/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.train.TrainActivityCollection;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainExePeriodCollection;
import com.kingdee.eas.hr.train.TrainExePeriodFactory;
import com.kingdee.eas.hr.train.TrainExePeriodInfo;
import com.kingdee.eas.hr.train.TrainPlanCategoryEnum;
import com.kingdee.eas.hr.train.app.AbstractTrainExePeriodControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainExePeriodControllerBean
extends AbstractTrainExePeriodControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainExePeriodControllerBean");
    private static final String TABLE_NAME = " T_HR_TrainExePeriod ";

    protected void _setExecuteState(Context ctx, boolean state, String id) throws BOSException {
        if (id == null) {
            return;
        }
        String sql = "UPDATE T_HR_TrainExePeriod SET FIsExeuted = ? WHERE FID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBoolean(1, state);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)id);
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException(e.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private TrainActivityCollection getPeriodCoursesForAct(Context ctx, String string) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("trainExePriod.id", (Object)string));
        viewInfo.setFilter(filterInfo);
        return TrainActivityFactory.getLocalInstance(ctx).getTrainActivityCollection(viewInfo);
    }

    private TrainExePeriodCollection getPeriodCourses(Context ctx, String string) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("planActivity.trainPlan.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("source.id", (Object)string));
        filterInfo.getFilterItems().add(new FilterItemInfo("planActivity.trainPlan.planCategory.category", (Object)TrainPlanCategoryEnum.MONTH));
        viewInfo.setFilter(filterInfo);
        return TrainExePeriodFactory.getLocalInstance(ctx).getTrainExePeriodCollection(viewInfo);
    }

    protected Map _deleteSource(Context ctx, Set sourceID, boolean flag) throws BOSException, EASBizException {
        TrainExePeriodCollection periodCollection = null;
        TrainActivityCollection periodCollectionForAct = null;
        TrainExePeriodInfo periodInfo = null;
        TrainExePeriodInfo periodInfo_exe = null;
        TrainActivityInfo actInfo = null;
        HashSet<DataBaseInfo> exe_set = null;
        String source_id = null;
        HashMap map = new HashMap();
        Iterator it = sourceID.iterator();
        while (it.hasNext()) {
            Iterator it1;
            exe_set = new HashSet<DataBaseInfo>();
            periodInfo = (TrainExePeriodInfo)it.next();
            String str = periodInfo.getId().toString();
            periodCollectionForAct = this.getPeriodCoursesForAct(ctx, str);
            if (periodCollectionForAct != null && periodCollectionForAct.size() > 0) {
                it1 = periodCollectionForAct.iterator();
                while (it1.hasNext()) {
                    actInfo = (TrainActivityInfo)it1.next();
                    exe_set.add(actInfo);
                }
                map.put(periodInfo.getId().toString(), exe_set);
            }
            if (!flag || (periodCollection = this.getPeriodCourses(ctx, source_id = periodInfo.getId().toString())) == null || periodCollection.size() <= 0) continue;
            it1 = periodCollection.iterator();
            while (it1.hasNext()) {
                periodInfo_exe = (TrainExePeriodInfo)it1.next();
                exe_set.add(periodInfo_exe);
            }
            map.put(periodInfo.getId().toString(), exe_set);
        }
        return map;
    }
}

