/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.IInstructorPhoto;
import com.kingdee.eas.hr.train.InstructorPhotoFactory;
import com.kingdee.eas.hr.train.InstructorPhotoInfo;
import com.kingdee.eas.hr.train.InstructorResumeFactory;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.TrainInstructorCollection;
import com.kingdee.eas.hr.train.TrainInstructorFactory;
import com.kingdee.eas.hr.train.TrainInstructorInfo;
import com.kingdee.eas.hr.train.TrainResourceException;
import com.kingdee.eas.hr.train.app.AbstractTrainInstructorControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;

public class TrainInstructorControllerBean
extends AbstractTrainInstructorControllerBean {
    private static final String IS_OUTER = "IsOuter";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainInstructorInfo)model), IS_OUTER);
        String instructorID = this.checkEmployeeDup(ctx, model);
        TrainInstructorInfo struInfo = (TrainInstructorInfo)model;
        struInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        this.handlePhoto(ctx, struInfo);
        if (instructorID == null) {
            return super._addnew(ctx, (IObjectValue)struInfo);
        }
        struInfo.setId(BOSUuid.read((String)instructorID));
        super._update(ctx, (IObjectPK)new ObjectUuidPK(instructorID), (IObjectValue)struInfo);
        return new ObjectUuidPK(instructorID);
    }

    private void handlePhoto(Context ctx, TrainInstructorInfo struInfo) throws BOSException, EASBizException {
        if (struInfo.isIsOuter()) {
            IInstructorPhoto iPhoto = InstructorPhotoFactory.getLocalInstance(ctx);
            byte[] photoData = struInfo.getPhotoData();
            if (photoData != null) {
                if (struInfo.getPhoto() == null) {
                    InstructorPhotoInfo photoInfo = new InstructorPhotoInfo();
                    photoInfo.setImageData(photoData);
                    IObjectPK pk = iPhoto.addnew(photoInfo);
                    photoInfo.setId(BOSUuid.read((String)pk.toString()));
                    struInfo.setPhoto(photoInfo);
                } else {
                    struInfo.getPhoto().setImageData(photoData);
                    iPhoto.delete((IObjectPK)new ObjectUuidPK(struInfo.getPhoto().getId()));
                    iPhoto.addnew(struInfo.getPhoto());
                }
            } else if ("true".equals(struInfo.getPhotoDeleteFlag()) && struInfo.getPhoto() != null) {
                iPhoto.delete((IObjectPK)new ObjectUuidPK(struInfo.getPhoto().getId()));
                struInfo.setPhoto(null);
            }
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainInstructorInfo)model), IS_OUTER);
        this.checkEmployeeDup(ctx, model);
        TrainInstructorInfo struInfo = (TrainInstructorInfo)model;
        struInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        this.handlePhoto(ctx, struInfo);
        super._addnew(ctx, pk, (IObjectValue)struInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        TrainInstructorInfo struInfo = (TrainInstructorInfo)model;
        struInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        this.handlePhoto(ctx, (TrainInstructorInfo)model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainInstructorInfo instructorInfo = (TrainInstructorInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)instructorInfo.getNumber(), CompareType.EQUALS));
        if (instructorInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)instructorInfo.getId(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, instructorInfo, "number") + instructorInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        return filter;
    }

    private String checkEmployeeDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TrainInstructorInfo instructorInfo = (TrainInstructorInfo)model;
        if (!instructorInfo.isIsOuter()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(IS_OUTER, (Object)0));
            filter.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)instructorInfo.getEmployee().getId().toString()));
            if (instructorInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)instructorInfo.getId().toString(), CompareType.NOTEQUALS));
            }
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.setFilter(filter);
            TrainInstructorCollection collection = TrainInstructorFactory.getLocalInstance(ctx).getTrainInstructorCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                return collection.get(0).getId().toString();
            }
        }
        return null;
    }

    private boolean setInstructorEnable(Context ctx, String instructorId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(instructorId);
        TrainInstructorInfo instructorInfo = TrainInstructorFactory.getLocalInstance(ctx).getTrainInstructorInfo((IObjectPK)pk);
        if (instructorInfo.isIsEnable()) {
            if (instructorInfo.isIsOuter()) {
                throw new TrainException(TrainException.OUTERINSTRUCTOR_ISENABLED);
            }
            throw new TrainException(TrainException.INNERINSTRUCTOR_ISENABLED);
        }
        instructorInfo.setIsEnable(true);
        this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)instructorInfo);
        return true;
    }

    private boolean setInstructorDisnable(Context ctx, String instructorID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(instructorID);
        TrainInstructorInfo instructorInfo = TrainInstructorFactory.getLocalInstance(ctx).getTrainInstructorInfo((IObjectPK)pk);
        if (!instructorInfo.isIsEnable()) {
            if (instructorInfo.isIsOuter()) {
                throw new TrainException(TrainException.OUTERINSTRUCTOR_ISDISABLED);
            }
            throw new TrainException(TrainException.INNERINSTRUCTOR_ISDISABLED);
        }
        instructorInfo.setIsEnable(false);
        this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)instructorInfo);
        return true;
    }

    protected boolean _setEnabled(Context ctx, ArrayList instructorIds, boolean flag) throws BOSException, EASBizException {
        if (instructorIds == null || instructorIds.size() <= 0) {
            return false;
        }
        int size = instructorIds.size();
        for (int i = 0; i < size; ++i) {
            if (!(flag ? !this.setInstructorEnable(ctx, instructorIds.get(i).toString()) : !this.setInstructorDisnable(ctx, instructorIds.get(i).toString()))) continue;
            return false;
        }
        return true;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        String sql = "select * from T_HR_CHANNELCOURSE where FInstructorID = '" + pk.toString() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet.size() > 0) {
            throw new TrainResourceException(TrainResourceException.CAN_NOT_DEL_INSTRUCTOR);
        }
        this.deleteInstructorResume(ctx, pk);
        if (ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()))) {
            throw new TrainResourceException(TrainResourceException.CAN_NOT_DEL_INSTRUCTOR);
        }
        InstructorPhotoInfo photoInfo = this.getPhoto(ctx, pk);
        CodingRuleServerHelper.recycleNumber(ctx, (CoreBaseInfo)this.getTrainInstructorInfo(ctx, pk), IS_OUTER);
        super._delete(ctx, pk);
        if (photoInfo != null) {
            InstructorPhotoFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(photoInfo.getId()));
        }
    }

    private void deleteInstructorResume(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("instructor.id", (Object)pk.toString()));
        InstructorResumeFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    private InstructorPhotoInfo getPhoto(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("photo.id"));
        TrainInstructorInfo instructorInfo = this.getTrainInstructorInfo(ctx, pk, sic);
        return instructorInfo.getPhoto();
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainInstructorInfo info = (TrainInstructorInfo)model;
        if (!info.isIsOuter() && info.getEmployee() != null) {
            info.setName(info.getEmployee().getName());
        }
        return super._submit(ctx, model);
    }

    protected IObjectValue _isReAppointment(Context ctx, IObjectValue personInfo) throws BOSException, EASBizException {
        PersonInfo info = (PersonInfo)personInfo;
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(IS_OUTER, (Object)0));
        fi.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)info.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("description"));
        viewInfo.setFilter(fi);
        TrainInstructorCollection collection = TrainInstructorFactory.getLocalInstance(ctx).getTrainInstructorCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }
}

