/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.app.AbstractTrainPlanCalendarFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainPlanCalendarFacadeControllerBean
extends AbstractTrainPlanCalendarFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainPlanCalendarFacadeControllerBean");
    private String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private SimpleDateFormat monthFormater = new SimpleDateFormat("M.d");
    private SimpleDateFormat yearFormater = new SimpleDateFormat("yyyy.M.d");
    private static final int SIZE = 22;

    protected HashMap _getTrainPlanCalendar(Context ctx, Set idSet, int year) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT FPlanActivityID, FStartDate, FEndDate FROM T_HR_TrainExePeriod WHERE FPlanActivityID IN ( ");
        boolean i = false;
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            if (i) {
                sql.append(",");
            }
            sql.append("'");
            sql.append(iter.next().toString());
            sql.append("'");
            i = true;
        }
        sql.append(" ) ");
        sql.append(" and ");
        sql.append(" YEAR(FStartDate) = ");
        sql.append(year);
        sql.append(" ORDER BY FStartDate ASC");
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashMap map = new HashMap();
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            ResultSet resultSet = pstmt.executeQuery();
            String id = null;
            HashMap<String, Object> subMap = null;
            Date startDate = null;
            Date endDate = null;
            Calendar calendar = Calendar.getInstance();
            int startMonth = 0;
            int startDay = 0;
            int startYear = 0;
            int endDay = 0;
            int endMonth = 0;
            int endYear = 0;
            String value = null;
            StringBuffer sb = null;
            Integer periods = null;
            while (resultSet.next()) {
                id = resultSet.getString("FPlanActivityID");
                subMap = (HashMap<String, Object>)map.get(id);
                if (subMap == null) {
                    subMap = new HashMap<String, Object>();
                    map.put(id, subMap);
                }
                if ((periods = (Integer)subMap.get("Count")) == null) {
                    periods = 1;
                    subMap.put("Count", periods);
                } else {
                    periods = periods + 1;
                    subMap.put("Count", periods);
                }
                startDate = resultSet.getDate("FStartDate");
                endDate = resultSet.getDate("FEndDate");
                calendar.setTime(startDate);
                startMonth = calendar.get(2);
                startDay = calendar.get(5);
                startYear = calendar.get(1);
                calendar.setTime(endDate);
                endDay = calendar.get(5);
                endMonth = calendar.get(2);
                endYear = calendar.get(1);
                value = (String)subMap.get(this.months[startMonth]);
                sb = new StringBuffer();
                if (value != null) {
                    sb.append(value);
                    int p = sb.lastIndexOf("\n");
                    ++p;
                    if (endYear != startYear) {
                        if (22 - (sb.length() - p) < 22) {
                            sb.append("\n");
                        } else {
                            sb.append(",");
                        }
                        sb.append(this.yearFormater.format(startDate));
                        sb.append("-");
                        sb.append(this.yearFormater.format(endDate));
                    } else if (endMonth != startMonth) {
                        if (22 - (sb.length() - p) < 12) {
                            sb.append("\n");
                        } else {
                            sb.append(",");
                        }
                        sb.append(this.monthFormater.format(startDate));
                        sb.append("-");
                        sb.append(this.monthFormater.format(endDate));
                    } else {
                        if (22 - (sb.length() - p) < 6) {
                            sb.append("\n");
                        } else {
                            sb.append(",");
                        }
                        sb.append(startDay);
                        sb.append("-");
                        sb.append(endDay);
                    }
                } else if (endYear != startYear) {
                    sb.append(this.yearFormater.format(startDate));
                    sb.append("-");
                    sb.append(this.yearFormater.format(endDate));
                } else if (endMonth != startMonth) {
                    sb.append(this.monthFormater.format(startDate));
                    sb.append("-");
                    sb.append(this.monthFormater.format(endDate));
                } else {
                    sb.append(startDay);
                    sb.append("-");
                    sb.append(endDay);
                }
                subMap.put(this.months[startMonth], sb.toString());
                Long days = (Long)subMap.get("days");
                if (days == null) {
                    days = this.getDaysOfTwoDate(startDate, endDate);
                    subMap.put("days", days);
                    continue;
                }
                days = days + this.getDaysOfTwoDate(startDate, endDate);
                subMap.put("days", days);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    private long getDaysOfTwoDate(java.util.Date begin, java.util.Date end) {
        long beginTime = begin.getTime();
        long endTime = end.getTime();
        return Math.round(0.5 + (double)(endTime - beginTime) / 8.64E7);
    }
}

