/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.IPersonTechnicalPost;
import com.kingdee.eas.hr.emp.PersonTechnicalPostCollection;
import com.kingdee.eas.hr.emp.PersonTechnicalPostFactory;
import com.kingdee.eas.hr.emp.PersonTechnicalPostInfo;
import com.kingdee.eas.hr.train.TrainStudentHelperInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainRecordFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainRecordFacadeControllerBean
extends AbstractTrainRecordFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainRecordFacadeControllerBean");
    IMetaDataPK personQueryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainStudentPersonInfoQuery");

    protected List _getStudent(Context ctx, Map params) throws BOSException, EASBizException {
        Object activity = params.get("activity");
        Object course = params.get("course");
        Object item = params.get("item");
        Integer activityState = (Integer)params.get("activityState");
        Integer courseState = (Integer)params.get("courseState");
        Integer itemState = (Integer)params.get("itemState");
        if (activity == null && course == null && item == null) {
            return null;
        }
        if (activity != null && activityState == null || course != null && courseState == null || item != null && itemState == null) {
            return null;
        }
        String pass = "10";
        String noPass = "20";
        StringBuffer sql = new StringBuffer();
        sql.append(" select record1.FEmployeeID as personId,activity.fname_l2 as activityName ");
        sql.append(",course.fname_l2 as courseName,item.fname_l2 as itemName , ");
        sql.append(" person.fname_l2 as pName, person.fNumber as pNumber, person.fGender as pGender ,");
        sql.append(" person.FEMail as pEmail , person.FCell as pCell,person.FOfficePhone as pOfficePhone");
        sql.append(" from T_HR_TrainCourseRecord record1 ");
        sql.append(" left outer join t_hr_trainActivity as activity on activity.fid = record1.FTrainActivityID ");
        sql.append(" left outer join t_hr_traincourse as course on course.fid = record1.FTrainCourseID ");
        sql.append(" left outer join t_hr_trainItem as item on item.fid = record1.FTrainItemID ");
        sql.append(" left outer join t_bd_person as person on person.fid = record1.FEmployeeID ");
        sql.append(" where 1 = 1 ");
        if (course != null && item == null) {
            if (String.valueOf(courseState).equals(noPass)) {
                sql.append(" and ");
                sql.append(" not exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainCourseID = record1.FTrainCourseID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FIsPassed =").append(pass);
                sql.append(" ) ");
            } else {
                sql.append(" and ");
                sql.append(" exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainCourseID = record1.FTrainCourseID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FIsPassed =").append(pass);
                sql.append(" ) ");
            }
        } else if (course == null && item != null) {
            if (String.valueOf(itemState).equals(noPass)) {
                sql.append(" and ");
                sql.append(" not exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainItemID = record1.FTrainItemID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FActIsPassed =").append(pass);
                sql.append(" ) ");
            } else {
                sql.append(" and ");
                sql.append(" exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainItemID = record1.FTrainItemID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FActIsPassed =").append(pass);
                sql.append(" ) ");
            }
        } else if (course != null && item != null) {
            if (String.valueOf(courseState).equals(pass) && String.valueOf(itemState).equals(noPass)) {
                sql.append(" and ");
                sql.append(" exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainCourseID = record1.FTrainCourseID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FIsPassed =").append(pass);
                sql.append(" ) ");
                sql.append(" and ");
                sql.append(" not exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainItemID = record1.FTrainItemID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FActIsPassed =").append(pass);
                sql.append(" ) ");
            } else if (String.valueOf(courseState).equals(noPass) && String.valueOf(itemState).equals(pass)) {
                sql.append(" and ");
                sql.append(" not exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainCourseID = record1.FTrainCourseID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FIsPassed =").append(pass);
                sql.append(" ) ");
                sql.append(" and ");
                sql.append(" exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainItemID = record1.FTrainItemID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FActIsPassed =").append(pass);
                sql.append(" ) ");
            } else if (String.valueOf(courseState).equals(noPass) && String.valueOf(itemState).equals(noPass)) {
                sql.append(" and ");
                sql.append(" not exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainCourseID = record1.FTrainCourseID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FIsPassed =").append(pass);
                sql.append(" ) ");
                sql.append(" and ");
                sql.append(" not exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainItemID = record1.FTrainItemID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FActIsPassed =").append(pass);
                sql.append(" ) ");
            } else {
                sql.append(" and ");
                sql.append(" exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainCourseID = record1.FTrainCourseID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FIsPassed =").append(pass);
                sql.append(" ) ");
                sql.append(" and ");
                sql.append(" exists( select * from T_HR_TrainCourseRecord record3 ");
                sql.append(" where record3.FTrainItemID = record1.FTrainItemID ");
                sql.append(" and record3.FEmployeeID = record1.FEmployeeID ");
                sql.append(" and record3.FActIsPassed =").append(pass);
                sql.append(" ) ");
            }
        }
        if (activity != null) {
            sql.append(" and record1.FTrainActivityID = '").append(activity.toString()).append("'");
            sql.append(" and record1.FActIsPassed =").append(activityState);
        }
        if (course != null) {
            sql.append(" and record1.FTrainCourseID = '").append(course.toString()).append("'");
        }
        if (item != null) {
            sql.append(" and record1.FTrainItemID = '").append(item.toString()).append("'");
        }
        return this.queryPersonInfo(ctx, sql.toString());
    }

    private List queryPersonInfo(Context ctx, String sql) throws BOSException, EASBizException {
        IRowSet trainRecordRow = DbUtil.executeQuery((Context)ctx, (String)sql);
        LinkedHashMap<String, TrainStudentHelperInfo> map = new LinkedHashMap<String, TrainStudentHelperInfo>();
        String male = ResourceBase.getString((String)"com.kingdee.eas.hr.train.TrainResource.male", (Locale)ctx.getLocale());
        String female = ResourceBase.getString((String)"com.kingdee.eas.hr.train.TrainResource.female", (Locale)ctx.getLocale());
        try {
            while (trainRecordRow.next()) {
                if (trainRecordRow.getString("personId") == null || map.containsKey(trainRecordRow.getString("personId"))) continue;
                TrainStudentHelperInfo hInfo = new TrainStudentHelperInfo();
                hInfo.setId(trainRecordRow.getString("personId"));
                hInfo.setActivity(trainRecordRow.getString("activityName"));
                hInfo.setCourse(trainRecordRow.getString("courseName"));
                hInfo.setItem(trainRecordRow.getString("itemName"));
                hInfo.setName(trainRecordRow.getString("pName"));
                hInfo.setNumber(trainRecordRow.getString("pNumber"));
                hInfo.setEmail(trainRecordRow.getString("pEmail"));
                hInfo.setCell(trainRecordRow.getString("pCell"));
                hInfo.setOfficePhone(trainRecordRow.getString("pOfficePhone"));
                if (trainRecordRow.getInt("pGender") == 1) {
                    hInfo.setGender(male);
                } else {
                    hInfo.setGender(female);
                }
                map.put(trainRecordRow.getString("personId"), hInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        if (map.size() == 0) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", map.keySet(), CompareType.INCLUDE));
        evi.setFilter(fi);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.personQueryPK);
        exec.setObjectView(evi);
        exec.option().isAutoTranslateEnum = true;
        IRowSet row = exec.executeQuery();
        try {
            while (row.next()) {
                TrainStudentHelperInfo hInfo = (TrainStudentHelperInfo)map.get(row.getString("id"));
                if (hInfo == null) continue;
                hInfo.setJob(row.getString("job.name"));
                hInfo.setDegree(row.getString("degree.name"));
                hInfo.setJobGrade(row.getString("jobGrade.name"));
                hInfo.setTechnicalPost(row.getString("technicalPost.name"));
                hInfo.setOrgUnit(row.getString("orgUnit.displayName"));
                hInfo.setPosition(row.getString("position.name"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        ArrayList list = new ArrayList();
        if (map.size() > 0) {
            list.addAll(map.values());
        }
        return list;
    }

    protected IObjectCollection _handleTechnicalPost(Context ctx, IObjectPK trainActivityId, PersonTechnicalPostCollection submitPosts, PersonTechnicalPostCollection deletePosts, Collection clearPostIds) throws BOSException, EASBizException {
        PersonTechnicalPostCollection cannotDeletePosts = this.getCannotDeletePosts(ctx, deletePosts);
        Collection deletePostIds = this.getDeletePostIds(deletePosts, cannotDeletePosts);
        this.deleteTechPost(ctx, deletePostIds);
        this.setHighTechnical(ctx, submitPosts);
        IObjectPK[] submitPostIds = this.addAndUpdate(ctx, submitPosts);
        HashSet deleteIds = new HashSet();
        if (deletePostIds != null && !deletePostIds.isEmpty()) {
            deleteIds.addAll(deletePostIds);
        }
        if (clearPostIds != null && !clearPostIds.isEmpty()) {
            deleteIds.addAll(clearPostIds);
        }
        if (!deleteIds.isEmpty()) {
            this.clearTrainRecordTechnicalPost(ctx, deleteIds);
        }
        IPersonTechnicalPost iPersonTechnicalPost = PersonTechnicalPostFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> personPostMap = new HashMap<String, String>();
        if (submitPostIds != null && submitPostIds.length > 0) {
            HashSet<String> ids = new HashSet<String>(submitPostIds.length);
            int length = submitPostIds.length;
            for (int i = 0; i < length; ++i) {
                ids.add(submitPostIds[i].toString());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
            submitPosts = iPersonTechnicalPost.getPersonTechnicalPostCollection(viewInfo);
            PersonTechnicalPostInfo postInfo = null;
            int size = submitPosts.size();
            for (int i = 0; i < size; ++i) {
                postInfo = submitPosts.get(i);
                if (postInfo == null || postInfo.getId() == null || postInfo.getPerson() == null) continue;
                personPostMap.put(postInfo.getPerson().getId().toString(), postInfo.getId().toString());
            }
            this.updateTrainRecordTechnicalPost(ctx, trainActivityId.toString(), personPostMap);
        }
        return cannotDeletePosts;
    }

    private PersonTechnicalPostCollection getCannotDeletePosts(Context ctx, PersonTechnicalPostCollection deletePosts) throws BOSException {
        if (deletePosts == null || deletePosts.isEmpty()) {
            return null;
        }
        HashMap<String, PersonTechnicalPostInfo> personMap = new HashMap<String, PersonTechnicalPostInfo>();
        HashSet<BOSUuid> postIds = new HashSet<BOSUuid>();
        PersonTechnicalPostInfo technicalPostInfo = null;
        int size = deletePosts.size();
        for (int i = 0; i < size; ++i) {
            technicalPostInfo = deletePosts.get(i);
            if (technicalPostInfo.getId() == null || !technicalPostInfo.isIsHighTechnical()) continue;
            personMap.put(technicalPostInfo.getPerson().getId().toString(), technicalPostInfo);
            postIds.add(technicalPostInfo.getId());
        }
        PersonTechnicalPostCollection cannotDeletePosts = null;
        if (!postIds.isEmpty()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personMap.keySet(), CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", postIds, CompareType.NOTINCLUDE));
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
            IPersonTechnicalPost iPersonTechnicalPost = PersonTechnicalPostFactory.getLocalInstance((Context)ctx);
            PersonTechnicalPostCollection collection = iPersonTechnicalPost.getPersonTechnicalPostCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                cannotDeletePosts = new PersonTechnicalPostCollection();
                int size2 = collection.size();
                for (int i = 0; i < size2; ++i) {
                    technicalPostInfo = collection.get(i);
                    cannotDeletePosts.add((PersonTechnicalPostInfo)personMap.get(technicalPostInfo.getPerson().getId().toString()));
                }
            }
        }
        return cannotDeletePosts;
    }

    private Collection getDeletePostIds(PersonTechnicalPostCollection deletePosts, PersonTechnicalPostCollection cannotDeletePosts) {
        if (deletePosts == null || deletePosts.isEmpty()) {
            return null;
        }
        PersonTechnicalPostInfo postInfo = null;
        if (cannotDeletePosts != null && cannotDeletePosts.size() > 0) {
            for (int i = cannotDeletePosts.size() - 1; i >= 0; --i) {
                postInfo = cannotDeletePosts.get(i);
                deletePosts.remove(postInfo);
            }
        }
        HashSet<String> deletePostIds = null;
        if (deletePosts != null && deletePosts.size() > 0) {
            deletePostIds = new HashSet<String>();
            int size = deletePosts.size();
            for (int i = 0; i < size; ++i) {
                postInfo = deletePosts.get(i);
                if (postInfo.getId() == null) continue;
                deletePostIds.add(postInfo.getId().toString());
            }
        }
        return deletePostIds;
    }

    private void setHighTechnical(Context ctx, PersonTechnicalPostCollection submitPosts) throws BOSException {
        IPersonTechnicalPost iPersonTechnicalPost = PersonTechnicalPostFactory.getLocalInstance((Context)ctx);
        if (submitPosts != null && submitPosts.size() > 0) {
            PersonTechnicalPostInfo technicalPostInfo = null;
            HashMap<String, PersonTechnicalPostInfo> map = new HashMap<String, PersonTechnicalPostInfo>();
            HashSet<String> ids = new HashSet<String>();
            int size = submitPosts.size();
            for (int i = 0; i < size; ++i) {
                technicalPostInfo = submitPosts.get(i);
                if (technicalPostInfo.isIsHighTechnical()) continue;
                map.put(technicalPostInfo.getPerson().getId().toString(), technicalPostInfo);
                if (technicalPostInfo.getId() == null) continue;
                ids.add(technicalPostInfo.getId().toString());
            }
            if (map.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("person.id", map.keySet(), CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("isHighTechnical", (Object)Boolean.TRUE));
                if (ids.size() > 0) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.NOTINCLUDE));
                }
                viewInfo.setFilter(filterInfo);
                viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
                PersonTechnicalPostCollection collection = iPersonTechnicalPost.getPersonTechnicalPostCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    int size2 = collection.size();
                    for (int i = 0; i < size2; ++i) {
                        technicalPostInfo = collection.get(i);
                        map.remove(technicalPostInfo.getPerson().getId().toString());
                    }
                }
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    technicalPostInfo = (PersonTechnicalPostInfo)map.get(it.next());
                    technicalPostInfo.setIsHighTechnical(true);
                }
            }
        }
    }

    private void clearTrainRecordTechnicalPost(Context ctx, Collection postIds) throws BOSException {
        if (postIds.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set FActPostID = ? ");
        sql.append(" where FActPostID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Iterator it = postIds.iterator();
            String postId = null;
            while (it.hasNext()) {
                postId = (String)it.next();
                pstmt.setString(1, null);
                pstmt.setString(2, postId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateTrainRecordTechnicalPost(Context ctx, String trainActivityId, Map personPostMap) throws BOSException {
        if (personPostMap.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_TrainCourseRecord set FActPostID = ? ");
        sql.append(" where FTrainActivityID = ? and  FEmployeeID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Iterator it = personPostMap.entrySet().iterator();
            String personId = null;
            String postId = null;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                personId = (String)entry.getKey();
                postId = (String)personPostMap.get(personId);
                pstmt.setString(1, postId);
                pstmt.setString(2, trainActivityId);
                pstmt.setString(3, personId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void deleteTechPost(Context ctx, Collection deletePostIds) throws BOSException, EASBizException {
        if (deletePostIds == null || deletePostIds.isEmpty()) {
            return;
        }
        IPersonTechnicalPost iPersonTechnicalPost = PersonTechnicalPostFactory.getLocalInstance((Context)ctx);
        Iterator it = deletePostIds.iterator();
        while (it.hasNext()) {
            iPersonTechnicalPost.delete((IObjectPK)new ObjectUuidPK(it.next().toString()));
        }
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonTechnicalPostCollection technicalPostCollection) throws EASBizException, BOSException {
        ObjectUuidPK[] newList = null;
        if (technicalPostCollection != null) {
            int i;
            IPersonTechnicalPost iPersonTechnicalPost = PersonTechnicalPostFactory.getLocalInstance((Context)ctx);
            this.handlePostIsEmploy(ctx, technicalPostCollection);
            ArrayList<Object> idList = new ArrayList<Object>();
            ObjectUuidPK pk = null;
            for (i = 0; i < technicalPostCollection.size(); ++i) {
                if (technicalPostCollection.get(i).getId() == null) {
                    idList.add(iPersonTechnicalPost.addnew((CoreBaseInfo)technicalPostCollection.get(i)));
                    continue;
                }
                pk = new ObjectUuidPK(technicalPostCollection.get(i).getId());
                iPersonTechnicalPost.update((IObjectPK)pk, (CoreBaseInfo)technicalPostCollection.get(i));
                idList.add(pk);
            }
            newList = new ObjectUuidPK[idList.size()];
            for (i = 0; i < idList.size(); ++i) {
                newList[i] = (IObjectPK)idList.get(i);
            }
        }
        return newList;
    }

    private void handlePostIsEmploy(Context ctx, PersonTechnicalPostCollection technicalPostCollection) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        PersonTechnicalPostInfo technicalPostInfo = null;
        IPersonTechnicalPost iPersonTechnicalPost = PersonTechnicalPostFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < technicalPostCollection.size(); ++i) {
            technicalPostInfo = technicalPostCollection.get(i);
            if (technicalPostInfo.getId() == null || technicalPostInfo.isIsEmploy()) continue;
            ids.add(technicalPostCollection.get(i).getId().toString());
        }
        if (ids.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            PersonTechnicalPostCollection collection = iPersonTechnicalPost.getPersonTechnicalPostCollection(viewInfo);
            for (int i = collection.size() - 1; i >= 0; --i) {
                technicalPostInfo = collection.get(i);
                if (technicalPostInfo.isIsEmploy()) continue;
                collection.remove(technicalPostInfo);
            }
            this.updatePersonEmployEmpty(ctx, collection);
        }
    }

    private void updatePersonEmployEmpty(Context ctx, PersonTechnicalPostCollection collection) throws BOSException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update t_bd_person set FEmployTechPostID = ? ");
        sql.append(" where fid = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            PersonTechnicalPostInfo technicalPostInfo = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                technicalPostInfo = collection.get(i);
                pstmt.setString(1, null);
                pstmt.setString(2, technicalPostInfo.getPerson().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

