/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainSignerCollection;
import com.kingdee.eas.hr.train.TrainSignerFactory;
import com.kingdee.eas.hr.train.TrainSignupFormEntryCollection;
import com.kingdee.eas.hr.train.TrainSignupFormException;
import com.kingdee.eas.hr.train.TrainSignupFormFactory;
import com.kingdee.eas.hr.train.TrainSignupFormInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainSignupFormControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;

public class TrainSignupFormControllerBean
extends AbstractTrainSignupFormControllerBean {
    private static final String IS_BATCH = "IsBatch";

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TrainSignupFormInfo info = this.getTrainSignupFormInfo(ctx, pk);
        CodingRuleServerHelper.recycleNumber(ctx, (CoreBaseInfo)info, (OrgUnitInfo)TrainUtilsServer.getGroupOrg(ctx), IS_BATCH);
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainSignupFormInfo)model), IS_BATCH, (OrgUnitInfo)TrainUtilsServer.getGroupOrg(ctx));
        this._checkNumberDup(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainSignupFormInfo)model), IS_BATCH, (OrgUnitInfo)TrainUtilsServer.getGroupOrg(ctx));
        this._checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainSignupFormInfo info = (TrainSignupFormInfo)model;
        String number = info.getNumber();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        String cuId = null;
        cuId = info.getCU() == null ? super.getCU(ctx, (ObjectBaseInfo)info).getId().toString() : info.getCU().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId, CompareType.EQUALS));
        if (TrainSignupFormFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainSignupFormException(TrainSignupFormException.NUMBER_NOT_DUP);
        }
    }

    protected void _setAuditingState(Context ctx, BOSUuid id, BOSUuid auditorID) throws BOSException, EASBizException {
        this.updateBillAuditor(ctx, id, auditorID);
        this.updateBillState(ctx, id, TrainAuditStateEnum.AUDITING);
    }

    protected void _setPassState(Context ctx, BOSUuid id, BOSUuid auditorID) throws BOSException, EASBizException {
        this.updateBillAuditor(ctx, id, auditorID);
        this.updateBillState(ctx, id, TrainAuditStateEnum.PASS);
    }

    private void insertIntoTrainSigner(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        StringBuffer sb;
        if (id == null) {
            return;
        }
        TrainSignupFormInfo info = this.getTrainSignupFormInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        TrainSignupFormEntryCollection collection = info.getEntrys();
        if (info.getTrainAct().getId() == null) {
            throw new TrainSignupFormException(TrainSignupFormException.TRAINACTIVITY_NOT_NULL);
        }
        if (collection == null || collection.size() == 0) {
            return;
        }
        HashSet<String> personSet = new HashSet<String>();
        HashSet<String> courseSet = new HashSet<String>();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            personSet.add(collection.get(i).getAttendee().getId().toString());
            courseSet.add(collection.get(i).getCourse().getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainAct.id", (Object)info.getTrainAct().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", personSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("Course.id", courseSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        TrainSignerCollection signerCollection = TrainSignerFactory.getLocalInstance(ctx).getTrainSignerCollection(viewInfo);
        HashSet<String> hasSet = new HashSet<String>();
        if (signerCollection != null && signerCollection.size() > 0) {
            int n2 = signerCollection.size();
            for (int i = 0; i < n2; ++i) {
                sb = new StringBuffer();
                sb.append(signerCollection.get(i).getTrainAct().getId().toString());
                sb.append(signerCollection.get(i).getCourse().getId().toString());
                sb.append(signerCollection.get(i).getEmployee().getId().toString());
                hasSet.add(sb.toString());
            }
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "INSERT INTO T_HR_TrainSigner (FID, FEmployeeID, FCourseID, FTrainActID) VALUES (?,?,?,?)";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            int count = 0;
            int n3 = collection.size();
            for (int i = 0; i < n3; ++i) {
                sb = new StringBuffer();
                sb.append(info.getTrainAct().getId().toString());
                sb.append(collection.get(i).getCourse().getId().toString());
                sb.append(collection.get(i).getAttendee().getId().toString());
                if (hasSet.contains(sb.toString())) continue;
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)collection.get(i).getAttendee().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)collection.get(i).getCourse().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getTrainAct().getId().toString());
                pstmt.addBatch();
                ++count;
            }
            if (count > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public SelectorItemCollection getTrainSignupFormSelectors() {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("TrainActivity.id"));
        return selectorItemCollection;
    }

    protected void _setUnpassState(Context ctx, BOSUuid id, BOSUuid auditorID) throws BOSException, EASBizException {
        this.updateBillAuditor(ctx, id, auditorID);
        this.updateBillState(ctx, id, TrainAuditStateEnum.UNPASS);
    }

    private void updateBillAuditor(Context ctx, BOSUuid id, BOSUuid auditorID) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_HR_TrainSignupForm SET FAuditorID = ? WHERE FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            if (auditorID != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)auditorID.toString());
            } else {
                pstmt.setString(1, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)id.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateBillState(Context ctx, BOSUuid id, TrainAuditStateEnum pass) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_HR_TrainSignupForm SET FAuditState = ? WHERE FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, pass.getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)id.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected IObjectPK _submit2(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected IObjectPK _submit3(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected boolean _canSignup(Context ctx, String activityID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)activityID)) {
            return false;
        }
        Date date = new Date();
        date = DateTimeUtils.truncateDate((Date)date);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)activityID));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)30));
        filterInfo.getFilterItems().add(new FilterItemInfo("canSignUp", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("signStartDate", (Object)date, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("signEndDate", (Object)date, CompareType.GREATER_EQUALS));
        return TrainActivityFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    protected void _insertToSignUpForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.insertIntoTrainSigner(ctx, id);
    }
}

