/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.ITrainStudent;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentCourseCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseInfo;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.TrainStudentInfo;
import com.kingdee.eas.hr.train.TrainStudentTypeEnum;
import com.kingdee.eas.hr.train.app.AbstractTrainStudentCourseControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainStudentCourseControllerBean
extends AbstractTrainStudentCourseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainStudentCourseControllerBean");
    private static String resourcePath = "com.kingdee.eas.hr.train.TrainActivityResource";

    protected Map _submitCategory(Context ctx, IObjectCollection studentCourseCollection) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sql = "INSERT INTO T_HR_TrainStudentCourse (FID, FControlUnitID, FTrainActCourseID, FPersonID, FType) VALUES (?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            String id = null;
            TrainStudentCourseInfo info = null;
            int size = studentCourseCollection.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainStudentCourseInfo)studentCourseCollection.getObject(i);
                id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getTrainActCourse().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                pstmt.setInt(5, info.getType().getValue());
                pstmt.addBatch();
                map.put(info.getPerson().getId().toString(), id);
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "INSERT INTO T_HR_TrainStudent (FID, FControlUnitID, FTrainActivityID, FPersonID, FType) VALUES (?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql2);
            String trainActivityId = null;
            TrainStudentCourseInfo info2 = null;
            HashSet<String> idSet = new HashSet<String>();
            int size2 = studentCourseCollection.size();
            for (int i = 0; i < size2; ++i) {
                info2 = (TrainStudentCourseInfo)studentCourseCollection.getObject(i);
                idSet.add(info2.getPerson().getId().toString());
                trainActivityId = info2.getTrainActCourse().getTrainActivity().getId().toString();
            }
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainStudentCourseCountQuery");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("Person.id", idSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityId));
            evi.setFilter(fi);
            exec.setObjectView(evi);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)exec.getSQL());
            String studentId = null;
            int trainActCourseCount = this.getTrainActCourseCount(ctx, trainActivityId);
            while (rowSet.next()) {
                if (rowSet.getInt("count") != trainActCourseCount) continue;
                studentId = BOSUuid.create((BOSObjectType)new TrainStudentInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)studentId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)rowSet.getString("trainActivity.id"));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)rowSet.getString("Person.id"));
                pstmt.setInt(5, info.getType().getValue());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    private int getTrainActCourseCount(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(fi);
        TrainActCourseCollection coll = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(evi);
        if (coll == null) {
            return 0;
        }
        return coll.size();
    }

    protected void _delete(Context ctx, String trainActCourseId, String trainActivityId, Set idSet) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseId));
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)idSet, CompareType.INCLUDE));
        this.delete(ctx, fi);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)idSet, CompareType.INCLUDE));
        ITrainStudent trainStudent = TrainStudentFactory.getLocalInstance(ctx);
        trainStudent.delete(filterInfo);
    }

    protected void _submitCategory(Context ctx, Map typeMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE T_HR_TrainStudentCourse SET FType = ? WHERE FID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            Set entrySet = typeMap.entrySet();
            for (Map.Entry entry : entrySet) {
                if (entry.getValue() == null) continue;
                pstmt.setInt(1, ((TrainStudentTypeEnum)((Object)entry.getValue())).getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)entry.getKey().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected Map _submitPerson(Context ctx, IObjectCollection studentCourseCollection) throws BOSException, EASBizException {
        Map map = new HashMap();
        TrainStudentCourseCollection studentCol_new = new TrainStudentCourseCollection();
        TrainStudentCourseCollection studentCol_old = new TrainStudentCourseCollection();
        TrainStudentCourseInfo info = null;
        int size = studentCourseCollection.size();
        for (int i = 0; i < size; ++i) {
            info = (TrainStudentCourseInfo)studentCourseCollection.getObject(i);
            if (info.getId() == null) {
                studentCol_new.add(info);
                continue;
            }
            studentCol_old.add(info);
        }
        if (studentCol_old.size() > 0) {
            this.updateTrainStudentCourse(ctx, studentCol_old);
            if (studentCol_new.size() == 0) {
                return null;
            }
        }
        if (studentCol_new.size() > 0) {
            map = this.createTrainStudentCourse(ctx, studentCol_new);
        }
        return map;
    }

    private Map createTrainStudentCourse(Context ctx, TrainStudentCourseCollection studentCol_new) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_HR_TrainStudentCourse (FID, FControlUnitID, FTrainActCourseID, FPersonID, FType, FOrgStudentID, FPosiStudentID) VALUES (?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            String id = null;
            TrainStudentCourseInfo info = null;
            String trainActivityId = null;
            int size = studentCol_new.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainStudentCourseInfo)studentCol_new.getObject(i);
                id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getTrainActCourse().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                pstmt.setInt(5, info.getType().getValue());
                if (info.getOrgStudent() == null) {
                    pstmt.setString(6, null);
                } else {
                    pstmt.setString(6, info.getOrgStudent().getId().toString());
                }
                if (info.getPosiStudent() == null) {
                    pstmt.setString(7, null);
                } else {
                    pstmt.setString(7, info.getPosiStudent().getId().toString());
                }
                pstmt.addBatch();
                map.put(info.getPerson().getId().toString(), id);
                if (trainActivityId != null) continue;
                trainActivityId = info.getTrainActCourse().getTrainActivity().getId().toString();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "UPDATE T_HR_TrainStudentCourse SET FOrgStudentID = ?, FPosiStudentID = ? WHERE FPersonID = ? AND FTrainActCourseID IN (SELECT FID FROM T_HR_TrainActCourse WHERE FTrainActivityID= ?)";
            pstmt = conn.prepareStatement(sql2);
            int size2 = studentCol_new.size();
            for (int i = 0; i < size2; ++i) {
                info = (TrainStudentCourseInfo)studentCol_new.getObject(i);
                pstmt.setString(1, info.getOrgStudent().getId().toString());
                pstmt.setString(2, info.getPosiStudent().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getTrainActCourse().getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            String sql3 = "INSERT INTO T_HR_TrainStudent (FID, FControlUnitID, FTrainActivityID, FPersonID, FType, FOrgStudentID, FPosiStudentID) VALUES (?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql3);
            HashSet<String> idSet = new HashSet<String>();
            int size3 = studentCol_new.size();
            for (int i = 0; i < size3; ++i) {
                info = (TrainStudentCourseInfo)studentCol_new.getObject(i);
                idSet.add(info.getPerson().getId().toString());
                id = info.getTrainActCourse().getTrainActivity().getId().toString();
            }
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainStudentCourseCountQuery");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            EntityViewInfo evi1 = new EntityViewInfo();
            FilterInfo fi1 = new FilterInfo();
            fi1.getFilterItems().add(new FilterItemInfo("Person.id", idSet, CompareType.INCLUDE));
            fi1.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)id));
            evi1.setFilter(fi1);
            exec.setObjectView(evi1);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)exec.getSQL());
            String studentId = null;
            int trainActCourseCount = this.getTrainActCourseCount(ctx, id);
            while (rowSet.next()) {
                if (rowSet.getInt("count") != trainActCourseCount) continue;
                studentId = BOSUuid.create((BOSObjectType)new TrainStudentInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)studentId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)rowSet.getString("trainActivity.id"));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)rowSet.getString("Person.id"));
                pstmt.setInt(5, info.getType().getValue());
                pstmt.setString(6, info.getOrgStudent().getId().toString());
                pstmt.setString(7, info.getPosiStudent().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    private void updateTrainStudentCourse(Context ctx, TrainStudentCourseCollection studentCol_old) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE T_HR_TrainStudentCourse SET FType = ? WHERE FID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            TrainStudentCourseInfo info = null;
            int size = studentCol_old.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainStudentCourseInfo)studentCol_old.getObject(i);
                pstmt.setInt(1, info.getType().getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)info.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "UPDATE T_HR_TrainStudent SET FOrgStudentID = ?, FPosiStudentID = ? WHERE FPersonID = ? AND FTrainActivityID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql2);
            int size2 = studentCol_old.size();
            for (int i = 0; i < size2; ++i) {
                info = (TrainStudentCourseInfo)studentCol_old.getObject(i);
                pstmt.setString(1, info.getOrgStudent().getId().toString());
                pstmt.setString(2, info.getPosiStudent().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getTrainActCourse().getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql3 = "UPDATE T_HR_TrainStudentCourse SET FOrgStudentID = ?, FPosiStudentID = ? WHERE FPersonID = ? AND FTrainActCourseID IN (SELECT FID FROM T_HR_TrainActCourse WHERE FTrainActivityID= ?)";
            pstmt = conn.prepareStatement(sql3);
            int size3 = studentCol_old.size();
            for (int i = 0; i < size3; ++i) {
                info = (TrainStudentCourseInfo)studentCol_old.getObject(i);
                pstmt.setString(1, info.getOrgStudent().getId().toString());
                pstmt.setString(2, info.getPosiStudent().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getTrainActCourse().getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _updatePersonForImport(Context ctx, IObjectCollection trainStudentCourse) throws BOSException, EASBizException {
        TrainStudentCourseCollection studentCol = (TrainStudentCourseCollection)trainStudentCourse;
        this.updateTrainStudentCourseByImport(ctx, studentCol);
    }

    private void updateTrainStudentCourseByImport(Context ctx, TrainStudentCourseCollection studentCol_old) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "UPDATE T_HR_TrainStudentCourse SET FType = ? WHERE FPersonID = ? AND FTrainActCourseID IN (SELECT FID FROM T_HR_TrainActCourse WHERE FTrainActivityID= ?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            TrainStudentCourseInfo info = null;
            int size = studentCol_old.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainStudentCourseInfo)studentCol_old.getObject(i);
                pstmt.setInt(1, info.getType().getValue());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getTrainActCourse().getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql2 = "UPDATE T_HR_TrainStudent SET FOrgStudentID = ?, FPosiStudentID = ? WHERE FPersonID = ? AND FTrainActivityID = ?";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql2);
            int size2 = studentCol_old.size();
            for (int i = 0; i < size2; ++i) {
                info = (TrainStudentCourseInfo)studentCol_old.getObject(i);
                pstmt.setString(1, info.getOrgStudent().getId().toString());
                pstmt.setString(2, info.getPosiStudent().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getTrainActCourse().getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt);
            String sql3 = "UPDATE T_HR_TrainStudentCourse SET FOrgStudentID = ?, FPosiStudentID = ? WHERE FPersonID = ? AND FTrainActCourseID IN (SELECT FID FROM T_HR_TrainActCourse WHERE FTrainActivityID= ?)";
            pstmt = conn.prepareStatement(sql3);
            int size3 = studentCol_old.size();
            for (int i = 0; i < size3; ++i) {
                info = (TrainStudentCourseInfo)studentCol_old.getObject(i);
                pstmt.setString(1, info.getOrgStudent().getId().toString());
                pstmt.setString(2, info.getPosiStudent().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getPerson().getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getTrainActCourse().getTrainActivity().getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

