/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.ITrainStudent;
import com.kingdee.eas.hr.train.ITrainStudentCourse;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActivityException;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainStudentCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentCourseInfo;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.TrainStudentInfo;
import com.kingdee.eas.hr.train.TrainStudentTypeEnum;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TrainStudentDataTransmission
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger((String)TrainStudentDataTransmission.class.getName());
    private static final String RESOURCEPATH = "com.kingdee.eas.hr.train.TrainActivityResource";
    private ICoreBase factory;
    private CoreBaseInfo info;
    private PersonInfo personInfo;
    private boolean isAllCourse = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            if (this.info instanceof TrainStudentInfo) {
                this.factory = TrainStudentFactory.getLocalInstance(ctx);
            } else if (this.info instanceof TrainStudentCourseInfo) {
                this.factory = TrainStudentCourseFactory.getLocalInstance(ctx);
            }
            return this.factory;
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            this.trans(hsData, ctx);
            return this.info;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void trans(Hashtable hsData, Context ctx) throws Exception {
        this.personInfo = this.transPersonInfo(hsData, ctx);
        String trainStudentClassName = this.getContextParameter("trainStudentClassName").toString();
        if ("com.kingdee.eas.hr.train.client.TrainStudentListUI".equals(trainStudentClassName)) {
            String activityID = (String)this.getContextParameter("TrainActivityID");
            this.importAllCourse(ctx, activityID);
            this.isAllCourse = true;
        } else if ("com.kingdee.eas.hr.train.client.TrainStudentCourseListUI".equals(trainStudentClassName)) {
            this.isAllCourse = (Boolean)this.getContextParameter("isAllCourse");
            String actCourseIdOrActId = (String)this.getContextParameter("TrainActCourseID");
            if (!this.isAllCourse) {
                this.info = new TrainStudentCourseInfo();
                ((TrainStudentCourseInfo)this.info).setPerson(this.personInfo);
                ((TrainStudentCourseInfo)this.info).setType(TrainStudentTypeEnum.FORMAL);
                TrainActCourseInfo trainActCourseInfo = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseInfo((IObjectPK)new ObjectUuidPK(actCourseIdOrActId));
                ((TrainStudentCourseInfo)this.info).setTrainActCourse(trainActCourseInfo);
                String orgAndPosSQL = this.getOrgAndPosSQL(ctx, this.personInfo.getId().toString());
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)orgAndPosSQL);
                AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                PositionInfo posInfo = new PositionInfo();
                try {
                    if (rowSet.next()) {
                        String orgID = rowSet.getString("ADMINID");
                        String posID = rowSet.getString("POSID");
                        adminInfo.setId(BOSUuid.read((String)orgID));
                        posInfo.setId(BOSUuid.read((String)posID));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                ((TrainStudentCourseInfo)this.info).setOrgStudent(adminInfo);
                ((TrainStudentCourseInfo)this.info).setPosiStudent(posInfo);
            } else {
                this.importAllCourse(ctx, actCourseIdOrActId);
            }
        } else {
            throw new TaskExternalException("Transform CoreBaseInfo Failed");
        }
    }

    private void importAllCourse(Context ctx, String activityID) throws Exception {
        this.info = new TrainStudentInfo();
        ((TrainStudentInfo)this.info).setPerson(this.personInfo);
        ((TrainStudentInfo)this.info).setType(TrainStudentTypeEnum.FORMAL);
        TrainActivityInfo trainActInfo = TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activityID));
        ((TrainStudentInfo)this.info).setTrainActivity(trainActInfo);
        String orgAndPosSQL = this.getOrgAndPosSQL(ctx, this.personInfo.getId().toString());
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)orgAndPosSQL);
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        PositionInfo posInfo = new PositionInfo();
        try {
            if (rowSet.next()) {
                String orgID = rowSet.getString("ADMINID");
                String posID = rowSet.getString("POSID");
                adminInfo.setId(BOSUuid.read((String)orgID));
                posInfo.setId(BOSUuid.read((String)posID));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ((TrainStudentInfo)this.info).setOrgStudent(adminInfo);
        ((TrainStudentInfo)this.info).setPosiStudent(posInfo);
    }

    private String getOrgAndPosSQL(Context ctx, String personId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ADMINORGUNIT.FID AS ADMINID,POSITION.FID AS POSID FROM T_BD_Person AS PERSON ");
        sql.append(" INNER JOIN T_ORG_PositionMember AS POSITIONMEMBER ON PERSON.FID = POSITIONMEMBER.FPersonID");
        sql.append(" INNER JOIN T_ORG_Position AS POSITION ON POSITIONMEMBER.FPositionID = POSITION.FID");
        sql.append(" INNER JOIN T_ORG_Admin AS ADMINORGUNIT ON POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID");
        sql.append(" WHERE ");
        sql.append(" PERSON.FID = ");
        sql.append("'");
        sql.append(personId);
        sql.append("'");
        return sql.toString();
    }

    private PersonInfo transPersonInfo(Hashtable hsData, Context ctx) throws Exception {
        String currentPersonNumber = hsData.get("person_Number").toString();
        if (TrainCommonUtils.isEmpty(currentPersonNumber)) {
            throw new TrainActivityException(TrainActivityException.STUDENTNUMBER_EMPTY);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currentPersonNumber));
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        HashSet hroSet = TrainActivityFacadeFactory.getLocalInstance(ctx).getHRRange();
        String adminRangePesonSQL = TrainUtilsServer.getHRAndAdminRangePersonSQL(hroSet, userId);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminRangePesonSQL, CompareType.INNER));
        viewInfo.setFilter(filter);
        PersonCollection persons = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
        PersonInfo personInfo = null;
        if (persons == null || persons.size() <= 0) {
            String message = ResourceBase.getString((String)RESOURCEPATH, (String)"NotInOrgRangeByTrainStudent", (Locale)ctx.getLocale());
            message = MessageFormat.format(message, currentPersonNumber);
            throw new TaskExternalException(message);
        }
        personInfo = persons.get(0);
        return personInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (this.isSltImportUpdate()) {
                if (this.factory == null) {
                    this.factory = this.getController(ctx);
                }
                if (!this.isAllCourse) {
                    TrainStudentCourseCollection studentCourseCollection = new TrainStudentCourseCollection();
                    studentCourseCollection.add((TrainStudentCourseInfo)coreBaseInfo);
                    if (this.isExists(coreBaseInfo)) {
                        ((ITrainStudentCourse)this.factory).updatePersonForImport(studentCourseCollection);
                    } else {
                        ((ITrainStudentCourse)this.factory).submitPerson(studentCourseCollection);
                    }
                } else {
                    TrainStudentCollection studentCollection = new TrainStudentCollection();
                    studentCollection.add((TrainStudentInfo)coreBaseInfo);
                    if (this.isExists(coreBaseInfo)) {
                        ((ITrainStudent)this.factory).updatePersonForImport(studentCollection);
                    } else {
                        ((ITrainStudent)this.factory).submitPerson(studentCollection);
                    }
                }
            } else {
                if (this.factory == null) {
                    this.factory = this.getController(ctx);
                }
                if (!this.isExists(coreBaseInfo)) {
                    if (!this.isAllCourse) {
                        TrainStudentCourseCollection studentCourseCollection = new TrainStudentCourseCollection();
                        studentCourseCollection.add((TrainStudentCourseInfo)coreBaseInfo);
                        ((ITrainStudentCourse)this.factory).submitPerson(studentCourseCollection);
                    } else {
                        TrainStudentCollection studentCollection = new TrainStudentCollection();
                        studentCollection.add((TrainStudentInfo)coreBaseInfo);
                        ((ITrainStudent)this.factory).submitPerson(studentCollection);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isExists(CoreBaseInfo coreBaseInfo) throws Exception {
        FilterInfo filter = new FilterInfo();
        if (coreBaseInfo instanceof TrainStudentInfo) {
            TrainStudentInfo trainStudentInfo = (TrainStudentInfo)coreBaseInfo;
            filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)trainStudentInfo.getPerson().getId()));
            filter.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainStudentInfo.getTrainActivity().getId()));
        } else if (coreBaseInfo instanceof TrainStudentCourseInfo) {
            TrainStudentCourseInfo trainStudentCourseInfo = (TrainStudentCourseInfo)coreBaseInfo;
            filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)trainStudentCourseInfo.getPerson().getId()));
            filter.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainStudentCourseInfo.getTrainActCourse().getId()));
        }
        return this.factory.exists(filter);
    }
}

