/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.ITrainCourseSummary;
import com.kingdee.eas.hr.train.TrainActivityOrganigerEntryCollection;
import com.kingdee.eas.hr.train.TrainActivityOrganigerEntryFactory;
import com.kingdee.eas.hr.train.TrainActivityOrganigerEntryInfo;
import com.kingdee.eas.hr.train.TrainActivityOrganigerInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainAuditStatusEnum;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseSummaryCollection;
import com.kingdee.eas.hr.train.TrainCourseSummaryFactory;
import com.kingdee.eas.hr.train.TrainSummaryCollection;
import com.kingdee.eas.hr.train.TrainSummaryException;
import com.kingdee.eas.hr.train.TrainSummaryFactory;
import com.kingdee.eas.hr.train.TrainSummaryInfo;
import com.kingdee.eas.hr.train.TrainSummaryRelativerCollection;
import com.kingdee.eas.hr.train.TrainSummaryRelativerInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainSummaryControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainSummaryControllerBean
extends AbstractTrainSummaryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainSummaryControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkCanUpdateOrDelete(ctx, pk.toString());
        this.deleteTrainSummaryCorTrainCourse(ctx, pk);
        super._delete(ctx, pk);
    }

    private void deleteTrainSummaryCorTrainCourse(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainSummary.id", (Object)pk.toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("IsAvgCost"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainActCourse.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("TrainSummary.id"));
        ITrainCourseSummary iTrainCourseSummary = TrainCourseSummaryFactory.getLocalInstance(ctx);
        TrainCourseSummaryCollection collection = iTrainCourseSummary.getTrainCourseSummaryCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                iTrainCourseSummary.deleteTrainCourseSummary((IObjectPK)new ObjectUuidPK(collection.get(i).getId()), collection.get(i));
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkCanUpdateOrDelete(ctx, pk.toString());
        this.operateTrainActivityChange(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    private void checkActivityAreadyActivitySummary(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        TrainSummaryInfo info = (TrainSummaryInfo)model;
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)info.getTrainActivity().getId().toString(), CompareType.EQUALS));
        if (TrainSummaryFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainSummaryException(TrainSummaryException.ACTIVITY_ALREADY_SUMMARY);
        }
    }

    private void operateTrainActivityChange(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TrainSummaryInfo oldInfo = (TrainSummaryInfo)TrainSummaryFactory.getLocalInstance(ctx).getValue(pk, this.getTrainSummarySelectors());
        TrainSummaryInfo newInfo = (TrainSummaryInfo)model;
        if (!oldInfo.getTrainActivity().getId().equals((Object)newInfo.getTrainActivity().getId())) {
            this.deleteTrainSummaryCorTrainCourse(ctx, pk);
        }
    }

    public SelectorItemCollection getTrainSummarySelectors() {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("TrainActivity.id"));
        return selectorItemCollection;
    }

    protected void _audit(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        this.checkIdIsNull(id.toString());
        this.checkCanAudit(ctx, id.toString());
        this.updateBillState(ctx, id.toString(), TrainAuditStateEnum.AUDITED);
    }

    protected void _unAudit(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        this.checkIdIsNull(id.toString());
        this.checkCanUnAudit(ctx, id.toString());
        this.updateBillState(ctx, id.toString(), TrainAuditStateEnum.UNAUDITED);
    }

    private void checkIdIsNull(String id) throws BOSException, EASBizException {
        if (id == null || id.trim().length() == 0) {
            throw new TrainSummaryException(TrainSummaryException.ID_NOT_NULL);
        }
    }

    private void checkCanAudit(Context ctx, String id) throws BOSException, EASBizException {
        if (!this._checkStateValid(ctx, id, TrainAuditStateEnum.UNAUDITED)) {
            throw new TrainSummaryException(TrainSummaryException.CANNOT_AUDIT);
        }
    }

    private void checkCanUnAudit(Context ctx, String id) throws BOSException, EASBizException, TrainSummaryException {
        if (!this._checkStateValid(ctx, id, TrainAuditStateEnum.AUDITED)) {
            throw new TrainSummaryException(TrainSummaryException.CANNOT_UNAUDIT);
        }
    }

    private void checkCanUpdateOrDelete(Context ctx, String id) throws BOSException, EASBizException, TrainSummaryException {
        if (!this._checkStateValid(ctx, id, TrainAuditStateEnum.UNAUDITED)) {
            throw new TrainSummaryException(TrainSummaryException.CANNOT_DELETE_UPDATE);
        }
    }

    private boolean _checkStateValid(Context ctx, String id, TrainAuditStateEnum state) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)state.getValue(), CompareType.EQUALS));
        return TrainSummaryFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    private void updateBillState(Context ctx, String id, TrainAuditStateEnum state) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_HR_TrainSummary SET FAuditState = ? WHERE FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, state.getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)id.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("trainActivity.number"));
        sic.add(new SelectorItemInfo("trainActivity.name"));
        TrainSummaryInfo summaryInfo = (TrainSummaryInfo)this._getValue(ctx, pk, sic);
        return summaryInfo.getLogInfo();
    }

    protected Map _getSummaryRelativeInfo(Context ctx, String trainActivityId) throws BOSException, EASBizException {
        Map returnValue = TrainCourseRecordFactory.getLocalInstance(ctx).getAverages(trainActivityId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("organiger.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("organiger.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("organiger.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("role.name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.trainActivity.id", (Object)trainActivityId));
        viewInfo.setFilter(filterInfo);
        TrainActivityOrganigerEntryCollection collection = TrainActivityOrganigerEntryFactory.getLocalInstance(ctx).getTrainActivityOrganigerEntryCollection(viewInfo);
        returnValue.put("activityOrgeniger", collection);
        if (collection != null && collection.size() > 0) {
            int size = collection.size();
            HashSet<String> personIds = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                if (collection.get(i).getOrganiger() == null) continue;
                personIds.add(collection.get(i).getOrganiger().getId().toString());
            }
            if (personIds.size() > 0) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
                IRowSet rowSet = TrainUtilsServer.getRowSet(ctx, "com.kingdee.eas.hr.train.app.PersonPositionAdminQuery", filterInfo);
                returnValue.put("person", rowSet);
            }
        }
        return returnValue;
    }

    protected void _syncActRelativer(Context ctx, IObjectValue trainActivityRelativer) throws BOSException, EASBizException {
        if (trainActivityRelativer == null) {
            return;
        }
        TrainActivityOrganigerInfo organigerInfo = (TrainActivityOrganigerInfo)trainActivityRelativer;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)organigerInfo.getTrainActivity().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        TrainSummaryCollection summarys = TrainSummaryFactory.getLocalInstance(ctx).getTrainSummaryCollection(viewInfo);
        if (summarys != null && summarys.size() > 0) {
            TrainSummaryInfo trainSummaryInfo = summarys.get(0);
            if (TrainAuditStatusEnum.AUDITED.equals((Object)trainSummaryInfo.getAuditState())) {
                throw new TrainSummaryException(TrainSummaryException.SUMMARY_AUDITED);
            }
            boolean changed = false;
            if (organigerInfo != null && organigerInfo.getEntries().size() > 0) {
                TrainActivityOrganigerEntryCollection actOrganigerEntrys = organigerInfo.getEntries();
                HashSet<String> actOrganigerIds = new HashSet<String>();
                int size = actOrganigerEntrys.size();
                for (int i = 0; i < size; ++i) {
                    actOrganigerIds.add(actOrganigerEntrys.get(i).getId().toString());
                }
                TrainSummaryRelativerInfo summaryRelativerInfo = null;
                TrainSummaryRelativerCollection summaryRelativerCollection = trainSummaryInfo.getPersonEntry();
                for (int i = summaryRelativerCollection.size() - 1; i >= 0; --i) {
                    summaryRelativerInfo = summaryRelativerCollection.get(i);
                    if (actOrganigerIds.contains(summaryRelativerInfo.getActRelativePerson().getId().toString())) continue;
                    summaryRelativerCollection.remove(summaryRelativerInfo);
                    changed = true;
                }
                HashSet<String> summaryOrganigerIds = new HashSet<String>();
                int size2 = summaryRelativerCollection.size();
                for (int i = 0; i < size2; ++i) {
                    summaryOrganigerIds.add(summaryRelativerCollection.get(i).getActRelativePerson().getId().toString());
                }
                TrainActivityOrganigerEntryInfo actEntryInfo = null;
                int size3 = actOrganigerEntrys.size();
                for (int i = 0; i < size3; ++i) {
                    actEntryInfo = actOrganigerEntrys.get(i);
                    if (summaryOrganigerIds.contains(actEntryInfo.getId().toString())) continue;
                    summaryRelativerInfo = new TrainSummaryRelativerInfo();
                    summaryRelativerInfo.setParent(trainSummaryInfo);
                    summaryRelativerInfo.setActRelativePerson(actEntryInfo);
                    summaryRelativerInfo.setSeq(summaryRelativerCollection.size() + 1);
                    summaryRelativerCollection.add(summaryRelativerInfo);
                    changed = true;
                }
            } else if (trainSummaryInfo.getPersonEntry().size() > 0) {
                trainSummaryInfo.getPersonEntry().clear();
                changed = true;
            }
            if (changed) {
                super._update(ctx, (IObjectPK)new ObjectUuidPK(trainSummaryInfo.getId().toString()), (IObjectValue)trainSummaryInfo);
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkActivityAreadyActivitySummary(ctx, model);
        return super._submit(ctx, model);
    }
}

