/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.ITrainSurvey;
import com.kingdee.eas.hr.train.RequirementIssueException;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.SurveyResponseCollection;
import com.kingdee.eas.hr.train.SurveyResponseFactory;
import com.kingdee.eas.hr.train.SurveyResponseInfo;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainSurveyFactory;
import com.kingdee.eas.hr.train.TrainSurveyInfo;
import com.kingdee.eas.hr.train.TrainSurveyPublishEntryCollection;
import com.kingdee.eas.hr.train.TrainSurveyPublishEntryFactory;
import com.kingdee.eas.hr.train.TrainSurveyPublishEntryInfo;
import com.kingdee.eas.hr.train.TrainSurveyPublishInfo;
import com.kingdee.eas.hr.train.TrainSurveyStateEnum;
import com.kingdee.eas.hr.train.app.AbstractTrainSurveyPublishControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainSurveyPublishControllerBean
extends AbstractTrainSurveyPublishControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainSurveyPublishControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.hr.train.RequirementResource";

    protected IObjectPK _publish(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainSurveyPublishInfo publishInfo = (TrainSurveyPublishInfo)model;
        TrainSurveyInfo surveyInfo = publishInfo.getTrainSurvey();
        SelectorItemCollection sic = new SelectorItemCollection();
        TrainSurveyPublishEntryCollection entrys = publishInfo.getEntry();
        TrainSurveyPublishEntryInfo entryInfo = null;
        ArrayList<String> receiveIds = new ArrayList<String>();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entrys.get(i);
            if (entryInfo.getState() != null) {
                if (entryInfo.getState() == TrainSurveyStateEnum.SURVEYING) {
                    continue;
                }
            } else {
                receiveIds.add(entryInfo.getPerson().getId().toString());
            }
            entryInfo.setState(TrainSurveyStateEnum.SURVEYING);
            entryInfo.setSurvey(surveyInfo);
        }
        IObjectPK pk = null;
        try {
            pk = this._submit(ctx, (IObjectValue)publishInfo);
        }
        catch (RequirementIssueException e) {
            throw new RequirementIssueException(RequirementIssueException.PUBLISH_FAIL, new Object[]{e.getMessage(ctx.getLocale())});
        }
        if (receiveIds.size() > 0) {
            HashMap<String, String> messageMap = new HashMap<String, String>();
            String str = ResourceBase.getString((String)RESOURCE, (String)"MASSEAG_SURVEY", (Locale)ctx.getLocale());
            String title = MessageFormat.format(str, surveyInfo.getName());
            messageMap.put("title", title);
            messageMap.put("body", title);
            messageMap.put("sender", ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            TrainActivityFacadeFactory.getLocalInstance(ctx).sendMessage(receiveIds, messageMap);
            ObjectUuidPK surveyPK = new ObjectUuidPK(surveyInfo.getId().toString());
            sic.clear();
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            ITrainSurvey iTrainSurvey = TrainSurveyFactory.getLocalInstance(ctx);
            surveyInfo = iTrainSurvey.getTrainSurveyInfo((IObjectPK)surveyPK, sic);
            if (TrainSurveyStateEnum.NOT_SURVEY.equals((Object)surveyInfo.getState())) {
                surveyInfo.setState(TrainSurveyStateEnum.SURVEYING);
                iTrainSurvey.update((IObjectPK)surveyPK, (CoreBaseInfo)surveyInfo);
            }
        }
        return pk;
    }

    protected Set _deletePerson(Context ctx, Set personIdSet, String surveyID) throws BOSException, EASBizException {
        SurveyResponseCollection col = this.getNotDeletePerson(ctx, personIdSet, surveyID);
        SurveyResponseInfo info = null;
        HashSet<String> notDeletePersonID = new HashSet<String>();
        HashSet<PersonInfo> notDeletepersonInfo = new HashSet<PersonInfo>();
        if (col.size() > 0) {
            int count = col.size();
            for (int i = 0; i < count; ++i) {
                info = col.get(i);
                notDeletePersonID.add(info.getResponser().getId().toString());
                notDeletepersonInfo.add(info.getResponser());
            }
        }
        Set<String> canDeletePerson = new HashSet();
        Iterator it = personIdSet.iterator();
        if (notDeletePersonID.size() > 0) {
            while (it.hasNext()) {
                String personID = (String)it.next();
                if (notDeletePersonID.contains(personID)) continue;
                canDeletePerson.add(personID);
            }
        } else {
            canDeletePerson = personIdSet;
        }
        if (canDeletePerson.size() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("person.id", canDeletePerson, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("survey.id", (Object)surveyID));
            fi.setMaskString("#0 AND #1");
            TrainSurveyPublishEntryFactory.getLocalInstance(ctx).delete(fi);
        }
        return notDeletepersonInfo;
    }

    private SurveyResponseCollection getNotDeletePerson(Context ctx, Set personIdSet, String surveyID) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        HashSet<String> personIDSet = new HashSet<String>();
        SurveyResponseInfo info = null;
        fi.getFilterItems().add(new FilterItemInfo("responser.id", (Object)personIdSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("survey.id", (Object)surveyID));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("responser.name"));
        evi.getSelector().add(new SelectorItemInfo("state"));
        SurveyResponseCollection col = SurveyResponseFactory.getLocalInstance(ctx).getSurveyResponseCollection(evi);
        if (col.size() > 0) {
            int count = col.size();
            for (int i = 0; i < count; ++i) {
                info = col.get(i);
                if (info.getState().equals((Object)RequirementResponseEnum.RESPONSED)) {
                    personIDSet.add(info.getResponser().getId().toString());
                    continue;
                }
                col.remove(info);
            }
            super._submit(ctx, (IObjectCollection)col);
        }
        return col;
    }
}

