/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.TrainPlanInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainUtilsServer {
    private static final Logger logger = Logger.getLogger((String)TrainUtilsServer.class.getName());
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    public static FilterInfo getNoDupNumberHROFilter(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)((DataBaseInfo)model).getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)((DataBaseInfo)model).getNumber(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        return filter;
    }

    public static FilterInfo getNoDupNameHROFilter(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)((DataBaseInfo)model).getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)((DataBaseInfo)model).getName(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        return filter;
    }

    public static FilterInfo getNoDupNameORGOFilter(Context ctx, IObjectValue model) {
        TrainPlanInfo info = (TrainPlanInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)((DataBaseInfo)model).getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)info.getOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)((DataBaseInfo)model).getName(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        return filter;
    }

    public static CoreBaseInfo getCoreBaseInfo(String className) throws BOSException {
        CoreBaseInfo info = null;
        try {
            Object object = Class.forName(className).newInstance();
            if (object instanceof CoreBaseInfo) {
                info = (CoreBaseInfo)object;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    public static String getNumberSilent(Context ctx, CoreBaseInfo info, String orgUnitId) throws BOSException, EASBizException {
        if (info == null || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return codingRuleManager.getNumber((IObjectValue)info, orgUnitId);
    }

    public static String getNumberSilent(Context ctx, CoreBaseInfo info, String orgUnitId, String bindingProperty) throws BOSException, EASBizException {
        if (info == null || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String customString = null;
        return codingRuleManager.getNumber((IObjectValue)info, orgUnitId, bindingProperty, customString);
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String orgUnitId) throws BOSException, EASBizException {
        if (info == null || orgUnitId == null || orgUnitId.equals("")) {
            return;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isExist((IObjectValue)info, orgUnitId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId)) {
            codingRuleManager.recycleNumber((IObjectValue)info, orgUnitId, info.getString("number"));
        }
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String orgUnitId, String bindingProperty) throws BOSException, EASBizException {
        if (info == null || orgUnitId == null || orgUnitId.equals("")) {
            return;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isExist((IObjectValue)info, orgUnitId, bindingProperty) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId, bindingProperty)) {
            codingRuleManager.recycleNumber((IObjectValue)info, orgUnitId, bindingProperty, null, info.getString("number"));
        }
    }

    public static CtrlUnitInfo getGroupOrg(Context ctx) throws EASBizException, BOSException {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }

    public static FilterInfo getHRFilter(Context ctx, String hrOrgUnitColumn, String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(hrOrgUnitColumn, (Object)hrOrgUnitId));
        return filter;
    }

    public static FilterInfo getHRFilterInfo(Context ctx, String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(hrOrgUnitId, (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        return filter;
    }

    public static FilterInfo getHROrgUnitAndOrgRangeFilter(Context ctx, String hrOrgUnit, String adminOrgUnit) throws BOSException {
        FilterInfo hrFilter;
        FilterInfo filterInfo = null;
        try {
            filterInfo = TrainUtilsServer.buildHROFilter1(ctx, adminOrgUnit);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            if (filterInfo == null) {
                new FilterInfo();
            }
            if (BOSUuid.create((BOSObjectType)new AdminOrgUnitInfo().getBOSType()) != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(adminOrgUnit, (Object)BOSUuid.create((BOSObjectType)new AdminOrgUnitInfo().getBOSType()).toString()));
            } else {
                return new FilterInfo();
            }
        }
        if (FilterUtility.hasFilterItem((FilterInfo)(hrFilter = TrainUtilsServer.getHRFilterInfo(ctx, hrOrgUnit)))) {
            filterInfo.mergeFilter(hrFilter, "AND");
        }
        return filterInfo;
    }

    public static FilterInfo getNoDupNumberHROFilter(Context ctx, IObjectValue model, String hrOrgUnitId) throws BOSException, EASBizException {
        FilterInfo hrFilter;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (FilterUtility.hasFilterItem((FilterInfo)(hrFilter = TrainUtilsServer.getHRFilterInfo(ctx, hrOrgUnitId)))) {
            filter.mergeFilter(hrFilter, "AND");
        }
        return filter;
    }

    public static FilterInfo getNoDupNumberFilter(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return filter;
    }

    public static FilterInfo getNoDupNameParentFilter(Context ctx, IObjectValue model, String hrOrgUnitId, String parent) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        String strId = null;
        if (dataBaseInfo.get(parent) != null) {
            strId = ((DataBaseInfo)dataBaseInfo.get(parent)).getId().toString();
        }
        String parentId = parent + ".id";
        filter.getFilterItems().add(new FilterItemInfo(parentId, (Object)strId, CompareType.EQUALS));
        FilterInfo hrFilter = TrainUtilsServer.getHRFilterInfo(ctx, hrOrgUnitId);
        if (FilterUtility.hasFilterItem((FilterInfo)hrFilter)) {
            filter.mergeFilter(hrFilter, "AND");
        }
        return filter;
    }

    public static PersonInfo getResponser(Context ctx, String adminID) throws Exception {
        PersonInfo personInfo = null;
        if (adminID == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)adminID));
        viewInfo.setFilter(fi);
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "GetOrgResponserQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        if (rowSet.size() == 0) {
            return null;
        }
        rowSet.next();
        personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)rowSet.getString("person.id")));
        personInfo.setName(rowSet.getString("person.name"));
        personInfo.setNumber(rowSet.getString("person.number"));
        return personInfo;
    }

    public static String formatBigDecimal(BigDecimal value, int precicion) {
        if (TrainUtilsServer.objectIsNull(value)) {
            return "";
        }
        String str = ZERO.compareTo(value) == 0 ? "0.00000000000000000000000" : value.toString();
        if (str.lastIndexOf(".") == -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            strBuffer.append(".");
            for (int i = 0; i < precicion; ++i) {
                strBuffer.append("0");
            }
            return strBuffer.toString();
        }
        if (str.lastIndexOf(".") == str.length() - 2) {
            return str + "0";
        }
        int len = str.lastIndexOf(".") + 1 + precicion;
        return str.substring(0, len);
    }

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    public static String computeDate(Context ctx, Date oldDate, Date nowDate) {
        int year = 0;
        int month = 0;
        if (oldDate != null && nowDate != null) {
            Calendar dateCal = Calendar.getInstance();
            dateCal.setTime(oldDate);
            Calendar nowCal = Calendar.getInstance();
            nowCal.setTime(nowDate);
            nowCal.add(5, 1);
            int dateYear = dateCal.get(1);
            int nowYear = nowCal.get(1);
            int dateMonth = dateCal.get(2) + 1;
            int nowMonth = nowCal.get(2) + 1;
            int dateDay = dateCal.get(5);
            int nowDay = nowCal.get(5);
            int tempYear = nowYear - dateYear;
            int tempMonth = nowMonth - dateMonth;
            int tempDay = nowDay - dateDay;
            if (tempDay < 0) {
                --tempMonth;
            }
            year = (tempYear * 12 + tempMonth) / 12;
            month = (tempYear * 12 + tempMonth) % 12;
        }
        StringBuffer str = new StringBuffer();
        str.append(year);
        str.append(ResourceBase.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"YEAR", (Locale)ctx.getLocale()));
        str.append(month);
        str.append(ResourceBase.getString((String)"com.kingdee.eas.hr.train.TrainResource", (String)"MONTH", (Locale)ctx.getLocale()));
        return str.toString();
    }

    public static IRowSet getRowSet(Context ctx, String queryName, FilterInfo filterInfo) throws BOSException {
        return TrainUtilsServer.getRowSet(ctx, queryName, filterInfo, null);
    }

    public static IRowSet getRowSet(Context ctx, String queryName, FilterInfo filterInfo, SorterItemCollection sorterItems) throws BOSException {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        if (sorterItems != null && sorterItems.size() > 0) {
            SorterItemCollection temp = evi.getSorter();
            int size = sorterItems.size();
            for (int i = 0; i < size; ++i) {
                temp.add(sorterItems.get(i));
            }
        }
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static IRowSet getRowSet(Context ctx, String queryName, EntityViewInfo viewInfo) throws BOSException {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static String getWebStringValue(IRowSet rowSet, String key) throws Exception {
        if (rowSet.getString(key) != null && rowSet.getString(key).length() > 0) {
            return rowSet.getString(key);
        }
        return "&nbsp;";
    }

    public static String getWebLegendStringValue(IRowSet rowSet, String key) throws Exception {
        if (rowSet.getString(key) != null && rowSet.getString(key).length() > 0) {
            return rowSet.getString(key);
        }
        return "";
    }

    public static String getWebBigDecimalStringValue(IRowSet rowSet, String key) throws Exception {
        if (rowSet.getBigDecimal(key) != null) {
            return TrainUtilsServer.formatBigDecimal(rowSet.getBigDecimal(key), 2);
        }
        return "&nbsp;";
    }

    private static String getDispNumber(Context ctx, CoreBaseInfo info, String orgUnitId) throws BOSException {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isAddView((IObjectValue)info, orgUnitId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId)) {
                number = codingRuleManager.getNumber((IObjectValue)info, orgUnitId);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return number;
    }

    private static String getDispNumber(Context ctx, CoreBaseInfo info, String orgUnitId, String bindingProperty) throws BOSException {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isAddView((IObjectValue)info, orgUnitId, bindingProperty) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId, bindingProperty)) {
                String customString = null;
                number = codingRuleManager.getNumber((IObjectValue)info, orgUnitId, bindingProperty, customString);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return number;
    }

    public static void initNumber(Context ctx, CoreBaseInfo info, String orgUnitId) throws BOSException {
        String number;
        boolean rst = TrainUtilsServer.hasNumberRule(ctx, info, orgUnitId);
        if (rst && !TrainUtilsServer.objectIsNull(number = TrainUtilsServer.getDispNumber(ctx, info, orgUnitId))) {
            info.setString("number", number);
        }
    }

    public static void initNumber(Context ctx, CoreBaseInfo info, String orgUnitId, String bindingProperty) throws BOSException {
        String number;
        boolean rst = TrainUtilsServer.hasNumberRule(ctx, info, orgUnitId, bindingProperty);
        if (rst && !TrainUtilsServer.objectIsNull(number = TrainUtilsServer.getDispNumber(ctx, info, orgUnitId, bindingProperty))) {
            info.setString("number", number);
        }
    }

    public static boolean hasNumberRule(Context ctx, CoreBaseInfo info, String orgUnitId) {
        if (info == null || orgUnitId == null || orgUnitId.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)info, orgUnitId);
        }
        catch (Exception e) {
            logger.error((Object)"error message", (Throwable)e);
        }
        return result;
    }

    public static boolean hasNumberRule(Context ctx, CoreBaseInfo info, String orgUnitId, String bindingProperty) {
        if (info == null || orgUnitId == null || orgUnitId.equals("") || bindingProperty == null || bindingProperty.equals("")) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)info, orgUnitId, bindingProperty);
        }
        catch (Exception e) {
            logger.error((Object)"error message", (Throwable)e);
        }
        return result;
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(Context ctx, String hrColumnName, String orgUnitColumnName) {
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        return TrainUtilsServer.getHRAndAdminRangeFilterInfo(ctx, hrColumnName, orgUnitColumnName, hrOrgUnitId);
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(Context ctx, String hrColumnName, String orgUnitColumnName, String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null || hrOrgUnitId == null) {
            filter.getFilterItems().add(new FilterItemInfo(hrColumnName, (Object)"0"));
            filter.getFilterItems().add(new FilterItemInfo(orgUnitColumnName, (Object)"0"));
            return filter;
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitId);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitId);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static FilterInfo getAdminRangeFilterInfo(Context ctx, String orgUnitColumnName) {
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null || ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return null;
        }
        StringBuffer sql = TrainUtilsServer.getAdminOrgUnitRangeSQL(ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static StringBuffer getAdminOrgUnitRangeSQL(Context ctx) {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql;
    }

    public static FilterInfo buildHROFilter(Context ctx, String columnName) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        IHROrgUnit iHRO = HROrgUnitFactory.getLocalInstance((Context)ctx);
        HROrgUnitInfo hroInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hroInfo == null) {
            return null;
        }
        AdminOrgUnitCollection adminColl = iHRO.getAdminOrgUnitCollectionWithOrgRangeFilter(hroInfo.getId().toString());
        if (adminColl != null && adminColl.size() > 0) {
            HashSet<String> ids = new HashSet<String>();
            int size = adminColl.size();
            for (int i = 0; i < size; ++i) {
                ids.add(adminColl.get(i).getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo(columnName, ids, CompareType.INCLUDE));
        } else {
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)BOSUuid.create((BOSObjectType)adminInfo.getBOSType())));
        }
        return filterInfo;
    }

    public static void handleDefaultSolution(RequestContext request, ResponseContext response, Context context) throws BOSException, EASBizException, Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getLocalInstance((Context)context);
        IMetaDataPK mainQueryPK = (IMetaDataPK)request.get("mainQueryPK");
        String className = (String)request.get("uiClassName");
        iQuery.hasDefaultSolution(className, mainQueryPK.getFullName());
    }

    public static DataBaseCollection getDataBaseCollection(Context ctx, IDataBase iDb, FilterInfo filterInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (filterInfo != null) {
            viewInfo.setFilter(filterInfo);
        }
        SorterItemInfo itemInfo = new SorterItemInfo("number");
        itemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(itemInfo);
        return iDb.getDataBaseCollection(viewInfo);
    }

    public static String getCurrentPersonId(Context ctx) {
        String currentPersonId = null;
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            currentPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        return currentPersonId;
    }

    public static void treeNodeHaveItems(RequestContext request, Context context, ICoreBase bizInterface) throws EASBizException, BOSException {
        CoreBaseInfo info = (CoreBaseInfo)request.get("nodeData");
        if (info != null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("treeid.id", (Object)info.getId().toString()));
            bizInterface.exists(filterInfo);
        }
    }

    public static PositionInfo getPositionAndAdminOrgUnit(Context ctx, String personId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        IPositionMember iPM = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection pmColl = iPM.getPositionMemberCollection(viewInfo);
        if (pmColl != null && pmColl.size() > 0) {
            return pmColl.get(0).getPosition();
        }
        return null;
    }

    public static String setSetToString(Set set) {
        if (set == null || set.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        boolean flag = false;
        while (it.hasNext()) {
            if (flag) {
                sb.append(" , ");
            }
            sb.append("'");
            sb.append(it.next());
            sb.append("'");
            flag = true;
        }
        String str = sb.toString();
        return str;
    }

    public static String getHRAndAdminRangePersonSQL(String hrOrgUnitID, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PERSON.FID FROM T_BD_PERSON AS PERSON");
        sql.append(" INNER JOIN T_ORG_PositionMember AS PM ON PM.FPERSONID = PERSON.FID");
        sql.append(" INNER JOIN T_ORG_Position AS Position ON Position.FID = PM.FPositionId");
        sql.append(" INNER JOIN T_ORG_UNITRELATION AS REL ON REL.FFROMUNITID = Position.FAdminOrgUnitId");
        sql.append(" INNER JOIN T_PM_ORGRANGE AS RANGE ON RANGE.FORGID = REL.FFROMUNITID");
        sql.append(" WHERE ");
        sql.append(" REL.FTOUNITID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" REL.FTYPERELATIONID = ");
        sql.append("'");
        sql.append("00000000-0000-0000-0000-0000000000100FE9F8B5");
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FUSERID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FTYPE = ");
        sql.append(20);
        return sql.toString();
    }

    public static String getStartDate2EndDateString(Date startDate, Date endDate, String seperate) {
        if (startDate == null || endDate == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(startDate);
        sb.append(seperate);
        sb.append(endDate);
        return sb.toString();
    }

    public static String getHourUnitString(Object courseHour, Object unit) {
        if (courseHour == null || unit == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TrainUtilsServer.formatBigDecimal((BigDecimal)courseHour, 2));
        if (unit instanceof Integer) {
            sb.append(CourseHourUnitEnum.getEnum((Integer)unit).toString());
        } else if (unit instanceof BizEnumInfo) {
            sb.append(CourseHourUnitEnum.getEnum(((BizEnumValueInfo)unit).getInt()).toString());
        } else {
            sb.append(unit.toString());
        }
        return sb.toString();
    }

    public static String getHRAndAdminRangePersonSQL(Set hrIdSet, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PERSON.FID FROM T_BD_PERSON AS PERSON");
        sql.append(" INNER JOIN T_ORG_PositionMember AS PM ON PM.FPERSONID = PERSON.FID");
        sql.append(" INNER JOIN T_ORG_Position AS Position ON Position.FID = PM.FPositionId");
        sql.append(" INNER JOIN T_ORG_UNITRELATION AS REL ON REL.FFROMUNITID = Position.FAdminOrgUnitId");
        sql.append(" INNER JOIN T_PM_ORGRANGE AS RANGE ON RANGE.FORGID = REL.FFROMUNITID");
        sql.append(" WHERE ");
        sql.append(" REL.FTOUNITID IN ");
        sql.append("(");
        sql.append(TrainUtilsServer.setSetToString(hrIdSet));
        sql.append(")");
        sql.append(" AND ");
        sql.append(" REL.FTYPERELATIONID = ");
        sql.append("'");
        sql.append("00000000-0000-0000-0000-0000000000100FE9F8B5");
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FUSERID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" RANGE.FTYPE = ");
        sql.append(20);
        return sql.toString();
    }

    public static FilterInfo buildHROFilter1(Context ctx, String columnName) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        Object iHRO = null;
        HROrgUnitInfo hroInfo = null;
        hroInfo = ctx == null ? SysContext.getSysContext().getCurrentHRUnit() : ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hroInfo == null) {
            filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)BOSUuid.create((String)"58B332D9")));
            return filterInfo;
        }
        String sql = TrainUtilsServer.getAdminOrgRangeAndHRSql(ctx, hroInfo.getId().toString());
        filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)sql, CompareType.INNER));
        return filterInfo;
    }

    public static String getAdminOrgRangeAndHRSql(Context ctx, String hrOrgUnitID) {
        if (hrOrgUnitID == null) {
            hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T1.fid FROM t_org_admin T1 ");
        sql.append(" inner join t_pm_orgrange T2 on T1.Fid= T2.Forgid");
        sql.append(" inner join t_org_unitrelation T3 on t3.ffromunitid = T1.fid");
        sql.append(" where T2.FUSERID= '").append(userID).append("'");
        sql.append(" AND T2.FType = 20 ");
        sql.append(" and T3.FTOUNITID= '").append(hrOrgUnitID).append("'");
        sql.append(" and T3.Ftyperelationid='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        return sql.toString();
    }
}

