/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.RequirementFacadeFactory;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseFactory;
import com.kingdee.eas.hr.train.RequirementResponseInfo;
import com.kingdee.eas.hr.train.RequirementTypeEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class RequirementResponseAction
extends DispatchAction {
    private SelectorItemCollection sic = null;

    public ActionForward response(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequirementResponseInfo responseInfo = (RequirementResponseInfo)request.getSession().getAttribute("responseInfo");
        if (responseInfo == null) {
            String responseId = RequirementAssistant.handleCharacter(request.getParameter("responseId"));
            if (TrainCommonUtils.isEmpty(responseId)) {
                responseId = RequirementAssistant.handleCharacter((String)request.getSession().getAttribute("responseId"));
                request.getSession().removeAttribute("responseId");
            }
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            if (TrainCommonUtils.isEmpty(responseId)) {
                String requirementId = RequirementAssistant.handleCharacter(request.getParameter("requirementId"));
                String currentPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
                responseInfo = RequirementResponseFactory.getLocalInstance(ctx).getRequirementResponseInfo(requirementId, currentPersonId, this.getSelector());
                if (responseInfo == null) {
                    responseInfo = RequirementAssistant.createRequirementResponseInfo(ctx, requirementId, ContextUtil.getCurrentUserInfo((Context)ctx));
                }
            } else {
                responseInfo = this.getValue(ctx, responseId);
            }
        }
        this.setDataToRequest(request, responseInfo);
        this.setPageViewState(request, false);
        return mapping.findForward("page");
    }

    private void setPageViewState(HttpServletRequest request, boolean flag) {
        request.setAttribute("view", (Object)String.valueOf(flag));
    }

    public ActionForward viewResponse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String id = RequirementAssistant.handleCharacter(request.getParameter("responseId"));
        RequirementResponseInfo info = this.getValue(ctx, id);
        this.setDataToRequest(request, info);
        this.setPageViewState(request, true);
        return mapping.findForward("page");
    }

    public ActionForward submit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequirementResponseInfo responseInfo = RequirementAssistant.assembleRequirementResponseInfo(request);
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IObjectPK pk = RequirementResponseFactory.getLocalInstance(ctx).submit((CoreBaseInfo)responseInfo);
        this.setMessage(request, ResourceBase.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"Msg_Submit_OK", (Locale)ctx.getLocale()));
        request.getSession().setAttribute("responseId", (Object)pk.toString());
        return mapping.findForward("edit");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequirementResponseInfo responseInfo = RequirementAssistant.assembleRequirementResponseInfo(request);
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IObjectPK pk = RequirementResponseFactory.getLocalInstance(ctx).save((CoreBaseInfo)responseInfo);
        this.setMessage(request, ResourceBase.getString((String)"com.kingdee.eas.hr.train.RequirementResource", (String)"Msg_Save_OK", (Locale)ctx.getLocale()));
        request.getSession().setAttribute("responseId", (Object)pk.toString());
        return mapping.findForward("edit");
    }

    private void setMessage(HttpServletRequest request, String message) {
        request.getSession().setAttribute("message", (Object)message);
    }

    private void setDataToRequest(HttpServletRequest request, RequirementResponseInfo responseInfo) throws EASBizException, BOSException {
        int i;
        request.setAttribute("editData", (Object)responseInfo);
        ArrayList<BillEntryBaseInfo> courses = new ArrayList<BillEntryBaseInfo>();
        for (i = 0; i < responseInfo.getAppointedCourse().size(); ++i) {
            courses.add(responseInfo.getAppointedCourse().get(i));
        }
        request.setAttribute("appointedCourses", courses);
        courses = new ArrayList();
        for (i = 0; i < responseInfo.getSuggestCourse().size(); ++i) {
            courses.add(responseInfo.getSuggestCourse().get(i));
        }
        request.setAttribute("suggestCourses", courses);
        String requirementId = responseInfo.getRequirement().getId().toString();
        String responserId = responseInfo.getResponser().getId().toString();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        boolean isPublisher = RequirementFacadeFactory.getLocalInstance(ctx).isAsPublisher(requirementId, responserId);
        request.setAttribute("isPublisher", (Object)String.valueOf(isPublisher));
        boolean flag = RequirementResponseEnum.RESPONSED.equals((Object)responseInfo.getState());
        request.setAttribute("responsedState", (Object)String.valueOf(flag));
        String requirementType = null;
        requirementType = RequirementTypeEnum.COURSE_TYPE.equals((Object)responseInfo.getRequirement().getType()) ? "courseType" : "trainItemType";
        request.setAttribute("requirementType", (Object)requirementType);
    }

    private RequirementResponseInfo getValue(Context ctx, String pk) throws EASBizException, BOSException {
        return RequirementResponseFactory.getLocalInstance(ctx).getRequirementResponseInfo((IObjectPK)new ObjectUuidPK(pk), this.getSelector());
    }

    private SelectorItemCollection getSelector() {
        if (this.sic == null) {
            this.sic = new SelectorItemCollection();
            this.sic.add(new SelectorItemInfo("*"));
            this.sic.add(new SelectorItemInfo("requirement.*"));
            this.sic.add(new SelectorItemInfo("adminOrgUnit.*"));
            this.sic.add(new SelectorItemInfo("responser.*"));
            this.sic.add(new SelectorItemInfo("appointedCourse.*"));
            this.sic.add(new SelectorItemInfo("appointedCourse.requirementEntry.*"));
            this.sic.add(new SelectorItemInfo("appointedCourse.requirementEntry.course.*"));
            this.sic.add(new SelectorItemInfo("appointedCourse.requirementEntry.course.treeid.*"));
            this.sic.add(new SelectorItemInfo("appointedCourse.requirementEntry.trainItem.*"));
            this.sic.add(new SelectorItemInfo("appointedCourse.requirementEntry.trainItem.treeid.name"));
            this.sic.add(new SelectorItemInfo("appointedCourse.requirementEntry.courseType.*"));
            this.sic.add(new SelectorItemInfo("suggestCourse.*"));
            this.sic.add(new SelectorItemInfo("suggestCourse.courseType.*"));
        }
        return this.sic;
    }
}

