/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonTechnicalPostCollection;
import com.kingdee.eas.hr.emp.PersonTechnicalPostFactory;
import com.kingdee.eas.hr.emp.PersonTechnicalPostInfo;
import com.kingdee.eas.hr.train.CourseHourUnitEnum;
import com.kingdee.eas.hr.train.EmployeeCourseCollection;
import com.kingdee.eas.hr.train.EmployeeCourseEntryCollection;
import com.kingdee.eas.hr.train.EmployeeCourseEntryInfo;
import com.kingdee.eas.hr.train.EmployeeCourseFactory;
import com.kingdee.eas.hr.train.EmployeeCourseInfo;
import com.kingdee.eas.hr.train.ITrainActCourse;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActStateEnum;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseTreeCollection;
import com.kingdee.eas.hr.train.TrainCourseTreeFactory;
import com.kingdee.eas.hr.train.TrainItemInfo;
import com.kingdee.eas.hr.train.TrainItemTreeInfo;
import com.kingdee.eas.hr.train.TrainingMethodInfo;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.hr.train.web.TrainWebUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TrainSignupUtil {
    private static Logger logger = Logger.getLogger((String)TrainSignupUtil.class.getName());
    private static final String RES = "com.kingdee.eas.hr.train.TrainWebResource";

    public static boolean isOrgResponser(Context ctx) {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return false;
        }
        try {
            AdminOrgUnitCollection adminColl = HROrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollectionWithOrgRangeFilter(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
            return adminColl.size() > 0;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.getCause());
            return false;
        }
    }

    public static List getTrainSignupList(Context ctx, String typeID) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null || ContextUtil.getCurrentHRUnit((Context)ctx) == null || TrainUtilsServer.objectIsNull(typeID)) {
            return list;
        }
        int COLUMN = 11;
        String personID = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filterInfo.getFilterItems().add(new FilterItemInfo("magroupPerson.id", (Object)personID));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        if (!typeID.equals("selectAll")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("trainingCategory.id", (Object)typeID));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)30));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)40));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainActState", (Object)50));
        if (!typeID.equals("selectAll")) {
            filterInfo.setMaskString(" (#0 OR #1) AND #2 AND #3 AND ( #4 OR #5 OR #6) ");
        } else {
            filterInfo.setMaskString(" (#0 OR #1) AND #2 AND ( #3 OR #4 OR #5) ");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        IRowSet rowSet = null;
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainSignupQuery"));
            iqec.setObjectView(viewInfo);
            rowSet = iqec.executeQuery();
            StringBuffer sumSQL = new StringBuffer();
            sumSQL.append(" SELECT t.TRAINACTID AS TRAINACTID, COUNT(t.TRAINACTID) AS count ");
            sumSQL.append(" from (");
            sumSQL.append("     SELECT");
            sumSQL.append("     DISTINCT TRAINSIGNER.FEmployeeID AS EMPLOYEEID,");
            sumSQL.append("     TRAINSIGNER.FTrainActID AS TRAINACTID");
            sumSQL.append("     FROM T_HR_TrainSigner AS TRAINSIGNER");
            sumSQL.append("     LEFT OUTER JOIN T_BD_Person AS EMPLOYEE");
            sumSQL.append("     ON TRAINSIGNER.FEmployeeID = EMPLOYEE.FID");
            sumSQL.append("     LEFT OUTER JOIN T_HR_TrainActivity AS TRAINACT");
            sumSQL.append("     ON TRAINSIGNER.FTrainActID = TRAINACT.FID");
            sumSQL.append("  ) t");
            sumSQL.append(" group by t.TRAINACTID");
            IRowSet sumCountRowSet = DbUtil.executeQuery((Context)ctx, (String)sumSQL.toString());
            HashMap<String, String> sumCountMap = new HashMap<String, String>();
            while (sumCountRowSet.next()) {
                sumCountMap.put(sumCountRowSet.getString("TRAINACTID"), sumCountRowSet.getString("count"));
            }
            StringBuffer formalSQL = new StringBuffer();
            formalSQL.append(" SELECT t.TRAINACTID AS TRAINACTID, COUNT(t.TRAINACTID) AS count ");
            formalSQL.append(" from (");
            formalSQL.append("     SELECT");
            formalSQL.append("     DISTINCT TRAINSIGNER.FTrainActID AS TRAINACTID, ");
            formalSQL.append("     TRAINSIGNER.FEmployeeID AS EMPLOYEEID");
            formalSQL.append("     FROM T_HR_TrainSigner AS TRAINSIGNER");
            formalSQL.append("     LEFT OUTER JOIN T_HR_TrainActivity AS TRAINACT");
            formalSQL.append("     ON TRAINSIGNER.FTrainActID = TRAINACT.FID");
            formalSQL.append("     LEFT OUTER JOIN T_BD_Person AS EMPLOYEE");
            formalSQL.append("     ON TRAINSIGNER.FEmployeeID = EMPLOYEE.FID");
            formalSQL.append("     INNER JOIN (SELECT ");
            formalSQL.append("     DISTINCT TRAINACTCOURSE.FTrainActivityID AS TRAINACTIVITYID, ");
            formalSQL.append("     TRAINSTUDENTCOURSE.FPersonID AS PERSONID, ");
            formalSQL.append("     TRAINSTUDENTCOURSE.FType AS TYPE");
            formalSQL.append("     FROM T_HR_TrainStudentCourse AS TRAINSTUDENTCOURSE");
            formalSQL.append("     LEFT OUTER JOIN T_HR_TrainActCourse AS TRAINACTCOURSE");
            formalSQL.append("     ON TRAINSTUDENTCOURSE.FTrainActCourseID = TRAINACTCOURSE.FID");
            formalSQL.append("     LEFT OUTER JOIN T_BD_Person AS PERSON");
            formalSQL.append("     ON TRAINSTUDENTCOURSE.FPersonID = PERSON.FID");
            formalSQL.append("     LEFT OUTER JOIN T_HR_TrainActivity AS TRAINACTIVITY");
            formalSQL.append("     ON TRAINACTCOURSE.FTrainActivityID = TRAINACTIVITY.FID");
            formalSQL.append("     WHERE TRAINSTUDENTCOURSE.FType = 10) AS SUBQUERY");
            formalSQL.append("     ON (TRAINSIGNER.FEmployeeID = SUBQUERY.PERSONID AND TRAINSIGNER.FTrainActID = SUBQUERY.TRAINACTIVITYID)");
            formalSQL.append("  ) t");
            formalSQL.append(" group by t.TRAINACTID");
            IRowSet formalCountRowSet = DbUtil.executeQuery((Context)ctx, (String)formalSQL.toString());
            HashMap<String, String> formalCountMap = new HashMap<String, String>();
            while (formalCountRowSet.next()) {
                formalCountMap.put(formalCountRowSet.getString("TRAINACTID"), formalCountRowSet.getString("count"));
            }
            int index = 0;
            int formal = 0;
            while (rowSet.next()) {
                String[] printStr = new String[COLUMN];
                printStr[0] = "" + ++index;
                printStr[1] = rowSet.getString("id");
                printStr[2] = TrainUtilsServer.getWebStringValue(rowSet, "name");
                printStr[3] = rowSet.getString("maxStudentCount") != null ? rowSet.getString("maxStudentCount") : "&nbsp;";
                printStr[4] = rowSet.getString("minStudentCount") != null ? rowSet.getString("minStudentCount") : "&nbsp;";
                if (formalCountMap.get(printStr[1]) != null) {
                    formal = Integer.parseInt(formalCountMap.get(printStr[1]).toString());
                    printStr[5] = formal > 0 ? "<a href=\"javascript:void(0);\" onclick=\"javascript:hr_train_viewTrainSignupStuList('" + printStr[1] + "','" + printStr[2] + "','true')\"" + " target=\"\">" + formal + "</a>" : "" + formal;
                    if (sumCountMap.get(printStr[1]) != null) {
                        printStr[6] = "" + (Integer.parseInt(sumCountMap.get(printStr[1]).toString()) - formal);
                        if (Integer.parseInt(printStr[6]) > 0) {
                            printStr[6] = "<a href=\"javascript:void(0);\" onclick=\"javascript:hr_train_viewTrainSignupStuList('" + printStr[1] + "','" + printStr[2] + "','false')\"" + " target=\"\">" + printStr[6] + "</a>";
                        }
                    } else {
                        printStr[6] = "&nbsp;";
                    }
                } else {
                    printStr[5] = "&nbsp;";
                    if (sumCountMap.get(printStr[1]) != null) {
                        printStr[6] = sumCountMap.get(printStr[1]).toString();
                        if (Integer.parseInt(printStr[6]) > 0) {
                            printStr[6] = "<a href=\"javascript:void(0);\" onclick=\"javascript:hr_train_viewTrainSignupStuList('" + printStr[1] + "','" + printStr[2] + "','false')\"" + " target=\"\">" + printStr[6] + "</a>";
                        }
                    } else {
                        printStr[6] = "&nbsp;";
                    }
                }
                printStr[7] = rowSet.getDate("signStartDate") != null && rowSet.getDate("signEndDate") != null ? rowSet.getDate("signStartDate").toString() + "--" + rowSet.getDate("signEndDate").toString() : "&nbsp;";
                printStr[8] = rowSet.getDate("trainStartDate") != null && rowSet.getDate("trainEndDate") != null ? rowSet.getDate("trainStartDate").toString() + "--" + rowSet.getDate("trainEndDate").toString() : "&nbsp;";
                printStr[9] = TrainUtilsServer.getWebStringValue(rowSet, "orgUnit.name");
                printStr[10] = TrainActStateEnum.getEnum(Integer.parseInt(rowSet.getString("trainActState"))).toString();
                list.add(printStr);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.getCause());
            return new ArrayList();
        }
        return list;
    }

    public static TrainActCourseInfo getActCourseInfo(HttpServletRequest request, String trainActCourseID) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (TrainUtilsServer.objectIsNull(trainActCourseID)) {
            return new TrainActCourseInfo();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("TrainCourse.name"));
        sic.add(new SelectorItemInfo("TrainCourse.number"));
        sic.add(new SelectorItemInfo("TrainingMethod.name"));
        sic.add(new SelectorItemInfo("TrainCourse.CourseKind.name"));
        sic.add(new SelectorItemInfo("CourseHour"));
        sic.add(new SelectorItemInfo("CourseHourUnit"));
        sic.add(new SelectorItemInfo("TrainCourse.treeid.name"));
        sic.add(new SelectorItemInfo("StartDate"));
        sic.add(new SelectorItemInfo("TotalCost"));
        sic.add(new SelectorItemInfo("EndDate"));
        sic.add(new SelectorItemInfo("NeedExam"));
        sic.add(new SelectorItemInfo("AssessMethod.name"));
        sic.add(new SelectorItemInfo("passStand"));
        sic.add(new SelectorItemInfo("TrainCourse.CourseTarget"));
        try {
            return TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseInfo((IObjectPK)new ObjectUuidPK(trainActCourseID.trim().replaceAll(" ", "+")), sic);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return new TrainActCourseInfo();
        }
    }

    public static TrainActivityInfo getActitivityInfo(Context ctx, String id) {
        if (TrainUtilsServer.objectIsNull(id)) {
            return new TrainActivityInfo();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("TrainPlan.name"));
        sic.add(new SelectorItemInfo("planActivity.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("belongOrgUnit.name"));
        sic.add(new SelectorItemInfo("belongOrgUnit.id"));
        sic.add(new SelectorItemInfo("orgPerson.name"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("trainingCategor.name"));
        sic.add(new SelectorItemInfo("trainItem.name"));
        sic.add(new SelectorItemInfo("trainStartDate"));
        sic.add(new SelectorItemInfo("trainEndDate"));
        sic.add(new SelectorItemInfo("BudgetCost"));
        sic.add(new SelectorItemInfo("minStudentCount"));
        sic.add(new SelectorItemInfo("maxStudentCount"));
        sic.add(new SelectorItemInfo("needDivide"));
        sic.add(new SelectorItemInfo("needCertifcate"));
        sic.add(new SelectorItemInfo("needContract"));
        sic.add(new SelectorItemInfo("target"));
        sic.add(new SelectorItemInfo("trainAddress"));
        sic.add(new SelectorItemInfo("contactMethod"));
        sic.add(new SelectorItemInfo("roadMap"));
        sic.add(new SelectorItemInfo("description"));
        try {
            return TrainActivityFactory.getLocalInstance(ctx).getTrainActivityInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return new TrainActivityInfo();
        }
    }

    public static String getActCourseDataXml(Context ctx, String trainActivityID) {
        int COLS = 10;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)trainActivityID, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        String xmlData = null;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainActivityForSignupFormEditUIQuery"));
            iqec.setObjectView(viewInfo);
            IRowSet rowSet = iqec.executeQuery();
            list.add("" + rowSet.size());
            int index = 0;
            String temp = "";
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = rowSet.getString("trainActCourse.id");
                array[1] = rowSet.getString("trainInstructor.id");
                array[2] = "" + ++index;
                array[3] = rowSet.getString("courseName");
                array[4] = rowSet.getString("courseNumber");
                temp = rowSet.getDate("signStartDate") != null && rowSet.getDate("signEndDate") != null ? rowSet.getDate("signStartDate").toString() + "--" + rowSet.getDate("signEndDate").toString() : "";
                array[5] = temp;
                temp = rowSet.getDate("trainActCourse.StartDate") != null && rowSet.getDate("trainActCourse.EndDate") != null ? rowSet.getDate("trainActCourse.StartDate").toString() + "--" + rowSet.getDate("trainActCourse.EndDate").toString() : "";
                array[6] = temp;
                array[7] = rowSet.getString("trainAddress");
                array[8] = rowSet.getString("orgUnit");
                array[9] = "" + rowSet.getBoolean("trainInstructor.IsOuter");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        return xmlData;
    }

    public static String getPersonalSignupCourseListXml(Context ctx, String trainActivityID, String personID) {
        int COLS = 11;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Attendee.id", (Object)personID, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        String xmlData = null;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainSignupFormAllQuery"));
            iqec.setObjectView(viewInfo);
            IRowSet rowSet = iqec.executeQuery();
            list.add("" + rowSet.size());
            int index = 0;
            String temp = "";
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = "" + ++index;
                array[1] = TrainAuditStateEnum.getEnum(rowSet.getInt("trainSignupForm.AuditState")).toString();
                array[2] = TrainUtilsServer.getWebLegendStringValue(rowSet, "Course.name");
                array[3] = rowSet.getString("Course.number");
                temp = rowSet.getDate("trainActCourse.StartDate") != null && rowSet.getDate("trainActCourse.EndDate") != null ? rowSet.getDate("trainActCourse.StartDate").toString() + "--" + rowSet.getDate("trainActCourse.EndDate").toString() : "";
                array[4] = temp;
                temp = rowSet.getBigDecimal("trainActCourse.CourseHour") != null && rowSet.getString("trainActCourse.CourseHourUnit") != null ? TrainUtilsServer.formatBigDecimal(rowSet.getBigDecimal("trainActCourse.CourseHour"), 2) + (Object)((Object)CourseHourUnitEnum.getEnum(rowSet.getInt("trainActCourse.CourseHourUnit"))) : "";
                array[5] = temp;
                array[6] = TrainUtilsServer.getWebLegendStringValue(rowSet, "treeid.name");
                array[7] = TrainUtilsServer.getWebLegendStringValue(rowSet, "CourseKind.name");
                array[8] = TrainUtilsServer.getWebLegendStringValue(rowSet, "instructor.name");
                array[9] = TrainUtilsServer.getWebLegendStringValue(rowSet, "trainActivity.trainAddress");
                array[10] = TrainUtilsServer.getWebLegendStringValue(rowSet, "orgUnit.name");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        return xmlData;
    }

    private static boolean exist(EmployeeCourseEntryCollection entrys, EmployeeCourseEntryInfo info) {
        boolean result = false;
        String courseId = info.getCourse().getId().toString();
        String trainItemId = "";
        if (info.getTrainItem() != null && info.getTrainItem().getId() != null) {
            trainItemId = info.getTrainItem().getId().toString();
        }
        for (int j = 0; j < entrys.size(); ++j) {
            EmployeeCourseEntryInfo entry = entrys.get(j);
            String itemId = "";
            if (entry.getTrainItem() != null && entry.getTrainItem().getId() != null) {
                itemId = entry.getTrainItem().getId().toString();
            }
            if (!courseId.equals(entry.getCourse().getId().toString()) || !trainItemId.equals(itemId)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean existTrainItem(EmployeeCourseEntryCollection entrys, EmployeeCourseEntryInfo info) {
        boolean result = false;
        String trainItemId = "";
        if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info)) {
            trainItemId = info.getTrainItem().getId().toString();
        }
        for (int j = 0; j < entrys.size(); ++j) {
            EmployeeCourseEntryInfo entry = entrys.get(j);
            String itemId = "";
            if (!TrainCommonUtils.isEmpty((CoreBaseInfo)entry.getTrainItem())) {
                itemId = entry.getTrainItem().getId().toString();
            }
            if (!trainItemId.equals(itemId)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getRequiredCourseDataXml(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String employeeId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.isRequired"));
        sic.add(new SelectorItemInfo("entrys.trainItem.*"));
        sic.add(new SelectorItemInfo("entrys.course.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.course.number"));
        sic.add(new SelectorItemInfo("entrys.course.treeid.name"));
        sic.add(new SelectorItemInfo("entrys.course.CourseKind.name"));
        sic.add(new SelectorItemInfo("entrys.course.CourseTarget"));
        sic.add(new SelectorItemInfo("entrys.course.CourseHour"));
        sic.add(new SelectorItemInfo("entrys.course.CourseHourUnit"));
        sic.add(new SelectorItemInfo("entrys.course.Content"));
        sic.add(new SelectorItemInfo("entrys.course.CourseJoinner"));
        sic.add(new SelectorItemInfo("entrys.course.description"));
        for (int i = 0; i < sic.size(); ++i) {
            viewInfo.getSelector().add(sic.get(i));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("employee.id", (Object)employeeId));
        viewInfo.setFilter(filterInfo);
        EmployeeCourseInfo employeeCourseInfo = null;
        EmployeeCourseCollection collection = null;
        EmployeeCourseEntryCollection entryCollection1 = null;
        EmployeeCourseEntryCollection entryCollection2 = null;
        EmployeeCourseEntryCollection entryCollection = null;
        Object xmlData = null;
        int COLS = 12;
        try {
            collection = EmployeeCourseFactory.getLocalInstance(ctx).getEmployeeCourseCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)("TrainSignupUtil.getRequiredCourseDataXml:" + e.getCause()));
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        if (collection != null && collection.size() > 0) {
            employeeCourseInfo = (EmployeeCourseInfo)collection.getObject(0);
            entryCollection1 = employeeCourseInfo.getEntrys();
        }
        try {
            entryCollection2 = EmployeeCourseFactory.getLocalInstance(ctx).getCoursesFromSysCate(employeeId);
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignupUtil.getRequiredCourseDataXml:" + e.getCause()));
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        if (entryCollection1 != null && entryCollection1.size() > 0 && entryCollection2 != null && entryCollection2.size() > 0) {
            EmployeeCourseEntryInfo info = null;
            int size = entryCollection2.size();
            for (int i = 0; i < size; ++i) {
                info = entryCollection2.get(i);
                if (TrainSignupUtil.exist(entryCollection1, info)) continue;
                entryCollection1.add(info);
            }
            entryCollection = entryCollection1;
        } else if (entryCollection1 == null || entryCollection1.size() == 0) {
            entryCollection = entryCollection2;
        }
        if (entryCollection == null || entryCollection.size() == 0) {
            return "<root><reccordcount>0</reccordcount><data></data></root>";
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordInfoQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(evi);
        HashMap<String, String> isPasseds = new HashMap<String, String>();
        try {
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                String courseId = rowSet.getString("TrainCourse.id");
                String isPassed = (String)isPasseds.get(courseId);
                if ("10".equals(isPassed)) continue;
                isPasseds.put(courseId, rowSet.getString("ISPASSED"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignupUtil.getRequiredCourseDataXml:" + e.getCause()));
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        String str = null;
        EmployeeCourseEntryInfo info = null;
        for (int i = entryCollection.size() - 1; i >= 0; --i) {
            info = entryCollection.get(i);
            if (info == null || !"10".equals(str = (String)isPasseds.get(info.getCourse().getId().toString()))) continue;
            entryCollection.removeObject(i);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int index = 1;
        EmployeeCourseEntryInfo entryInfo = null;
        list.add("" + entryCollection.size());
        DecimalFormat format = new DecimalFormat("0.00");
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCollection.get(i);
            String[] array = new String[COLS];
            array[0] = "" + index++;
            array[1] = entryInfo.getTrainItem() != null ? entryInfo.getTrainItem().getName() : "";
            array[2] = entryInfo.isIsRequired() ? ResourceBase.getString((String)RES, (String)"yes", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"no", (Locale)ctx.getLocale());
            if (entryInfo.getCourse() != null) {
                TrainCourseInfo course = entryInfo.getCourse();
                array[3] = course.getName() != null ? course.getName() : "";
                array[4] = course.getTreeid() != null ? course.getTreeid().getName() : "";
                array[5] = course.getCourseKind() != null ? course.getCourseKind().getName() : "";
                array[6] = course.getCourseTarget() != null ? course.getCourseTarget().replaceAll("\n", "") : "";
                array[7] = course.getCourseHour() != null ? format.format(course.getCourseHour()) : "";
                array[8] = course.getCourseHourUnit() != null ? course.getCourseHourUnit().toString() : "";
                array[9] = course.getContent() != null ? course.getContent().replaceAll("\n", "") : "";
                array[10] = course.getCourseJoinner() != null ? course.getCourseJoinner().replaceAll("\n", "") : "";
                array[11] = course.getDescription() != null ? course.getDescription().replaceAll("\n", "") : "";
            } else {
                array[11] = "";
                array[10] = "";
                array[9] = "";
                array[8] = "";
                array[7] = "";
                array[6] = "";
                array[5] = "";
                array[4] = "";
                array[3] = "";
            }
            list.add(array);
        }
        return TrainWebUtils.makeProcDataToXMLData(list, COLS);
    }

    public static String getCourseRecordDataXml(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String employeeId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        int COLS = 14;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordInfoQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(evi);
        String xmlData = null;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        int start = (pageNumber - 1) * pageCount;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            list.add("" + exec.getRowCount());
            IRowSet rowSet = exec.executeQuery(start, pageCount);
            int index = 1;
            DecimalFormat format = new DecimalFormat("0.00");
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = "" + index++;
                array[1] = rowSet.getString("TrainActivity.name");
                array[2] = rowSet.getString("trainItem.name");
                array[3] = rowSet.getString("actAssessMethod.name");
                array[4] = rowSet.getBigDecimal("actAssessScore") != null ? format.format(rowSet.getBigDecimal("actAssessScore")) : "";
                array[5] = rowSet.getString("ACTISPASSED");
                array[6] = rowSet.getString("ACTCONTRACT.CONTRACTNO");
                array[7] = rowSet.getString("ACTCONTRACTTEMP.NAME");
                array[8] = rowSet.getString("ACTCERTIFICATE.NUMBER");
                array[9] = rowSet.getString("ACTCERTIFICATE.NAME");
                array[10] = rowSet.getString("TRAINCOURSE.NAME");
                array[11] = rowSet.getString("ASSESSMETHOD.NAME");
                array[12] = rowSet.getBigDecimal("ASSESSSCORE") != null ? format.format(rowSet.getBigDecimal("ASSESSSCORE")) : "";
                array[13] = rowSet.getString("ISPASSED");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignupUtil.getCourseRecordDataXml:" + e.getCause()));
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
            return xmlData;
        }
        return xmlData;
    }

    public static String getRequiredTrainDataXml(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String employeeId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String sortFieldName = request.getParameter("sortFieldName");
        int sortIndex = -1;
        if (sortFieldName != null && sortFieldName.length() > 0) {
            sortIndex = Integer.parseInt(sortFieldName);
        }
        String sortType = request.getParameter("sortType");
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("employee.id", (Object)employeeId));
        viewInfo.setFilter(filterInfo);
        EmployeeCourseInfo employeeCourseInfo = null;
        EmployeeCourseCollection collection = null;
        EmployeeCourseEntryCollection entryCollection1 = null;
        EmployeeCourseEntryCollection entryCollection2 = null;
        EmployeeCourseEntryCollection entryCollection = null;
        String xmlData = null;
        int COLS = 9;
        try {
            collection = EmployeeCourseFactory.getLocalInstance(ctx).getEmployeeCourseCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)("TrainSignupUtil.getRequiredTrainDataXml:" + e.getMessage()));
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
            return xmlData;
        }
        if (collection != null && collection.size() > 0) {
            employeeCourseInfo = (EmployeeCourseInfo)collection.getObject(0);
            entryCollection1 = employeeCourseInfo.getEntrys();
            TrainSignupUtil.removeRepeatRecord(entryCollection1);
        }
        try {
            entryCollection2 = TrainSignupUtil.getTrainItemFromSysCate(ctx, employeeId);
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignupUtil.getRequiredTrainDataXml:" + e.getMessage()));
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
            return xmlData;
        }
        if (entryCollection1 != null && entryCollection1.size() > 0 && entryCollection2 != null && entryCollection2.size() > 0) {
            EmployeeCourseEntryInfo info = null;
            int size = entryCollection2.size();
            for (int i = 0; i < size; ++i) {
                info = entryCollection2.get(i);
                if (TrainCommonUtils.isEmpty((CoreBaseInfo)info) && TrainSignupUtil.existTrainItem(entryCollection1, info)) continue;
                entryCollection1.add(info);
            }
            entryCollection = entryCollection1;
        } else if (entryCollection1 == null || entryCollection1.size() == 0) {
            entryCollection = entryCollection2;
        }
        if (entryCollection == null || entryCollection.size() == 0) {
            return "<root><reccordcount>0</reccordcount><data></data></root>";
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordItemQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(evi);
        HashMap<String, String> isPasseds = new HashMap<String, String>();
        try {
            IRowSet rowSet = exec.executeQuery();
            String itemId = null;
            String isPassed = null;
            while (rowSet.next()) {
                itemId = rowSet.getString("trainItem.id");
                isPassed = (String)isPasseds.get(itemId);
                if ("10".equals(isPassed)) continue;
                isPasseds.put(itemId, rowSet.getString("actIsPassed"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignupUtil.getRequiredTrainDataXml:" + e.getCause()));
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
            return xmlData;
        }
        String str = null;
        EmployeeCourseEntryInfo info = null;
        for (int i = entryCollection.size() - 1; i >= 0; --i) {
            info = entryCollection.get(i);
            if (info == null || !"10".equals(str = (String)isPasseds.get(info.getTrainItem().getId().toString()))) continue;
            entryCollection.removeObject(i);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int index = 1;
        EmployeeCourseEntryInfo entryInfo = null;
        list.add("" + entryCollection.size());
        TrainItemInfo item = null;
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCollection.get(i);
            Object[] array = new Object[COLS];
            array[0] = "" + index++;
            array[2] = entryInfo.isIsRequired() ? ResourceBase.getString((String)RES, (String)"yes", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"no", (Locale)ctx.getLocale());
            if (entryInfo.getTrainItem() == null) {
                array[1] = "";
            }
            if (entryInfo.getTrainItem() != null) {
                array[1] = entryInfo.getTrainItem().getName();
                item = entryInfo.getTrainItem();
                array[3] = item.getTreeid() != null ? item.getTreeid().getName() : "";
                array[4] = item.getTrainMethod() != null ? item.getTrainMethod().getName() : "";
                array[5] = item.getCourseHour() != null ? item.getCourseHour() : new BigDecimal("-1");
                array[6] = item.getCourseHourUnit() != null ? item.getCourseHourUnit().toString() : "";
                array[7] = item.getCertificateName() != null ? item.getCertificateName() : "";
                array[8] = item.getAdminOrgUnit() != null ? item.getAdminOrgUnit().getName() : "";
            } else {
                array[8] = "";
                array[7] = "";
                array[6] = "";
                array[4] = "";
                array[3] = "";
                array[1] = "";
                array[5] = new BigDecimal("0");
            }
            list.add(array);
        }
        if (sortIndex > -1) {
            ArrayList arrayList = TrainWebUtils.sortStringArray(list, sortIndex, sortType, COLS);
            xmlData = TrainWebUtils.makeProcDataToXMLData(arrayList, COLS);
        } else {
            DecimalFormat format = new DecimalFormat("0.00");
            ArrayList<Object> newList = new ArrayList<Object>();
            newList.add(list.get(0));
            Object[] oArray = null;
            String[] sArray = null;
            int size2 = list.size();
            for (int i = 1; i < size2; ++i) {
                oArray = (Object[])list.get(i);
                sArray = new String[COLS];
                for (int j = 0; j < oArray.length; ++j) {
                    if (j == 5) {
                        if (((BigDecimal)oArray[5]).compareTo(new BigDecimal("-1")) != 0) {
                            sArray[j] = format.format(oArray[5]);
                            continue;
                        }
                        sArray[j] = "";
                        continue;
                    }
                    sArray[j] = oArray[j].toString();
                }
                newList.add(sArray);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(newList, COLS);
        }
        return xmlData;
    }

    private static void removeRepeatRecord(EmployeeCourseEntryCollection entryCollection1) {
        if (entryCollection1 != null && entryCollection1.size() > 0) {
            ArrayList<String> trainItemIds = new ArrayList<String>();
            EmployeeCourseEntryInfo entryInfo = null;
            String trainItemId = null;
            for (int i = 0; i < entryCollection1.size(); ++i) {
                entryInfo = entryCollection1.get(i);
                if (TrainCommonUtils.isEmpty((CoreBaseInfo)entryInfo.getTrainItem())) {
                    entryCollection1.removeObject((IObjectValue)entryInfo);
                    continue;
                }
                trainItemId = entryInfo.getTrainItem().getId().toString();
                if (trainItemIds.contains(trainItemId)) {
                    entryCollection1.removeObject((IObjectValue)entryInfo);
                    continue;
                }
                trainItemIds.add(trainItemId);
            }
        }
    }

    public static String getTrainRecordDataXml(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String employeeId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        int COLS = 14;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        String sortFieldName = request.getParameter("sortFieldName");
        String sortType = request.getParameter("sortType");
        String beginyear = request.getParameter("beginyear");
        String beginmonth = request.getParameter("beginmonth");
        String beginday = request.getParameter("beginday");
        String endyear = request.getParameter("endyear");
        String endmonth = request.getParameter("endmonth");
        String endday = request.getParameter("endday");
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("actTrainType", (Object)"10"));
        if (beginyear != null && beginmonth != null && beginday != null && endyear != null && endmonth != null && endday != null) {
            Date beginDate = new Date(Integer.parseInt(beginyear), Integer.parseInt(beginmonth), Integer.parseInt(beginday), 0, 0, 0);
            Date endDate = new Date(Integer.parseInt(endyear), Integer.parseInt(endmonth), Integer.parseInt(endday), 23, 59, 59);
            filterInfo.getFilterItems().add(new FilterItemInfo("actBeginDate", (Object)endDate, CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("actEndDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        } else {
            Date endDate = new Date();
            endDate.setHours(23);
            endDate.setMinutes(59);
            endDate.setSeconds(59);
            Date beginDate = DateTimeUtils.addMonth((Date)endDate, (int)-2);
            beginDate.setHours(0);
            beginDate.setMinutes(0);
            beginDate.setSeconds(0);
            filterInfo.getFilterItems().add(new FilterItemInfo("actBeginDate", (Object)endDate, CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("actEndDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        }
        evi.setFilter(filterInfo);
        SorterItemInfo sorterItem = null;
        if ("activityNumber".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("TrainActivity.number");
        } else if ("trainActivity".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("TrainActivity.name");
        } else if ("trainCategory".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("trainCategory.name");
        } else if ("trainingCategory".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("trainingCategory.name");
        } else if ("trainItem".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("trainItem.name");
        } else if ("trainCourseCheckMethod".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("actAssessMethod.name");
        } else if ("trainCourseCheckGrade".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("actAssessScore");
        } else if ("isPass".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("actIsPassed");
        } else if ("contractNumber".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("actContract.contractNo");
        } else if ("contractName".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("actContractTemp.name");
        } else if ("certificateNumber".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("actCertificate.number");
        } else if ("certificateName".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("actCertificate.name");
        }
        if (sorterItem != null) {
            if ("desc".equals(sortType)) {
                sorterItem.setSortType(SortType.DESCEND);
            } else {
                sorterItem.setSortType(SortType.ASCEND);
            }
            evi.getSorter().add(sorterItem);
        }
        sorterItem = new SorterItemInfo("actBeginDate");
        sorterItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItem);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainRecordItemQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(evi);
        String xmlData = null;
        int start = (pageNumber - 1) * pageCount;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            int size = exec.getRowCount();
            IRowSet rowSet = exec.executeQuery(start, pageCount);
            while (rowSet.next()) {
                if (rowSet.getString("TrainActivity.id") != null && rowSet.getString("TrainActivity.id").length() != 0 || rowSet.getString("trainItem.id") != null && rowSet.getString("trainItem.id").length() != 0) continue;
                --size;
            }
            rowSet.beforeFirst();
            list.add("" + size);
            int index = 1;
            DecimalFormat format = new DecimalFormat("0.00");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            while (rowSet.next()) {
                if (!(rowSet.getString("TrainActivity.id") != null && rowSet.getString("TrainActivity.id").length() != 0 || rowSet.getString("trainItem.id") != null && rowSet.getString("trainItem.id").length() != 0)) continue;
                String[] array = new String[COLS];
                array[0] = "" + index++;
                array[1] = rowSet.getString("TrainActivity.number");
                array[2] = rowSet.getString("TrainActivity.name");
                array[3] = rowSet.getString("trainCategory.name");
                array[4] = rowSet.getString("trainingCategory.name");
                array[5] = rowSet.getString("trainItem.name");
                array[6] = rowSet.getDate("actBeginDate") != null && rowSet.getDate("actEndDate") != null ? dateFormat.format(rowSet.getDate("actBeginDate")) + ResourceBase.getString((String)RES, (String)"to", (Locale)ctx.getLocale()) + dateFormat.format(rowSet.getDate("actEndDate")) : "";
                array[7] = rowSet.getString("actAssessMethod.name");
                array[8] = rowSet.getBigDecimal("actAssessScore") != null ? format.format(rowSet.getBigDecimal("actAssessScore")) : "";
                array[9] = rowSet.getString("ACTISPASSED");
                array[10] = rowSet.getString("ACTCONTRACT.CONTRACTNO");
                array[11] = rowSet.getString("ACTCONTRACTTEMP.NAME");
                array[12] = rowSet.getString("ACTCERTIFICATE.NUMBER");
                array[13] = rowSet.getString("ACTCERTIFICATE.NAME");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignupUtil.getTrainRecordDataXml:" + e.getMessage()));
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
            return xmlData;
        }
        return xmlData;
    }

    public static String getOuterRecordDataXml(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String employeeId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        int COLS = 12;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        String sortFieldName = request.getParameter("sortFieldName");
        String sortType = request.getParameter("sortType");
        String beginyear = request.getParameter("beginyear");
        String beginmonth = request.getParameter("beginmonth");
        String beginday = request.getParameter("beginday");
        String endyear = request.getParameter("endyear");
        String endmonth = request.getParameter("endmonth");
        String endday = request.getParameter("endday");
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)employeeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("trainType", (Object)"20"));
        if (beginyear != null && beginmonth != null && beginday != null && endyear != null && endmonth != null && endday != null) {
            Date beginDate = new Date(Integer.parseInt(beginyear), Integer.parseInt(beginmonth), Integer.parseInt(beginday), 0, 0, 0);
            Date endDate = new Date(Integer.parseInt(endyear), Integer.parseInt(endmonth), Integer.parseInt(endday), 23, 59, 59);
            filterInfo.getFilterItems().add(new FilterItemInfo("BeginDateTime", (Object)endDate, CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("EndDateTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        } else {
            Date endDate = new Date();
            endDate.setHours(23);
            endDate.setMinutes(59);
            endDate.setSeconds(59);
            Date beginDate = DateTimeUtils.addMonth((Date)endDate, (int)-2);
            beginDate.setHours(0);
            beginDate.setMinutes(0);
            beginDate.setSeconds(0);
            filterInfo.getFilterItems().add(new FilterItemInfo("BeginDateTime", (Object)endDate, CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("EndDateTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        }
        evi.setFilter(filterInfo);
        SorterItemInfo sorterItem = null;
        if ("courseNumber".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("TrainCourse.number");
        } else if ("courseName".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("TrainCourse.name");
        } else if ("trainSort".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("trainCategory.name");
        } else if ("trainType".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("trainingCategory.name");
        } else if ("courseType".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("TrainCourseTree.name");
        } else if ("needExam".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("NeedExam");
        } else if ("trainCourseCheckGrade".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("AssessScore");
        } else if ("isPass".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("isPassed");
        } else if ("attendAll".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("attendAll");
        } else if ("TrainCost".equals(sortFieldName)) {
            sorterItem = new SorterItemInfo("CourseCost");
        }
        if (sorterItem != null) {
            if ("desc".equals(sortType)) {
                sorterItem.setSortType(SortType.DESCEND);
            } else {
                sorterItem.setSortType(SortType.ASCEND);
            }
            evi.getSorter().add(sorterItem);
        }
        sorterItem = new SorterItemInfo("BeginDateTime");
        sorterItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItem);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainOuterRecordQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(evi);
        String xmlData = null;
        int start = (pageNumber - 1) * pageCount;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IRowSet rowSet = exec.executeQuery(start, pageCount);
            list.add("" + exec.getRowCount());
            int index = 1;
            DecimalFormat format = new DecimalFormat("0.00");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String yes = ResourceBase.getString((String)RES, (String)"yes", (Locale)ctx.getLocale());
            String no = ResourceBase.getString((String)RES, (String)"no", (Locale)ctx.getLocale());
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = "" + index++;
                array[1] = rowSet.getString("TrainCourse.number");
                array[2] = rowSet.getString("TrainCourse.name");
                array[3] = rowSet.getString("trainCategory.name");
                array[4] = rowSet.getString("trainingCategory.name");
                array[5] = rowSet.getString("TrainCourseTree.name");
                array[6] = rowSet.getDate("BeginDateTime") != null && rowSet.getDate("EndDateTime") != null ? dateFormat.format(rowSet.getDate("BeginDateTime")) + ResourceBase.getString((String)RES, (String)"to", (Locale)ctx.getLocale()) + dateFormat.format(rowSet.getDate("EndDateTime")) : "";
                array[7] = rowSet.getBoolean("NeedExam") ? yes : no;
                array[8] = rowSet.getBigDecimal("AssessScore") != null ? format.format(rowSet.getBigDecimal("AssessScore")) : "";
                array[9] = rowSet.getString("isPassed");
                array[10] = rowSet.getBoolean("attendAll") ? yes : no;
                array[11] = rowSet.getString("CourseCost");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignupUtil.getTrainRecordDataXml:" + e.getMessage()));
            xmlData = TrainWebUtils.makeErrorProcDataToXMLData(COLS);
            return xmlData;
        }
        return xmlData;
    }

    public static EmployeeCourseEntryCollection getTrainItemFromSysCate(Context ctx, String employeeId) throws BOSException {
        Set[] positions = TrainSignupUtil.getPositions(ctx, employeeId);
        Set technicals = TrainSignupUtil.getTechnicals(ctx, employeeId);
        String jobGradeId = TrainSignupUtil.getPersonJobGrade(ctx, employeeId);
        IRowSet rowSet = TrainSignupUtil.getSysCateCourses(ctx, positions, technicals, jobGradeId);
        return TrainSignupUtil.assembleEmployeeCourseEntrys(rowSet);
    }

    public static Set[] getPositions(Context ctx, String employeeId) throws BOSException {
        HashSet[] result = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.job.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)employeeId));
        viewInfo.setFilter(filterInfo);
        PositionMemberCollection collection = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            result = new HashSet[2];
            HashSet<String> positionIds = new HashSet<String>();
            HashSet<String> jobIds = new HashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                PositionMemberInfo info = collection.get(i);
                if (info.getPosition() == null || info.getPosition().getId() == null) continue;
                positionIds.add(info.getPosition().getId().toString());
                if (info.getPosition().getJob() == null || info.getPosition().getJob().getId() == null) continue;
                jobIds.add(info.getPosition().getJob().getId().toString());
            }
            if (positionIds.size() > 0) {
                result[0] = positionIds;
            }
            if (jobIds.size() > 0) {
                result[1] = jobIds;
            }
        }
        return result;
    }

    public static Set getTechnicals(Context ctx, String employeeId) throws BOSException {
        HashSet<String> result = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("technicalPost.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)employeeId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isHighTechnical", (Object)1));
        viewInfo.setFilter(filterInfo);
        PersonTechnicalPostCollection collection = PersonTechnicalPostFactory.getLocalInstance((Context)ctx).getPersonTechnicalPostCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            result = new HashSet<String>();
            PersonTechnicalPostInfo info = collection.get(0);
            if (info.getTechnicalPost() != null && info.getTechnicalPost().getId() != null) {
                result.add(info.getTechnicalPost().getId().toString());
            }
        }
        return result;
    }

    public static String getPersonJobGrade(Context ctx, String employeeId) throws BOSException {
        PersonPositionInfo personPositionInfo;
        String jobGradeId = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("jobGrade.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)employeeId));
        viewInfo.setFilter(filterInfo);
        PersonPositionCollection collection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(viewInfo);
        if (collection.size() > 0 && (personPositionInfo = collection.get(0)).getJobGrade() != null && personPositionInfo.getJobGrade().getId() != null) {
            jobGradeId = personPositionInfo.getJobGrade().getId().toString();
        }
        return jobGradeId;
    }

    public static IRowSet getSysCateCourses(Context ctx, Set[] positions, Set technicals, String jobGradeId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (positions != null) {
            if (positions[0] != null && positions[0].size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("PostionEntry.Position.id", (Object)positions[0], CompareType.INCLUDE));
            }
            if (positions[1] != null && positions[1].size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("JobEntry.Job.id", (Object)positions[1], CompareType.INCLUDE));
            }
        }
        if (technicals != null && technicals.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("TechPostEntry.TechPost.id", (Object)technicals, CompareType.INCLUDE));
        }
        if (jobGradeId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("JobGrade.id", (Object)jobGradeId, CompareType.EQUALS));
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                if (i != 0) {
                    str.append(" or ");
                }
                str.append("#");
                str.append(i);
            }
            filterInfo.setMaskString(str.toString());
            filterInfo.mergeFilter(TrainUtilsServer.getHRFilterInfo(ctx, "HrOrgUnit.id"), "AND");
        } else {
            filterInfo = TrainUtilsServer.getHRFilterInfo(ctx, "HrOrgUnit.id");
        }
        viewInfo.setFilter(filterInfo);
        viewInfo.getSorter().add(new SorterItemInfo("trainItem.id"));
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.train.app", "SysCateTrainItemQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)iqec.getSQL());
        return rowSet;
    }

    public static EmployeeCourseEntryCollection assembleEmployeeCourseEntrys(IRowSet rowSet) throws BOSException {
        EmployeeCourseEntryCollection result = new EmployeeCourseEntryCollection();
        try {
            rowSet.beforeFirst();
            EmployeeCourseEntryInfo entry = null;
            TrainItemInfo trainItem = null;
            TrainCourseInfo course = null;
            while (rowSet.next()) {
                String trainItemId = rowSet.getString("trainItem.id");
                if (trainItemId == null || trainItemId.length() == 0) continue;
                entry = new EmployeeCourseEntryInfo();
                trainItem = new TrainItemInfo();
                trainItem.setId(BOSUuid.read((String)trainItemId));
                trainItem.setName(rowSet.getString("trainItem.name"));
                if (rowSet.getString("trainItemTree.id") != null) {
                    TrainItemTreeInfo tree = new TrainItemTreeInfo();
                    tree.setId(BOSUuid.read((String)rowSet.getString("trainItemTree.id")));
                    tree.setName(rowSet.getString("trainItemTree.name"));
                    trainItem.setTreeid(tree);
                }
                if (rowSet.getString("trainingMethod.id") != null) {
                    TrainingMethodInfo method = new TrainingMethodInfo();
                    method.setId(BOSUuid.read((String)rowSet.getString("trainingMethod.id")));
                    method.setName(rowSet.getString("trainingMethod.name"));
                    trainItem.setTrainMethod(method);
                }
                if (rowSet.getString("trainItem.courseHour") != null) {
                    trainItem.setCourseHour(new BigDecimal(rowSet.getString("trainItem.courseHour")));
                }
                trainItem.setCourseHourUnit(CourseHourUnitEnum.getEnum(rowSet.getInt("trainItem.courseHourUnit")));
                trainItem.setCertificateName(rowSet.getString("trainItem.certificateName"));
                if (rowSet.getString("adminOrgUnit.id") != null) {
                    AdminOrgUnitInfo orgUnit = new AdminOrgUnitInfo();
                    orgUnit.setId(BOSUuid.read((String)rowSet.getString("adminOrgUnit.id")));
                    orgUnit.setName(rowSet.getString("adminOrgUnit.name"));
                    trainItem.setAdminOrgUnit(orgUnit);
                }
                entry.setTrainItem(trainItem);
                entry.setIsRequired(rowSet.getBoolean("CourseEntry.IsRequired"));
                entry.setFromSysCate(true);
                course = new TrainCourseInfo();
                course.setId(BOSUuid.read((String)rowSet.getString("TrainCourse.id")));
                entry.setCourse(course);
                if (TrainSignupUtil.isExist(entry, result)) continue;
                result.add(entry);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return result;
    }

    public static boolean isExist(EmployeeCourseEntryInfo entry, EmployeeCourseEntryCollection collection) {
        boolean result = false;
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                EmployeeCourseEntryInfo info = collection.get(i);
                String entryItemId = "";
                if (entry.getTrainItem() != null) {
                    entryItemId = entry.getTrainItem().getId().toString();
                }
                String infoItemId = "";
                if (info.getTrainItem() != null) {
                    infoItemId = info.getTrainItem().getId().toString();
                }
                if (!entryItemId.equals(infoItemId)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String getTrainCourseTreeScript(String treeName, HttpServletRequest request) {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            StringBuffer sb = new StringBuffer();
            FilterInfo filter = null;
            EntityViewInfo viewInfo = new EntityViewInfo();
            CtrlUnitInfo cui = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String cuID = cui.getId().toString();
            String cuLongNumber = cui.getLongNumber();
            filter = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cuID, (String)cuLongNumber);
            viewInfo.setFilter(filter);
            SorterItemCollection sorter = viewInfo.getSorter();
            sorter.add(new SorterItemInfo("longNumber"));
            TrainCourseTreeCollection coll = TrainCourseTreeFactory.getLocalInstance(ctx).getTrainCourseTreeCollection(viewInfo);
            if (coll.size() == 0) {
                return null;
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            String currentVar = "";
            String parentVar = "";
            currentVar = "course_type_0";
            sb.append("var " + currentVar + "=" + treeName + ".AddNode(null,null,0,'" + ResourceBase.getString((String)RES, (String)"courseType", (Locale)ctx.getLocale()) + "','tree_folder_close.gif','root','tree_folder_open.gif','true','true',false);");
            sb.append("\n");
            int pid = 0;
            String id = null;
            String name = null;
            int n = coll.size();
            for (int i = 1; i <= n; ++i) {
                id = coll.get(i - 1).getId().toString();
                name = coll.get(i - 1).getName();
                pid = coll.get(i - 1).getParent() != null && map.get(coll.get(i - 1).getParent().getId().toString()) != null ? (Integer)map.get(coll.get(i - 1).getParent().getId().toString()) : 0;
                currentVar = "course_type_" + i;
                parentVar = "course_type_" + pid;
                sb.append("var " + currentVar + "=" + treeName + ".AddNode(" + parentVar + ",null," + i + ",'" + name + "','tree_folder_close.gif','" + id + "','tree_folder_open.gif','true','true',false);");
                sb.append("\n");
                map.put(id, i);
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignUtil.getTrainCourseTree:" + e.getMessage()), e.getCause());
            return null;
        }
    }

    public static TrainActCourseCollection getTrainActCourse(HttpServletRequest request, String trainActID) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            ITrainActCourse trainActCourse = TrainActCourseFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            if (trainActID != null) {
                fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActID));
            }
            if (ContextUtil.getCurrentCtrlUnit((Context)ctx) != null) {
                fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
            }
            evi.setFilter(fi);
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("TrainCourse.id"));
            evi.getSelector().add(new SelectorItemInfo("TrainCourse.name"));
            TrainActCourseCollection coll = trainActCourse.getTrainActCourseCollection(evi);
            return coll;
        }
        catch (BOSException e) {
            return null;
        }
    }

    public static String getTrainSignupStuListDataXML(HttpServletRequest request) {
        String xmlData = null;
        int COLS = 14;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String trainActID = request.getParameter("trainActID");
        String trainCourseID = request.getParameter("trainCourseID");
        boolean isFormal = Boolean.valueOf(request.getParameter("isFormal"));
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        int start = (pageNumber - 1) * pageCount;
        if (trainActID == null) {
            logger.error((Object)"TrainSignupUtil.getTrainSignupStuListDataXML:trainActID is null.");
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActID.replaceAll(" ", "+")));
        StringBuffer stuSQL = new StringBuffer();
        if (trainCourseID != null && !"selectAll".equals(trainCourseID) && !"null".equalsIgnoreCase(trainCourseID)) {
            filter.getFilterItems().add(new FilterItemInfo("trainCourse.id", (Object)trainCourseID.replaceAll(" ", "+")));
            stuSQL.append("select FPersonID from T_HR_TrainStudentCourse stuCourse");
            stuSQL.append(" left outer join T_HR_TrainActCourse actCourse on stuCourse.FTrainActCourseID=actCourse.FID");
            stuSQL.append(" where FTrainActivityID='");
            stuSQL.append(trainActID.replaceAll(" ", "+"));
            stuSQL.append("'");
            stuSQL.append(" and actCourse.FTrainCourseID='");
            stuSQL.append(trainCourseID.replaceAll(" ", "+"));
            stuSQL.append("'");
            stuSQL.append(" and stuCourse.FType = ");
            stuSQL.append(10);
            if (isFormal) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)stuSQL.toString(), CompareType.INNER));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)stuSQL.toString(), CompareType.NOTINNER));
            }
        } else {
            Set allPersonIds = null;
            try {
                allPersonIds = TrainActivityFacadeFactory.getLocalInstance(ctx).getSignupAllPerson(trainActID.replaceAll(" ", "+"));
                if (allPersonIds != null && allPersonIds.size() > 0) {
                    stuSQL.append("select DISTINCT person.FID from T_BD_PERSON person");
                    stuSQL.append(" left outer join T_HR_TrainStudentCourse stuCourse on stuCourse.FPersonID = person.FID");
                    stuSQL.append(" left outer join T_HR_TrainActCourse actCourse on stuCourse.FTrainActCourseID = actCourse.FID");
                    stuSQL.append(" where person.FID in ");
                    stuSQL.append("(");
                    stuSQL.append(TrainCommonUtils.collectionToStrings(allPersonIds));
                    stuSQL.append(")");
                    stuSQL.append(" and actCourse.FTrainActivityID = ");
                    stuSQL.append("'");
                    stuSQL.append(trainActID.replaceAll(" ", "+"));
                    stuSQL.append("'");
                    stuSQL.append(" and stuCourse.FType = ");
                    stuSQL.append(10);
                }
            }
            catch (Exception e) {
                logger.info((Object)e.getCause());
            }
            if (stuSQL.length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)allPersonIds, CompareType.INCLUDE));
                if (isFormal) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)stuSQL.toString(), CompareType.INNER));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)stuSQL.toString(), CompareType.NOTINNER));
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", null));
            }
        }
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "PersonPositionAdminTrainActCourseQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.setObjectView(viewInfo);
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IRowSet rowSet = exec.executeQuery(start, pageCount);
            list.add("" + exec.getRowCount());
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = rowSet.getString("id");
                array[1] = isFormal ? ResourceBase.getString((String)RES, (String)"formal", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RES, (String)"reserve", (Locale)ctx.getLocale());
                array[2] = TrainUtilsServer.getWebLegendStringValue(rowSet, "number");
                array[3] = TrainUtilsServer.getWebLegendStringValue(rowSet, "name");
                array[4] = TrainUtilsServer.getWebLegendStringValue(rowSet, "gender");
                array[5] = TrainUtilsServer.getWebLegendStringValue(rowSet, "orgUnit");
                array[6] = TrainUtilsServer.getWebLegendStringValue(rowSet, "positionName");
                array[7] = TrainUtilsServer.getWebLegendStringValue(rowSet, "job");
                array[8] = TrainUtilsServer.getWebLegendStringValue(rowSet, "technicalPost");
                array[9] = TrainUtilsServer.getWebLegendStringValue(rowSet, "jobGrade.name");
                array[10] = TrainUtilsServer.getWebLegendStringValue(rowSet, "degree.name");
                array[11] = TrainUtilsServer.getWebLegendStringValue(rowSet, "officePhone");
                array[12] = TrainUtilsServer.getWebLegendStringValue(rowSet, "cell");
                array[13] = TrainUtilsServer.getWebLegendStringValue(rowSet, "email");
                list.add(array);
            }
            xmlData = TrainWebUtils.makeProcDataToXMLData(list, COLS);
            return xmlData;
        }
        catch (Exception e) {
            logger.error((Object)("TrainSignupUtil.getTrainSignupStuListDataXML:" + e.getMessage()), e.getCause());
            return TrainWebUtils.makeErrorProcDataToXMLData(COLS);
        }
    }
}

