/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.arap.app.CloseAccountService;
import com.kingdee.eas.ma.arap.app.UnCloseAccountService;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ArapClosePeriodService {
    private Context ctx;

    public ArapClosePeriodService(Context ctx) {
        this.ctx = ctx;
    }

    public Map getData(Map map) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        LinkedList data = new LinkedList();
        result.put("rows", data);
        String loc = this.ctx.getLocale().toString();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.ctx);
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId();
        FullOrgUnitCollection orgs = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.ProfitCenter, null, this.getPermission());
        if (orgs == null || orgs.size() == 0) {
            return result;
        }
        StringBuffer orgFilter = new StringBuffer();
        orgFilter.append("(");
        int length = orgs.size();
        for (int i = 0; i < length; ++i) {
            orgFilter.append("'" + orgs.get(i).getId() + "',");
        }
        orgFilter.deleteCharAt(orgFilter.length() - 1);
        orgFilter.append(")");
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    sc.FID, \n");
        sql.append("    c.FID FOrgID, c.FNumber FOrgNumber, c.FName_" + loc + " FOrgName, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber FPeriodMonth \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_ProfitCenter c on c.FID = sc.FProfitCenterID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append(" and sc.fisstart = 1");
        sql.append("    and s.FName =  ").append(1007);
        sql.append("    and c.FID in " + orgFilter + " \n");
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                String id = rowSet.getString("FID");
                String orgId = rowSet.getString("FOrgID");
                String orgName = rowSet.getString("FOrgName");
                String periodId = rowSet.getString("FPeriodID");
                String periodMonth = rowSet.getString("FPeriodMonth");
                String periodYear = rowSet.getString("FPeriodYear");
                if (periodMonth != null && periodMonth.toString().length() == 1) {
                    periodMonth = "0" + periodMonth;
                }
                String periodName = periodYear + "\u5e74" + periodMonth + "\u671f";
                dataMap.put("id", id);
                dataMap.put("profitCenterID", orgId);
                dataMap.put("profitCenterName", orgName);
                dataMap.put("periodID", periodId);
                dataMap.put("periodName", periodName);
                data.add(dataMap);
            }
            result.put("rows", data);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public Map closePeriod(Map map) throws EASBizException, BOSException {
        PeriodInfo periodInfo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String profitCenterid = map.get("orgId").toString();
        String currPeriodid = map.get("periodId").toString();
        ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)this.ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterid));
        List errors = this.checkcanClose(profitCenter, periodInfo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(currPeriodid)), map);
        if (errors.size() > 0) {
            result.put("errors", errors);
            return result;
        }
        boolean ischeck = Boolean.parseBoolean(map.get("ischeck").toString());
        if (!ischeck) {
            CloseAccountService closeAccount = new CloseAccountService(this.ctx);
            closeAccount.doing(profitCenterid);
            int system = 1007;
            PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitCurrentPeriod(system, profitCenterid);
            String periodYear = String.valueOf(currentPeriod.getPeriodYear());
            String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
            if (periodMonth != null && periodMonth.toString().length() == 1) {
                periodMonth = "0" + periodMonth;
            }
            String periodName = periodYear + "\u5e74" + periodMonth + "\u671f";
            result.put("periodId", currentPeriod.getId().toString());
            result.put("periodName", periodName);
        }
        result.put("status", "success");
        return result;
    }

    public Map unClosePeriod(Map map) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        String profitCenterid = map.get("orgId").toString();
        String currPeriodid = map.get("periodId").toString();
        ProfitCenterOrgUnitInfo profitCenterInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)this.ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterid));
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(currPeriodid));
        errors = this.checkcanUnClose(profitCenterInfo, periodInfo, map);
        if (errors.size() > 0) {
            result.put("errors", errors);
            return result;
        }
        UnCloseAccountService unCloseAccountService = new UnCloseAccountService(this.ctx);
        HashMap<String, Object> inParam = new HashMap<String, Object>();
        inParam.put("profitCenter", profitCenterInfo);
        inParam.put("currPeriod", periodInfo);
        unCloseAccountService.doing(inParam);
        int system = 1007;
        PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitCurrentPeriod(system, profitCenterid);
        String periodYear = String.valueOf(currentPeriod.getPeriodYear());
        String periodMonth = String.valueOf(currentPeriod.getPeriodNumber());
        if (periodMonth != null && periodMonth.toString().length() == 1) {
            periodMonth = "0" + periodMonth;
        }
        String periodName = periodYear + "\u5e74" + periodMonth + "\u671f";
        result.put("periodId", currentPeriod.getId().toString());
        result.put("periodName", periodName);
        result.put("status", "success");
        return result;
    }

    private String getPermission() {
        String permission = null;
        return permission;
    }

    private List checkcanClose(ProfitCenterOrgUnitInfo profitCenter, PeriodInfo currPeriod, Map condition) throws EASBizException, BOSException {
        int errorIndex = 0;
        String id = (String)condition.get("id");
        ArrayList errors = new ArrayList();
        Date bigenDate = currPeriod.getBeginDate();
        Timestamp endDate = currPeriod.getEndDate();
        String beginDateStr = this.convertDateToString(bigenDate);
        String endDateStr = this.convertDateToString(endDate);
        String profitCenterID = profitCenter.getId().toString();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select fid from t_map_bizRelatedBIll where FProfitCenterOrgID = '").append(profitCenterID).append("'").append(" and fbizDate >{").append(beginDateStr).append("} and fbizDate<{").append(endDateStr).append("}").append(" and fstatus<30");
        String sql = sqlBuilder.toString();
        IRowSet rowset = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            if (rowset.next()) {
                HashMap<String, Object> error = new HashMap<String, Object>();
                error.put("status", "error");
                error.put("id", id + "_" + ++errorIndex);
                error.put("profitCenterName", "\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5355\u636e\uff01");
                error.put("operation", "\u5904\u7406");
                error.put("isError", true);
                error.put("periodId", currPeriod.getId().toString());
                error.put("orgId", profitCenter.getId().toString());
                errors.add(error);
            }
        }
        catch (SQLException e) {
            throw new BOSException("\u6570\u636e\u5e93\u5f02\u5e38\uff01");
        }
        return errors;
    }

    private List checkcanUnClose(ProfitCenterOrgUnitInfo profitCenter, PeriodInfo currPeriod, Map condition) throws BOSException, EASBizException {
        String id = (String)condition.get("id");
        ArrayList errors = new ArrayList();
        int errorIndex = 0;
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        PeriodInfo startPeriod = iSystemStatusCtrol.getProfitStartPeriod(1007, profitCenter.getId().toString());
        if (currPeriod.equals((Object)startPeriod)) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("isError", true);
            error.put("profitCenterName", "\u5f53\u524d\u671f\u95f4\u7b49\u4e8e\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26");
            errors.add(error);
            return errors;
        }
        return errors;
    }

    private String convertDateToString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }
}

