/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.app.CalUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArapUtils {
    public static String getSqlIDs(Set<String> idSet) {
        StringBuilder sb = new StringBuilder();
        if (idSet == null || idSet.size() == 0) {
            return "";
        }
        for (String pk : idSet) {
            if (sb.length() > 0) {
                sb.append(",'").append(pk).append("'");
                continue;
            }
            sb.append("'").append(pk).append("'");
        }
        return sb.toString();
    }

    public static String getCUID(Context ctx, ProfitCenterOrgUnitInfo profitCenter) throws EASBizException, BOSException {
        if (profitCenter.getParent() == null) {
            profitCenter = CalUtils.getProfitCenter((Context)ctx, (String)profitCenter.getId().toString(), (String[])new String[]{"id", "parent", "isCU"});
        }
        ProfitCenterOrgUnitInfo parentOrg = profitCenter.getParent();
        parentOrg = CalUtils.getProfitCenter((Context)ctx, (String)parentOrg.getId().toString(), (String[])new String[]{"id", "parent", "isCU"});
        while (!parentOrg.isIsCU()) {
            parentOrg = parentOrg.getParent();
            parentOrg = CalUtils.getProfitCenter((Context)ctx, (String)parentOrg.getId().toString(), (String[])new String[]{"id", "parent", "isCU"});
        }
        return parentOrg.getId().toString();
    }

    public static String getRelatedCompanyId(Context ctx, String profitCenterId) throws BOSException {
        if (profitCenterId == null || profitCenterId.length() <= 0) {
            return "";
        }
        HashSet<String> idSet = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        idSet.add(profitCenterId);
        Set<String> companyIds = ArapUtils.getRelatedCompanyIds(ctx, idSet);
        Object companyId = null;
        Iterator<String> it = companyIds.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return "";
    }

    public static Set<String> getRelatedCompanyIds(Context ctx, Set<String> profitCenterIds) throws BOSException {
        if (profitCenterIds == null || profitCenterIds.size() <= 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select rel.ftounitid  fcompanyid from T_ORG_UnitRelation rel ");
        sql.append(" inner join t_org_typerelation typeRel on typeRel.fid = rel.ftyperelationid ");
        sql.append(" and rel.ffromunitid in (").append(ArapUtils.getSqlIDs(profitCenterIds)).append(")");
        sql.append(" and typeRel.ftotype = ").append(1);
        sql.append(" and typeRel.ffromtype = ").append(6);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String companyID = rs.getString("fcompanyid");
                set.add(companyID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return set;
    }

    public static Map<String, PeriodInfo> getPeriod(Context ctx, String[] orgids, int systemEnum) throws BOSException, EASBizException {
        String profitCenterid2 = null;
        PeriodInfo periodInfo = null;
        HashMap<String, PeriodInfo> periodMap = new HashMap<String, PeriodInfo>();
        ISystemStatusCtrol iSystemStatusCtrol = null;
        iSystemStatusCtrol = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        for (String profitCenterid2 : orgids) {
            if (StringUtils.isEmpty((String)profitCenterid2)) continue;
            periodInfo = iSystemStatusCtrol.getProfitCurrentPeriod(systemEnum, profitCenterid2);
            periodMap.put(profitCenterid2, periodInfo);
        }
        return periodMap;
    }

    public static SelectorItemCollection getProfitCenterSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isSealUp"));
        sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("isAssistantOrg"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        sic.add(new SelectorItemInfo("SimpleName"));
        sic.add(new SelectorItemInfo("orgTypeStr"));
        return sic;
    }

    public static Date getDate(Date oldDate, int day) throws BOSException, EASBizException {
        Date date = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(oldDate);
        cal.add(5, day);
        date = cal.getTime();
        return date;
    }
}

