/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.arap.BalancebillException;
import com.kingdee.eas.ma.arap.BalancebillFactory;
import com.kingdee.eas.ma.arap.BalancebillInfo;
import com.kingdee.eas.ma.arap.SettlementTypeEnum;
import com.kingdee.eas.ma.arap.app.ArapUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class BalanceBillImport
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger(BalanceBillImport.class);

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BalancebillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getType(), (Throwable)e);
        }
    }

    protected String getType() {
        return "balanceBill";
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BalancebillInfo infos = new BalancebillInfo();
        Map pageParam = super.getContextMap();
        try {
            SettlementTypeEnum settleType;
            AccountViewInfo account;
            PersonInfo personInfo;
            String exchangeRate;
            ProfitCenterOrgUnitInfo profitCenterInfo = this.getProfitCenter(ctx, hsData);
            if (profitCenterInfo != null) {
                infos.setProfitCenterOrgUnit(profitCenterInfo);
            }
            CtrlUnitInfo ctrlUnit = this.getCU(ctx, profitCenterInfo);
            infos.setCU(ctrlUnit);
            CompanyOrgUnitInfo company = this.getCompany(ctx, hsData, profitCenterInfo.getId().toString());
            infos.setCompanyOrgUnit(company);
            CurrencyInfo currency = this.getCurrency(ctx, hsData);
            if (currency != null) {
                infos.setCurrency(currency);
            }
            if ((exchangeRate = ((DataToken)hsData.get((Object)"FExchangeRate")).data.toString()) != null && !"".equals(exchangeRate)) {
                infos.setExchangeRate(new BigDecimal(exchangeRate));
            }
            AsstActTypeInfo asstActTypeInfo = this.getAsstActType(ctx, hsData);
            infos.setAsstActType(asstActTypeInfo);
            this.setAsstAct(ctx, hsData, asstActTypeInfo, infos);
            AdminOrgUnitInfo adminOrgUnitInfo = this.getAdmin(ctx, hsData);
            if (adminOrgUnitInfo != null) {
                infos.setAdminOrgUnit(adminOrgUnitInfo);
            }
            if ((personInfo = this.getPerson(ctx, hsData)) != null) {
                infos.setPerson(personInfo);
            }
            if ((account = this.getAccount(ctx, hsData)) != null) {
                infos.setAccount(account);
            }
            if ((settleType = this.getSettlementType(ctx, hsData)) != null) {
                infos.setSettlementType(settleType);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FBeginAmount")).data)) {
                infos.setBeginAmount(this.getValue(hsData.get("FBeginAmount")));
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FBeginAmountLocal")).data)) {
                infos.setBeginAmountLocal(this.getValue(hsData.get("FBeginAmountLocal")));
            }
            return infos;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected BigDecimal getValue(Object data) {
        return new BigDecimal(((DataToken)data).data.toString().trim());
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }

    protected boolean CheckString(Object values) {
        boolean check = true;
        if (values != null) {
            String value = String.valueOf(values);
            if (value.length() <= 0) {
                check = false;
            }
        } else {
            check = false;
        }
        return check;
    }

    public ProfitCenterOrgUnitInfo getProfitCenter(Context ctx, Hashtable hsData) throws Exception, BOSException {
        Map pageParam = super.getContextMap();
        ProfitCenterOrgUnitInfo profitCenterInfo = null;
        IProfitCenterOrgUnit profitCenterOrgUnit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        HashSet<String> numSet = new HashSet<String>();
        HashMap<String, ProfitCenterOrgUnitInfo> profitMap = new HashMap<String, ProfitCenterOrgUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)ArapUtils.getProfitCenterSic());
        if (pageParam != null && pageParam.get("FProfitCenterID") != null) {
            String profitCenterIds = pageParam.get("FProfitCenterID").toString();
            String[] profitArr = null;
            if (profitCenterIds.contains(",")) {
                profitArr = profitCenterIds.split(",");
                for (int i = 0; i < profitArr.length; ++i) {
                    profitCenterInfo = profitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitArr[i]), sic);
                    numSet.add(profitCenterInfo.getNumber());
                    profitMap.put(profitCenterInfo.getNumber(), profitCenterInfo);
                }
            } else {
                profitCenterInfo = profitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterIds), sic);
                numSet.add(profitCenterInfo.getNumber());
                profitMap.put(profitCenterInfo.getNumber(), profitCenterInfo);
            }
        } else {
            profitCenterInfo = ContextUtil.getCurrentProfitUnit((Context)ctx);
            if (profitCenterInfo != null) {
                numSet.add(profitCenterInfo.getNumber());
                profitMap.put(profitCenterInfo.getNumber(), profitCenterInfo);
            }
        }
        String profitCenterID = ((DataToken)hsData.get((Object)"FProfitCenterID")).data.toString();
        if (!numSet.contains(profitCenterID)) {
            throw new BalancebillException(BalancebillException.BALANCEBILLNOTCURPROFIT);
        }
        return (ProfitCenterOrgUnitInfo)profitMap.get(profitCenterID);
    }

    private CtrlUnitInfo getCU(Context ctx, ProfitCenterOrgUnitInfo profitCenter) throws Exception {
        String cuid = ArapUtils.getCUID(ctx, profitCenter);
        CtrlUnitInfo ctrlUnit = new CtrlUnitInfo();
        ctrlUnit.setId(BOSUuid.read((String)cuid));
        return ctrlUnit;
    }

    public CompanyOrgUnitInfo getCompany(Context ctx, Hashtable hsData, String profitCenterId) throws UuidException, SQLException, Exception {
        CompanyOrgUnitInfo unitInfo = null;
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        String companyId = ArapUtils.getRelatedCompanyId(ctx, profitCenterId);
        String orgUnitID = ((DataToken)hsData.get((Object)"FCompanyOrgUnitID")).data.toString();
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)ArapUtils.getProfitCenterSic());
        unitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        if (!unitInfo.getNumber().equals(orgUnitID)) {
            throw new BalancebillException(BalancebillException.BALANCEBILLNOTCURCOMAPANY);
        }
        return unitInfo;
    }

    public CurrencyInfo getCurrency(Context ctx, Hashtable hsData) throws Exception, BOSException {
        CurrencyInfo currency = null;
        String currencyID = ((DataToken)hsData.get((Object)"FCurrencyID")).data.toString();
        String sql = "select id where number='" + currencyID + "'";
        CurrencyCollection curCol = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(sql);
        if (curCol == null || curCol.size() <= 0) {
            throw new BalancebillException(BalancebillException.BALANCEBILLNOCURRENCY);
        }
        currency = curCol.get(0);
        return currency;
    }

    private AsstActTypeInfo getAsstActType(Context ctx, Hashtable hsData) throws Exception, BOSException {
        AsstActTypeInfo asstActTypeInfo = null;
        String asstActTypeID = ((DataToken)hsData.get((Object)"FAsstActTypeID")).data.toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)asstActTypeID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        AsstActTypeCollection curCol = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(viewInfo);
        if (curCol == null || curCol.size() <= 0) {
            throw new BalancebillException(BalancebillException.BALANCEBILLNOASSTACTTYPE);
        }
        asstActTypeInfo = curCol.get(0);
        return asstActTypeInfo;
    }

    private void setAsstAct(Context ctx, Hashtable hsData, AsstActTypeInfo asstActType, BalancebillInfo info) throws Exception, BOSException {
        String asstActID = null;
        String asstActName = null;
        StringBuilder sqlBD = new StringBuilder();
        String asstActNumber = ((DataToken)hsData.get((Object)"FAsstActID")).data.toString();
        sqlBD.append("select fid,fname_l2 from ").append(asstActType.getRealtionDataObject()).append(" where fnumber ='").append(asstActNumber).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBD.toString());
        if (!rowSet.next()) {
            throw new BalancebillException(BalancebillException.BALANCEBILLNOASSTACT);
        }
        asstActID = rowSet.getString("fid");
        asstActName = rowSet.getString("fname_l2");
        info.setAsstActID(asstActID);
        info.setAsstActName(asstActName);
    }

    private AdminOrgUnitInfo getAdmin(Context ctx, Hashtable hsData) throws Exception, BOSException {
        AdminOrgUnitInfo adminInfo = null;
        String adminOrgUnitID = ((DataToken)hsData.get((Object)"FAdminOrgUnitID")).data.toString();
        String sql = "select fid where number='" + adminOrgUnitID + "'";
        AdminOrgUnitCollection adminCol = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(sql);
        if (adminCol == null || adminCol.size() <= 0) {
            throw new BalancebillException(BalancebillException.BALANCEBILLNOADMIN);
        }
        adminInfo = adminCol.get(0);
        return adminInfo;
    }

    private PersonInfo getPerson(Context ctx, Hashtable hsData) throws Exception, BOSException {
        PersonInfo personInfo = null;
        String personID = ((DataToken)hsData.get((Object)"FPersonID")).data.toString();
        String sql = "select fid where number='" + personID + "'";
        PersonCollection personCol = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(sql);
        if (personCol == null || personCol.size() <= 0) {
            throw new BalancebillException(BalancebillException.BALANCEBILLNOPERSON);
        }
        personInfo = personCol.get(0);
        return personInfo;
    }

    private AccountViewInfo getAccount(Context ctx, Hashtable hsData) throws Exception, BOSException {
        AccountViewInfo accountInfo = null;
        String accountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
        String sql = "select fid where number='" + accountID + "'";
        AccountViewCollection personCol = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(sql);
        if (personCol == null || personCol.size() <= 0) {
            throw new BalancebillException(BalancebillException.BALANCEBILLNOACCOUNT);
        }
        accountInfo = personCol.get(0);
        return accountInfo;
    }

    private SettlementTypeEnum getSettlementType(Context ctx, Hashtable hsData) throws Exception, BOSException {
        String settelmentTypeName = ((DataToken)hsData.get((Object)"FSettlementType")).data.toString();
        if ("\u5e94\u6536".equals(settelmentTypeName)) {
            return SettlementTypeEnum.AR;
        }
        if ("\u5e94\u4ed8".equals(settelmentTypeName)) {
            return SettlementTypeEnum.AP;
        }
        throw new BalancebillException(BalancebillException.BALANCEBILLNOSETTLETYPE);
    }
}

