/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.scmcommon.tools.BizCommand;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import java.util.Map;

public class UnCloseAccountService
extends BizCommand {
    public UnCloseAccountService(Context ctx) {
        super(ctx);
    }

    protected Object doing(Object inParam) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)((Map)inParam).get("profitCenter");
        PeriodInfo currPeriod = (PeriodInfo)((Map)inParam).get("currPeriod");
        this.unClosePeriod(profitCenter, currPeriod);
        return null;
    }

    private void unClosePeriod(ProfitCenterOrgUnitInfo profitCenter, PeriodInfo currPeriod) throws EASBizException, BOSException {
        String profitCenterId = profitCenter.getId().toString();
        PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)currPeriod);
        boolean isAdjustPeriod = prePeriodInfo.isIsAdjustPeriod();
        if (isAdjustPeriod) {
            prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)prePeriodInfo);
        }
        PeriodInfo startPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getProfitStartPeriod(1007, profitCenterId);
        if (prePeriodInfo.getId().equals((Object)startPeriod.getId())) {
            this.deleteBalanceData4Start(profitCenterId);
            this.updateBalanceData4Start(prePeriodInfo, profitCenterId);
        } else {
            this.deleteBalanceData(currPeriod, profitCenterId);
            this.updateBalanceData(prePeriodInfo, profitCenterId);
        }
        this.updatePeriod((OrgUnitInfo)profitCenter, isAdjustPeriod);
    }

    private void deleteBalanceData4Start(String profitCenterId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete T_MAP_BALANCEBILL ");
        sql.append(" where FProfitCenterOrgID = ? and FInitFlag = 0");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId});
    }

    private void updateBalanceData4Start(PeriodInfo currPeriod, String profitCenterId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_MAP_BALANCEBILL ");
        sql.append(" set ");
        sql.append(" FArAmount = 0 ,FArAmountLocal = 0,FApAmount=0,FApAmountLocal=0,");
        sql.append(" FAmount=0,FAmountLocal=0");
        sql.append(" where FPeriodID = ? ");
        sql.append(" and FProfitCenterOrgID = ? and FInitFlag = 1");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{currPeriod.getId().toString(), profitCenterId});
    }

    private void updateBalanceData(PeriodInfo currPeriod, String profitCenterId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_MAP_BALANCEBILL ");
        sql.append(" set ");
        sql.append(" FArAmount = 0 ,FArAmountLocal = 0,FApAmount=0,FApAmountLocal=0,");
        sql.append(" FAmount=0,FAmountLocal=0");
        sql.append(" where FPeriodID = ? ");
        sql.append(" and FProfitCenterOrgID = ? and FInitFlag = 0");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{currPeriod.getId().toString(), profitCenterId});
    }

    private void deleteBalanceData(PeriodInfo nextPeriodInfo, String profitCenterId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete T_MAP_BALANCEBILL ");
        sql.append(" where FPeriodID = ? ");
        sql.append(" and FProfitCenterOrgID = ? and FInitFlag = 0");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{nextPeriodInfo.getId().toString(), profitCenterId});
    }

    private void updatePeriod(OrgUnitInfo orgInfo, boolean isAdjustPeriod) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        iSystemStatusCtrol.prePeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
        if (isAdjustPeriod) {
            iSystemStatusCtrol.prePeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
        }
    }

    public String getTaskID() {
        return null;
    }
}

