/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountException;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.MbgDimException;
import com.kingdee.eas.ma.base.app.AbstractBgAccountControllerBean;
import com.kingdee.eas.ma.base.app.utils.BgIntIdHelper;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.app.utils.TreeBaseParentChangeHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class BgAccountControllerBean
extends AbstractBgAccountControllerBean {
    private static final long serialVersionUID = -5457975521491340277L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgAccountControllerBean");

    private IObjectPK[] saveData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        if (ctx == null || colls.isEmpty()) {
            return null;
        }
        this.checkLeaf(ctx, colls);
        BgAccountInfo info = null;
        FilterInfo baseFilter = new FilterInfo();
        for (int i = 0; i < colls.size(); ++i) {
            info = (BgAccountInfo)colls.getObject(i);
            if (baseFilter.getFilterItems().isEmpty()) {
                baseFilter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)info.getBgAccountView().getId().toString()));
            }
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            if (info.getDistributeRootID() != null) continue;
            info.setDistributeRootID(info.getId());
        }
        TreeBaseParentChangeHelper treeHelper = new TreeBaseParentChangeHelper(ctx, BgAccountFactory.getLocalInstance(ctx), baseFilter);
        treeHelper.init(colls);
        if (!colls.isEmpty()) {
            BgIntIdHelper.setIntIdOnlyAddNew(ctx, colls, ((BgAccountInfo)colls.getObject(0)).getBgAccountView().getId().toString(), true);
        }
        IObjectPK[] pks = super._saveBatchData(ctx, colls);
        this.updateParent(ctx, colls, null, false);
        this.updateLeafMembers(ctx, colls);
        treeHelper.updateParent();
        MbgVirtualView.getInstance(ctx).checkVirtualView(colls);
        BgDimCacheUtils.clearDimMemberCache(ctx);
        return pks;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)((BgAccountInfo)model).getNumber())) {
            BgCodeNumberHelper codeHelper = new BgCodeNumberHelper(ctx, null, null);
            codeHelper.init(model, ((BgAccountInfo)model).getOrgUnit().getId().toString());
            if (codeHelper.isHasCodeNumber()) {
                this.applyNumber(ctx, codeHelper, (BgAccountInfo)model, ((BgAccountInfo)model).getOrgUnit().getId().toString());
            }
            if (StringUtils.isEmpty((String)((BgAccountInfo)model).getNumber())) {
                ((BgAccountInfo)model).setNumber("BgAccount-" + System.currentTimeMillis());
            }
        }
        if (((BgAccountInfo)model).getNumber().length() > 80) {
            throw new MbgDimException(MbgDimException.NUMBERTOLONG);
        }
        if (!BgNumberHelper.checkNumber(((BgAccountInfo)model).getNumber())) {
            throw new MbgDimException(MbgDimException.SPECIALCHARINNUMBER);
        }
        this.checkNumDump(ctx, model);
        BgAccountInfo info = (BgAccountInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        if (info.getDistributeRootID() == null) {
            info.setDistributeRootID(info.getId());
        }
        boolean hasSync = this.checkHasSyncFactData(ctx, model);
        this.updateTreeNodes(ctx, model);
        if (!this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            BgIntIdHelper.setIntIdOnlyAddNew(ctx, (CoreBaseInfo)info, info.getBgAccountView().getId().toString(), true);
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        if (hasSync) {
            CoreBaseCollection colls = new CoreBaseCollection();
            colls.addObject(model);
            MbgVirtualView.getInstance(ctx).checkVirtualView((IObjectCollection)colls);
            BgDimCacheUtils.clearDimMemberCache(ctx);
        }
        return pk;
    }

    private boolean checkHasSyncFactData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return false;
        }
        BgAccountInfo member = (BgAccountInfo)model;
        if (member.getId() == null) {
            return true;
        }
        String id = member.getId().toString();
        String number = member.getNumber();
        String parentId = member.getParent() != null ? member.getParent().getId().toString() : null;
        boolean hasSync = false;
        IRowSet rst = null;
        try {
            rst = StringUtils.isEmpty((String)parentId) ? BgDBUtils.executeQuery(ctx, "select FID from T_MBG_BgAccount where FID = ? and FNumber = ? and FParentId is null", new Object[]{id, number}) : BgDBUtils.executeQuery(ctx, "select FID from T_MBG_BgAccount where FID = ? and FNumber = ? and FParentId = ?", new Object[]{id, number, parentId});
            if (rst != null && !rst.next()) {
                hasSync = true;
            }
            SQLUtils.cleanup((ResultSet)rst);
            rst = BgDBUtils.executeQuery(ctx, "select FID, FPolAlgorithm, FBgAccountType, FBgAccountDataType, FBgDecreditAlgorithm from T_MBG_BgAccount where fid = ?", new Object[]{id});
            if (rst != null && rst.next() && (member.getPolAlgorithm().getValue() != rst.getInt("FPolAlgorithm") || member.getBgAccountType().getValue() != rst.getInt("FBgAccountType") || member.getBgAccountDataType().getValue() != rst.getInt("FBgAccountDataType") || member.getBgDecreditAlgorithm().getValue() != rst.getInt("FBgDecreditAlgorithm"))) {
                hasSync = true;
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return hasSync;
    }

    private void checkNumDump(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return;
        }
        BgAccountInfo accountInfo = (BgAccountInfo)model;
        String number = accountInfo.getNumber();
        String viewid = accountInfo.getBgAccountView().getId().toString();
        if (accountInfo.getId() != null ? this._exists(ctx, "select id where number = '" + number + "'and bgAccountView.id = '" + viewid + "' and id <> '" + accountInfo.getId().toString() + "'") : this._exists(ctx, "select id where number = '" + number + "'and bgAccountView.id = '" + viewid + "'")) {
            throw new BgAccountException(BgAccountException.HASEXISTSAMENUM, new Object[]{number});
        }
    }

    private void updateTreeNodes(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (ctx == null || model == null || ((BgAccountInfo)model).getId() == null) {
            return;
        }
        BgAccountInfo curMember = (BgAccountInfo)model;
        if (!this._exists(ctx, "where id = '" + curMember.getId() + "'")) {
            return;
        }
        BgAccountInfo oldValue = (BgAccountInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(curMember.getId()));
        TreeBaseCollection coll = null;
        if (this.hasParentChanged(curMember, oldValue)) {
            coll = this.getAllChildren(ctx, curMember);
            coll.addObject(0, (IObjectValue)curMember);
            this.updateAllChildsByCurMember(ctx, coll, curMember);
            this._saveBatchData(ctx, (IObjectCollection)coll);
            this.updateCurMemberParent(ctx, oldValue, curMember.getParent(), curMember.getBgAccountView().getId().toString());
        }
    }

    private boolean hasParentChanged(BgAccountInfo curMember, BgAccountInfo oldValue) {
        BgAccountInfo newParentValue = curMember.getParent();
        BgAccountInfo oldParentValue = oldValue.getParent();
        if (newParentValue == null && oldParentValue == null) {
            return false;
        }
        if (newParentValue == null && oldParentValue != null) {
            return true;
        }
        if (newParentValue != null && oldParentValue == null) {
            return true;
        }
        return !newParentValue.getId().toString().equals(oldParentValue.getId().toString());
    }

    private void updateCurMemberParent(Context ctx, BgAccountInfo oldValue, BgAccountInfo newParent, String viewId) throws EASBizException, BOSException {
        if (ctx == null || oldValue == null || StringUtils.isEmpty((String)viewId)) {
            return;
        }
        BgAccountInfo bgAccountInfo = oldValue.getParent();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isleaf"));
        if (bgAccountInfo != null) {
            ObjectUuidPK curOldPk = new ObjectUuidPK(BOSUuid.read((String)bgAccountInfo.getId().toString()));
            IObjectValue curOldParentValue = this._getValue(ctx, (IObjectPK)curOldPk);
            if (!this._exists(ctx, "select id where bgaccountview.id = '" + viewId + "' and parent.id = '" + bgAccountInfo.getId().toString() + "'")) {
                ((BgAccountInfo)curOldParentValue).setIsLeaf(true);
                this.updatePartial(ctx, (BgAccountInfo)curOldParentValue, sic);
            }
        }
        if (newParent != null && newParent.isIsLeaf()) {
            newParent.setIsLeaf(false);
            this.updatePartial(ctx, newParent, sic);
        }
    }

    private void updateAllChildsByCurMember(Context ctx, TreeBaseCollection coll, BgAccountInfo model) throws EASBizException, BOSException {
        if (coll == null || coll.isEmpty() || model == null) {
            return;
        }
        HashMap<String, BgAccountInfo> memberParentCache = new HashMap<String, BgAccountInfo>();
        ObjectUuidPK curPk = new ObjectUuidPK(model.getId());
        IObjectValue curValue = this._getValue(ctx, (IObjectPK)curPk);
        BgAccountInfo newParentInfo = model.getParent();
        BgAccountInfo newParentValue = null;
        if (newParentInfo != null) {
            newParentValue = (BgAccountInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(newParentInfo.getId()));
            BgAccountInfo childInfo = null;
            for (int i = 0; i < coll.size(); ++i) {
                childInfo = (BgAccountInfo)coll.get(i);
                if (memberParentCache.containsKey(childInfo.getParent().getId().toString())) {
                    newParentValue = (BgAccountInfo)memberParentCache.get(childInfo.getParent().getId().toString());
                    newParentValue.setIsLeaf(false);
                }
                childInfo.setLongNumber(newParentValue.getLongNumber() + "!" + childInfo.getNumber());
                childInfo.setLevel(newParentValue.getLevel() + 1);
                childInfo.setParent(newParentValue);
                memberParentCache.put(childInfo.getId().toString(), childInfo);
            }
        } else {
            BgAccountInfo childInfo = null;
            for (int i = 0; i < coll.size(); ++i) {
                childInfo = (BgAccountInfo)coll.get(i);
                if (childInfo.getParent() != null && memberParentCache.containsKey(childInfo.getParent().getId().toString())) {
                    newParentValue = (BgAccountInfo)memberParentCache.get(childInfo.getParent().getId().toString());
                    newParentValue.setIsLeaf(false);
                    childInfo.setLongNumber(newParentValue.getLongNumber() + "!" + childInfo.getNumber());
                    childInfo.setLevel(newParentValue.getLevel() + 1);
                    childInfo.setParent(newParentValue);
                } else {
                    childInfo.setLongNumber(childInfo.getNumber());
                    childInfo.setLevel(1);
                    childInfo.setParent(null);
                }
                memberParentCache.put(childInfo.getId().toString(), childInfo);
            }
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo curCUFilter = new FilterInfo();
        BgAccountInfo bgAccountInfo = (BgAccountInfo)model;
        if (bgAccountInfo.getBgAccountView() == null) {
            try {
                bgAccountInfo = (BgAccountInfo)this._getValue(ctx, "select bgaccountview.id where id = '" + ((BgAccountInfo)model).getId().toString() + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"get bgaccountview error", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"get bgaccountview error", (Throwable)e);
            }
        }
        curCUFilter.getFilterItems().add(new FilterItemInfo("bgaccountView.id", (Object)bgAccountInfo.getBgAccountView().getId().toString(), CompareType.EQUALS));
        return curCUFilter;
    }

    private void updateLeafMembers(Context ctx, IObjectCollection colls) throws BOSException {
        BgAccountInfo accountInfo = null;
        Set<String> hasLeafIds = null;
        HashSet<String> NotLeafIDS = new HashSet<String>();
        ArrayList<String> dealIds = new ArrayList<String>();
        for (int i = 0; i < colls.size(); ++i) {
            accountInfo = (BgAccountInfo)colls.getObject(i);
            if (accountInfo.isIsLeaf()) continue;
            NotLeafIDS.add(accountInfo.getId().toString());
        }
        if (NotLeafIDS.isEmpty()) {
            return;
        }
        hasLeafIds = this.getHasLeafIds(ctx, NotLeafIDS);
        NotLeafIDS.removeAll(hasLeafIds);
        dealIds.addAll(NotLeafIDS);
        if (!dealIds.isEmpty()) {
            PreparedStatement pstmt;
            Connection conn;
            block12: {
                int i;
                conn = null;
                pstmt = null;
                int batchSize = 50;
                int batchIndex = 0;
                int size = dealIds.size();
                int count = (size - 1) / batchSize + 1;
                int pos = 0;
                int value = 1;
                StringBuffer sql = new StringBuffer("update T_MBG_BgAccount set FIsLeaf = ? where FID in ( ");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (i = 0; i < count; ++i) {
                        pstmt.setInt(1, value);
                        int j = 2;
                        while (j <= batchSize + 1) {
                            if (pos < size) {
                                pstmt.setString(j, (String)dealIds.get(pos));
                            } else {
                                pstmt.setString(j, "#");
                            }
                            ++j;
                            ++pos;
                        }
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex == 0) break block12;
                    pstmt.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    private Set<String> getHasLeafIds(Context ctx, Set<String> notLeafIDS) throws BOSException {
        HashSet<String> hasLeafIds = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isleaf");
        sic.add("parent.id");
        filter.getFilterItems().add(new FilterItemInfo("parent.id", notLeafIDS, CompareType.INCLUDE));
        evi.setSelector(sic);
        evi.setFilter(filter);
        BgAccountCollection accColls = BgAccountFactory.getLocalInstance(ctx).getBgAccountCollection(evi);
        for (int i = 0; i < accColls.size(); ++i) {
            hasLeafIds.add(accColls.get(i).getParent().getId().toString());
        }
        return hasLeafIds;
    }

    private void checkLeaf(Context ctx, IObjectCollection colls) throws BOSException {
        if (colls.isEmpty()) {
            return;
        }
        HashMap<String, BgAccountInfo> leafMap = new HashMap<String, BgAccountInfo>();
        BgAccountInfo bgAccountInfo = null;
        for (int i = 0; i < colls.size(); ++i) {
            bgAccountInfo = (BgAccountInfo)colls.getObject(i);
            if (!bgAccountInfo.isIsLeaf() || bgAccountInfo.getId() == null) continue;
            leafMap.put(bgAccountInfo.getId().toString(), bgAccountInfo);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isleaf");
        filter.getFilterItems().add(new FilterItemInfo("id", leafMap.keySet(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)0, CompareType.EQUALS));
        evi.setSelector(sic);
        evi.setFilter(filter);
        BgAccountCollection accColls = BgAccountFactory.getLocalInstance(ctx).getBgAccountCollection(evi);
        if (accColls.size() == 0) {
            return;
        }
        for (int i = 0; i < accColls.size(); ++i) {
            ((BgAccountInfo)leafMap.get(accColls.get(i).getId().toString())).setIsLeaf(false);
        }
    }

    protected IObjectPK[] _saveBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        this.addLog(ctx, colls, "mbg_bgAccount_update");
        return this.saveData(ctx, colls);
    }

    @Override
    protected void _importBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        this.addLog(ctx, colls, "mbg_bgAccount_import");
        this.saveData(ctx, colls);
    }

    @Override
    protected void _sysImportData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        this.addLog(ctx, colls, "mbg_bgAccount_sysImport");
        this.saveData(ctx, colls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _deleteBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        BgAccountCollection accountColls = this.getAccountCollByIds(ctx, idSet);
        BgAccountInfo accountInfo = null;
        HashMap<BgAccountInfo, BgAccountInfo> parentMap = new HashMap<BgAccountInfo, BgAccountInfo>();
        TreeBaseCollection coll = null;
        HashSet<String> needDeleteIDS = new HashSet<String>();
        HashMap<String, BgAccountInfo> needDeleteInfo = new HashMap<String, BgAccountInfo>();
        HashMap<String, HashSet<String>> childMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> parentIDMaps = new HashMap<String, HashSet<String>>();
        HashSet<String> selectIDS = new HashSet<String>();
        int in = accountColls.size();
        for (int i = 0; i < in; ++i) {
            accountInfo = accountColls.get(i);
            selectIDS.add(accountInfo.getId().toString());
            if (!childMap.containsKey(accountInfo.getId().toString())) {
                childMap.put(accountInfo.getId().toString(), new HashSet());
            }
            coll = this.getAllChildren(ctx, accountInfo);
            Object child = null;
            int jn = coll.size();
            for (int j = 0; j < jn; ++j) {
                child = (BgAccountInfo)coll.get(j);
                needDeleteIDS.add(child.getId().toString());
                if (!parentIDMaps.containsKey(child.getId().toString())) {
                    parentIDMaps.put(child.getId().toString(), new HashSet());
                }
                ((HashSet)parentIDMaps.get(child.getId().toString())).add(accountInfo.getId().toString());
                this.recursionParent(coll, parentIDMaps, (BgAccountInfo)child);
                needDeleteInfo.put(child.getId().toString(), (BgAccountInfo)child);
                if (childMap.containsKey(accountInfo.getId().toString())) {
                    ((HashSet)childMap.get(accountInfo.getId().toString())).add(child.getId().toString());
                }
                this.recursionChild(coll, childMap, (BgAccountInfo)child);
            }
            needDeleteIDS.add(accountInfo.getId().toString());
            needDeleteInfo.put(accountInfo.getId().toString(), accountInfo);
            if (accountInfo.getParent() == null) continue;
            parentMap.put(accountInfo, accountInfo.getParent());
            if (!parentIDMaps.containsKey(accountInfo.getId().toString())) {
                parentIDMaps.put(accountInfo.getId().toString(), new HashSet());
                ((HashSet)parentIDMaps.get(accountInfo.getId().toString())).add(accountInfo.getParent().getId().toString());
                continue;
            }
            ((HashSet)parentIDMaps.get(accountInfo.getId().toString())).add(accountInfo.getParent().getId().toString());
        }
        BgAccountInfo parent = null;
        BgAccountCollection updateParentColl = new BgAccountCollection();
        for (BgAccountInfo account : parentMap.keySet()) {
            parent = (BgAccountInfo)parentMap.get(account);
            if (parent.getBgAccountView() == null) continue;
            coll = this.getAllChildren(ctx, parent);
            BgAccountInfo info = null;
            Boolean flag = true;
            int in2 = coll.size();
            for (int i = 0; i < in2; ++i) {
                info = (BgAccountInfo)coll.get(i);
                if (needDeleteIDS.contains(info.getId().toString())) continue;
                flag = false;
                break;
            }
            if (!flag.booleanValue()) continue;
            updateParentColl.add(account);
        }
        StringBuffer msg = new StringBuffer();
        Map returnMap = this._checkRef(ctx, needDeleteIDS);
        needDeleteIDS = this.reFilterDeleteIds(returnMap, needDeleteIDS, needDeleteInfo, msg, childMap, parentIDMaps, selectIDS);
        this.checkDistributeMem(ctx, needDeleteIDS, needDeleteInfo, msg, childMap, parentIDMaps, selectIDS);
        if (!needDeleteIDS.isEmpty()) {
            BgAccountCollection deColls = this.getAccountCollByIds(ctx, needDeleteIDS);
            this.addLog(ctx, (IObjectCollection)deColls, "mbg_bgAccount_delete");
            ArrayList<String> lst = new ArrayList<String>(needDeleteIDS);
            IObjectPK[] pkArrays = new IObjectPK[needDeleteIDS.size()];
            int in3 = lst.size();
            for (int i = 0; i < in3; ++i) {
                pkArrays[i] = new ObjectUuidPK((String)lst.get(i));
            }
            super._deleteBatchData(ctx, pkArrays);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgDBUtils.executeBatchUpdate(conn, "SELECT fid FROM t_mbg_PropertyRefSource where FSOURCEID in (" + BgDBUtils.getSqlParam(50) + ")", new ArrayList<Object>(needDeleteIDS));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        if (!updateParentColl.isEmpty() && !needDeleteIDS.isEmpty()) {
            BgAccountInfo acctInfo = null;
            Iterator iterator = updateParentColl.iterator();
            while (iterator.hasNext()) {
                acctInfo = (BgAccountInfo)iterator.next();
                if (needDeleteIDS.contains(acctInfo.getId().toString())) continue;
                iterator.remove();
            }
            this.updateParent(ctx, (IObjectCollection)updateParentColl, childMap, true);
        }
        returnMap.put("delete_success", needDeleteIDS);
        MbgVirtualView.getInstance(ctx).checkVirtualView((IObjectCollection)accountColls);
        BgDimCacheUtils.clearDimMemberCache(ctx);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (msg.length() > 0) {
            if (needDeleteIDS.size() == 0) {
                resultMap.put("delete_result", "delete_fail");
                resultMap.put("delete_fail", msg.toString());
            } else {
                resultMap.put("delete_result", msg.toString());
            }
        } else {
            resultMap.put("delete_result", "delete_success");
        }
        return resultMap;
    }

    private void recursionParent(TreeBaseCollection coll, Map<String, HashSet<String>> parentIDMaps, BgAccountInfo accountInfo) {
        BgAccountInfo parent = null;
        for (int i = 0; i < coll.size(); ++i) {
            parent = (BgAccountInfo)coll.get(i);
            if (!accountInfo.getLongNumber().startsWith(parent.getLongNumber() + "!")) continue;
            parentIDMaps.get(accountInfo.getId().toString()).add(parent.getId().toString());
        }
    }

    private void recursionChild(TreeBaseCollection coll, Map<String, HashSet<String>> childMaps, BgAccountInfo accountInfo) {
        BgAccountInfo child = null;
        if (!childMaps.containsKey(accountInfo.getId().toString())) {
            childMaps.put(accountInfo.getId().toString(), new HashSet());
        }
        for (int i = 0; i < coll.size(); ++i) {
            child = (BgAccountInfo)coll.get(i);
            if (!child.getLongNumber().startsWith(accountInfo.getLongNumber() + "!")) continue;
            childMaps.get(accountInfo.getId().toString()).add(child.getId().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void checkDistributeMem(Context ctx, Set<String> needDeleteIDS, Map<String, BgAccountInfo> needDeleteInfo, StringBuffer msg, Map<String, HashSet<String>> childMap, Map<String, HashSet<String>> parentIDMap, HashSet<String> selectIDS) throws BOSException, EASBizException {
        Connection conn;
        IRowSet rst;
        block22: {
            if (ctx == null || needDeleteIDS == null || needDeleteIDS.isEmpty()) {
                return;
            }
            rst = null;
            conn = null;
            TempTablePool pool = null;
            String id = null;
            String number = null;
            String distributeId = null;
            String tmpTable = null;
            String key2222 = null;
            HashMap<String, String> idNumMap = new HashMap<String, String>();
            HashSet<String> selectChildIDS = new HashSet<String>();
            try {
                conn = BgDBUtils.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FID) values (?)", needDeleteIDS);
                rst = BgDBUtils.executeQuery(conn, "SELECT FID,FNUMBER,FDISTRIBUTEROOTID FROM T_MBG_BGACCOUNT WHERE FID IN (SELECT FID FROM " + tmpTable + " )");
                HashSet<String> exsitId = new HashSet<String>();
                while (rst.next()) {
                    id = rst.getString("FID");
                    number = rst.getString("FNUMBER");
                    distributeId = rst.getString("FDISTRIBUTEROOTID");
                    idNumMap.put(id, number);
                    if (id.equals(distributeId) || !needDeleteIDS.contains(id)) continue;
                    needDeleteIDS.remove(id);
                    if (childMap.containsKey(id)) {
                        selectChildIDS.clear();
                        for (String key2222 : childMap.get(id)) {
                            if (!selectIDS.contains(key2222) || !childMap.containsKey(key2222)) continue;
                            if (!selectIDS.contains(id)) {
                                selectChildIDS.add(key2222);
                                selectChildIDS.addAll((Collection)childMap.get(key2222));
                                continue;
                            }
                            if (!selectIDS.contains(key2222)) continue;
                            selectChildIDS.add(key2222);
                            selectChildIDS.addAll((Collection)childMap.get(key2222));
                        }
                        for (String key2222 : childMap.get(id)) {
                            if (selectChildIDS.contains(key2222)) continue;
                            needDeleteIDS.remove(key2222);
                        }
                    }
                    if (needDeleteInfo.containsKey(id)) {
                        exsitId.add(id);
                        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteDispatch", (Object[])new Object[]{needDeleteInfo.get(id).getNumber(), needDeleteInfo.get(id).getName()}) + "\n");
                    }
                    if (!parentIDMap.containsKey(id)) continue;
                    needDeleteIDS.removeAll((Collection)parentIDMap.get(id));
                    for (String ids : parentIDMap.get(id)) {
                        if (exsitId.contains(ids)) continue;
                        exsitId.add(ids);
                        if (needDeleteInfo.get(ids) == null) continue;
                        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteDispatchChild", (Object[])new Object[]{needDeleteInfo.get(ids).getNumber(), needDeleteInfo.get(ids).getName()}) + "\n");
                    }
                }
                rst.close();
                rst = BgDBUtils.executeQuery(conn, "SELECT acc.FID,acc.FNUMBER,acc.FDISTRIBUTEROOTID FROM T_MBG_BGACCOUNT acc join " + tmpTable + " tmp ON acc.FDISTRIBUTEROOTID = tmp.FID WHERE acc.FID <> tmp.FID  order by acc.FLONGNUMBER ASC");
                exsitId.clear();
                while (rst.next()) {
                    id = rst.getString("FDISTRIBUTEROOTID");
                    if (!needDeleteIDS.contains(id)) continue;
                    needDeleteIDS.remove(id);
                    if (childMap.containsKey(id)) {
                        selectChildIDS.clear();
                        for (String key2222 : childMap.get(id)) {
                            if (!selectIDS.contains(key2222) || !childMap.containsKey(key2222)) continue;
                            if (!selectIDS.contains(id)) {
                                selectChildIDS.add(key2222);
                                selectChildIDS.addAll((Collection)childMap.get(key2222));
                                continue;
                            }
                            if (!selectIDS.contains(key2222)) continue;
                            selectChildIDS.add(key2222);
                            selectChildIDS.addAll((Collection)childMap.get(key2222));
                        }
                        for (String key2222 : childMap.get(id)) {
                            if (selectChildIDS.contains(key2222)) continue;
                            needDeleteIDS.remove(key2222);
                        }
                    }
                    if (needDeleteInfo.containsKey(id)) {
                        exsitId.add(id);
                        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteDisplayed", (Object[])new Object[]{needDeleteInfo.get(id).getNumber(), needDeleteInfo.get(id).getName()}) + "\n");
                    }
                    if (!parentIDMap.containsKey(id)) continue;
                    needDeleteIDS.removeAll((Collection)parentIDMap.get(id));
                    for (String ids : parentIDMap.get(id)) {
                        if (exsitId.contains(ids)) continue;
                        exsitId.add(ids);
                        if (needDeleteInfo.get(ids) == null) continue;
                        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteDispatchChild", (Object[])new Object[]{needDeleteInfo.get(ids).getNumber(), needDeleteInfo.get(ids).getName()}) + "\n");
                    }
                }
                if (tmpTable == null) break block22;
            }
            catch (SQLDataException e) {
                block23: {
                    logger.error((Object)("sqldata error:" + (Object)((Object)e)));
                    if (tmpTable == null) break block23;
                    BgDBUtils.releaseTmpTable(pool, tmpTable);
                }
                SQLUtils.cleanup(rst, null, (Connection)conn);
            }
            catch (SQLException e) {
                block24: {
                    logger.error((Object)("sql error:" + e));
                    if (tmpTable == null) break block24;
                    {
                        catch (Throwable throwable) {
                            if (tmpTable != null) {
                                BgDBUtils.releaseTmpTable(pool, tmpTable);
                            }
                            SQLUtils.cleanup(rst, null, (Connection)conn);
                            throw throwable;
                        }
                    }
                    BgDBUtils.releaseTmpTable(pool, tmpTable);
                }
                SQLUtils.cleanup(rst, null, (Connection)conn);
            }
            BgDBUtils.releaseTmpTable(pool, tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    private String getAppendStrByColls(Set<String> userGroupIds) {
        if (userGroupIds == null || userGroupIds.isEmpty()) {
            return null;
        }
        StringBuffer selectGroupStr = new StringBuffer();
        selectGroupStr.append("(");
        Iterator<String> it = userGroupIds.iterator();
        while (it.hasNext()) {
            selectGroupStr.append("'").append(it.next()).append("',");
        }
        selectGroupStr.delete(selectGroupStr.length() - 1, selectGroupStr.length()).append(")");
        return selectGroupStr.toString();
    }

    private HashSet<String> reFilterDeleteIds(Map<String, HashSet<String>> returnMap, HashSet<String> needDeleteIDS, Map<String, BgAccountInfo> needDeleteInfo, StringBuffer msg, Map<String, HashSet<String>> childMap, Map<String, HashSet<String>> parentIDMap, HashSet<String> selectIDS) {
        if (returnMap == null || returnMap.isEmpty()) {
            return needDeleteIDS;
        }
        Object valueSet = null;
        HashSet<String> exsitId = new HashSet<String>();
        LinkedHashSet<String> allSet = new LinkedHashSet<String>();
        Iterator<String> ite = returnMap.keySet().iterator();
        while (ite.hasNext()) {
            allSet.addAll((Collection)returnMap.get(ite.next()));
        }
        String key2 = null;
        HashSet<String> selectChildIDS = new HashSet<String>();
        if (allSet != null && !allSet.isEmpty()) {
            TreeSet<BgAccountInfo> needDeleteInfoSet = new TreeSet<BgAccountInfo>(new Comparator<BgAccountInfo>(){

                @Override
                public int compare(BgAccountInfo o1, BgAccountInfo o2) {
                    return o1.getLongNumber().compareTo(o2.getLongNumber());
                }
            });
            for (String id : allSet) {
                if (!needDeleteInfo.containsKey(id)) continue;
                needDeleteInfoSet.add(needDeleteInfo.get(id));
            }
            allSet.clear();
            for (BgAccountInfo bgAccountInfo : needDeleteInfoSet) {
                allSet.add(bgAccountInfo.getId().toString());
            }
            for (String value : allSet) {
                if (needDeleteIDS.contains(value)) {
                    needDeleteIDS.remove(value);
                }
                if (childMap.containsKey(value)) {
                    selectChildIDS.clear();
                    for (String key2 : childMap.get(value)) {
                        if (!selectIDS.contains(key2) || !childMap.containsKey(key2)) continue;
                        if (!selectIDS.contains(value)) {
                            selectChildIDS.add(key2);
                            selectChildIDS.addAll((Collection)childMap.get(key2));
                            continue;
                        }
                        if (!selectIDS.contains(key2)) continue;
                        selectChildIDS.add(key2);
                        selectChildIDS.addAll((Collection)childMap.get(key2));
                    }
                    for (String key2 : childMap.get(value)) {
                        if (selectChildIDS.contains(key2)) continue;
                        needDeleteIDS.remove(key2);
                    }
                }
                if (needDeleteInfo.containsKey(value)) {
                    exsitId.add(value);
                    msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteByhasRef", (Object[])new Object[]{needDeleteInfo.get(value).getNumber(), needDeleteInfo.get(value).getName()}) + "\n");
                }
                if (!parentIDMap.containsKey(value)) continue;
                needDeleteIDS.removeAll((Collection)parentIDMap.get(value));
                for (String ids : parentIDMap.get(value)) {
                    if (exsitId.contains(ids)) continue;
                    exsitId.add(ids);
                    if (needDeleteInfo.get(ids) == null) continue;
                    msg.append(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteByhasRefChild", (Object[])new Object[]{needDeleteInfo.get(ids).getNumber(), needDeleteInfo.get(ids).getName()}) + "\n");
                }
            }
        }
        return needDeleteIDS;
    }

    private void printLog(Context ctx, BgAccountInfo info, String logItem) {
        String logName = info.getNumber() + " " + info.getName();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    private void addLog(Context ctx, IObjectCollection colls, String logItem) {
        if (colls == null || colls.isEmpty()) {
            return;
        }
        BgAccountInfo info = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            info = (BgAccountInfo)colls.getObject(i);
            this.printLog(ctx, info, logItem);
        }
    }

    private BgAccountCollection getAccountCollByIds(Context ctx, Set idSet) throws BOSException {
        IBgAccount iBgAccount = BgAccountFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("longNumber");
        sic.add("parent.id");
        sic.add("parent.longNumber");
        sic.add("parent.bgAccountView.id");
        sic.add("bgAccountView.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return iBgAccount.getBgAccountCollection(view);
    }

    private TreeBaseCollection getAllChildren(Context ctx, BgAccountInfo account) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)account.getBgAccountView().getId(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return this.getAllChildren(ctx, account, view);
    }

    private void updateParent(Context ctx, IObjectCollection colls, Map<String, HashSet<String>> childMap, boolean isLeaf) throws BOSException {
        BgAccountInfo accountInfo = null;
        BgAccountInfo parentInfo = null;
        ArrayList<String> parentIDS = new ArrayList<String>();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            accountInfo = (BgAccountInfo)colls.getObject(i);
            if (accountInfo.getParent() == null || (parentInfo = accountInfo.getParent()).getId() == null) continue;
            if (childMap != null && childMap.containsKey(parentInfo.getId().toString())) {
                childMap.get(parentInfo.getId().toString()).removeAll((Collection)childMap.get(accountInfo.getId().toString()));
                childMap.get(parentInfo.getId().toString()).remove(accountInfo.getId().toString());
            }
            if (childMap != null && childMap.get(parentInfo.getId().toString()) != null && !childMap.get(parentInfo.getId().toString()).isEmpty()) continue;
            parentIDS.add(parentInfo.getId().toString());
        }
        if (!parentIDS.isEmpty()) {
            PreparedStatement pstmt;
            Connection conn;
            block12: {
                int i;
                conn = null;
                pstmt = null;
                int batchSize = 50;
                int batchIndex = 0;
                int size = parentIDS.size();
                int count = (size - 1) / batchSize + 1;
                int pos = 0;
                int value = isLeaf ? 1 : 0;
                StringBuffer sql = new StringBuffer("update T_MBG_BgAccount set FIsLeaf = ? where FID in ( ");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (i = 0; i < count; ++i) {
                        pstmt.setInt(1, value);
                        int j = 2;
                        while (j <= batchSize + 1) {
                            if (pos < size) {
                                pstmt.setString(j, (String)parentIDS.get(pos));
                            } else {
                                pstmt.setString(j, "#");
                            }
                            ++j;
                            ++pos;
                        }
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex == 0) break block12;
                    pstmt.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    protected Map _checkRef(Context ctx, Set idSet, boolean isOnlyCheckBgData) throws BOSException, EASBizException {
        HashMap<String, Set<String>> refMap = new HashMap<String, Set<String>>();
        if (ctx == null || idSet == null || idSet.isEmpty()) {
            return refMap;
        }
        if (!isOnlyCheckBgData) {
            Map<String, Set<String>> refDim = this.getRefDimRelations(ctx, idSet);
            refMap.putAll(refDim);
            Map<String, Set<String>> refBiz = this.getRefBiz(ctx, idSet);
            refMap.putAll(refBiz);
        }
        Map<String, Set<String>> refMem = this.getRefMembers(ctx, idSet);
        refMap.putAll(refMem);
        return refMap;
    }

    @Override
    protected Map _checkRef(Context ctx, Set idSet) throws BOSException, EASBizException {
        return this._checkRef(ctx, idSet, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Set<String>> getRefMembers(Context ctx, Set<String> bgAccountIds) throws BOSException {
        ResultSet rst;
        PreparedStatement pst;
        Connection connection;
        HashMap<String, Set<String>> refMem;
        block9: {
            refMem = new HashMap<String, Set<String>>();
            if (ctx == null) return refMem;
            if (bgAccountIds == null) return refMem;
            if (bgAccountIds.isEmpty()) {
                return refMem;
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String id : bgAccountIds) {
                params.add(new Object[]{id});
            }
            connection = null;
            pst = null;
            rst = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tmpTable = null;
            try {
                connection = this.getConnection(ctx);
                tmpTable = pool.createTempTable("Create Table TMP_MBG_TEMPTABLE(FBgAccountID Varchar(44) NOT NULL)");
                DbUtil.executeBatch((Context)ctx, (String)("Insert Into " + tmpTable + "(FBgAccountID) Values(?)"), params);
                pst = connection.prepareStatement("select FRefType, FBaseDataID from T_MBG_BgRefDimMember where FBaseDataID in (select FBgAccountID from " + tmpTable + ")");
                rst = pst.executeQuery();
                Integer refType = null;
                String baseDateId = null;
                String refStr = null;
                while (rst.next()) {
                    refType = rst.getInt(1);
                    baseDateId = rst.getString(2);
                    refStr = this.transRefStr(refType);
                    if (!refMem.containsKey(refStr)) {
                        refMem.put(refStr, new HashSet());
                    }
                    ((Set)refMem.get(refStr)).add(baseDateId);
                }
                if (tmpTable == null) break block9;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rst, pst, (Connection)connection);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        return refMem;
    }

    private String transRefStr(Integer refType) {
        String str = null;
        if (refType == 1) {
            str = "ref_template";
        } else if (refType == 4) {
            str = "ref_form";
        } else if (refType == 8) {
            str = "ref_data";
        }
        return str;
    }

    private Map<String, Set<String>> getRefDimRelations(Context ctx, Set<String> bgAccountIds) throws BOSException {
        HashMap<String, Set<String>> refDim = new HashMap<String, Set<String>>();
        if (ctx == null || bgAccountIds == null || bgAccountIds.isEmpty()) {
            return refDim;
        }
        HashMap schemeDim = new HashMap();
        Connection connection = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer querySql = new StringBuffer();
        try {
            connection = this.getConnection(ctx);
            Map<String, Set<String>> viewScheme = this.queryViewSchemes(connection, bgAccountIds);
            querySql.append("SELECT  g.FBgSchemeId, re.FDimensionNumber ").append("FROM T_MBG_DimensionRelationship re ").append("left join T_MBG_DimensionRelationGroup  g on g.FID  = re.FDIMENSIONGROUPID ").append("where re.FDimensionNumber like '%Acc:%' ");
            pst = connection.prepareStatement(querySql.toString());
            rst = pst.executeQuery();
            String schemeId2 = null;
            String dimNum = null;
            while (rst.next()) {
                schemeId2 = rst.getString(1);
                dimNum = rst.getString(2);
                if (dimNum.indexOf("Acc:") < 0) continue;
                if (!schemeDim.containsKey(schemeId2)) {
                    schemeDim.put(schemeId2, new HashSet());
                }
                ((Set)schemeDim.get(schemeId2)).add(this.processDimNum(dimNum));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (!viewScheme.isEmpty() && !schemeDim.isEmpty()) {
                BgAccountCollection colls = this.getAccountCollByIds(ctx, bgAccountIds);
                Set numLst = null;
                BgAccountInfo info = null;
                String viewId = null;
                int size = colls.size();
                for (int index = 0; index < size; ++index) {
                    info = colls.get(index);
                    viewId = info.getBgAccountView().getId().toString();
                    if (!viewScheme.containsKey(viewId)) continue;
                    Set<String> schemeIds = viewScheme.get(viewId);
                    for (String schemeId2 : schemeIds) {
                        if (!schemeDim.containsKey(schemeId2) || !(numLst = (Set)schemeDim.get(schemeId2)).contains(info.getNumber())) continue;
                        if (!refDim.containsKey("ref_dimRelation")) {
                            refDim.put("ref_dimRelation", new HashSet());
                        }
                        ((Set)refDim.get("ref_dimRelation")).add(info.getId().toString());
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pst, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        return refDim;
    }

    private String processDimNum(String dimNum) {
        String newNum = null;
        String[] dimNums = dimNum.split(",");
        for (int i = 0; i < dimNums.length; ++i) {
            if (!dimNums[i].startsWith("Acc:")) continue;
            newNum = dimNums[i].substring(4, dimNums[i].length());
        }
        return newNum;
    }

    private Map<String, Set<String>> getRefBiz(Context ctx, Set<String> bgAccountIds) throws BOSException {
        HashMap<String, Set<String>> refBiz = new HashMap<String, Set<String>>();
        if (ctx == null || bgAccountIds == null || bgAccountIds.isEmpty()) {
            return refBiz;
        }
        HashMap schemeBiz = new HashMap();
        Connection connection = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        try {
            connection = this.getConnection(ctx);
            Map<String, Set<String>> viewScheme = this.queryViewSchemes(connection, bgAccountIds);
            String sql = "SELECT cl.FBgSchemeID, ru.FBGINDEXNUM  FROM T_MBG_BizCalcRule ru left join T_MBG_BizCalc cl on cl.FID  = ru.FBizSchemeID where ru.FBgIndexNum is not null";
            pst = connection.prepareStatement(sql);
            rst = pst.executeQuery();
            String schemeId2 = null;
            String accountNum = null;
            while (rst.next()) {
                schemeId2 = rst.getString(1);
                accountNum = rst.getString(2);
                if (accountNum.indexOf("Acc:") < 0) continue;
                if (!schemeBiz.containsKey(schemeId2)) {
                    schemeBiz.put(schemeId2, new HashSet());
                }
                ((Set)schemeBiz.get(schemeId2)).add(this.processDimNum(accountNum));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (!viewScheme.isEmpty() && !schemeBiz.isEmpty()) {
                BgAccountCollection colls = this.getAccountCollByIds(ctx, bgAccountIds);
                Set numLst = null;
                BgAccountInfo info = null;
                String viewId = null;
                int size = colls.size();
                for (int index = 0; index < size; ++index) {
                    info = colls.get(index);
                    viewId = info.getBgAccountView().getId().toString();
                    if (!viewScheme.containsKey(viewId)) continue;
                    Set<String> schemeIds = viewScheme.get(viewId);
                    for (String schemeId2 : schemeIds) {
                        if (!schemeBiz.containsKey(schemeId2) || !(numLst = (Set)schemeBiz.get(schemeId2)).contains(info.getNumber())) continue;
                        if (!refBiz.containsKey("ref_biz")) {
                            refBiz.put("ref_biz", new HashSet());
                        }
                        ((Set)refBiz.get("ref_biz")).add(info.getId().toString());
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pst, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        return refBiz;
    }

    private Map<String, Set<String>> queryViewSchemes(Connection connection, Set<String> bgAccountIds) throws BOSException {
        HashMap<String, Set<String>> schemeView = new HashMap<String, Set<String>>();
        if (connection == null || bgAccountIds == null || bgAccountIds.isEmpty()) {
            return schemeView;
        }
        Set<String> viewIds = this.getViewIds(connection, bgAccountIds);
        String schemeId = null;
        String viewId = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT s.FBgSchemeID, m.FMemberId ").append("FROM T_MBG_BgDimSettingsMember m ").append("left join T_MBG_BgDimSettings s on s.fid = m.FBgDimSettingsID ").append("where s.fdimNumber = 'BG_Account' ").append(" and m.FMemberId in (");
            for (String obj : viewIds) {
                if (obj == null) continue;
                sql.append("?,");
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
            pst = connection.prepareStatement(sql.toString());
            MbgSqlHelper.setParams(pst, new ArrayList<String>(viewIds));
            rst = pst.executeQuery();
            while (rst.next()) {
                schemeId = rst.getString(1);
                viewId = rst.getString(2);
                if (!schemeView.containsKey(viewId)) {
                    schemeView.put(viewId, new HashSet());
                }
                ((Set)schemeView.get(viewId)).add(schemeId);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
        return schemeView;
    }

    private Set<String> getViewIds(Connection conn, Set<String> bgAccountIds) throws BOSException {
        HashSet<String> viewIds = new HashSet<String>();
        if (conn == null || bgAccountIds == null || bgAccountIds.isEmpty()) {
            return viewIds;
        }
        PreparedStatement pst = null;
        ResultSet rst = null;
        ArrayList<String> IDList = new ArrayList<String>(bgAccountIds);
        int batchNum = 500;
        int size = IDList.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer("select FBgAccountViewID From T_MBG_BgAccount where fid in ( ");
        for (int i = 0; i < batchNum; ++i) {
            if (i == batchNum - 1) {
                sql.append("?)");
                continue;
            }
            sql.append("?,");
        }
        try {
            pst = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pst.setString(k, (String)IDList.get(pos));
                    } else {
                        pst.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pst.executeQuery();
                while (rst.next()) {
                    viewIds.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pst);
        }
        return viewIds;
    }

    @Override
    protected Map _cancelCancel(Context ctx, List ids) throws BOSException, EASBizException {
        return this.doCancel(ctx, ids, true);
    }

    @Override
    protected Map _cancel(Context ctx, List ids) throws BOSException, EASBizException {
        return this.doCancel(ctx, ids, false);
    }

    private Map doCancel(Context ctx, List ids, Boolean isEnable) throws EASBizException, BOSException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        Map<String, String> checkMap = null;
        ArrayList<String> updateIds = null;
        if (isEnable.booleanValue()) {
            checkMap = this.checkCancelCancel(ctx, ids);
            if (!checkMap.isEmpty()) {
                updateIds = new ArrayList<String>();
                Set<String> checkSet = checkMap.keySet();
                for (int index = 0; index < ids.size(); ++index) {
                    if (checkSet.contains(ids.get(index))) continue;
                    updateIds.add((String)ids.get(index));
                }
            } else {
                updateIds = ids;
            }
        } else {
            updateIds = this.getCancelIds(ctx, ids);
        }
        if (updateIds != null && !updateIds.isEmpty()) {
            this.updateCancelState(ctx, updateIds, isEnable);
        }
        return checkMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> checkCancelCancel(Context ctx, List ids) throws EASBizException, BOSException {
        IRowSet rst;
        Connection conn;
        LinkedHashMap<String, String> checkMap;
        block7: {
            checkMap = new LinkedHashMap<String, String>();
            if (ids == null) return checkMap;
            if (ids.isEmpty()) {
                return checkMap;
            }
            conn = null;
            TempTablePool pool = null;
            String tmpTable = null;
            rst = null;
            try {
                conn = BgDBUtils.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FID) values (?)", (Collection<String>)ids);
                String sql = "Select a.FID, a.FNumber, a.FParentId, p.FIsEnabled From T_MBG_BgAccount a  Join T_MBG_BgAccount p on a.FPARENTID   = p.FID Where a.FID in (Select FID from " + tmpTable + ") Order by a.FLongNumber";
                String id = null;
                String parentId = null;
                String number = null;
                boolean isEnable = false;
                rst = BgDBUtils.executeQuery(conn, sql);
                while (rst.next()) {
                    id = rst.getString("FID");
                    parentId = rst.getString("FParentId");
                    if (StringUtils.isEmpty((String)parentId)) continue;
                    number = rst.getString("FNumber");
                    isEnable = rst.getBoolean("FIsEnabled");
                    if (isEnable || !checkMap.containsKey(parentId) && ids.contains(parentId)) continue;
                    checkMap.put(id, number);
                }
                if (tmpTable == null) break block7;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        BgDBUtils.releaseTmpTable(pool, tmpTable);
                    }
                    SQLUtils.cleanup(rst, null, (Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable(pool, tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return checkMap;
    }

    private List<BgAccountInfo> getRootLst(BgAccountCollection colls) {
        ArrayList<BgAccountInfo> rootLst = new ArrayList<BgAccountInfo>();
        if (colls == null || colls.isEmpty()) {
            return rootLst;
        }
        int size = colls.size();
        BgAccountInfo info = null;
        BgAccountInfo pInfo = null;
        String longNum = null;
        String pLongNum = null;
        for (int i = size - 1; i >= 0; --i) {
            boolean isRoot = true;
            pInfo = colls.get(i);
            pLongNum = pInfo.getLongNumber();
            for (int j = 0; j < size; ++j) {
                info = colls.get(j);
                longNum = info.getLongNumber();
                if (!pLongNum.startsWith(longNum + "!") || pLongNum.equals(longNum)) continue;
                isRoot = false;
                break;
            }
            if (!isRoot) continue;
            rootLst.add(pInfo);
        }
        return rootLst;
    }

    private List<String> getCancelIds(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        BgAccountCollection colls = this.getAccountCollByIds(ctx, new HashSet(ids));
        List<BgAccountInfo> rootLst = this.getRootLst(colls);
        ArrayList<String> cancelIds = new ArrayList<String>();
        TreeBaseCollection tbColls = null;
        BgAccountInfo info = null;
        for (int i = 0; i < rootLst.size(); ++i) {
            cancelIds.add(rootLst.get(i).getId().toString());
            tbColls = this.getAllChildren(ctx, rootLst.get(i));
            if (tbColls == null || tbColls.isEmpty()) continue;
            for (int j = 0; j < tbColls.size(); ++j) {
                info = (BgAccountInfo)tbColls.get(j);
                if (!info.isIsEnabled()) continue;
                cancelIds.add(tbColls.get(j).getId().toString());
            }
        }
        return cancelIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateCancelState(Context ctx, List ids, Boolean isEnable) throws EASBizException, BOSException {
        Connection conn;
        block6: {
            if (ids == null) return;
            if (ids.isEmpty()) {
                return;
            }
            conn = null;
            TempTablePool pool = null;
            String tmpTable = null;
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userId = user.getId().toString();
            try {
                conn = BgDBUtils.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = BgDBUtils.createTmpTable(ctx, pool, "CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FID) values (?)", (Collection<String>)ids);
                String sql = null;
                sql = isEnable != false ? "update T_MBG_BgAccount set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(),FDisabledDate = null , FIsEnabled = 1 where FId in (select FID from " + tmpTable + ")" : "update T_MBG_BgAccount set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(), FDisabledDate = now() , FIsEnabled = 0 where FId in (select FID from " + tmpTable + ")";
                DbUtil.execute((Context)ctx, (String)sql);
                if (tmpTable == null) break block6;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        BgDBUtils.releaseTmpTable(pool, tmpTable);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable(pool, tmpTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected IObjectPK _submitforDataMigration(Context ctx, IObjectValue model, boolean isExistBgData) throws BOSException, EASBizException {
        if (ctx == null || model == null || !(model instanceof BgAccountInfo)) {
            return null;
        }
        if (StringUtils.isEmpty((String)((BgAccountInfo)model).getNumber())) {
            BgCodeNumberHelper codeHelper = new BgCodeNumberHelper(ctx, null, null);
            codeHelper.init(model, ((BgAccountInfo)model).getOrgUnit().getId().toString());
            if (codeHelper.isHasCodeNumber()) {
                this.applyNumber(ctx, codeHelper, (BgAccountInfo)model, ((BgAccountInfo)model).getOrgUnit().getId().toString());
            }
            if (StringUtils.isEmpty((String)((BgAccountInfo)model).getNumber())) {
                ((BgAccountInfo)model).setNumber("BgAccount-" + System.currentTimeMillis());
            }
        }
        if (((BgAccountInfo)model).getNumber().length() > 80) {
            throw new MbgDimException(MbgDimException.NUMBERTOLONG);
        }
        if (!BgNumberHelper.checkNumber(((BgAccountInfo)model).getNumber())) {
            throw new MbgDimException(MbgDimException.SPECIALCHARINNUMBER);
        }
        this.checkNumDump(ctx, model);
        Connection connection = this.getConnection(ctx);
        if (isExistBgData) {
            try {
                if (!this._exists(ctx, (IObjectPK)new ObjectUuidPK(((BgAccountInfo)model).getId()))) {
                    BgIntIdHelper.setIntIdOnlyAddNew(ctx, (CoreBaseInfo)((BgAccountInfo)model), ((BgAccountInfo)model).getBgAccountView().getId().toString(), true);
                }
                connection.setAutoCommit(false);
                Class classBgMigrationUtil = this.getClassBgMigrationUtil();
                Method method = classBgMigrationUtil.getMethod("submitforDataMigration", Context.class, Connection.class, IObjectValue.class);
                method.invoke(null, ctx, connection, model);
                connection.commit();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    throw new BOSException((Throwable)e1);
                }
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)connection);
            }
        }
        IObjectPK pk = this._submit(ctx, model);
        return pk;
    }

    private Class getClassBgMigrationUtil() throws BOSException {
        Class<?> util = null;
        try {
            util = Class.forName("com.kingdee.eas.ma.mbg.app.data.BgMigrationUtil");
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        return util;
    }

    @Override
    protected boolean _checkTmpData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null || !(model instanceof BgAccountInfo)) {
            return true;
        }
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            Class classBgMigrationUtil = this.getClassBgMigrationUtil();
            Method method = classBgMigrationUtil.getMethod("checkTmpData", Context.class, Connection.class, IObjectValue.class);
            Object invoke = method.invoke(null, ctx, connection, model);
            if (invoke != null && invoke instanceof Boolean) {
                boolean bl = (Boolean)invoke;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
        return true;
    }

    @Override
    protected Set _checkBgData(Context ctx, IObjectValue model, boolean isSelf) throws BOSException, EASBizException {
        if (ctx == null || model == null || !(model instanceof BgAccountInfo)) {
            return null;
        }
        Connection connection = this.getConnection(ctx);
        try {
            Class classBgMigrationUtil = this.getClassBgMigrationUtil();
            Method method = classBgMigrationUtil.getMethod("checkBgData", Context.class, Connection.class, IObjectValue.class, Boolean.TYPE);
            Object invoke = method.invoke(null, ctx, connection, model, isSelf);
            if (invoke != null && invoke instanceof Map) {
                Map map = (Map)invoke;
                Set set = map.get("dataIDSet") != null ? (Set)map.get("dataIDSet") : null;
                return set;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
        return null;
    }

    private void applyNumber(Context ctx, BgCodeNumberHelper codeHelper, BgAccountInfo model, String orgUnitId) throws EASBizException, BOSException {
        if (model.getNumber() != null) {
            return;
        }
        codeHelper.applyNumber((IObjectValue)model, orgUnitId, null);
        if (model.getNumber() != null && this._exists(ctx, "select id where number = '" + model.getNumber() + "'and bgAccountView.id = '" + model.getBgAccountView().getId().toString() + "'")) {
            model.setNumber(null);
            this.applyNumber(ctx, codeHelper, model, orgUnitId);
        }
    }

    protected int getDisplayNameLength() {
        return 255;
    }
}

