/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountGroupCollection;
import com.kingdee.eas.ma.base.BgAccountGroupFactory;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountViewCollection;
import com.kingdee.eas.ma.base.BgAccountViewFactory;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.app.AbstractBgAccountDistributeFacadeControllerBean;
import com.kingdee.eas.ma.base.app.utils.BgIntIdHelper;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.refmbg.BaseRefMbgHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.base.utils.OrderObject;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAccountDistributeFacadeControllerBean
extends AbstractBgAccountDistributeFacadeControllerBean {
    private static final long serialVersionUID = 1615031059875593630L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgAccountDistributeFacadeControllerBean");
    public static final String resource = "com.kingdee.eas.ma.base.BgAccountDistributeResource";
    private static final String BGACCOUNTVIEW = "bgAccountView";
    private static final String ORGUNIT = "orgUnit";
    private static final String VIEW_RESULT = "viewResult";
    private static final String VIEW_FAIL_REASON = "viewFailReason";
    private static final String BGACCOUNT = "bgAccount";
    private static final String BGACCOUNT_RESULT = "bgAccountResult";
    private static final String BGACCOUNT_FAIL_REASON = "bgAccountFailReason";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String bgAccountViewNumberRepeat = "bgAccountViewNumberRepeat";
    private static final String bgAccountNumberRepeat = "bgAccountNumberRepeat";
    private static final String bgAccountNumberHasBgData = "bgAccountNumberHasBgData";
    private static final String bgAccountNumberParentFail = "bgAccountNumberParentFail";
    private static final String isRefByScheme = "isRefByScheme";
    private static final String viewExistFailAntiMember = "viewExistFailAntiMember";
    private static final String hasRefByModelFormRule = "hasRefByModelFormRule";
    private static final String bgAccountAntiResult = "bgAccountAntiResult";
    private static final String existChildNumberNodispatch = "existChildNumberNodispatch";
    private static final String existChildNumberHasRef = "existChildNumberHasRef";
    private static final String parentGroupNotSame = "parentGroupNotSame";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _distribute(Context ctx, IObjectValue orgUnit, IObjectValue accountView, List bgAccounts, BgAccountGroupInfo accountGroup) throws BOSException, EASBizException {
        IRowSet rst;
        Connection conn;
        ArrayList<HashMap<OrderObject, String>> result;
        block37: {
            result = new ArrayList<HashMap<OrderObject, String>>();
            BgAccountViewInfo _accountView = (BgAccountViewInfo)accountView;
            DataBaseInfo _orgUnit = (DataBaseInfo)orgUnit;
            List _bgAccounts = bgAccounts;
            if (accountGroup == null) {
                return result;
            }
            BgAccountViewInfo _thisView = null;
            String thisViewId = "";
            Object var12_12 = null;
            BgAccountViewCollection viewCol = BgAccountViewFactory.getLocalInstance(ctx).getBgAccountViewCollection("select id, number, name, description, distributeViewRootId where number = '" + _accountView.getNumber() + "' and orgUnit.id = '" + _orgUnit.getId() + "' AND sourceType = " + _accountView.getSourceType().getValue());
            if (viewCol != null && !viewCol.isEmpty()) {
                _thisView = viewCol.get(0);
                thisViewId = _thisView.getId().toString();
                if (!_thisView.getDistributeViewRootId().equals((Object)_accountView.getDistributeViewRootId())) {
                    HashMap<OrderObject, String> hashMap = new HashMap<OrderObject, String>();
                    this.addOrderObject(ctx, hashMap, BGACCOUNTVIEW, _accountView.getName());
                    this.addOrderObject(ctx, hashMap, ORGUNIT, _orgUnit.getName());
                    this.addOrderObject(ctx, hashMap, VIEW_RESULT, this.getString(ctx, FAIL));
                    this.addOrderObject(ctx, hashMap, VIEW_FAIL_REASON, this.getString(ctx, bgAccountViewNumberRepeat));
                    this.addOrderObject(ctx, hashMap, BGACCOUNT, null);
                    this.addOrderObject(ctx, hashMap, BGACCOUNT_RESULT, null);
                    this.addOrderObject(ctx, hashMap, BGACCOUNT_FAIL_REASON, null);
                    result.add(hashMap);
                    return result;
                }
            }
            ArrayList<String> paramList = new ArrayList<String>();
            for (int i = 0; i < _bgAccounts.size(); ++i) {
                paramList.addAll(Arrays.asList(((TreeBaseInfo)_bgAccounts.get(i)).getLongNumber().split("!")));
            }
            conn = null;
            rst = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tmpTable = null;
            try {
                conn = this.getConnection(ctx);
                tmpTable = pool.createTempTable("Create Table T_MBG_BgAccountDist(FNumber NVarchar(80) NOT NULL, F2 NVARCHAR(84), FThisViewID VARCHAR(44), FThisViewRootID VARCHAR(44), FHasData INT)");
                MbgSqlHelper.executeBatch(conn, "Insert Into " + tmpTable + "(FNumber) values(?)", paramList);
                MbgSqlHelper.execute(conn, "Update " + tmpTable + " Set F2 = Concat('" + DimensionBaseConstants.DEF_INDEX_SRCNUMBER + ":', FNumber)");
                MbgSqlHelper.execute(conn, "Update " + tmpTable + " Set FHasData = 0");
                if (_thisView != null) {
                    MbgSqlHelper.executeBatch(conn, "Update " + tmpTable + " t0 Set FThisViewID = (Select FID FROM T_MBg_BgAccount t1 Where t0.FNumber = t1.FNumber AND t1.FBgAccountViewID = ?)", _thisView.getId().toString());
                    MbgSqlHelper.executeBatch(conn, "Update " + tmpTable + " t0 Set FThisViewRootID = (Select FDistributeRootID FROM T_MBg_BgAccount t1 Where t0.FNumber = t1.FNumber AND t1.FBgAccountViewID = ?) Where FThisViewID IS NOT NULL", _thisView.getId().toString());
                    paramList.clear();
                    paramList.add(_thisView.getId().toString());
                    List refCubes = MbgSqlHelper.executeBatchQuery(conn, "Select FRefCube FROM T_MBG_BgScheme Where FID IN(Select FBgSchemeId FROM T_MBG_BgDimSettings Where FID IN(SELECT FBgDimSettingsId FROM T_MBG_bgDimsettingsmember Where FMemberId = ?))", paramList);
                    String refCube = null;
                    if (refCubes != null && !refCubes.isEmpty()) {
                        for (int i = 0; i < refCubes.size(); ++i) {
                            refCube = (String)refCubes.get(i);
                            MbgSqlHelper.execute(conn, "Update " + tmpTable + " t0 Set FHasData = 1 Where FThisViewID IS NOT NULL AND FHasData = 0 AND Exists(Select FID FROM " + refCube + " t1 Where t0.F2 = t1.F2)");
                            MbgSqlHelper.execute(conn, "Update " + tmpTable + " t0 Set FHasData = 1 Where FThisViewID IS NOT NULL AND FHasData = 0 AND Exists(Select FID FROM " + BaseRefMbgHelper.getDailyActualCubeName(refCube) + " t1 Where t0.F2 = t1.F2)");
                        }
                    }
                }
                HashMap<String, String> number_id = new HashMap<String, String>();
                HashMap<String, String> number_rootId = new HashMap<String, String>();
                HashSet<String> hasDataNumbers = new HashSet<String>();
                rst = BgDBUtils.executeQuery(conn, "Select FNumber, FThisViewID, FThisViewRootID, FHasData FROM " + tmpTable + " Where FThisViewID IS NOT NULL");
                String number = null;
                String id = null;
                String rootId = null;
                while (rst.next()) {
                    number = rst.getString("FNumber");
                    id = rst.getString("FThisViewID");
                    rootId = rst.getString("FThisViewRootID");
                    number_id.put(number, id);
                    number_rootId.put(number, rootId);
                    if (!rst.getBoolean("FHasData")) continue;
                    hasDataNumbers.add(number);
                }
                SQLUtils.cleanup((ResultSet)rst);
                BgAccountInfo accountInfo2 = null;
                HashSet<String> sourceIds = new HashSet<String>();
                final LinkedHashMap<String, BgAccountInfo> sourceMap = new LinkedHashMap<String, BgAccountInfo>();
                for (int i = 0; i < _bgAccounts.size(); ++i) {
                    accountInfo2 = new BgAccountInfo();
                    accountInfo2.putAll((IObjectValue)_bgAccounts.get(i));
                    sourceMap.put(accountInfo2.getNumber(), accountInfo2);
                    sourceIds.add(accountInfo2.getId().toString());
                }
                StringBuffer sql = new StringBuffer();
                sql.append("Select FNumber, FLongNumber, FDistributeRootID, FLevel, FIsLeaf, FBgAccountGroupID FROM T_MBg_BgAccount Where FID IN(");
                MbgSqlHelper.addPlaceHolder(sql).append(")");
                MbgSqlHelper.executeBatchQuery(conn, sql.toString(), MbgSqlHelper.getBatchParams(null, sourceIds.toArray(), 50), new IResultReader(){

                    @Override
                    public void read(ResultSet res) throws SQLException {
                        String number = res.getString("FNumber");
                        ((BgAccountInfo)sourceMap.get(number)).setLongNumber(res.getString("FLongNumber"));
                        ((BgAccountInfo)sourceMap.get(number)).setDistributeRootID(BOSUuid.read((String)res.getString("FDistributeRootID")));
                        ((BgAccountInfo)sourceMap.get(number)).setLevel(res.getInt("FLevel"));
                        ((BgAccountInfo)sourceMap.get(number)).setIsLeaf(res.getBoolean("FIsLeaf"));
                    }
                });
                final LinkedHashMap acountGroupIdMap = new LinkedHashMap();
                final HashSet numberSet = new HashSet();
                sql = new StringBuffer();
                sql.append("Select t1.FNumber, t2.FNumber, t2.FBgAccountGroupID FROM T_MBg_BgAccount t1, T_MBg_BgAccount t2 Where t1.FParentID = t2.FID and t1.FID IN(");
                MbgSqlHelper.addPlaceHolder(sql).append(")");
                MbgSqlHelper.executeBatchQuery(conn, sql.toString(), MbgSqlHelper.getBatchParams(null, sourceIds.toArray(), 50), new IResultReader(){

                    @Override
                    public void read(ResultSet res) throws SQLException {
                        String number = res.getString(1);
                        String pnumber = res.getString(2);
                        numberSet.add(pnumber);
                        if (!acountGroupIdMap.containsKey(number)) {
                            acountGroupIdMap.put(number, new HashMap());
                        }
                        ((Map)acountGroupIdMap.get(number)).put(pnumber, res.getString("FBgAccountGroupID"));
                    }
                });
                final HashMap groupIdNumberMap = new HashMap();
                final LinkedHashMap targetAccMap = new LinkedHashMap();
                if (!numberSet.isEmpty()) {
                    sql = new StringBuffer();
                    sql.append("Select FNumber, FBgAccountGroupID FROM T_MBg_BgAccount Where FBgAccountViewID = '" + thisViewId + "' and FNumber IN(");
                    MbgSqlHelper.addPlaceHolder(sql).append(")");
                    MbgSqlHelper.executeBatchQuery(conn, sql.toString(), MbgSqlHelper.getBatchParams(null, numberSet.toArray(), 50), new IResultReader(){

                        @Override
                        public void read(ResultSet res) throws SQLException {
                            String number = res.getString("FNumber");
                            targetAccMap.put(number, res.getString("FBgAccountGroupID"));
                        }
                    });
                    sql = new StringBuffer();
                    sql.append("Select FID ,FNUMBER from T_MBG_BgAccountGroup where FVIEWID IN (").append(" select t1.FID from T_MBG_BgAccountView t1, T_MBG_BgAccountView t2 where t1.FDISTRIBUTEVIEWROOTID  = t2.FDISTRIBUTEVIEWROOTID and t2.FID = '").append(thisViewId).append("' )");
                    MbgSqlHelper.executeBatchQuery(conn, sql.toString(), null, new IResultReader(){

                        @Override
                        public void read(ResultSet res) throws SQLException, BOSException {
                            groupIdNumberMap.put(res.getString("FID"), res.getString("FNumber"));
                        }
                    });
                }
                HashMap<String, String> errorMap = new HashMap<String, String>();
                for (Map.Entry entry : acountGroupIdMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Map pmap = (Map)entry.getValue();
                    if (pmap == null) continue;
                    for (Map.Entry pentry : pmap.entrySet()) {
                        String pkey = (String)pentry.getKey();
                        String value = (String)pentry.getValue();
                        if (value == null || !targetAccMap.containsKey(pkey)) continue;
                        String targetAccGroupID = (String)targetAccMap.get(pkey);
                        if (!groupIdNumberMap.containsKey(value) || !groupIdNumberMap.containsKey(targetAccGroupID) || ((String)groupIdNumberMap.get(value)).equals(groupIdNumberMap.get(targetAccGroupID))) continue;
                        errorMap.put(key, parentGroupNotSame);
                    }
                }
                String[] lns = null;
                for (BgAccountInfo accountInfo2 : sourceMap.values()) {
                    if (number_rootId.containsKey(accountInfo2.getNumber()) && !accountInfo2.getDistributeRootID().toString().equals(number_rootId.get(accountInfo2.getNumber()))) {
                        errorMap.put(accountInfo2.getNumber(), bgAccountNumberRepeat);
                    }
                    lns = accountInfo2.getLongNumber().split("!");
                    for (int i = 0; i < lns.length - 1; ++i) {
                        if (!hasDataNumbers.contains(lns[i])) continue;
                        errorMap.put(accountInfo2.getNumber(), bgAccountNumberHasBgData);
                    }
                }
                for (BgAccountInfo accountInfo2 : sourceMap.values()) {
                    if (errorMap.containsKey(accountInfo2.getNumber())) continue;
                    lns = accountInfo2.getLongNumber().split("!");
                    for (int i = 0; i < lns.length - 1; ++i) {
                        if (!errorMap.containsKey(lns[i])) continue;
                        errorMap.put(accountInfo2.getNumber(), bgAccountNumberParentFail);
                    }
                }
                HashMap<String, String> target_source = new HashMap<String, String>();
                HashMap<String, BgAccountInfo> targetMap = new HashMap<String, BgAccountInfo>();
                HashSet<String> addNewSet = new HashSet<String>();
                HashSet<String> updateSet = new HashSet<String>();
                BgAccountInfo targetAccountInfo = null;
                for (BgAccountInfo accountInfo2 : sourceMap.values()) {
                    if (errorMap.containsKey(accountInfo2.getNumber())) {
                        HashMap<OrderObject, String> hashMap = new HashMap<OrderObject, String>();
                        this.addOrderObject(ctx, hashMap, BGACCOUNTVIEW, _accountView.getName());
                        this.addOrderObject(ctx, hashMap, ORGUNIT, _orgUnit.getName());
                        this.addOrderObject(ctx, hashMap, VIEW_RESULT, this.getString(ctx, SUCCESS));
                        this.addOrderObject(ctx, hashMap, BGACCOUNT, accountInfo2.getName());
                        this.addOrderObject(ctx, hashMap, BGACCOUNT_RESULT, this.getString(ctx, FAIL));
                        this.addOrderObject(ctx, hashMap, BGACCOUNT_FAIL_REASON, this.getString(ctx, (String)errorMap.get(accountInfo2.getNumber())));
                        result.add(hashMap);
                        continue;
                    }
                    targetAccountInfo = new BgAccountInfo();
                    targetAccountInfo.putAll((IObjectValue)accountInfo2);
                    targetAccountInfo.setIsLeaf(true);
                    if (number_id.containsKey(targetAccountInfo.getNumber())) {
                        targetAccountInfo.setId(BOSUuid.read((String)((String)number_id.get(targetAccountInfo.getNumber()))));
                        updateSet.add(targetAccountInfo.getNumber());
                    } else {
                        targetAccountInfo.setId(BOSUuid.create((BOSObjectType)targetAccountInfo.getBOSType()));
                        addNewSet.add(targetAccountInfo.getNumber());
                    }
                    target_source.put(targetAccountInfo.getId().toString(), accountInfo2.getId().toString());
                    targetMap.put(targetAccountInfo.getNumber(), targetAccountInfo);
                }
                final HashMap<String, BgAccountInfo> parentMap = new HashMap<String, BgAccountInfo>();
                if (_thisView != null) {
                    for (BgAccountInfo accountInfo2 : targetMap.values()) {
                        lns = accountInfo2.getLongNumber().split("!");
                        if (lns.length <= 1 || targetMap.containsKey(lns[lns.length - 2])) continue;
                        parentMap.put(lns[lns.length - 2], null);
                    }
                    if (!parentMap.isEmpty()) {
                        sql = new StringBuffer();
                        sql.append("Select FID, FNumber FROM T_MBg_BgAccount Where FBgAccountViewID = ? AND FNumber IN(");
                        MbgSqlHelper.addPlaceHolder(sql).append(")");
                        MbgSqlHelper.executeBatchQuery(conn, sql.toString(), MbgSqlHelper.getBatchParams(new Object[]{_thisView.getId().toString()}, parentMap.keySet().toArray(), 50), new IResultReader(){

                            @Override
                            public void read(ResultSet res) throws SQLException {
                                BgAccountInfo acc = new BgAccountInfo();
                                acc.setId(BOSUuid.read((String)res.getString("FID")));
                                acc.setNumber(res.getString("FNumber"));
                                parentMap.put(acc.getNumber(), acc);
                            }
                        });
                    }
                }
                for (BgAccountInfo accountInfo2 : targetMap.values()) {
                    lns = accountInfo2.getLongNumber().split("!");
                    if (lns.length <= 1) continue;
                    if (targetMap.containsKey(lns[lns.length - 2])) {
                        accountInfo2.setParent((BgAccountInfo)targetMap.get(lns[lns.length - 2]));
                    } else {
                        accountInfo2.setParent((BgAccountInfo)parentMap.get(lns[lns.length - 2]));
                    }
                    if (accountInfo2.getParent() == null) continue;
                    parentMap.put(accountInfo2.getParent().getNumber(), accountInfo2.getParent());
                }
                UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                String userId = currentUserInfo.getId().toString();
                String orgUnitId = _orgUnit.getId().toString();
                String viewId = null;
                if (_thisView == null) {
                    viewId = this.addNewBgAccountView(conn, userId, _accountView.getId().toString(), orgUnitId);
                } else {
                    viewId = _thisView.getId().toString();
                    this.updateBgAccountView(conn, viewId, _accountView.getId().toString());
                }
                if (accountGroup.getNumber() != null && !"ACG".equals(accountGroup.getNumber())) {
                    BgAccountGroupCollection bgAccountGroupCollection = BgAccountGroupFactory.getLocalInstance(ctx).getBgAccountGroupCollection("where number='" + accountGroup.getNumber() + "' and viewId.id = '" + viewId + "'");
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    if (bgAccountGroupCollection == null || bgAccountGroupCollection.isEmpty()) {
                        accountGroup.setDistributeViewRootId(accountGroup.getId());
                        accountGroup.setId(BOSUuid.create((BOSObjectType)new BgAccountGroupInfo().getBOSType()));
                        CostCenterOrgUnitInfo costCenterOrgUnitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
                        accountGroup.setOrgunit((CostCenterOrgUnitInfo)(costCenterOrgUnitInfo != null ? costCenterOrgUnitInfo : null));
                        accountGroup.setCreateTime(now);
                        accountGroup.setLastUpdateTime(now);
                        accountGroup.setCreator(currentUserInfo);
                        accountGroup.setLastUpdateUser(currentUserInfo);
                        BgAccountViewInfo bgAccountViewInfo = BgAccountViewFactory.getLocalInstance(ctx).getBgAccountViewInfo((IObjectPK)new ObjectUuidPK(viewId));
                        accountGroup.setViewId(bgAccountViewInfo);
                        BgAccountGroupFactory.getLocalInstance(ctx).addnew(accountGroup);
                    } else {
                        accountGroup = bgAccountGroupCollection.get(0);
                        accountGroup.setLastUpdateTime(now);
                        accountGroup.setLastUpdateUser(currentUserInfo);
                    }
                }
                this.updateBgAccount(userId, conn, updateSet, targetMap, target_source);
                this.addNewBggAccount(ctx, conn, userId, addNewSet, targetMap, target_source, viewId, orgUnitId, accountGroup);
                this.updateIsLeaf(conn, viewId, parentMap);
                this.updatePropertyRef(conn, pool, target_source);
                BgAccountCollection col = new BgAccountCollection();
                BgAccountInfo info = new BgAccountInfo();
                info.setBgAccountView(new BgAccountViewInfo());
                info.getBgAccountView().setId(BOSUuid.read((String)viewId));
                col.add(info);
                MbgVirtualView.getInstance(ctx).checkVirtualView((IObjectCollection)col);
                BgDimCacheUtils.clearDimMemberCache(ctx);
                if (tmpTable == null) break block37;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rst);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    private void updatePropertyRef(Connection conn, TempTablePool pool, Map<String, String> target_source) throws SQLException {
        if (target_source == null || target_source.isEmpty()) {
            return;
        }
        ArrayList<Object[]> paramListDel = new ArrayList<Object[]>();
        ArrayList<Object[]> paramListIns = new ArrayList<Object[]>();
        for (Map.Entry<String, String> entry : target_source.entrySet()) {
            paramListDel.add(new Object[]{entry.getKey(), entry.getValue()});
            paramListIns.add(new Object[]{entry.getKey(), entry.getValue(), entry.getKey()});
        }
        MbgSqlHelper.executeBatch(conn, "Delete FROM T_MBG_PropertyRefSource Where FSourceId = ? AND FPropertyID NOT IN(Select FPropertyID FROM T_MBG_PropertyRefSource Where FSourceId = ?)", paramListDel);
        MbgSqlHelper.executeBatch(conn, "Insert Into T_MBG_PropertyRefSource(FID, FSourceId, FPropertyID) Select newbosid('2C365DA4'), ?, FPropertyID FROM T_MBG_PropertyRefSource t1 Where FSourceId = ? AND not exists (Select FID FROM T_MBG_PropertyRefSource t2 Where t2.FSourceId = ? AND t2.FPropertyID = t1.FPropertyID)", paramListIns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TreeBaseInfo> getSourceIdsByNums(Connection conn, String viewid, BOSUuid id, List<String> paramList) {
        Connection connection = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        ArrayList<TreeBaseInfo> result = new ArrayList<TreeBaseInfo>();
        try {
            pst = conn.prepareStatement("Select FID,FNumber,FLongNumber FROM T_MBg_BgAccount Where FBGACCOUNTVIEWID = '" + viewid + "' AND FNumber IN " + this.getAppendStrByColls(paramList));
            rst = pst.executeQuery();
            BgAccountInfo info = null;
            while (rst.next()) {
                info = new BgAccountInfo();
                info.setId(BOSUuid.read((String)rst.getString("FID")));
                info.setNumber(rst.getString("FNumber"));
                info.setLongNumber(rst.getString("FLongNumber"));
                result.add(info);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst, connection);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pst, connection);
        }
        return result;
    }

    private void updateIsLeaf(Connection conn, String viewId, Map<String, BgAccountInfo> parentMap) throws SQLException {
        IRowSet rs = null;
        rs = BgDBUtils.executeQuery(conn, "Select t2.FNUMBER NUM FROM T_MBg_BgAccount t2 INNER JOIN T_MBg_BgAccount t3 ON t2.FID = t3.FPARENTID Where t2.FBgAccountViewID = '" + viewId + "'");
        HashSet<String> idSet = new HashSet<String>();
        while (rs.next()) {
            idSet.add(rs.getString("NUM"));
        }
        rs.close();
        ArrayList<Object> tmpList = new ArrayList<Object>();
        tmpList.add(viewId);
        if (!idSet.isEmpty()) {
            BgDBUtils.executeUpdate(conn, "Update T_MBg_BgAccount Set FIsLeaf = 0 Where FBgAccountViewID = ? AND FNumber IN " + this.getAppendStrByColls(idSet), tmpList);
        }
    }

    private void updateBgAccountView(Connection conn, String targetViewId, String sourceViewId) throws SQLException {
        String sql = "Update T_MBg_BgAccountView t0 Set (FName_L1, FName_L2, FName_L3, FDescription_L1, FDescription_L2, FDescription_L3) = (Select FName_L1, FName_L2, FName_L3, FDescription_L1, FDescription_L2, FDescription_L3 FROM T_MBg_BgAccountView t1 Where t1.FID = ?) Where t0.FID = ?";
        MbgSqlHelper.executeBatch(conn, sql, new Object[]{sourceViewId, targetViewId});
    }

    private String addNewBgAccountView(Connection conn, String userId, String sourceViewId, String orgUnitId) throws SQLException {
        int i;
        String[] commFields = new String[]{"FName_L1", "FName_L2", "FName_L3", "FDescription_L1", "FDescription_L2", "FDescription_L3", "FControlUnitID", "FNumber", "FLongNumber", "FLevel", "FIsLeaf", "FDistributeViewRootId", "FSourceType"};
        Timestamp now = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_MBg_BgAccountView(FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FParentID, FOrgUnitId");
        for (i = 0; i < commFields.length; ++i) {
            sql.append(", ").append(commFields[i]);
        }
        sql.append(") Select ?, ?, ?, ?, ?, ?, ?");
        for (i = 0; i < commFields.length; ++i) {
            sql.append(", ").append(commFields[i]);
        }
        sql.append(" FROM T_MBg_BgAccountView Where FID = ?");
        String newId = BOSUuid.create((BOSObjectType)new BgAccountViewInfo().getBOSType()).toString();
        MbgSqlHelper.executeBatch(conn, sql.toString(), new Object[]{newId, userId, now, userId, now, newId, orgUnitId, sourceViewId});
        return newId;
    }

    private void addNewBggAccount(Context ctx, Connection conn, String userId, Set<String> addNewSet, Map<String, BgAccountInfo> targetMap, Map<String, String> target_source, String viewId, String orgUnitId, BgAccountGroupInfo accountGroup) throws SQLException, BOSException {
        int i;
        if (addNewSet.isEmpty()) {
            return;
        }
        String[] commFields = new String[]{"FName_L1", "FName_L2", "FName_L3", "FDescription_L1", "FDescription_L2", "FDescription_L3", "FPolAlgorithm", "FPeriodAlgorithm", "FBgAccountType", "FBgAccountDataType", "FBgDecreditAlgorithm", "FControlUnitID", "FNumber", "FLongNumber", "FBgAccountSortID", "FLevel", "FDistributeRootID"};
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_MBg_BgAccount(FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FParentID, FBgAccountViewID, FIsLeaf, FOrgUnitId, FIntID, FBgAccountGroupID");
        for (i = 0; i < commFields.length; ++i) {
            sql.append(", ").append(commFields[i]);
        }
        sql.append(") Select ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?");
        for (i = 0; i < commFields.length; ++i) {
            sql.append(", ").append(commFields[i]);
        }
        sql.append(" FROM T_MBg_BgAccount Where FID = ?");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        String number2 = null;
        BgAccountInfo accountInfo = null;
        CoreBaseCollection col = new CoreBaseCollection();
        for (String number2 : addNewSet) {
            accountInfo = targetMap.get(number2);
            col.add((CoreBaseInfo)accountInfo);
        }
        BgIntIdHelper.setIntIdOnlyAddNew(ctx, (IObjectCollection)col, viewId, true);
        for (String number2 : addNewSet) {
            accountInfo = targetMap.get(number2);
            params = new Object[]{accountInfo.getId().toString(), userId, now, userId, now, accountInfo.getParent() == null ? null : accountInfo.getParent().getId().toString(), viewId, 1, orgUnitId, accountInfo.getIntID(), accountGroup.getId().toString(), target_source.get(params[0])};
            paramList.add(params);
        }
        MbgSqlHelper.executeBatch(conn, sql.toString(), paramList);
    }

    private void updateBgAccount(String userId, Connection conn, Set<String> updateSet, Map<String, BgAccountInfo> targetMap, Map<String, String> target_source) throws SQLException {
        int i;
        if (updateSet.isEmpty()) {
            return;
        }
        String[] commFields = new String[]{"FName_L1", "FName_L2", "FName_L3", "FDescription_L1", "FDescription_L2", "FDescription_L3", "FPolAlgorithm", "FPeriodAlgorithm", "FBgAccountType", "FBgAccountDataType", "FBgDecreditAlgorithm", "FBgAccountSortID"};
        StringBuffer sql = new StringBuffer();
        sql.append("Update T_Mbg_BgAccount t0  Set (FLastUpdateUserID, FLastUpdateTime");
        for (i = 0; i < commFields.length; ++i) {
            sql.append(", ").append(commFields[i]);
        }
        sql.append(") = (Select ?, ?");
        for (i = 0; i < commFields.length; ++i) {
            sql.append(", ").append(commFields[i]);
        }
        sql.append(" FROM T_Mbg_BgAccount t1 Where t1.FID = ?) Where t0.FID = ?");
        Timestamp now = new Timestamp(System.currentTimeMillis());
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        String number2 = null;
        BgAccountInfo accountInfo = null;
        for (String number2 : updateSet) {
            accountInfo = targetMap.get(number2);
            params = new Object[4];
            params[0] = userId;
            params[1] = now;
            params[3] = accountInfo.getId().toString();
            params[2] = target_source.get(params[3]);
            paramList.add(params);
        }
        MbgSqlHelper.executeBatch(conn, sql.toString(), paramList);
    }

    private void addOrderObject(Context ctx, Map<OrderObject, String> orderMap, String key, String value) {
        orderMap.put(this.createOrderObject(ctx, key), value);
    }

    private OrderObject createOrderObject(Context ctx, String key) {
        return new OrderObject(key, this.getString(ctx, key), this.getOrder(key));
    }

    private String getString(Context ctx, String key) {
        return ResourceBase.getString((String)resource, (String)key, (Locale)ctx.getLocale());
    }

    private String getString(Context ctx, String key, Object[] params) {
        return EASResource.getString((String)resource, (String)key, (Object[])params);
    }

    private int getOrder(String key) {
        if (BGACCOUNTVIEW.equals(key)) {
            return 0;
        }
        if (ORGUNIT.equals(key)) {
            return 1;
        }
        if (VIEW_RESULT.equals(key)) {
            return 2;
        }
        if (VIEW_FAIL_REASON.equals(key)) {
            return 3;
        }
        if (BGACCOUNT.equals(key)) {
            return 4;
        }
        if (BGACCOUNT_RESULT.equals(key)) {
            return 5;
        }
        if (BGACCOUNT_FAIL_REASON.equals(key)) {
            return 6;
        }
        if (hasRefByModelFormRule.equals(key)) {
            return 7;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _AntiDistribute(Context ctx, IObjectValue orgUnit, IObjectValue accountView, List accts, BgAccountGroupInfo accountGroup) throws BOSException, EASBizException {
        ResultSet rst;
        Connection conn;
        ArrayList<HashMap<OrderObject, String>> result;
        block28: {
            result = new ArrayList<HashMap<OrderObject, String>>();
            BgAccountViewInfo _accountView = (BgAccountViewInfo)accountView;
            DataBaseInfo _orgUnit = (DataBaseInfo)orgUnit;
            List _bgAccounts = accts;
            if (accts == null) return result;
            if (accts.isEmpty()) return result;
            if (_accountView.getId() == null) {
                return result;
            }
            conn = null;
            PreparedStatement pstmt = null;
            PreparedStatement pstmt1 = null;
            rst = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tmpTable = null;
            String sql = null;
            Object var17_17 = null;
            try {
                List<String> isSelectedMem;
                conn = this.getConnection(ctx);
                BgAccountViewCollection viewCol = BgAccountViewFactory.getLocalInstance(ctx).getBgAccountViewCollection("select id, number, name, description, distributeViewRootId where number = '" + _accountView.getNumber() + "' and orgUnit.id = '" + _orgUnit.getId() + "'");
                _accountView = viewCol.get(0);
                HashMap<String, String> errorMap = new HashMap<String, String>();
                Map<String, String> antiAcctMemNum = this.getAllChildBySelectAcctMem(ctx, _accountView, _orgUnit, _bgAccounts, errorMap);
                HashSet<String> accNumSet = new HashSet<String>();
                ArrayList<String> groupIdList = new ArrayList<String>();
                if (_bgAccounts != null) {
                    for (int i = 0; i < _bgAccounts.size(); ++i) {
                        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)_bgAccounts.get(i);
                        if (treeBaseInfo == null) continue;
                        accNumSet.add(treeBaseInfo.getNumber());
                    }
                }
                if (!accNumSet.isEmpty()) {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setSelector(new SelectorItemCollection());
                    evi.getSelector().add("*");
                    evi.getSelector().add("group.*");
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", accNumSet, CompareType.INCLUDE));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)_accountView.getId().toString()));
                    BgAccountCollection bgAccountCollection = BgAccountFactory.getLocalInstance(ctx).getBgAccountCollection(evi);
                    if (bgAccountCollection != null && !bgAccountCollection.isEmpty()) {
                        for (int i = 0; i < bgAccountCollection.size(); ++i) {
                            BgAccountInfo bgAccountInfo = bgAccountCollection.get(i);
                            if (bgAccountInfo == null) continue;
                            groupIdList.add(bgAccountInfo.getGroup().getId().toString());
                        }
                    }
                }
                sql = "Create Table T_MBg_TMPAccModel(FID Varchar(44) NOT NULL, FNumber NVarchar(80) NOT NULL, FLongNumber NVarchar(1024) NOT NULL, FLevel INT Default 0 NOT NULL, FIsRef INT Default 0 NOT NULL, FIsDelete INT Default 0 NOT NULL, FIsSelected INT Default 0 NOT NULL, FParentID Varchar(44), FHasSub INT Default 0 NOT NULL)";
                tmpTable = pool.createTempTable(sql);
                sql = "Insert Into " + tmpTable + "(FID, FNumber, FLongNumber, FLevel, FParentID) Select FID,  FNumber, FLongNumber, FLevel,FParentID FROM T_MBG_BGACCOUNT Where FBGACCOUNTVIEWID = '" + _accountView.getId().toString() + "'";
                if (!antiAcctMemNum.isEmpty()) {
                    sql = sql + " AND FID IN " + this.getAppendStrByColls(antiAcctMemNum.keySet());
                }
                MbgSqlHelper.execute(conn, sql);
                List<String> isRefByOther = this.getRefByOtherObject(ctx, antiAcctMemNum.keySet());
                if (!isRefByOther.isEmpty()) {
                    MbgSqlHelper.executeBatch(conn, "Update " + tmpTable + " Set FIsRef = 1 Where FID = ? ", isRefByOther);
                }
                if (!(isSelectedMem = this.getSelectedMemByAccts(ctx, _bgAccounts)).isEmpty()) {
                    MbgSqlHelper.executeBatch(conn, "Update " + tmpTable + " Set FIsSelected = 1 Where FNumber = ? ", isSelectedMem);
                }
                int maxLevel = 0;
                sql = "Select Max(FLevel) FROM " + tmpTable;
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    maxLevel = rst.getInt(1);
                }
                SQLUtils.cleanup((ResultSet)rst);
                SQLUtils.cleanup((Statement)pstmt);
                sql = "Update " + tmpTable + " t1 Set FHasSub = 1 Where FLevel = ? AND exists (Select FID FROM " + tmpTable + " t2 Where t2.FParentID = t1.FID AND t2.FIsDelete = 0)";
                pstmt = conn.prepareStatement(sql);
                sql = "Update " + tmpTable + " Set FIsDelete = 1 Where FLevel = ? AND FHasSub = 0 AND FIsRef = 0";
                pstmt1 = conn.prepareStatement(sql);
                for (int level = maxLevel; level > 0; --level) {
                    pstmt.setInt(1, level);
                    pstmt.executeUpdate();
                    pstmt1.setInt(1, level);
                    pstmt1.executeUpdate();
                }
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Statement)pstmt1);
                sql = "Select FID, FNumber, FIsRef,FIsSelected, FLevel, FIsDelete, FParentID,FHasSub FROM " + tmpTable;
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                ArrayList<String> deleteList = new ArrayList<String>();
                HashSet<String> refParSet = new HashSet<String>();
                String number = null;
                String id = null;
                String parentid = null;
                boolean isSelected = false;
                boolean isDelete = false;
                boolean isRef = false;
                while (rst.next()) {
                    id = rst.getString("FID");
                    number = rst.getString("FNumber");
                    parentid = rst.getString("FParentID");
                    isSelected = rst.getBoolean("FIsSelected");
                    isDelete = rst.getBoolean("FIsDelete");
                    isRef = rst.getBoolean("FIsRef");
                    if (isRef) {
                        errorMap.put(number, hasRefByModelFormRule);
                        refParSet.add(parentid);
                    }
                    if (!isDelete) continue;
                    if (isSelected) {
                        deleteList.add(id);
                        continue;
                    }
                    if (refParSet.contains(parentid)) continue;
                    deleteList.add(id);
                }
                SQLUtils.cleanup((ResultSet)rst);
                SQLUtils.cleanup((Statement)pstmt);
                if (!errorMap.isEmpty()) {
                    HashMap<OrderObject, String> hashMap = new HashMap<OrderObject, String>();
                    String numberItr2 = null;
                    StringBuffer buff = new StringBuffer();
                    for (String numberItr2 : errorMap.keySet()) {
                        buff.append(numberItr2).append(" ");
                    }
                    this.addOrderObject(ctx, hashMap, bgAccountAntiResult, this.getString(ctx, (String)errorMap.get(numberItr2), new Object[]{buff.toString()}));
                    result.add(hashMap);
                } else if (!deleteList.isEmpty()) {
                    MbgSqlHelper.executeBatch(conn, "DELETE FROM T_MBG_BGACCOUNT WHERE FBGACCOUNTVIEWID = '" + _accountView.getId().toString() + "' AND FID = ?", deleteList);
                    MbgSqlHelper.executeBatch(conn, "DELETE FROM T_MBG_PropertyRefSource WHERE FSourceID = ?", deleteList);
                    this.deleteGroupIsEmpty(conn, rst, groupIdList);
                }
                rst = BgDBUtils.executeQuery(ctx, "SELECT COUNT(FID) COUNT FROM T_MBG_BGACCOUNT WHERE FBGACCOUNTVIEWID = '" + _accountView.getId().toString() + "' AND FORGUNITID = '" + _orgUnit.getId().toString() + "'");
                int count = -1;
                if (rst.next()) {
                    count = rst.getInt(1);
                }
                if (count != 0) {
                    this.updateIsLeaf(conn, _accountView.getId().toString());
                }
                if (count == 0) {
                    if (this.isReferencedByScheme(ctx, _accountView.getId().toString())) {
                        HashMap<OrderObject, String> hashMap = new HashMap<OrderObject, String>();
                        this.addOrderObject(ctx, hashMap, BGACCOUNTVIEW, _accountView.getName());
                        result.add(hashMap);
                    } else {
                        MbgSqlHelper.execute(conn, "DELETE FROM T_MBG_BGACCOUNTVIEW WHERE FID = '" + _accountView.getId().toString() + "' AND  FORGUNITID = '" + _orgUnit.getId().toString() + "'");
                        MbgSqlHelper.execute(conn, "DELETE FROM T_MBG_BgAccountGroup WHERE FViewId = '" + _accountView.getId().toString() + "' and FNumber <> 'ACG'");
                        BgIntIdHelper.deleteView(ctx, _accountView.getId().toString());
                    }
                }
                if (tmpTable == null) break block28;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rst);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    private void deleteGroupIsEmpty(Connection conn, ResultSet rst, List<String> groupIdList) throws Exception {
        PreparedStatement pstmt = null;
        try {
            if (!groupIdList.isEmpty()) {
                int i;
                StringBuilder sql1 = new StringBuilder();
                sql1.append("SELECT count(FID), FBgAccountGroupID FROM T_MBG_BGACCOUNT where FBgAccountGroupID in (");
                for (i = 0; i < groupIdList.size(); ++i) {
                    if (i == 0) {
                        sql1.append("?");
                        continue;
                    }
                    sql1.append(",?");
                }
                sql1.append(") group by FBgAccountGroupID");
                pstmt = conn.prepareStatement(sql1.toString());
                for (i = 0; i < groupIdList.size(); ++i) {
                    pstmt.setString(i + 1, groupIdList.get(i));
                }
                HashSet<String> existAccOfGroup = new HashSet<String>();
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    existAccOfGroup.add(rst.getString("FBgAccountGroupID"));
                }
                groupIdList.removeAll(existAccOfGroup);
                if (!groupIdList.isEmpty()) {
                    MbgSqlHelper.executeBatch(conn, "DELETE FROM T_MBG_BgAccountGroup WHERE FId = ? and FNumber <> 'ACG'", groupIdList);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
            SQLUtils.cleanup(pstmt);
        }
    }

    private List<String> getSelectedMemByAccts(Context ctx, List<TreeBaseInfo> _bgAccounts) {
        ArrayList<String> selectList = new ArrayList<String>();
        if (ctx == null || _bgAccounts.isEmpty()) {
            return selectList;
        }
        for (int i = 0; i < _bgAccounts.size(); ++i) {
            selectList.add(_bgAccounts.get(i).getNumber());
        }
        return selectList;
    }

    private String getAppendStrByColls(Collection<String> userGroupIds) {
        if (userGroupIds == null || userGroupIds.isEmpty()) {
            return null;
        }
        StringBuffer selectGroupStr = new StringBuffer();
        selectGroupStr.append("(");
        Iterator<String> it = userGroupIds.iterator();
        while (it.hasNext()) {
            selectGroupStr.append("'").append(it.next()).append("',");
        }
        selectGroupStr.delete(selectGroupStr.length() - 1, selectGroupStr.length()).append(")");
        return selectGroupStr.toString();
    }

    private List<String> getRefByOtherObject(Context ctx, Set<String> keySet) throws EASBizException, BOSException {
        ArrayList<String> refList = new ArrayList<String>();
        if (ctx == null || keySet.isEmpty()) {
            return refList;
        }
        Map refResult = BgAccountFactory.getLocalInstance(ctx).checkRef(keySet);
        HashSet refSet = new HashSet();
        Set refSetIds = null;
        Iterator it = refResult.keySet().iterator();
        while (it.hasNext()) {
            refSetIds = (Set)refResult.get(it.next());
            if (refSetIds == null || refSetIds.isEmpty()) continue;
            refSet.addAll(refSetIds);
        }
        refList.addAll(refSet);
        return refList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAllChildBySelectAcctMem(Context ctx, BgAccountViewInfo _accountView, DataBaseInfo _orgUnit, List<TreeBaseInfo> _bgAccounts, Map<String, String> errorMap) {
        HashMap<String, String> allMems = new HashMap<String, String>();
        if (_bgAccounts == null || _bgAccounts.isEmpty() || _accountView.getId() == null) {
            return allMems;
        }
        HashSet<String> prefixNumSet = new HashSet<String>();
        HashSet<String> rootNumSet = new HashSet<String>();
        HashMap<String, String> numberLongNumMap = new HashMap<String, String>();
        HashMap numberTrueMap = new HashMap();
        HashMap<String, BgAccountInfo> numberAccountInfoMap = new HashMap<String, BgAccountInfo>();
        String prefixNum = null;
        String longNum = null;
        String number = null;
        int index = -1;
        int count = _bgAccounts.size();
        for (int i = 0; i < count; ++i) {
            number = _bgAccounts.get(i).getNumber();
            longNum = _bgAccounts.get(i).getLongNumber();
            index = _bgAccounts.get(i).getLongNumber().indexOf("!");
            if (index != -1) {
                prefixNum = longNum.substring(0, index + 1);
                if (!rootNumSet.contains(longNum) && !prefixNumSet.contains(prefixNum)) {
                    rootNumSet.add(number);
                    numberLongNumMap.put(number, longNum);
                    prefixNumSet.add(longNum + "!");
                    continue;
                }
                if (prefixNumSet.contains(prefixNum)) continue;
                prefixNumSet.add(prefixNum);
                continue;
            }
            rootNumSet.add(longNum);
            numberLongNumMap.put(number, longNum);
            prefixNumSet.add(longNum + "!");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID,FNUMBER,FDISTRIBUTEROOTID,FLONGNUMBER FROM T_MBG_BGACCOUNT WHERE FBGACCOUNTVIEWID = '").append(_accountView.getId().toString()).append("' AND ( FNUMBER IN ( ");
        Iterator it = rootNumSet.iterator();
        while (it.hasNext()) {
            sql.append("'").append((String)it.next()).append("'").append(",");
        }
        sql.delete(sql.length() - 1, sql.length()).append(")");
        it = prefixNumSet.iterator();
        while (it.hasNext()) {
            sql.append(" OR FLONGNUMBER LIKE ").append("'").append((String)it.next()).append("%").append("'");
        }
        sql.append(")");
        IRowSet rowset = null;
        String rootnumber2 = null;
        BgAccountInfo info = null;
        try {
            rowset = BgDBUtils.executeQuery(ctx, sql.toString());
            while (rowset.next()) {
                info = new BgAccountInfo();
                info.setId(BOSUuid.read((String)rowset.getString("FID")));
                info.setNumber(rowset.getString("FNUMBER"));
                info.setLongNumber(rowset.getString("FLONGNUMBER"));
                info.setDistributeRootID(BOSUuid.read((String)rowset.getString("FDISTRIBUTEROOTID")));
                numberAccountInfoMap.put(rowset.getString("FLONGNUMBER"), info);
                allMems.put(rowset.getString("FID"), rowset.getString("FNUMBER"));
            }
            for (String rootnumber2 : numberLongNumMap.keySet()) {
                for (String longnumber : numberAccountInfoMap.keySet()) {
                    HashSet<String> idset;
                    if (!longnumber.startsWith((String)numberLongNumMap.get(rootnumber2))) continue;
                    if (((BgAccountInfo)numberAccountInfoMap.get(longnumber)).getId().toString().equals(((BgAccountInfo)numberAccountInfoMap.get(longnumber)).getDistributeRootID().toString())) {
                        if (numberTrueMap.get(rootnumber2) == null) {
                            idset = new HashSet<String>();
                            idset.add("_");
                            numberTrueMap.put(rootnumber2, idset);
                            continue;
                        }
                        ((Set)numberTrueMap.get(rootnumber2)).add("_");
                        continue;
                    }
                    if (numberTrueMap.get(rootnumber2) == null) {
                        idset = new HashSet();
                        idset.add(((BgAccountInfo)numberAccountInfoMap.get(longnumber)).getId().toString());
                        numberTrueMap.put(rootnumber2, idset);
                        continue;
                    }
                    ((Set)numberTrueMap.get(rootnumber2)).add(((BgAccountInfo)numberAccountInfoMap.get(longnumber)).getId().toString());
                }
            }
            for (String key : numberTrueMap.keySet()) {
                Set idset = (Set)numberTrueMap.get(key);
                if (!idset.contains("_")) continue;
                errorMap.put(key, existChildNumberNodispatch);
                for (String id : idset) {
                    if (id.equals("_")) continue;
                    allMems.remove(id);
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rowset);
        }
        SQLUtils.cleanup((ResultSet)rowset);
        return allMems;
    }

    protected boolean isReferencedByScheme(Context ctx, String viewID) throws BOSException {
        String sql = "select count(Fid) from T_MBG_BgDimSettingsMember where FMemberID = ?";
        IRowSet rowset = null;
        boolean isReferenced = false;
        try {
            int count;
            rowset = BgDBUtils.executeQuery(ctx, sql, new Object[]{viewID});
            if (rowset.next() && (count = Integer.valueOf(rowset.getString(1)).intValue()) >= 1) {
                isReferenced = true;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowset);
        return isReferenced;
    }

    protected void updateIsLeaf(Connection conn, String viewId) throws BOSException {
        MbgSqlHelper.execute(conn, "UPDATE T_MBG_BgAccount SET FISLEAF = 1 WHERE  fid in (select FID  from T_MBG_BgAccount where FBGACCOUNTVIEWID  = '" + viewId + "' and FID  not in (SELECT FParentid FROM T_MBG_BgAccount where FBGACCOUNTVIEWID  = '" + viewId + "' and (FPARENTID is not null or FPARENTID <> '')))");
    }
}

