/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.AbstractBgAccountSortControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BgAccountSortControllerBean
extends AbstractBgAccountSortControllerBean {
    private static final long serialVersionUID = 3236890616295731000L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgAccountSortControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNumberDup(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        return super._submit(ctx, model);
    }

    @Override
    protected boolean _isRefByAccount(Context ctx, String bgAccountSortID) throws BOSException, EASBizException {
        boolean isRefByIndex = false;
        if (bgAccountSortID == null) {
            isRefByIndex = false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select FBgAccountSortID from T_MBG_BgAccount where FBgAccountSortID=?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, bgAccountSortID);
            rs = ps.executeQuery();
            isRefByIndex = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isRefByIndex;
    }

    @Override
    protected boolean _isRefByOrgEntrust(Context ctx, String bgAccountSortID) throws BOSException, EASBizException {
        boolean isRefByOrgEntrust = false;
        if (bgAccountSortID == null) {
            isRefByOrgEntrust = false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select FBgIndexSortID from T_MBG_BgControlOrgEntrust where FBgIndexSortID=?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, bgAccountSortID);
            rs = ps.executeQuery();
            isRefByOrgEntrust = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isRefByOrgEntrust;
    }

    @Override
    protected List _getRefIDs(Context ctx, List idLst) throws BOSException, EASBizException {
        ArrayList<String> refList = new ArrayList<String>();
        if (idLst == null) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        int index = 0;
        int batchSize = 50;
        int size = idLst.size();
        int pos = 0;
        int pos1 = 0;
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        sql1.append("select FBgIndexSortID from T_MBG_BgControlOrgEntrust where FBgIndexSortID in (");
        sql2.append("select FBgAccountSortID from T_MBG_BgAccount where FBgAccountSortID in (");
        for (index = 1; index < batchSize; ++index) {
            sql1.append("?,");
            sql2.append("?,");
        }
        sql1.append("?)");
        sql2.append("?)");
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql1.toString());
            int i = 1;
            while (i < batchSize + 1) {
                if (pos < size) {
                    ps.setString(i, idLst.get(pos).toString());
                } else {
                    ps.setString(i, "#");
                }
                ++i;
                ++pos;
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String id = rs.getString(1).toString();
                if (refList.contains(id)) continue;
                refList.add(id);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            ps = connection.prepareStatement(sql2.toString());
            i = 1;
            while (i < batchSize + 1) {
                if (pos1 < size) {
                    ps.setString(i, idLst.get(pos1).toString());
                } else {
                    ps.setString(i, "#");
                }
                ++i;
                ++pos1;
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String id = rs.getString(1).toString();
                if (refList.contains(id)) continue;
                refList.add(id);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return refList;
    }
}

