/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgAccountException;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.app.AbstractBgAccountViewControllerBean;
import com.kingdee.eas.ma.base.app.utils.BgIntIdHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BgAccountViewControllerBean
extends AbstractBgAccountViewControllerBean {
    private static final long serialVersionUID = 8901269119435781659L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgAccountViewControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAccountViewInfo info = (BgAccountViewInfo)model;
        if (this.isNumberExists(ctx, info)) {
            throw new BgAccountException(BgAccountException.NUMEXISTS);
        }
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        if (info.getDistributeViewRootId() == null) {
            info.setDistributeViewRootId(info.getId());
        }
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this._isHasAccount(ctx, pk)) {
            throw new BgAccountException(BgAccountException.HASACCOUNT);
        }
        if (this.checkIsRefByModel(ctx, pk)) {
            throw new BgAccountException(BgAccountException.REFBYSCHEME);
        }
        if (this.checkHasSubView(ctx, pk)) {
            throw new BgAccountException(BgAccountException.HASSUBVIEW);
        }
        if (this.checkIsDistributedView(ctx, pk)) {
            throw new BgAccountException(BgAccountException.CANTDELETEDISTRIBUTEDVIEW);
        }
        super._delete(ctx, pk);
        BgIntIdHelper.deleteView(ctx, pk.toString());
        MbgVirtualView.getInstance(ctx).recycleVirtualView(pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkIsDistributedView(Context ctx, IObjectPK pk) {
        boolean isDistributeView;
        Connection conn;
        IRowSet rst;
        block6: {
            rst = null;
            conn = null;
            isDistributeView = false;
            String id = pk.toString();
            StringBuffer sql = new StringBuffer("SELECT FDISTRIBUTEVIEWROOTID FROM T_MBG_BGACCOUNTVIEW WHERE FID = '" + id + "'");
            try {
                conn = BgDBUtils.getConnection(ctx);
                rst = BgDBUtils.executeQuery(conn, sql.toString());
                if (!rst.next() || id.equals(rst.getString("FDISTRIBUTEVIEWROOTID"))) break block6;
                isDistributeView = true;
            }
            catch (SQLDataException e) {
                logger.error((Object)("sqldata error:" + (Object)((Object)e)));
                SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            }
            catch (SQLException e2) {
                logger.error((Object)("sql error:" + e2));
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, null, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return isDistributeView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkHasSubView(Context ctx, IObjectPK pk) {
        boolean hasSubView;
        block9: {
            Connection conn;
            IRowSet rst;
            block7: {
                boolean bl;
                block8: {
                    rst = null;
                    conn = null;
                    hasSubView = false;
                    int count = -1;
                    StringBuffer sql = new StringBuffer("SELECT COUNT(FDISTRIBUTEVIEWROOTID) FROM T_MBG_BGACCOUNTVIEW WHERE FDISTRIBUTEVIEWROOTID = '" + pk.toString() + "'");
                    conn = BgDBUtils.getConnection(ctx);
                    rst = BgDBUtils.executeQuery(conn, sql.toString());
                    if (!rst.next()) break block7;
                    count = rst.getInt(1);
                    if (count <= 1) break block8;
                    boolean bl2 = true;
                    SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
                    return bl2;
                }
                try {
                    bl = false;
                }
                catch (SQLDataException e) {
                    logger.error((Object)("sqldata error:" + (Object)((Object)e)));
                    SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
                    break block9;
                }
                catch (SQLException e2) {
                    logger.error((Object)("sql error:" + e2));
                    {
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst, null, (Connection)conn);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
                }
                SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
                return bl;
            }
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        }
        return hasSubView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkIsRefByModel(Context ctx, IObjectPK pk) {
        boolean isRefByModel;
        Connection conn;
        IRowSet rst;
        block6: {
            rst = null;
            conn = null;
            isRefByModel = false;
            StringBuffer sql = new StringBuffer("SELECT top 1 fmemberid FROM T_mbg_bgdimsettingsMember WHERE Fmemberid = '" + pk.toString() + "'");
            try {
                conn = BgDBUtils.getConnection(ctx);
                rst = BgDBUtils.executeQuery(conn, sql.toString());
                if (!rst.next()) break block6;
                isRefByModel = true;
            }
            catch (SQLDataException e) {
                logger.error((Object)("sqldata error:" + (Object)((Object)e)));
                SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            }
            catch (SQLException e2) {
                logger.error((Object)("sql error:" + e2));
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, null, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return isRefByModel;
    }

    private boolean isNumberExists(Context ctx, BgAccountViewInfo info) throws EASBizException, BOSException {
        if (info == null || StringUtils.isEmpty((String)info.getNumber()) || info.getOrgUnit().getId() == null) {
            return true;
        }
        String number = info.getNumber();
        String orgUnitId = info.getOrgUnit().getId().toString();
        String oql = null;
        oql = info.getId() == null ? "select id where number = '" + number + "' and orgunit.id = '" + orgUnitId + "'" : "select id where number = '" + number + "' and orgunit.id = '" + orgUnitId + "' and id <> '" + info.getId().toString() + "'";
        return this._exists(ctx, oql);
    }

    @Override
    protected boolean _isHasAccount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select top 1 FID from T_MBG_BgAccount where FBgAccountViewId = '" + pk.toString() + "'";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowset.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        if (model == null) {
            return null;
        }
        FilterInfo curCUFilter = super.getFilterForDefaultCU(ctx, model);
        BgAccountViewInfo bgAccountInfo = (BgAccountViewInfo)model;
        curCUFilter.getFilterItems().add(new FilterItemInfo("id", (Object)bgAccountInfo.getId().toString(), CompareType.EQUALS));
        curCUFilter.setMaskString(" #0 AND #1");
        return curCUFilter;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAccountViewInfo info = (BgAccountViewInfo)model;
        if (this.isNumberExists(ctx, info)) {
            throw new BgAccountException(BgAccountException.NUMEXISTS);
        }
        return super._submit(ctx, model);
    }
}

