/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.RefDimMemberEnum;
import com.kingdee.eas.ma.base.RefDimMemberResult;
import com.kingdee.eas.ma.base.app.AbstractBgBaseFacadeControllerBean;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgBaseFacadeControllerBean
extends AbstractBgBaseFacadeControllerBean {
    private static final long serialVersionUID = -1938069847441120720L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgBaseFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getCompanyIds(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> companys = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID From T_ORG_Company");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                companys.add(rst.getString(1));
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return companys;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkParent(Context ctx, TreeBaseInfo ParentInfo) throws BOSException, EASBizException {
        IRowSet rs;
        boolean result;
        block12: {
            boolean bl;
            block13: {
                result = true;
                String id = ParentInfo.getId().toString();
                HashMap<String, String> refCubeNameMap = new HashMap<String, String>();
                rs = null;
                IRowSet rs2 = null;
                String str = null;
                String str2 = null;
                String baseTable = null;
                boolean isBgElement = false;
                if (ParentInfo instanceof BgVersionInfo) {
                    str = "FVERSIONID";
                    str2 = "FVERSION";
                    baseTable = "T_MBG_BgVersion";
                } else if (ParentInfo instanceof BgScenarioInfo) {
                    str = "FSCENARIOID";
                    str2 = "FSCENARIO";
                    baseTable = "T_MBG_BgSCENARIO";
                } else {
                    str = "fid";
                    str2 = "FBGELEMENTID";
                    baseTable = "T_MBG_BgELEMENT";
                    isBgElement = true;
                }
                try {
                    String sql = "SELECT sc.fid,sc.FREFCUBE , p." + str + " FROM t_mbg_bgScheme sc LEFT OUTER JOIN t_mbg_bgDimSettings st on st.fbgSchemeid = sc.fid   LEFT OUTER JOIN t_mbg_bgDimSettingsMember dm on dm.fbgDimSettingsid = st.fid  LEFT OUTER JOIN " + baseTable + " p on p.fid = dm.fmemberid  where  p.fid = '" + id + "'";
                    ISQLExecutor iSql = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
                    rs = iSql.executeSQL();
                    while (rs.next()) {
                        refCubeNameMap.put(rs.getString(2), rs.getString(3));
                    }
                    if (refCubeNameMap.size() <= 0) break block12;
                    for (String refCubeName : refCubeNameMap.keySet()) {
                        String sql2;
                        ISQLExecutor iSql2;
                        String property = (String)refCubeNameMap.get(refCubeName);
                        int baseNo = 0;
                        if (!isBgElement) {
                            baseNo = Integer.parseInt(property);
                        }
                        if (refCubeName == null || !(rs2 = (iSql2 = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)(sql2 = "select top 1 fid FROM " + refCubeName + " where " + str2 + " = " + (isBgElement ? "'" + property + "'" : Integer.valueOf(baseNo))))).executeSQL()).next()) continue;
                        bl = result = false;
                        break block13;
                    }
                    break block12;
                }
                catch (SQLException ex) {
                    try {
                        throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }

    @Override
    protected IObjectCollection _getOrgAllChildren(Context ctx, BOSUuid orgUnitId) throws BOSException, EASBizException {
        ICostCenterOrgUnit iOrgUnit;
        if (orgUnitId == null) {
            return new OrgUnitCollection();
        }
        OrgUnitInfo unitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo("select isCostOrgUnit, isUnion where id = '" + orgUnitId + "'");
        OrgUnitCollection unitCollection = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("longnumber");
        if (unitInfo.isIsUnion()) {
            OrgStructureInfo structInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select tree.id, longNumber where unit.id = '" + orgUnitId + "'");
            OrgStructureCollection col = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select unit.id, unit.longNumber where tree.id = '" + structInfo.getTree().getId() + "' and longNumber like '" + structInfo.getLongNumber() + "!%'");
            unitCollection = new OrgUnitCollection();
            for (int i = 0; i < col.size(); ++i) {
                unitCollection.add((OrgUnitInfo)col.get(i).getUnit());
            }
        } else if (unitInfo.isIsCostOrgUnit() && (unitInfo = (OrgUnitInfo)(iOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx)).getValue((IObjectPK)new ObjectUuidPK(orgUnitId), sic)) != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(unitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            view.setFilter(filter);
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("number"));
            view.setSorter(sort);
            unitCollection = iOrgUnit.getOrgUnitCollection(view);
        }
        return unitCollection;
    }

    @Override
    protected int _lockAndUpdateMaxInt(Context ctx, String viewID, int addValue) throws BOSException {
        int n;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            int maxInt = this.readMaxInt(conn, viewID);
            if (maxInt < 0) {
                pstmt = conn.prepareStatement("Insert INTO T_MBG_BgIntLock(FViewId, FMaxInt) Values(?, 0)");
                pstmt.setString(1, viewID);
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
            }
            pstmt = conn.prepareStatement("Update T_MBG_BgIntLock Set FMaxInt = FMaxInt + ? Where FViewId = ?");
            pstmt.setInt(1, addValue);
            pstmt.setString(2, viewID);
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            n = this.readMaxInt(conn, viewID) - addValue;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readMaxInt(Connection conn, String viewID) throws SQLException {
        ResultSet rst;
        PreparedStatement pstmt;
        block3: {
            int n;
            pstmt = null;
            rst = null;
            try {
                pstmt = conn.prepareStatement("Select FViewId, FMaxInt FROM T_MBG_BgIntLock Where FViewId = ?");
                pstmt.setString(1, viewID);
                rst = pstmt.executeQuery();
                if (!rst.next()) break block3;
                n = rst.getInt("FMaxInt");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            return n;
        }
        int n = -1;
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return n;
    }

    @Override
    protected void _deleteView(Context ctx, String viewId) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("Delete FROM T_MBG_BgIntLock Where FViewId = ?");
            pstmt.setString(1, viewId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _getRefDimMember(Context ctx, String memberId, String viewId, int type) throws BOSException, EASBizException {
        HashMap<String, AbstractCollection> map = new HashMap<String, AbstractCollection>();
        ArrayList<RefDimMemberResult> results = new ArrayList<RefDimMemberResult>();
        Set<String> schemeIdS = this.queryScheme(ctx, type, viewId);
        String[] infoNumber = this.getMemberNum(ctx, type, memberId);
        results.addAll(this.getRefMembers(ctx, memberId));
        results.addAll(this.getRefOther(ctx, memberId, viewId, type, schemeIdS, infoNumber[0], infoNumber[1]));
        Collections.sort(results, new Comparator<RefDimMemberResult>(){

            @Override
            public int compare(RefDimMemberResult o1, RefDimMemberResult o2) {
                if (o1.getNumber() == null || o2.getNumber() == null) {
                    return 0;
                }
                if (o1.getType() != o2.getType()) {
                    return o1.getType() - o2.getType();
                }
                if (!o1.getBgScheme().getNumber().equals(o2.getBgScheme().getNumber())) {
                    return o1.getBgScheme().getNumber().compareTo(o2.getBgScheme().getNumber());
                }
                if (!o1.getNumber().equals(o2.getNumber())) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
                return 0;
            }
        });
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        for (int i = 0; i < results.size(); ++i) {
            set.add(((RefDimMemberResult)results.get(i)).getType());
        }
        map.put("REFTYPE_SET", set);
        map.put("REFDATA", results);
        return map;
    }

    private String[] getMemberNum(Context ctx, int type, String memberId) {
        String[] str = new String[2];
        try {
            if (type == 1) {
                BgAccountInfo accinfo = (BgAccountInfo)BgAccountFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)memberId.toString())));
                str[0] = "Acc:";
                str[1] = accinfo.getNumber();
            } else if (type == 2) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                selector.add("mbgDim.srcNumber");
                MbgMemberInfo memberInfo = MbgMemberFactory.getLocalInstance(ctx).getMbgMemberInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)memberId.toString())), selector);
                str[0] = memberInfo.getMbgDim().getSrcNumber() + BgBaseConstants.SEP_FOUR_STR;
                str[1] = memberInfo.getNumber();
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> queryScheme(Context ctx, int type, String viewId) {
        Connection connection = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        HashSet<String> schemeIdS = new HashSet<String>();
        try {
            connection = this.getConnection(ctx);
            String sql = "SELECT s.FBgSchemeID, m.FMemberId FROM T_MBG_BgDimSettingsMember m left join T_MBG_BgDimSettings s on s.fid = m.FBgDimSettingsID  where  m.FMemberId = ? and ";
            if (type == 1) {
                sql = sql + " s.fdimNumber = 'BG_Account' ";
            } else if (type == 2) {
                sql = sql + " s.fdimNumber  not in ( 'BG_Account','BG_Period','BG_Scenario','BG_Version','BG_Currency','BG_Organization','BG_Element')";
            }
            pst = connection.prepareStatement(sql.toString());
            pst.setString(1, viewId);
            rst = pst.executeQuery();
            while (rst.next()) {
                schemeIdS.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pst, (Connection)connection);
        }
        return schemeIdS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RefDimMemberResult> getRefMembers(Context ctx, String memberId) {
        Connection connection = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        ArrayList<RefDimMemberResult> results = new ArrayList<RefDimMemberResult>();
        try {
            StringBuffer sql;
            Object s;
            connection = this.getConnection(ctx);
            String locale = ctx.getLocale().getLanguage();
            pst = connection.prepareStatement("select r.FRefType, r.FBaseDataID, r.FRefID, s.fnumber sNumber, s.fid sfid, s.fname_" + locale + " sName, o.fnumber oNumber, o.fid ofid, o.fname_" + locale + " oName from T_MBG_BgRefDimMember r  left join t_mbg_bgscheme s on s.fid = r.FBGSCHEMEID  left join t_org_baseunit o on o.fid = r.FOTHERID  where FBaseDataID =?");
            pst.setString(1, memberId);
            rst = pst.executeQuery();
            Integer refType = null;
            String fBaseDataID = null;
            String refID = null;
            String key = null;
            RefDimMemberEnum refenum = null;
            RefDimMemberResult result = null;
            BgAccountInfo schemeInfo = null;
            OrgUnitInfo unitInfo = null;
            HashSet<String> keySet = new HashSet<String>();
            HashSet<String> tempIdSet = new HashSet<String>();
            HashSet<String> formIdSet = new HashSet<String>();
            while (rst.next()) {
                refType = rst.getInt("FRefType");
                refID = rst.getString("FRefID");
                fBaseDataID = rst.getString("FBaseDataID");
                key = refID + fBaseDataID;
                if (keySet.contains(key) || refType != 1 && refType != 8 && refType != 4) continue;
                keySet.add(key);
                result = new RefDimMemberResult();
                result.setRefId(refID);
                schemeInfo = new BgAccountInfo();
                schemeInfo.setNumber(rst.getString("sNumber"));
                schemeInfo.setName(rst.getString("sName"));
                schemeInfo.setId(BOSUuid.read((String)rst.getString("sfid")));
                result.setBgScheme(schemeInfo);
                unitInfo = new OrgUnitInfo();
                unitInfo.setNumber(rst.getString("oNumber"));
                unitInfo.setName(rst.getString("oName"));
                unitInfo.setId(BOSUuid.read((String)rst.getString("ofid")));
                result.setBgOrgUnit(unitInfo);
                refenum = this.transRefEnum(refType);
                result.setType(refenum.getValue());
                s = EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"refDetail", (Locale)ctx.getLocale());
                MessageFormat mf = new MessageFormat((String)s);
                String detail = mf.format(new String[]{unitInfo.getName(), unitInfo.getNumber(), refenum.getAlias()});
                result.setDetail(detail);
                results.add(result);
                if (refenum.getValue() == 6 || refenum.getValue() == 5) {
                    formIdSet.add(refID);
                    continue;
                }
                if (refenum.getValue() != 2) continue;
                tempIdSet.add(refID);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (formIdSet.isEmpty() && tempIdSet.isEmpty()) {
                s = new ArrayList<RefDimMemberResult>();
                SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
                return s;
            }
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            String[] params = null;
            if (!formIdSet.isEmpty()) {
                sql = new StringBuffer();
                sql.append("select fid, fnumber , fname").append("  from T_MBG_Bgform  where fid in (");
                for (String obj : formIdSet) {
                    if (obj == null) continue;
                    sql.append("?,");
                }
                sql.delete(sql.length() - 1, sql.length());
                sql.append(") ");
                pst = connection.prepareStatement(sql.toString());
                MbgSqlHelper.setParams(pst, new ArrayList(formIdSet));
                rst = pst.executeQuery();
                while (rst.next()) {
                    params = new String[]{rst.getString(2), rst.getString(3)};
                    map.put(rst.getString(1), params);
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (!tempIdSet.isEmpty()) {
                sql = new StringBuffer();
                sql.append("select fid, fnumber , fname").append("  from T_MBG_BgTemplate  where fid in (");
                for (String obj : tempIdSet) {
                    if (obj == null) continue;
                    sql.append("?,");
                }
                sql.delete(sql.length() - 1, sql.length());
                sql.append(") ");
                pst = connection.prepareStatement(sql.toString());
                MbgSqlHelper.setParams(pst, new ArrayList(tempIdSet));
                rst = pst.executeQuery();
                while (rst.next()) {
                    params = new String[]{rst.getString(2), rst.getString(3)};
                    map.put(rst.getString(1), params);
                }
            }
            for (int i = 0; i < results.size(); ++i) {
                if (!map.containsKey(((RefDimMemberResult)results.get(i)).getRefId())) continue;
                ((RefDimMemberResult)results.get(i)).setNumber(((String[])map.get(((RefDimMemberResult)results.get(i)).getRefId()))[0]);
                ((RefDimMemberResult)results.get(i)).setName(((String[])map.get(((RefDimMemberResult)results.get(i)).getRefId()))[1]);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pst, (Connection)connection);
        }
        return results;
    }

    private List<RefDimMemberResult> getRefOther(Context ctx, String memberId, String viewId, int type, Set<String> schemeIdS, String srcMember, String infoNumber) throws BOSException {
        ArrayList<RefDimMemberResult> results = new ArrayList<RefDimMemberResult>();
        Connection connection = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer querySql = new StringBuffer();
        String schemeId2 = null;
        String dimNum = null;
        String[] param = null;
        BgAccountInfo schemeInfo = null;
        OrgUnitInfo unitInfo = null;
        HashMap schemeDim = new HashMap();
        try {
            String detail;
            String[] par;
            String constans2;
            String dimNumber;
            Map numLst;
            HashSet<String> sets;
            Map map;
            connection = this.getConnection(ctx);
            String local = ctx.getLocale().getLanguage();
            String s = EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"refDetail", (Locale)ctx.getLocale());
            MessageFormat mf = new MessageFormat(s);
            RefDimMemberResult result = null;
            querySql.append("SELECT  g.FBgSchemeId,s.fnumber snumber,s.fname_" + local + " sname, re.FDimensionNumber, g.fnumber gnumber, g.fname_" + local + " gname, o.fid ofid, o.fnumber onumber, o.fname_" + local + " oname").append(" FROM T_MBG_DimensionRelationship re ").append(" left join T_MBG_DimensionRelationGroup  g on g.FID  = re.FDIMENSIONGROUPID ").append(" left join t_mbg_bgscheme  s on s.FID  = g.FBgSchemeId ").append(" left join T_org_baseunit  o on o.FID  = re.FCostUnitID ").append(" where re.FDimensionNumber like '%" + srcMember + "%' ");
            pst = connection.prepareStatement(querySql.toString());
            rst = pst.executeQuery();
            while (rst.next()) {
                HashSet<String[]> sets2;
                Map map2;
                schemeId2 = rst.getString("FBgSchemeId");
                dimNum = rst.getString("FDimensionNumber");
                if (dimNum.indexOf(srcMember) < 0) continue;
                String num = this.processDimNum(dimNum, srcMember);
                param = new String[]{rst.getString("snumber"), rst.getString("sname"), rst.getString("gnumber"), rst.getString("gname"), rst.getString("ofid"), rst.getString("onumber"), rst.getString("oname")};
                if (!schemeDim.containsKey(schemeId2)) {
                    map2 = new HashMap();
                    sets2 = new HashSet<String[]>();
                    sets2.add(param);
                    map2.put(num, sets2);
                    schemeDim.put(schemeId2, map2);
                    continue;
                }
                map2 = (Map)schemeDim.get(schemeId2);
                if (!map2.containsKey(num)) {
                    sets2 = new HashSet();
                    sets2.add(param);
                    map2.put(num, sets2);
                    continue;
                }
                ((Set)map2.get(num)).add(param);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (!schemeIdS.isEmpty() && !schemeDim.isEmpty()) {
                Map numLst2 = null;
                for (String schemeId2 : schemeIdS) {
                    if (!schemeDim.containsKey(schemeId2) || !(numLst2 = (Map)schemeDim.get(schemeId2)).containsKey(infoNumber)) continue;
                    Set params = (Set)numLst2.get(infoNumber);
                    for (String[] par2 : params) {
                        result = new RefDimMemberResult();
                        schemeInfo = new BgAccountInfo();
                        schemeInfo.setNumber(par2[0]);
                        schemeInfo.setName(par2[1]);
                        schemeInfo.setId(BOSUuid.read((String)schemeId2));
                        result.setBgScheme(schemeInfo);
                        result.setNumber(par2[2]);
                        result.setName(par2[3]);
                        unitInfo = new OrgUnitInfo();
                        unitInfo.setId(BOSUuid.read((String)par2[4]));
                        unitInfo.setNumber(par2[5]);
                        unitInfo.setName(par2[6]);
                        result.setBgOrgUnit(unitInfo);
                        result.setType(1);
                        String detail2 = mf.format(new String[]{unitInfo.getName(), unitInfo.getNumber(), RefDimMemberEnum.dimRelation.getAlias()});
                        result.setDetail(detail2);
                        results.add(result);
                    }
                }
            }
            schemeDim.clear();
            HashMap schemeCalc = new HashMap();
            HashMap<String, String[]> schemeCalcParam = new HashMap<String, String[]>();
            String sql = "SELECT cl.FBGMEMBERNUM, ru.FFORMULA,bc.FBgSchemeId,s.fnumber snumber,s.fname_" + local + " sname, bc.fid bcid,bc.fnumber gnumber, bc.fname_" + local + " gname, o.fid ofid, o.fnumber onumber, o.fname_" + local + " oname FROM T_MBG_BizCalcSubSet ru left join t_mbg_bizscope cl on cl.FBIZCALCSUBSETID  = ru.FID inner join T_MBG_BizCalc bc on bc.fid = ru.fbizcalcid inner join t_org_baseunit o on o.fid = bc.FOrgUnitID inner join t_mbg_bgscheme s on s.FID  = bc.FBgSchemeId ";
            pst = connection.prepareStatement(sql);
            rst = pst.executeQuery();
            byte[] formula = null;
            String scopeNum = null;
            String bcid = null;
            String _bizFormula = null;
            while (rst.next()) {
                scopeNum = rst.getString("FBGMEMBERNUM");
                formula = rst.getBytes("FFORMULA");
                schemeId2 = rst.getString("FBgSchemeId");
                bcid = rst.getString("bcid");
                param = new String[]{rst.getString("snumber"), rst.getString("sname"), rst.getString("gnumber"), rst.getString("gname"), rst.getString("ofid"), rst.getString("onumber"), rst.getString("oname")};
                if (!schemeCalc.containsKey(schemeId2)) {
                    map = new HashMap();
                    sets = new HashSet<String>();
                    if (formula != null && formula.length > 0) {
                        _bizFormula = (String)BgCommHelper.getObject(formula);
                        sets.add(_bizFormula);
                    }
                    if (scopeNum != null) {
                        sets.add(scopeNum);
                    }
                    map.put(bcid, sets);
                    schemeCalcParam.put(bcid, param);
                    schemeCalc.put(schemeId2, map);
                    continue;
                }
                map = (Map)schemeCalc.get(schemeId2);
                if (!map.containsKey(bcid)) {
                    sets = new HashSet();
                    if (formula != null && formula.length > 0) {
                        _bizFormula = (String)BgCommHelper.getObject(formula);
                        sets.add(_bizFormula);
                    }
                    if (scopeNum != null) {
                        sets.add(scopeNum);
                    }
                    map.put(bcid, sets);
                    schemeCalcParam.put(bcid, param);
                    continue;
                }
                if (formula != null && formula.length > 0) {
                    _bizFormula = (String)BgCommHelper.getObject(formula);
                    ((Set)map.get(bcid)).add(_bizFormula);
                }
                if (scopeNum == null) continue;
                ((Set)map.get(bcid)).add(scopeNum);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (!schemeIdS.isEmpty() && !schemeCalc.isEmpty()) {
                numLst = null;
                dimNumber = null;
                constans2 = null;
                for (String schemeId2 : schemeIdS) {
                    if (!schemeCalc.containsKey(schemeId2)) continue;
                    numLst = (Map)schemeCalc.get(schemeId2);
                    block9: for (String key : numLst.keySet()) {
                        dimNumber = srcMember + infoNumber;
                        for (String constans2 : (Set)numLst.get(key)) {
                            if (!constans2.contains(dimNumber)) continue;
                            par = (String[])schemeCalcParam.get(key);
                            result = new RefDimMemberResult();
                            schemeInfo = new BgAccountInfo();
                            schemeInfo.setNumber(par[0]);
                            schemeInfo.setName(par[1]);
                            schemeInfo.setId(BOSUuid.read((String)schemeId2));
                            result.setBgScheme(schemeInfo);
                            result.setNumber(par[2]);
                            result.setName(par[3]);
                            unitInfo = new OrgUnitInfo();
                            unitInfo.setId(BOSUuid.read((String)par[4]));
                            unitInfo.setNumber(par[5]);
                            unitInfo.setName(par[6]);
                            result.setBgOrgUnit(unitInfo);
                            result.setRefId(key);
                            result.setType(3);
                            detail = mf.format(new String[]{unitInfo.getName(), unitInfo.getNumber(), RefDimMemberEnum.bizCalc.getAlias()});
                            result.setDetail(detail);
                            results.add(result);
                            continue block9;
                        }
                    }
                }
            }
            schemeCalc.clear();
            schemeCalcParam.clear();
            sql = "SELECT cl.FBGMEMBERNUM, ru.FFORMULA,bc.FBgSchemeId,s.fnumber snumber,s.fname_" + local + " sname, bc.fid bcid,bc.fnumber gnumber, bc.fname_" + local + " gname, o.fid ofid, o.fnumber onumber, o.fname_" + local + " oname FROM t_mbg_bgexaminesubset ru left join t_mbg_bgscope cl on cl.FBGEXAMINESUBSETID  = ru.FID inner join t_mbg_bgexamine bc on bc.fid = ru.FBGEXAMINEID inner join t_org_baseunit o on o.fid = bc.FOrgUnitID inner join t_mbg_bgscheme s on s.FID  = bc.FBgSchemeId ";
            pst = connection.prepareStatement(sql);
            rst = pst.executeQuery();
            while (rst.next()) {
                scopeNum = rst.getString("FBGMEMBERNUM");
                formula = rst.getBytes("FFORMULA");
                schemeId2 = rst.getString("FBgSchemeId");
                bcid = rst.getString("bcid");
                param = new String[]{rst.getString("snumber"), rst.getString("sname"), rst.getString("gnumber"), rst.getString("gname"), rst.getString("ofid"), rst.getString("onumber"), rst.getString("oname")};
                if (!schemeCalc.containsKey(schemeId2)) {
                    map = new HashMap();
                    sets = new HashSet();
                    if (formula != null && formula.length > 0) {
                        _bizFormula = (String)BgCommHelper.getObject(formula);
                        sets.add(_bizFormula);
                    }
                    if (scopeNum != null) {
                        sets.add(scopeNum);
                    }
                    map.put(bcid, sets);
                    schemeCalcParam.put(bcid, param);
                    schemeCalc.put(schemeId2, map);
                    continue;
                }
                map = (Map)schemeCalc.get(schemeId2);
                if (!map.containsKey(bcid)) {
                    sets = new HashSet();
                    if (formula != null && formula.length > 0) {
                        _bizFormula = (String)BgCommHelper.getObject(formula);
                        sets.add(_bizFormula);
                    }
                    if (scopeNum != null) {
                        sets.add(scopeNum);
                    }
                    map.put(bcid, sets);
                    schemeCalcParam.put(bcid, param);
                    continue;
                }
                if (formula != null && formula.length > 0) {
                    _bizFormula = (String)BgCommHelper.getObject(formula);
                    ((Set)map.get(bcid)).add(_bizFormula);
                }
                if (scopeNum == null) continue;
                ((Set)map.get(bcid)).add(scopeNum);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pst);
            if (!schemeIdS.isEmpty() && !schemeCalc.isEmpty()) {
                numLst = null;
                dimNumber = null;
                constans2 = null;
                for (String schemeId2 : schemeIdS) {
                    if (!schemeCalc.containsKey(schemeId2)) continue;
                    numLst = (Map)schemeCalc.get(schemeId2);
                    block13: for (String key : numLst.keySet()) {
                        dimNumber = srcMember + infoNumber;
                        for (String constans2 : (Set)numLst.get(key)) {
                            if (!constans2.contains(dimNumber)) continue;
                            par = (String[])schemeCalcParam.get(key);
                            result = new RefDimMemberResult();
                            schemeInfo = new BgAccountInfo();
                            schemeInfo.setNumber(par[0]);
                            schemeInfo.setName(par[1]);
                            schemeInfo.setId(BOSUuid.read((String)schemeId2));
                            result.setBgScheme(schemeInfo);
                            result.setNumber(par[2]);
                            result.setName(par[3]);
                            unitInfo = new OrgUnitInfo();
                            unitInfo.setId(BOSUuid.read((String)par[4]));
                            unitInfo.setNumber(par[5]);
                            unitInfo.setName(par[6]);
                            result.setBgOrgUnit(unitInfo);
                            result.setRefId(key);
                            result.setType(4);
                            detail = mf.format(new String[]{unitInfo.getName(), unitInfo.getNumber(), RefDimMemberEnum.bgExamine.getAlias()});
                            result.setDetail(detail);
                            results.add(result);
                            continue block13;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pst, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pst, (Connection)connection);
        return results;
    }

    private RefDimMemberEnum transRefEnum(Integer refType) {
        RefDimMemberEnum denum = RefDimMemberEnum.bgdata;
        if (refType == 1) {
            denum = RefDimMemberEnum.bgTemplate;
        } else if (refType == 4) {
            denum = RefDimMemberEnum.bgForm;
        } else if (refType == 8) {
            denum = RefDimMemberEnum.bgForm;
        }
        return denum;
    }

    private String processDimNum(String dimNum, String srcNumber) {
        String newNum = null;
        String[] dimNums = dimNum.split(",");
        for (int i = 0; i < dimNums.length; ++i) {
            if (!dimNums[i].startsWith(srcNumber)) continue;
            newNum = dimNums[i].substring(4, dimNums[i].length());
        }
        return newNum;
    }
}

