/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgItemException;
import com.kingdee.eas.ma.base.BgItemGroupFactory;
import com.kingdee.eas.ma.base.BgItemGroupInfo;
import com.kingdee.eas.ma.base.app.AbstractBgItemGroupControllerBean;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BgItemGroupControllerBean
extends AbstractBgItemGroupControllerBean {
    private static final long serialVersionUID = 3425595152721370099L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgItemGroupControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkNumber(Context ctx, String id, String number) throws BOSException, EASBizException {
        if (ctx == null) return false;
        if (StringUtils.isEmpty((String)number)) {
            return false;
        }
        boolean re = true;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_MBG_BgItemGroup where FNumber = ?");
        if (id != null) {
            sql.append(" and FID != ?");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, number);
            if (id != null) {
                pstmt.setString(2, id);
            }
            if ((rst = pstmt.executeQuery()).next()) {
                re = false;
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (BOSException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgItemGroupInfo groupInfo = (BgItemGroupInfo)model;
        if (StringUtils.isEmpty((String)groupInfo.getNumber())) {
            String OUID = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
            BgCodeNumberNHelper.applyNumber(ctx, model, OUID);
            if (StringUtils.isEmpty((String)groupInfo.getNumber())) {
                groupInfo.setNumber("BgItemGroup-" + System.currentTimeMillis());
            }
        }
        if (!this.checkNumber(ctx, null, groupInfo.getNumber())) {
            throw new BgItemException(BgItemException.GROUPHAVENUMBER, new String[]{groupInfo.getNumber()});
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (ctx == null || pk == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("parent.id");
        sic.add("parent.name");
        sic.add("parent.number");
        BgItemGroupInfo groupInfo = BgItemGroupFactory.getLocalInstance(ctx).getBgItemGroupInfo(pk, sic);
        if (groupInfo != null) {
            String OUID = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
            BgCodeNumberNHelper.recycleNumber(ctx, (IObjectValue)groupInfo, OUID, groupInfo.getNumber());
        }
        super._delete(ctx, pk);
        if (groupInfo.getParent() != null && this.checkIsLeaf(ctx, groupInfo.getParent().getId())) {
            BgItemGroupInfo parent = groupInfo.getParent();
            parent.setIsLeaf(true);
            SelectorItemCollection _sic = new SelectorItemCollection();
            _sic.add("isLeaf");
            this._updatePartial(ctx, (IObjectValue)parent, _sic);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIsLeaf(Context ctx, BOSUuid bgItemGroupId) throws BOSException, EASBizException {
        if (ctx == null) return false;
        if (bgItemGroupId == null) {
            return false;
        }
        boolean re = true;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select TOP 1 FID From T_MBG_BgItemGroup where FParentID = ?");
            pstmt.setString(1, bgItemGroupId.toString());
            rst = pstmt.executeQuery();
            re = !rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }
}

