/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodInfoFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.app.AbstractBgPeriodDispControllerBean;
import com.kingdee.eas.ma.base.app.utils.BgIntIdHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPeriodDispControllerBean
extends AbstractBgPeriodDispControllerBean {
    private static final long serialVersionUID = -7276203471219086878L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodDispControllerBean.class);
    private static final String resClassName = "com.kingdee.eas.ma.base.BgPeriodMsgResource";

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    protected FilterInfo getFilterForDefaultCU(IObjectValue model) {
        return new FilterInfo();
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("type.*");
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("bgPeriod.*");
        selector.add("parent.*");
        try {
            BgPeriodDispInfo bgPeriodDispInfo = this.getBgPeriodDispInfo(ctx, pk, selector);
            String number = bgPeriodDispInfo.getType().getNumber();
            if (BgPeriodHelper.ALL_BGPERIOD_NUMBER.contains(number)) {
                EntityViewInfo view = new EntityViewInfo();
                IBgPeriod localInstance = BgPeriodFactory.getLocalInstance(ctx);
                BgPeriodTypeInfo type = bgPeriodDispInfo.getType();
                String longNumber = bgPeriodDispInfo.getLongNumber();
                if (!BgNPeriodHelper.isOnlySelfDefinedPeriod(type)) {
                    String preNumber = longNumber.substring(0, 10);
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(preNumber + "%"), CompareType.LIKE));
                    view.setFilter(filter);
                    BgPeriodCollection bgPeriodCollection = localInstance.getBgPeriodCollection(view);
                    HashSet<String> set = new HashSet<String>();
                    for (int i = 0; i < bgPeriodCollection.size(); ++i) {
                        set.add(bgPeriodCollection.get(i).getId().toString());
                    }
                    view = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(preNumber + "%"), CompareType.NOTLIKE));
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", set, CompareType.INCLUDE));
                    view.setFilter(filter);
                    BgPeriodDispCollection bgPeriodDispCollection = this.getBgPeriodDispCollection(ctx, view);
                    if (bgPeriodDispCollection != null && !bgPeriodDispCollection.isEmpty()) {
                        String string = ResourceBase.getString((String)resClassName, (String)"usedByKN", (Locale)ContextUtils.getLocaleFromEnv());
                        throw new CanNotDeleteException(string);
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"CanNotDeleteException", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"CanNotDeleteException", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    @Override
    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        this._canDelete(ctx, pk, null);
        IBgPeriod localInstance = BgPeriodFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("type.*");
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        BgPeriodDispInfo bgPeriodDispInfo = this.getBgPeriodDispInfo(ctx, pk, selector);
        String longNumber = bgPeriodDispInfo.getLongNumber();
        BgPeriodTypeInfo type = bgPeriodDispInfo.getType();
        String preNumber = null;
        preNumber = longNumber.indexOf(BgBaseConstants.SEP_ONE_STR) > 0 ? longNumber.substring(0, longNumber.indexOf(BgBaseConstants.SEP_ONE_STR)) : longNumber;
        String innerSql = "select Fbgperiodid from t_mbg_bgperioddisp where fnumber ='" + preNumber + "' or flongNumber like '" + preNumber + "!%'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql, CompareType.INNER));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        BgPeriodCollection bgPeriodCollection = localInstance.getBgPeriodCollection(view);
        ArrayList<BgPeriodInfo> periods = new ArrayList<BgPeriodInfo>();
        if (bgPeriodCollection != null && !bgPeriodCollection.isEmpty()) {
            for (int i = 0; i < bgPeriodCollection.size(); ++i) {
                periods.add(bgPeriodCollection.get(i));
            }
        }
        if (!BgNPeriodHelper.isAcrossYearsPeriod(type) || this.isDisPeriodNotUsed(ctx, bgPeriodDispInfo, periods)) {
            if (this.isUse(ctx, periods)) {
                throw new BgPeriodException(BgPeriodException.ISUSE);
            }
            IObjectPK[] delete = localInstance.delete(filter);
            String string = type.getId().toString();
            FilterItemInfo info = new FilterItemInfo("type.id", (Object)string, CompareType.EQUALS);
            filter.getFilterItems().add(info);
            IObjectPK[] _delete = this._delete(ctx, filter);
            FilterInfo _filter = new FilterInfo();
            _filter.getFilterItems().add(info);
            if (!this.exists(ctx, _filter)) {
                String sql = "update t_mbg_bgperiodtype set fbelongyear = null,fstartMonth = null where fid = ?";
                Object[] params = new Object[]{string};
                try {
                    BgDBUtils.executeUpdate(ctx, sql, params);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (BgNPeriodHelper.isOnlySelfDefinedPeriod(type)) {
                this.updateParentAttrIsLeaf(ctx, localInstance, bgPeriodDispInfo);
            }
            try {
                BgDBUtils.executeUpdate(ctx, "delete from T_MBG_BgPeriodDisp where FBgPeriodId not in (select FID from T_MBG_BgPeriod)");
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
    }

    protected boolean isDisPeriodNotUsed(Context ctx, BgPeriodDispInfo bgPeriodDispInfo, List<BgPeriodInfo> periods) throws BOSException, EASBizException {
        boolean isDisPeriodNotUsed = false;
        if (ctx == null || bgPeriodDispInfo == null) {
            return isDisPeriodNotUsed;
        }
        BgPeriodTypeInfo type = bgPeriodDispInfo.getType();
        String longNumber = bgPeriodDispInfo.getLongNumber();
        FilterInfo filter = new FilterInfo();
        String preNumber = null;
        preNumber = longNumber.indexOf(BgBaseConstants.SEP_ONE_STR) > 0 ? longNumber.substring(0, longNumber.indexOf(BgBaseConstants.SEP_ONE_STR)) : longNumber.substring(0, 10);
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(preNumber + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)type.getId().toString(), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("bgPeriod.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BgPeriodDispCollection disColls = BgPeriodDispFactory.getLocalInstance(ctx).getBgPeriodDispCollection(view);
        HashSet<String> unUsedPeriodNums = new HashSet<String>();
        BgPeriodDispCollection unUsedPeriodColls = new BgPeriodDispCollection();
        BgPeriodDispInfo disInfo = null;
        for (int index = 0; index < disColls.size(); ++index) {
            disInfo = disColls.get(index);
            if (BgPeriodHelper.ALL_BGPERIOD_NUMBER.contains(disInfo.getNumber().substring(0, disInfo.getNumber().indexOf(".")))) continue;
            unUsedPeriodNums.add(disInfo.getNumber());
            unUsedPeriodColls.add(disInfo);
        }
        ArrayList<BgPeriodInfo> checkBgPeriods = new ArrayList<BgPeriodInfo>();
        for (int i = 0; i < periods.size(); ++i) {
            if (!unUsedPeriodNums.contains(periods.get(i).getNumber())) continue;
            checkBgPeriods.add(periods.get(i));
        }
        if (!(checkBgPeriods.isEmpty() || this.isUse(ctx, checkBgPeriods) || unUsedPeriodColls.isEmpty())) {
            int p;
            IObjectPK[] pkArray = new IObjectPK[checkBgPeriods.size()];
            for (p = 0; p < checkBgPeriods.size(); ++p) {
                pkArray[p] = new ObjectUuidPK(((BgPeriodInfo)checkBgPeriods.get(p)).getId());
            }
            BgPeriodFactory.getLocalInstance(ctx).deleteBatchData(pkArray);
            pkArray = new IObjectPK[disColls.size()];
            for (p = 0; p < disColls.size(); ++p) {
                pkArray[p] = new ObjectUuidPK(disColls.get(p).getId());
            }
            BgPeriodDispFactory.getLocalInstance(ctx).deleteBatchData(pkArray);
            isDisPeriodNotUsed = true;
        }
        return isDisPeriodNotUsed;
    }

    @Override
    public boolean _isUse(Context ctx, List periods) throws EASBizException, BOSException {
        boolean isUsed = false;
        if (periods == null) {
            return isUsed;
        }
        BgPeriodInfo periodInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            int in = periods.size();
            for (int i = 0; i < in; ++i) {
                periodInfo = (BgPeriodInfo)periods.get(i);
                pstmt = conn.prepareStatement("select top 1 t.FID from T_MBG_BgRefDimMember t, T_MBG_BgPeriod p where t.FrefType = ? and t.FBaseDataID = p.FID and p.fid = ?");
                pstmt.setInt(1, 8);
                pstmt.setString(2, periodInfo.getId().toString());
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    isUsed = true;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (isUsed) {
                } else {
                    pstmt = conn.prepareStatement("select top 1 t.FID from T_MBG_BgRefDimMember t inner join  T_MBG_BgPeriodDisp p on t.FBASEDATAID  = p.FID inner join T_MBG_bgPeriod d on p.FBGPERIODID  = d.FID where t.FrefType = ?  and d.fid  = ? ");
                    pstmt.setInt(1, 1);
                    pstmt.setString(2, periodInfo.getId().toString());
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        isUsed = true;
                    }
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    if (isUsed) {
                    } else {
                        pstmt = conn.prepareStatement("select top 1 t.FID from T_MBg_BgForm t, T_MBG_BgPeriod p where t.FBgPeriodID = p.FID and p.fid = ?");
                        pstmt.setString(1, periodInfo.getId().toString());
                        rst = pstmt.executeQuery();
                        if (rst.next()) {
                            isUsed = true;
                        }
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                        if (isUsed) {
                        } else {
                            pstmt = conn.prepareStatement("select top 1 t.FID from T_MBg_BgForm t, T_MBG_BgPeriod p where t.fbgRollperiodId = p.FID and p.fid = ?");
                            pstmt.setString(1, periodInfo.getId().toString());
                            rst = pstmt.executeQuery();
                            if (rst.next()) {
                                isUsed = true;
                            }
                            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                            if (!isUsed) continue;
                        }
                    }
                }
                break;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"delete BgPeriod Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return isUsed || this.checkFormulaOfRefcube(ctx, periods);
    }

    /*
     * Exception decompiling
     */
    private boolean checkFormulaOfRefcube(Context ctx, List<BgPeriodInfo> periods) throws BgException, BOSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<BgPeriodInfo> getBgPeriodInfos(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        ArrayList<BgPeriodInfo> periods = new ArrayList<BgPeriodInfo>();
        if (ctx == null) return periods;
        if (pks == null) return periods;
        if (pks.length == 0) {
            return periods;
        }
        int batchNum = 50;
        int size = pks.length;
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        BgPeriodInfo periodInfo = null;
        ArrayList<String> periodIds = new ArrayList<String>();
        int in = pks.length;
        for (int i = 0; i < in; ++i) {
            periodIds.add(pks[i].toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FLongNumber from T_MBG_BgPeriod where FID in (");
        for (int index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                for (int x = 1; x <= batchNum; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)periodIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    periodInfo = new BgPeriodInfo();
                    periodInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    periodInfo.setLongNumber(rst.getString("FLongNumber"));
                    periods.add(periodInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"delete BgPeriod Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return periods;
    }

    private void updateParentAttrIsLeaf(Context ctx, IBgPeriod localInstance, BgPeriodDispInfo bgPeriodDispInfo) throws BOSException, EASBizException, SQLDataException {
        BgPeriodDispInfo parent = bgPeriodDispInfo.getParent();
        if (parent != null) {
            String longnumber = parent.getLongNumber();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longnumber + "!%"), CompareType.LIKE));
            if (!this.exists(ctx, filter)) {
                try {
                    BgDBUtils.executeUpdate(ctx, "update T_MBG_BgPerioddisp set fisleaf = 1 where fid = '" + parent.getId().toString() + "'");
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (!localInstance.exists(filter)) {
                try {
                    BgPeriodInfo bgPeriod = bgPeriodDispInfo.getBgPeriod();
                    BgDBUtils.executeUpdate(ctx, "update T_MBG_BgPeriod set fisleaf = 1 where fid = '" + bgPeriod.getId().toString() + "'");
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected Object _addBgPeriodByPeriodType(Context ctx, IObjectValue bgPeriodType, int start, int end, List list) throws BOSException, EASBizException {
        return this._addBgPeriodByPeriodType(ctx, bgPeriodType, start, end, list, 1, false);
    }

    @Override
    protected Object _addBgPeriodByPeriodType(Context ctx, IObjectValue bgPeriodType, int start, int end, List periodList, int startTime, boolean isStrideYear) throws BOSException, EASBizException {
        return this._addBgPeriodByPeriodType(ctx, bgPeriodType, start, end, periodList, true, startTime, isStrideYear);
    }

    @Override
    protected Object _addBgPeriodByPeriodType(Context ctx, IObjectValue bgPeriodType, int start, int end, List periodList, boolean isCheckFactory) throws BOSException, EASBizException {
        return this._addBgPeriodByPeriodType(ctx, bgPeriodType, start, end, periodList, isCheckFactory, 1, false);
    }

    @Override
    protected Object _addBgPeriodByPeriodType(Context ctx, IObjectValue bgPeriodType, int start, int end, List list, boolean isCheckFactory, int startTime, boolean isStrideYear) throws BOSException, EASBizException {
        int successCount = 0;
        int faildCount = 0;
        if (bgPeriodType == null || !(bgPeriodType instanceof BgPeriodTypeInfo) || start > end) {
            return null;
        }
        BgPeriodTypeInfo bgPeriodTypeInfo = (BgPeriodTypeInfo)bgPeriodType;
        Locale localeFromEnv = ContextUtils.getLocaleFromEnv();
        BgPeriodInfoFactory factory = null;
        bgPeriodTypeInfo.getNumber();
        StringBuilder sb = null;
        String yearNumber = null;
        StringBuilder msg = new StringBuilder();
        IBgPeriodDisp iDisp = BgPeriodDispFactory.getLocalInstance(ctx);
        for (int year = start; year <= end; ++year) {
            boolean exists = false;
            if (!BgNPeriodHelper.isOnlySelfDefinedPeriod(bgPeriodTypeInfo)) {
                sb = new StringBuilder();
                yearNumber = sb.append(bgPeriodTypeInfo.getNumber()).append(".").append(year).append("Y").toString();
                FilterInfo filter = new FilterInfo();
                BgCommHelper.replaceFilterItemsWithoutMask(filter, new FilterItemInfo("number", (Object)(yearNumber + "%"), CompareType.LIKE));
                exists = iDisp.exists(filter);
            }
            if (exists) {
                msg.append(ResourceBase.getString((String)resClassName, (String)"createFailed", (Locale)localeFromEnv, (Object[])new Object[]{year + " "})).append("\n");
                ++faildCount;
                continue;
            }
            ArrayList<BgPeriodInfo> createBgPeriodInfos = new ArrayList<BgPeriodInfo>();
            if (BgNPeriodHelper.isOnlySelfDefinedPeriod(bgPeriodTypeInfo)) {
                factory = new BgPeriodInfoFactory(ctx, bgPeriodTypeInfo, list, localeFromEnv);
                createBgPeriodInfos.addAll(factory.createBgPeriod(Calendar.getInstance().get(1), bgPeriodTypeInfo.isSelfDefined()));
            } else if (FiscalYearEnum.STRIDEYEAR.equals((Object)bgPeriodTypeInfo.getFiscalYear())) {
                createBgPeriodInfos.addAll(list);
            } else if (FiscalYearEnum.STANDARDYEAR.equals((Object)bgPeriodTypeInfo.getFiscalYear()) && bgPeriodTypeInfo.isSelfDefined()) {
                factory = new BgPeriodInfoFactory(ctx, bgPeriodTypeInfo, list, localeFromEnv);
                createBgPeriodInfos.addAll(factory.createBgPeriod(year, bgPeriodTypeInfo.isSelfDefined()));
            } else {
                factory = new BgPeriodInfoFactory(bgPeriodTypeInfo, localeFromEnv, startTime, isStrideYear);
                createBgPeriodInfos.addAll(factory.createBgPeriod(year, bgPeriodTypeInfo.isSelfDefined()));
            }
            if (!this.checkRetainAllPeriods(bgPeriodTypeInfo, createBgPeriodInfos, year, iDisp, msg, localeFromEnv)) {
                ++faildCount;
                break;
            }
            this._addBatchData(ctx, createBgPeriodInfos, bgPeriodTypeInfo.getId().toString());
            if (BgNPeriodHelper.isOnlySelfDefinedPeriod(bgPeriodTypeInfo)) {
                for (BgPeriodInfo item : createBgPeriodInfos) {
                    msg.append(ResourceBase.getString((String)resClassName, (String)"createSelfSuccse", (Locale)localeFromEnv, (Object[])new Object[]{item.getName()})).append("\n");
                }
            } else {
                msg.append(ResourceBase.getString((String)resClassName, (String)"createSuccse", (Locale)localeFromEnv, (Object[])new Object[]{year + " "})).append("\n");
                ++successCount;
            }
            if (!isCheckFactory) continue;
            BgPeriodHelper.checkBgPeriodClosure(ctx, bgPeriodTypeInfo.getId());
        }
        return new Object[]{successCount, faildCount, msg.toString()};
    }

    private boolean checkRetainAllPeriods(BgPeriodTypeInfo bgPeriodTypeInfo, List<BgPeriodInfo> createBgPeriodInfos, int year, IBgPeriodDisp iDisp, StringBuilder msg, Locale localeFromEnv) throws BOSException, EASBizException {
        BgPeriodDispInfo bgPeriodDispInfo;
        String number = bgPeriodTypeInfo.getNumber();
        if (!"MONT".equals(number)) {
            return true;
        }
        StringBuilder str = new StringBuilder();
        String beforeYearNumber = str.append(bgPeriodTypeInfo.getNumber()).append(".").append(year - 1).append("Y").toString();
        if (iDisp.exists("select id,endDate where number = '" + beforeYearNumber + "'") && (bgPeriodDispInfo = iDisp.getBgPeriodDispInfo("select id,endDate where number = '" + beforeYearNumber + "'")) != null) {
            Date endDate = bgPeriodDispInfo.getEndDate();
            for (BgPeriodInfo saveInfo : createBgPeriodInfos) {
                if (!endDate.after(saveInfo.getBeginDate())) continue;
                msg.append(ResourceBase.getString((String)resClassName, (String)"retainAllPeriods", (Locale)localeFromEnv, (Object[])new Object[]{year + " "})).append("\n");
                return false;
            }
        }
        str.setLength(0);
        String afterYearNumber = str.append(bgPeriodTypeInfo.getNumber()).append(".").append(year + 1).append("Y").toString();
        if (iDisp.exists("select id,beginDate where number = '" + afterYearNumber + "'") && (bgPeriodDispInfo = iDisp.getBgPeriodDispInfo("select id,beginDate where number = '" + afterYearNumber + "'")) != null) {
            Date beginDate = bgPeriodDispInfo.getBeginDate();
            for (BgPeriodInfo saveInfo : createBgPeriodInfos) {
                if (!beginDate.before(saveInfo.getEndDate())) continue;
                msg.append(ResourceBase.getString((String)resClassName, (String)"retainAllPeriods", (Locale)localeFromEnv, (Object[])new Object[]{year + " "})).append("\n");
                return false;
            }
        }
        return true;
    }

    @Override
    protected void _addBatchData(Context ctx, List list, String groupId) throws BOSException, EASBizException {
        if (list == null || list.isEmpty()) {
            return;
        }
        BgPeriodTypeInfo bgPeriodType = BgPeriodTypeFactory.getLocalInstance(ctx).getBgPeriodTypeInfo((IObjectPK)new ObjectSingleKey((Object)groupId));
        IBgPeriod bgperiodInstance = BgPeriodFactory.getLocalInstance(ctx);
        CoreBaseCollection bgPeriodCollection = new CoreBaseCollection();
        BgPeriodDispCollection collection = new BgPeriodDispCollection();
        CoreBaseCollection bgPeriodDispCollection = new CoreBaseCollection();
        List bgPeriodInfos = list;
        HashMap<String, BgPeriodDispInfo> map = new HashMap<String, BgPeriodDispInfo>();
        for (BgPeriodInfo object : bgPeriodInfos) {
            bgPeriodCollection.add((CoreBaseInfo)object);
            object.setCreateTime(new Timestamp(System.currentTimeMillis()));
            object.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            object.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            object.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            BgPeriodDispInfo disp = BgPeriodHelper.convert2BgPeriodDisp(object, bgPeriodType);
            collection.add(disp);
            map.put(disp.getLongNumber(), disp);
        }
        String pLongNumber = "";
        String longNumber = "";
        BgPeriodDispInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            longNumber = info.getLongNumber();
            if (longNumber.contains("!")) {
                pLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                info.setParent((BgPeriodDispInfo)map.get(pLongNumber));
            }
            bgPeriodDispCollection.add((CoreBaseInfo)info);
        }
        BgIntIdHelper.setIntIdOnlyAddNew(ctx, (IObjectCollection)bgPeriodCollection, "T_MBG_BgPeriod", true);
        bgperiodInstance.addnewBatchData(bgPeriodCollection);
        this.addnewBatchData(ctx, bgPeriodDispCollection);
    }

    private List<BgPeriodInfo> isExist(Context ctx, List<BgPeriodInfo> bgPeriodInfos) throws EASBizException, BOSException {
        if (bgPeriodInfos == null || bgPeriodInfos.isEmpty()) {
            return null;
        }
        ArrayList<BgPeriodInfo> list = new ArrayList<BgPeriodInfo>();
        HashSet<String> set = new HashSet<String>();
        for (BgPeriodInfo bgPeriodInfo : bgPeriodInfos) {
            set.add(bgPeriodInfo.getNumber());
        }
        FilterInfo filter = new FilterInfo();
        BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("number", set, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        BgPeriodCollection bgPeriodCollection = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodCollection(view);
        if (bgPeriodCollection != null && !bgPeriodCollection.isEmpty()) {
            for (int i = 0; i < bgPeriodCollection.size(); ++i) {
                list.add(bgPeriodCollection.get(i));
            }
        }
        return list;
    }

    @Override
    protected void _updateAliasBatchData(Context ctx, Map aliasMap) throws BOSException, EASBizException {
        if (aliasMap == null || aliasMap.isEmpty()) {
            return;
        }
        Object[] arr = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String fid : aliasMap.keySet()) {
            arr = new Object[]{aliasMap.get(fid), fid};
            params.add(arr);
        }
        String sql = "update t_mbg_bgperioddisp set falias = ? where fid = ?";
        try {
            BgDBUtils.executeBatch(ctx, sql, params);
        }
        catch (SQLException e) {
            logger.error((Object)(sql + e));
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _checkPeriodType(Context ctx, Set bgPeriodNumbers, boolean isAddMember) throws BOSException, EASBizException {
        if (bgPeriodNumbers == null || bgPeriodNumbers.isEmpty() || bgPeriodNumbers.size() == 1) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("type.*");
        evi.getSelector().add("isLeaf");
        evi.getSelector().add("showLevel");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)bgPeriodNumbers, CompareType.INCLUDE));
        BgPeriodDispCollection col = this.getBgPeriodDispCollection(ctx, evi);
        if (col == null || col.isEmpty()) {
            return;
        }
        Object[] result = BgNPeriodHelper.checkPeriodType(col);
        if (((Boolean)result[0]).booleanValue() && ((Boolean)result[1]).booleanValue()) {
            throw new BgPeriodException(BgPeriodException.FISCALYEARDIFFERENT);
        }
        if (!((Boolean)result[1]).booleanValue()) {
            return;
        }
        HashMap<String, BgPeriodTypeInfo> bgTypes = new HashMap<String, BgPeriodTypeInfo>();
        HashMap leafBgPeriod = new HashMap();
        for (int i = 0; i < col.size(); ++i) {
            BgPeriodDispInfo bgPeriod = col.get(i);
            BgPeriodTypeInfo type = bgPeriod.getType();
            if (!bgPeriod.isIsLeaf()) {
                bgTypes.put(type.getId().toString(), type);
                continue;
            }
            if (FiscalYearEnum.STANDARDYEAR.equals((Object)type.getFiscalYear())) continue;
            if (!leafBgPeriod.containsKey(bgPeriod.getNumber())) {
                leafBgPeriod.put(bgPeriod.getNumber(), new HashMap());
            }
            ((Map)leafBgPeriod.get(bgPeriod.getNumber())).put(type.getId().toString(), type);
        }
        block1: for (Map tmpMap : leafBgPeriod.values()) {
            for (String bgTypeId : tmpMap.keySet()) {
                if (!bgTypes.containsKey(bgTypeId)) continue;
                continue block1;
            }
            bgTypes.putAll(tmpMap);
        }
        HashMap<Integer, Integer> startMonth = new HashMap<Integer, Integer>();
        Integer typeEnum = null;
        Integer month = null;
        for (BgPeriodTypeInfo type : bgTypes.values()) {
            typeEnum = type.getBgPeriodEnum();
            month = type.getStartMonth().getValue();
            if (startMonth.containsKey(typeEnum)) {
                if (month == startMonth.get(typeEnum)) continue;
                if (isAddMember) {
                    throw new BgPeriodException(BgPeriodException.STARTMONTHDIFFRENT);
                }
                throw new BgPeriodException(BgPeriodException.STARTMONTHDIFFRENTCHECK);
            }
            startMonth.put(typeEnum, month);
        }
    }

    @Override
    protected List _getSelfPeriodDispNumber(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> bgPeriodDispNumber = new ArrayList<String>();
        String sql = "SELECT FNUMBER FROM T_MBG_BGPERIODDISP WHERE FPERIODTYPE IN (8,10,11,12,13,14,15,16,17)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String number = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                number = rst.getString("FNUMBER");
                if (number == null || !Character.isDigit(number.charAt(number.length() - 1))) continue;
                bgPeriodDispNumber.add(number);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)(sql + e));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgPeriodDispNumber;
    }

    @Override
    protected void _replenishData(Context ctx, int year, String bgPeriodTypeId) throws BOSException, EASBizException {
        Locale localeFromEnv = ContextUtils.getLocaleFromEnv();
        ArrayList<BgPeriodInfo> createPeriodList = new ArrayList<BgPeriodInfo>();
        BgPeriodTypeInfo bgPeriodType = BgPeriodTypeFactory.getLocalInstance(ctx).getBgPeriodTypeInfo((IObjectPK)new ObjectSingleKey((Object)bgPeriodTypeId));
        BgPeriodInfoFactory factory = new BgPeriodInfoFactory(bgPeriodType, localeFromEnv);
        createPeriodList.addAll(factory.createBgPeriod(year, false));
        if (createPeriodList.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String yearNumber = bgPeriodType.getNumber() + "." + year + "Y";
        BgPeriodDispCollection existPeriodDispColls = BgPeriodDispFactory.getLocalInstance(ctx).getBgPeriodDispCollection("where type='" + bgPeriodTypeId + "' and longNumber like '" + yearNumber + "%'");
        HashSet<String> periodIdSet = new HashSet<String>();
        if (existPeriodDispColls != null && !existPeriodDispColls.isEmpty()) {
            for (int i = 0; i < existPeriodDispColls.size(); ++i) {
                periodIdSet.add(existPeriodDispColls.get(i).getBgPeriod().getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", periodIdSet, CompareType.INCLUDE));
        BgPeriodCollection existPeriodColls = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodCollection(viewInfo);
        if (existPeriodColls == null || existPeriodColls.isEmpty() || existPeriodDispColls == null || existPeriodDispColls.isEmpty()) {
            return;
        }
        HashMap<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
        for (int i = 0; i < existPeriodColls.size(); ++i) {
            periodMap.put(existPeriodColls.get(i).getNumber(), existPeriodColls.get(i));
        }
        HashMap<String, BgPeriodDispInfo> periodDispMap = new HashMap<String, BgPeriodDispInfo>();
        for (int i = 0; i < existPeriodDispColls.size(); ++i) {
            periodDispMap.put(existPeriodDispColls.get(i).getNumber(), existPeriodDispColls.get(i));
        }
        IBgPeriod bgperiodInstance = BgPeriodFactory.getLocalInstance(ctx);
        CoreBaseCollection bgPeriodCollection = new CoreBaseCollection();
        BgPeriodDispCollection collection = new BgPeriodDispCollection();
        CoreBaseCollection bgPeriodDispCollection = new CoreBaseCollection();
        ArrayList<BgPeriodInfo> createPeriodColls = createPeriodList;
        HashMap<String, BgPeriodDispInfo> map = new HashMap<String, BgPeriodDispInfo>();
        for (BgPeriodInfo object : createPeriodColls) {
            object.setCreateTime(existPeriodColls.get(0).getCreateTime());
            object.setCreator(existPeriodColls.get(0).getCreator());
            object.setLastUpdateTime(existPeriodColls.get(0).getLastUpdateTime());
            object.setLastUpdateUser(existPeriodColls.get(0).getLastUpdateUser());
            if (periodMap.containsKey(object.getNumber())) {
                object.setId(((BgPeriodInfo)periodMap.get(object.getNumber())).getId());
            }
            BgPeriodDispInfo disp = BgPeriodHelper.convert2BgPeriodDisp(object, bgPeriodType);
            map.put(disp.getLongNumber(), disp);
            if (periodMap.containsKey(object.getNumber())) continue;
            bgPeriodCollection.add((CoreBaseInfo)object);
            collection.add(disp);
        }
        String pLongNumber = "";
        String longNumber = "";
        BgPeriodDispInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            longNumber = info.getLongNumber();
            if (longNumber.contains("!")) {
                pLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                info.setParent((BgPeriodDispInfo)map.get(pLongNumber));
            }
            if (periodDispMap.containsKey(info.getNumber())) {
                info.setId(((BgPeriodInfo)periodMap.get(info.getNumber())).getId());
            }
            bgPeriodDispCollection.add((CoreBaseInfo)info);
        }
        bgperiodInstance.addnewBatchData(bgPeriodCollection);
        this.addnewBatchData(ctx, bgPeriodDispCollection);
        if (bgPeriodCollection.size() != 0 && bgPeriodDispCollection.size() != 0) {
            BgPeriodHelper.checkBgPeriodClosure(ctx, bgPeriodType.getId());
        }
    }

    @Override
    protected void _amendmentDataForStride(Context ctx, int year, String bgPeriodTypeId) throws BOSException, EASBizException {
        try {
            IBgPeriodDisp dispInstance = BgPeriodDispFactory.getLocalInstance(ctx);
            IBgPeriod localInstance = BgPeriodFactory.getLocalInstance(ctx);
            BgPeriodTypeInfo bgPeriodTypeInfo = BgPeriodTypeFactory.getLocalInstance(ctx).getBgPeriodTypeInfo((IObjectPK)new ObjectSingleKey((Object)bgPeriodTypeId));
            StringBuilder sb = new StringBuilder();
            String yearNumber = bgPeriodTypeInfo.getNumber() + "." + year + "Y";
            BgPeriodDispCollection existPeriodDispColls = BgPeriodDispFactory.getLocalInstance(ctx).getBgPeriodDispCollection("where type='" + bgPeriodTypeId + "' and longNumber like '" + yearNumber + "%'");
            BgPeriodDispInfo bgPeriodDispInfo = null;
            HashSet<String> existsBgPeriodIdSet = new HashSet<String>();
            for (int i = 0; i < existPeriodDispColls.size(); ++i) {
                bgPeriodDispInfo = existPeriodDispColls.get(i);
                existsBgPeriodIdSet.add(bgPeriodDispInfo.getBgPeriod().getId().toString());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", existsBgPeriodIdSet, CompareType.INCLUDE));
            BgPeriodCollection existPeriodColls = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodCollection(viewInfo);
            HashMap<String, BgPeriodInfo> existPeriodMap = new HashMap<String, BgPeriodInfo>();
            for (int i = 0; i < existPeriodColls.size(); ++i) {
                existPeriodMap.put(existPeriodColls.get(i).getNumber(), existPeriodColls.get(i));
            }
            HashMap<BgPeriodInfo, BgPeriodInfo> oldNewPeriodMap = new HashMap<BgPeriodInfo, BgPeriodInfo>();
            HashMap<String, BgPeriodDispInfo> map = new HashMap<String, BgPeriodDispInfo>();
            CoreBaseCollection collection = new CoreBaseCollection();
            this.dealWithPeriod(ctx, year, localInstance, bgPeriodTypeInfo, existPeriodDispColls, existPeriodColls, existPeriodMap, oldNewPeriodMap, map, collection);
            this.persistent(dispInstance, localInstance, map, collection, oldNewPeriodMap);
            this.alterClousureAndFact(ctx, bgPeriodTypeInfo, collection, oldNewPeriodMap);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void dealWithPeriod(Context ctx, int year, IBgPeriod localInstance, BgPeriodTypeInfo bgPeriodTypeInfo, BgPeriodDispCollection existPeriodDispColls, BgPeriodCollection existPeriodColls, Map<String, BgPeriodInfo> existPeriodMap, Map<BgPeriodInfo, BgPeriodInfo> oldNewPeriodMap, Map<String, BgPeriodDispInfo> map, CoreBaseCollection collection) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = null;
        BgPeriodDispInfo existbgPeriodDispInfo = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodInfoFactory factory = new BgPeriodInfoFactory(bgPeriodTypeInfo, ctx.getLocale());
        List<BgPeriodInfo> bgperiods = factory.createBgPeriod(year, bgPeriodTypeInfo.isSelfDefined());
        for (BgPeriodInfo object : bgperiods) {
            BgPeriodDispInfo disp = BgPeriodHelper.convert2BgPeriodDisp(object, bgPeriodTypeInfo);
            Date beginDate = disp.getBeginDate();
            Date endDate = disp.getEndDate();
            for (int j = 0; j < existPeriodDispColls.size(); ++j) {
                existbgPeriodDispInfo = existPeriodDispColls.get(j);
                if (!existbgPeriodDispInfo.getBeginDate().equals(beginDate) || !existbgPeriodDispInfo.getEndDate().equals(endDate)) continue;
                disp.setId(existbgPeriodDispInfo.getId());
                disp.setCreateTime(existbgPeriodDispInfo.getCreateTime());
                disp.setCreator(existbgPeriodDispInfo.getCreator());
                disp.setLastUpdateTime(existbgPeriodDispInfo.getLastUpdateTime());
                disp.setLastUpdateUser(existbgPeriodDispInfo.getLastUpdateUser());
            }
            filter = new FilterInfo();
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("number", (Object)"MONT.%M", CompareType.LIKE));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("beginDate", (Object)beginDate, CompareType.EQUALS));
            BgCommHelper.replaceFilterItems(filter, new FilterItemInfo("endDate", (Object)endDate, CompareType.EQUALS));
            view.setFilter(filter);
            BgPeriodCollection bgPeriodCollection = localInstance.getBgPeriodCollection(view);
            if (bgPeriodCollection != null && bgPeriodCollection.size() == 1) {
                bgPeriodInfo = bgPeriodCollection.get(0);
                disp.setBgPeriod(bgPeriodInfo);
                disp.setName(bgPeriodInfo.getName());
                disp.setAlias(bgPeriodInfo.getName());
                disp.setLongNumber(disp.getLongNumber().replace(disp.getNumber(), bgPeriodInfo.getNumber()));
                disp.setNumber(bgPeriodInfo.getNumber());
                for (int i = 0; i < existPeriodColls.size(); ++i) {
                    if (!existPeriodColls.get(i).getBeginDate().equals(beginDate) || !existPeriodColls.get(i).getEndDate().equals(endDate) || existPeriodColls.get(i).getNumber().equals(bgPeriodCollection.get(0).getNumber())) continue;
                    oldNewPeriodMap.put(existPeriodColls.get(i), bgPeriodCollection.get(0));
                }
            } else {
                if (existPeriodMap.containsKey(object.getNumber())) {
                    bgPeriodInfo = existPeriodMap.get(object.getNumber());
                    object.setId(bgPeriodInfo.getId());
                    object.setCreateTime(bgPeriodInfo.getCreateTime());
                    object.setCreator(bgPeriodInfo.getCreator());
                    object.setLastUpdateTime(bgPeriodInfo.getLastUpdateTime());
                    object.setLastUpdateUser(bgPeriodInfo.getLastUpdateUser());
                }
                disp.setBgPeriod(object);
            }
            map.put(disp.getLongNumber(), disp);
            collection.add((CoreBaseInfo)disp);
        }
    }

    private void alterClousureAndFact(Context ctx, BgPeriodTypeInfo bgPeriodTypeInfo, CoreBaseCollection collection, Map<BgPeriodInfo, BgPeriodInfo> oldNewPeriodMap) {
        if (oldNewPeriodMap.keySet().size() != 0 && collection.size() != 0) {
            BgPeriodHelper.checkBgPeriodClosure(ctx, bgPeriodTypeInfo.getId());
        }
    }

    private void persistent(IBgPeriodDisp dispInstance, IBgPeriod localInstance, Map<String, BgPeriodDispInfo> map, CoreBaseCollection collection, Map<BgPeriodInfo, BgPeriodInfo> oldNewPeriodMap) throws BOSException, EASBizException {
        String pLongNumber = "";
        String longNumber = "";
        BgPeriodDispInfo info = null;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            info = (BgPeriodDispInfo)collection.get(i);
            longNumber = info.getLongNumber();
            if (longNumber.contains("!")) {
                pLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                info.setParent(map.get(pLongNumber));
            }
            list.add(info.getId().toString());
        }
        ObjectSingleKey[] arrayPK = new ObjectSingleKey[oldNewPeriodMap.keySet().size()];
        int i = 0;
        for (BgPeriodInfo bgPeriodInfo : oldNewPeriodMap.keySet()) {
            arrayPK[i] = new ObjectSingleKey((Object)bgPeriodInfo.getId().toString());
            ++i;
        }
        localInstance.delete((IObjectPK[])arrayPK);
        dispInstance.updateBatchData(collection);
    }
}

