/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementException;
import com.kingdee.eas.ma.base.BgPropertyException;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.BgRefDimMemberEnum;
import com.kingdee.eas.ma.base.BgScenarioException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.AbstractBgPropertySortControllerBean;
import com.kingdee.eas.ma.base.app.utils.BgRefDimMemberHelper;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgPropertyHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPropertySortControllerBean
extends AbstractBgPropertySortControllerBean {
    private static final long serialVersionUID = -8355000098405362281L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgPropertySortControllerBean");
    private static String RS = "com.kingdee.eas.ma.base.BgPropertyResource";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgPropertySortInfo bgPropertySort = (BgPropertySortInfo)model;
        FilterInfo filter = new FilterInfo();
        this.checkPropertyExistByDimSource(ctx, filter, bgPropertySort, "number");
        filter.getFilterItems().clear();
        this.checkPropertyExistByDimSource(ctx, filter, bgPropertySort, "name");
        return super._addnew(ctx, model);
    }

    private void checkPropertyExistByDimSource(Context ctx, FilterInfo filter, BgPropertySortInfo bgPropertySort, String checkField) throws BgScenarioException, EASBizException, BOSException {
        if (ctx == null) {
            return;
        }
        if (bgPropertySort.getMbgDim() != null) {
            filter.appendFilterItem("mbgDim.id", (Object)bgPropertySort.getMbgDimId());
        } else {
            filter.appendFilterItem("sourceType", (Object)bgPropertySort.getSourceType());
        }
        if ("number".equals(checkField)) {
            filter.appendFilterItem(checkField, (Object)bgPropertySort.getNumber());
            if (this._exists(ctx, filter)) {
                throw new BgScenarioException(BgScenarioException.FORBIDDENREPEATNUM);
            }
        } else {
            filter.appendFilterItem(checkField, (Object)bgPropertySort.getName());
            if (this._exists(ctx, filter)) {
                throw new BgElementException(BgElementException.FORBIDDENREPEATNAME);
            }
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo curCUFilter = super.getFilterForDefaultCU(ctx, model);
        if (model == null) {
            return curCUFilter;
        }
        BgPropertySortInfo bgPropertySort = (BgPropertySortInfo)model;
        if (bgPropertySort.getMbgDim() != null) {
            curCUFilter.appendFilterItem("mbgDim.id", (Object)bgPropertySort.getMbgDimId());
        } else {
            curCUFilter.appendFilterItem("sourceType", (Object)bgPropertySort.getSourceType());
        }
        return curCUFilter;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgPropertySortInfo bgSortInfo = (BgPropertySortInfo)model;
        Locale local = ctx.getLocale();
        if (bgSortInfo.getDescription(LocaleUtils.locale_L3) != null && bgSortInfo.getDescription(LocaleUtils.locale_L3).length() > 255) {
            bgSortInfo.setDescription(bgSortInfo.getDescription(LocaleUtils.locale_L3).substring(0, 255), LocaleUtils.locale_L3);
        }
        BgPropertySortInfo bgPropertySort = (BgPropertySortInfo)model;
        MbgDimInfo mbgDim = bgPropertySort.getMbgDim();
        if (bgSortInfo.getId() != null) {
            IRowSet rs;
            block8: {
                String sql = null;
                rs = null;
                try {
                    if (mbgDim == null) {
                        sql = "select fid from t_mbg_bgpropertysort where FID <> ? and FName_" + local + " = ? and FSourceType = ?";
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgSortInfo.getId().toString(), bgSortInfo.getName(), bgPropertySort.getSourceType()});
                    } else {
                        String mbgDimId = mbgDim.getId().toString();
                        sql = "select fid from t_mbg_bgpropertysort where FID <> ? and FName_" + local + " = ? and fmbgdimid = ? and FSourceType = ?";
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgSortInfo.getId().toString(), bgSortInfo.getName(), mbgDimId, bgPropertySort.getSourceType()});
                    }
                    if (!rs.next()) break block8;
                    throw new BgElementException(BgElementException.FORBIDDENREPEATNAME);
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)"budget error:", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        return super._submit(ctx, model);
    }

    @Override
    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select fid from t_mbg_bgproperty where FBgPropertySortID = ?";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
            if (rs.next()) {
                throw new BgPropertyException(BgPropertyException.HASPROPERTY);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        if (BgRefDimMemberEnum.BgTemplate.equals((Object)BgRefDimMemberHelper.checkRef(ctx, BOSUuid.read((String)pk.toString())))) {
            throw new BgPropertyException(BgPropertyException.ISUSEBYTEMPLATE);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected List _querySort(Context ctx, Set dimNumbers, String filterString, boolean isShowExtSort) throws BOSException, EASBizException {
        ArrayList<BgPropertySortInfo> result = new ArrayList<BgPropertySortInfo>();
        if (dimNumbers == null || dimNumbers.isEmpty()) {
            return result;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            String mbgDimId;
            String dimName;
            conn = this.getConnection(ctx);
            HashSet<String> necessary = new HashSet<String>(DimensionBaseConstants.necessary);
            necessary.remove(DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
            necessary.remove(DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
            dimNumbers.removeAll(necessary);
            if (dimNumbers.isEmpty()) {
                ArrayList<BgPropertySortInfo> arrayList = result;
                return arrayList;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select s.FDimNumber, s.FDimName_" + ctx.getLocale() + " FDimName, v.FMbgDimID FROM T_MBG_BgDimSettings s Inner Join T_MBG_BgDimSettingsMember m On s.FID = m.FBgDimSettingsID Left Join T_MBG_MbgView v On v.FID = m.FMemberId Where s.FDimNumber IN(");
            MbgSqlHelper.addPlaceHolder(sql, dimNumbers.size()).append(")");
            sql.append(" Order By s.FSeq, m.FSeq");
            LinkedHashMap<String, String> dimNames = new LinkedHashMap<String, String>();
            HashMap<String, String> mbgDimIds = new HashMap<String, String>();
            HashMap<String, String> mbgDimIdMap = new HashMap<String, String>();
            final ArrayList<String> dimIds = new ArrayList<String>();
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams(pstmt, dimNumbers.toArray());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String dimNumber = rst.getString("FDimNumber");
                dimName = rst.getString("FDimName");
                mbgDimId = rst.getString("FMbgDimID");
                dimNames.put(dimNumber, dimName);
                if (dimNumber.equals(DimensionBaseConstants.DEF_ORGUNIT_NUMBER)) {
                    mbgDimId = "33F82845";
                } else if (dimNumber.equals(DimensionBaseConstants.DEF_ACCOUNT_NUMBER)) {
                    mbgDimId = "E68E9293";
                }
                mbgDimIds.put(mbgDimId, dimNumber);
                mbgDimIdMap.put(dimNumber, mbgDimId);
                if (dimIds.contains(mbgDimId)) continue;
                dimIds.add(mbgDimId);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (dimIds.isEmpty()) {
                ArrayList<BgPropertySortInfo> arrayList = result;
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
                return arrayList;
            }
            sql.setLength(0);
            ArrayList<String> params = new ArrayList<String>();
            sql.append("Select p.FID, p.FNumber, p.FName_" + ctx.getLocale() + " FName, p.FSourceType, p.FMbgDimID FROM T_MBg_BgPropertySort p Where ");
            sql.append(" p.FSourceType IN(");
            MbgSqlHelper.addPlaceHolder(sql, dimIds.size()).append(")");
            params.addAll(dimIds);
            sql.append(" OR ");
            sql.append(" p.FMbgDimID IN(");
            MbgSqlHelper.addPlaceHolder(sql, dimIds.size()).append(")");
            params.addAll(dimIds);
            sql.append(" Order By FLongNumber");
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams(pstmt, params.toArray());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgPropertySortInfo info = new BgPropertySortInfo();
                info.setId(BOSUuid.read((String)rst.getString("FID")));
                info.setNumber(rst.getString("FNumber"));
                info.setName(rst.getString("FName"));
                info.setSourceType(rst.getString("FSourceType"));
                mbgDimId = rst.getString("FMbgDimId");
                if (!StringUtils.isEmpty((String)mbgDimId)) {
                    info.setMbgDim(new MbgDimInfo());
                    info.getMbgDim().setId(BOSUuid.read((String)mbgDimId));
                }
                dimName = (String)dimNames.get(mbgDimIds.get(info.getMbgDimId()));
                info.put(BgBaseConstants.DIMENSION_NAME, dimName);
                info.put(BgBaseConstants.DIMENSION_NUMBER, mbgDimIds.get(info.getMbgDimId()));
                if (!(StringUtils.isEmpty((String)filterString) || dimName != null && dimName.indexOf(filterString) >= 0 || info.getNumber().indexOf(filterString) >= 0 || info.getName() != null && info.getName().indexOf(filterString) >= 0)) continue;
                result.add(info);
            }
            if (isShowExtSort) {
                this.adSysDefBgPropertyNameSort(ctx, dimNames, result, mbgDimIdMap, filterString);
            }
            Collections.sort(result, new Comparator<BgPropertySortInfo>(){

                @Override
                public int compare(BgPropertySortInfo o1, BgPropertySortInfo o2) {
                    return o1.getNumber().toLowerCase().compareTo(o2.getNumber().toLowerCase());
                }
            });
            Collections.sort(result, new Comparator<BgPropertySortInfo>(){

                @Override
                public int compare(BgPropertySortInfo o1, BgPropertySortInfo o2) {
                    return new Integer(dimIds.indexOf(o1.getMbgDimId())).compareTo(dimIds.indexOf(o2.getMbgDimId()));
                }
            });
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return result;
    }

    private void adSysDefBgPropertyNameSort(Context ctx, Map<String, String> dimNames, List<BgPropertySortInfo> result, Map<String, String> mbgDimIdMap, String filterString) {
        String dimNumber = null;
        String dimName = null;
        String mbgDimId = null;
        for (Map.Entry<String, String> entry : dimNames.entrySet()) {
            dimNumber = entry.getKey();
            dimName = entry.getValue();
            BgPropertySortInfo info = new BgPropertySortInfo();
            info.setNumber(BgPropertyHelper.genDimNamePropertySortNumber(dimNumber));
            info.setName(entry.getValue() + EASResource.getString((String)RS, (String)"systemName", (Locale)ctx.getLocale()));
            mbgDimId = mbgDimIdMap.get(dimNumber);
            if (!StringUtils.isEmpty((String)mbgDimId)) {
                if (!DimensionBaseConstants.necessary.contains(dimNumber)) {
                    info.setMbgDim(new MbgDimInfo());
                    info.getMbgDim().setId(BOSUuid.read((String)mbgDimId));
                } else {
                    info.setSourceType(mbgDimId);
                }
            }
            info.put(BgBaseConstants.DIMENSION_NAME, entry.getValue());
            info.put(BgBaseConstants.DIMENSION_NUMBER, entry.getKey());
            if (!(StringUtils.isEmpty((String)filterString) || dimName != null && dimName.indexOf(filterString) >= 0 || info.getNumber().indexOf(filterString) >= 0 || info.getName() != null && info.getName().indexOf(filterString) >= 0)) continue;
            result.add(info);
            info = new BgPropertySortInfo();
            info.setNumber(BgPropertyHelper.genDimDescPropertySortNumber(dimNumber));
            info.setName(entry.getValue() + EASResource.getString((String)RS, (String)"systemDesc", (Locale)ctx.getLocale()));
            mbgDimId = mbgDimIdMap.get(dimNumber);
            if (!StringUtils.isEmpty((String)mbgDimId)) {
                if (!DimensionBaseConstants.necessary.contains(dimNumber)) {
                    info.setMbgDim(new MbgDimInfo());
                    info.getMbgDim().setId(BOSUuid.read((String)mbgDimId));
                } else {
                    info.setSourceType(mbgDimId);
                }
            }
            info.put(BgBaseConstants.DIMENSION_NAME, entry.getValue());
            info.put(BgBaseConstants.DIMENSION_NUMBER, entry.getKey());
            if (!(StringUtils.isEmpty((String)filterString) || dimName != null && dimName.indexOf(filterString) >= 0 || info.getNumber().indexOf(filterString) >= 0 || info.getName() != null && info.getName().indexOf(filterString) >= 0)) continue;
            result.add(info);
        }
    }

    @Override
    protected boolean _existsRefScheme(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        Boolean exists = false;
        try {
            Class<?> forName = Class.forName("com.kingdee.eas.ma.mbg.RefSchemeHelper");
            Object instance = forName.newInstance();
            Class[] paramTypes = new Class[]{Context.class, FilterInfo.class};
            Method method = forName.getMethod("invoke", paramTypes);
            exists = (Boolean)method.invoke(instance, ctx, filter);
        }
        catch (Exception e) {
            logger.error((Object)"existsRefScheme error :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return exists;
    }
}

