/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.ma.base.BgScenarioException;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionException;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.AbstractBgVersionControllerBean;
import com.kingdee.eas.ma.base.utils.BgCommNHelper;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgVersionControllerBean
extends AbstractBgVersionControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.BgVersionControllerBean");
    private static final String BGVERSION_TABLE = "T_MBG_BgVersion";
    private static final String BGVERSIONID = "FVersionId";

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    protected FilterInfo getFilterForDefaultCU(IObjectValue model) {
        return new FilterInfo();
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        BgDimCacheUtils.clearDimMemberCache(ctx);
        BgDimCacheUtils.clearBgVersionCache(ctx);
    }

    public IObjectPK _submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, (IObjectValue)model);
        return super._submit(ctx, (IObjectValue)model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgVersionInfo bgVersion = (BgVersionInfo)model;
        Locale local = ctx.getLocale();
        if (bgVersion.getId() != null) {
            IRowSet rs;
            block5: {
                String sql = "select fid from t_mbg_bgversion where FID <> ? and FName_" + local + " = ?";
                rs = null;
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bgVersion.getId().toString(), bgVersion.getName()});
                    if (!rs.next()) break block5;
                    throw new BgVersionException(BgVersionException.FORBIDDENREPEATNAME);
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)"budget error:", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgVersionInfo bgVersion = (BgVersionInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("number", (Object)bgVersion.getNumber());
        if (this._exists(ctx, filter)) {
            throw new BgScenarioException(BgScenarioException.FORBIDDENREPEATNUM);
        }
        filter.appendFilterItem("name", (Object)bgVersion.getName());
        if (this._exists(ctx, filter)) {
            throw new BgVersionException(BgVersionException.FORBIDDENREPEATNAME);
        }
        BgVersionInfo bgVersionInfo = (BgVersionInfo)model;
        Integer maxid = BgCommNHelper.getMaxId(ctx, BGVERSION_TABLE, BGVERSIONID);
        bgVersionInfo.setVersionId(maxid);
        return super._addnew(ctx, model);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.isVersionUsed(ctx, pk)) throw new BgVersionException(BgVersionException.ISUSE);
        if (this.isSysVesion(ctx, pk)) throw new BgVersionException(BgVersionException.ISSYSSET);
        if (!this.isCreateByThisOrg(ctx, pk)) {
            throw new BgVersionException(BgVersionException.ISCREATEBYORG);
        }
        super._delete(ctx, pk);
    }

    private boolean isSysVesion(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet rs;
        block5: {
            boolean bl;
            if (pk == null) {
                return false;
            }
            String sql = "select fid from t_mbg_bgversion where FID = ? and FNumber = ?";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString(), "Ve"});
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    private boolean isVersionUsed(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet rs;
        block5: {
            boolean bl;
            if (pk == null) {
                return false;
            }
            String sql = "SELECT s.fid FROM t_mbg_bgScheme s  left join t_mbg_bgDimSettings d on d.FBgschemeId = s.FID   left join t_mbg_bgDimSettingsMember m  on d.fid=m.FBgDimSettingsId  where  d.FDimNumber = 'BG_Version'  and m.FmemberId = ? ";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    private boolean isCreateByThisOrg(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet rs;
        block5: {
            boolean bl;
            if (pk == null) {
                return false;
            }
            CostCenterOrgUnitInfo ccoui = ContextUtil.getCurrentCostUnit((Context)ctx);
            String sql = "select fid from t_mbg_bgversion where FID = ? and FOrgUnitID = ?";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString(), ccoui.getId().toString()});
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    @Override
    protected boolean _isExistRepeatNum(Context ctx, String bgVersionNum) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("number", (Object)bgVersionNum);
        return this.exists(ctx, filter);
    }

    @Override
    protected Map _remove(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        HashSet<String> cantRemove = new HashSet<String>();
        HashSet<String> canSet = new HashSet<String>();
        HashSet idset = new HashSet();
        result.put("cantRemove", cantRemove);
        result.put("canSet", canSet);
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("isSysData");
        sic.add("parent.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        for (int index = 0; index < ids.size(); ++index) {
            idset.add(ids.get(index));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        view.setFilter(filter);
        BgVersionCollection verCol = BgVersionFactory.getLocalInstance(ctx).getBgVersionCollection(view);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add("id");
        sic1.add("number");
        sic1.add("name");
        sic1.add("isSysData");
        sic1.add("parent.id");
        evi.getSelector().addObjectCollection((IObjectCollection)sic1);
        filter1.getFilterItems().add(new FilterItemInfo("id", (Object)"Select settMember.FMemberID FROM T_MBG_BgDimSettings sett INNER JOIN T_MBG_BgDimSettingsMember settMember On settMember.FBgDimSettingsId = sett.FID Where sett.FDimNumber = 'BG_Version'", CompareType.INNER));
        evi.setFilter(filter1);
        BgVersionCollection cantVerCol = BgVersionFactory.getLocalInstance(ctx).getBgVersionCollection(evi);
        idset.clear();
        int en = cantVerCol.size();
        for (int j = 0; j < en; ++j) {
            TreeBaseCollection children = this.getAllChildren(ctx, cantVerCol.get(j));
            if (verCol.contains(cantVerCol.get(j))) {
                verCol.remove(cantVerCol.get(j));
                cantRemove.add(cantVerCol.get(j).getId().toString());
            }
            if (children == null) continue;
            for (int i = 0; i < children.size(); ++i) {
                if (!verCol.contains(children.get(i))) continue;
                verCol.remove(cantVerCol.get(j));
                cantRemove.add(cantVerCol.get(j).getId().toString());
            }
        }
        HashMap childMap = new HashMap();
        HashSet<Object> childSet = null;
        HashMap<Object, BgVersionInfo> parentMap = new HashMap<Object, BgVersionInfo>();
        TreeBaseCollection coll = null;
        int in = verCol.size();
        for (int i = 0; i < in; ++i) {
            BgVersionInfo version = verCol.get(i);
            coll = this.getAllChildren(ctx, version);
            childSet = new HashSet<Object>();
            BgVersionInfo child = null;
            int jn = coll.size();
            for (int j = 0; j < jn; ++j) {
                child = (BgVersionInfo)coll.get(j);
                childSet.add(child);
                canSet.add(child.getId().toString());
                if (verCol.contains(child)) continue;
                idset.add(child.getId().toString());
            }
            childSet.add(version);
            canSet.add(version.getId().toString());
            childMap.put(version, childSet);
            if (version.getParent() == null) continue;
            parentMap.put(version, version.getParent());
        }
        BgVersionInfo parent = null;
        BgVersionCollection updateParentColl = new BgVersionCollection();
        for (BgVersionInfo account : parentMap.keySet()) {
            parent = (BgVersionInfo)parentMap.get(account);
            coll = this.getAllChildren(ctx, parent);
            BgVersionInfo info = null;
            Boolean flag = true;
            int in2 = coll.size();
            for (int i = 0; i < in2; ++i) {
                info = (BgVersionInfo)coll.get(i);
                if (canSet.contains(info.getId().toString())) continue;
                flag = false;
                break;
            }
            if (!flag.booleanValue()) continue;
            updateParentColl.add(account);
        }
        if (!canSet.isEmpty()) {
            ArrayList lst = new ArrayList(canSet);
            IObjectPK[] pkArrays = new IObjectPK[canSet.size()];
            int in3 = lst.size();
            for (int i = 0; i < in3; ++i) {
                pkArrays[i] = new ObjectUuidPK((String)lst.get(i));
            }
            super._deleteBatchData(ctx, pkArrays);
        }
        if (!updateParentColl.isEmpty()) {
            this.updateParent(ctx, (IObjectCollection)updateParentColl, true);
        }
        canSet.removeAll(idset);
        BgDimCacheUtils.clearDimMemberCache(ctx);
        BgDimCacheUtils.clearBgVersionCache(ctx);
        return result;
    }

    private void updateParent(Context ctx, IObjectCollection colls, boolean isLeaf) throws BOSException {
        BgVersionInfo version = null;
        BgVersionInfo parentInfo = null;
        ArrayList<String> parentIDS = new ArrayList<String>();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            version = (BgVersionInfo)colls.getObject(i);
            if (version.getParent() == null || (parentInfo = version.getParent()).getId() == null) continue;
            parentIDS.add(parentInfo.getId().toString());
        }
        if (!parentIDS.isEmpty()) {
            PreparedStatement pstmt;
            Connection conn;
            block11: {
                int i;
                conn = null;
                pstmt = null;
                int batchSize = 50;
                int batchIndex = 0;
                int size = parentIDS.size();
                int count = (size - 1) / batchSize + 1;
                int pos = 0;
                int value = isLeaf ? 1 : 0;
                StringBuffer sql = new StringBuffer("update T_MBG_BgVersion set FIsLeaf = ? where FID in ( ");
                for (i = 1; i < batchSize; ++i) {
                    sql.append("?,");
                }
                sql.append("?)");
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (i = 0; i < count; ++i) {
                        pstmt.setInt(1, value);
                        int j = 2;
                        while (j <= batchSize + 1) {
                            if (pos < size) {
                                pstmt.setString(j, (String)parentIDS.get(pos));
                            } else {
                                pstmt.setString(j, "#");
                            }
                            ++j;
                            ++pos;
                        }
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex == 0) break block11;
                    pstmt.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }
}

