/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamDataType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.IMbgParams;
import com.kingdee.eas.ma.base.MbgParamsCollection;
import com.kingdee.eas.ma.base.MbgParamsFactory;
import com.kingdee.eas.ma.base.MbgParamsInfo;
import com.kingdee.eas.ma.base.MbgParamsValueInfo;
import com.kingdee.eas.ma.base.app.AbstractMbgParamsValueControllerBean;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class MbgParamsValueControllerBean
extends AbstractMbgParamsValueControllerBean {
    private static final long serialVersionUID = 8439402958095623597L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.MbgParamsValueControllerBean");

    protected FilterInfo getDeafultFilter() {
        return new FilterInfo();
    }

    @Override
    protected IObjectCollection _loadParams(Context ctx, int orgType, BOSUuid orgUnitId) throws BOSException, EASBizException {
        MbgParamsCollection colls = new MbgParamsCollection();
        if (orgUnitId == null) {
            return colls;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FNumber, FName_" + ctx.getLocale() + " AS FName, FAlias_" + ctx.getLocale() + " AS FAlias, FType, FOrgType, FDefaultValue, FCanModified from T_MBG_MbgParams where FOrgType = ? order by FNumber");
        HashMap<String, MbgParamsInfo> mbgParamMap = new HashMap<String, MbgParamsInfo>();
        MbgParamsInfo mbgParam = null;
        IMbgParams iMbgParams = MbgParamsFactory.getLocalInstance(ctx);
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery(conn, sql.toString(), new Object[]{orgType});
            while (rst.next()) {
                mbgParam = new MbgParamsInfo();
                mbgParam.setId(BOSUuid.read((String)rst.getString("FID")));
                mbgParam.setNumber(rst.getString("FNumber"));
                mbgParam.setName(rst.getString("FName"));
                mbgParam.setAlias(rst.getString("FAlias"));
                mbgParam.setType(ParamDataType.getEnum((int)rst.getInt("FType")));
                mbgParam.setOrgType(OrgType.getEnum((int)rst.getInt("FOrgType")));
                mbgParam.setDefaultValue(rst.getString("FDefaultValue"));
                mbgParam.setCanModified(rst.getBoolean("FCanModified"));
                mbgParamMap.put(rst.getString("FID"), mbgParam);
                colls.add(mbgParam);
            }
            SQLUtils.cleanup((ResultSet)rst);
            rst = BgDBUtils.executeQuery(conn, "select FID, FMbgParamId, FCtrlSubOrg, FMbgParamValue from T_MBG_MbgParamsValue where FOrgUnitId = ? and FMbgParamId IN (select FID from T_MBG_MbgParams where FOrgType = ?)", new Object[]{orgUnitId.toString(), orgType});
            while (rst.next()) {
                if (!mbgParamMap.containsKey(rst.getString("FMbgParamId"))) continue;
                mbgParam = (MbgParamsInfo)mbgParamMap.get(rst.getString("FMbgParamId"));
                mbgParam.setParamValueId(rst.getString("FID"));
                mbgParam.setCtrlSubOrg(rst.getBoolean("FCtrlSubOrg"));
                mbgParam.setValue(rst.getString("FMbgParamValue"));
            }
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgParam = colls.get(i);
                if (!"MBG_C001".equals(mbgParam.getNumber())) continue;
                mbgParam.setValue(iMbgParams.getParamValue(orgUnitId.toString(), "MBG_C001"));
                mbgParam.setCtrlSubOrg(true);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return colls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _saveParams(Context ctx, BOSUuid userId, List paramValue) throws BOSException, EASBizException {
        if (ctx == null || userId == null || paramValue == null || paramValue.isEmpty()) {
            return null;
        }
        Map<String, MbgParamsInfo> mbgParams = null;
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            mbgParams = this.queryMbgParams(ctx, conn);
            this.saveC001Params(ctx, conn, pool, userId, mbgParams, paramValue);
            this.saveOtherParams(ctx, conn, pool, userId, mbgParams, paramValue);
            BgDimCacheUtils.putObject(ctx, "BUDGET_MBG_PARAM_CACHE", new ConcurrentHashMap());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return paramValue;
    }

    protected Map<String, MbgParamsInfo> queryMbgParams(Context ctx, Connection conn) throws BOSException, EASBizException {
        HashMap<String, MbgParamsInfo> mbgParams = new HashMap<String, MbgParamsInfo>();
        if (conn == null) {
            return mbgParams;
        }
        MbgParamsInfo mbgParam = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select FID, FNumber from T_MBG_MbgParams");
            while (rst.next()) {
                mbgParam = new MbgParamsInfo();
                mbgParam.setId(BOSUuid.read((String)rst.getString("FID")));
                mbgParam.setNumber(rst.getString("FNumber"));
                mbgParams.put(mbgParam.getNumber(), mbgParam);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return mbgParams;
    }

    protected void saveC001Params(Context ctx, Connection conn, TempTablePool pool, BOSUuid userId, Map<String, MbgParamsInfo> mbgParams, List<MbgParamsValueInfo> params) throws BOSException, EASBizException {
        if (ctx == null || conn == null || pool == null || userId == null || params == null || params.isEmpty()) {
            return;
        }
        String tmpTable = null;
        String longNumber = null;
        String[] tmpStrs = null;
        ArrayList<MbgParamsValueInfo> filter = new ArrayList<MbgParamsValueInfo>();
        ArrayList<MbgParamsValueInfo> tmpList = new ArrayList<MbgParamsValueInfo>();
        ArrayList<String> longNums = new ArrayList<String>();
        HashMap<BOSUuid, String> orgIlMap = new HashMap<BOSUuid, String>();
        HashMap<String, BOSUuid> orgLiMap = new HashMap<String, BOSUuid>();
        HashMap<BOSUuid, MbgParamsValueInfo> paramsMap = new HashMap<BOSUuid, MbgParamsValueInfo>();
        MbgParamsValueInfo value = null;
        BOSUuid mbgC001Id = mbgParams.get("MBG_C001").getId();
        HashSet<BOSUuid> filterIds = new HashSet<BOSUuid>();
        filterIds.add(mbgC001Id);
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            value = params.get(i);
            if (!filterIds.contains(value.getMbgParamId())) continue;
            filter.add(value);
        }
        HashSet<String> orgUnits = new HashSet<String>();
        int in2 = filter.size();
        for (int i = 0; i < in2; ++i) {
            value = (MbgParamsValueInfo)filter.get(i);
            orgUnits.add(value.getOrgUnitId().toString());
            paramsMap.put(value.getOrgUnitId(), value);
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select FOrgUnitId from T_MBG_MbgParamsValue where FMbgParamId = ? and FMbgParamValue = 'true'", new Object[]{mbgC001Id.toString()});
            while (rst.next()) {
                orgUnits.add(rst.getString("FOrgUnitId"));
            }
            SQLUtils.cleanup((ResultSet)rst);
            tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            if (tmpTable != null) {
                BgDBUtils.insertKey(conn, "Insert Into " + tmpTable + " (FID) values (?)", orgUnits);
                rst = BgDBUtils.executeQuery(conn, "select FID, FLongNumber from T_ORG_CostCenter where exists (select FID from " + tmpTable + " where FID = T_ORG_CostCenter.FID)");
                while (rst.next()) {
                    orgIlMap.put(BOSUuid.read((String)rst.getString("FID")), rst.getString("FLongNumber"));
                    orgLiMap.put(rst.getString("FLongNumber"), BOSUuid.read((String)rst.getString("FID")));
                    longNums.add(rst.getString("FLongNumber"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            Collections.sort(longNums);
            boolean check = false;
            HashSet<String> filterNums = new HashSet<String>();
            HashSet<String> removeNums = new HashSet<String>();
            for (String _longNumber : longNums) {
                check = false;
                tmpStrs = _longNumber.split(BgBaseConstants.SEP_ONE_STR);
                if (tmpStrs != null) {
                    int in3 = tmpStrs.length - 1;
                    for (int i = 0; i < in3; ++i) {
                        if (!filterNums.contains(tmpStrs[i])) continue;
                        check = true;
                        break;
                    }
                }
                if (check) {
                    removeNums.add(_longNumber);
                    continue;
                }
                filterNums.add(_longNumber);
            }
            int in4 = filter.size();
            for (int i = 0; i < in4; ++i) {
                value = (MbgParamsValueInfo)filter.get(i);
                longNumber = (String)orgIlMap.get(value.getOrgUnitId());
                if (!removeNums.contains(longNumber)) continue;
                tmpList.add(value);
            }
            filter.removeAll(tmpList);
            this.saveDefaultParams(ctx, conn, pool, userId, mbgParams, filter);
            for (String _longNumber : filterNums) {
                BgDBUtils.executeUpdate(conn, "delete from T_MBG_MbgParamsValue where FMbgParamId = ? and exists (select FID from T_ORG_CostCenter where FID = T_MBG_MbgParamsValue.FOrgUnitId and FLongNumber like ?)", new Object[]{mbgC001Id.toString(), _longNumber + "!%"});
            }
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                if (tmpTable != null) {
                    pool.releaseTable(tmpTable);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (tmpTable != null) {
            pool.releaseTable(tmpTable);
        }
    }

    protected void saveOtherParams(Context ctx, Connection conn, TempTablePool pool, BOSUuid userId, Map<String, MbgParamsInfo> mbgParams, List<MbgParamsValueInfo> params) throws BOSException, EASBizException {
        if (ctx == null || conn == null || pool == null || userId == null || params == null || params.isEmpty()) {
            return;
        }
        ArrayList<MbgParamsValueInfo> filter = new ArrayList<MbgParamsValueInfo>();
        MbgParamsValueInfo value = null;
        HashSet<BOSUuid> filterIds = new HashSet<BOSUuid>();
        filterIds.add(mbgParams.get("MBG_C001").getId());
        int in = params.size();
        for (int i = 0; i < in; ++i) {
            value = params.get(i);
            if (filterIds.contains(value.getMbgParamId())) continue;
            filter.add(value);
        }
        this.saveDefaultParams(ctx, conn, pool, userId, mbgParams, filter);
    }

    protected void saveDefaultParams(Context ctx, Connection conn, TempTablePool pool, BOSUuid userId, Map<String, MbgParamsInfo> mbgParams, List<MbgParamsValueInfo> params) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        String tmpTable;
        block14: {
            if (ctx == null || conn == null || pool == null || userId == null || params == null || params.isEmpty()) {
                return;
            }
            int batchIndex = 0;
            Object[] objs = null;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            tmpTable = null;
            String _userId = userId.toString();
            ArrayList<MbgParamsValueInfo> upValues = new ArrayList<MbgParamsValueInfo>();
            ArrayList<MbgParamsValueInfo> newValus = new ArrayList<MbgParamsValueInfo>();
            MbgParamsValueInfo value = null;
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                value = params.get(i);
                if (value.getId() != null) {
                    upValues.add(value);
                    continue;
                }
                value.setId(BOSUuid.create((BOSObjectType)value.getBOSType()));
                newValus.add(value);
            }
            if (upValues.isEmpty() && newValus.isEmpty()) {
                return;
            }
            pstmt = null;
            try {
                conn = this.getConnection(ctx);
                if (!upValues.isEmpty()) {
                    pstmt = conn.prepareStatement("update T_MBG_MbgParamsValue set FLastUpdateUserID = ?, FLastUpdateTime = ?, FMbgParamValue = ?, FCtrlSubOrg = ? where FID = ?");
                    int in2 = upValues.size();
                    for (int i = 0; i < in2; ++i) {
                        value = (MbgParamsValueInfo)upValues.get(i);
                        pstmt.setString(1, _userId);
                        pstmt.setTimestamp(2, timestamp);
                        pstmt.setString(3, value.getMbgParamValue());
                        pstmt.setBoolean(4, value.isCtrlSubOrg());
                        pstmt.setString(5, value.getId().toString());
                        pstmt.addBatch();
                        if (++batchIndex < 50) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex > 0) {
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                }
                if (newValus.isEmpty() || (tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FCreatorID VARCHAR(44), FCreateTime DateTime, FLastUpdateUserID VARCHAR(44), FLastUpdateTime DateTime, FOrgUnitId VARCHAR(44), FSetOrgUnitId VARCHAR(44), FMbgParamId VARCHAR(44), FMbgParamValue VARCHAR(256), FCtrlSubOrg INT)")) == null) break block14;
                ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
                int in3 = newValus.size();
                for (int i = 0; i < in3; ++i) {
                    value = (MbgParamsValueInfo)newValus.get(i);
                    objs = new Object[]{value.getId().toString(), _userId, timestamp, _userId, timestamp, value.getOrgUnitId().toString(), value.getOrgUnitId().toString(), value.getMbgParamId().toString(), value.getMbgParamValue(), value.isCtrlSubOrg()};
                    sqlParams.add(objs);
                }
                BgDBUtils.insertValue1(conn, "Insert Into " + tmpTable + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitId, FSetOrgUnitId, FMbgParamId, FMbgParamValue, FCtrlSubOrg) values (?,?,?,?,?,?,?,?,?,?)", sqlParams);
                BgDBUtils.executeUpdate(conn, "Insert Into T_MBG_MbgParamsValue (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitId, FSetOrgUnitId, FMbgParamId, FMbgParamValue, FCtrlSubOrg) select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitId, FSetOrgUnitId, FMbgParamId, FMbgParamValue, FCtrlSubOrg from " + tmpTable);
            }
            catch (Exception ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    if (pool != null && tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        if (pool != null && tmpTable != null) {
            pool.releaseTable(tmpTable);
        }
    }
}

