/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.IMbgMember;
import com.kingdee.eas.ma.base.MbgDimException;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.app.AbstractMbgViewControllerBean;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MbgViewControllerBean
extends AbstractMbgViewControllerBean {
    private static final long serialVersionUID = 7152152587916472895L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.app.MbgViewControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("MbgDim.id", (Object)((MbgViewInfo)model).getMbgDim().getId().toString());
        return filter;
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isReferByMember = false;
        IMbgMember imember = MbgMemberFactory.getLocalInstance(ctx);
        isReferByMember = imember.exists("select id  where viewid ='" + pk.toString() + "' and issystemdefault =0 ");
        if (isReferByMember) {
            throw new MbgDimException(MbgDimException.REFERBYMEMBER);
        }
        if (this.checkIsRefByModel(ctx, pk)) {
            throw new MbgDimException(MbgDimException.REFERBYMODEL);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewid", (Object)pk.toString(), CompareType.EQUALS));
        imember.delete(filter);
        super.delete(ctx, pk);
        MbgVirtualView.getInstance(ctx).recycleVirtualView(pk);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        MbgViewInfo mbgView = (MbgViewInfo)model;
        this.checkStandby(ctx, mbgView);
        boolean isExistSysMember = false;
        isExistSysMember = MbgMemberFactory.getLocalInstance(ctx).exists("select id where viewid ='" + mbgView.getId().toString() + "' and isSystemDefault = 1");
        IObjectPK pk = super.submit(ctx, model);
        if (!isExistSysMember) {
            this.addPreSetMember(ctx, mbgView);
        }
        return pk;
    }

    protected void checkStandby(Context ctx, MbgViewInfo mbgView) throws BOSException, EASBizException {
        if (ctx == null || mbgView == null || mbgView.getId() == null || !mbgView.isStandby()) {
            return;
        }
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery(conn, "select top 1 FID from T_MBG_MbgMember where FViewId = ? and FIsSystemDefault = 0", new Object[]{mbgView.getId().toString()});
            if (rst.next()) {
                throw new MbgDimException(MbgDimException.CHECKSTANDBY);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    private void addPreSetMember(Context ctx, MbgViewInfo mbgView) throws EASBizException, BOSException {
        CoreBaseCollection addColls = new CoreBaseCollection();
        MbgDimInfo mbgDim = mbgView.getMbgDim();
        MbgMemberInfo parent = new MbgMemberInfo();
        parent = new MbgMemberInfo();
        parent.setId(BOSUuid.create((BOSObjectType)parent.getBOSType()));
        parent.setNumber(mbgDim.getNumber());
        parent.setLongNumber(mbgDim.getNumber());
        parent.setName(mbgDim.getName() + ResourceBase.getString((String)"com.kingdee.eas.ma.base.BASEAutoGenerateResource", (String)"0_MbgViewControllerBean", (Locale)ctx.getLocale()));
        parent.setLevel(1);
        parent.setIsLeaf(false);
        parent.setAggregation(BgUpperGatherEnum.add);
        parent.setViewId(mbgView.getId());
        parent.setDimId(mbgDim.getId());
        parent.setMbgDim(mbgDim);
        parent.setOrgunit(mbgView.getOrgUnit());
        parent.setCreator(mbgView.getCreator());
        parent.setCreateTime(mbgView.getCreateTime());
        parent.setLastUpdateTime(mbgView.getCreateTime());
        parent.setLastUpdateUser(mbgView.getCreator());
        parent.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        parent.setIsSystemDefault(true);
        MbgMemberInfo member = new MbgMemberInfo();
        member = new MbgMemberInfo();
        member.setId(BOSUuid.create((BOSObjectType)member.getBOSType()));
        member.setNumber(mbgDim.getNumber() + "-01");
        member.setLongNumber(parent.getLongNumber() + "!" + mbgDim.getNumber() + "-01");
        member.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.base.BASEAutoGenerateResource", (String)"1_MbgViewControllerBean", (Locale)ctx.getLocale()) + mbgDim.getName());
        member.setViewId(mbgView.getId());
        member.setDimId(mbgDim.getId());
        member.setMbgDim(mbgDim);
        member.setLevel(2);
        member.setIsLeaf(true);
        member.setAggregation(BgUpperGatherEnum.add);
        member.setParent(parent);
        member.setOrgunit(mbgView.getOrgUnit());
        member.setCreator(mbgView.getCreator());
        member.setCreateTime(mbgView.getCreateTime());
        member.setLastUpdateTime(mbgView.getCreateTime());
        member.setLastUpdateUser(mbgView.getCreator());
        member.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        member.setIsSystemDefault(true);
        addColls.add((CoreBaseInfo)parent);
        addColls.add((CoreBaseInfo)member);
        MbgMemberFactory.getLocalInstance(ctx).saveBatchData(addColls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _checkIsRefByModel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRowSet rst = null;
        Connection conn = null;
        boolean isRefByModel = false;
        StringBuffer sql = new StringBuffer("SELECT fmemberid FROM T_mbg_bgdimsettingsMember WHERE Fmemberid = '" + pk.toString() + "'");
        try {
            conn = BgDBUtils.getConnection(ctx);
            rst = BgDBUtils.executeQuery(conn, sql.toString());
            while (rst.next()) {
                isRefByModel = true;
            }
        }
        catch (SQLDataException e) {
            logger.error((Object)("sqldata error:" + (Object)((Object)e)));
        }
        catch (SQLException e) {
            logger.error((Object)("sql error:" + e));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return isRefByModel;
    }
}

