/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgBaseFacadeFactory;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgIntIdHelper {
    private static Logger logger = Logger.getLogger((String)BgIntIdHelper.class.getName());
    public static final String INT_ID_FIELD = "intID";
    public static final String VIEW_ID_ELEMENT = "T_MBG_BgElement";
    public static final String VIEW_ID_PERIOD = "T_MBG_BgPeriod";

    public static void setIntIdOnlyAddNew(Context ctx, CoreBaseInfo info, String viewId, boolean isCheckExists) throws BOSException {
        CoreBaseCollection col = new CoreBaseCollection();
        col.add(info);
        BgIntIdHelper.setIntIdOnlyAddNew(ctx, (IObjectCollection)col, viewId, isCheckExists);
    }

    public static void setIntIdOnlyAddNew(Context ctx, IObjectCollection col, String viewId, boolean isCheckExists) throws BOSException {
        if (col == null || col.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty((String)viewId)) {
            throw new BOSException("BgIntIdHelper.setIntIdOnlyAddNew viewId isNull");
        }
        BOSObjectType bosType = null;
        CoreBaseCollection addNewCol = new CoreBaseCollection();
        addNewCol.addObjectCollection(col);
        HashSet<String> ids = new HashSet<String>();
        for (int i = addNewCol.size() - 1; i >= 0; --i) {
            bosType = col.getObject(i).getBOSType();
            if (col.getObject(i).getInt(INT_ID_FIELD) > 0) {
                addNewCol.removeObject(i);
                continue;
            }
            if (col.getObject(i).getBOSUuid("id") == null) continue;
            ids.add(col.getObject(i).getBOSUuid("id").toString());
        }
        if (!ids.isEmpty() && isCheckExists) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
            CoreBaseCollection existsCol = coreBase.getCollection(evi);
            Map exitstMap = BgCommHelper.transeToMap((IObjectCollection)existsCol);
            for (int i = addNewCol.size() - 1; i >= 0; --i) {
                if (!exitstMap.containsKey(addNewCol.getObject(i).getBOSUuid("id").toString())) continue;
                addNewCol.removeObject(i);
            }
        }
        if (addNewCol.isEmpty()) {
            return;
        }
        int maxId = BgBaseFacadeFactory.getLocalInstance(ctx).lockAndUpdateMaxInt(viewId, addNewCol.size());
        logger.info((Object)("lockAndUpdateMaxInt " + maxId + " view id " + viewId));
        for (int i = 0; i < addNewCol.size(); ++i) {
            addNewCol.getObject(i).setInt(INT_ID_FIELD, maxId + i + 1);
        }
    }

    public static void deleteView(Context ctx, String viewId) throws BOSException {
        logger.info((Object)("delete view id " + viewId));
        BgBaseFacadeFactory.getLocalInstance(ctx).deleteView(viewId);
    }
}

