/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgParmCodingRule;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class BgCodeNumberNHelper {
    private static final Logger logger = Logger.getLogger(BgCodeNumberNHelper.class);

    public static boolean hasCodeNumber(Context ctx, IObjectValue model, String orgUnitId) {
        if (ctx == null || model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist(model, orgUnitId);
        }
        catch (Exception e) {
            logger.error((Object)"Code Number Error:", (Throwable)e);
        }
        return result;
    }

    public static boolean hasCodeNumber(Context ctx, IObjectValue model, String orgUnitId, String property) {
        return BgCodeNumberNHelper.hasCodeNumber(ctx, model, orgUnitId, property, null);
    }

    public static boolean hasCodeNumber(Context ctx, IObjectValue model, String orgUnitId, String property, String fieldName) {
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberNHelper.hasCodeNumber(ctx, model, orgUnitId);
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist(model, orgUnitId, property, (ParmCodingRule)BgCodeNumberNHelper.getParmCodingRule(fieldName));
        }
        catch (Exception ex) {
            logger.error((Object)"Code Number Error:", (Throwable)ex);
        }
        return result;
    }

    public static boolean hasDisplayNumber(Context ctx, IObjectValue model, String orgUnitId) {
        boolean isAddView = false;
        if (ctx == null || model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId);
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Code Number Error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static boolean hasDisplayNumber(Context ctx, IObjectValue model, String orgUnitId, String property) {
        return BgCodeNumberNHelper.hasDisplayNumber(ctx, model, orgUnitId, property, null);
    }

    public static boolean hasDisplayNumber(Context ctx, IObjectValue model, String orgUnitId, String property, String fieldName) {
        boolean isAddView = false;
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberNHelper.hasCodeNumber(ctx, model, orgUnitId);
        }
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId, property, (ParmCodingRule)BgCodeNumberNHelper.getParmCodingRule(fieldName));
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Code Number Error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static void applyNumber(Context ctx, IObjectValue model, String orgUnitId, String property) throws EASBizException {
        BgCodeNumberNHelper.applyNumber(ctx, model, orgUnitId, property, null);
    }

    public static void applyNumber(Context ctx, IObjectValue model, String orgUnitId, String property, String fieldName) throws EASBizException {
        BgCodeNumberNHelper.applyNumber(ctx, model, orgUnitId, property, fieldName, true);
    }

    public static void applyNumber(Context ctx, IObjectValue model, String orgUnitId, String property, String fieldName, boolean isSetDefault) throws EASBizException {
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = "number";
        }
        if (!StringUtils.isEmpty((String)model.getString(fieldName))) {
            return;
        }
        if (StringUtils.isEmpty((String)property)) {
            BgCodeNumberNHelper.applyNumber(ctx, model, orgUnitId, isSetDefault);
        } else {
            if (ctx == null || model == null) {
                return;
            }
            String customString = null;
            boolean hasProperty = false;
            String number = model.getString(fieldName);
            ICodingRuleManager codingRuleManager = null;
            BgParmCodingRule pcr = BgCodeNumberNHelper.getParmCodingRule(fieldName);
            try {
                codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                boolean hasCode = false;
                if (codingRuleManager.isExist(model, orgUnitId, property, (ParmCodingRule)pcr)) {
                    hasProperty = true;
                    hasCode = true;
                } else {
                    hasCode = codingRuleManager.isExist(model, orgUnitId);
                }
                if (!hasProperty) {
                    BgCodeNumberNHelper.applyNumber(ctx, model, orgUnitId, isSetDefault);
                } else {
                    if (hasCode) {
                        number = codingRuleManager.getNumber(model, orgUnitId, property, customString, (ParmCodingRule)pcr);
                    }
                    if (isSetDefault && StringUtils.isEmpty((String)number)) {
                        number = "Bg-" + System.currentTimeMillis();
                    }
                    if (!StringUtils.isEmpty((String)number)) {
                        model.setString(fieldName, number);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Code Number Error:", (Throwable)ex);
                throw new BgException(BgException.NUMBERMANAGERERROR);
            }
        }
    }

    private static BgParmCodingRule getParmCodingRule(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName) || "number".equals(fieldName)) {
            return null;
        }
        BgParmCodingRule pcr = new BgParmCodingRule();
        pcr.setCustomProperty(fieldName);
        return pcr;
    }

    public static void applyNumber(Context ctx, IObjectValue model, String orgUnitId) throws EASBizException {
        BgCodeNumberNHelper.applyNumber(ctx, model, orgUnitId, true);
    }

    public static void applyNumber(Context ctx, IObjectValue model, String orgUnitId, boolean isSetDefault) throws EASBizException {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        if (!StringUtils.isEmpty((String)model.getString("number"))) {
            return;
        }
        boolean hasCode = true;
        boolean hasAddNewShow = false;
        String number = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = ctx != null ? CodingRuleManagerFactory.getLocalInstance((Context)ctx) : CodingRuleManagerFactory.getRemoteInstance();
            hasCode = codingRuleManager.isExist(model, orgUnitId);
            if (hasCode) {
                hasAddNewShow = codingRuleManager.isAddView(model, orgUnitId);
            }
            if (hasCode) {
                if (codingRuleManager.isUseIntermitNumber(model, orgUnitId)) {
                    number = codingRuleManager.getNonbreakNumber(model, orgUnitId);
                } else {
                    number = codingRuleManager.getNumber(model, orgUnitId);
                    if (isSetDefault && StringUtils.isEmpty((String)number)) {
                        number = "Bg-" + System.currentTimeMillis();
                    }
                }
            } else {
                number = model.getString("number");
                if (isSetDefault && StringUtils.isEmpty((String)number)) {
                    number = "Bg-" + System.currentTimeMillis();
                }
            }
            if (!StringUtils.isEmpty((String)number)) {
                model.setString("number", number);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Code Number Error:", (Throwable)ex);
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static void recycleNumber(Context ctx, IObjectValue model, String orgUnitId, String number) throws EASBizException {
        if (ctx == null || model == null || StringUtils.isEmpty((String)number)) {
            return;
        }
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist(model, orgUnitId) && codingRuleManager.isUseIntermitNumber(model, orgUnitId)) {
                codingRuleManager.recycleNumber(model, orgUnitId, number);
            }
        }
        catch (Exception ex) {
            throw new BgException(BgException.NUMBERMANAGERERROR);
        }
    }

    public static void recycleNumber(Context ctx, IObjectValue model, String orgUnitId, String number, String property) throws EASBizException {
        if (StringUtils.isEmpty((String)property)) {
            BgCodeNumberNHelper.recycleNumber(ctx, model, orgUnitId, number);
        } else {
            if (ctx == null || model == null || StringUtils.isEmpty((String)number)) {
                return;
            }
            ICodingRuleManager codingRuleManager = null;
            try {
                codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                boolean hasCode = codingRuleManager.isExist(model, orgUnitId, property);
                if (hasCode) {
                    if (codingRuleManager.isUseIntermitNumber(model, orgUnitId, property)) {
                        codingRuleManager.recycleNumber(model, orgUnitId, property, null, number);
                    }
                } else {
                    BgCodeNumberNHelper.recycleNumber(ctx, model, orgUnitId, number);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Code Number Error:", (Throwable)ex);
                throw new BgException(BgException.NUMBERMANAGERERROR);
            }
        }
    }
}

