/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgLocaleHelper {
    private static final Logger logger = Logger.getLogger(BgLocaleHelper.class);
    public static final Locale[] locales;

    public static String getCurrentLocale() {
        String localeString = LocaleUtils.getDefaultLocale().getLanguage();
        if ("l2".equals(localeString) || "L2".equals(localeString)) {
            return "zh_CN";
        }
        if ("zh_CN".equals(localeString) || "CH".equals(localeString)) {
            return "l2";
        }
        return LocaleUtils.getMappingLocals((String)LocaleUtils.getDefaultLocale().getLanguage());
    }

    public static void copyMultiLangField(IObjectValue target, IObjectValue source, String sourceProp, String targetProp) {
        if (target != null && source != null && sourceProp != null && targetProp != null) {
            for (int i = 0; i < locales.length; ++i) {
                Locale l = locales[i];
                Object value = BgLocaleHelper.get(source, sourceProp, l);
                if (value == null) continue;
                target.put(targetProp, value, l);
            }
            if (target.get(targetProp, LocaleUtils.locale_l1) == null) {
                if (target.get(targetProp, LocaleUtils.locale_l2) != null) {
                    target.put(targetProp, target.get(targetProp, LocaleUtils.locale_l2), LocaleUtils.locale_l1);
                } else if (target.get(targetProp, LocaleUtils.locale_l3) != null) {
                    target.put(targetProp, target.get(targetProp, LocaleUtils.locale_l3), LocaleUtils.locale_l1);
                }
            }
            if (target.get(targetProp, LocaleUtils.locale_l2) == null) {
                if (target.get(targetProp, LocaleUtils.locale_l3) != null) {
                    target.put(targetProp, (Object)STConverter.tc2sc((String)String.valueOf(target.get(targetProp, LocaleUtils.locale_l2))), LocaleUtils.locale_l2);
                } else if (target.get(targetProp, LocaleUtils.locale_l1) != null) {
                    target.put(targetProp, target.get(targetProp, LocaleUtils.locale_l1), LocaleUtils.locale_l2);
                }
            }
            if (target.get(targetProp, LocaleUtils.locale_l3) == null) {
                if (target.get(targetProp, LocaleUtils.locale_l2) != null) {
                    target.put(targetProp, (Object)STConverter.sc2tc((String)String.valueOf(target.get(targetProp, LocaleUtils.locale_l2))), LocaleUtils.locale_l3);
                } else if (target.get(targetProp, LocaleUtils.locale_l1) != null) {
                    target.put(targetProp, target.get(targetProp, LocaleUtils.locale_l1), LocaleUtils.locale_l3);
                }
            }
        }
    }

    public static Object get(IObjectValue source, String property, Locale locale) {
        if (source != null && property != null && locale != null) {
            if (source instanceof PropertyInfo) {
                Locale l = BgLocaleHelper.convertLocale(locale);
                if (l != null) {
                    return source.get(property, l);
                }
            } else {
                return source.get(property, locale);
            }
        }
        return null;
    }

    public static Locale convertLocale(Locale shortLocale) {
        List locales = LocaleUtils.getLocaleByShortCode((String)LocaleUtils.getShortCode((Locale)shortLocale));
        if (locales != null && !locales.isEmpty()) {
            return (Locale)locales.get(0);
        }
        return null;
    }

    static {
        HashMap<String, Locale> list = new HashMap<String, Locale>();
        Field[] field = LocaleUtils.class.getFields();
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                if (field[i].getType() != Locale.class || !field[i].getName().toLowerCase(Locale.ENGLISH).startsWith("locale_l")) continue;
                try {
                    Locale locale = (Locale)field[i].get(null);
                    list.put(locale.getDisplayName(), locale);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        locales = new Locale[list.size()];
        int index = 0;
        Iterator it = list.values().iterator();
        while (it.hasNext()) {
            BgLocaleHelper.locales[index++] = (Locale)it.next();
        }
    }
}

