/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.cache.CacheEngine;
import com.kingdee.bos.cache.CacheObject;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.cache.DefaultObjectMonitor;
import com.kingdee.bos.cache.ObjectAttributes;
import com.kingdee.bos.cache.ObjectMonitor;
import com.kingdee.bos.cache.RegionAttributes;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BudgetCache {
    private String BUDGET_CACHE_NAME = "BudgetAppDataCache";
    private int CACHE_TIME_OUT = 1800000;
    private Lock lock = new ReentrantLock();
    private CacheRegion region = null;
    private static final BudgetCache instance = new BudgetCache();

    public BudgetCache() {
        this.initCacheRegin();
    }

    public BudgetCache(String bgCacheName) {
        if (bgCacheName != null) {
            this.setCacheName(bgCacheName);
        }
        this.initCacheRegin();
    }

    private void initCacheRegin() {
        CacheRegion rootRegion = CacheEngine.getLocalRootRegion();
        RegionAttributes regionAttrs = new RegionAttributes();
        regionAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        ObjectAttributes objAttrs = new ObjectAttributes();
        objAttrs.setLong(6, (long)this.getCacheOutTime());
        objAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        this.region = rootRegion.createSubRegion((Object)this.getCacheName(), regionAttrs, objAttrs);
    }

    public static BudgetCache getInstance() {
        return instance;
    }

    public void setCacheName(String cacheName) {
        this.BUDGET_CACHE_NAME = cacheName;
    }

    public String getCacheName() {
        return this.BUDGET_CACHE_NAME;
    }

    public void setCacheOutTime(int outTime) {
        this.CACHE_TIME_OUT = outTime;
    }

    public int getCacheOutTime() {
        return this.CACHE_TIME_OUT;
    }

    private Lock getLock() {
        return this.lock;
    }

    private CacheRegion getRegion() {
        return this.region;
    }

    private ObjectAttributes getDefaultObjectAttributes() {
        ObjectAttributes regionAttrs = new ObjectAttributes();
        regionAttrs.setLong(6, (long)this.getCacheOutTime());
        regionAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        return regionAttrs;
    }

    public boolean exists(Object name) {
        return this.getRegion().exists(name);
    }

    public void putObject(Object name, Object value) {
        if (name == null) {
            return;
        }
        this.getLock().lock();
        try {
            if (this.getRegion().exists(name)) {
                this.destroyObject(name);
            }
            this.getRegion().putObject(name, value, this.getDefaultObjectAttributes());
        }
        finally {
            this.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object name) {
        if (name == null) {
            return null;
        }
        Object cacheValue = null;
        CacheObject cacheObject = null;
        this.getLock().lock();
        try {
            cacheObject = this.getRegion().getObject(name);
            if (cacheObject != null && cacheObject.isAvailable()) {
                cacheValue = cacheObject.get();
            }
        }
        finally {
            this.releaseCacheObject(cacheObject);
            this.getLock().unlock();
        }
        return cacheValue;
    }

    public void destroyObject(Object name) {
        if (name == null) {
            return;
        }
        CacheObject cacheObject = null;
        this.getLock().lock();
        try {
            cacheObject = this.getRegion().getObject(name);
            if (cacheObject != null) {
                cacheObject.destroy();
            }
        }
        finally {
            this.releaseCacheObject(cacheObject);
            this.getLock().unlock();
        }
    }

    private void releaseCacheObject(CacheObject cacheObject) {
        if (cacheObject != null) {
            cacheObject.release();
        }
    }
}

