/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.MbgExchangeRateInfo;
import com.kingdee.eas.ma.base.MbgExchangeRatePeriodTypeEnum;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MbgExchangeRateUtils {
    public static final String ZDY = "ZDY";
    public static final String RES = "com.kingdee.eas.ma.base.MbgExchangeRateResource";
    public static Set<Integer> unSelfPeriodYearsType = new HashSet<Integer>();
    public static Set<Integer> selfPeriodYearsType = new HashSet<Integer>();

    public static List<String> getPeriodYears(MbgExchangeRatePeriodTypeEnum type) throws BOSException {
        if (MbgExchangeRatePeriodTypeEnum.unSelfDefined.equals((Object)type)) {
            return MbgExchangeRateUtils.getUnSelfPeriodYears();
        }
        return MbgExchangeRateUtils.getSelfPeriodYears();
    }

    public static List<String> getUnSelfPeriodYears() throws BOSException {
        ArrayList<String> years = new ArrayList<String>();
        BgPeriodCollection colls = MbgExchangeRateUtils.queryPeriods(false);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                if (years.contains(colls.get(i).getYear())) continue;
                years.add(String.valueOf(colls.get(i).getYear()));
            }
        }
        return years;
    }

    public static List<String> getSelfPeriodYears() throws BOSException {
        ArrayList<String> years = new ArrayList<String>();
        years.add(ZDY);
        return years;
    }

    private static BgPeriodCollection queryPeriods(Boolean isSelf) throws BOSException {
        CalendarHelper calendarHelper = new CalendarHelper();
        int currentlyYear = calendarHelper.getCurrentlyYear();
        IBgPeriod iBgPeriod = BgPeriodFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        if (isSelf.booleanValue()) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("periodType", selfPeriodYearsType, CompareType.INCLUDE));
        } else {
            view.getFilter().getFilterItems().add(new FilterItemInfo("periodType", unSelfPeriodYearsType, CompareType.INCLUDE));
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)currentlyYear, CompareType.GREATER_EQUALS));
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("id");
        view.getSelector().add("year");
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("year"));
        return iBgPeriod.getBgPeriodCollection(view);
    }

    public static void sortMap(Map<String, MbgExchangeRateInfo> rateMap) {
        if (rateMap == null) {
            return;
        }
        Collections.sort(new ArrayList<String>(rateMap.keySet()), new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
    }

    public static SelectorItemCollection getRateSchemeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("targeCurrency.id"));
        sic.add(new SelectorItemInfo("targeCurrency.number"));
        sic.add(new SelectorItemInfo("targeCurrency.name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        return sic;
    }

    static {
        Collections.addAll(unSelfPeriodYearsType, 1, 2, 3, 4, 9, 5, 6, 7);
        Collections.addAll(unSelfPeriodYearsType, 8, 16, 10, 11, 12, 13, 14, 15, 17);
    }
}

