/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.eas.ma.base.MbgDimException;
import com.kingdee.eas.ma.base.utils.Tree;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TreeNode {
    private Tree tree;
    private TreeNode parent;
    private String parentNumber;
    private String memberNumber;
    private String level;
    private Map extProperties;
    private boolean isFailed = false;
    private boolean isEnable = false;
    private int rowIndex = 0;
    private boolean isLeaf = false;
    private Set<TreeNode> childs = new HashSet<TreeNode>();
    public static final String ALL_RIGHT = "ALL-RIGHT";

    public TreeNode(String parentNumber, String memberNumber, Map extProperties, Tree tree) throws MbgDimException {
        if (StringUtils.isEmpty((String)memberNumber)) {
            throw new MbgDimException(MbgDimException.MEMBERNOTNULL);
        }
        this.parentNumber = parentNumber;
        this.memberNumber = memberNumber;
        this.extProperties = extProperties;
        if (tree == null) {
            throw new MbgDimException(MbgDimException.TREEISNULL);
        }
        this.tree = tree;
        tree.addNode(this);
    }

    public void setChilds(Set<TreeNode> childs) {
        this.childs = childs;
    }

    public Set<TreeNode> getChilds() {
        return this.childs;
    }

    public boolean isLeaf() {
        return this.childs.isEmpty();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public String getParentNumber() {
        return this.parentNumber;
    }

    public void setParentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    public boolean isFailed() {
        return this.isFailed;
    }

    public void setFailed(boolean isFailed) {
        this.isFailed = isFailed;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public String getLevel() {
        if (this.parent == null) {
            return "1";
        }
        String parentlevel = this.parent.getLevel();
        Integer levelNum = Integer.valueOf(parentlevel) + Integer.valueOf("1");
        return levelNum.toString();
    }

    public Map getExtProperties() {
        return this.extProperties;
    }

    public void setExtProperties(Map extProperties) {
        this.extProperties = extProperties;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public String getMemberNumber() {
        return this.memberNumber;
    }

    public void setMemberNumber(String memberNumber) {
        this.memberNumber = memberNumber;
    }

    public String lookForFailedParent() throws MbgDimException {
        return this.recursionLookForFailureParent(this.getMemberNumber());
    }

    public String lookForDisableParent() throws MbgDimException {
        return this.recursionLookForDisableParent(this.getMemberNumber());
    }

    private String recursionLookForDisableParent(String memberNumber) throws MbgDimException {
        TreeNode node = (TreeNode)this.tree.get(memberNumber);
        if (node == null) {
            throw new MbgDimException(MbgDimException.NODEISNOTEXIST);
        }
        if (!(node.isEnable() || node.getExtProperties().containsKey("isEnable") && Boolean.FALSE.equals(node.getExtProperties().get("isEnable")))) {
            return node.getMemberNumber();
        }
        if (node.getParent() == null || node.getMemberNumber().equals(node.getParent().getMemberNumber())) {
            return ALL_RIGHT;
        }
        return this.recursionLookForDisableParent(node.getParent().getMemberNumber());
    }

    private String recursionLookForFailureParent(String memberNumber) throws MbgDimException {
        TreeNode node = (TreeNode)this.tree.get(memberNumber);
        if (node == null) {
            throw new MbgDimException(MbgDimException.NODEISNOTEXIST);
        }
        if (node.isFailed() && !node.getMemberNumber().equals(memberNumber) && node.isLeaf()) {
            return node.getMemberNumber();
        }
        if (node.getParent() == null || node.getMemberNumber().equals(node.getParent().getMemberNumber())) {
            return ALL_RIGHT;
        }
        return this.recursionLookForFailureParent(node.getParent().getMemberNumber());
    }

    private String getRootMemberNumber(String memberNumber) throws MbgDimException {
        TreeNode node = (TreeNode)this.tree.get(memberNumber);
        if (node == null) {
            throw new MbgDimException(MbgDimException.NODEISNOTEXIST);
        }
        if (node.getParent() == null) {
            return node.getMemberNumber();
        }
        return this.getRootMemberNumber(node.getParent().getMemberNumber());
    }
}

