/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.check.ReportCheck;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslException;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslAdjFormControllerBean;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslAdjRptReportPropertyAdapter;
import com.kingdee.eas.ma.bgcsl.utils.BgCslBackSaveCaller;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionAdjDataUtils;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionDataUtils;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgClosureMapUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.impl.CubeManager;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslAdjFormControllerBean
extends AbstractBgCslAdjFormControllerBean {
    private static final long serialVersionUID = 8283039277278171122L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslAdjFormControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslAdjFormInfo _bgFormInfo = (BgCslAdjFormInfo)model;
        Map<String, String> specialMember = this.getSpecialMember(_bgFormInfo);
        if (specialMember != null) {
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, _bgFormInfo.getBgScheme().getId().toString());
            HashSet<String> orgIds = new HashSet<String>();
            orgIds.add(_bgFormInfo.getCU().getId().toString());
            Map<String, Set<String>> existsSpecialMember = this.getExistsSpecialMember(ctx, specialMember, orgIds, schemeHelper, _bgFormInfo);
            String checkSpecial = this.checkSpecialNoExists(_bgFormInfo, specialMember, existsSpecialMember);
            if (checkSpecial != null) {
                String specialDimName = _bgFormInfo.getBgSpecialItems() != null && !_bgFormInfo.getBgSpecialItems().isEmpty() ? _bgFormInfo.getBgSpecialItems().get(0).getMemberDisplayName() : null;
                throw new BgCslException(BgCslException.CHECKMEMBEREXISTS, new Object[]{specialDimName});
            }
        }
        this.checkNumberDup(ctx, _bgFormInfo);
        this.checkCFSAdjustCube(ctx, _bgFormInfo.getBgScheme());
        return super._submit(ctx, model);
    }

    private String checkSpecialNoExists(BgCslAdjFormInfo bgFormInfo, Map<String, String> specialMember, Map<String, Set<String>> existsSpecialMember) {
        if (bgFormInfo != null && bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty() && specialMember != null && !specialMember.isEmpty()) {
            for (String combin : specialMember.keySet()) {
                String display = specialMember.get(combin) + "(" + DimensionFormulaHelper.getMemberNumber((String)combin) + ")";
                if (existsSpecialMember == null || existsSpecialMember.isEmpty()) {
                    return display;
                }
                Set<String> subSet = existsSpecialMember.get(bgFormInfo.getCU().getId().toString());
                if (subSet != null && !subSet.isEmpty() && subSet.contains(combin)) continue;
                return display;
            }
        }
        return null;
    }

    private Map<String, String> getSpecialMember(BgCslAdjFormInfo baseInfo) {
        if (baseInfo.getBgSpecialItems() == null || baseInfo.getBgSpecialItems().isEmpty()) {
            return null;
        }
        String[] specialNumbes = baseInfo.getBgSpecialItems().get(0).getDimensionNumber().split(DimensionConstants.COMMA_SEPARATOR);
        String[] dimNames = baseInfo.getBgSpecialItems().get(0).getMemberName().split(DimensionConstants.TICK_SEPARATOR);
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < specialNumbes.length; ++i) {
            result.put(specialNumbes[i], dimNames[i]);
        }
        return result;
    }

    private Map<String, Set<String>> getExistsSpecialMember(Context ctx, Map<String, String> specialMember, Set<String> orgIds, BgSchemeDimensionHelper schemeHelper, BgCslAdjFormInfo _bgFormInfo) throws EASBizException, BOSException {
        if (specialMember == null || specialMember.isEmpty()) {
            return null;
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        IDimensionFormulaFacade facade = DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx);
        HashSet<String> numbers = new HashSet<String>();
        for (String combin : specialMember.keySet()) {
            String srcNumber = DimensionFormulaHelper.getSrcNumber((String)combin);
            String number = DimensionFormulaHelper.getMemberNumber((String)combin);
            String dimNumber = ((BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(srcNumber)).getNumber();
            numbers.clear();
            numbers.add(number);
            for (String orgId : orgIds) {
                Map _map;
                if (!result.containsKey(orgId)) {
                    result.put(orgId, new HashSet());
                }
                if ((_map = facade.queryMembers(orgId, schemeHelper, dimNumber, numbers, false, null)) == null || _map.isEmpty()) continue;
                ((Set)result.get(orgId)).add(combin);
            }
        }
        return result;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslAdjFormInfo _bgFormInfo = (BgCslAdjFormInfo)model;
        this.checkNumberDup(ctx, _bgFormInfo);
        this.checkCFSAdjustCube(ctx, _bgFormInfo.getBgScheme());
        return super._save(ctx, model);
    }

    private void checkNumberDup(Context ctx, BgCslAdjFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo == null || ctx == null) {
            return;
        }
        String id = "000000000000000000000000000=";
        if (bgFormInfo.getId() != null) {
            id = bgFormInfo.getId().toString();
        }
        if (this._exists(ctx, "where bgScheme.id = '" + bgFormInfo.getBgScheme().getId() + "' and orgUnit.id = '" + bgFormInfo.getOrgUnit().getId() + "' and number = '" + bgFormInfo.getNumber() + "' and id <> '" + id + "'")) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{bgFormInfo.getNumber()});
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslAdjFormInfo _bgFormInfo = (BgCslAdjFormInfo)model;
        this.checkBgPeriodIsAcross(ctx, _bgFormInfo);
        BgCodeNumberHelper numberCodeHelper = new BgCodeNumberHelper(ctx, null, "sourceType");
        BgCodeNumberHelper nameCodeHelper = new BgCodeNumberHelper(ctx, "name", "sourceType");
        String oldNumber = _bgFormInfo.getNumber();
        numberCodeHelper.init((IObjectValue)_bgFormInfo, _bgFormInfo.getOrgUnit().getId().toString());
        numberCodeHelper.applyNumber((IObjectValue)_bgFormInfo, _bgFormInfo.getOrgUnit().getId().toString(), null, true);
        if (StringUtils.isEmpty((String)_bgFormInfo.getNumber()) && !StringUtils.isEmpty((String)oldNumber)) {
            _bgFormInfo.setNumber(oldNumber);
        }
        String oldName = _bgFormInfo.getName();
        nameCodeHelper.init((IObjectValue)_bgFormInfo, _bgFormInfo.getOrgUnit().getId().toString());
        nameCodeHelper.applyNumber((IObjectValue)_bgFormInfo, _bgFormInfo.getOrgUnit().getId().toString(), null, true);
        if (StringUtils.isEmpty((String)_bgFormInfo.getName()) && !StringUtils.isEmpty((String)oldName)) {
            _bgFormInfo.setName(oldName);
        }
        this.checkNumberDup(ctx, _bgFormInfo);
        if (StringUtils.isEmpty((String)_bgFormInfo.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
        IObjectPK pk = super._addnew(ctx, model);
        AttachmentServerManager attachmentServerManager = AttachmentManagerFactory.getServerManager((Context)ctx);
        attachmentServerManager.copyBizAttachmentFiles(_bgFormInfo.getBgCslTemplate().getId().toString(), _bgFormInfo.getId().toString());
        return pk;
    }

    private void checkBgPeriodIsAcross(Context ctx, BgCslAdjFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo == null || bgFormInfo.getBgScheme() == null) {
            return;
        }
        try {
            String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
            BgSchemeDimensionHelper schemehHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            IMbgViewManager viewManager = BgCslFormHelper.getFormView(ctx, bgFormInfo, schemehHelper);
            MbgViewListFormServerHelper.checkBgPeriodIsAcross((Context)ctx, (String)bgSchemeId, (IMbgViewBase)viewManager, (IDimDataQuery)bgFormInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgCslAdjFormInfo _bgFormInfo = (BgCslAdjFormInfo)model;
        try {
            this.getBudgetSheet(ctx, _bgFormInfo);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        BgViewServerHelper.removeStateLock((ReportBaseInfo)_bgFormInfo);
        super._update(ctx, pk, model);
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        BgCslAdjFormInfo info = null;
        try {
            info = (BgCslAdjFormInfo)this._getValue(ctx, "select state where id = '" + pk + "'");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
        if (info != null && info.getState().getValue() != 1) {
            throw new CanNotDeleteException(ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjFormResource", (String)"canntDeleteState", (Locale)ctx.getLocale()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        Object imsc = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            List<BgCslAdjFormInfo> bgCslForms = MbgCslDataHelper.getBgCslAdjFormInfo(ctx, conn, ids);
            if (bgCslForms != null) {
                for (BgCslAdjFormInfo bgCslForm : bgCslForms) {
                    BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)bgCslForm, (String)bgCslForm.getOrgUnit().getId().toString(), (String)bgCslForm.getNumber());
                }
            }
            this.deleteOtherData(ctx, conn, ids, bgCslForms);
        }
        catch (SQLException e) {
            logger.error((Object)"sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            if (imsc != null) {
                imsc.releaseObjIDForUpdate(pk.toString());
            }
        }
        super._delete(ctx, pk);
    }

    private void deleteOtherData(Context ctx, Connection conn, List<String> ids, List<BgCslAdjFormInfo> bgCslForms) throws SQLException, BOSException, EASBizException {
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_RPT_RptSheetPara where FReportID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_RPT_RptPostil where FReportID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgCurrency where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgElement where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgScenario where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgPeriod where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgItemCombin where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_BgCslAdjFormMeasureUnit where FBgCslFormId = ?", ids);
        this.clearBgData(ctx, conn, ids);
        BgFacadeHelper.deleteRef((Context)ctx, ids);
        for (BgCslAdjFormInfo info : bgCslForms) {
            MbgViewListDescriptionHelper.clearBgCommentRef((Connection)conn, (IDimDataQuery)info);
        }
    }

    private void clearBgData(Context ctx, Connection conn, List<String> ids) throws BOSException {
        final HashMap cube_ids = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("Select bgForm.FID, bgScheme.FRefCube FROM T_MBg_BgCslAdjForm bgForm LEFT JOIN T_MBg_BgScheme bgScheme ON bgForm.FBgSchemeId = bgScheme.FID Where bgForm.FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])ids.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String cubeName = res.getString("FRefCube");
                String id = res.getString("FID");
                if (!cube_ids.containsKey(cubeName)) {
                    cube_ids.put(cubeName, new ArrayList());
                }
                ((List)cube_ids.get(cubeName)).add(id);
            }
        });
        String cubeName2 = null;
        String cslCubeName = null;
        String cslEntryCubeName = null;
        String cslCacheName = null;
        String cslECacheName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTable = null;
        try {
            tempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FDataID VARCHAR(44), FFormID VARCHAR(44))");
            if (tempTable == null) {
                return;
            }
            for (String cubeName2 : cube_ids.keySet()) {
                ids = (List)cube_ids.get(cubeName2);
                cslCubeName = BgCubeUtils.getCFSAdjustCubeName((String)cubeName2);
                cslEntryCubeName = BgCubeUtils.getCFSAdjustEntryCubeName((String)cubeName2);
                MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempTable));
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempTable + " (FDataID, FFormId) Select FDataID, FFormId from " + cslEntryCubeName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.executeBatch((Connection)conn, (String)("delete " + cslEntryCubeName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + tempTable + " where exists (select FDataID from " + cslEntryCubeName + " where FDataID = " + tempTable + ".FDataID)"));
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + cslCubeName + " where FID IN (select FDataID from " + tempTable + ") and (FState = " + 1 + " OR FState = " + 3 + ")"));
                if (BgDBUtils.existTable((Connection)conn, cslCacheName) != BgDBUtils.YES || BgDBUtils.existTable((Connection)conn, cslECacheName) != BgDBUtils.YES) continue;
                MbgSqlHelper.execute((Connection)conn, (String)("TRUNCATE TABLE " + tempTable));
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempTable + " (FDataID) Select FDataID from " + cslECacheName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.executeBatch((Connection)conn, (String)("delete " + cslECacheName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + tempTable + " where exists (select FDataID from " + cslECacheName + " where FDataID = " + tempTable + ".FDataID)"));
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + cslCacheName + " where FID IN (select FDataID from " + tempTable + ")"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTable != null) {
                try {
                    pool.releaseTable(tempTable);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void checkCFSAdjustCube(Context ctx, BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        if (bgSchemeInfo.getRefCube() == null) {
            bgSchemeInfo = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BgSchemeInfo)bgSchemeInfo);
        }
        if (BgDBUtils.existTable((Context)ctx, (String)BgCubeUtils.getCFSAdjustCubeName((String)bgSchemeInfo.getRefCube())) == BgDBUtils.YES) {
            return;
        }
        if (bgSchemeInfo.getBgDimSettings().isEmpty()) {
            bgSchemeInfo = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BgSchemeInfo)bgSchemeInfo);
        }
        try {
            CubeManager.getInstance().getCubeFacade().updateCFSCube(ctx, bgSchemeInfo.getRefCube(), bgSchemeInfo);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void getBudgetSheet(final Context ctx, final BgCslAdjFormInfo _bgFormInfo) throws Exception {
        Book book = _bgFormInfo.getBook();
        if (book == null) {
            return;
        }
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        _endTime = _startTime;
        logger.info((Object)"invoke begin save bgData!");
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        HashMap<String, Map<String, IBgNData>> indvDatas = new HashMap<String, Map<String, IBgNData>>();
        final HashMap<String, BgNViewDataInfo> subDatas = new HashMap<String, BgNViewDataInfo>();
        indvDatas.put(_bgFormInfo.getOrgUnit().getId().toString(), subDatas);
        Sheet _sheet = null;
        Cell _cell = null;
        BigDecimal budgetValue = null;
        String formulaStr = null;
        BgNViewDataInfo data = null;
        HashSet oldFormulas = new HashSet();
        if (_bgFormInfo.getId() != null) {
            BgCslAdjFormCollection col = this.getBgCslAdjFormCollection(ctx, "select data where id = '" + _bgFormInfo.getId() + "'");
            List formulaList = null;
            if (col != null && !col.isEmpty() && col.get(0).getZipData() != null) {
                formulaList = BgNFSHelper.getFormulaListOfBook((Book)col.get(0).getBook());
            }
            if (formulaList != null) {
                oldFormulas.addAll(formulaList);
            }
        }
        for (int s = 0; s < book.getSheetCount(); ++s) {
            _sheet = book.getSheet(s);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    oldFormulas.remove(formulaStr);
                    try {
                        budgetValue = (BigDecimal)BgNFSHelper.getValue((Cell)_cell);
                    }
                    catch (Exception ex) {
                        budgetValue = BgNConstants.ZERO;
                    }
                    data = subDatas.containsKey(formulaStr) ? (BgNViewDataInfo)subDatas.get(formulaStr) : this.addBaseValue(ctx, _cell, formulaStr, _bgFormInfo.getBgVersion().getNumber(), budgetValue);
                    if (!BgNFSHelper.checkUpdataValueByTime((Cell)_cell, (BgNDataInfo)data).booleanValue()) continue;
                    data.setBudgetValue(budgetValue);
                    subDatas.put(formulaStr, data);
                }
            }
        }
        if (!oldFormulas.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            String cubeName = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeInfo("select refCube where id = '" + _bgFormInfo.getBgScheme().getId() + "'").getRefCube();
            String cubeEntry = BgCubeUtils.getCFSAdjustEntryCubeName((String)cubeName);
            cubeName = BgCubeUtils.getCFSAdjustCubeName((String)cubeName);
            sql.append("select fformula from ").append(cubeName).append(" t0 where funionId = ? and forgunitid = ? ").append("and exists(Select fdataid from ").append(cubeEntry).append(" t1 where t1.fformid = ? and t0.fid = t1.fdataid) ").append("and not exists(Select fdataid from ").append(cubeEntry).append(" t2 where t2.fformid <> ? and t0.fid = t2.fdataid) ").append("and fformula in(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{_bgFormInfo.getOrgTree().getId().toString(), _bgFormInfo.getOrgUnit().getId().toString(), _bgFormInfo.getId().toString(), _bgFormInfo.getId().toString()}, (Object[])oldFormulas.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException, BOSException {
                    String formulaStr = res.getString(1);
                    try {
                        subDatas.put(formulaStr, BgCslAdjFormControllerBean.this.addBaseValue(ctx, null, formulaStr, _bgFormInfo.getBgVersion().getNumber(), null));
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
            });
            sql.setLength(0);
            sql.append("delete from ").append(cubeEntry).append(" where fformid = ? and exists(select fid from ").append(cubeName).append(" where ").append(cubeName).append(".FID = ").append(cubeEntry).append(".FDataId and fformula = ?)");
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{_bgFormInfo.getId().toString()}, (Object[])oldFormulas.toArray(), (int)1));
        }
        UnionDataUtils.getIntance().saveIndvData(ctx, _bgFormInfo.getId(), _bgFormInfo.getBgScheme().getId(), _bgFormInfo.getOrgTree().getId(), ContextUtil.getCurrentUserInfo((Context)ctx).getId(), indvDatas, null);
        if (!subDatas.isEmpty()) {
            new MbgXMLParser(ctx);
            _bgFormInfo.setDimensionData(MbgXMLParser.unParse((IMbgViewManager)DimensionFormulaHelper.buildViewMamager((Context)ctx, subDatas.keySet(), null)));
        }
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end save bgData!");
    }

    private BgNViewDataInfo addBaseValue(Context ctx, Cell cell, String formula, String version, BigDecimal value) throws EASBizException, BOSException {
        BgNViewDataInfo _dataInfo = null;
        if (!StringUtils.isEmpty((String)formula)) {
            _dataInfo = new BgNViewDataInfo();
            if (cell != null) {
                _dataInfo.setRow(cell.getRow());
                _dataInfo.setCol(cell.getCol());
            }
            _dataInfo.setFormula(formula);
            _dataInfo.setBgVersion(version);
            _dataInfo.splitFormula();
            if (this.isActData(ctx, _dataInfo.getBgScenario())) {
                _dataInfo.setBizActual(value);
            } else {
                _dataInfo.setBudgetValue(value);
            }
            this.parseBgFormula((BgNDataInfo)_dataInfo);
        }
        return _dataInfo;
    }

    private boolean isActData(Context ctx, String bgScenarioNumber) throws BOSException {
        Map scenarioCache = BgDimCacheUtils.getScenarioCache((Context)ctx);
        if (scenarioCache != null && bgScenarioNumber != null && scenarioCache.containsKey(bgScenarioNumber)) {
            BgScenarioInfo scenario = (BgScenarioInfo)scenarioCache.get(bgScenarioNumber);
            int type = scenario.getType().getValue();
            if (0 == type) {
                return false;
            }
            if (1 == type) {
                return true;
            }
        }
        return false;
    }

    private void parseBgFormula(BgNDataInfo info) throws EASBizException {
        if (info != null && !StringUtils.isEmpty((String)info.getFormula())) {
            String[] _para = BgNFSHelper.parseFormulaPara((String)info.getFormula());
            BgNFSHelper.checkFormulaPara((String)info.getFormula(), (String[])_para);
            if (_para != null) {
                info.setBgItemNumber(_para[0]);
                info.setBgPeriodNumber(_para[1]);
                info.setBgElementNumber(_para[2]);
                info.setCurrencyNumber(_para[5]);
                info.setBgScenario(_para[3]);
            }
        }
    }

    @Override
    protected Map _batchAudit(Context ctx, List idList, IObjectValue idea, boolean isReqMutex) throws BOSException, EASBizException {
        HashMap<String, Map<String, String[]>> result = new HashMap<String, Map<String, String[]>>();
        if (ctx == null || idList == null || idList.isEmpty()) {
            return result;
        }
        String billId = null;
        Set workFlow = null;
        Set mutex = new HashSet();
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        BgSchemeInfo schemeInfo = null;
        BgAuditIdeaInfo ideaInfo = null;
        BgAuditIdeaInfo _tmpIdea = null;
        CoreBaseCollection ideas = new CoreBaseCollection();
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        UnionAdjDataUtils utils = new UnionAdjDataUtils(pool);
        try {
            conn = this.getConnection(ctx);
            if (idea instanceof BgAuditIdeaInfo) {
                ideaInfo = (BgAuditIdeaInfo)idea;
            } else {
                ideaInfo = new BgAuditIdeaInfo();
                ideaInfo.setState(BgAuditIdeaEnum.AUDITPASS);
            }
            if (ideaInfo.getCreator() == null) {
                ideaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            if (ideaInfo.getCreateTime() == null) {
                ideaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            }
            if (isReqMutex) {
                mutex = MBgCheckHelper.requestMutex((Context)ctx, (List)idList, (boolean)true);
            }
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, (Collection)idList);
            List<BgCslAdjFormInfo> cslAdjForms = MbgCslDataHelper.getBgCslAdjFormInfo(ctx, conn, idList);
            if (schemeInfo == null && cslAdjForms != null && cslAdjForms.size() > 0) {
                schemeInfo = MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)ctx.getLocale(), (BOSUuid)cslAdjForms.get(0).getBgScheme().getId());
            }
            BgClosureMapUtils bgClosureMapUtils = new BgClosureMapUtils(schemeInfo, conn);
            Map closureMap = bgClosureMapUtils.getClosureMap();
            utils.setClosureMap(closureMap);
            for (BgCslAdjFormInfo cslAdjFrom : cslAdjForms) {
                billId = cslAdjFrom.getId().toString();
                if (mutex.contains(billId) || workFlow.contains(billId)) {
                    if (mutex.contains(billId)) {
                        mutexMap.put(billId, new String[]{cslAdjFrom.getNumber(), cslAdjFrom.getName()});
                        continue;
                    }
                    if (!workFlow.contains(billId)) continue;
                    workFlowMap.put(billId, new String[]{cslAdjFrom.getNumber(), cslAdjFrom.getName()});
                    continue;
                }
                if (1 == cslAdjFrom.getState().getValue()) {
                    utils.audit(ctx, conn, schemeInfo, cslAdjFrom, null, result);
                } else {
                    stateMap.put(billId, new String[]{cslAdjFrom.getNumber(), cslAdjFrom.getName()});
                }
                _tmpIdea = ideaInfo.getClone();
                _tmpIdea.setFormId(BOSUuid.read((String)billId));
                ideas.add((CoreBaseInfo)_tmpIdea);
            }
            if (!ideas.isEmpty()) {
                BgAuditIdeaFactory.getLocalInstance((Context)ctx).addnewBatchData(ideas);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"cslAdjForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            idList.removeAll(mutex);
            MBgCheckHelper.releaseMutex((Context)ctx, (List)idList);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        return result;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, List idList, IObjectValue idea, boolean isReqMutex) throws BOSException, EASBizException {
        HashMap<String, Map<String, String[]>> result = new HashMap<String, Map<String, String[]>>();
        if (ctx == null || idList == null || idList.isEmpty()) {
            return result;
        }
        String billId = null;
        Set workFlow = null;
        Set mutex = new HashSet();
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        BgSchemeInfo schemeInfo = null;
        BgAuditIdeaInfo ideaInfo = null;
        BgAuditIdeaInfo _tmpIdea = null;
        CoreBaseCollection ideas = new CoreBaseCollection();
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        UnionAdjDataUtils utils = new UnionAdjDataUtils(pool);
        try {
            conn = this.getConnection(ctx);
            if (idea instanceof BgAuditIdeaInfo) {
                ideaInfo = (BgAuditIdeaInfo)idea;
            } else {
                ideaInfo = new BgAuditIdeaInfo();
                ideaInfo.setState(BgAuditIdeaEnum.UNAUDIT);
            }
            if (ideaInfo.getCreator() == null) {
                ideaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            if (ideaInfo.getCreateTime() == null) {
                ideaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            }
            if (isReqMutex) {
                mutex = MBgCheckHelper.requestMutex((Context)ctx, (List)idList, (boolean)true);
            }
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, (Collection)idList);
            List<BgCslAdjFormInfo> cslAdjForms = MbgCslDataHelper.getBgCslAdjFormInfo(ctx, conn, idList);
            if (schemeInfo == null && cslAdjForms != null && cslAdjForms.size() > 0) {
                schemeInfo = MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)ctx.getLocale(), (BOSUuid)cslAdjForms.get(0).getBgScheme().getId());
            }
            BgClosureMapUtils bgClosureMapUtils = new BgClosureMapUtils(schemeInfo, conn);
            Map closureMap = bgClosureMapUtils.getClosureMap();
            utils.setClosureMap(closureMap);
            for (BgCslAdjFormInfo cslAdjFrom : cslAdjForms) {
                billId = cslAdjFrom.getId().toString();
                if (mutex.contains(billId) || workFlow.contains(billId)) {
                    if (mutex.contains(billId)) {
                        mutexMap.put(billId, new String[]{cslAdjFrom.getNumber(), cslAdjFrom.getName()});
                        continue;
                    }
                    if (!workFlow.contains(billId)) continue;
                    workFlowMap.put(billId, new String[]{cslAdjFrom.getNumber(), cslAdjFrom.getName()});
                    continue;
                }
                if (2 == cslAdjFrom.getState().getValue()) {
                    utils.unAudit(ctx, conn, schemeInfo, cslAdjFrom, null, result);
                    _tmpIdea = ideaInfo.getClone();
                    _tmpIdea.setFormId(BOSUuid.read((String)billId));
                    ideas.add((CoreBaseInfo)_tmpIdea);
                    continue;
                }
                stateMap.put(billId, new String[]{cslAdjFrom.getNumber(), cslAdjFrom.getName()});
            }
            if (!ideas.isEmpty()) {
                BgAuditIdeaFactory.getLocalInstance((Context)ctx).addnewBatchData(ideas);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"cslAdjForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            idList.removeAll(mutex);
            MBgCheckHelper.releaseMutex((Context)ctx, (List)idList);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        return result;
    }

    @Override
    protected Map _getBgDataInfo(Context ctx, BgCslAdjFormInfo bgFormInfo, IMbgViewBase view) throws BOSException, EASBizException {
        if (view == null || bgFormInfo == null) {
            return new HashMap();
        }
        ArrayList<IBgDimensionManagerBase> dimensionManagers = new ArrayList<IBgDimensionManagerBase>();
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            dimensionManagers.add(((IMbgSheetBase)view.getSheetManagers().get(i)).getDimensionManager());
        }
        Map indvDatas = MBGFormFacadeFactory.getLocalInstance((Context)ctx).queryBgData(null, (IObjectValue)bgFormInfo, dimensionManagers, 128, false, null, false, null);
        this.saveBizCalcDatas(ctx, bgFormInfo, indvDatas);
        return indvDatas;
    }

    protected void saveBizCalcDatas(Context ctx, BgCslAdjFormInfo bgFormInfo, Map<String, Map<String, IBgNData>> datas) {
        BgCslBackSaveCaller.getInstance().runBackUpdate(ctx, bgFormInfo, datas);
    }

    @Override
    protected void _saveViewListData(Context ctx, BgCslAdjFormInfo bgCslFormInfo, Map bgDataMap, Map otherOrgDimensionDataToSave, Map editNote, IObjectCollection desColls) throws BOSException, EASBizException {
    }

    @Override
    protected Map _initMutiOrgMemberCheckHelper(Context ctx, Map mutiViewManagers, BgSchemeDimensionHelper schemeHelper, boolean isClearCtx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _queryViewListData(Context ctx, BgCslAdjFormInfo bgCslFormInfo, Map dimensionManagers, int dataType, boolean isSynch) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _reportCheck(Context ctx, List billIds) throws BOSException, EASBizException {
        HashMap<String, String> msgMap = new HashMap<String, String>();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return msgMap;
        }
        StringBuffer msg = null;
        RptOperationSchemaComp comp = null;
        ArrayList check = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(BgCslFormHelper.getSelector());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(billIds), CompareType.INCLUDE));
            BgCslAdjFormCollection cslForms = this.getBgCslAdjFormCollection(ctx, evi);
            if (cslForms != null) {
                for (int i = 0; i < cslForms.size(); ++i) {
                    BgCslAdjFormInfo cslForm = cslForms.get(i);
                    if (0 != cslForm.getBgCslTemplate().getFormType().getValue() && 8 != cslForm.getBgCslTemplate().getFormType().getValue() || cslForm.getData() == null) continue;
                    BookProperties bp = BookProperties.loadFromBook((Book)cslForm.getBook());
                    comp = cslForm.get("operationSchemas") != null ? (RptOperationSchemaComp)cslForm.get("operationSchemas") : bp.getOperationSchema();
                    if (comp == null || comp.isCheckExpEmpty()) continue;
                    cslForm.put("FORMULA_DATA", this.extractData(cslForm, true, null));
                    cslForm.put("operationSchemas", comp);
                    BgCslAdjRptReportPropertyAdapter adapter = new BgCslAdjRptReportPropertyAdapter(cslForm);
                    check = ReportCheck.checkReport((Context)ctx, (ReportBaseInfo)cslForm, (IReportPropertyAdapter)adapter, null);
                    if (check == null || !Boolean.FALSE.equals(check.get(0))) continue;
                    msg = new StringBuffer();
                    msg.append("<a>" + cslForm.getNumber() + " - " + cslForm.getName() + "</a>");
                    msg.append("<br>");
                    msg.append(check.get(2));
                    msg.append("<br>");
                    msg.append("<br>");
                    msgMap.put(cslForm.getId().toString(), msg.toString());
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return msgMap;
    }

    private List extractData(BgCslAdjFormInfo model, boolean valueFirst, int[] calIndex) {
        Book _book = null;
        Sheet _sheet = null;
        try {
            _book = model.getBook();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BgNFSHelper.disableCal((Book)_book);
        BgNFSHelper.disableUndo((Book)_book);
        ArrayList result = new ArrayList(_book.getSheetCount());
        ArrayList<String> names = new ArrayList<String>(_book.getSheetCount());
        result.add(names);
        int i = 0;
        int jn = _book.getSheetCount();
        for (int j = 0; j < jn; ++j) {
            int r;
            _sheet = _book.getSheet(j);
            if (_sheet == null) {
                result.add(null);
                names.add(null);
                continue;
            }
            names.add(_sheet.getSheetName());
            int rowcount = _sheet.getMaxRowIndex();
            if (rowcount < 1) continue;
            ArrayList myBody = new ArrayList(rowcount);
            result.add(myBody);
            int lastRow = 0;
            for (r = 0; r < rowcount; ++r) {
                Row row = _sheet.getRow(r, false);
                if (row == null) {
                    myBody.add(null);
                    continue;
                }
                ArrayList<Object> myRow = new ArrayList<Object>(_sheet.getMaxColIndex());
                boolean hasContent = false;
                for (int k = 0; k < _sheet.getMaxColIndex(); ++k) {
                    Cell cell = row.getCell(k, false);
                    if (cell == null || cell.getValue() == Variant.nullVariant && BgNFSHelper.getExpression((Cell)cell) == null) {
                        myRow.add(null);
                        continue;
                    }
                    if (cell != null && BgNFSHelper.getValue((Cell)cell) instanceof String && StringUtils.isEmpty((String)((String)BgNFSHelper.getValue((Cell)cell))) && BgNFSHelper.getExpression((Cell)cell) == null) {
                        myRow.add(null);
                        continue;
                    }
                    hasContent = true;
                    String s = BgNFSHelper.getExpression((Cell)cell);
                    Variant obj = cell.getValue();
                    if (!StringUtils.isEmpty((String)s)) {
                        if (valueFirst || calIndex != null && calIndex[i] < 0) {
                            myRow.add(obj);
                            continue;
                        }
                        myRow.add(s);
                        continue;
                    }
                    myRow.add(obj);
                }
                if (hasContent) {
                    myBody.add(myRow);
                    lastRow = j;
                    continue;
                }
                myBody.add(null);
            }
            for (r = rowcount - 1; r > lastRow; --r) {
                myBody.remove(r);
            }
            ++i;
        }
        return result;
    }
}

