/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTempNodeFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTempNodeInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateException;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslAdjTemplateControllerBean;
import com.kingdee.eas.ma.bgcsl.common.BgCslTemplateHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgSpecialCommonHelper;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgMeasureUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslAdjTemplateControllerBean
extends AbstractBgCslAdjTemplateControllerBean {
    private static final long serialVersionUID = 235171830854451649L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslAdjTemplateControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslAdjTemplateInfo info = (BgCslAdjTemplateInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)info, (String)info.getOrgUnit().getId().toString());
        }
        if (info.getNumber() != null && info.getNumber().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERTOOLONG);
        }
        this.checkDupNumber(ctx, info.getNumber(), info.getId() == null ? null : info.getId().toString(), info.getBgScheme().getId().toString(), info.getOrgUnit().getId().toString());
        if (info.getName() != null && info.getName().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NAMETOOLONG);
        }
        try {
            Book book = info.getBook();
            BgNTemplateHelper.initAliasObjectTem((Book)book, (boolean)false);
            info.setBook(book);
            this.transAndCheckBook(ctx, info, book);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return super._save(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslAdjTemplateInfo info = (BgCslAdjTemplateInfo)model;
        info.setRoot(info);
        BgCslAdjTempNodeInfo node = new BgCslAdjTempNodeInfo();
        node.setBgTemplate(info);
        node.setOrgUnit(info.getOrgUnit());
        BgCslAdjTempNodeFactory.getLocalInstance(ctx).save(node);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgCslAdjTemplateInfo info = this.getBgCslAdjTemplateInfo(ctx, "select id, orgUnit.id, number where id = '" + pk + "'");
        BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)info, (String)info.getOrgUnit().getId().toString(), (String)info.getNumber());
        super._delete(ctx, pk);
    }

    private Book transAndCheckBook(Context ctx, BgCslAdjTemplateInfo model, Book book) throws BOSException, EASBizException {
        if (ctx == null || model == null || book == null) {
            return book;
        }
        HashSet bgItemSet = new HashSet();
        HashSet bgPeriodSet = new HashSet();
        HashSet bgElementSet = new HashSet();
        HashSet currencySet = new HashSet();
        ArrayList formulaList = new ArrayList();
        if (!BgTemFormTypeEnum.VIEWLIST.equals((Object)model.getFormType()) && book != null && (BgTemFormTypeEnum.FIXEDFORM.equals((Object)model.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)model.getFormType()))) {
            this.transAndCheckBookForNoView(ctx, model, book, formulaList, bgItemSet, bgElementSet, bgPeriodSet, currencySet);
            new MbgXMLParser(ctx);
            model.setDimensionData(MbgXMLParser.unParse((IMbgViewManager)DimensionFormulaHelper.buildViewMamager((Context)ctx, formulaList, null)));
        }
        return book;
    }

    private void transAndCheckBookForNoView(Context ctx, BgCslAdjTemplateInfo model, Book book, List formulaList, Set bgItemSet, Set bgElementSet, Set bgPeriodSet, Set currencySet) throws EASBizException, BOSException {
        boolean isAssignTemplate = false;
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, model.getBgScheme().getId().toString(), model.getBgScheme().getOrgUnit().getId().toString());
        boolean isElementRequired = !BgSpecialCommonHelper.isInSpecialItem(DimensionConstants.DEF_ELEMENT_NUMBER, model, schemeHelper);
        Sheet sheet = null;
        Cell cell = null;
        String formulaStr = null;
        String expression = null;
        String _tmpStr = null;
        String[] formula = null;
        String[] _tmpStrs = null;
        String[] bgItemNums = null;
        ArrayList<String[]> checkList = new ArrayList<String[]>();
        ArrayList<String> bgItemNumList = new ArrayList<String>();
        HashSet<String> bgPeriodVariable = new HashSet<String>();
        String orgUnitId = model.getCU() == null ? ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString() : model.getCU().getId().toString();
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        boolean isAnalyseSheet = false;
        if (model.getBgType() != null && "bgMAAAAKIcA7rHKd".equals(model.getBgType().getId().toString())) {
            isAnalyseSheet = true;
        }
        HashSet<String> bgPeriodNumbers = new HashSet<String>();
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRowCount = sheet.getMaxRowIndex();
            int maxColCount = sheet.getMaxColIndex();
            for (int i = 0; i <= maxRowCount; ++i) {
                for (int j = 0; j <= maxColCount; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                    formulaList.add(formulaStr);
                    if (isAnalyseSheet) {
                        throw new BgTemplateException(BgTemplateException.SELF_ANA_TEM_NOT_ALLOW_ITEMFORMUL);
                    }
                    formula = new String[]{sheet.getSheetName(), formulaStr, String.valueOf(i), String.valueOf(j)};
                    checkList.add(formula);
                    _tmpStrs = BgNFSHelper.parseFormulaPara((String)formulaStr);
                    if (_tmpStrs == null || _tmpStrs.length != 6) {
                        throw new BgException(BgException.BGITEMPARSEERROR, (Object[])new String[]{formulaStr});
                    }
                    _tmpStr = _tmpStrs[0];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"item.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                    }
                    bgItemSet.add(_tmpStr.replaceAll(",", "_"));
                    bgItemNums = _tmpStr.split(",");
                    for (int x = 0; x < bgItemNums.length; ++x) {
                        if (bgItemNumList.contains(bgItemNums[x])) continue;
                        bgItemNumList.add(bgItemNums[x]);
                    }
                    _tmpStr = _tmpStrs[2];
                    if (isElementRequired && StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"element.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                    }
                    bgElementSet.add(_tmpStr);
                    _tmpStr = _tmpStrs[1];
                    if (!StringUtils.isEmpty((String)_tmpStr)) {
                        bgPeriodNumbers.add(_tmpStr);
                        if (!bgPeriodVariable.contains(_tmpStr)) {
                            boolean isRelativeBgPeriod = false;
                            int relativeValue = 0;
                            try {
                                relativeValue = Integer.parseInt(_tmpStr);
                                isRelativeBgPeriod = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (isRelativeBgPeriod) {
                                if (Math.abs(relativeValue) > 100) {
                                    String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"itemformula.to.100.to100", (Locale)ctx.getLocale());
                                    throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                                }
                            } else if (BgPeriodNVariableHelper.checkCanConvert((String)_tmpStr)) {
                                bgPeriodVariable.add(_tmpStr);
                            } else {
                                bgPeriodSet.add(_tmpStr);
                            }
                        }
                    }
                    if (!StringUtils.isEmpty((String)(_tmpStr = _tmpStrs[5]))) {
                        currencySet.add(_tmpStr);
                    }
                    if (!StringUtils.isEmpty((String)(expression = BgNFSHelper.getExpression((Cell)cell))) && !isAssignTemplate) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inDataFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                        }
                    }
                    if (!StringUtils.isEmpty((String)(expression = cell.getFormula())) && !isAssignTemplate) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inActualFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                        }
                    }
                    if (StringUtils.isEmpty((String)(expression = cell.getFormula())) || isAssignTemplate) continue;
                    try {
                        ExcelFormulaPaserHelper.parse((String)expression);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inADDFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                    }
                }
            }
        }
        try {
            BgPeriodDispFactory.getLocalInstance((Context)ctx).checkPeriodType(bgPeriodNumbers, false);
            DimensionFormulaHelper.checkDimensionMemberExist((Context)ctx, (String)orgUnitId, bgItemNumList);
            BgNTemplateHelper.checkFormulaIsEctype(checkList, (Locale)ctx.getLocale());
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkList.clear();
        }
    }

    @Override
    protected Map _getRPCDataMap(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return BgCslTemplateFactory.getLocalInstance(ctx).getRPCDataMap(paramMap);
    }

    @Override
    protected void _saveSimpleInfo(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        BgCslAdjTemplateInfo bgTemInfo = (BgCslAdjTemplateInfo)info;
        String id = bgTemInfo.getId().toString();
        String name = bgTemInfo.getName();
        String number = bgTemInfo.getNumber();
        String description = bgTemInfo.getDescription();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String measureId = bgTemInfo.getDefaultMeasureUnit().getId().toString();
        this.checkDupNumber(ctx, number, id, bgTemInfo.getBgScheme().getId().toString(), bgTemInfo.getOrgUnit().getId().toString());
        sql.append(" update t_mbg_bgCslAdjTemplate set fname = ?, fnumber = ?, fdescription = ?, fDefaultMeasureUnitId = ?, FLastUpdateTime = ?, FBgTypeId = ? where fid = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, name);
            sm.setString(2, number);
            sm.setString(3, description);
            sm.setString(4, measureId);
            sm.setTimestamp(5, time);
            if (bgTemInfo.getBgType() == null) {
                sm.setNull(6, 12);
            } else {
                sm.setString(6, bgTemInfo.getBgType().getId().toString());
            }
            sm.setString(7, id);
            sm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        if (bgTemInfo.getId() != null && bgTemInfo.getBgSpecialItems().isEmpty()) {
            BgCslSpecialItemsFactory.getLocalInstance(ctx).delete("where bgAdjTemplate.id = '" + bgTemInfo.getId() + "'");
        } else {
            CoreBaseCollection col = new CoreBaseCollection();
            col.addObjectCollection((IObjectCollection)bgTemInfo.getBgSpecialItems());
            BgCslSpecialItemsFactory.getLocalInstance(ctx).saveBatchData(col);
        }
        this.saveMeasure(ctx, bgTemInfo);
    }

    private void saveMeasure(Context ctx, BgCslAdjTemplateInfo bgTem) throws BOSException, EASBizException {
        String id = bgTem.getId().toString();
        PreparedStatement ps = null;
        Connection connection = null;
        BOSObjectType type = new BgMeasureUnitInfo().getBOSType();
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(80);
            strBuffer.append("delete T_MBG_BgCslAdjTemMsUnit where FBGCSLTEMPLATEID = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, id);
            ps.executeUpdate();
            if (bgTem.getBgMeasureUnit() != null && bgTem.getBgMeasureUnit().size() != 0) {
                strBuffer = new StringBuffer(80);
                strBuffer.append("insert into T_MBG_BgCslAdjTemMsUnit(fid,FBGCSLTEMPLATEID,fbgelementid,fmeasureunitid) values(?,?,?,?)");
                ps = connection.prepareStatement(strBuffer.toString());
                for (int i = 0; i < bgTem.getBgMeasureUnit().size(); ++i) {
                    ps.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                    ps.setString(2, id);
                    ps.setString(3, bgTem.getBgMeasureUnit().get(i).getBgElement().getId().toString());
                    ps.setString(4, bgTem.getBgMeasureUnit().get(i).getMeasureUnit().getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void checkDupNumber(Context ctx, String number, String id, String bgSchemeId, String treeId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(60);
        if (id == null) {
            id = "000000000000000000000000000=";
        }
        sql.append(" select t1.fid from T_MBG_BgCslAdjTemplate t1, T_MBG_BgCslAdjTempNode t2 where t1.FID = t2.FBgTemplateId AND t1.fnumber = ? and t2.forgunitid = ? and t1.FBgSchemeId = ?");
        if (!StringUtils.isEmpty((String)id)) {
            sql.append(" and t1.fid <> ?");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, number);
            pstmt.setString(2, treeId);
            pstmt.setString(3, bgSchemeId);
            pstmt.setString(4, id);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{number});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _checkRefByForm(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_MBg_BgCslAdjForm where FBgCslTemplateID = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }

    @Override
    protected void _clone(Context ctx, IObjectPK pk, BOSUuid orgUnitId) throws BOSException, EASBizException {
        BgCslAdjTemplateInfo info = this.getBgCslAdjTemplateInfo(ctx, pk, BgCslTemplateHelper.getCslAdjTemplateFullSelector());
        if (info.getDefaultMeasureUnit() != null && info.getDefaultMeasureUnit().isIsDisabled()) {
            throw new BgTemplateException(BgTemplateException.IMPORTNOTFOUNDMEASUREUNIT, new Object[]{info.getDefaultMeasureUnit().getNumber()});
        }
        info = info.deepClone();
        info.setOrgUnit(new FullOrgUnitInfo());
        info.getOrgUnit().setId(orgUnitId);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setNumber("clone_" + info.getNumber());
        info.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"clone", (Locale)ctx.getLocale()) + "_" + info.getName());
        this._save(ctx, (IObjectValue)info);
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
    }

    @Override
    protected void _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.doCancelOrNot(ctx, ids, true);
    }

    @Override
    protected void _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.doCancelOrNot(ctx, ids, false);
    }

    protected void doCancelOrNot(Context ctx, Set ids, boolean isCancel) throws BOSException, EASBizException {
        if (ctx == null || ids == null || ids.isEmpty()) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgCslAdjTemplate Set FTemplateStatus = " + (isCancel ? 10 : 0) + " Where FID = ?"), new ArrayList(ids));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected boolean _checkNumberDup(Context ctx, String templateId, String bgSchemeId, String orgUnitId, String number) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select t1.fid from T_MBG_BgCslAdjTemplate t1 where  t1.fnumber = ?  and t1.FBgSchemeId = ? and t1.FOrgUnitId = ? ");
            if (!StringUtils.isEmpty((String)templateId)) {
                sql.append(" and t1.fid <> ?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                sm.setString(2, bgSchemeId);
                sm.setString(3, orgUnitId);
                if (!StringUtils.isEmpty((String)templateId)) {
                    sm.setString(4, templateId);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    protected Map<String, FullOrgUnitInfo> queryOrgUnitInfo(Context ctx, List orgUnitIds) throws BOSException {
        HashMap<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(orgUnitIds), CompareType.INCLUDE));
        FullOrgUnitCollection orgCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(evi);
        for (int i = 0; i < orgCol.size(); ++i) {
            orgUnitMap.put(orgCol.get(i).getId().toString(), orgCol.get(i));
        }
        return orgUnitMap;
    }

    protected String[] getBaseResult(BgCslAdjTemplateInfo info, FullOrgUnitInfo orgUnit) {
        String[] result = new String[6];
        result[2] = info.getNumber();
        result[3] = info.getName();
        result[4] = orgUnit.getNumber();
        result[5] = orgUnit.getName();
        return result;
    }

    private IMutexServiceControl getMutexServicInterface(Context ctx) throws BOSException {
        return MutexServiceControlFactory.getLocalInstance((Context)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _assign(Context ctx, String bgSchemeID, List orgUnitIds, List templateIds) throws BOSException, EASBizException {
        if (orgUnitIds == null || orgUnitIds.isEmpty() || templateIds == null || templateIds.isEmpty()) {
            return new ArrayList();
        }
        HashMap<String, BgCslAdjTemplateInfo> templateMap = new HashMap<String, BgCslAdjTemplateInfo>();
        Map<String, FullOrgUnitInfo> orgUnitMap = this.queryOrgUnitInfo(ctx, orgUnitIds);
        ArrayList<String[]> _reList = new ArrayList<String[]>();
        try {
            int i;
            BgCslAdjTemplateInfo info = null;
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("data");
            evi.getSelector().add("orgUnit.id");
            evi.getSelector().add("BgSpecialItems.*");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(templateIds), CompareType.INCLUDE));
            BgCslAdjTemplateCollection col = this.getBgCslAdjTemplateCollection(ctx, evi);
            for (i = 0; i < col.size(); ++i) {
                info = col.get(i);
                templateMap.put(info.getId().toString(), info);
            }
            for (i = 0; i < templateIds.size(); ++i) {
                String _bgTemplateId = (String)templateIds.get(i);
                BgCslAdjTemplateInfo templateInfo = (BgCslAdjTemplateInfo)templateMap.get(_bgTemplateId);
                IMutexServiceControl iMc = this.getMutexServicInterface(ctx);
                List<String[]> tmpList = null;
                try {
                    boolean reqTemplate = iMc.requestBizObjIDForUpdate(_bgTemplateId);
                    if (reqTemplate) {
                        tmpList = this.dispatchBgTemplate(ctx, bgSchemeID, templateInfo, orgUnitIds, orgUnitMap);
                        if (tmpList == null) continue;
                        _reList.addAll(tmpList);
                        continue;
                    }
                    String[] result = new String[]{String.valueOf(false), ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"requestBizObj4Adj", (Locale)ctx.getLocale(), (Object[])new Object[]{templateInfo.getNumber() + "(" + templateInfo.getName() + ")"})};
                    _reList.add(result);
                    continue;
                }
                finally {
                    iMc.releaseObjIDForUpdate(_bgTemplateId);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return _reList;
    }

    private List<String[]> dispatchBgTemplate(Context ctx, String bgSchemeID, BgCslAdjTemplateInfo templateInfo, List orgUnitIds, Map<String, FullOrgUnitInfo> orgUnitMap) throws BOSException {
        ArrayList<String[]> tmpList = new ArrayList<String[]>();
        Connection conn = this.getConnection(ctx);
        try {
            BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeID, (String)null);
            HashMap<String, Map<String, String>> number2Name = new HashMap<String, Map<String, String>>();
            Map<String, Map<String, Set<String>>> memberMap = BgCslAdjTemplateControllerBean.getMemberMap(ctx, schemeHelper, new HashSet<String>(orgUnitIds), number2Name);
            List<BgDimensionInfo> speDim = BgSpecialCommonHelper.getBgDimensions(templateInfo, schemeHelper);
            Book book = templateInfo.getBook();
            List formulaList = BgNFSHelper.getFormulaListOfBook((Book)book);
            MbgViewManagerImpl view = DimensionFormulaHelper.buildViewMamager((Context)ctx, (Collection)formulaList, null);
            List<String[]> paramList = new ArrayList();
            StringBuffer sql = new StringBuffer("Select FOrgUnitId FROM T_MBG_BgCslAdjTempNode Where FBgTemplateId IN (Select FID FROM T_MBG_BgCslAdjTemplate Where FNumber = ? AND FID <> ? AND FBgSchemeId = ?) AND FOrgUnitId IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{templateInfo.getNumber(), templateInfo.getId().toString(), bgSchemeID}, (Object[])orgUnitIds.toArray(), (int)50);
            List orgNumberRepeat = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), paramList);
            String assignHasTemplate = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasTemplate", (Locale)ctx.getLocale());
            String[] result = null;
            paramList = new ArrayList();
            List<BgDimensionInfo> bgDimensions = BgSpecialCommonHelper.getBgDimensions(templateInfo, schemeHelper);
            block5: for (int i = 0; i < orgUnitIds.size(); ++i) {
                String _orgUnitId = (String)orgUnitIds.get(i);
                FullOrgUnitInfo orgUnit = orgUnitMap.get(_orgUnitId);
                result = this.getBaseResult(templateInfo, orgUnit);
                result[0] = String.valueOf(true);
                tmpList.add(result);
                String newId = BOSUuid.create((BOSObjectType)new BgCslAdjTempNodeInfo().getBOSType()).toString();
                if (orgUnit == null) continue;
                if (orgNumberRepeat.contains(_orgUnitId)) {
                    result[0] = String.valueOf(false);
                    result[1] = assignHasTemplate;
                    continue;
                }
                List sheetManagers = view.getSheetManagers();
                if (sheetManagers.size() > 0) {
                    for (int j = 0; j < sheetManagers.size(); ++j) {
                        IMbgSheetBase iMbgSheetBase = (IMbgSheetBase)sheetManagers.get(j);
                        IBgDimensionManagerBase dimensionManager = iMbgSheetBase.getDimensionManager();
                        IBgDimensionManager manager = (IBgDimensionManager)dimensionManager;
                        List dimensions = manager.getDimension();
                        if (dimensions != null && bgDimensions != null) {
                            dimensions.addAll(bgDimensions);
                        }
                        int in = dimensions.size();
                        for (int w = 0; w < in; ++w) {
                            BgDimensionInfo dimensionInfo = (BgDimensionInfo)dimensions.get(w);
                            String dimNumber = dimensionInfo.getNumber();
                            if (DimensionBaseConstants.necessary.contains(dimNumber)) continue;
                            List members = dimensionInfo.getMember();
                            for (int l = 0; l < members.size(); ++l) {
                                Set<String> set;
                                BgDimensionMember member = (BgDimensionMember)members.get(l);
                                String number = member.getNumber();
                                Map<String, Set<String>> map = memberMap.get(member.getRefField());
                                if (map == null || (set = map.get(_orgUnitId)) == null || set.contains(number)) continue;
                                result[0] = String.valueOf(false);
                                if (dimNumber.equals(DimensionConstants.DEF_INDEX_NUMBER)) {
                                    result[1] = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasNoMbgMember1", (Locale)ctx.getLocale(), (Object[])new Object[]{member.getNumber() + "(" + member.getName() + ")"});
                                    continue block5;
                                }
                                result[1] = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasNoMbgMember1", (Locale)ctx.getLocale(), (Object[])new Object[]{member.getNumber() + "(" + member.getName() + ")"});
                                continue block5;
                            }
                        }
                    }
                } else {
                    for (int p = 0; p < speDim.size(); ++p) {
                        if (DimensionBaseConstants.necessary.contains(speDim.get(p).getNumber())) continue;
                        List members = speDim.get(p).getMember();
                        for (int l = 0; l < members.size(); ++l) {
                            Set<String> set;
                            BgDimensionMember member = (BgDimensionMember)members.get(l);
                            String number = member.getNumber();
                            Map<String, Set<String>> map = memberMap.get(member.getRefField());
                            if (map == null || (set = map.get(_orgUnitId)) == null || set.contains(number)) continue;
                            result[0] = String.valueOf(false);
                            if (speDim.get(p).getNumber().equals(DimensionConstants.DEF_INDEX_NUMBER)) {
                                result[1] = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasNoMbgMember1", (Locale)ctx.getLocale(), (Object[])new Object[]{member.getNumber() + "(" + member.getName() + ")"});
                                continue block5;
                            }
                            result[1] = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasNoMbgMember1", (Locale)ctx.getLocale(), (Object[])new Object[]{member.getNumber() + "(" + member.getName() + ")"});
                            continue block5;
                        }
                    }
                }
                paramList.add(new String[]{newId, _orgUnitId, templateInfo.getId().toString(), templateInfo.getId().toString(), _orgUnitId});
            }
            if (!paramList.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Insert Into T_MBG_BgCslAdjTempNode(FID, FBGTEMPLATEID, FORGUNITID) Select ?, FID, ? FROM T_MBG_BgCslAdjTemplate Where FID = ? AND NOT EXISTS (Select FID FROM T_MBG_BgCslAdjTempNode Where FBGTEMPLATEID = ? AND FORGUNITID = ?)", paramList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return tmpList;
    }

    @Override
    protected List _unAssign(Context ctx, String bgSchemeID, List orgUnitIds, List templateIds) throws BOSException, EASBizException {
        if (orgUnitIds == null || orgUnitIds.isEmpty() || templateIds == null || templateIds.isEmpty()) {
            return new ArrayList();
        }
        Map<String, FullOrgUnitInfo> orgUnitMap = this.queryOrgUnitInfo(ctx, orgUnitIds);
        HashMap<String, BgCslAdjTemplateInfo> templateMap = new HashMap<String, BgCslAdjTemplateInfo>();
        BgCslAdjTemplateInfo info2 = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("orgUnit.id");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(templateIds), CompareType.INCLUDE));
        BgCslAdjTemplateCollection col = this.getBgCslAdjTemplateCollection(ctx, evi);
        for (int i = 0; i < col.size(); ++i) {
            info2 = col.get(i);
            templateMap.put(info2.getNumber(), info2);
        }
        ArrayList<String[]> _reList = new ArrayList<String[]>();
        String hasElmeMsg = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"existCslAdjustForm", (Locale)ctx.getLocale());
        String orgUnitId = null;
        FullOrgUnitInfo orgUnit = null;
        ArrayList<String[]> delOrgIds = new ArrayList<String[]>();
        for (BgCslAdjTemplateInfo info2 : templateMap.values()) {
            Set<String> refByBgFormMap = BgCslAdjTemplateControllerBean.dispatchCheckRefBgForm(ctx, bgSchemeID, info2.getId(), orgUnitIds);
            for (int i = 0; i < orgUnitIds.size(); ++i) {
                orgUnitId = (String)orgUnitIds.get(i);
                orgUnit = orgUnitMap.get(orgUnitId);
                String[] result = this.getBaseResult(info2, orgUnit);
                _reList.add(result);
                if (refByBgFormMap != null && refByBgFormMap.contains(orgUnitId)) {
                    result[0] = String.valueOf(false);
                    result[1] = hasElmeMsg;
                    continue;
                }
                delOrgIds.add(new String[]{info2.getId().toString(), orgUnitId});
                result[0] = String.valueOf(true);
            }
        }
        if (!delOrgIds.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)"Delete From T_MBG_BgCslAdjTempNode Where FBgTemplateId = ? AND FOrgUnitId = ?", delOrgIds);
        }
        return _reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> dispatchCheckRefBgForm(Context ctx, String bgSchemeID, BOSUuid bgTemplateRootId, List<String> orgUnitIds) throws BOSException, EASBizException {
        HashSet<String> refBgTemplateIdSet = new HashSet<String>();
        if (ctx == null) return refBgTemplateIdSet;
        if (bgTemplateRootId == null) return refBgTemplateIdSet;
        if (orgUnitIds == null) {
            return refBgTemplateIdSet;
        }
        String _bgTemplateRootId = bgTemplateRootId.toString();
        int index = 0;
        int size = orgUnitIds.size();
        int count = (size - 1) / 50 + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FOrgUnitId from T_MBG_BgCslAdjForm f where f.FBgCslTemplateID = ? and f.FOrgUnitId IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, _bgTemplateRootId);
                for (int k = 2; k <= 51; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, orgUnitIds.get(pos));
                        continue;
                    }
                    pstmt.setString(k, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    refBgTemplateIdSet.add(rst.getString("FOrgUnitId"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"dispatchCheckRefBgForm Error: ", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"dispatchCheckRefBgForm Error: ", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return refBgTemplateIdSet;
    }

    public static Map<String, Map<String, Set<String>>> getMemberMap(Context ctx, BgCslSchemeDimensionHelper bgSchemeDimensionHelper, Set<String> sourceOrgIdSet, Map<String, Map<String, String>> number2Name) throws EASBizException, BOSException, SQLException {
        HashMap<String, Map<String, Set<String>>> memberMap = new HashMap<String, Map<String, Set<String>>>();
        String bgSchemeId = bgSchemeDimensionHelper.getBgSchemeId();
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeInfo("where id = '" + bgSchemeId + "'");
        Date beginDate = bgSchemeInfo.getDateFrom();
        CalendarHelper clhelper = new CalendarHelper();
        Date endDate = bgSchemeInfo.getDateTo();
        List allDimensions = bgSchemeDimensionHelper.getAllDimensions();
        for (int j = 0; j < allDimensions.size(); ++j) {
            BgDimensionInfo dimension = (BgDimensionInfo)allDimensions.get(j);
            if (DimensionBaseConstants.necessary.contains(dimension.getNumber())) continue;
            String refField = dimension.getRefField();
            memberMap.put(refField, new HashMap());
            for (String orgId : sourceOrgIdSet) {
                if (!((Map)memberMap.get(refField)).containsKey(orgId)) {
                    ((Map)memberMap.get(refField)).put(orgId, new HashSet());
                }
                DimensionFilterHelper helper = DimensionFilterHelper.getLocaleIntance((Context)ctx, (BgDimensionInfo)dimension, (String)orgId, (String)bgSchemeDimensionHelper.getBgSchemeId(), null, (String)orgId);
                String numberField = "number";
                String nameField = "name";
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(numberField);
                evi.getSelector().add(nameField);
                evi.setFilter(helper.getFilter(true));
                if (dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String beginDateString = df.format(beginDate);
                    String endDateString = df.format(endDate);
                    String defaultBeginDateString = df.format(clhelper.getFirstDayOfYear(2000));
                    String defaultEndDateString = df.format(clhelper.getLastDayOfYear(2099));
                    String filterString = "select fid from T_MBG_BgPeriodDisp where  (((fbeginDate <={ts'" + endDateString + "'} and fbeginDate>={ts'" + beginDateString + "'}) or (fEndDate <={ts'" + endDateString + "'} and fendDate>={ts'" + beginDateString + "'}) ) or (fbeginDate ={ts'" + defaultBeginDateString + "'} and fendDate={ts'" + defaultEndDateString + "'}))";
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)filterString, CompareType.INNER));
                }
                IDataProvider dpv = helper.getQueryExecutor();
                dpv.setObjectView(evi);
                IRowSet rs = dpv.executeQuery();
                while (rs.next()) {
                    String memberNumber = rs.getString(1);
                    ((Set)((Map)memberMap.get(refField)).get(orgId)).add(memberNumber);
                    if (number2Name == null) continue;
                    if (!number2Name.containsKey(refField)) {
                        number2Name.put(refField, new HashMap());
                    }
                    number2Name.get(refField).put(memberNumber, rs.getString(2));
                }
            }
        }
        return memberMap;
    }

    @Override
    protected Map _getDispatchInfo(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        HashMap bgTemplateIdsMap = new HashMap();
        if (ctx == null || bgSchemeId == null) {
            return bgTemplateIdsMap;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select t.FBgTemplateId, t.FOrgUnitId from T_MBG_BgCslAdjTempNode t, T_MBG_BgCslAdjTemplate t1 where t.FBgTemplateId = t1.FID and t.FOrgUnitID <> t1.FOrgUnitId and t1.FBgSchemeId = ?");
        Object[] sqlParams = new Object[]{bgSchemeId.toString()};
        String bgTemRootId = null;
        String orgUnitId = null;
        Set<String> temps = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            while (rst.next()) {
                bgTemRootId = rst.getString("FBgTemplateId");
                orgUnitId = rst.getString("FOrgUnitId");
                if (bgTemplateIdsMap.containsKey(orgUnitId)) {
                    temps = (Set)bgTemplateIdsMap.get(orgUnitId);
                } else {
                    temps = new HashSet();
                    bgTemplateIdsMap.put(orgUnitId, temps);
                }
                temps.add(bgTemRootId);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryDispatchInfo Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return bgTemplateIdsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getOrgMap(Context ctx, Connection conn, Set<String> orgIds) throws SQLException {
        LinkedHashMap<String, String> orgMap = new LinkedHashMap<String, String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FName_").append(ctx.getLocale()).append(" FName FROM T_Org_BaseUnit Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Order By FNumber");
            List params = MbgSqlHelper.getBatchParams(null, (Object[])orgIds.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            orgMap.clear();
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgMap.put(rst.getString("FID"), rst.getString("FName"));
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return orgMap;
    }

    private void beforeDeleteTemplate(Context ctx, Set<IObjectPK> deletePks) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", deletePks, CompareType.INCLUDE));
        evi.setFilter(filter);
        BgCslAdjTemplateCollection bgTemColls = this.getBgCslAdjTemplateCollection(ctx, evi);
        BgCslAdjTemplateInfo bgTemplateInfo = null;
        for (int i = 0; i < bgTemColls.size(); ++i) {
            bgTemplateInfo = bgTemColls.get(i);
            BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)bgTemplateInfo, (String)bgTemplateInfo.getOrgUnit().getId().toString(), (String)bgTemplateInfo.getNumber());
        }
    }

    private void afterDeleteTemplate(Context ctx, Set<IObjectPK> deletePks) throws BOSException, EASBizException {
        if (deletePks.size() == 0 || deletePks == null) {
            return;
        }
        ArrayList<String> deleteIds = new ArrayList<String>();
        for (IObjectPK iPk : deletePks) {
            deleteIds.add(iPk.toString());
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgViewDimension  where FTemplateID = ?", deleteIds);
            BgFacadeHelper.deleteRef((Context)ctx, deleteIds);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_BgTemSheet where FBgTemplateID = ?", deleteIds);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_MbgPermission where FBgTemplateID = ?", deleteIds);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_BgSheetpermission where FBgTemplateID = ?", deleteIds);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected String[] _delete(Context ctx, Map ids) throws BOSException, EASBizException {
        String[] stringArray;
        String bgTemplateId2;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        Map<Object, Object> orgMap;
        LinkedHashMap<String, String> bgTemplateMap;
        HashMap<String, String> dispatchedMap;
        HashMap refMap;
        int totalCount;
        block22: {
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            Map _ids = ids;
            totalCount = 0;
            refMap = new HashMap();
            dispatchedMap = new HashMap<String, String>();
            bgTemplateMap = new LinkedHashMap<String, String>();
            orgMap = new LinkedHashMap();
            HashSet<IObjectPK> deletePks = new HashSet<IObjectPK>();
            conn = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            for (String bgTemplateId2 : _ids.keySet()) {
                Set orgUnitIds = (Set)_ids.get(bgTemplateId2);
                totalCount += orgUnitIds.size();
                for (String string : orgUnitIds) {
                    orgMap.put(string, null);
                }
            }
            conn = this.getConnection(ctx);
            List<Object[]> params = new ArrayList();
            for (Map.Entry entry : _ids.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                params.addAll(MbgSqlHelper.getBatchParams((Object[])new Object[]{entry.getKey()}, (Object[])((Set)entry.getValue()).toArray(), (int)50));
            }
            sql.setLength(0);
            sql.append("Select FBgCslTemplateID, FOrgUnitId FROM T_MBG_BgCslAdjForm Where FBgCslTemplateID = ? And FOrgUnitId IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgTemplateId2 = rst.getString("FBgCslTemplateID");
                    String string = rst.getString("FOrgUnitId");
                    orgMap.put(string, null);
                    ((Set)_ids.get(bgTemplateId2)).remove(string);
                    if (!refMap.containsKey(bgTemplateId2)) {
                        refMap.put(bgTemplateId2, new HashSet());
                    }
                    ((Set)refMap.get(bgTemplateId2)).add(string);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            sql.setLength(0);
            sql.append("Select bgTemplate.FNumber, bgTemplate.FID, bgTemplate.FOrgUnitId, Count(tempNode.FID) FTemplateCount FROM T_MBG_BgCslAdjTemplate bgTemplate Left Join T_MBG_BgCslAdjTempNode tempNode On bgTemplate.FID = tempNode.FBgTemplateId Where bgTemplate.FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Group By bgTemplate.FNumber, bgTemplate.FID, bgTemplate.FOrgUnitId");
            params = MbgSqlHelper.getBatchParams(null, (Object[])_ids.keySet().toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgTemplateId2 = rst.getString("FID");
                    String string = rst.getString("FOrgUnitId");
                    int count = rst.getInt("FTemplateCount");
                    bgTemplateMap.put(bgTemplateId2, rst.getString("FNumber"));
                    if (!((Set)_ids.get(bgTemplateId2)).contains(string)) continue;
                    if (((Set)_ids.get(bgTemplateId2)).size() == count) {
                        deletePks.add((IObjectPK)new ObjectStringPK(bgTemplateId2));
                        continue;
                    }
                    dispatchedMap.put(bgTemplateId2, string);
                    ((Set)_ids.get(bgTemplateId2)).remove(string);
                    orgMap.put(string, null);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            params.clear();
            for (String bgTemplateId2 : _ids.keySet()) {
                for (String string : (Set)_ids.get(bgTemplateId2)) {
                    params.add(new Object[]{bgTemplateId2, string});
                }
            }
            if (!params.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Delete From T_MBG_BgCslAdjTempNode Where FBgTemplateId = ? AND FOrgUnitId = ?", params);
            }
            if (!deletePks.isEmpty()) {
                this.beforeDeleteTemplate(ctx, deletePks);
                this._delete(ctx, deletePks.toArray(new IObjectPK[0]));
                this.afterDeleteTemplate(ctx, deletePks);
            }
            if (!orgMap.isEmpty()) break block22;
            Iterator it = null;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return it;
        }
        try {
            orgMap = this.getOrgMap(ctx, conn, orgMap.keySet());
            int failCount = 0;
            String msgRefForm = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateResource", (String)"canRemove", (Locale)ctx.getLocale());
            String msgDispatched = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateResource", (String)"alreadyAssignTemp", (Locale)ctx.getLocale());
            String msgFormat = null;
            StringBuffer msg = new StringBuffer();
            for (Map.Entry entry : bgTemplateMap.entrySet()) {
                bgTemplateId2 = (String)entry.getKey();
                for (String string : orgMap.keySet()) {
                    msgFormat = refMap.containsKey(bgTemplateId2) && ((Set)refMap.get(bgTemplateId2)).contains(string) ? msgRefForm : (string.equals(dispatchedMap.get(bgTemplateId2)) ? msgDispatched : null);
                    if (msgFormat == null) continue;
                    ++failCount;
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(MessageFormat.format(msgFormat, orgMap.get(string), entry.getValue()));
                }
            }
            String info = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateResource", (String)"batchRemoveHasFailAndSuccess", (Locale)ctx.getLocale()), totalCount, totalCount - failCount, failCount);
            stringArray = new String[]{info, msg.toString()};
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return stringArray;
    }
}

