/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.bgcsl.BgCslElimCollection;
import com.kingdee.eas.ma.bgcsl.BgCslElimEntryCollection;
import com.kingdee.eas.ma.bgcsl.BgCslElimEntryInfo;
import com.kingdee.eas.ma.bgcsl.BgCslElimFactory;
import com.kingdee.eas.ma.bgcsl.BgCslElimInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateException;
import com.kingdee.eas.ma.bgcsl.ElimStatusEnum;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslElimControllerBean;
import com.kingdee.eas.ma.bgcsl.common.BgCslElimHelper;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionElimDataUtils;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslElimControllerBean
extends AbstractBgCslElimControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)BgCslElimControllerBean.class.getName());

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSubmit(ctx, model);
        BgCslElimInfo info = (BgCslElimInfo)model;
        try {
            String OUID = info.getOrgUnit().getId().toString();
            BgCodeNumberHelper numberCodeHelper = new BgCodeNumberHelper(ctx, null, null);
            String oldNumber = info.getNumber();
            numberCodeHelper.init((IObjectValue)info, OUID);
            numberCodeHelper.applyNumber((IObjectValue)info, OUID, null, true);
            if (StringUtils.isEmpty((String)info.getNumber()) && !StringUtils.isEmpty((String)oldNumber)) {
                info.setNumber(oldNumber);
            }
        }
        catch (Exception e) {
            info.setNumber(this.createDefaultNumber());
        }
        this.checkDupNumber(ctx, info.getNumber(), info.getId() == null ? null : info.getId().toString(), info.getOrgUnit().getId().toString(), info.getBgScheme().getId().toString());
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSubmit(ctx, model);
        super._update(ctx, pk, model);
    }

    private void checkDupNumber(Context ctx, String number, String id, String treeId, String bgSchemeId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(60);
        if (id == null) {
            id = "000000000000000000000000000=";
        }
        sql.append(" SELECT FID FROM T_MBG_BgCslElim where FOrgUnitID = ? AND FNumber = ? AND FID <> ? AND FBgSchemeId = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, treeId);
            pstmt.setString(2, number);
            pstmt.setString(3, id);
            pstmt.setString(4, bgSchemeId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{number});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("status"));
        selector.add(new SelectorItemInfo("elimType"));
        selector.add(new SelectorItemInfo("memberCombinNunber"));
        selector.add(new SelectorItemInfo("memberCombinName"));
        selector.add(new SelectorItemInfo("memberCombinRef"));
        selector.add(new SelectorItemInfo("bgScheme.id"));
        selector.add(new SelectorItemInfo("bgScheme.number"));
        selector.add(new SelectorItemInfo("bgScheme.refCube"));
        selector.add(new SelectorItemInfo("orgTree.id"));
        selector.add(new SelectorItemInfo("orgTree.number"));
        selector.add(new SelectorItemInfo("orgUnit.id"));
        selector.add(new SelectorItemInfo("orgUnit.number"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("currency.number"));
        selector.add(new SelectorItemInfo("bgVersion.id"));
        selector.add(new SelectorItemInfo("bgVersion.number"));
        selector.add(new SelectorItemInfo("bgVersion.versionId"));
        selector.add(new SelectorItemInfo("bgScenario.id"));
        selector.add(new SelectorItemInfo("bgScenario.number"));
        selector.add(new SelectorItemInfo("bgScenario.scenarioId"));
        selector.add(new SelectorItemInfo("bgElement.id"));
        selector.add(new SelectorItemInfo("bgElement.number"));
        selector.add(new SelectorItemInfo("bgPeriod.id"));
        selector.add(new SelectorItemInfo("bgPeriod.number"));
        selector.add(new SelectorItemInfo("template.id"));
        selector.add(new SelectorItemInfo("template.number"));
        selector.add(new SelectorItemInfo("template.name"));
        selector.add(new SelectorItemInfo("entries.*"));
        return selector;
    }

    @Override
    protected Map<String, Map<String, String[]>> _batchAudit(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null || param.get("idList") == null) {
            return null;
        }
        List idList = (List)param.get("idList");
        BgAuditIdeaInfo idea = (BgAuditIdeaInfo)param.get("idea");
        boolean isReqMutex = (Boolean)param.get("isReqMutex");
        boolean isDoAudit = param.get("isDoAudit") != null ? (Boolean)param.get("isDoAudit") : false;
        HashMap<String, Map<String, String[]>> result = new HashMap<String, Map<String, String[]>>();
        String billId = null;
        Set workFlow = null;
        Set mutex = new HashSet();
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        BgSchemeInfo schemeInfo = null;
        BgAuditIdeaInfo ideaInfo = null;
        BgAuditIdeaInfo _tmpIdea = null;
        CoreBaseCollection ideas = new CoreBaseCollection();
        String schemeId = null;
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        UnionElimDataUtils utils = new UnionElimDataUtils(pool);
        try {
            conn = this.getConnection(ctx);
            ideaInfo = idea instanceof BgAuditIdeaInfo ? idea : new BgAuditIdeaInfo();
            ideaInfo.setState(isDoAudit ? BgAuditIdeaEnum.AUDITPASS : BgAuditIdeaEnum.UNAUDIT);
            if (ideaInfo.getCreator() == null) {
                ideaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            if (ideaInfo.getCreateTime() == null) {
                ideaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            }
            if (isReqMutex) {
                mutex = MBgCheckHelper.requestMutex((Context)ctx, (List)idList, (boolean)true);
            }
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, (Collection)idList);
            logger.error((Object)("idList size :" + idList.size()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setSelector(this.getSelectors());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            BgCslElimCollection elimCol = BgCslElimFactory.getLocalInstance(ctx).getBgCslElimCollection(viewInfo);
            logger.error((Object)("BgcslElimCollection size :" + elimCol.size()));
            BgCslElimInfo elimInfo = null;
            BgCslElimCollection auditCol = new BgCslElimCollection();
            for (int i = 0; i < elimCol.size(); ++i) {
                elimInfo = elimCol.get(i);
                billId = elimInfo.getId().toString();
                schemeId = elimInfo.getBgScheme().getId().toString();
                if (mutex.contains(billId) || workFlow.contains(billId)) {
                    if (mutex.contains(billId)) {
                        mutexMap.put(billId, new String[]{elimInfo.getNumber()});
                        continue;
                    }
                    if (!workFlow.contains(billId)) continue;
                    workFlowMap.put(billId, new String[]{elimInfo.getNumber()});
                    continue;
                }
                if (isDoAudit && elimInfo.getStatus() == ElimStatusEnum.AUDITED) {
                    stateMap.put(billId, new String[]{elimInfo.getNumber()});
                    continue;
                }
                if (!isDoAudit && elimInfo.getStatus() == ElimStatusEnum.UNAUDITED) {
                    stateMap.put(billId, new String[]{elimInfo.getNumber()});
                    continue;
                }
                auditCol.add(elimInfo);
            }
            schemeInfo = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeInfo((IObjectPK)new ObjectStringPK(schemeId), BgSchemeUtils.getSelectors());
            if (auditCol.size() > 0) {
                utils.audit(ctx, conn, schemeInfo, (IObjectCollection)auditCol, null, result, isDoAudit);
                _tmpIdea = ideaInfo.getClone();
                _tmpIdea.setFormId(BOSUuid.read((String)billId));
                ideas.add((CoreBaseInfo)_tmpIdea);
            }
            if (!ideas.isEmpty()) {
                BgAuditIdeaFactory.getLocalInstance((Context)ctx).addnewBatchData(ideas);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            idList.removeAll(mutex);
            MBgCheckHelper.releaseMutex((Context)ctx, (List)idList);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        return result;
    }

    @Override
    protected Map<String, Map<String, String[]>> _batchUnAudit(Context ctx, Map param) throws BOSException, EASBizException {
        if (param != null) {
            param.put("isDoAudit", Boolean.FALSE);
        }
        return this._batchAudit(ctx, param);
    }

    private String genItemFormula(BgCslElimInfo info, BgCslElimEntryInfo entry) {
        return BgCslElimHelper.getItemFormula(info, entry);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslElimInfo info = (BgCslElimInfo)model;
        if (info.getNumber() != null && info.getNumber().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERTOOLONG);
        }
        this.checkDupNumber(ctx, info.getNumber(), info.getId() == null ? null : info.getId().toString(), info.getOrgUnit().getId().toString(), info.getBgScheme().getId().toString());
        return super._save(ctx, model);
    }

    private void beforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        BgCslElimInfo info = (BgCslElimInfo)model;
        int c = info.getEntries().size();
        for (int i = 0; i < c; ++i) {
            BgCslElimEntryInfo entry = info.getEntries().get(i);
            entry.setItemFormula(this.genItemFormula(info, entry));
        }
    }

    private EntityViewInfo getViewInfo(List<String> idList) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(idList)));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("status"));
        view.getSelector().add(new SelectorItemInfo("elimType"));
        view.getSelector().add(new SelectorItemInfo("memberCombinNumber"));
        view.getSelector().add(new SelectorItemInfo("memberCombinName"));
        view.getSelector().add(new SelectorItemInfo("memberCombinRef"));
        view.getSelector().add(new SelectorItemInfo("bgScheme.id"));
        view.getSelector().add(new SelectorItemInfo("bgScheme.number"));
        view.getSelector().add(new SelectorItemInfo("bgScheme.refCube"));
        view.getSelector().add(new SelectorItemInfo("orgTree.id"));
        view.getSelector().add(new SelectorItemInfo("orgTree.number"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.number"));
        view.getSelector().add(new SelectorItemInfo("currency.id"));
        view.getSelector().add(new SelectorItemInfo("currency.number"));
        view.getSelector().add(new SelectorItemInfo("bgVersion.id"));
        view.getSelector().add(new SelectorItemInfo("bgVersion.number"));
        view.getSelector().add(new SelectorItemInfo("bgVersion.versionId"));
        view.getSelector().add(new SelectorItemInfo("bgScenario.id"));
        view.getSelector().add(new SelectorItemInfo("bgScenario.number"));
        view.getSelector().add(new SelectorItemInfo("bgScenario.scenarioId"));
        view.getSelector().add(new SelectorItemInfo("bgElement.id"));
        view.getSelector().add(new SelectorItemInfo("bgElement.number"));
        view.getSelector().add(new SelectorItemInfo("bgPeriod.id"));
        view.getSelector().add(new SelectorItemInfo("bgPeriod.number"));
        view.getSelector().add(new SelectorItemInfo("template.id"));
        view.getSelector().add(new SelectorItemInfo("template.number"));
        view.getSelector().add(new SelectorItemInfo("template.name"));
        view.getSelector().add(new SelectorItemInfo("entries.*"));
        return new EntityViewInfo();
    }

    @Override
    protected IObjectValue _copy(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgCslElimInfo info = this.getBgCslElimInfo(ctx, pk, BgCslElimControllerBean.getCslElimFullSelector());
        info = (BgCslElimInfo)info.clone();
        info.remove("id");
        info.remove("number");
        BgCslElimEntryCollection entries = info.getEntries();
        BgCslElimEntryInfo entry = new BgCslElimEntryInfo();
        for (int i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            entry.remove("id");
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
        }
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setStatus(ElimStatusEnum.UNAUDITED);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, info.getOrgUnit().getId().toString());
        return info;
    }

    public static final SelectorItemCollection getCslElimFullSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("template.*"));
        sic.add(new SelectorItemInfo("elimType"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("memberCombinName"));
        sic.add(new SelectorItemInfo("memberCombinNumber"));
        sic.add(new SelectorItemInfo("memberCombinRef"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bgScenario.id"));
        sic.add(new SelectorItemInfo("bgScenario.number"));
        sic.add(new SelectorItemInfo("bgScenario.name"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("bgElement.id"));
        sic.add(new SelectorItemInfo("bgElement.number"));
        sic.add(new SelectorItemInfo("bgElement.name"));
        sic.add(new SelectorItemInfo("bgPeriod.id"));
        sic.add(new SelectorItemInfo("bgPeriod.number"));
        sic.add(new SelectorItemInfo("bgPeriod.name"));
        sic.add(new SelectorItemInfo("bgVersion.id"));
        sic.add(new SelectorItemInfo("bgVersion.number"));
        sic.add(new SelectorItemInfo("bgVersion.name"));
        sic.add(new SelectorItemInfo("entries.summary"));
        sic.add(new SelectorItemInfo("entries.indexMemberName"));
        sic.add(new SelectorItemInfo("entries.indexMemberNumber"));
        sic.add(new SelectorItemInfo("entries.indexMemberRef"));
        sic.add(new SelectorItemInfo("entries.memberCombinName"));
        sic.add(new SelectorItemInfo("entries.memberCombinNumber"));
        sic.add(new SelectorItemInfo("entries.memberCombinRef"));
        sic.add(new SelectorItemInfo("entries.debitAmount"));
        sic.add(new SelectorItemInfo("entries.debitFormula"));
        sic.add(new SelectorItemInfo("entries.creditAmount"));
        sic.add(new SelectorItemInfo("entries.creditFormula"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("creator.id"));
        return sic;
    }

    @Override
    protected IObjectCollection _getCostOrgUnits(Context ctx, String orgTreeId, String unitId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)orgTreeId) || StringUtils.isEmpty((String)unitId)) {
            return null;
        }
        IOrgStructure iStruc = OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeId));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitId));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("longnumber"));
        view.getSelector().add(new SelectorItemInfo("name"));
        OrgStructureCollection structInfos = iStruc.getOrgStructureCollection(view);
        OrgStructureInfo strucInfo = null;
        if (structInfos == null || structInfos.isEmpty()) {
            return null;
        }
        strucInfo = structInfos.get(0);
        String language = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select unit.FID unitId,  unit.FNAME_").append(language).append(" unitName, unit.FNumber unitNumber, unit.FSimpleName unitSimpleName, unit.FLongNumber unitLongNumber, unit.FIsGrouping unitGrouping").append(" From t_org_baseunit unit ").append(" inner join t_org_structure struct on unit.fid = struct.funitid").append(" where struct.ftreeid = '" + orgTreeId + "' ").append(" and unit.fisunion = 0 ").append(" and struct.FLONGNUMBER LIKE '" + strucInfo.getLongNumber() + "%' ").append(" ORDER BY unit.FNUMBER ASC ");
        CostCenterOrgUnitCollection colls = new CostCenterOrgUnitCollection();
        CostCenterOrgUnitInfo info = null;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                info = new CostCenterOrgUnitInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("unitId")));
                info.setNumber(rowSet.getString("unitNumber"));
                info.setName(rowSet.getString("unitName"));
                info.setLongNumber(rowSet.getString("unitLongNumber"));
                colls.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return colls;
    }

    private String createDefaultNumber() {
        String str = String.valueOf(new Date().getTime());
        if (str.length() > 6) {
            str = str.substring(str.length() - 7, str.length() - 1);
        }
        return "TZ" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_" + str;
    }
}

