/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.dynbusiness.adv.chain.StringUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.bgcsl.BgCslElimCollection;
import com.kingdee.eas.ma.bgcsl.BgCslElimEntryCollection;
import com.kingdee.eas.ma.bgcsl.BgCslElimEntryInfo;
import com.kingdee.eas.ma.bgcsl.BgCslElimFactory;
import com.kingdee.eas.ma.bgcsl.BgCslElimInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateInfo;
import com.kingdee.eas.ma.bgcsl.ElimStatusEnum;
import com.kingdee.eas.ma.bgcsl.ElimTypeEnum;
import com.kingdee.eas.ma.bgcsl.IBgCslElim;
import com.kingdee.eas.ma.bgcsl.IBgCslOffsetEntryTemplate;
import com.kingdee.eas.ma.bgcsl.app.BgCslElimBaseImportData;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgCslElimImportData
extends BgCslElimBaseImportData {
    private static Logger logger = Logger.getLogger(BgCslElimImportData.class);

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BgCslElimFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FTemplate_number", rs.getString("template.number"));
            this.putTable(result, "FTemplate_name", rs.getString("template.name"));
            this.putTable(result, "FElimType", ElimTypeEnum.getEnum(rs.getInt("elimType")) != null ? ElimTypeEnum.getEnum(rs.getInt("elimType")).getAlias() : null);
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FCurrency_name_l2", rs.getString("currency.name"));
            this.putTable(result, "FBgVersion_number", rs.getString("bgVersion.number"));
            this.putTable(result, "FBgVersion_name_l2", rs.getString("bgVersion.name"));
            this.putTable(result, "FBgScenario_number", rs.getString("bgScenario.number"));
            this.putTable(result, "FBgScenario_name_l2", rs.getString("bgScenario.name"));
            this.putTable(result, "FBgElement_number", rs.getString("bgElement.number"));
            this.putTable(result, "FBgElement_name_l2", rs.getString("bgElement.name"));
            this.putTable(result, "FBgPeriod_number", rs.getString("bgPeriod.number"));
            this.putTable(result, "FBgPeriod_name_l2", rs.getString("bgPeriod.name"));
            this.putTable(result, "FMemberCombinNumber", rs.getString("memberCombinNumber"));
            this.putTable(result, "FMemberCombinName", rs.getString("memberCombinName"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FEntries_summary", rs.getString("entries.summary"));
            this.putTable(result, "FEntries_indexMemberNumber", rs.getString("entries.indexMemberNumber"));
            this.putTable(result, "FEntries_indexMemberName", rs.getString("entries.indexMemberName"));
            this.putTable(result, "FEntries_memberCombinNumber", rs.getString("entries.memberCombinNumber"));
            this.putTable(result, "FEntries_memberCombinName", rs.getString("entries.memberCombinName"));
            this.putTable(result, "FEntries_debitAmount", rs.getString("entries.debitAmount"));
            this.putTable(result, "FEntries_creditAmount", rs.getString("entries.creditAmount"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    protected void setNumberByCodeRule(Context ctx, BgCslElimInfo info, String number) throws Exception {
        String imUnitID = this.orgUnitInfo.getId().toString();
        if (null == imUnitID) {
            throw new TaskExternalException(BgCslElimImportData.getResource("OrgUnit_NULL", ctx));
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, imUnitID)) {
            String numberStr = iCodingRuleManager.getNumber((IObjectValue)info, imUnitID, "");
            info.setNumber(numberStr);
        } else if (!StringUtils.isEmpty((String)number)) {
            info.setNumber(number);
        }
    }

    @Override
    protected CoreBaseInfo transmitnew(Hashtable hsData, Context ctx) throws Exception {
        BgCslElimCollection collection;
        String ksql;
        Object contextNumSet = this.getContextParameter("number_Set");
        HashSet<String> numberSet = null;
        if (contextNumSet != null && contextNumSet instanceof HashSet) {
            numberSet = (HashSet<String>)contextNumSet;
        }
        String number = this.getData("FNumber", (Hashtable)hsData.get(0)).toString();
        BgCslElimInfo info = new BgCslElimInfo();
        boolean isNumberNull = StringUtil.isEmpty((String)number);
        TaskExternalCode task = TaskTemplateAdapter.getTaskExternalCode((String)"eas.ma.bgcsl.BgCslElim", (Context)ctx);
        DIETemplateInfo dieTemplateInfo = task.getDIETemplateInfo();
        Object fieldentries = dieTemplateInfo.get("fieldentries");
        DIETemplateFieldEntryCollection entrys = null;
        if (fieldentries != null && fieldentries instanceof DIETemplateFieldEntryCollection) {
            entrys = (DIETemplateFieldEntryCollection)fieldentries;
            DIETemplateFieldEntryInfo entryItem = null;
            Boolean isNeed = null;
            String entryItemNumber = null;
            Object numberObj = null;
            Object hasDataItemObj = null;
            Object filedObj = null;
            StringBuilder errorMessage = new StringBuilder();
            for (int i = 0; i < entrys.size(); ++i) {
                entryItem = entrys.get(i);
                isNeed = (Boolean)entryItem.get("isneed");
                if (!isNeed.booleanValue()) continue;
                numberObj = entryItem.get("number");
                String string = entryItemNumber = numberObj != null ? numberObj.toString() : null;
                if (StringUtil.isEmpty((String)entryItemNumber)) continue;
                for (int j = 0; j < hsData.size(); ++j) {
                    hasDataItemObj = hsData.get(j);
                    if (hasDataItemObj == null || !(hasDataItemObj instanceof Hashtable) || (filedObj = ((Hashtable)hasDataItemObj).get(entryItemNumber)) == null || !(filedObj instanceof DataToken) || ((DataToken)filedObj).data != null && !StringUtil.isEmpty((String)((String)((DataToken)filedObj).data))) continue;
                    errorMessage.append(ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"objectIsNull", (Locale)ctx.getLocale(), (Object[])new Object[]{j + 5, ((DataToken)filedObj).desc}) + "\n");
                }
            }
            if (errorMessage.length() > 0) {
                throw new TaskExternalException(errorMessage.toString());
            }
        }
        HashSet<String> memberNumbers = new HashSet<String>();
        IBgCslElim iElim = BgCslElimFactory.getLocalInstance(ctx);
        BgCslElimEntryCollection clone = null;
        for (int i = 0; i < hsData.size(); ++i) {
            this.collectionMemberNumber((String)this.getData("FMemberCombinNumber", (Hashtable)hsData.get(i)), memberNumbers);
            this.collectionMemberNumber((String)this.getData("FEntries_indexMemberNumber", (Hashtable)hsData.get(i)), memberNumbers);
            this.collectionMemberNumber((String)this.getData("FEntries_memberCombinNumber", (Hashtable)hsData.get(i)), memberNumbers);
        }
        this.checkMemberExist(ctx, memberNumbers);
        if (!this.isSltImportUpdate()) {
            ksql = "where number='" + number + "' and bgScheme.id = '" + this.bgSchemeInfo.getId().toString() + "' and orgTree.id = '" + this.orgTreeInfo.getId().toString() + "' and orgUnit.id = '" + this.orgUnitInfo.getId().toString() + "'";
            collection = iElim.getBgCslElimCollection(ksql);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
                if (numberSet == null) {
                    numberSet = new HashSet<String>();
                    numberSet.add(info.getNumber());
                }
            }
            if (numberSet != null && numberSet.contains(number)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslElimResource", (String)"numIsExistNoImport", (Locale)ctx.getLocale(), (Object[])new Object[]{number}));
            }
            if (info != null && ElimStatusEnum.AUDITED.equals((Object)info.getStatus())) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"elimIsAudited", (Locale)ctx.getLocale(), (Object[])new Object[]{number}));
            }
            this.setNumberByCodeRule(ctx, info, number);
            info = this.setHeadInfo(ctx, info, (Hashtable)hsData.get(0));
            this.collectionMemberNumber(info.getMemberCombinNumber(), memberNumbers);
            for (int i = 0; i < hsData.size(); ++i) {
                BgCslElimEntryInfo entryInfo = new BgCslElimEntryInfo();
                entryInfo.setElimination(info);
                this.setEntryInfo(ctx, entryInfo, (Hashtable)hsData.get(i));
                info.getEntries().add(entryInfo);
                this.collectionMemberNumber(entryInfo.getIndexMemberNumber(), memberNumbers);
                this.collectionMemberNumber(entryInfo.getMemberCombinNumber(), memberNumbers);
                this.checkDimMatch(ctx, info, entryInfo);
            }
        } else if (!isNumberNull) {
            ksql = "where number='" + number + "' and bgScheme.id = '" + this.bgSchemeInfo.getId().toString() + "' and orgTree.id = '" + this.orgTreeInfo.getId().toString() + "' and orgUnit.id = '" + this.orgUnitInfo.getId().toString() + "'";
            collection = iElim.getBgCslElimCollection(ksql);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
            if (info != null && ElimStatusEnum.AUDITED.equals((Object)info.getStatus())) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"elimIsAudited", (Locale)ctx.getLocale(), (Object[])new Object[]{number}));
            }
            if (StringUtils.isEmpty((String)(info = this.setHeadInfo(ctx, info, (Hashtable)hsData.get(0))).getNumber())) {
                this.setNumberByCodeRule(ctx, info, number);
            }
            this.collectionMemberNumber(info.getMemberCombinNumber(), memberNumbers);
            clone = new BgCslElimEntryCollection();
            BgCslElimEntryCollection entries = info.getEntries();
            for (int j = 0; j < entries.size(); ++j) {
                clone.add(entries.get(j));
            }
            for (int i = 0; i < hsData.size(); ++i) {
                BgCslElimEntryInfo entryInfo = new BgCslElimEntryInfo();
                entryInfo.setElimination(info);
                this.setEntryInfo(ctx, entryInfo, (Hashtable)hsData.get(i));
                info.getEntries().add(entryInfo);
                this.collectionMemberNumber(entryInfo.getIndexMemberNumber(), memberNumbers);
                this.collectionMemberNumber(entryInfo.getMemberCombinNumber(), memberNumbers);
                this.checkDimMatch(ctx, info, entryInfo);
            }
        } else {
            throw new TaskExternalException(BgCslElimImportData.getResource("NUMBER_NULL", ctx));
        }
        this.checkMemberExist(ctx, memberNumbers);
        this.checkSpeicalDim(ctx, info);
        if (this.isSltImportUpdate() && !isNumberNull && clone != null && clone.size() < info.getEntries().size()) {
            for (int i = clone.size() - 1; i >= 0; --i) {
                if (!info.getEntries().contains(clone.get(i))) continue;
                info.getEntries().remove(clone.get(i));
            }
        }
        return info;
    }

    private void setEntryInfo(Context ctx, BgCslElimEntryInfo entryInfo, Hashtable hsData) throws Exception {
        String dc;
        String da;
        String summary = (String)this.getData("FEntries_summary", hsData);
        entryInfo.setSummary(summary);
        String accNumber = (String)this.getData("FEntries_indexMemberNumber", hsData);
        String accName = (String)this.getData("FEntries_indexMemberName", hsData);
        accName = (String)this.memberCacheMap.get(accNumber);
        String accRef = "F2";
        if (null == accNumber || null == accName || null == accRef) {
            throw new TaskExternalException(BgCslElimImportData.getResource("BgAccount_NULL", ctx));
        }
        BgDimensionMember account = new BgDimensionMember("BG_Account", accRef, accName, accNumber);
        entryInfo.setIndexMemberName(account.getName());
        entryInfo.setIndexMemberNumber(account.getNumber());
        entryInfo.setIndexMemberRef(account.getAttribute());
        String dimNumber = (String)this.getData("FEntries_memberCombinNumber", hsData);
        String dimName = (String)this.getData("FEntries_memberCombinName", hsData);
        String dimRef = this.getDimRef(dimNumber);
        if (null != dimNumber && null != dimName && null != dimRef) {
            entryInfo.setMemberCombinName(dimName);
            entryInfo.setMemberCombinNumber(dimNumber);
            entryInfo.setMemberCombinRef(dimRef);
        }
        if (this.getData("FEntries_debitAmount", hsData) instanceof String && !StringUtils.isEmpty((String)(da = (String)this.getData("FEntries_debitAmount", hsData)))) {
            try {
                BigDecimal debitAmount = new BigDecimal((String)this.getData("FEntries_debitAmount", hsData));
                entryInfo.setDebitAmount(debitAmount);
            }
            catch (NumberFormatException e) {
                throw new TaskExternalException(BgCslElimImportData.getResource("amountIsBigDecimal", ctx));
            }
        }
        if (this.getData("FEntries_creditAmount", hsData) != null && this.getData("FEntries_creditAmount", hsData) instanceof String && !StringUtils.isEmpty((String)(dc = (String)this.getData("FEntries_creditAmount", hsData)))) {
            try {
                BigDecimal creditAmount = new BigDecimal((String)this.getData("FEntries_creditAmount", hsData));
                entryInfo.setCreditAmount(creditAmount);
            }
            catch (NumberFormatException e) {
                throw new TaskExternalException(BgCslElimImportData.getResource("amountIsBigDecimal", ctx));
            }
        }
        if (entryInfo.getDebitAmount() != null && entryInfo.getCreditAmount() != null) {
            throw new TaskExternalException(BgCslElimImportData.getResource("debitAndCreditAllFull", ctx));
        }
    }

    protected BgCslElimInfo setHeadInfo(Context ctx, BgCslElimInfo info, Hashtable hsData) throws Exception {
        Object data = null;
        data = this.getData("FElimType", hsData);
        ElimTypeEnum enumType = this.getElimiEnumByAlias(String.valueOf(data), ctx.getOriginLocale());
        info.setElimType(enumType);
        String description = (String)this.getData("FDescription", hsData);
        info.setDescription(description);
        info.setBgScheme(this.bgSchemeInfo);
        info.setOrgTree(this.orgTreeInfo);
        info.setOrgUnit(this.orgUnitInfo);
        info.setStatus(ElimStatusEnum.UNAUDITED);
        this.setBgPeriodInfo(ctx, info, hsData, true);
        this.setBgVersion(ctx, info, hsData, true);
        this.setBgElement(ctx, info, hsData, true);
        this.setBgScenario(ctx, info, hsData, true);
        this.setCurrency(ctx, info, hsData, true);
        this.setHeadMember(ctx, info, hsData);
        String template = (String)this.getData("FTemplate_number", hsData);
        info.setTemplate(this.getTemplateInfo(ctx, template));
        return info;
    }

    private BgCslOffsetEntryTemplateInfo getTemplateInfo(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        IBgCslOffsetEntryTemplate ioffset = BgCslOffsetEntryTemplateFactory.getLocalInstance(ctx);
        BgCslOffsetEntryTemplateInfo offsetInfo = new BgCslOffsetEntryTemplateInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.bgSchemeInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)this.orgTreeInfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.orgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        BgCslOffsetEntryTemplateCollection offsetCol = ioffset.getBgCslOffsetEntryTemplateCollection(view);
        if (null != offsetCol && !offsetCol.isEmpty()) {
            offsetInfo = offsetCol.get(0);
        }
        return offsetInfo;
    }
}

