/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.check.ReportCheck;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgRefDimMemberEnum;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslException;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormMeasureUnitInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormStateEnum;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsInfo;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupCollection;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialRelationGroupInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemMeasureUnitCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemMeasureUnitInfo;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslViewListFormFacadeFactory;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BizRefCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperException;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslFormControllerBean;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslBackSaveCaller;
import com.kingdee.eas.ma.bgcsl.utils.BgCslDimensionMemberCheckFactory;
import com.kingdee.eas.ma.bgcsl.utils.BgCslRptReportPropertyAdapter;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslTemplateSequenceSetHelper;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionDataUtils;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcQuery;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellCollection;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgClosureMapUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.ma.mbg.utils.MBgPeriodVariable;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslFormControllerBean
extends AbstractBgCslFormControllerBean {
    private static final long serialVersionUID = 2402810451993491323L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslFormControllerBean");
    public static final String BG_SPECIAL_ITEMS = "bgSpecialItems";
    private static final int orgFlag = 1;
    private static final int temFlag = 2;
    private static final int perFlag = 3;
    private static final int verFlag = 4;
    private static final int curFlag = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslFormInfo info = (BgCslFormInfo)model;
        IObjectPK pk = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            this.checkBgPeriodIsAcross(ctx, info);
            this.checkFormNumber(conn, info);
            pk = super._addnew(ctx, model);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(pk.toString());
            MbgViewListFormServerHelper.saveDesCellByIds((Context)ctx, (Connection)conn, ids, (String)info.getBgCslTemplate().getId().toString());
            AttachmentServerManager attachmentServerManager = AttachmentManagerFactory.getServerManager((Context)ctx);
            attachmentServerManager.copyBizAttachmentFiles(info.getBgCslTemplate().getId().toString(), info.getId().toString());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return pk;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkFormNumber(Connection conn, BgCslFormInfo model) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_MBg_BgCslForm where FNumber = ? and FOrgUnitID = ? and FID <> ? and FBgSchemeId = ? and FOrgTreeId = ? ");
            pstmt.setString(1, model.getNumber());
            pstmt.setString(2, model.getOrgUnit().getId().toString());
            pstmt.setString(3, model.getId().toString());
            pstmt.setString(4, model.getBgScheme().getId().toString());
            pstmt.setString(5, model.getOrgTree().getId().toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new BgCslException(BgCslException.NUMBERREPEAT, new String[]{model.getNumber()});
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgCslFormInfo _bgFormInfo = (BgCslFormInfo)model;
        try {
            this.getBudgetSheet(ctx, _bgFormInfo);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        BgViewServerHelper.removeStateLock((ReportBaseInfo)_bgFormInfo);
        super._update(ctx, pk, model);
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        BgCslFormInfo info = null;
        try {
            info = (BgCslFormInfo)this._getValue(ctx, "select state where id = '" + pk + "'");
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new CanNotDeleteException((Throwable)e);
        }
        if (info != null && info.getState().getValue() != 1) {
            throw new CanNotDeleteException(ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"canntDeleteState", (Locale)ctx.getLocale()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        Object imsc = null;
        IEnactmentService iems = EnactmentServiceFactory.createEnactService((Context)ctx);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            List<BgCslFormInfo> bgCslForms = MbgCslDataHelper.getBgCslFormInfo(ctx, conn, ids);
            if (bgCslForms != null) {
                for (BgCslFormInfo bgCslForm : bgCslForms) {
                    String str1 = bgCslForm.getOrgUnit().getNumber() + "(" + bgCslForm.getOrgUnit().getName() + ")";
                    String str2 = bgCslForm.getNumber() + "(" + bgCslForm.getName() + ")";
                    if (1 != bgCslForm.getState().getValue()) {
                        throw new MbgWorkPaperException(MbgWorkPaperException.CANNTCSLREMOVENEW, new Object[]{str1, str2});
                    }
                    String[] bgFormIds = new String[ids.size()];
                    int n = ids.size();
                    for (int i = 0; i < n; ++i) {
                        bgFormIds[i] = (String)ids.get(i);
                    }
                    if ((bgFormIds = iems.checkBizObjInWfProcess(bgFormIds)) == null || bgFormIds.length <= 0) continue;
                    throw new MbgWorkPaperException(MbgWorkPaperException.CANNTCSLREMOVENEW, new Object[]{str1, str2});
                }
            }
            this.deleteOtherData(ctx, conn, ids, bgCslForms);
        }
        catch (SQLException e) {
            logger.error((Object)"sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            if (imsc != null) {
                imsc.releaseObjIDForUpdate(pk.toString());
            }
        }
        super._delete(ctx, pk);
    }

    private void deleteOtherData(Context ctx, Connection conn, List<String> ids, List<BgCslFormInfo> bgCslForms) throws SQLException, BOSException, EASBizException {
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_RPT_RptSheetPara where FReportID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_RPT_RptPostil where FReportID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgCurrency where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgElement where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgScenario where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgPeriod where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgRefBgItemCombin where FBgFormID = ?", ids);
        MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_BgCslFormMeasureUnit where FBgCslFormId = ?", ids);
        this.clearBgData(ctx, conn, ids);
        BgFacadeHelper.deleteRef((Context)ctx, ids);
        for (BgCslFormInfo info : bgCslForms) {
            MbgViewListDescriptionHelper.clearViewlistDesEntries((Connection)conn, (IDimDataQuery)info);
            MbgViewListDescriptionHelper.clearEditNote((Connection)conn, (IDimDataQuery)info);
            MbgViewListDescriptionHelper.clearBgCommentRef((Connection)conn, (IDimDataQuery)info);
        }
    }

    private void clearBgData(Context ctx, Connection conn, List<String> ids) throws BOSException {
        final HashMap cube_ids = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("Select bgForm.FID, bgScheme.FRefCube FROM T_MBg_BgCslForm bgForm LEFT JOIN T_MBg_BgScheme bgScheme ON bgForm.FBgSchemeId = bgScheme.FID Where bgForm.FID IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])ids.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String cubeName = res.getString("FRefCube");
                String id = res.getString("FID");
                if (!cube_ids.containsKey(cubeName)) {
                    cube_ids.put(cubeName, new ArrayList());
                }
                ((List)cube_ids.get(cubeName)).add(id);
            }
        });
        String cubeName2 = null;
        String cslCubeName = null;
        String cslEntryCubeName = null;
        String cslCacheName = null;
        String cslECacheName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTable = null;
        try {
            tempTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FDataID VARCHAR(44), FFormID VARCHAR(44))");
            if (tempTable == null) {
                return;
            }
            for (String cubeName2 : cube_ids.keySet()) {
                ids = (List)cube_ids.get(cubeName2);
                cslCubeName = BgCubeUtils.getCFSCubeName((String)cubeName2);
                cslEntryCubeName = BgCubeUtils.getCFSEntryCubeName((String)cubeName2);
                MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempTable));
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempTable + " (FDataID, FFormId) Select FDataID, FFormId from " + cslEntryCubeName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.executeBatch((Connection)conn, (String)("delete " + cslEntryCubeName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + tempTable + " where exists (select FDataID from " + cslEntryCubeName + " where FDataID = " + tempTable + ".FDataID)"));
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + cslCubeName + " where FID IN (select FDataID from " + tempTable + ") and (FState = " + 1 + " OR FState = " + 3 + ")"));
                if (BgDBUtils.existTable((Connection)conn, cslCacheName) != BgDBUtils.YES || BgDBUtils.existTable((Connection)conn, cslECacheName) != BgDBUtils.YES) continue;
                MbgSqlHelper.execute((Connection)conn, (String)("TRUNCATE TABLE " + tempTable));
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempTable + " (FDataID) Select FDataID from " + cslECacheName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.executeBatch((Connection)conn, (String)("delete " + cslECacheName + " where FFormId = ?"), (List)ids);
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + tempTable + " where exists (select FDataID from " + cslECacheName + " where FDataID = " + tempTable + ".FDataID)"));
                MbgSqlHelper.execute((Connection)conn, (String)("delete " + cslCacheName + " where FID IN (select FDataID from " + tempTable + ")"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTable != null) {
                try {
                    pool.releaseTable(tempTable);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void getBudgetSheet(Context ctx, BgCslFormInfo _bgFormInfo) throws Exception {
        Book book = _bgFormInfo.getBook();
        if (book == null) {
            return;
        }
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        _endTime = _startTime;
        logger.info((Object)"invoke begin save bgData!");
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        HashMap<String, Map<String, IBgNData>> indvDatas = new HashMap<String, Map<String, IBgNData>>();
        HashMap<String, BgNDataInfo> subDatas = new HashMap<String, BgNDataInfo>();
        indvDatas.put(_bgFormInfo.getOrgUnit().getId().toString(), subDatas);
        Sheet _sheet = null;
        Cell _cell = null;
        BigDecimal budgetValue = null;
        String formulaStr = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            _sheet = book.getSheet(s);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    try {
                        budgetValue = (BigDecimal)BgNFSHelper.getValue((Cell)_cell);
                    }
                    catch (Exception ex) {
                        budgetValue = BgNConstants.ZERO;
                    }
                    subDatas.put(formulaStr, this.addBaseValue(ctx, _cell, formulaStr, _bgFormInfo.getBgVersion().getNumber(), budgetValue));
                }
            }
        }
        UnionDataUtils.getIntance().saveIndvData(ctx, _bgFormInfo.getId(), _bgFormInfo.getBgScheme().getId(), _bgFormInfo.getOrgTree().getId(), ContextUtil.getCurrentUserInfo((Context)ctx).getId(), indvDatas, null);
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end save bgData!");
    }

    private BgNDataInfo addBaseValue(Context ctx, Cell cell, String formula, String version, BigDecimal value) throws EASBizException, BOSException {
        BgNDataInfo _dataInfo = null;
        if (!StringUtils.isEmpty((String)formula)) {
            _dataInfo = new BgNDataInfo();
            if (cell != null) {
                _dataInfo.setRow(cell.getRow());
                _dataInfo.setCol(cell.getCol());
            }
            _dataInfo.setFormula(formula);
            _dataInfo.setBgVersion(version);
            _dataInfo.splitFormula();
            if (this.isActData(ctx, _dataInfo.getBgScenario())) {
                _dataInfo.setBizActual(value);
            } else {
                _dataInfo.setBudgetValue(value);
            }
            this.parseBgFormula(_dataInfo);
        }
        return _dataInfo;
    }

    private boolean isActData(Context ctx, String bgScenarioNumber) throws BOSException {
        Map scenarioCache = BgDimCacheUtils.getScenarioCache((Context)ctx);
        if (scenarioCache != null && bgScenarioNumber != null && scenarioCache.containsKey(bgScenarioNumber)) {
            BgScenarioInfo scenario = (BgScenarioInfo)scenarioCache.get(bgScenarioNumber);
            int type = scenario.getType().getValue();
            if (0 == type) {
                return false;
            }
            if (1 == type) {
                return true;
            }
        }
        return false;
    }

    private void parseBgFormula(BgNDataInfo info) throws EASBizException {
        if (info != null && !StringUtils.isEmpty((String)info.getFormula())) {
            String[] _para = BgNFSHelper.parseFormulaPara((String)info.getFormula());
            BgNFSHelper.checkFormulaPara((String)info.getFormula(), (String[])_para);
            if (_para != null) {
                info.setBgItemNumber(_para[0]);
                info.setBgPeriodNumber(_para[1]);
                info.setBgElementNumber(_para[2]);
                info.setCurrencyNumber(_para[5]);
                info.setBgScenario(_para[3]);
            }
        }
    }

    @Override
    protected Map _audit(Context ctx, List idList, IObjectValue idea, String audOrgUnitId) throws BOSException, EASBizException {
        return this._batchAudit(ctx, idList, idea, false, audOrgUnitId);
    }

    @Override
    protected Map _batchAudit(Context ctx, List idList, IObjectValue idea, boolean isReqMutex, String audOrgUnitId) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (ctx == null || idList == null || idList.isEmpty()) {
            return result;
        }
        String billId = null;
        String cubeName = null;
        String cubeEntry = null;
        String unionId = null;
        BgSchemeInfo schemeInfo = null;
        BgAuditIdeaInfo ideaInfo = null;
        BgAuditIdeaInfo _tmpIdea = null;
        CoreBaseCollection ideas = new CoreBaseCollection();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        UnionDataUtils utils = UnionDataUtils.getIntance();
        Set workFlow = null;
        Set mutex = null;
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        Object templateSet = null;
        Object templateExSet = null;
        Map templateSetMap = new HashMap();
        Map templateExSetMap = new HashMap();
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            if (idea instanceof BgAuditIdeaInfo) {
                ideaInfo = (BgAuditIdeaInfo)idea;
            } else {
                ideaInfo = new BgAuditIdeaInfo();
                ideaInfo.setState(BgAuditIdeaEnum.AUDITPASS);
            }
            if (ideaInfo.getCreator() == null) {
                ideaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            if (ideaInfo.getCreateTime() == null) {
                ideaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            }
            mutex = isReqMutex ? MBgCheckHelper.requestMutex((Context)ctx, (List)idList, (boolean)true) : new HashSet();
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, (Collection)idList);
            List<BgCslFormInfo> cslForms = MbgCslDataHelper.getBgCslFormInfo(ctx, conn, idList);
            if (schemeInfo == null && cslForms != null && cslForms.size() > 0) {
                schemeInfo = MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)ctx.getLocale(), (BOSUuid)cslForms.get(0).getBgScheme().getId());
                cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
                cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
            }
            String nullStr = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"nullStr", (Locale)ctx.getLocale());
            Map<String, Object> checkListMap = BgCslTemplateSequenceSetHelper.checkBgTemplateSequenceSet(ctx, conn, idList, cslForms, schemeInfo, 0);
            templateSetMap = (Map)checkListMap.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET");
            templateExSetMap = (Map)checkListMap.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX");
            BgClosureMapUtils bgClosureMapUtils = new BgClosureMapUtils(schemeInfo, conn);
            Map closureMap = bgClosureMapUtils.getClosureMap();
            utils.setClosureMap(closureMap);
            for (BgCslFormInfo cslForm : cslForms) {
                billId = cslForm.getId().toString();
                String orgStr = cslForm.getOrgUnit().getNumber() + "(" + cslForm.getOrgUnit().getName() + ")";
                String formStr = cslForm.getNumber() + "(" + cslForm.getName() + ")";
                Boolean BGCSLFORM_WORKING_OPEN = false;
                if (ctx.get((Object)"BGCSLFORM_WORKING_OPEN") instanceof Boolean && ((Boolean)ctx.get((Object)"BGCSLFORM_WORKING_OPEN")).booleanValue()) {
                    BGCSLFORM_WORKING_OPEN = (Boolean)ctx.get((Object)"BGCSLFORM_WORKING_OPEN");
                }
                if (1 == cslForm.getState().getValue() || BgFormHelper.checkInProInst((Context)ctx, (String)billId) && BGCSLFORM_WORKING_OPEN.booleanValue() && 14 == cslForm.getState().getValue()) {
                    unionId = cslForm.getOrgTree().getId().toString();
                    if (mutex.contains(billId) || workFlow.contains(billId) && !BgCslFormStateEnum.APPROVING.equals((Object)cslForm.getState()) || templateSetMap.containsKey(billId) || templateExSetMap.containsKey(billId)) {
                        if (mutex.contains(billId)) {
                            mutexMap.put(billId, new String[]{orgStr, formStr});
                            continue;
                        }
                        if (workFlow.contains(billId) && !BgCslFormStateEnum.APPROVING.equals((Object)cslForm.getState())) {
                            workFlowMap.put(billId, new String[]{orgStr, formStr});
                            continue;
                        }
                        if (templateSetMap.containsKey(billId) || templateExSetMap.containsKey(billId)) continue;
                    }
                    utils.auditCsl08(ctx, pool, cslForm, schemeInfo, audOrgUnitId);
                    BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgCslForm set FState = ?, FAuditorID = ?, FAuditedTime = ? where FID = ?", (Object[])new Object[]{2, userId, time, billId});
                    _tmpIdea = ideaInfo.getClone();
                    _tmpIdea.setFormId(BOSUuid.read((String)billId));
                    ideas.add((CoreBaseInfo)_tmpIdea);
                    continue;
                }
                stateMap.put(billId, new String[]{orgStr, formStr});
            }
            if (!ideas.isEmpty()) {
                BgAuditIdeaFactory.getLocalInstance((Context)ctx).addnewBatchData(ideas);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"cslForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            idList.removeAll(mutexMap.keySet());
            MBgCheckHelper.releaseMutex((Context)ctx, (List)idList);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        result.put("CHECK_RESULT_BGTEMPLATE_SEQUENCESET", templateSetMap);
        result.put("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX", templateExSetMap);
        return result;
    }

    @Override
    protected Map _unAudit(Context ctx, List idList, IObjectValue idea) throws BOSException, EASBizException {
        return this._batchUnAudit(ctx, idList, idea, false);
    }

    @Override
    public Map _batchUnAudit(Context ctx, List idList, IObjectValue idea, boolean isReqMutex) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (ctx == null || idList == null || idList.isEmpty()) {
            return result;
        }
        BgAuditIdeaInfo ideaInfo = null;
        BgAuditIdeaInfo _tmpIdea = null;
        CoreBaseCollection ideas = new CoreBaseCollection();
        String billId = null;
        String cubeName = null;
        String cubeEntry = null;
        Object unionId = null;
        Object orgUnitId = null;
        BgSchemeInfo schemeInfo = null;
        HashSet orgUnitIds = new HashSet();
        HashSet bgPeriodNums = new HashSet();
        HashSet versionNums = new HashSet();
        Set workFlow = null;
        Set mutex = null;
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        HashMap getDataMap = new HashMap();
        Map templateSetMap = new HashMap();
        Map templateExSetMap = new HashMap();
        HashSet<String> mbgDimNums = new HashSet<String>();
        mbgDimNums.add(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        mbgDimNums.add(DimensionBaseConstants.DEF_VERSION_NUMBER);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        UnionDataUtils utils = UnionDataUtils.getIntance();
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            mutex = isReqMutex ? MBgCheckHelper.requestMutex((Context)ctx, (List)idList, (boolean)true) : new HashSet();
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, (Collection)idList);
            List<BgCslFormInfo> cslForms = MbgCslDataHelper.getBgCslFormInfo(ctx, conn, idList);
            if (schemeInfo == null && cslForms != null && cslForms.size() > 0) {
                schemeInfo = MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)ctx.getLocale(), (BOSUuid)cslForms.get(0).getBgScheme().getId());
                cubeName = BgCubeUtils.getCFSCubeName((String)schemeInfo.getRefCube());
                cubeEntry = BgCubeUtils.getCFSEntryCubeName((String)schemeInfo.getRefCube());
            }
            Map<String, Object> checkListMap = BgCslTemplateSequenceSetHelper.checkBgTemplateSequenceSet(ctx, conn, idList, cslForms, schemeInfo, 1);
            templateSetMap = (Map)checkListMap.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET");
            templateExSetMap = (Map)checkListMap.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX");
            BgClosureMapUtils bgClosureMapUtils = new BgClosureMapUtils(schemeInfo, conn);
            Map closureMap = bgClosureMapUtils.getClosureMap();
            utils.setClosureMap(closureMap);
            if (idea instanceof BgAuditIdeaInfo) {
                ideaInfo = (BgAuditIdeaInfo)idea;
            } else {
                ideaInfo = new BgAuditIdeaInfo();
                ideaInfo.setState(BgAuditIdeaEnum.UNAUDIT);
            }
            if (ideaInfo.getCreator() == null) {
                ideaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            if (ideaInfo.getCreateTime() == null) {
                ideaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            }
            for (BgCslFormInfo cslForm : cslForms) {
                billId = cslForm.getId().toString();
                String orgStr = cslForm.getOrgUnit().getNumber() + "(" + cslForm.getOrgUnit().getName() + ")";
                String formStr = cslForm.getNumber() + "(" + cslForm.getName() + ")";
                if (2 == cslForm.getState().getValue()) {
                    if (mutex.contains(billId) || workFlow.contains(billId) || templateSetMap.containsKey(billId) || templateExSetMap.containsKey(billId)) {
                        if (mutex.contains(billId)) {
                            mutexMap.put(billId, new String[]{orgStr, formStr});
                            continue;
                        }
                        if (workFlow.contains(billId)) {
                            workFlowMap.put(billId, new String[]{orgStr, formStr});
                            continue;
                        }
                        if (templateSetMap.containsKey(billId) || templateExSetMap.containsKey(billId)) continue;
                    }
                    if (getDataMap.containsKey(billId) || templateSetMap.containsKey(billId) || templateExSetMap.containsKey(billId)) continue;
                    utils.clearCsl01(ctx, pool, cslForm, schemeInfo);
                    utils.unAuditCsl08(ctx, pool, cslForm, schemeInfo, null);
                    BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgCslForm set FState = ?, FAuditorID = null, FAuditedTime = null where FID = ?", (Object[])new Object[]{1, billId});
                    BgDBUtils.executeUpdate((Connection)conn, (String)("update " + cubeName + " set FState = ? where FUnionID = ? and FOrgUnitId = ? and exists (select FDataId from " + cubeEntry + " where FDataId = " + cubeName + ".FID and FFormId = ?)"), (Object[])new Object[]{1, unionId, orgUnitId, billId});
                    _tmpIdea = ideaInfo.getClone();
                    _tmpIdea.setFormId(BOSUuid.read((String)billId));
                    ideas.add((CoreBaseInfo)_tmpIdea);
                    continue;
                }
                stateMap.put(billId, new String[]{orgStr, formStr});
            }
            if (!ideas.isEmpty()) {
                BgAuditIdeaFactory.getLocalInstance((Context)ctx).addnewBatchData(ideas);
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"cslForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            idList.removeAll(mutexMap.keySet());
            MBgCheckHelper.releaseMutex((Context)ctx, (List)idList);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        result.put("CHECK_GETDATA", getDataMap);
        result.put("CHECK_RESULT_BGTEMPLATE_SEQUENCESET", templateSetMap);
        result.put("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX", templateExSetMap);
        return result;
    }

    @Override
    protected Map _checkCanAudit(Context ctx, List billIds) throws BOSException, EASBizException {
        return this.checkCanAudit2AntiAudit(ctx, billIds, 1);
    }

    @Override
    protected Map _checkCanAntiAudit(Context ctx, List billIds) throws BOSException, EASBizException {
        return this.checkCanAudit2AntiAudit(ctx, billIds, 2);
    }

    protected Map<String, Map<String, String[]>> checkCanAudit2AntiAudit(Context ctx, List<String> billIds, int checkState) throws BOSException, EASBizException {
        HashMap<String, Map<String, String[]>> result = new HashMap<String, Map<String, String[]>>();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return result;
        }
        String billId = null;
        Set workFlow = null;
        Set mutex = null;
        HashMap<String, String[]> workFlowMap = new HashMap<String, String[]>();
        HashMap<String, String[]> mutexMap = new HashMap<String, String[]>();
        HashMap<String, String[]> stateMap = new HashMap<String, String[]>();
        HashMap getDataMap = new HashMap();
        HashSet<String> mbgDimNums = new HashSet<String>();
        mbgDimNums.add(DimensionBaseConstants.DEF_PERIOD_NUMBER);
        mbgDimNums.add(DimensionBaseConstants.DEF_VERSION_NUMBER);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            mutex = MBgCheckHelper.requestMutex((Context)ctx, billIds, (boolean)true);
            workFlow = MBgCheckHelper.checkInProInst((Context)ctx, billIds);
            List<BgCslFormInfo> cslForms = MbgCslDataHelper.getBgCslFormInfo(ctx, conn, billIds);
            for (BgCslFormInfo cslForm : cslForms) {
                billId = cslForm.getId().toString();
                String orgStr = cslForm.getOrgUnit().getNumber() + "(" + cslForm.getOrgUnit().getName() + ")";
                String formStr = cslForm.getNumber() + "(" + cslForm.getName() + ")";
                if (checkState != cslForm.getState().getValue()) {
                    stateMap.put(billId, new String[]{orgStr, formStr});
                    continue;
                }
                if (!mutex.contains(billId) && !workFlow.contains(billId)) continue;
                if (mutex.contains(billId)) {
                    mutexMap.put(billId, new String[]{orgStr, formStr});
                    continue;
                }
                if (!workFlow.contains(billId)) continue;
                workFlowMap.put(billId, new String[]{orgStr, formStr});
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"cslForm audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            billIds.removeAll(mutexMap.keySet());
            MBgCheckHelper.releaseMutex((Context)ctx, billIds);
        }
        result.put("CHECK_NETMUTEX", mutexMap);
        result.put("CHECK_WORKFLOW", workFlowMap);
        result.put("CHECK_STATE", stateMap);
        result.put("CHECK_GETDATA", getDataMap);
        return result;
    }

    @Override
    protected Map _getBgDataInfo(Context ctx, BgCslFormInfo bgFormInfo, IMbgViewBase view) throws BOSException, EASBizException {
        if (view == null || bgFormInfo == null) {
            return new HashMap();
        }
        ArrayList<IBgDimensionManagerBase> dimensionManagers = new ArrayList<IBgDimensionManagerBase>();
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            dimensionManagers.add(((IMbgSheetBase)view.getSheetManagers().get(i)).getDimensionManager());
        }
        Map data = MBGFormFacadeFactory.getLocalInstance((Context)ctx).queryBgData(null, (IObjectValue)bgFormInfo, dimensionManagers, 64, false, null, false, null);
        this.saveBizCalcDatas(ctx, bgFormInfo, data);
        return data;
    }

    @Override
    protected void _saveViewListData(Context ctx, BgCslFormInfo bgCslFormInfo, Map bgDataMap, Map otherOrgDimensionDataToSave, Map editNote, IObjectCollection desColls) throws BOSException, EASBizException {
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgCslFormInfo.getBgScheme().getId().toString(), bgCslFormInfo.getBgScheme().getOrgUnit().getId().toString());
        try {
            otherOrgDimensionDataToSave.put(bgCslFormInfo.getOrgUnit().getId().toString(), new MbgViewListXMLParser(ctx).parse(bgCslFormInfo.getDimensionData()));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Map<String, String> org_formId = this.queryFormId(ctx, bgCslFormInfo.getId().toString(), otherOrgDimensionDataToSave.keySet());
        this._saveDimensionData(ctx, bgCslFormInfo.getId(), otherOrgDimensionDataToSave, schemeHelper, org_formId);
        this._saveData(ctx, bgCslFormInfo, bgDataMap, org_formId);
        this._saveEditNote(ctx, bgCslFormInfo.getId().toString(), editNote);
        this._saveDesCell(ctx, (MbgViewListDesCellCollection)desColls, bgCslFormInfo);
    }

    protected void _saveEditNote(Context ctx, String id, Map editNotes) throws BOSException {
        MBGViewListFormFacadeFactory.getLocalInstance((Context)ctx).saveEditNote(id, editNotes);
    }

    private void _saveDesCell(Context ctx, MbgViewListDesCellCollection desColls, BgCslFormInfo bgCslFormInfo) throws EASBizException, BOSException {
        MbgViewListDesCellFactory.getLocalInstance((Context)ctx).saveBatchColls(desColls, bgCslFormInfo.getId().toString(), null);
    }

    protected void _saveDimensionData(Context ctx, BOSUuid bgFormId, Map otherOrgDimensionDataToSave, BgCslSchemeDimensionHelper schemeHelper, Map<String, String> org_id) throws BOSException, EASBizException {
        if (otherOrgDimensionDataToSave == null || otherOrgDimensionDataToSave.isEmpty() || org_id == null || org_id.isEmpty()) {
            return;
        }
        MbgViewListXMLParser mbgXmlParser = new MbgViewListXMLParser(ctx);
        Map.Entry entry2 = null;
        byte[] viewData = null;
        String _bgFormId = null;
        HashMap<String, byte[]> dataMap = new HashMap<String, byte[]>();
        for (Map.Entry entry2 : otherOrgDimensionDataToSave.entrySet()) {
            if (!org_id.containsKey(entry2.getKey())) continue;
            _bgFormId = org_id.get(entry2.getKey());
            viewData = mbgXmlParser.unParse((MbgViewListManager)entry2.getValue());
            if (viewData == null) continue;
            dataMap.put(_bgFormId, viewData);
            BgFacadeHelper.saveViewRef1((Context)ctx, (BgSchemeDimensionHelper)schemeHelper, (String)_bgFormId, (String)((String)entry2.getKey()), (BgRefDimMemberEnum)BgRefDimMemberEnum.BgCslForm, (IMbgViewBase)((IMbgViewBase)entry2.getValue()), (boolean)true);
        }
        if (dataMap.size() > 0) {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Connection conn = null;
            PreparedStatement pstmt = null;
            String sql = "update T_MBg_BgCslForm set FDimensionData = ?, FLastUpdateTime = ?, FLastUpdateUserID = ? where FId = ?";
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                Map.Entry entry12 = null;
                for (Map.Entry entry12 : dataMap.entrySet()) {
                    pstmt.setBytes(1, (byte[])entry12.getValue());
                    pstmt.setTimestamp(2, now);
                    pstmt.setString(3, userId);
                    pstmt.setString(4, (String)entry12.getKey());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }

    private Map<String, String> queryFormId(Context ctx, String bgFormId, Collection orgIds) throws BOSException {
        final HashMap<String, String> org_id = new HashMap<String, String>();
        if (bgFormId == null || orgIds == null || orgIds.isEmpty()) {
            return org_id;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select FOrgUnitId, FID FROM T_MBg_BgCslForm Where ");
        sql.append("FBgSchemeId = (Select FBgSchemeId FROM T_MBg_BgCslForm Where FID = ?)");
        sql.append("AND FOrgTreeId = (Select FOrgTreeId FROM T_MBg_BgCslForm Where FID = ?)");
        sql.append("AND FBgCslTemplateId = (Select FBgCslTemplateId FROM T_MBg_BgCslForm Where FID = ?)");
        sql.append("AND FBgPeriodId = (Select FBgPeriodId FROM T_MBg_BgCslForm Where FID = ?)");
        sql.append("AND FCurrencyId = (Select FCurrencyId FROM T_MBg_BgCslForm Where FID = ?)");
        sql.append("AND FBgVersionId = (Select FBgVersionId FROM T_MBg_BgCslForm Where FID = ?)");
        sql.append("AND FOrgUnitId IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{bgFormId, bgFormId, bgFormId, bgFormId, bgFormId, bgFormId}, (Object[])orgIds.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                org_id.put(res.getString("FOrgUnitId"), res.getString("FID"));
            }
        });
        return org_id;
    }

    protected void _saveData(Context ctx, BgCslFormInfo bgFormInfo, Map bgDataMap, Map<String, String> org_formId) throws BOSException, EASBizException {
        String orgId2 = null;
        BOSUuid bgSchemeId = bgFormInfo.getBgScheme().getId();
        BOSUuid orgTreeId = bgFormInfo.getOrgTree().getId();
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        HashMap<String, Map<String, IBgNData>> subMap = new HashMap<String, Map<String, IBgNData>>();
        try {
            for (String orgId2 : bgDataMap.keySet()) {
                if (!org_formId.containsKey(orgId2)) continue;
                subMap.clear();
                subMap.put(orgId2, (Map<String, IBgNData>)bgDataMap.get(orgId2));
                UnionDataUtils.getIntance().saveIndvData(ctx, BOSUuid.read((String)org_formId.get(orgId2)), bgSchemeId, orgTreeId, userId, subMap, null);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _initMutiOrgMemberCheckHelper(Context ctx, Map mutiViewManagers, BgSchemeDimensionHelper schemeHelper, boolean isClearCtx) throws BOSException, EASBizException {
        long ct = System.currentTimeMillis();
        long ct1 = System.currentTimeMillis();
        HashMap<String, DimensionMemberCheckHelper> checkHelpers = new HashMap<String, DimensionMemberCheckHelper>();
        if (mutiViewManagers == null || mutiViewManagers.isEmpty() || schemeHelper == null) {
            return checkHelpers;
        }
        BgCslDimensionMemberCheckFactory factory = new BgCslDimensionMemberCheckFactory(ctx, null, schemeHelper);
        String orgUnitId2 = null;
        MbgViewListManager viewManager = null;
        DimensionMemberCheckHelper checkHelper = null;
        for (String orgUnitId2 : mutiViewManagers.keySet()) {
            checkHelper = factory.getHelper(orgUnitId2, (IMbgViewBase)(viewManager = (MbgViewListManager)mutiViewManagers.get(orgUnitId2)));
            if (checkHelper != null) {
                checkHelpers.put(orgUnitId2, checkHelper);
                if (isClearCtx) {
                    checkHelper.clearCtx();
                    checkHelper.getCacheHelper().clearCtx();
                }
            }
            System.out.println("OrgUnitId:" + orgUnitId2 + "  Time:" + (System.currentTimeMillis() - ct));
            ct = System.currentTimeMillis();
        }
        System.out.println("OrgUnitId(count):" + mutiViewManagers.size() + "  Time:" + (System.currentTimeMillis() - ct1));
        return checkHelpers;
    }

    protected Map queryMuiltOrgData(Context ctx, BgCslFormInfo bgCslFormInfo, Map dimensionManagers, int dataType, boolean isSynch) throws BOSException, EASBizException {
        if (bgCslFormInfo == null || dimensionManagers == null || dimensionManagers.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, BgNViewDataInfo>> data = new HashMap();
        if (ctx == null || bgCslFormInfo == null || dimensionManagers == null || dimensionManagers.isEmpty()) {
            return data;
        }
        List subDimensionManagers = null;
        HashSet<String> orgUnitIds = new HashSet<String>();
        ArrayList allDimManagers = new ArrayList();
        for (String orgUnitId : dimensionManagers.keySet()) {
            if (!(dimensionManagers.get(orgUnitId) instanceof List) || (subDimensionManagers = (List)dimensionManagers.get(orgUnitId)).isEmpty()) continue;
            allDimManagers.addAll(subDimensionManagers);
            orgUnitIds.add(orgUnitId);
        }
        bgCslFormInfo.put("ORGUNIT_ID", orgUnitIds);
        data = MBGFormFacadeFactory.getLocalInstance((Context)ctx).queryBgData(BOSUuid.read((String)bgCslFormInfo.getString(bgCslFormInfo.getPKField())), (IObjectValue)bgCslFormInfo, allDimManagers, dataType, isSynch, null, false, null);
        this.saveBizCalcDatas(ctx, bgCslFormInfo, data);
        return data;
    }

    @Override
    protected Map _queryViewListData(Context ctx, BgCslFormInfo bgCslFormInfo, Map dimensionManagers, int dataType, boolean isSynch) throws BOSException, EASBizException {
        long beginTime = System.currentTimeMillis();
        logger.info((Object)"begin queryViewData!");
        if (bgCslFormInfo == null || dimensionManagers == null || dimensionManagers.isEmpty()) {
            return null;
        }
        return this.queryMuiltOrgData(ctx, bgCslFormInfo, dimensionManagers, dataType, isSynch);
    }

    protected void saveBizCalcDatas(Context ctx, BgCslFormInfo info, Map<String, Map<String, BgNViewDataInfo>> datas) {
        BgCslBackSaveCaller.getInstance().runBackUpdate(ctx, info, datas);
    }

    @Override
    protected Map _reportCheck(Context ctx, List billIds) throws BOSException, EASBizException {
        HashMap<String, String> msgMap = new HashMap<String, String>();
        if (ctx == null || billIds == null || billIds.isEmpty()) {
            return msgMap;
        }
        StringBuffer msg = null;
        List<BgCslFormInfo> cslForms = null;
        BgCslFormInfo _cslForm = null;
        RptOperationSchemaComp comp = null;
        ArrayList check = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            cslForms = MbgCslDataHelper.getBgCslFormInfo(ctx, conn, billIds, false);
            if (cslForms != null) {
                for (BgCslFormInfo cslForm : cslForms) {
                    if (0 != cslForm.getBgCslTemplate().getFormType().getValue() && 8 != cslForm.getBgCslTemplate().getFormType().getValue()) continue;
                    _cslForm = (BgCslFormInfo)this._getValue(ctx, "select data where id = '" + cslForm.getId().toString() + "'");
                    cslForm.setData(_cslForm.getData());
                    if (cslForm.getData() == null) continue;
                    BookProperties bp = BookProperties.loadFromBook((Book)cslForm.getBook());
                    comp = cslForm.get("operationSchemas") != null ? (RptOperationSchemaComp)cslForm.get("operationSchemas") : bp.getOperationSchema();
                    if (comp == null || comp.isCheckExpEmpty()) continue;
                    cslForm.put("FORMULA_DATA", this.extractData(cslForm, true, null));
                    cslForm.put("operationSchemas", comp);
                    BgCslRptReportPropertyAdapter adapter = new BgCslRptReportPropertyAdapter(cslForm);
                    check = ReportCheck.checkReport((Context)ctx, (ReportBaseInfo)cslForm, (IReportPropertyAdapter)adapter, null);
                    if (check == null || !Boolean.FALSE.equals(check.get(0))) continue;
                    msg = new StringBuffer();
                    msg.append("<a>" + cslForm.getNumber() + " - " + cslForm.getName() + "</a>");
                    msg.append("<br>");
                    msg.append(check.get(2));
                    msg.append("<br>");
                    msg.append("<br>");
                    msgMap.put(cslForm.getId().toString(), msg.toString());
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return msgMap;
    }

    private List extractData(BgCslFormInfo model, boolean valueFirst, int[] calIndex) {
        Book _book = null;
        Sheet _sheet = null;
        try {
            _book = model.getBook();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BgNFSHelper.disableCal((Book)_book);
        BgNFSHelper.disableUndo((Book)_book);
        if (_book == null) {
            return new ArrayList();
        }
        ArrayList result = new ArrayList(_book.getSheetCount());
        ArrayList<String> names = new ArrayList<String>(_book.getSheetCount());
        result.add(names);
        int i = 0;
        int jn = _book.getSheetCount();
        for (int j = 0; j < jn; ++j) {
            int r;
            _sheet = _book.getSheet(j);
            if (_sheet == null) {
                result.add(null);
                names.add(null);
                continue;
            }
            names.add(_sheet.getSheetName());
            int rowcount = _sheet.getMaxRowIndex();
            if (rowcount < 1) continue;
            ArrayList myBody = new ArrayList(rowcount);
            result.add(myBody);
            int lastRow = 0;
            for (r = 0; r < rowcount; ++r) {
                Row row = _sheet.getRow(r, false);
                if (row == null) {
                    myBody.add(null);
                    continue;
                }
                ArrayList<Object> myRow = new ArrayList<Object>(_sheet.getMaxColIndex());
                boolean hasContent = false;
                for (int k = 0; k < _sheet.getMaxColIndex(); ++k) {
                    Cell cell = row.getCell(k, false);
                    if (cell == null || cell.getValue() == Variant.nullVariant && BgNFSHelper.getExpression((Cell)cell) == null) {
                        myRow.add(null);
                        continue;
                    }
                    if (cell != null && BgNFSHelper.getValue((Cell)cell) instanceof String && StringUtils.isEmpty((String)((String)BgNFSHelper.getValue((Cell)cell))) && BgNFSHelper.getExpression((Cell)cell) == null) {
                        myRow.add(null);
                        continue;
                    }
                    hasContent = true;
                    String s = BgNFSHelper.getExpression((Cell)cell);
                    Variant obj = cell.getValue();
                    if (!StringUtils.isEmpty((String)s)) {
                        if (valueFirst || calIndex != null && calIndex[i] < 0) {
                            myRow.add(obj);
                            continue;
                        }
                        myRow.add(s);
                        continue;
                    }
                    myRow.add(obj);
                }
                if (hasContent) {
                    myBody.add(myRow);
                    lastRow = j;
                    continue;
                }
                myBody.add(null);
            }
            for (r = rowcount - 1; r > lastRow; --r) {
                myBody.remove(r);
            }
            ++i;
        }
        return result;
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        MbgViewListManager viewManager = null;
        MbgViewListXMLParser parse = null;
        byte[] bytes = null;
        bytes = ((BgCslFormInfo)model).getDimensionData();
        parse = new MbgViewListXMLParser(ctx);
        ArrayList<BgCslFormInfo> newForms = new ArrayList<BgCslFormInfo>();
        newForms.add((BgCslFormInfo)model);
        try {
            viewManager = parse.parse(bytes);
            MbgViewListFormServerHelper.addDefDimMembers((MbgViewListManager)viewManager, newForms, (boolean)false, (boolean)true);
            bytes = parse.unParse(viewManager);
            ((BgCslFormInfo)model).setDimensionData(bytes);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return super.submit(ctx, model);
    }

    private void checkBgPeriodIsAcross(Context ctx, BgCslFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo == null || bgFormInfo.getBgScheme() == null) {
            return;
        }
        try {
            String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
            BgSchemeDimensionHelper schemehHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            IMbgViewManager viewManager = BgCslFormHelper.getFormView(ctx, bgFormInfo, schemehHelper);
            MbgViewListFormServerHelper.checkBgPeriodIsAcross((Context)ctx, (String)bgSchemeId, (IMbgViewBase)viewManager, (IDimDataQuery)bgFormInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Object _batchAddCslFrom(Context ctx, Object[] orgUnits, Object[] templates, Object[] versions, Object[] periods, OrgTreeInfo treeInfo, BgCslFormInfo cslForm) throws BOSException, EASBizException {
        if (treeInfo == null || cslForm == null || this.isNullForBatch(orgUnits, templates, versions, periods)) {
            return null;
        }
        BgCodeNumberHelper numberCodeHelper = new BgCodeNumberHelper(ctx, null, "sourceType");
        CurrencyInfo currency = cslForm.getCurrency();
        Object[] currs = new Object[]{currency};
        Object pk = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet res = null;
        try {
            Object[] objectArray;
            conn = this.getConnection(ctx);
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            Set<String> hasFormKey = this.getHasFormKey(conn, pool, (BgCslFormInfo)cslForm, orgUnits, templates, periods, versions, currs);
            String addNewPermission = "csl_mbgform02_addNew";
            Set hasPermOrgIds = this.getHasPermission(ctx, orgUnits, addNewPermission);
            String permissionAlias = null;
            if (!StringUtils.isEmpty((String)addNewPermission)) {
                PermissionItemInfo info = PermItemFactory.getLocalInstance((Context)ctx).getPermissionItemInfo(addNewPermission);
                permissionAlias = info.getAlias();
            }
            HashMap<String, BgPeriodInfo> periodCache = new HashMap<String, BgPeriodInfo>();
            Date sBegin = BgNPeriodHelper.getDayBegin((Date)cslForm.getBgScheme().getDateFrom());
            Date sEnd = BgNPeriodHelper.getDayEnd((Date)cslForm.getBgScheme().getDateTo());
            String bgSchemeId = cslForm.getBgScheme().getId().toString();
            BgCslSchemeDimensionHelper schemehHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId, (String)null);
            Map<String, String[]> cannotPeriondNTemplate = this.checkPeriondNTemplate(ctx, conn, templates, periods, sBegin, sEnd, periodCache, schemehHelper);
            Map<String, String[]> bizPeriod = this.checkPeirodBiz(ctx, conn, pool, templates, periods, sBegin, sEnd, periodCache, cslForm.getBgScheme());
            HashMap<String, IMbgViewBase> managerMap = new HashMap<String, IMbgViewBase>();
            Map<String, BgCslFormInfo> bgForms = this.getFormMap(ctx, (BgCslFormInfo)cslForm, orgUnits, templates, versions, periods, treeInfo, managerMap, schemehHelper);
            if (bgForms == null) {
                Object var30_32 = null;
                return var30_32;
            }
            String curOrgId = null;
            HashSet<String> numbers = new HashSet<String>();
            HashSet<String> numberNull = new HashSet<String>();
            HashSet<String> numberError = new HashSet<String>();
            BgCslFormInfo b = null;
            HashSet<String> nameError = new HashSet<String>();
            for (String formKey : bgForms.keySet()) {
                b = bgForms.get(formKey);
                if (hasFormKey != null && hasFormKey.contains(formKey) || hasPermOrgIds == null || !hasPermOrgIds.contains(b.getOrgUnit().getId().toString()) || cannotPeriondNTemplate != null && cannotPeriondNTemplate.containsKey(this.getKey(null, b.getBgCslTemplate().getId(), b.getBgPeriod().getId(), null, null)) || bizPeriod != null && bizPeriod.containsKey(this.getKey(null, b.getBgCslTemplate().getId(), b.getBgPeriod().getId(), null, null))) continue;
                if (!b.getOrgUnit().getId().toString().equals(curOrgId)) {
                    curOrgId = b.getOrgUnit().getId().toString();
                    numberCodeHelper.init((IObjectValue)b, curOrgId);
                }
                String oldNumber = b.getNumber();
                numberCodeHelper.applyNumber((IObjectValue)b, curOrgId, null, true);
                if (StringUtils.isEmpty((String)b.getNumber()) && !StringUtils.isEmpty((String)oldNumber)) {
                    b.setNumber(oldNumber);
                }
                if (StringUtils.isEmpty((String)b.getNumber())) {
                    numberNull.add(formKey);
                    continue;
                }
                if (b.getNumber() != null && b.getNumber().length() > 80) {
                    b.setNumber(b.getNumber().substring(0, 80));
                }
                if (!StringUtils.isEmpty((String)b.getNumber())) {
                    if (b.getNumber().indexOf("(") >= 0 || b.getNumber().indexOf(")") >= 0) {
                        numberError.add(formKey);
                    } else {
                        numbers.add(b.getNumber());
                    }
                }
                if (!StringUtils.isEmpty((String)b.getNumber())) {
                    if (b.getNumber().indexOf("(") >= 0 || b.getNumber().indexOf(")") >= 0) {
                        numberError.add(formKey);
                    } else {
                        numbers.add(b.getNumber());
                    }
                }
                String oldName = b.getName();
                if (StringUtils.isEmpty((String)b.getName()) && !StringUtils.isEmpty((String)oldName)) {
                    b.setName(oldName);
                }
                if (StringUtils.isEmpty((String)b.getName())) {
                    b.setName(BgCslFormControllerBean.getBgFormName(b.getCU(), b.getOrgUnit(), b.getBgCslTemplate(), b.getBgPeriod(), b.getBgVersion(), 80));
                }
                if (b.getName().length() > 80) {
                    b.setName(b.getName().substring(0, 80));
                }
                if (b.getName().indexOf("/") < 0 && b.getName().indexOf("\\") < 0) continue;
                nameError.add(formKey);
            }
            Set<String> hasNumbers = this.getHasNumbers(ctx, conn, pool, cslForm.getBgScheme().getId().toString(), DimensionCommonHelper.getIds((Object[])orgUnits), numbers);
            Map<String, String> specialMember = this.getSpecialMember((BgCslFormInfo)cslForm);
            Map<String, Set<String>> existsSpecialMember = this.getExistsSpecialMember(ctx, specialMember, DimensionCommonHelper.getIds((Object[])orgUnits), schemehHelper);
            if (cslForm.getBgSpecialItems() != null && !cslForm.getBgSpecialItems().isEmpty() && !cslForm.getBgSpecialItems().get(0).getDimRelaGroupRef().isEmpty()) {
                BgCslSpecialRelationGroupCollection coll = cslForm.getBgSpecialItems().get(0).getDimRelaGroupRef();
                DimensionRelationshipGroupInfo groupId = null;
                for (int i = 0; i < coll.size(); ++i) {
                    groupId = coll.get(i).getDimRelaGroup();
                }
                if (groupId != null && groupId.getId() != null) {
                    Set orgids = DimensionCommonHelper.getIds((Object[])orgUnits);
                    OrgUnitInfo orgUnitInfo = null;
                    HashSet<String> src = new HashSet<String>();
                    for (int i = 0; i < groupId.getEntries().size(); ++i) {
                        src.add(schemehHelper.getSrcNumber(groupId.getEntries().get(i).getDimNumber()));
                    }
                    for (String id : orgids) {
                        orgUnitInfo = new OrgUnitInfo();
                        orgUnitInfo.setId(BOSUuid.read((String)id));
                        CoreBaseCollection colls = DimensionMemberRelationShipHelper.queryAllRelationByGroupId((Context)ctx, (DimensionRelationshipGroupInfo)groupId, (OrgUnitInfo)orgUnitInfo);
                        DimensionRelationshipInfo shipinfo = null;
                        String dimensionNumber = null;
                        HashSet dimSrc = new HashSet();
                        for (int i = 0; i < colls.size(); ++i) {
                            shipinfo = (DimensionRelationshipInfo)colls.get(i);
                            dimensionNumber = shipinfo.getDimensionNumber();
                            dimSrc.addAll(Arrays.asList(dimensionNumber.split(",")));
                        }
                        if (existsSpecialMember == null || existsSpecialMember.get(id) == null || existsSpecialMember.get(id).isEmpty()) continue;
                        Set<String> srcDim = existsSpecialMember.get(id);
                        Iterator<String> iterator = srcDim.iterator();
                        while (iterator.hasNext()) {
                            String dimString = iterator.next();
                            if (dimSrc.contains(dimString) || !src.contains(dimString.split(":")[0])) continue;
                            iterator.remove();
                        }
                    }
                }
            }
            String otherKey = null;
            ArrayList<BgCslFormInfo> successForms = new ArrayList<BgCslFormInfo>();
            ArrayList viewForms = new ArrayList();
            HashMap viewListForms = new HashMap();
            CoreBaseCollection colls = new CoreBaseCollection();
            BgTemFormTypeEnum formType = null;
            Object bgMeasureUnit = null;
            Object bgTemMeaInfo = null;
            HashMap<String, String> id_formKey = new HashMap<String, String>();
            LinkedHashMap<String, String> errorMap = new LinkedHashMap<String, String>();
            for (String formKey : bgForms.keySet()) {
                String bgTemplateId;
                block51: {
                    b = bgForms.get(formKey);
                    String orgUnitId = b.getOrgUnit().getId().toString();
                    id_formKey.put(b.getId().toString(), formKey);
                    otherKey = this.getKey(null, b.getBgCslTemplate().getId(), b.getBgPeriod().getId(), null, null);
                    bgTemplateId = b.getBgCslTemplate().getId().toString();
                    if (hasFormKey != null && hasFormKey.contains(formKey)) {
                        errorMap.put(formKey, this.getMsg(ctx, "checkFormExistsCSL", b, null));
                        continue;
                    }
                    if (hasPermOrgIds == null || !hasPermOrgIds.contains(b.getOrgUnit().getId().toString())) {
                        errorMap.put(formKey, this.getMsg(ctx, "checkFormPermissionCSL", b, permissionAlias));
                        continue;
                    }
                    if (cannotPeriondNTemplate != null && cannotPeriondNTemplate.containsKey(otherKey)) {
                        errorMap.put(formKey, this.getMsg(ctx, cannotPeriondNTemplate.get(otherKey)[0], b, cannotPeriondNTemplate.get(otherKey)[1]));
                        continue;
                    }
                    if (bizPeriod != null && bizPeriod.containsKey(otherKey)) {
                        errorMap.put(formKey, this.getMsg(ctx, bizPeriod.get(otherKey)[0], b, bizPeriod.get(otherKey)[1]));
                        continue;
                    }
                    if (numberError.contains(formKey)) {
                        errorMap.put(formKey, this.getMsg(ctx, "checkNumberErrorCSL", b, b.getNumber()));
                        continue;
                    }
                    if (numberNull.contains(formKey)) {
                        errorMap.put(formKey, this.getMsg(ctx, "checkNumberNullCSL", b, null));
                        continue;
                    }
                    if (hasNumbers.contains(this.getKey(b.getOrgUnit().getId(), b.getNumber(), null, null, null))) {
                        errorMap.put(formKey, this.getMsg(ctx, "checkNumberExistCSL", b, b.getNumber()));
                        continue;
                    }
                    String checkSpecial = this.checkSpecialNoExists(b, specialMember, existsSpecialMember);
                    if (checkSpecial != null) {
                        errorMap.put(formKey, this.getMsgSP(ctx, "checkMemberExistsSpecialCSL", b, checkSpecial));
                        continue;
                    }
                    if (nameError.contains(formKey)) {
                        errorMap.put(formKey, this.getMsg(ctx, "checkNameErrorCSL", b, b.getName()));
                        continue;
                    }
                    if (BgTemFormTypeEnum.VIEWLIST.equals((Object)b.getBgCslTemplate().getFormType())) {
                        try {
                            IMbgViewBase iMbgViewBase = (IMbgViewBase)managerMap.get(this.getKey(b));
                            if (!(iMbgViewBase instanceof MbgViewListManager)) break block51;
                            MbgViewListFormServerHelper.convertRelationMap((Context)ctx, (MbgViewListManager)((MbgViewListManager)iMbgViewBase), (String)b.getOrgUnit().getId().toString(), (DimensionCacheHelper)new DimensionCacheHelper(ctx));
                            MbgViewListFormServerHelper.checkPeriodType((Context)ctx, null, (MbgViewListManager)((MbgViewListManager)iMbgViewBase));
                        }
                        catch (Exception e) {
                            if (!(e instanceof BgPeriodException)) break block51;
                            errorMap.put(formKey, this.getMsg(ctx, "checkPeriodTypeCSL", b, ((BgPeriodException)e).getMessage()));
                            continue;
                        }
                    }
                }
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(b.getId().toString());
                MbgViewListFormServerHelper.saveDesCellByIds((Context)ctx, (Connection)conn, ids, (String)bgTemplateId);
                ArrayList<BgCslFormInfo> formInfos = new ArrayList<BgCslFormInfo>();
                formInfos.add(b);
                MbgViewListFormServerHelper.saveEditNote((Context)ctx, (Connection)conn, formInfos, (String)bgTemplateId);
                successForms.add(b);
                colls.add((CoreBaseInfo)b);
                b.setBgType(b.getBgCslTemplate().getBgType());
                b.setMeasureUnit(b.getBgCslTemplate().getDefaultMeasureUnit());
                b.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                b.setCU(b.getOrgUnit().getCU());
                b.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                formType = b.getBgCslTemplate().getFormType();
            }
            String formMsg = null;
            formMsg = this.getMsg(ctx, "bgFormCSL", null);
            IObjectPK[] _saveBatchData = this._saveBatchData(ctx, (IObjectCollection)colls);
            Object[] result = new String[2];
            if (!errorMap.isEmpty()) {
                StringBuffer detail = new StringBuffer();
                int index = 1;
                for (String msg : errorMap.values()) {
                    if (detail.length() > 0) {
                        detail.append("\r\n");
                    }
                    detail.append(this.getMsg(ctx, "checkErrorSeq", new Object[]{index++}));
                    detail.append(msg);
                }
                result = new Object[4];
                result[1] = detail.toString();
                result[0] = errorMap.size() == bgForms.size() ? this.getMsg(ctx, "addNewFail", new Object[]{formMsg, bgForms.size()}) : this.getMsg(ctx, "addNewSuccessFail", new Object[]{formMsg, bgForms.size() - errorMap.size(), errorMap.size()});
                result[2] = successForms;
                result[3] = new Integer[]{bgForms.size(), errorMap.size()};
            } else {
                result[0] = this.getMsg(ctx, "addNewSuccess", new Object[]{formMsg, bgForms.size()});
                result = new Object[4];
                result[0] = this.getMsg(ctx, "addNewSuccess", new Object[]{formMsg, bgForms.size()});
                result[2] = successForms;
                result[3] = new Integer[]{bgForms.size(), 0};
                if (bgForms.size() == 1) {
                    objectArray = cslForm;
                    return objectArray;
                }
            }
            objectArray = result;
            return objectArray;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(res, pstmt, (Connection)conn);
        }
    }

    private boolean isNullForBatch(Object[] orgUnits, Object[] templates, Object[] versions, Object[] periods) {
        return orgUnits == null || templates == null || versions == null || periods == null;
    }

    private String getMsg(Context ctx, String msgKey, Object[] param) {
        if (param == null) {
            return ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)msgKey, (Locale)ctx.getLocale());
        }
        return MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)msgKey, (Locale)ctx.getLocale()), param);
    }

    private String getMsg(Context ctx, String msgKey, BgCslFormInfo bgFormInfo, Object other) {
        String specialDimName = bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty() ? bgFormInfo.getBgSpecialItems().get(0).getMemberDisplayName() : null;
        Object[] params = null;
        if (other != null) {
            params = new Object[6];
            params[params.length - 1] = other;
        } else {
            params = new Object[]{bgFormInfo.getOrgUnit().getName(), bgFormInfo.getBgCslTemplate().getName(), bgFormInfo.getBgPeriod().getName(), bgFormInfo.getBgVersion().getName(), bgFormInfo.getCurrency().getName()};
        }
        return this.getMsg(ctx, msgKey, params);
    }

    private String getMsgSP(Context ctx, String msgKey, BgCslFormInfo bgFormInfo, Object other) {
        String specialDimName = bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty() ? bgFormInfo.getBgSpecialItems().get(0).getMemberDisplayName() : null;
        Object[] params = null;
        if (other != null) {
            params = new Object[7];
            params[params.length - 1] = other;
            params[0] = bgFormInfo.getOrgUnit().getName();
            params[1] = bgFormInfo.getBgCslTemplate().getName();
            params[2] = bgFormInfo.getBgPeriod().getName();
            params[3] = bgFormInfo.getBgVersion().getName();
            params[4] = bgFormInfo.getCurrency().getName();
            if (!StringUtils.isEmpty((String)specialDimName)) {
                params[5] = specialDimName;
            }
        }
        return this.getMsg(ctx, msgKey, params);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getHasFormKey(Connection conn, TempTablePool pool, BgCslFormInfo baseInfo, Object[] orgUnitInfos, Object[] bgTemplateInfos, Object[] bgPeriodInfos, Object[] bgVersionInfos, Object[] currencyInfos) throws BOSException, EASBizException {
        HashSet<String> hasFormKey = new HashSet<String>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        String tmpIdTable = null;
        try {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            this.addToParam(paramList, orgUnitInfos, 1);
            this.addToParam(paramList, bgTemplateInfos, 2);
            this.addToParam(paramList, bgPeriodInfos, 3);
            this.addToParam(paramList, bgVersionInfos, 4);
            this.addToParam(paramList, currencyInfos, 5);
            tmpIdTable = pool.createTempTable("create table T_MBG_TemIdTable(FFlag INT NOT NULL, FID Varchar(44) NOT NULL)");
            pool.createIndex(tmpIdTable, "FFlag,FID", true, true);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tmpIdTable + "(FFlag, FID) Values(?, ?)"), paramList);
            StringBuffer sql = this.getExistsFormSQL(baseInfo, tmpIdTable);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, baseInfo.getBgScheme().getId().toString());
            pstmt.setInt(2, 1);
            pstmt.setInt(3, 2);
            pstmt.setInt(4, 3);
            pstmt.setInt(5, 4);
            pstmt.setInt(6, 5);
            if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
                pstmt.setString(7, baseInfo.getBgSpecialItems().get(0).getDimensionNumber());
            }
            res = pstmt.executeQuery();
            while (res.next()) {
                if (StringUtils.isEmpty((String)res.getString("FOrgUnitId"))) continue;
                hasFormKey.add(this.getKey(res.getString("FOrgUnitId"), res.getString("FBgCslTemplateID"), res.getString("FBgPeriodId"), res.getString("FBgVersionID"), res.getString("FCurrencyId")));
            }
        }
        catch (BOSException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw e;
                catch (EASBizException e2) {
                    logger.error((Object)"", (Throwable)e2);
                    throw e2;
                }
                catch (Exception e3) {
                    logger.error((Object)"", (Throwable)e3);
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt);
                if (tmpIdTable == null) throw throwable;
                pool.releaseTable(tmpIdTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
        if (tmpIdTable == null) return hasFormKey;
        pool.releaseTable(tmpIdTable);
        return hasFormKey;
    }

    private void addToParam(List<Object[]> paramList, Object[] objectValues, int flag) {
        for (Object obj : objectValues) {
            paramList.add(new Object[]{flag, ((CoreBaseInfo)obj).getId().toString()});
        }
    }

    private StringBuffer getExistsFormSQL(BgCslFormInfo baseInfo, String tmpIdTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Select t0.Fid, t0.FOrgUnitId, t0.FBgCslTemplateID, t0.FBgPeriodId, t0.FBgVersionID, t0.FCurrencyId FROM T_MBG_BgCslForm t0 ");
        if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
            sql.append(" Left Join T_MBG_BgCslSpecialItems t1 ON t1.FBgFormId = t0.FID ");
        }
        sql.append(" Left Join T_MBG_BgOrgUnit t2 ON t2.FOrgUnitID = t0.FOrgUnitId ");
        sql.append("Where t0.FBgSchemeId = ? ");
        sql.append("AND t0.FOrgUnitId IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        sql.append("AND t0.FBgCslTemplateID IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        sql.append("AND t0.FBgPeriodId IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        sql.append("AND t0.FBgVersionID IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        sql.append("AND t0.FCurrencyId IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
            sql.append(" AND (t1.FDimensionNumber = ? OR t1.FDimensionNumber IS NULL)");
        }
        return sql;
    }

    private void putBgForm(Map<String, BgCslFormInfo> bgForms, BgCslFormInfo b) {
        String key = this.getKey(b.getOrgUnit().getId(), b.getBgCslTemplate().getId(), b.getBgPeriod().getId(), b.getBgVersion().getId(), b.getCurrency().getId());
        bgForms.put(key, b);
    }

    private String getKey(Object orgUnitId, Object bgTemplateId, Object bgPeriodId, Object bgVersionId, Object currencyId) {
        return orgUnitId + "_" + bgTemplateId + "_" + bgPeriodId + "_" + bgVersionId + "_" + currencyId;
    }

    private String getKey(BgCslFormInfo b) {
        return this.getKey(b.getOrgUnit().getId(), b.getBgCslTemplate().getId(), b.getBgPeriod().getId(), b.getBgVersion().getId(), b.getCurrency().getId());
    }

    private Set getHasPermission(Context ctx, Object[] orgUnitInfos, String addNewPermission) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)addNewPermission)) {
            return DimensionCommonHelper.getIds((Object[])orgUnitInfos);
        }
        IObjectPK[] orgPks = new IObjectPK[orgUnitInfos.length];
        for (int i = 0; i < orgUnitInfos.length; ++i) {
            orgPks[i] = new ObjectUuidPK(((OrgUnitInfo)orgUnitInfos[i]).getId());
        }
        return PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPks, addNewPermission);
    }

    private Map<String, String[]> checkPeirodBiz(Context ctx, Connection conn, TempTablePool pool, Object[] bgTemplateInfos, Object[] bgPeriodInfos, Date schemeBegin, Date schemeEnd, Map<String, BgPeriodInfo> periodCacheMap, BgSchemeInfo bgSchemeInfo) throws Exception {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        String checkBizConvertPeriodN = "checkBizConvertPeriodNCSL";
        String checkBizPeriodExists = "checkBizPeriodExistsCSL";
        Map<String, List<BizCalcInfo>> templateBizCals = this.getTemplateBiz(ctx, conn, pool, bgTemplateInfos);
        if (templateBizCals == null || templateBizCals.isEmpty()) {
            return result;
        }
        HashMap<String, BizCalcInfo> bizCalcMap = new HashMap<String, BizCalcInfo>();
        BizCalcInfo bizCalc = null;
        for (List<BizCalcInfo> list : templateBizCals.values()) {
            for (int i = 0; i < list.size(); ++i) {
                bizCalc = list.get(i);
                bizCalcMap.put(bizCalc.getId().toString(), bizCalc);
            }
        }
        BgPeriodInfo periodInfo = null;
        MBgPeriodVariable variable = new MBgPeriodVariable(ctx.getLocale());
        LinkedHashSet<String> bgPeriodNumbers = new LinkedHashSet<String>();
        HashMap<String, String[]> checkMap = new HashMap<String, String[]>();
        for (Object p : bgPeriodInfos) {
            periodInfo = (BgPeriodInfo)p;
            for (String bizId : bizCalcMap.keySet()) {
                bizCalc = (BizCalcInfo)bizCalcMap.get(bizId);
                bgPeriodNumbers.clear();
                String errPeriodNumber = variable.getBgPeriodNumbers(ctx, bgPeriodNumbers, bizCalc, periodInfo, bgSchemeInfo);
                if (errPeriodNumber != null) {
                    checkMap.put(this.getKey(null, bizCalc.getId(), periodInfo.getId(), null, null), new String[]{"checkBizConvertPeriodNCSL", errPeriodNumber});
                    continue;
                }
                String notExist = this.checkPeriodExists(conn, periodCacheMap, bgPeriodNumbers, schemeBegin, schemeEnd);
                if (notExist == null) continue;
                checkMap.put(this.getKey(null, bizCalc.getId(), periodInfo.getId(), null, null), new String[]{"checkBizPeriodExistsCSL", notExist});
            }
        }
        String[] value = null;
        for (String bgTemplateId : templateBizCals.keySet()) {
            block5: for (Object p : bgPeriodInfos) {
                periodInfo = (BgPeriodInfo)p;
                for (BizCalcInfo info : templateBizCals.get(bgTemplateId)) {
                    value = (String[])checkMap.get(this.getKey(null, info.getId(), periodInfo.getId(), null, null));
                    if (value == null) continue;
                    result.put(this.getKey(null, bgTemplateId, periodInfo.getId(), null, null), value);
                    continue block5;
                }
            }
        }
        return result;
    }

    protected String checkPeriodExists(Connection conn, Map<String, BgPeriodInfo> periodCacheMap, Set<String> bgPeriodNumbers, Date schemeBegin, Date schemeEnd) throws EASBizException {
        ArrayList<String> queryPeriodNumbers = new ArrayList<String>();
        for (String bgPeriodNumber : bgPeriodNumbers) {
            if (periodCacheMap.containsKey(bgPeriodNumber)) {
                if (periodCacheMap.get(bgPeriodNumber) != null) continue;
                return bgPeriodNumber;
            }
            queryPeriodNumbers.add(bgPeriodNumber);
        }
        String notExist = null;
        Date pBegin = null;
        Date pEnd = null;
        if (!queryPeriodNumbers.isEmpty()) {
            Map periodMap = MbgViewListFormServerHelper.getBgPeriodMap((Connection)conn, queryPeriodNumbers);
            for (String bgPeriodNumber : queryPeriodNumbers) {
                if (periodMap.containsKey(bgPeriodNumber)) {
                    if (((BgPeriodInfo)periodMap.get(bgPeriodNumber)).getBeginDate() == null) continue;
                    pBegin = BgNPeriodHelper.getDayBegin((Date)((BgPeriodInfo)periodMap.get(bgPeriodNumber)).getBeginDate());
                    if (!BgNPeriodHelper.isAcross((Date)schemeBegin, (Date)schemeEnd, (Date)pBegin, (Date)(pEnd = BgNPeriodHelper.getDayEnd((Date)((BgPeriodInfo)periodMap.get(bgPeriodNumber)).getEndDate())))) {
                        periodCacheMap.put(bgPeriodNumber, null);
                        if (notExist != null) continue;
                        notExist = bgPeriodNumber;
                        continue;
                    }
                    periodCacheMap.put(bgPeriodNumber, (BgPeriodInfo)periodMap.get(bgPeriodNumber));
                    continue;
                }
                periodCacheMap.put(bgPeriodNumber, null);
                if (notExist != null) continue;
                notExist = bgPeriodNumber;
            }
        }
        return notExist;
    }

    private Map<String, List<BizCalcInfo>> getTemplateBiz(Context ctx, Connection conn, TempTablePool pool, Object[] bgTemplateInfos) throws Exception {
        HashMap<String, List<BizCalcInfo>> result = new HashMap<String, List<BizCalcInfo>>();
        ArrayList<String> bizIds = new ArrayList<String>();
        HashMap templateBizIds = new HashMap();
        Set ids = DimensionCommonHelper.getIds((Object[])bgTemplateInfos);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("bizCalcID");
        evi.getSelector().add("templateID");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("templateID", (Object)ids, CompareType.INCLUDE));
        BizRefCslTemplateCollection col = BizRefCslTemplateFactory.getLocalInstance(ctx).getBizRefCslTemplateCollection(evi);
        String bgTemplateId2 = null;
        String bizId2 = null;
        for (int i = 0; i < col.size(); ++i) {
            bgTemplateId2 = col.get(i).getTemplateID().toString();
            bizId2 = col.get(i).getBizCalcID().toString();
            if (!templateBizIds.containsKey(bgTemplateId2)) {
                templateBizIds.put(bgTemplateId2, new HashSet());
            }
            ((Set)templateBizIds.get(bgTemplateId2)).add(bizId2);
            if (bizIds.contains(bizId2)) continue;
            bizIds.add(bizId2);
        }
        if (bizIds.isEmpty()) {
            return result;
        }
        BizCalcQuery query = new BizCalcQuery(ctx);
        List bizInfos = query.queryBizCalc(conn, pool, bizIds);
        if (bizInfos == null || bizInfos.isEmpty()) {
            return result;
        }
        HashMap bizMap = new HashMap();
        for (int i = 0; i < bizInfos.size(); ++i) {
            bizMap.put(((BizCalcInfo)bizInfos.get(i)).getId().toString(), bizInfos.get(i));
        }
        for (String bgTemplateId2 : templateBizIds.keySet()) {
            result.put(bgTemplateId2, new ArrayList());
            for (String bizId2 : (Set)templateBizIds.get(bgTemplateId2)) {
                if (!bizMap.containsKey(bizId2)) continue;
                ((List)result.get(bgTemplateId2)).add(bizMap.get(bizId2));
            }
        }
        return result;
    }

    private Map<String, BgCslFormInfo> getFormMap(Context ctx, BgCslFormInfo cslForm, Object[] orgUnits, Object[] templates, Object[] versions, Object[] periods, OrgTreeInfo treeInfo, Map<String, IMbgViewBase> managerMap, BgSchemeDimensionHelper schemehHelper) throws EASBizException, BOSException, Exception, DimensionException {
        boolean isSingle = !this.isMutil(orgUnits, templates, versions, periods);
        String bgSchemeId = cslForm.getBgScheme().getId().toString();
        BgSchemeInfo bgScheme = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeInfo("select dateFrom, dateTo where id = '" + bgSchemeId + "'");
        HashMap<String, BgPeriodInfo> pMap = new HashMap<String, BgPeriodInfo>();
        Set pidSet = DimensionCommonHelper.getIds((Object[])periods);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)pidSet, CompareType.INCLUDE));
        BgPeriodCollection bgPeriodCollection = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(view);
        if (bgPeriodCollection != null) {
            for (int i = 0; i < bgPeriodCollection.size(); ++i) {
                BgPeriodInfo bgPeriodInfo = bgPeriodCollection.get(i);
                pMap.put(bgPeriodInfo.getId().toString(), bgPeriodInfo);
            }
        } else {
            return null;
        }
        Set tempidSet = DimensionCommonHelper.getIds((Object[])templates);
        view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)tempidSet, CompareType.INCLUDE));
        view.getSelector().add("*");
        view.getSelector().add("bgMeasureUnit.*");
        BgCslTemplateCollection bgNWorkViewDimensionCollection = BgCslTemplateFactory.getLocalInstance(ctx).getBgCslTemplateCollection(view);
        HashMap<String, BgCslTemplateInfo> tMap = new HashMap<String, BgCslTemplateInfo>();
        if (bgNWorkViewDimensionCollection != null) {
            for (int i = 0; i < bgNWorkViewDimensionCollection.size(); ++i) {
                BgCslTemplateInfo bgNWorkViewDimensionInfo = bgNWorkViewDimensionCollection.get(i);
                tMap.put(bgNWorkViewDimensionInfo.getId().toString(), bgNWorkViewDimensionInfo);
            }
        } else {
            return null;
        }
        MbgViewListXMLParser mbgViewParser = new MbgViewListXMLParser(ctx);
        LinkedHashMap<String, BgCslFormInfo> bgForms = new LinkedHashMap<String, BgCslFormInfo>();
        IMbgViewManager viewManager = null;
        Book book = null;
        BgCslSpecialItemsInfo spItem = null;
        BgCslSpecialRelationGroupInfo refInfo = null;
        for (Object orgUnit : orgUnits) {
            String orgUnitId = ((FullOrgUnitInfo)orgUnit).getId().toString();
            for (Object bgTemplate : templates) {
                for (Object bgPeriod : periods) {
                    for (Object bgVersion : versions) {
                        BgCslFormInfo b;
                        BgCslTemplateInfo bgTemplateInfo = (BgCslTemplateInfo)bgTemplate;
                        BgPeriodInfo period = (BgPeriodInfo)bgPeriod;
                        period = (BgPeriodInfo)pMap.get(period.getId().toString());
                        if (!isSingle) {
                            b = cslForm.deepclone();
                            for (int i = 0; i < b.getBgSpecialItems().size(); ++i) {
                                spItem = (BgCslSpecialItemsInfo)b.getBgSpecialItems().get(i).clone();
                                b.getBgSpecialItems().set(i, spItem);
                                spItem.setId(BOSUuid.create((BOSObjectType)spItem.getBOSType()));
                                spItem.setBgForm(b);
                                for (int g = 0; g < spItem.getDimRelaGroupRef().size(); ++g) {
                                    refInfo = (BgCslSpecialRelationGroupInfo)spItem.getDimRelaGroupRef().get(g).clone();
                                    spItem.getDimRelaGroupRef().set(i, refInfo);
                                    refInfo.setId(BOSUuid.create((BOSObjectType)refInfo.getBOSType()));
                                    refInfo.setBgSpecialItems(spItem);
                                }
                            }
                        } else {
                            b = cslForm;
                        }
                        if (b.getId() == null) {
                            b.setId(BOSUuid.create((BOSObjectType)b.getBOSType()));
                        }
                        BgNFSHelper.synPeriod((ReportBaseInfo)b, (BgPeriodInfo)period);
                        b.setOrgUnit((FullOrgUnitInfo)orgUnit);
                        b.setBgCslTemplate((BgCslTemplateInfo)tMap.get(bgTemplateInfo.getId().toString()));
                        b.setBgPeriod(period);
                        b.setBgVersion((BgVersionInfo)bgVersion);
                        b.setDescription(StringUtils.isEmpty((String)b.getDescription()) ? ((BgCslTemplateInfo)bgTemplate).getDescription() : b.getDescription());
                        if (b.getBgCslTemplate() != null && !BgTemFormTypeEnum.SPECIALFORM.equals((Object)b.getBgCslTemplate().getFormType()) && b.getBgSpecialItems() != null) {
                            b.getBgSpecialItems().clear();
                        }
                        BgCslTemplateInfo _bgTemplateInfo = null;
                        _bgTemplateInfo = b.getBgCslTemplate();
                        book = _bgTemplateInfo.getBook();
                        if (book != null) {
                            BgNExpressionHelper.dealAcctExpressionAtAddNew((Context)ctx, (Book)book, (IObjectValue)b, (int)0, (boolean)true);
                            if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)_bgTemplateInfo.getFormType())) {
                                book.setUserObject(BG_SPECIAL_ITEMS, (Object)BG_SPECIAL_ITEMS);
                            }
                            BgCslFormHelper.setNewBook(book);
                            b.setData(IOHelper.packBook((Book)book));
                        }
                        if (_bgTemplateInfo.getDimensionData() != null) {
                            b.setDimensionData((byte[])ObjectUtils.createCopy((Object)_bgTemplateInfo.getDimensionData()));
                        }
                        BgNFSHelper.synPeriod((ReportBaseInfo)b, (BgPeriodInfo)b.getBgPeriod());
                        b.setMeasureUnit(_bgTemplateInfo.getDefaultMeasureUnit());
                        BgCslFormMeasureUnitInfo bgMeasureUnit = null;
                        if (_bgTemplateInfo.getBgMeasureUnit() != null && !_bgTemplateInfo.getBgMeasureUnit().isEmpty()) {
                            BgCslTemMeasureUnitInfo bgTemMeaInfo = null;
                            BgCslTemMeasureUnitCollection bgTemCol = _bgTemplateInfo.getBgMeasureUnit();
                            Iterator iter = bgTemCol.iterator();
                            while (iter.hasNext()) {
                                bgTemMeaInfo = (BgCslTemMeasureUnitInfo)iter.next();
                                bgMeasureUnit = new BgCslFormMeasureUnitInfo();
                                bgMeasureUnit.setBgCslForm(b);
                                bgMeasureUnit.setBgElement(bgTemMeaInfo.getBgElement());
                                bgMeasureUnit.setMeasureUnit(bgTemMeaInfo.getMeasureUnit());
                                b.getCslFormMeasureUnit().add(bgMeasureUnit);
                            }
                        }
                        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)_bgTemplateInfo.getFormType()) && b.getDimensionData() != null) {
                            MbgViewListXMLParser parser = new MbgViewListXMLParser();
                            viewManager = parser.parse(b.getDimensionData());
                            MbgViewListManager canView = BgCslViewListFormFacadeFactory.getLocalInstance(ctx).reParseCanAddMembers((MbgViewListManager)viewManager, b, false);
                            DimensionCommonHelper.fillViewListDefaultMember((CurrencyInfo)b.getCurrency(), (BgPeriodInfo)b.getBgPeriod(), (BgVersionInfo)b.getBgVersion(), (MbgViewListManager)((MbgViewListManager)viewManager), (MbgViewListManager)canView);
                            b.setDimensionData(parser.unParse((MbgViewListManager)viewManager));
                        } else {
                            viewManager = BgCslFormHelper.getFormView(ctx, b, schemehHelper);
                        }
                        this.putBgFormForManager(b, (IMbgViewBase)viewManager, managerMap);
                        this.putBgForm(bgForms, b);
                    }
                }
            }
        }
        return bgForms;
    }

    private boolean isMutil(Object[] orgUnits, Object[] templates, Object[] versions, Object[] periods) {
        return DimensionCommonHelper.isMulti((Object)orgUnits) || DimensionCommonHelper.isMulti((Object)templates) || DimensionCommonHelper.isMulti((Object)versions) || DimensionCommonHelper.isMulti((Object)periods);
    }

    private void putBgFormForManager(BgCslFormInfo b, IMbgViewBase mbgViewManager, Map<String, IMbgViewBase> managerMap) {
        String key = this.getKey(b.getOrgUnit().getId(), b.getBgCslTemplate().getId(), b.getBgPeriod().getId(), b.getBgVersion().getId(), b.getCurrency().getId());
        managerMap.put(key, mbgViewManager);
    }

    public static String getBgFormName(CtrlUnitInfo cu, FullOrgUnitInfo orgUnit, BgCslTemplateInfo bgTemplateInfo, BgPeriodInfo bgPeriodInfo, BgVersionInfo bgVersionInfo, int maxLangth) {
        String name = null;
        name = new StringBuffer(bgPeriodInfo.getName()).append("-").append(bgTemplateInfo.getName()).append("-").append(bgVersionInfo.getName()).toString().trim();
        return name.length() > maxLangth ? name.substring(1, maxLangth) : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getHasNumbers(Context ctx, Connection conn, TempTablePool pool, String bgSchemeId, Set<String> orgIds, Set<String> numbers) throws Exception {
        String numberTable;
        HashSet<String> result;
        block7: {
            result = new HashSet<String>();
            if (orgIds == null || orgIds.isEmpty() || numbers == null || numbers.isEmpty()) {
                return result;
            }
            String orgIdTable = null;
            numberTable = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                orgIdTable = pool.createTempTable("Create Table T_MBG_OrgIdTable(FID Varchar(44) NOT NULL)");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgIdTable + "(FID) Values(?)"), orgIds);
                numberTable = pool.createTempTable("Create Table T_MBG_NumberTable(FNumber NVarchar(80) NOT NULL)");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + numberTable + "(FNumber) Values(?)"), numbers);
                pstmt = conn.prepareStatement("Select FOrgUnitId, FNumber FROM T_MBG_BgCslForm Where FBgSchemeId = ? AND FOrgUnitId IN(Select FID FROM " + orgIdTable + ") AND FNumber IN(Select FNumber FROM " + numberTable + ")");
                pstmt.setString(1, bgSchemeId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    result.add(this.getKey(rst.getString("FOrgUnitId"), rst.getString("FNumber"), null, null, null));
                }
                if (orgIdTable == null) break block7;
            }
            catch (Throwable throwable) {
                if (orgIdTable != null) {
                    pool.releaseTable(orgIdTable);
                }
                if (numberTable != null) {
                    pool.releaseTable(numberTable);
                }
                throw throwable;
            }
            pool.releaseTable(orgIdTable);
        }
        if (numberTable != null) {
            pool.releaseTable(numberTable);
        }
        return result;
    }

    private Map<String, String[]> checkPeriondNTemplate(Context ctx, Connection conn, Object[] bgTemplateInfos, Object[] bgPeriodInfos, Date schemeBegin, Date schemeEnd, Map<String, BgPeriodInfo> periodCacheMap, BgSchemeDimensionHelper schemehHelper) throws Exception {
        HashMap<String, String[]> resultMap = new HashMap<String, String[]>();
        String checkConvertPeriodN = "checkConvertPeriodNCSL1";
        String checkPeriodExists = "checkPeriodExistsCSL";
        Map<String, IMbgViewBase> viewMap = this.getViewMap(ctx, bgTemplateInfos);
        IMbgViewBase viewManager = null;
        List dimensions = null;
        BgDimensionBaseInfo dimension = null;
        String number = null;
        BgPeriodInfo bgPeriod = null;
        LinkedHashSet<String> bgPeriodNumbers = new LinkedHashSet<String>();
        ArrayList queryPeriodNumbers = new ArrayList();
        for (String bgTempateId : viewMap.keySet()) {
            viewManager = viewMap.get(bgTempateId);
            for (Object p : bgPeriodInfos) {
                bgPeriod = (BgPeriodInfo)p;
                bgPeriodNumbers.clear();
                queryPeriodNumbers.clear();
                try {
                    for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
                        if (((IMbgSheetBase)viewManager.getSheetManagers().get(s)).getDimensionManager() instanceof MbgViewListDimensionManager) {
                            dimensions = ((MbgViewListDimensionManager)((IMbgSheetBase)viewManager.getSheetManagers().get(s)).getDimensionManager()).getAllDimensions();
                            BgFormHelper.queryRelationPeriod(bgPeriodNumbers, (MbgViewListDimensionManager)((MbgViewListDimensionManager)((IMbgSheetBase)viewManager.getSheetManagers().get(s)).getDimensionManager()), (BgPeriodInfo)bgPeriod);
                        } else {
                            dimensions = ((IMbgSheetBase)viewManager.getSheetManagers().get(s)).getDimensionManager().getDimension();
                        }
                        for (int d = 0; d < dimensions.size(); ++d) {
                            if (!(dimensions.get(d) instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_PERIOD_NUMBER.equals((dimension = (BgDimensionBaseInfo)dimensions.get(d)).getNumber())) continue;
                            for (int m = 0; m < dimension.getSelectMembers().size(); ++m) {
                                number = null;
                                if (dimension.getSelectMembers().get(m) instanceof BgDimensionMember) {
                                    number = ((BgDimensionMember)dimension.getSelectMembers().get(m)).getNumber();
                                } else if (dimension.getSelectMembers().get(m) instanceof BgPeriodInfo) {
                                    number = ((BgPeriodInfo)dimension.getSelectMembers().get(m)).getNumber();
                                }
                                if (number == null) continue;
                                bgPeriodNumbers.add(BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriod.getNumber(), (String)number, (int)bgPeriod.getPeriodType().getValue()));
                            }
                        }
                    }
                }
                catch (BgPeriodException e) {
                    if (StringUtils.isEmpty(number)) {
                        number = BgFormHelper.getPeriodNNumber(bgPeriodNumbers, (IMbgViewBase)viewManager, (BgPeriodInfo)bgPeriod, null);
                    }
                    resultMap.put(this.getKey(null, bgTempateId, bgPeriod.getId(), null, null), new String[]{"checkConvertPeriodNCSL1", number});
                    continue;
                }
                String notExists = this.checkPeriodExists(conn, periodCacheMap, bgPeriodNumbers, schemeBegin, schemeEnd);
                if (notExists == null) continue;
                resultMap.put(this.getKey(null, bgTempateId, bgPeriod.getId(), null, null), new String[]{"checkPeriodExistsCSL", notExists});
            }
        }
        return resultMap;
    }

    private Map<String, IMbgViewBase> getViewMap(Context ctx, Object[] bgTemplateInfos) throws Exception {
        HashMap<String, IMbgViewBase> result = new HashMap<String, IMbgViewBase>();
        Set ids = DimensionCommonHelper.getIds((Object[])bgTemplateInfos);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("dimensionData");
        evi.getSelector().add("id");
        evi.getSelector().add("formType");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        BgCslTemplateCollection col = BgCslTemplateFactory.getLocalInstance(ctx).getBgCslTemplateCollection(evi);
        byte[] datas = null;
        MbgXMLParser viewParser = new MbgXMLParser(ctx);
        MbgViewListXMLParser viewListParser = new MbgViewListXMLParser(ctx);
        for (int i = 0; i < col.size(); ++i) {
            datas = col.get(i).getDimensionData();
            if (datas == null || datas.length == 0) continue;
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)col.get(i).getFormType())) {
                result.put(col.get(i).getId().toString(), (IMbgViewBase)viewListParser.parse(datas));
                continue;
            }
            result.put(col.get(i).getId().toString(), (IMbgViewBase)viewParser.parse(datas));
        }
        return result;
    }

    private Map<String, String> getSpecialMember(BgCslFormInfo baseInfo) throws EASBizException, BOSException {
        if (baseInfo.getBgSpecialItems() == null || baseInfo.getBgSpecialItems().isEmpty()) {
            return null;
        }
        String[] specialNumbes = baseInfo.getBgSpecialItems().get(0).getDimensionNumber().split(DimensionConstants.COMMA_SEPARATOR);
        String[] dimNames = baseInfo.getBgSpecialItems().get(0).getMemberName().split(DimensionConstants.TICK_SEPARATOR);
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < specialNumbes.length; ++i) {
            result.put(specialNumbes[i], dimNames[i]);
        }
        return result;
    }

    private Map<String, Set<String>> getExistsSpecialMember(Context ctx, Map<String, String> specialMember, Set<String> orgIds, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        if (specialMember == null || specialMember.isEmpty()) {
            return null;
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        IDimensionFormulaFacade facade = DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx);
        HashSet<String> numbers = new HashSet<String>();
        for (String combin : specialMember.keySet()) {
            String srcNumber = DimensionFormulaHelper.getSrcNumber((String)combin);
            String number = DimensionFormulaHelper.getMemberNumber((String)combin);
            String dimNumber = ((BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(srcNumber)).getNumber();
            numbers.clear();
            numbers.add(number);
            for (String orgId : orgIds) {
                Map _map;
                if (!result.containsKey(orgId)) {
                    result.put(orgId, new HashSet());
                }
                if ((_map = facade.queryMembers(orgId, schemeHelper, dimNumber, numbers, false, null)) == null || _map.isEmpty()) continue;
                ((Set)result.get(orgId)).add(combin);
            }
        }
        return result;
    }

    public static void copyBizAttachmentFiles(AttachmentServerManager attachmentServerManager, BgCslFormInfo info, String sourceID, String destID) throws BOSException, EASBizException {
        if (info != null) {
            sourceID = info.getBgCslTemplate().getId().toString();
            destID = info.getId().toString();
        }
        String[] attachmentIDsByBoID = attachmentServerManager.getAttachmentIDsByBoID(destID);
        for (int i = 0; attachmentIDsByBoID != null && i < attachmentIDsByBoID.length; ++i) {
            if (StringUtils.isEmpty((String)attachmentIDsByBoID[i]) || "null".equalsIgnoreCase(attachmentIDsByBoID[i])) continue;
            attachmentServerManager.deleteOneAssociation(destID, attachmentIDsByBoID[i]);
        }
        attachmentServerManager.copyBizAttachmentFiles(sourceID, destID);
    }

    private String checkSpecialNoExists(BgCslFormInfo bgFormInfo, Map<String, String> specialMember, Map<String, Set<String>> existsSpecialMember) {
        if (bgFormInfo != null && bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty() && specialMember != null && !specialMember.isEmpty()) {
            for (String combin : specialMember.keySet()) {
                String display = specialMember.get(combin) + "(" + DimensionFormulaHelper.getMemberNumber((String)combin) + ")";
                if (existsSpecialMember == null || existsSpecialMember.isEmpty()) {
                    return display;
                }
                Set<String> subSet = existsSpecialMember.get(bgFormInfo.getOrgUnit().getId().toString());
                if (subSet != null && !subSet.isEmpty() && subSet.contains(combin)) continue;
                return display;
            }
        }
        return null;
    }
}

