/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslFormCourseFacadeControllerBean;
import com.kingdee.eas.ma.bgcsl.utils.BgCslFormCourseHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslFormCourseFacadeControllerBean
extends AbstractBgCslFormCourseFacadeControllerBean {
    private static final long serialVersionUID = 4223628694001514660L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslFormCourseFacadeControllerBean");

    private Integer getSelectOrgUnitType(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        return (Integer)parameter.get("SEL_ORGUNIT_TYPE");
    }

    private String getOrgTreeId(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        return (String)parameter.get("CURR_ORGTREE_ID");
    }

    private String getOrgViewId(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        return (String)parameter.get("CURR_ORGUNIT_VIEW_ID");
    }

    private boolean getIsForbid(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return false;
        }
        return (Boolean)parameter.get("IS_FORBID");
    }

    private String getCurUserID(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        return (String)parameter.get("CURR_USER_ID");
    }

    private String getSelectOrgId(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        return (String)parameter.get("SEL_ORGUNIT_ID");
    }

    private Set<String> getSelectSchemeIDS(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String[] selectSchemeIDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        return BgCslFormCourseHelper.copyArrayToSet(selectSchemeIDS);
    }

    private Set<String> getSelectPeriodIDS(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String[] selectPeriodIDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        return BgCslFormCourseHelper.copyArrayToSet(selectPeriodIDS);
    }

    private Set<String> getSelectCurrencyIDS(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String[] selectCurrencyIDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        return BgCslFormCourseHelper.copyArrayToSet(selectCurrencyIDS);
    }

    private Set<String> getSelectVersionIDS(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String[] selectVersionIDS = (String[])parameter.get("SEL_BGVERSION_IDS");
        return BgCslFormCourseHelper.copyArrayToSet(selectVersionIDS);
    }

    private Set<String> getSelectTemplateIDS(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String[] selectTemplateIDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        return BgCslFormCourseHelper.copyArrayToSet(selectTemplateIDS);
    }

    private Set<String> getSelectCslTemplateIDS(Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String[] selectCslTemplateIDS = (String[])parameter.get("SEL_CSLTEMPLATE_IDS");
        return BgCslFormCourseHelper.copyArrayToSet(selectCslTemplateIDS);
    }

    private FullOrgUnitInfo getOrgUnitInfo(Context ctx, String orgUnitId) throws EASBizException, BOSException {
        if (ctx == null || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        return FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo("select id, name, number, longNumber, level where id = '" + orgUnitId + "'");
    }

    private Set<Integer> getUnQueryFormStates() {
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        state.add(new Integer(5));
        return state;
    }

    private Map<String, List<String>> getOrgIdsMap(Context ctx, String orgTreeId, String curOrgId, Integer selectType) throws EASBizException, BOSException {
        HashMap<String, List<String>> orgIdsMap;
        block13: {
            List orgIdList;
            block14: {
                block12: {
                    orgIdsMap = new HashMap<String, List<String>>();
                    if (StringUtils.isEmpty((String)orgTreeId) || StringUtils.isEmpty((String)curOrgId)) {
                        return orgIdsMap;
                    }
                    IObjectPK userPK = ctx.getCaller();
                    orgIdList = null;
                    if (userPK != null) {
                        orgIdList = OrgRangeFactory.getLocalInstance((Context)ctx).getOrgIdByUserAndType(userPK, OrgRangeType.BIZ_ORG_TYPE);
                    }
                    if (orgIdList == null || orgIdList.isEmpty()) {
                        return orgIdsMap;
                    }
                    orgIdsMap.put("KEY_CSLORGUNIT", new ArrayList());
                    orgIdsMap.put("KEY_BGORGUNIT", new ArrayList());
                    if (!selectType.equals(1)) break block12;
                    if (!orgIdList.contains(curOrgId)) {
                        return orgIdsMap;
                    }
                    if (BgCslFormCourseHelper.isOrgGroup(ctx, curOrgId).booleanValue()) {
                        ((List)orgIdsMap.get("KEY_CSLORGUNIT")).add(curOrgId);
                    } else {
                        ((List)orgIdsMap.get("KEY_BGORGUNIT")).add(curOrgId);
                    }
                    break block13;
                }
                if (!selectType.equals(2)) break block14;
                IOrgStructure iOrgStructure = OrgStructureFactory.getLocalInstance((Context)ctx);
                OrgStructureInfo osi = iOrgStructure.getOrgStructureInfo("select id, number, name, longNumber, unit.id, unit.isGrouping, tree.id where unit.id = '" + curOrgId + "' and tree.id = '" + orgTreeId + "'");
                OrgStructureCollection colls = iOrgStructure.getOrgStructureCollection("select id, unit.id, unit.name, unit.number, unit.longNumber, unit.isGrouping where parent.id = '" + osi.getId().toString() + "' order by longNumber ");
                colls.add(osi);
                OrgStructureInfo osInfo = null;
                FullOrgUnitInfo unitInfo = null;
                for (int index = 0; index < colls.size(); ++index) {
                    osInfo = colls.get(index);
                    unitInfo = osInfo.getUnit();
                    if (!orgIdList.contains(unitInfo.getId().toString())) {
                        colls.remove(osInfo);
                        --index;
                        continue;
                    }
                    if (unitInfo.isIsGrouping()) {
                        ((List)orgIdsMap.get("KEY_CSLORGUNIT")).add(unitInfo.getId().toString());
                        continue;
                    }
                    ((List)orgIdsMap.get("KEY_BGORGUNIT")).add(unitInfo.getId().toString());
                }
                break block13;
            }
            if (!selectType.equals(3)) break block13;
            IOrgStructure iOrgStructure = OrgStructureFactory.getLocalInstance((Context)ctx);
            OrgStructureInfo osi = iOrgStructure.getOrgStructureInfo("select id, number, name, longNumber, unit.id, unit.isGrouping, tree.id where unit.id = '" + curOrgId + "' and tree.id = '" + orgTreeId + "'");
            OrgStructureCollection colls = iOrgStructure.getOrgStructureCollection("select id, unit.id, unit.name, unit.number, unit.longNumber, unit.isGrouping where longNumber like '" + osi.getLongNumber() + "!%' and tree.id = '" + orgTreeId + "' order by LongNumber");
            colls.add(osi);
            OrgStructureInfo osInfo = null;
            FullOrgUnitInfo unitInfo = null;
            for (int index = 0; index < colls.size(); ++index) {
                osInfo = colls.get(index);
                unitInfo = osInfo.getUnit();
                if (!orgIdList.contains(unitInfo.getId().toString())) {
                    colls.remove(osInfo);
                    --index;
                    continue;
                }
                if (unitInfo.isIsGrouping()) {
                    ((List)orgIdsMap.get("KEY_CSLORGUNIT")).add(unitInfo.getId().toString());
                    continue;
                }
                ((List)orgIdsMap.get("KEY_BGORGUNIT")).add(unitInfo.getId().toString());
            }
        }
        return orgIdsMap;
    }

    @Override
    protected Map _queryCourseInfo(Context ctx, Map parameter) throws BOSException, EASBizException {
        Connection conn;
        HashMap<String, Map> courseMap;
        block12: {
            TempTablePool pool;
            String tmpOrgTable;
            block13: {
                courseMap = new HashMap<String, Map>();
                if (parameter == null || parameter.isEmpty()) {
                    return courseMap;
                }
                Map<String, List<String>> orgIdsMap = this.getOrgIdsMap(ctx, this.getOrgTreeId(parameter), this.getSelectOrgId(parameter), this.getSelectOrgUnitType(parameter));
                if (orgIdsMap == null || orgIdsMap.isEmpty()) {
                    return courseMap;
                }
                List<String> orgGroupIds = orgIdsMap.get("KEY_CSLORGUNIT");
                List<String> orgUnitIds = orgIdsMap.get("KEY_BGORGUNIT");
                String tmpOrgGroup = null;
                tmpOrgTable = null;
                conn = null;
                pool = TempTablePool.getInstance((Context)ctx);
                try {
                    conn = this.getConnection(ctx);
                    tmpOrgGroup = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgGroup + "(FID) values (?)"), orgGroupIds);
                    tmpOrgTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + "(FID) values (?)"), orgUnitIds);
                    Map cslMap = this.queryCslCourseInfo(ctx, parameter, tmpOrgGroup);
                    Map bgMap = this.queryBgCourseInfo(ctx, parameter, tmpOrgTable);
                    if (cslMap != null && !cslMap.isEmpty()) {
                        courseMap.put("KEY_CSLORGUNIT", cslMap);
                    }
                    if (bgMap != null && !bgMap.isEmpty()) {
                        courseMap.put("KEY_BGORGUNIT", bgMap);
                    }
                    if (pool == null) break block12;
                    if (tmpOrgGroup == null) break block13;
                }
                catch (Exception ex) {
                    try {
                        throw new BOSException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        if (pool != null) {
                            if (tmpOrgGroup != null) {
                                pool.releaseTable(tmpOrgGroup);
                            }
                            if (tmpOrgTable != null) {
                                pool.releaseTable(tmpOrgTable);
                            }
                        }
                        SQLUtils.cleanup((Connection)conn);
                        throw throwable;
                    }
                }
                pool.releaseTable(tmpOrgGroup);
            }
            if (tmpOrgTable != null) {
                pool.releaseTable(tmpOrgTable);
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return courseMap;
    }

    protected Map queryBgCourseInfo(Context ctx, Map parameter, String tmpOrgTable) throws BOSException, EASBizException {
        if (parameter == null || parameter.isEmpty() || StringUtils.isEmpty((String)tmpOrgTable)) {
            return null;
        }
        boolean isForbid = this.getIsForbid(parameter);
        HashMap<String, Map<String, Object[]>> resultMap = new HashMap<String, Map<String, Object[]>>();
        Map bgFormMap = this.queryBgFormMap(ctx, parameter, tmpOrgTable);
        Map<String, Map<String, CoreBaseInfo>> bgTemplateMap = BgCslFormCourseHelper.queryBgTemplateInfo(ctx, this.getCurUserID(parameter), this.getSelectOrgId(parameter), tmpOrgTable, this.getSelectSchemeIDS(parameter), this.getSelectTemplateIDS(parameter), false, this.getIsForbid(parameter));
        BgPeriodCollection bgPeriodCol = BgCslFormCourseHelper.queryBgPeriod(ctx, this.getSelectPeriodIDS(parameter));
        CurrencyCollection currencyCol = BgCslFormCourseHelper.queryCurrency(ctx, this.getSelectCurrencyIDS(parameter));
        BgVersionCollection bgVersionCol = BgCslFormCourseHelper.queryBgVersion(ctx, this.getSelectVersionIDS(parameter));
        Map<String, Object[]> keyMap = BgCslFormCourseHelper.getKeyMap(BgCslFormCourseHelper.queryOrgInfo(ctx, this.getOrgViewId(parameter), tmpOrgTable), bgTemplateMap, bgPeriodCol, currencyCol, bgVersionCol, bgFormMap);
        resultMap.put("key2BgformMap", bgFormMap);
        resultMap.put("keyMap", keyMap);
        return resultMap;
    }

    private Map queryBgFormMap(Context ctx, Map parameter, String tmpOrgTable) throws EASBizException, BOSException {
        if (ctx == null || parameter == null || tmpOrgTable == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = BgCslFormCourseHelper.getBgFormSelectorItem();
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", this.getSelectSchemeIDS(parameter), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", this.getSelectVersionIDS(parameter), CompareType.INCLUDE));
        boolean isTemplateIdsEmpty = EmptyUtil.isEmpty(this.getSelectTemplateIDS(parameter));
        if (!isTemplateIdsEmpty) {
            StringBuilder sb = new StringBuilder();
            sb.append("select frootid from T_MBG_BgTemplate where fid in (");
            for (String object : this.getSelectTemplateIDS(parameter)) {
                sb.append("'").append(object.toString()).append("',");
            }
            sb = sb.deleteCharAt(sb.lastIndexOf(","));
            sb.append(")");
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.root.id", (Object)sb.toString(), CompareType.INNER));
        }
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", this.getSelectPeriodIDS(parameter), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", this.getSelectCurrencyIDS(parameter), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", this.getUnQueryFormStates(), CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)("select FID from " + tmpOrgTable), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 6, 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        if (this.getIsForbid(parameter)) {
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.templateStatus", (Object)0, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("processType", (Object)1));
        if (!isTemplateIdsEmpty) {
            if (this.getIsForbid(parameter)) {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 and (#8 or #9) and #10 and #11");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and #7 and (#8 or #9) and #10");
            }
        } else if (this.getIsForbid(parameter)) {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and (#7 or #8) and #9 and #10");
        } else {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and #6 and (#7 or #8) and #9");
        }
        view.setFilter(filter);
        return BgCslFormCourseHelper.queryBgFormFromDB(ctx, view);
    }

    private Map<String, IDimDataQuery> queryCslFormMap(Context ctx, Map parameter, String tmpOrgGroup) throws EASBizException, BOSException {
        if (ctx == null || parameter == null || tmpOrgGroup == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = BgCslFormCourseHelper.getCslFormSelectorItem();
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", this.getSelectSchemeIDS(parameter), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgVersion.id", this.getSelectVersionIDS(parameter), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", this.getSelectPeriodIDS(parameter), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", this.getSelectCurrencyIDS(parameter), CompareType.INCLUDE));
        boolean isTemplateIdsEmpty = EmptyUtil.isEmpty(this.getSelectCslTemplateIDS(parameter));
        if (!isTemplateIdsEmpty) {
            filter.getFilterItems().add(new FilterItemInfo("bgCslTemplate.id", this.getSelectCslTemplateIDS(parameter), CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)("select FID from " + tmpOrgGroup), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("bgCslTemplate.bgType.id", null));
        filter.getFilterItems().add(new FilterItemInfo("bgCslTemplate.bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)this.getOrgTreeId(parameter), CompareType.EQUALS));
        if (this.getIsForbid(parameter)) {
            filter.getFilterItems().add(new FilterItemInfo("bgCslTemplate.templateStatus", (Object)0, CompareType.EQUALS));
        }
        if (!isTemplateIdsEmpty) {
            if (this.getIsForbid(parameter)) {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and (#6 or #7) and #8 and #9");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5 and (#6 or #7) and #8");
            }
        } else if (this.getIsForbid(parameter)) {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or #6) and #7 and #8");
        } else {
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or #6) and #7");
        }
        view.setFilter(filter);
        return BgCslFormCourseHelper.queryCslFormFromDB(ctx, view);
    }

    protected Map queryCslCourseInfo(Context ctx, Map parameter, String tmpOrgGroup) throws BOSException, EASBizException {
        if (parameter == null || parameter.isEmpty() || StringUtils.isEmpty((String)tmpOrgGroup)) {
            return null;
        }
        boolean isForbid = this.getIsForbid(parameter);
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        Map<String, IDimDataQuery> bgFormMap = this.queryCslFormMap(ctx, parameter, tmpOrgGroup);
        Map<String, Map<String, CoreBaseInfo>> bgTemplateMap = BgCslFormCourseHelper.queryCslTemplateInfo(ctx, this.getOrgTreeId(parameter), this.getCurUserID(parameter), this.getSelectOrgId(parameter), this.getSelectSchemeIDS(parameter), this.getSelectCslTemplateIDS(parameter), this.getIsForbid(parameter), false);
        BgPeriodCollection bgPeriodCol = BgCslFormCourseHelper.queryBgPeriod(ctx, this.getSelectPeriodIDS(parameter));
        CurrencyCollection currencyCol = BgCslFormCourseHelper.queryCurrency(ctx, this.getSelectCurrencyIDS(parameter));
        BgVersionCollection bgVersionCol = BgCslFormCourseHelper.queryBgVersion(ctx, this.getSelectVersionIDS(parameter));
        Map<String, Object[]> keyMap = BgCslFormCourseHelper.getKeyMap(BgCslFormCourseHelper.queryOrgInfo(ctx, this.getOrgViewId(parameter), tmpOrgGroup), bgTemplateMap, bgPeriodCol, currencyCol, bgVersionCol, bgFormMap);
        resultMap.put("key2BgformMap", bgFormMap);
        resultMap.put("keyMap", keyMap);
        return resultMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _loadColorScheme(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Integer _state = null;
        String _color = null;
        HashMap<Integer, String> colorScheme = new HashMap<Integer, String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FState, FColor from T_MBG_BgCslColorScheme");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _state = new Integer(rst.getInt(1));
                _color = rst.getString(2);
                colorScheme.put(_state, _color);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return colorScheme;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveColorScheme(Context ctx, Map colorScheme) throws BOSException, EASBizException {
        if (colorScheme == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map.Entry _entry2222222 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_MBG_BgCslColorScheme");
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("insert into T_MBG_BgCslColorScheme (FState, FColor) values(?, ?)");
            for (Map.Entry _entry2222222 : colorScheme.entrySet()) {
                pstmt.setInt(1, (Integer)_entry2222222.getKey());
                pstmt.setString(2, (String)_entry2222222.getValue());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _queryOrgInfo(Context ctx, Map parameter) throws BOSException, EASBizException {
        HashMap courseMap = new HashMap();
        if (parameter == null || parameter.isEmpty()) {
            return courseMap;
        }
        Boolean isOrgGroup = BgCslFormCourseHelper.isOrgGroup(ctx, this.getSelectOrgId(parameter));
        Map<String, List<String>> orgIdsMap = null;
        orgIdsMap = isOrgGroup != false && this.getSelectOrgUnitType(parameter).equals(1) ? this.getOrgIdsMap(ctx, this.getOrgTreeId(parameter), this.getSelectOrgId(parameter), 2) : this.getOrgIdsMap(ctx, this.getOrgTreeId(parameter), this.getSelectOrgId(parameter), this.getSelectOrgUnitType(parameter));
        List<String> orgGroupIds = orgIdsMap.get("KEY_CSLORGUNIT");
        List<String> orgUnitIds = orgIdsMap.get("KEY_BGORGUNIT");
        Map cslMap = this.queryCslOrgInfo(ctx, parameter, new HashSet<String>(orgGroupIds));
        Map bgMap = this.queryBgOrgInfo(ctx, parameter, new HashSet<String>(orgUnitIds));
        courseMap.putAll(cslMap);
        courseMap.putAll(bgMap);
        return courseMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map queryCslOrgInfo(Context ctx, Map parameter, Set<String> queryOrgUnitIds) throws BOSException, EASBizException {
        if (parameter == null) return new HashMap();
        if (parameter.isEmpty()) return new HashMap();
        if (queryOrgUnitIds.isEmpty()) {
            return new HashMap();
        }
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_CSLTEMPLATE_IDS = (String[])parameter.get("SEL_CSLTEMPLATE_IDS");
        HashMap<String, Map<Integer, BigDecimal>> _dataMap = new HashMap<String, Map<Integer, BigDecimal>>();
        Map<Integer, BigDecimal> _tmpMap = null;
        HashMap _dataOfTemplateMap = new HashMap();
        int _state = 0;
        int _count = 0;
        boolean formSum = false;
        String _orgUnitId = null;
        String _bgPeriodId = null;
        String _bgVersionId = null;
        String _bgTemplateId = null;
        String org_period_version = null;
        Set<String> temp = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] querySql = this.getSql_PlanQueryCslOrgInfo(parameter, queryOrgUnitIds);
        String sql = (String)querySql[0];
        List paramsList = (List)querySql[1];
        try {
            this.planQueryCslOrgCount(parameter, ctx, this.getOrgTreeId(parameter), _dataMap, queryOrgUnitIds, SEL_BGSCHEME_IDS, SEL_CSLTEMPLATE_IDS);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, (List)paramsList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString(1);
                _bgPeriodId = rst.getString(2);
                _bgVersionId = rst.getString(3);
                _state = rst.getInt(4);
                _count = rst.getInt(6);
                _bgTemplateId = rst.getString(7);
                org_period_version = _orgUnitId + ";" + _bgPeriodId + ";" + _bgVersionId;
                if (_dataMap.containsKey(org_period_version)) {
                    _tmpMap = (Map)_dataMap.get(org_period_version);
                } else {
                    _tmpMap = new HashMap();
                    _dataMap.put(org_period_version, _tmpMap);
                }
                if (_tmpMap.containsKey(new Integer(_state))) {
                    _tmpMap.put(new Integer(_state), ((BigDecimal)_tmpMap.get(new Integer(_state))).add(new BigDecimal(_count)));
                } else {
                    _tmpMap.put(new Integer(_state), new BigDecimal(_count));
                }
                if (_tmpMap.containsKey(new Integer(10000))) {
                    temp = (Set)_tmpMap.get(new Integer(10000));
                } else {
                    temp = new HashSet();
                    _tmpMap.put(new Integer(10000), (BigDecimal)((Object)temp));
                }
                temp.add(_bgTemplateId);
                if (_tmpMap.containsKey(new Integer(10001))) {
                    _tmpMap.put(new Integer(10001), ((BigDecimal)_tmpMap.get(10001)).add(new BigDecimal(_count)));
                    continue;
                }
                _tmpMap.put(new Integer(10001), new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    public Object[] getSql_PlanQueryCslOrgInfo(Map parameter, Set<String> filtedQueryBgOrgUnitIds) {
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] SEL_CSLTEMPLATE_IDS = (String[])parameter.get("SEL_CSLTEMPLATE_IDS");
        String[] SEL_BGVERSION_IDS = (String[])parameter.get("SEL_BGVERSION_IDS");
        Object[] returnObj = new Object[2];
        String id2 = null;
        String obj2 = null;
        ArrayList<String> tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select f.FOrgUnitId,f.FBgPeriodId,f.FBgVersionID, f.FState,t.fid, count(f.FID),f.FBgCslTemplateID from T_MBG_BgCslForm f ").append(" left join T_MBg_BgScheme s on f.Fbgschemeid = s.fid ").append(" left join T_MBG_BgCslTemplate t on f.FBgCslTemplateID = t.FID ").append(" where (f.FBgTypeId is null or f.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ").append(" and f.FOrgUnitId IN (");
        for (String obj2 : filtedQueryBgOrgUnitIds) {
            if (obj2 == null) continue;
            sql.append("?,");
            tmpList.add(obj2.toString());
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") ");
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length > 0) {
            sql.append(" AND s.FId IN (");
            for (String id2 : SEL_BGSCHEME_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_CSLTEMPLATE_IDS != null && SEL_CSLTEMPLATE_IDS.length > 0) {
            sql.append(" AND t.FID IN (");
            for (String id2 : SEL_CSLTEMPLATE_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGPERIOD_IDS != null && SEL_BGPERIOD_IDS.length > 0) {
            sql.append(" AND f.FBgPeriodId IN (");
            for (String id2 : SEL_BGPERIOD_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.FCurrencyId IN (");
            for (String id2 : SEL_CURRENCY_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGVERSION_IDS != null && SEL_BGVERSION_IDS.length > 0) {
            sql.append(" AND f.FBgVersionID IN (");
            for (String id2 : SEL_BGVERSION_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (this.getIsForbid(parameter)) {
            sql.append(" AND t.FTemplateStatus =0");
        }
        sql.append(" group by f.FOrgUnitID,f.FBgPeriodId,f.FBgVersionID, f.FState,t.fid,f.FBgCslTemplateID");
        returnObj[0] = sql.toString();
        returnObj[1] = tmpList;
        return returnObj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void planQueryCslOrgCount(Map parameter, Context ctx, String orgTreeId, Map queryMap, Set orgUnitIds, String[] bgSchemeRootIds, String[] bgTemplateRootIDS) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (parameter == null) {
            return;
        }
        int _count = 0;
        Integer _state = new Integer(100);
        String _orgUnitId2222222 = null;
        Map<Integer, BigDecimal> _tmpMap = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select count(n.fid) from T_MBG_BgCslTemplate n ").append("where n.FOrgTreeID = '" + orgTreeId + "'");
        if (bgSchemeRootIds != null && bgSchemeRootIds.length > 0) {
            sql.append(" AND n.FBgSchemeId IN (");
            for (String schemeid : bgSchemeRootIds) {
                sql.append("?,");
                _tmpList.add(schemeid);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            sql.append(" AND n.FID IN (");
            for (String templateId : bgTemplateRootIDS) {
                sql.append("?,");
                _tmpList.add(templateId);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (this.getIsForbid(parameter)) {
            sql.append(" AND n.FTemplateStatus =0");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _count = rst.getInt(1);
                for (String _orgUnitId2222222 : orgUnitIds) {
                    if (queryMap.containsKey(_orgUnitId2222222)) {
                        _tmpMap = (Map)queryMap.get(_orgUnitId2222222);
                    } else {
                        _tmpMap = new HashMap();
                        queryMap.put(_orgUnitId2222222, _tmpMap);
                    }
                    _tmpMap.put(_state, new BigDecimal(_count));
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map queryBgOrgInfo(Context ctx, Map parameter, Set<String> queryOrgUnitIds) throws BOSException, EASBizException {
        if (parameter == null) return new HashMap();
        if (parameter.isEmpty()) return new HashMap();
        if (queryOrgUnitIds.isEmpty()) {
            return new HashMap();
        }
        String CURR_USER_ID = (String)parameter.get("CURR_USER_ID");
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGTEMPLATE_IDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        HashMap<String, Map<Integer, BigDecimal>> _dataMap = new HashMap<String, Map<Integer, BigDecimal>>();
        Map<Integer, BigDecimal> _tmpMap = null;
        HashMap _dataOfTemplateMap = new HashMap();
        int _state = 0;
        int _count = 0;
        boolean formSum = false;
        String _orgUnitId = null;
        String _bgPeriodId = null;
        String _bgVersionId = null;
        String _bgTemplateId = null;
        String org_period_version = null;
        Set<String> temp = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] querySql = this.getSql_PlanQueryBgOrgInfo(parameter, queryOrgUnitIds);
        String sql = (String)querySql[0];
        List paramsList = (List)querySql[1];
        try {
            this.planQueryBgOrgCount(parameter, ctx, CURR_USER_ID, _dataMap, queryOrgUnitIds, SEL_BGSCHEME_IDS, SEL_BGTEMPLATE_IDS);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, (List)paramsList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString(1);
                _bgPeriodId = rst.getString(2);
                _bgVersionId = rst.getString(3);
                _state = rst.getInt(4);
                _bgTemplateId = rst.getString(7);
                _count = rst.getInt(6);
                org_period_version = _orgUnitId + ";" + _bgPeriodId + ";" + _bgVersionId;
                if (_dataMap.containsKey(org_period_version)) {
                    _tmpMap = (Map)_dataMap.get(org_period_version);
                } else {
                    _tmpMap = new HashMap();
                    _dataMap.put(org_period_version, _tmpMap);
                }
                if (_tmpMap.containsKey(new Integer(_state))) {
                    _tmpMap.put(new Integer(_state), ((BigDecimal)_tmpMap.get(new Integer(_state))).add(new BigDecimal(_count)));
                } else {
                    _tmpMap.put(new Integer(_state), new BigDecimal(_count));
                }
                if (_tmpMap.containsKey(new Integer(10000))) {
                    temp = (Set)_tmpMap.get(new Integer(10000));
                } else {
                    temp = new HashSet();
                    _tmpMap.put(new Integer(10000), (BigDecimal)((Object)temp));
                }
                temp.add(_bgTemplateId);
                if (_tmpMap.containsKey(new Integer(10001))) {
                    _tmpMap.put(new Integer(10001), ((BigDecimal)_tmpMap.get(10001)).add(new BigDecimal(_count)));
                    continue;
                }
                _tmpMap.put(new Integer(10001), new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    public Object[] getSql_PlanQueryBgOrgInfo(Map parameter, Set<String> filtedQueryBgOrgUnitIds) {
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] SEL_BGTEMPLATE_IDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        String[] SEL_BGVERSION_IDS = (String[])parameter.get("SEL_BGVERSION_IDS");
        Object[] returnObj = new Object[2];
        String id2 = null;
        String obj2 = null;
        ArrayList<String> tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FOrgUnitId,f.FBgPeriodId,f.Fbgversionid, f.FState,t.FID, count(f.FID),f.FBgTemplateId from T_MBg_BgForm f ").append("left join T_MBg_BgScheme s on f.Fbgschemeid = s.fid ").append("left join T_MBg_BgTemplate t on f.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ").append(" and t.FIsReadOnly = 0").append(" and f.FProcessType = 1").append(" and f.FOrgUnitId IN (");
        for (String obj2 : filtedQueryBgOrgUnitIds) {
            if (obj2 == null) continue;
            sql.append("?,");
            tmpList.add(obj2.toString());
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") ");
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length > 0) {
            sql.append(" AND s.FId IN (");
            for (String id2 : SEL_BGSCHEME_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGTEMPLATE_IDS != null && SEL_BGTEMPLATE_IDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            for (String id2 : SEL_BGTEMPLATE_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGPERIOD_IDS != null && SEL_BGPERIOD_IDS.length > 0) {
            sql.append(" AND f.FBgPeriodId IN (");
            for (String id2 : SEL_BGPERIOD_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.FCurrencyId IN (");
            for (String id2 : SEL_CURRENCY_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGVERSION_IDS != null && SEL_BGVERSION_IDS.length > 0) {
            sql.append(" AND f.Fbgversionid IN (");
            for (String id2 : SEL_BGVERSION_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (this.getIsForbid(parameter)) {
            sql.append(" AND t.FTemplateStatus =0");
        }
        sql.append(" AND f.FID not in (select fadjustId from T_MBg_BgForm  where fid <> fadjustid) ");
        sql.append(" group by f.FOrgUnitId,f.FBgPeriodId,f.Fbgversionid, f.FState,t.fid,f.FBgTemplateId");
        returnObj[0] = sql.toString();
        returnObj[1] = tmpList;
        return returnObj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void planQueryBgOrgCount(Map parameter, Context ctx, String userId, Map queryMap, Set orgUnitIds, String[] bgSchemeRootIds, String[] bgTemplateRootIDS) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (parameter == null) {
            return;
        }
        int _count = 0;
        Integer _state = new Integer(100);
        String _rootId2222222 = null;
        String _orgUnitId2222222 = null;
        Map<Integer, BigDecimal> _tmpMap = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select n.FOrgUnitId, count(n.fid) from T_MBg_BgTemplateNode n ").append("left join T_MBg_BgTemplate t on n.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ").append(" and t.FIsReadOnly = 0 ");
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and n.FOrgUnitId IN (");
            for (String _orgUnitId2222222 : orgUnitIds) {
                sql.append("?,");
                _tmpList.add(_orgUnitId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgSchemeRootIds != null && bgSchemeRootIds.length > 0) {
            sql.append(" AND t.FBgSchemeId IN (");
            for (String _rootId2222222 : bgSchemeRootIds) {
                sql.append("?,");
                _tmpList.add(_rootId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            for (String _rootId2222222 : bgTemplateRootIDS) {
                sql.append("?,");
                _tmpList.add(_rootId2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (this.getIsForbid(parameter)) {
            sql.append(" AND t.FTemplateStatus =0");
        }
        sql.append(" group by n.FOrgUnitId");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId2222222 = rst.getString(1);
                _count = rst.getInt(2);
                if (queryMap.containsKey(_orgUnitId2222222)) {
                    _tmpMap = (Map)queryMap.get(_orgUnitId2222222);
                } else {
                    _tmpMap = new HashMap();
                    queryMap.put(_orgUnitId2222222, _tmpMap);
                }
                _tmpMap.put(_state, new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _queryTempInfo(Context ctx, Map parameter) throws BOSException, EASBizException {
        HashMap<String, Map> courseMap = new HashMap<String, Map>();
        if (parameter == null || parameter.isEmpty()) {
            return courseMap;
        }
        Boolean isOrgGroup = BgCslFormCourseHelper.isOrgGroup(ctx, this.getSelectOrgId(parameter));
        Map<String, List<String>> orgIdsMap = null;
        orgIdsMap = isOrgGroup != false && this.getSelectOrgUnitType(parameter).equals(1) ? this.getOrgIdsMap(ctx, this.getOrgTreeId(parameter), this.getSelectOrgId(parameter), 2) : this.getOrgIdsMap(ctx, this.getOrgTreeId(parameter), this.getSelectOrgId(parameter), this.getSelectOrgUnitType(parameter));
        if (orgIdsMap == null || orgIdsMap.isEmpty()) {
            return courseMap;
        }
        List<String> orgGroupIds = orgIdsMap.get("KEY_CSLORGUNIT");
        List<String> orgUnitIds = orgIdsMap.get("KEY_BGORGUNIT");
        Map cslMap = this.queryCslTemplateInfo(ctx, parameter, new HashSet<String>(orgGroupIds));
        Map bgMap = this.queryBgTemplateInfo(ctx, parameter, new HashSet<String>(orgUnitIds));
        courseMap.put("KEY_CSLORGUNIT", cslMap);
        courseMap.put("KEY_BGORGUNIT", bgMap);
        return courseMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map queryCslTemplateInfo(Context ctx, Map parameter, Set<String> queryOrgUnitIds) throws BOSException, EASBizException {
        if (parameter == null) return new HashMap();
        if (parameter.isEmpty()) return new HashMap();
        if (queryOrgUnitIds.isEmpty()) {
            return new HashMap();
        }
        String CURR_USER_ID = (String)parameter.get("CURR_USER_ID");
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_CSLTEMPLATE_IDS = (String[])parameter.get("SEL_CSLTEMPLATE_IDS");
        String CURR_ORGTREE_ID = parameter.get("CURR_ORGTREE_ID").toString();
        HashMap<String, Map<Integer, BigDecimal>> _dataMap = new HashMap<String, Map<Integer, BigDecimal>>();
        Map<Integer, BigDecimal> _tmpMap = null;
        LinkedHashMap<String, String> _nameMap = new LinkedHashMap<String, String>();
        HashMap _dataOfTemplateMap = new HashMap();
        int _state = 0;
        int _count = 0;
        boolean formSum = false;
        String _name = null;
        String _rootId = null;
        String bgPeriodId = null;
        String bgVersionId = null;
        String bgOrgunitId = null;
        Set<String> temp = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] querySql = this.getSql_PlanQueryCslTemplate(parameter, queryOrgUnitIds);
        String sql = (String)querySql[0];
        List paramsList = (List)querySql[1];
        try {
            this.queryCslTemplateCount(parameter, ctx, CURR_USER_ID, _dataMap, _nameMap, queryOrgUnitIds, SEL_BGSCHEME_IDS, SEL_CSLTEMPLATE_IDS, CURR_ORGTREE_ID);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, (List)paramsList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _name = rst.getString(1);
                _rootId = rst.getString(2);
                _state = rst.getInt(3);
                _count = rst.getInt(4);
                bgPeriodId = rst.getString(5);
                bgVersionId = rst.getString(6);
                bgOrgunitId = rst.getString(8);
                String vpKey = _rootId + ";" + bgPeriodId + ";" + bgVersionId;
                _nameMap.put(_rootId, _name);
                if (_dataMap.containsKey(vpKey)) {
                    _tmpMap = (Map)_dataMap.get(vpKey);
                } else {
                    _tmpMap = new HashMap();
                    _dataMap.put(vpKey, _tmpMap);
                }
                if (_tmpMap.containsKey(new Integer(_state))) {
                    _tmpMap.put(new Integer(_state), ((BigDecimal)_tmpMap.get(new Integer(_state))).add(new BigDecimal(_count)));
                } else {
                    _tmpMap.put(new Integer(_state), new BigDecimal(_count));
                }
                if (_tmpMap.containsKey(new Integer(10000))) {
                    temp = (Set)_tmpMap.get(new Integer(10000));
                } else {
                    temp = new HashSet();
                    _tmpMap.put(new Integer(10000), (BigDecimal)((Object)temp));
                }
                temp.add(bgOrgunitId);
                if (_tmpMap.containsKey(new Integer(10001))) {
                    _tmpMap.put(new Integer(10001), ((BigDecimal)_tmpMap.get(10001)).add(new BigDecimal(_count)));
                    continue;
                }
                _tmpMap.put(new Integer(10001), new BigDecimal(_count));
            }
            _dataMap.put("KEY_CSLORGUNIT", _nameMap);
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    public Object[] getSql_PlanQueryCslTemplate(Map parameter, Set<String> filtedQueryBgOrgUnitIds) throws EASBizException, BOSException {
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] SEL_CSLTEMPLATE_IDS = (String[])parameter.get("SEL_CSLTEMPLATE_IDS");
        String[] SEL_BGVERSION_IDS = (String[])parameter.get("SEL_BGVERSION_IDS");
        String CURR_ORGTREE_ID = parameter.get("CURR_ORGTREE_ID").toString();
        Object[] returnObj = new Object[2];
        String id2 = null;
        String obj2 = null;
        ArrayList<String> tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FName, t.FId, f.FState, count(f.FID), f.FBgPeriodId, f.FBgVersionId,t.Fnumber ,f.FOrgUnitId ").append("from T_MBG_BgCslForm f ").append("left join T_MBg_BgScheme s on f.FBgSchemeId = s.FID ").append("left join T_MBG_BgCslTemplate t on f.FBgCslTemplateID = t.FID ").append("where (f.FBgTypeId is null or f.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ").append(" AND t.FORGTREEID = '" + CURR_ORGTREE_ID + "'");
        if (filtedQueryBgOrgUnitIds != null && !filtedQueryBgOrgUnitIds.isEmpty()) {
            sql.append(" and f.FOrgUnitId IN (");
            for (String obj2 : filtedQueryBgOrgUnitIds) {
                if (obj2 == null) continue;
                sql.append("?,");
                tmpList.add(obj2.toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length > 0) {
            sql.append(" AND s.FId IN (");
            for (String id2 : SEL_BGSCHEME_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_CSLTEMPLATE_IDS != null && SEL_CSLTEMPLATE_IDS.length > 0) {
            sql.append(" AND t.FID IN (");
            for (String id2 : SEL_CSLTEMPLATE_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGPERIOD_IDS != null && SEL_BGPERIOD_IDS.length > 0) {
            sql.append(" AND f.FBgPeriodId IN (");
            for (String id2 : SEL_BGPERIOD_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.FCurrencyId IN (");
            for (String id2 : SEL_CURRENCY_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGVERSION_IDS != null && SEL_BGVERSION_IDS.length > 0) {
            sql.append(" AND f.Fbgversionid IN (");
            for (String id2 : SEL_BGVERSION_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (this.getIsForbid(parameter)) {
            sql.append(" AND t.FTemplateStatus =0");
        }
        sql.append(" group by t.FName, t.FId, f.FState, f.FBgPeriodId, f.FBgVersionId, t.FNumber,f.FOrgUnitId order by t.FNumber");
        returnObj[0] = sql.toString();
        returnObj[1] = tmpList;
        return returnObj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void queryCslTemplateCount(Map parameter, Context ctx, String userId, Map queryMap, Map nameMap, Set orgUnitIds, String[] bgSchemeRootIds, String[] bgTemplateRootIDS, String CURR_ORGTREE_ID) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (parameter == null) {
            return;
        }
        int _count = 0;
        Integer _state = new Integer(100);
        String _id2222222 = null;
        String _tempId = null;
        String _name = null;
        Map<Integer, BigDecimal> _tmpMap = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select n.FName, n.FId, count(n.FID), n.FNumber ").append("from T_MBG_BgCslTemplate n ").append("where (n.FBgTypeId is null or n.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ").append(" AND n.FORGTREEID = '" + CURR_ORGTREE_ID + "'");
        if (bgSchemeRootIds != null && bgSchemeRootIds.length > 0) {
            sql.append(" AND n.FBgSchemeId IN (");
            for (String _id2222222 : bgSchemeRootIds) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            sql.append(" AND n.FID IN (");
            for (String _id2222222 : bgTemplateRootIDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (this.getIsForbid(parameter)) {
            sql.append(" AND n.FTemplateStatus =0");
        }
        sql.append(" group by n.FName, n.FId, n.FNumber order by n.FNumber");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _name = rst.getString(1);
                _tempId = rst.getString(2);
                _count = rst.getInt(3);
                if (queryMap.containsKey(_tempId)) {
                    _tmpMap = (Map)queryMap.get(_tempId);
                } else {
                    _tmpMap = new HashMap();
                    queryMap.put(_tempId, _tmpMap);
                }
                nameMap.put(_tempId, _name);
                _tmpMap.put(_state, new BigDecimal(orgUnitIds.size()));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map queryBgTemplateInfo(Context ctx, Map parameter, Set<String> queryOrgUnitIds) throws BOSException, EASBizException {
        if (parameter == null) return new HashMap();
        if (parameter.isEmpty()) return new HashMap();
        if (queryOrgUnitIds.isEmpty()) {
            return new HashMap();
        }
        String CURR_USER_ID = (String)parameter.get("CURR_USER_ID");
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGTEMPLATE_IDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        HashMap<String, Map<Integer, BigDecimal>> _dataMap = new HashMap<String, Map<Integer, BigDecimal>>();
        Map<Integer, BigDecimal> _tmpMap = null;
        LinkedHashMap<String, String> _nameMap = new LinkedHashMap<String, String>();
        HashMap _dataOfTemplateMap = new HashMap();
        int _state = 0;
        int _count = 0;
        boolean formSum = false;
        String _name = null;
        String _tempId = null;
        String bgPeriodId = null;
        String bgVersionId = null;
        String bgOrgunitId = null;
        Set<String> temp = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object[] querySql = this.getSql_PlanQueryBgTemplate(parameter, queryOrgUnitIds);
        String sql = (String)querySql[0];
        List paramsList = (List)querySql[1];
        try {
            this.queryBgTemplateCount(parameter, ctx, CURR_USER_ID, _dataMap, _nameMap, queryOrgUnitIds, SEL_BGSCHEME_IDS, SEL_BGTEMPLATE_IDS);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, (List)paramsList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _name = rst.getString(1);
                _tempId = rst.getString(2);
                _state = rst.getInt(3);
                _count = rst.getInt(4);
                bgPeriodId = rst.getString(5);
                bgVersionId = rst.getString(6);
                bgOrgunitId = rst.getString(8);
                String vpKey = _tempId + ";" + bgPeriodId + ";" + bgVersionId;
                if (_dataMap.containsKey(vpKey)) {
                    _tmpMap = (Map)_dataMap.get(vpKey);
                } else {
                    _tmpMap = new HashMap();
                    _dataMap.put(vpKey, _tmpMap);
                }
                if (_tmpMap.containsKey(new Integer(_state))) {
                    _tmpMap.put(new Integer(_state), ((BigDecimal)_tmpMap.get(new Integer(_state))).add(new BigDecimal(_count)));
                } else {
                    _tmpMap.put(new Integer(_state), new BigDecimal(_count));
                }
                if (_tmpMap.containsKey(new Integer(10000))) {
                    temp = (Set)_tmpMap.get(new Integer(10000));
                } else {
                    temp = new HashSet();
                    _tmpMap.put(new Integer(10000), (BigDecimal)((Object)temp));
                }
                temp.add(bgOrgunitId);
                if (_tmpMap.containsKey(new Integer(10001))) {
                    _tmpMap.put(new Integer(10001), ((BigDecimal)_tmpMap.get(10001)).add(new BigDecimal(_count)));
                } else {
                    _tmpMap.put(new Integer(10001), new BigDecimal(_count));
                }
                _nameMap.put(_tempId, _name);
            }
            _dataMap.put("KEY_BGORGUNIT", _nameMap);
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    public Object[] getSql_PlanQueryBgTemplate(Map parameter, Set<String> filtedQueryBgOrgUnitIds) throws EASBizException, BOSException {
        String[] SEL_BGSCHEME_IDS = (String[])parameter.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])parameter.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])parameter.get("SEL_CURRENCY_IDS");
        String[] SEL_BGTEMPLATE_IDS = (String[])parameter.get("SEL_BGTEMPLATE_IDS");
        String[] SEL_BGVERSION_IDS = (String[])parameter.get("SEL_BGVERSION_IDS");
        Object[] returnObj = new Object[2];
        String id2 = null;
        String obj2 = null;
        ArrayList<String> tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FName, t.FRootId, f.FState, count(f.FID), f.FBgPeriodId, f.FBgVersionId, t.FNumber,f.FOrgUnitId ").append("from T_MBg_BgForm f ").append("left join T_MBg_BgScheme s on f.FBgSchemeId = s.FID ").append("left join T_MBg_BgTemplate t on f.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ");
        sql.append(" and t.FIsReadOnly =0").append(" and f.FProcessType = 1");
        if (filtedQueryBgOrgUnitIds != null && !filtedQueryBgOrgUnitIds.isEmpty()) {
            sql.append(" and f.FOrgUnitId IN (");
            for (String obj2 : filtedQueryBgOrgUnitIds) {
                if (obj2 == null) continue;
                sql.append("?,");
                tmpList.add(obj2.toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (SEL_BGSCHEME_IDS != null && SEL_BGSCHEME_IDS.length > 0) {
            sql.append(" AND s.FId IN (");
            for (String id2 : SEL_BGSCHEME_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGTEMPLATE_IDS != null && SEL_BGTEMPLATE_IDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            for (String id2 : SEL_BGTEMPLATE_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGPERIOD_IDS != null && SEL_BGPERIOD_IDS.length > 0) {
            sql.append(" AND f.FBgPeriodId IN (");
            for (String id2 : SEL_BGPERIOD_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_CURRENCY_IDS != null && SEL_CURRENCY_IDS.length > 0) {
            sql.append(" AND f.FCurrencyId IN (");
            for (String id2 : SEL_CURRENCY_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (SEL_BGVERSION_IDS != null && SEL_BGVERSION_IDS.length > 0) {
            sql.append(" AND f.Fbgversionid IN (");
            for (String id2 : SEL_BGVERSION_IDS) {
                sql.append("?,");
                tmpList.add(id2);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") ");
        }
        if (this.getIsForbid(parameter)) {
            sql.append(" AND t.FTemplateStatus =0");
        }
        sql.append(" AND  f.FID not in  (select fadjustId from T_MBg_BgForm m where fid <> fadjustid) ");
        sql.append(" group by t.FName, t.FRootId, f.FState, f.FBgPeriodId, f.FBgVersionId, t.FNumber,f.FOrgUnitId order by t.FNumber");
        returnObj[0] = sql.toString();
        returnObj[1] = tmpList;
        return returnObj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void queryBgTemplateCount(Map parameter, Context ctx, String userId, Map queryMap, Map nameMap, Set orgUnitIds, String[] bgSchemeRootIds, String[] bgTemplateRootIDS) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (parameter == null) {
            return;
        }
        int _count = 0;
        Integer _state = new Integer(100);
        String _id2222222 = null;
        String _tempId = null;
        String _name = null;
        Map<Integer, BigDecimal> _tmpMap = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FName, t.FRootId, count(n.FID), t.FNumber ").append("from T_MBg_BgTemplateNode n ").append("left join T_MBg_BgTemplate t on n.FBgTemplateId = t.FID ").append("where (t.FBgTypeId is null or t.fbgtypeid <> 'bgMAAAAKIcA7rHKd') ");
        sql.append(" and t.FIsReadOnly = 0");
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            sql.append(" and n.FOrgUnitId IN (");
            for (String _id2222222 : orgUnitIds) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgSchemeRootIds != null && bgSchemeRootIds.length > 0) {
            sql.append(" AND t.FBgSchemeId IN (");
            for (String _id2222222 : bgSchemeRootIds) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgTemplateRootIDS != null && bgTemplateRootIDS.length > 0) {
            sql.append(" AND t.FRootID IN (");
            for (String _id2222222 : bgTemplateRootIDS) {
                sql.append("?,");
                _tmpList.add(_id2222222);
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (this.getIsForbid(parameter)) {
            sql.append(" AND t.FTemplateStatus =0");
        }
        sql.append(" group by t.FName, t.FRootId, t.FNumber order by t.FNumber");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _name = rst.getString(1);
                _tempId = rst.getString(2);
                _count = rst.getInt(3);
                if (queryMap.containsKey(_tempId)) {
                    _tmpMap = (Map)queryMap.get(_tempId);
                } else {
                    _tmpMap = new HashMap();
                    queryMap.put(_tempId, _tmpMap);
                }
                nameMap.put(_tempId, _name);
                _tmpMap.put(_state, new BigDecimal(_count));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected IObjectPK _queryUnion(Context ctx, String orgNumber, String treeId) throws BOSException, EASBizException {
        IRowSet rs = null;
        ObjectUuidPK pk = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ORGSTRUCTURE.FParentID FROM T_ORG_Structure AS ORGSTRUCTURE ");
            sql.append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID ");
            sql.append(" WHERE TREE.FID  = '").append(treeId).append("' ");
            sql.append(" AND UNIT.FNUMBER ='").append(orgNumber).append("' ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                String orgId = rs.getString("FParentID");
                pk = new ObjectUuidPK(BOSUuid.read((String)orgId));
            }
            if (pk != null) {
                OrgStructureInfo orgStructureInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo(pk);
                pk = new ObjectUuidPK(orgStructureInfo.getUnit().getId());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return pk;
    }
}

