/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.bgcsl.BgCslFacadeFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormStateEnum;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslFormFacadeControllerBean;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgAuditIdeaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgAuditIdea;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslFormFacadeControllerBean
extends AbstractBgCslFormFacadeControllerBean {
    private static final long serialVersionUID = 4227032173563797858L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslFormFacadeControllerBean");

    @Override
    protected boolean _submitForm(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        return this._auditFormApproving(ctx, id, null);
    }

    @Override
    protected boolean _submitFormWork(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected void _submitAuditIdea(Context ctx, BOSUuid id, BOSUuid auditorId, BgAuditIdeaEnum ideaState, String message) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        IBgAuditIdea iBgAuditIdea = BgAuditIdeaFactory.getLocalInstance((Context)ctx);
        if (iBgAuditIdea != null) {
            BgCslFormInfo bgFormInfo = new BgCslFormInfo();
            bgFormInfo.setId(id);
            BgAuditIdeaInfo bgAuditIdeaInfo = new BgAuditIdeaInfo();
            if (auditorId != null) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(auditorId);
                bgAuditIdeaInfo.setCreator(userInfo);
            } else {
                bgAuditIdeaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            bgAuditIdeaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgAuditIdeaInfo.setIdea(message);
            bgAuditIdeaInfo.setFormId(bgFormInfo.getId());
            bgAuditIdeaInfo.setState(ideaState == null ? BgAuditIdeaEnum.AUDITPASS : ideaState);
            iBgAuditIdea.addnew((CoreBaseInfo)bgAuditIdeaInfo);
        }
    }

    @Override
    protected void _submitAuditIdea(Context ctx, BOSUuid id, BOSUuid auditorId, String message) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        IBgAuditIdea iBgAuditIdea = BgAuditIdeaFactory.getLocalInstance((Context)ctx);
        if (iBgAuditIdea != null) {
            BgCslFormInfo bgFormInfo = new BgCslFormInfo();
            bgFormInfo.setId(id);
            BgAuditIdeaInfo bgAuditIdeaInfo = new BgAuditIdeaInfo();
            if (auditorId != null) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(auditorId);
                bgAuditIdeaInfo.setCreator(userInfo);
            } else {
                bgAuditIdeaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            bgAuditIdeaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgAuditIdeaInfo.setIdea(message);
            bgAuditIdeaInfo.setFormId(bgFormInfo.getId());
        }
    }

    @Override
    protected void _submitIdeaNoPass(Context ctx, BOSUuid bgFormId, BOSUuid auditorId, String msg) throws BOSException, EASBizException {
        IBgAuditIdea iBgAuditIdea;
        if (bgFormId == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)msg) && msg.length() > 650) {
            msg = msg.substring(0, 650);
        }
        if ((iBgAuditIdea = BgAuditIdeaFactory.getLocalInstance((Context)ctx)) != null) {
            BgCslFormInfo bgFormInfo = new BgCslFormInfo();
            bgFormInfo.setId(bgFormId);
            BgAuditIdeaInfo bgAuditIdeaInfo = new BgAuditIdeaInfo();
            if (auditorId != null) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(auditorId);
                bgAuditIdeaInfo.setCreator(userInfo);
            } else {
                bgAuditIdeaInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            bgAuditIdeaInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgAuditIdeaInfo.setIdea(msg);
            bgAuditIdeaInfo.setFormId(bgFormInfo.getId());
        }
    }

    @Override
    protected boolean _auditFormApproving(Context ctx, BOSUuid id, BOSUuid auditorId) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        this.processBgCslFormState(ctx, id, auditorId, BgCslFormStateEnum.APPROVING);
        return true;
    }

    @Override
    protected boolean _auditFormReferring(Context ctx, BOSUuid id, BOSUuid auditorId) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        this.processBgCslFormState(ctx, id, auditorId, BgCslFormStateEnum.REFERRING);
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processBgCslFormState(Context ctx, BOSUuid id, BOSUuid auditorId, BgCslFormStateEnum bgCslFormStateEnum) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pst = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select FID from T_MBg_BgCslForm where FID=?");
        update.append("update T_MBg_BgCslForm set FState=?, FAuditorID=?, FAuditedTime=? where FID=?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            if (!rst.next()) throw new BgFormException(BgFormException.NOBGFORMINFO);
            pst = conn.prepareStatement(update.toString());
            pst.setInt(1, bgCslFormStateEnum.getValue());
            if (BgCslFormStateEnum.EDIT.equals((Object)bgCslFormStateEnum)) {
                pst.setString(2, null);
                pst.setTimestamp(3, null);
            } else {
                if (auditorId != null) {
                    pst.setString(2, auditorId.toString());
                } else {
                    pst.setString(2, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                }
                Timestamp time = new Timestamp(System.currentTimeMillis());
                pst.setTimestamp(3, time);
            }
            pst.setString(4, id.toString());
            pst.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"Error: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _submitAntiAudit(Context ctx, BOSUuid bgFormId, BOSUuid auditorId, String msg) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected boolean _auditFormBasisApproved(Context ctx, BOSUuid bgFormId, BOSUuid auditorId, String message) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _submitFormWorkNextPerson(Context ctx, IObjectValue editData) throws BOSException, EASBizException {
        if (editData != null && editData.get(editData.getPKField()) != null && editData instanceof BgCslFormInfo) {
            try {
                BgCslFormInfo info = (BgCslFormInfo)editData;
                IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"csl_bgform_refer", (BOSObjectType)info.getBOSType(), null, (String)(info.getNumber() + "(" + info.getName() + ")"), (String)"csl_bgform_refer");
                if (pk != null) {
                    LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
                }
            }
            catch (Exception e) {
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean _auditCancelForm(Context ctx, BOSUuid id, BOSUuid auditorId, String idea) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        this.processBgCslFormState(ctx, id, auditorId, BgCslFormStateEnum.EDIT);
        return true;
    }

    @Override
    protected boolean _auditForm(Context ctx, BOSUuid bgFormId, BOSUuid bgAuditOrgId, BOSUuid bgUserId, String msg) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return false;
        }
        try {
            int i;
            Object[] msgArr;
            String[] otherStr;
            Object otherMsg;
            BgCslFormInfo info = MbgCslDataHelper.getBgCslFormInfo(ctx, bgFormId.toString());
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(bgFormId.toString());
            UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            BOSUuid _bgAuditOrgId = bgAuditOrgId == null ? info.getOrgUnit().getId() : bgAuditOrgId;
            BOSUuid _bgUserId = bgUserId == null ? currentUserInfo.getId() : bgUserId;
            BgAuditIdeaInfo ideaInfo = this.createIdea(ctx, bgFormId, _bgUserId, msg, BgAuditIdeaEnum.AUDITPASS);
            ctx.put((Object)"BGCSLFORM_WORKING_OPEN", (Object)Boolean.TRUE);
            Map result = BgCslFormFactory.getLocalInstance(ctx).batchAudit(idList, (IObjectValue)(StringUtils.isEmpty((String)msg) ? null : ideaInfo), false, _bgAuditOrgId.toString());
            Map mutexMap = (Map)result.get("CHECK_NETMUTEX");
            Map workFlowMap = (Map)result.get("CHECK_WORKFLOW");
            Map stateMap = (Map)result.get("CHECK_STATE");
            Map templateSetMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET");
            Map templateExSetMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX");
            if (!(mutexMap != null && !mutexMap.isEmpty() || workFlowMap != null && !workFlowMap.isEmpty() || stateMap != null && !stateMap.isEmpty() || templateSetMap != null && !templateSetMap.isEmpty() || templateExSetMap != null && !templateExSetMap.isEmpty())) {
                boolean bl = true;
                return bl;
            }
            int size = 0;
            String detail = "";
            if (mutexMap != null) {
                size += mutexMap.size();
                for (Object[] cslForm : mutexMap.values()) {
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslMutex", (Object[])cslForm) + "\r\n";
                }
            }
            if (workFlowMap != null) {
                size += workFlowMap.size();
                for (Object[] cslForm : workFlowMap.values()) {
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslWorkFlow", (Object[])cslForm) + "\r\n";
                }
            }
            if (stateMap != null) {
                size += stateMap.size();
                for (Object[] cslForm : stateMap.values()) {
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"cslState", (Object[])cslForm) + "\r\n";
                }
            }
            if (templateSetMap != null) {
                size += templateSetMap.size();
                for (Object[] cslForm : templateSetMap.values()) {
                    otherMsg = cslForm[5];
                    if (((String)otherMsg).indexOf("#") <= 0) continue;
                    otherStr = ((String)otherMsg).split("#");
                    msgArr = new String[2 + otherStr.length];
                    msgArr[0] = cslForm[4];
                    msgArr[1] = cslForm[0];
                    for (i = 0; i < otherStr.length; ++i) {
                        msgArr[i + 2] = otherStr[i];
                    }
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"checkBgTemplate_Sequence", (Object[])msgArr) + "\r\n";
                }
            }
            if (templateExSetMap != null) {
                size += templateExSetMap.size();
                for (Object[] cslForm : templateExSetMap.values()) {
                    otherMsg = cslForm[5];
                    if (((String)otherMsg).indexOf("#") <= 0) continue;
                    otherStr = ((String)otherMsg).split("#");
                    msgArr = new String[2 + otherStr.length];
                    msgArr[0] = cslForm[4];
                    msgArr[1] = cslForm[0];
                    for (i = 0; i < otherStr.length; ++i) {
                        msgArr[i + 2] = otherStr[i];
                    }
                    detail = detail + BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"checkBgTemplate_Sequence_Ex", (Object[])msgArr) + "\r\n";
                }
            }
            if (detail.length() > 0) {
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{detail.toString()});
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"BGCSLFORM_WORKING_OPEN");
        }
        return false;
    }

    @Override
    protected boolean _auditForm(Context ctx, BOSUuid id, BOSUuid auditorId) throws BOSException, EASBizException {
        return this._auditForm(ctx, id, auditorId, null, null);
    }

    @Override
    protected boolean _auditForm(Context ctx, BOSUuid id, BOSUuid auditorId, String idea) throws BOSException, EASBizException {
        return this._auditForm(ctx, id, null, auditorId, idea);
    }

    protected BgAuditIdeaInfo createIdea(Context ctx, BOSUuid formId, BOSUuid auditorId, String idea, BgAuditIdeaEnum ideaEnum) {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        UserInfo userInfo = new UserInfo();
        userInfo.setId(auditorId);
        BgAuditIdeaInfo bgAuditIdea = new BgAuditIdeaInfo();
        bgAuditIdea.setCreator(userInfo);
        bgAuditIdea.setCreateTime(time);
        bgAuditIdea.setIdea(idea);
        bgAuditIdea.setFormId(formId);
        bgAuditIdea.setState(ideaEnum);
        return bgAuditIdea;
    }

    @Override
    protected boolean _checkIsSubmit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _unAuditForm(Context ctx, BOSUuid id, BgAuditIdeaEnum type, BOSUuid auditorId, String message) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _submitAntiAudit(Context ctx, BOSUuid bgFormId, BOSUuid bgAntiAuditOrgId, BOSUuid bgAntiUserId, String msg) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _unionReportWork(Context ctx, String id, String auditorId) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        try {
            BgCslFormInfo info = MbgCslDataHelper.getBgCslFormInfo(ctx, id);
            BgSchemeInfo schemeInfo = info.getBgScheme();
            OrgTreeInfo union = info.getOrgTree();
            FullOrgUnitInfo orgUnit = info.getOrgUnit();
            String userId = StringUtils.isEmpty((String)auditorId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditorId;
            HashMap<String, String> auditParams = new HashMap<String, String>();
            auditParams.put("AUDIT_SCHEME_ID", schemeInfo.getId().toString());
            auditParams.put("AUDIT_UNION_UNIONID", union.getId().toString());
            auditParams.put("AUDIT_ORGUNIT_ID", orgUnit.getId().toString());
            auditParams.put("AUDIT_USER_ID", userId);
            ArrayList<String> billIds = new ArrayList<String>();
            billIds.add(id.toString());
            Map result = BgCslFacadeFactory.getLocalInstance(ctx).report(billIds, auditParams);
            int size = 0;
            StringBuffer msg = new StringBuffer();
            if (result != null && !result.isEmpty()) {
                Map tempalteSetsMap;
                if (result.containsKey("CHECK_RESULT_DATASTATE")) {
                    Map stateMap = (Map)result.get("CHECK_RESULT_DATASTATE");
                    size += stateMap.size();
                    for (String[] tmpStrs : stateMap.values()) {
                        msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"reportErrorStateMsg", (Object[])new String[]{tmpStrs[4], tmpStrs[0]}) + "\n");
                    }
                }
                if (result.containsKey("CHECK_RESULT_BGTEMPLATE_SEQUENCESET")) {
                    tempalteSetsMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET");
                    size += tempalteSetsMap.size();
                    for (String[] tmpStrs : tempalteSetsMap.values()) {
                        String otherMsg = tmpStrs[5];
                        if (otherMsg.indexOf("#") > 0) {
                            String[] otherStr = otherMsg.split("#");
                            Object[] msgArr = new String[2 + otherStr.length];
                            msgArr[0] = tmpStrs[4];
                            msgArr[1] = tmpStrs[0];
                            for (int i = 0; i < otherStr.length; ++i) {
                                msgArr[i + 2] = otherStr[i];
                            }
                            msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"checkBgTemplate_Sequence", (Object[])msgArr) + "\r\n");
                            continue;
                        }
                        msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"unionReportTemplateSet", (Object[])new String[]{tmpStrs[4], tmpStrs[0]}) + "\r\n");
                    }
                } else if (result.containsKey("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX")) {
                    tempalteSetsMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX");
                    size += tempalteSetsMap.size();
                    for (String[] tmpStrs : tempalteSetsMap.values()) {
                        String otherMsg = tmpStrs[5];
                        if (otherMsg.indexOf("#") > 0) {
                            String[] otherStr = otherMsg.split("#");
                            Object[] msgArr = new String[2 + otherStr.length];
                            msgArr[0] = tmpStrs[4];
                            msgArr[1] = tmpStrs[0];
                            for (int i = 0; i < otherStr.length; ++i) {
                                msgArr[i + 2] = otherStr[i];
                            }
                            msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"checkBgTemplate_Sequence_Ex", (Object[])msgArr) + "\r\n");
                            continue;
                        }
                        msg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.bgcsl.BgCslFormResource", (String)"unionReportTemplateSet", (Object[])new String[]{tmpStrs[4], tmpStrs[0]}) + "\r\n");
                    }
                }
            }
            if (msg.length() > 0) {
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{msg.toString()});
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

