/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.bgcsl.AbstractBgCslOffsetEntryTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslElimCollection;
import com.kingdee.eas.ma.bgcsl.BgCslElimFactory;
import com.kingdee.eas.ma.bgcsl.BgCslElimInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryCollection;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetException;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateException;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslOffsetEntryTemplateControllerBean;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyInfo;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslOffsetEntryTemplateControllerBean
extends AbstractBgCslOffsetEntryTemplateControllerBean {
    private static final long serialVersionUID = 5732028102582652629L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslOffsetEntryTemplateControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslOffsetEntryTemplateInfo info = (BgCslOffsetEntryTemplateInfo)model;
        if (info.getNumber() != null && info.getNumber().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERTOOLONG);
        }
        this.checkDupNumber(ctx, info.getNumber(), info.getId() == null ? null : info.getId().toString(), info.getOrgUnit().getId().toString(), info.getBgScheme().getId().toString());
        if (info.getName() != null && info.getName().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NAMETOOLONG);
        }
        return super._save(ctx, model);
    }

    private void checkDupNumber(Context ctx, String number, String id, String treeId, String bgSchemeId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(60);
        if (id == null) {
            id = "000000000000000000000000000=";
        }
        sql.append(" SELECT FID FROM T_MBG_BgCslOffsetEntryTemplate where FBgSchemeID = ? AND FOrgUnitID = ? AND FNumber = ? AND FID <> ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId);
            pstmt.setString(2, treeId);
            pstmt.setString(3, number);
            pstmt.setString(4, id);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{number});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.doCancelOrNot(ctx, ids, true);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslOffsetEntryTemplateInfo info = (BgCslOffsetEntryTemplateInfo)model;
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setRootId(info.getId());
        return super._addnew(ctx, model);
    }

    @Override
    protected void _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.doCancelOrNot(ctx, ids, false);
    }

    protected void doCancelOrNot(Context ctx, Set ids, boolean isCancel) throws BOSException, EASBizException {
        if (ctx == null || ids == null || ids.isEmpty()) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgCslOffsetEntryTemplate Set FTemplateStatus = " + (isCancel ? 10 : 0) + " Where FID = ?"), new ArrayList(ids));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected IObjectValue _copy(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgCslOffsetEntryTemplateInfo info = this.getBgCslOffsetEntryTemplateInfo(ctx, pk, BgCslOffsetEntryTemplateControllerBean.getCslOffsetEntryTemplateFullSelector());
        info = (BgCslOffsetEntryTemplateInfo)info.clone();
        info.remove("id");
        info.remove("number");
        BgCslOffsetEntryTemplateEntryCollection entries = info.getEntries();
        BgCslOffsetEntryTemplateEntryInfo entry = new BgCslOffsetEntryTemplateEntryInfo();
        for (int i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            entry.remove("id");
            entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
        }
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setRootId(info.getId());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setTemplateStatus(BgTemplateStatusEnum.CANCEL_CANCEL);
        return info;
    }

    public static final SelectorItemCollection getCslOffsetEntryTemplateFullSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("elimType"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("memberCombinName"));
        sic.add(new SelectorItemInfo("memberCombinNumber"));
        sic.add(new SelectorItemInfo("memberCombinRef"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("bgScenario.id"));
        sic.add(new SelectorItemInfo("bgScenario.number"));
        sic.add(new SelectorItemInfo("bgScenario.name"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("bgElement.id"));
        sic.add(new SelectorItemInfo("bgElement.number"));
        sic.add(new SelectorItemInfo("bgElement.name"));
        sic.add(new SelectorItemInfo("bgPeriod.id"));
        sic.add(new SelectorItemInfo("bgPeriod.number"));
        sic.add(new SelectorItemInfo("bgPeriod.name"));
        sic.add(new SelectorItemInfo("bgVersion.id"));
        sic.add(new SelectorItemInfo("bgVersion.number"));
        sic.add(new SelectorItemInfo("bgVersion.name"));
        sic.add(new SelectorItemInfo("templateStatus"));
        sic.add(new SelectorItemInfo("entries.summary"));
        sic.add(new SelectorItemInfo("entries.indexMemberName"));
        sic.add(new SelectorItemInfo("entries.indexMemberNumber"));
        sic.add(new SelectorItemInfo("entries.indexMemberRef"));
        sic.add(new SelectorItemInfo("entries.memberCombinName"));
        sic.add(new SelectorItemInfo("entries.memberCombinNumber"));
        sic.add(new SelectorItemInfo("entries.memberCombinRef"));
        sic.add(new SelectorItemInfo("entries.debitAmount"));
        sic.add(new SelectorItemInfo("entries.debitFormula"));
        sic.add(new SelectorItemInfo("entries.creditAmount"));
        sic.add(new SelectorItemInfo("entries.creditFormula"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("creator.id"));
        return sic;
    }

    @Override
    protected List _assign(Context ctx, String bgSchemeID, List orgUnitIds, List templateIds) throws BOSException, EASBizException {
        if (orgUnitIds == null || orgUnitIds.isEmpty() || templateIds == null || templateIds.isEmpty()) {
            return new ArrayList();
        }
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeID, (String)null);
        HashMap<String, BgCslOffsetEntryTemplateInfo> templateMap = new HashMap<String, BgCslOffsetEntryTemplateInfo>();
        HashMap childMap = new HashMap();
        HashMap<String, Set<String>> queryMap = new HashMap<String, Set<String>>();
        HashMap<String, HashMap<String, Set<String>>> offsetMap = new HashMap<String, HashMap<String, Set<String>>>();
        Map<String, FullOrgUnitInfo> orgUnitMap = this.queryOrgUnitInfo(ctx, orgUnitIds);
        Map<String, Set<String>> subOffsetMap = null;
        BgCslOffsetEntryTemplateInfo info2 = null;
        HashMap<String, String> rootId_number = new HashMap<String, String>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("rootId");
        evi.getSelector().add("memberCombinNumber");
        evi.getSelector().add("entries.indexMemberNumber");
        evi.getSelector().add("entries.memberCombinNumber");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(templateIds), CompareType.INCLUDE));
        BgCslOffsetEntryTemplateCollection col = this.getBgCslOffsetEntryTemplateCollection(ctx, evi);
        for (int i = 0; i < col.size(); ++i) {
            info2 = col.get(i);
            subOffsetMap = new HashMap<String, Set<String>>();
            offsetMap.put(info2.getId().toString(), (HashMap<String, Set<String>>)subOffsetMap);
            this.addMember(queryMap, subOffsetMap, info2.getMemberCombinNumber());
            rootId_number.put(info2.getRootId().toString(), info2.getNumber());
            templateMap.put(info2.getNumber(), info2);
            for (int e = 0; e < info2.getEntries().size(); ++e) {
                this.addMember(queryMap, subOffsetMap, info2.getEntries().get(e).getIndexMemberNumber());
                this.addMember(queryMap, subOffsetMap, info2.getEntries().get(e).getMemberCombinNumber());
            }
        }
        evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("rootId");
        evi.setFilter(new FilterInfo());
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(templateMap.keySet()), CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", new HashSet(orgUnitIds), CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeID, CompareType.EQUALS));
        col = this.getBgCslOffsetEntryTemplateCollection(ctx, evi);
        String number = null;
        for (int i = 0; i < col.size(); ++i) {
            info2 = col.get(i);
            number = (String)rootId_number.get(info2.getRootId().toString());
            if (number == null) {
                number = info2.getNumber();
            }
            if (!childMap.containsKey(number)) {
                childMap.put(number, new HashMap());
            }
            ((Map)childMap.get(number)).put(info2.getOrgUnit().getId().toString(), info2);
        }
        ViewListMemberCacheHelper memberCacheHelper = new ViewListMemberCacheHelper();
        memberCacheHelper.setCtx(ctx);
        this.queryMember(ctx, orgUnitIds, queryMap, memberCacheHelper, schemeHelper);
        ArrayList<String[]> _reList = new ArrayList<String[]>();
        FullOrgUnitInfo orgUnit = null;
        String orgUnitId = null;
        ArrayList<MbgUpdateDataBaseCopyInfo> infoCopies = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        ArrayList<MbgUpdateDataBaseCopyInfo> entriesCopies = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        ArrayList<String> deleteIds = new ArrayList<String>();
        String newId = null;
        AbstractBgCslOffsetEntryTemplateInfo childInfo = null;
        BgDimensionInfo dimension = null;
        boolean isGlobal = true;
        MbgUpdateDataBaseCopyInfo copyInfo = null;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String entryBosType = new BgCslOffsetEntryTemplateEntryInfo().getBOSType().toString();
        String assignHasTemplate = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasTemplate", (Locale)ctx.getLocale());
        String assignHasNoMbgMember = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasNoMbgMember", (Locale)ctx.getLocale());
        String assignHasNoAccountMember = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasNoAccountMember", (Locale)ctx.getLocale());
        String assignHasNoDimension = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"assignHasNoDimension", (Locale)ctx.getLocale());
        for (BgCslOffsetEntryTemplateInfo info2 : templateMap.values()) {
            subOffsetMap = (Map)offsetMap.get(info2.getId().toString());
            block9: for (int i = 0; i < orgUnitIds.size(); ++i) {
                orgUnitId = (String)orgUnitIds.get(i);
                orgUnit = orgUnitMap.get(orgUnitId);
                newId = BOSUuid.create((BOSObjectType)info2.getBOSType()).toString();
                String[] result = this.getBaseResult(info2, orgUnit);
                _reList.add(result);
                childInfo = null;
                if (childMap.get(info2.getNumber()) != null) {
                    childInfo = (BgCslOffsetEntryTemplateInfo)((Map)childMap.get(info2.getNumber())).get(orgUnitId);
                }
                if (childInfo != null && !childInfo.getRootId().equals((Object)info2.getRootId())) {
                    result[0] = String.valueOf(false);
                    result[1] = assignHasTemplate;
                    continue;
                }
                for (String srcNumber : subOffsetMap.keySet()) {
                    dimension = (BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(srcNumber);
                    if (dimension == null) {
                        result[0] = String.valueOf(false);
                        result[1] = MessageFormat.format(assignHasNoDimension, srcNumber);
                        continue block9;
                    }
                    isGlobal = memberCacheHelper.isGlobal(dimension.getNumber(), (BgSchemeDimensionHelper)schemeHelper);
                    for (String number2 : subOffsetMap.get(srcNumber)) {
                        if (memberCacheHelper.getMembers(dimension.getNumber(), orgUnitId, isGlobal, number2, -1) != null) continue;
                        result[0] = String.valueOf(false);
                        if (srcNumber.equals(DimensionConstants.DEF_INDEX_SRCNUMBER)) {
                            result[1] = assignHasNoAccountMember;
                            continue block9;
                        }
                        result[1] = assignHasNoMbgMember;
                        continue block9;
                    }
                }
                result[0] = String.valueOf(true);
                if (childInfo != null) {
                    newId = childInfo.getId().toString();
                    deleteIds.add(newId);
                }
                copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FID = ?");
                copyInfo.addWhereParam((Object)info2.getId().toString());
                copyInfo.addReplaceVar("FID", (Object)newId);
                copyInfo.addReplaceVar("FDistributePerson", (Object)userId);
                copyInfo.addReplaceVar("FOrgUnitID", (Object)orgUnitId);
                copyInfo.addReplaceVar("FCreatorId", (Object)userId);
                copyInfo.addReplaceVar("FCreateTime", (Object)now);
                copyInfo.addReplaceVar("FLastUpdateUserID", (Object)userId);
                copyInfo.addReplaceVar("FLastUpdateTime", (Object)now);
                copyInfo.addReplaceVar("FDistributeTime", (Object)now);
                infoCopies.add(copyInfo);
                copyInfo = new MbgUpdateDataBaseCopyInfo();
                copyInfo.setWhere("FParentID = ?");
                copyInfo.addWhereParam((Object)info2.getId().toString());
                copyInfo.addReplace("FID", "newbosid('" + entryBosType + "')");
                copyInfo.addReplaceVar("FParentID", (Object)newId);
                entriesCopies.add(copyInfo);
            }
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            if (!deleteIds.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Delete FROM T_MBG_BgCslOffsetEntryTemplate Where FID = ?", deleteIds);
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Delete FROM T_MBG_BgCslOffsetEntTempEntry Where FParentID = ?", deleteIds);
            }
            MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslOffsetEntryTemplate", infoCopies);
            MbgUpdateDataBaseCopyHelper.copyDataBase((Connection)conn, (String)"T_MBG_BgCslOffsetEntTempEntry", entriesCopies);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return _reList;
    }

    protected Map<String, FullOrgUnitInfo> queryOrgUnitInfo(Context ctx, List orgUnitIds) throws BOSException {
        HashMap<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(orgUnitIds), CompareType.INCLUDE));
        FullOrgUnitCollection orgCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(evi);
        for (int i = 0; i < orgCol.size(); ++i) {
            orgUnitMap.put(orgCol.get(i).getId().toString(), orgCol.get(i));
        }
        return orgUnitMap;
    }

    protected String[] getBaseResult(BgCslOffsetEntryTemplateInfo info, FullOrgUnitInfo orgUnit) {
        String[] result = new String[6];
        result[2] = info.getNumber();
        result[3] = info.getName();
        result[4] = orgUnit.getNumber();
        result[5] = orgUnit.getName();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void queryMember(Context ctx, List orgUnitIds, Map<String, Set<String>> queryMap, ViewListMemberCacheHelper memberCacheHelper, BgCslSchemeDimensionHelper schemeHelper) throws BOSException {
        Connection conn;
        block11: {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tempTable = null;
            conn = null;
            Object rst = null;
            try {
                tempTable = pool.createTempTable("Create Table T_MBG_TNumber(FNumber NVarchar(80) NOT NULL)");
                String orgUnitId = null;
                BgDimensionInfo dimension = null;
                DimensionFilterHelper filterHelper = null;
                conn = this.getConnection(ctx);
                String bgSchemeOrgId = (String)MbgSqlHelper.executeQuery((Connection)conn, (String)"Select FOrgUnitId FROM T_MBG_BgScheme Where FID = ?", (Object[])new Object[]{schemeHelper.getBgSchemeId()}).get(0);
                String bgOrgViewId = schemeHelper.getBgOrgViewId();
                boolean isGlobal = true;
                IDataProvider dpv = null;
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("number");
                for (String srcNumber : queryMap.keySet()) {
                    dimension = (BgDimensionInfo)schemeHelper.getDimensionBySrcNumber().get(srcNumber);
                    if (dimension == null) continue;
                    isGlobal = memberCacheHelper.isGlobal(dimension.getNumber(), (BgSchemeDimensionHelper)schemeHelper);
                    MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempTable));
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempTable + "(FNumber) Values(?)"), (Collection)queryMap.get(srcNumber));
                    for (int o = 0; o < orgUnitIds.size(); ++o) {
                        orgUnitId = String.valueOf(orgUnitIds.get(o));
                        if (isGlobal) {
                            if (memberCacheHelper.contains(dimension.getNumber(), orgUnitId, isGlobal)) continue;
                            filterHelper = DimensionFilterHelper.getLocaleIntance((Context)ctx, (BgDimensionInfo)dimension, (String)bgSchemeOrgId, (String)schemeHelper.getBgSchemeId(), (String)bgOrgViewId, null);
                        } else {
                            filterHelper = DimensionFilterHelper.getLocaleIntance((Context)ctx, (BgDimensionInfo)dimension, (String)bgSchemeOrgId, (String)schemeHelper.getBgSchemeId(), (String)bgOrgViewId, (String)orgUnitId);
                        }
                        evi.setFilter(filterHelper.getFilter());
                        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)("Select FNumber FROM " + tempTable), CompareType.INNER));
                        if (evi.getFilter().getFilterItems().size() > 1 && !StringUtils.isEmpty((String)evi.getFilter().getMaskString())) {
                            evi.getFilter().setMaskString(evi.getFilter().getMaskString() + " and #" + (evi.getFilter().getFilterItems().size() - 1));
                        }
                        dpv = filterHelper.getQueryExecutor();
                        dpv.setObjectView(evi);
                        IRowSet rs = dpv.executeQuery();
                        while (rs.next()) {
                            String number = rs.getString(1);
                            memberCacheHelper.putMembers(dimension.getNumber(), orgUnitId, isGlobal, number, -1, null);
                        }
                        SQLUtils.cleanup((ResultSet)rs);
                    }
                }
                if (tempTable == null) break block11;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tempTable != null) {
                        pool.releaseTable(tempTable);
                    }
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tempTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private void addMember(Map<String, Set<String>> queryMap, Map<String, Set<String>> subOffsetMap, String memberCombinNumber) {
        if (StringUtils.isEmpty((String)memberCombinNumber)) {
            return;
        }
        String srcNumber = null;
        String number = null;
        String[] combins = DimensionFormulaHelper.splitCombinations((String)memberCombinNumber);
        for (int i = 0; i < combins.length; ++i) {
            srcNumber = DimensionFormulaHelper.getSrcNumber((String)combins[i]);
            number = DimensionFormulaHelper.getMemberNumber((String)combins[i]);
            if (!queryMap.containsKey(srcNumber)) {
                queryMap.put(srcNumber, new HashSet());
            }
            queryMap.get(srcNumber).add(number);
            if (!subOffsetMap.containsKey(srcNumber)) {
                subOffsetMap.put(srcNumber, new HashSet());
            }
            subOffsetMap.get(srcNumber).add(number);
        }
    }

    @Override
    protected List _unAssign(Context ctx, String bgSchemeID, List orgUnitIds, List templateIds) throws BOSException, EASBizException {
        if (orgUnitIds == null || orgUnitIds.isEmpty() || templateIds == null || templateIds.isEmpty()) {
            return new ArrayList();
        }
        Map<String, FullOrgUnitInfo> orgUnitMap = this.queryOrgUnitInfo(ctx, orgUnitIds);
        HashMap<String, BgCslOffsetEntryTemplateInfo> templateMap = new HashMap<String, BgCslOffsetEntryTemplateInfo>();
        HashMap canDeleteMap = new HashMap();
        HashSet<String> rootIds = new HashSet<String>();
        BgCslOffsetEntryTemplateInfo info2 = null;
        String rootId2 = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("rootId");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(templateIds), CompareType.INCLUDE));
        BgCslOffsetEntryTemplateCollection col = this.getBgCslOffsetEntryTemplateCollection(ctx, evi);
        for (int i = 0; i < col.size(); ++i) {
            info2 = col.get(i);
            templateMap.put(info2.getNumber(), info2);
            rootId2 = info2.getRootId().toString();
            rootIds.add(rootId2);
            canDeleteMap.put(rootId2, new HashSet(orgUnitIds));
        }
        HashMap hasElimMap = new HashMap();
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setSelector(new SelectorItemCollection());
        evi2.getSelector().add("template.rootId");
        evi2.getSelector().add("orgUnit.id");
        evi2.setFilter(new FilterInfo());
        evi2.getFilter().getFilterItems().add(new FilterItemInfo("template.rootId", rootIds, CompareType.INCLUDE));
        evi2.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", new HashSet(orgUnitIds), CompareType.INCLUDE));
        BgCslElimCollection col2 = BgCslElimFactory.getLocalInstance(ctx).getBgCslElimCollection(evi2);
        BgCslElimInfo elimInfo = null;
        for (int i = 0; i < col2.size(); ++i) {
            elimInfo = col2.get(i);
            rootId2 = elimInfo.getTemplate().getRootId().toString();
            if (!hasElimMap.containsKey(rootId2)) {
                hasElimMap.put(rootId2, new HashSet());
            }
            ((Set)hasElimMap.get(rootId2)).add(elimInfo.getOrgUnit().getId().toString());
        }
        ArrayList<String[]> _reList = new ArrayList<String[]>();
        String hasElmeMsg = ResourceBase.getString((String)"com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryResource", (String)"unssignHasElim", (Locale)ctx.getLocale());
        String orgUnitId = null;
        FullOrgUnitInfo orgUnit = null;
        Set hasElimOrgSet = null;
        for (BgCslOffsetEntryTemplateInfo info2 : templateMap.values()) {
            rootId2 = info2.getRootId().toString();
            hasElimOrgSet = (Set)hasElimMap.get(rootId2);
            for (int i = 0; i < orgUnitIds.size(); ++i) {
                orgUnitId = (String)orgUnitIds.get(i);
                orgUnit = orgUnitMap.get(orgUnitId);
                String[] result = this.getBaseResult(info2, orgUnit);
                _reList.add(result);
                if (hasElimOrgSet != null && hasElimOrgSet.contains(orgUnitId)) {
                    result[0] = String.valueOf(false);
                    result[1] = hasElmeMsg;
                    ((Set)canDeleteMap.get(rootId2)).remove(orgUnitId);
                    continue;
                }
                result[0] = String.valueOf(true);
            }
        }
        StringBuffer entrySql = new StringBuffer("Delete FROM T_MBG_BgCslOffsetEntTempEntry Where FParentID IN(Select FID FROM T_MBG_BgCslOffsetEntryTemplate Where FRootId = ? AND FOrgUnitId IN(");
        StringBuffer mainSql = new StringBuffer("Delete FROM T_MBG_BgCslOffsetEntryTemplate Where FRootId = ? AND FOrgUnitId IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)mainSql).append(")");
        MbgSqlHelper.addPlaceHolder((StringBuffer)entrySql).append("))");
        ArrayList paramList = new ArrayList();
        for (String rootId2 : canDeleteMap.keySet()) {
            hasElimOrgSet = (Set)canDeleteMap.get(rootId2);
            if (hasElimOrgSet.isEmpty()) continue;
            paramList.addAll(MbgSqlHelper.getBatchParams((Object[])new Object[]{rootId2}, (Object[])hasElimOrgSet.toArray(), (int)50));
        }
        if (!paramList.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)entrySql.toString(), paramList);
            DbUtil.executeBatch((Context)ctx, (String)mainSql.toString(), paramList);
        }
        return _reList;
    }

    @Override
    protected Map _getDispatchInfo(Context ctx, String bgSchemeId, String orgTreeId, String currOrgUnitId) throws BOSException, EASBizException {
        String currLongNumber;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        HashMap dispatchMap;
        block10: {
            dispatchMap = new HashMap();
            if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgTreeId) || StringUtils.isEmpty((String)currOrgUnitId)) {
                return dispatchMap;
            }
            conn = null;
            pstmt = null;
            rst = null;
            conn = this.getConnection(ctx);
            currLongNumber = null;
            pstmt = conn.prepareStatement("Select FLongNumber FROM T_ORG_Structure Where FUnitId = ?");
            pstmt.setString(1, BOSUuid.read((String)currOrgUnitId).toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                currLongNumber = rst.getString(1);
                break block10;
            }
            HashMap hashMap = dispatchMap;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return hashMap;
        }
        try {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            HashMap<String, String> cureOrgTemMap = new HashMap<String, String>();
            pstmt = conn.prepareStatement("Select FID, FRootId FROM T_MBG_BgCslOffsetEntryTemplate Where FBgSchemeId = ? AND FOrgUnitId = ?");
            pstmt.setString(1, bgSchemeId);
            pstmt.setString(2, currOrgUnitId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                cureOrgTemMap.put(rst.getString("FRootId"), rst.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            String sql = "Select FRootId, FOrgUnitId FROM T_MBG_BgCslOffsetEntryTemplate Where FRootId IN(Select FRootId FROM T_MBG_BgCslOffsetEntryTemplate Where FBgSchemeId = ? AND FOrgUnitId = ?) AND FOrgUnitId IN(Select FUnitId FROM T_ORG_Structure Where FOrgTreeId  = ? AND FLongNumber Like ?)";
            String orgUnitId = null;
            String rootId = null;
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bgSchemeId);
            pstmt.setString(2, currOrgUnitId);
            pstmt.setString(3, orgTreeId);
            pstmt.setString(4, currLongNumber + "!%");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitId = rst.getString("FOrgUnitId");
                rootId = rst.getString("FRootId");
                if (!cureOrgTemMap.containsKey(rootId)) continue;
                rootId = (String)cureOrgTemMap.get(rootId);
                if (!dispatchMap.containsKey(orgUnitId)) {
                    dispatchMap.put(orgUnitId, new HashSet());
                }
                ((Set)dispatchMap.get(orgUnitId)).add(rootId);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return dispatchMap;
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        try {
            if (this._checkRefByForm(ctx, pk.toString())) {
                throw new CanNotDeleteException(new BgCslOffsetException(BgCslOffsetException.CANNOTDELETEBYELIM).getMessage());
            }
            if (this._checkIsAssign(ctx, pk.toString())) {
                throw new CanNotDeleteException(new BgCslOffsetException(BgCslOffsetException.ISASSIGN).getMessage());
            }
        }
        catch (CanNotDeleteException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    protected boolean _checkIsAssign(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_MBG_BgCslOffsetEntryTemplate where FRootID = ? and FID <> FRootID");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }

    protected boolean _checkRefByForm(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_MBg_BgCslElim where FTemplateID = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }
}

