/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryCollection;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateEntryInfo;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslOffsetEntryTemplateInfo;
import com.kingdee.eas.ma.bgcsl.ElimTypeEnum;
import com.kingdee.eas.ma.bgcsl.IBgCslOffsetEntryTemplate;
import com.kingdee.eas.ma.bgcsl.app.BgCslElimBaseImportData;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class BgCslOffsetEntryTemplateImportData
extends BgCslElimBaseImportData {
    private static Logger logger = Logger.getLogger(BgCslOffsetEntryTemplateImportData.class);
    private BgCslOffsetEntryTemplateInfo exsitInfo = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BgCslOffsetEntryTemplateFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FName", rs.getString("name"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FBgVersion_number", rs.getString("bgVersion.number"));
            this.putTable(result, "FBgScenario_number", rs.getString("bgScenario.number"));
            this.putTable(result, "FBgElement_number", rs.getString("bgElement.number"));
            this.putTable(result, "FBgPeriod_number", rs.getString("bgPeriod.number"));
            this.putTable(result, "FMemberCombinNumber", rs.getString("memberCombinNumber"));
            this.putTable(result, "FCurrency_name_l2", rs.getString("currency.name"));
            this.putTable(result, "FBgVersion_name_l2", rs.getString("bgVersion.name"));
            this.putTable(result, "FBgScenario_name_l2", rs.getString("bgScenario.name"));
            this.putTable(result, "FBgElement_name_l2", rs.getString("bgElement.name"));
            this.putTable(result, "FBgPeriod_name_l2", rs.getString("bgPeriod.name"));
            this.putTable(result, "FMemberCombinName", rs.getString("memberCombinName"));
            this.putTable(result, "FElimType", ElimTypeEnum.getEnum(rs.getInt("elimType")) != null ? ElimTypeEnum.getEnum(rs.getInt("elimType")).getAlias() : null);
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FEntries_summary", rs.getString("entries.summary"));
            this.putTable(result, "FEntries_indexMemberNumber", rs.getString("entries.indexMemberNumber"));
            this.putTable(result, "FEntries_memberCombinNumber", rs.getString("entries.memberCombinNumber"));
            this.putTable(result, "FEntries_indexMemberName", rs.getString("entries.indexMemberName"));
            this.putTable(result, "FEntries_memberCombinName", rs.getString("entries.memberCombinName"));
            this.putTable(result, "FEntries_debitFormula", rs.getString("entries.debitFormula"));
            this.putTable(result, "FEntries_creditFormula", rs.getString("entries.creditFormula"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    protected void setNumberByCodeRule(Context ctx, BgCslOffsetEntryTemplateInfo info, String number) throws Exception {
        String imUnitID = this.orgUnitInfo.getId().toString();
        if (null == imUnitID) {
            throw new TaskExternalException(BgCslOffsetEntryTemplateImportData.getResource("OrgUnit_NULL", ctx));
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, imUnitID)) {
            String numberStr = iCodingRuleManager.getNumber((IObjectValue)info, imUnitID, "");
            info.setNumber(numberStr);
        } else if (!StringUtils.isEmpty((String)number)) {
            info.setNumber(number);
        }
    }

    protected BgCslOffsetEntryTemplateInfo getExistInfo(Hashtable hsData, Context ctx) throws Exception {
        String ksql;
        BgCslOffsetEntryTemplateInfo info = null;
        String number = this.getData("FNumber", (Hashtable)hsData.get(0)).toString();
        if (StringUtils.isEmpty((String)number)) {
            return info;
        }
        IBgCslOffsetEntryTemplate ioffset = BgCslOffsetEntryTemplateFactory.getLocalInstance(ctx);
        BgCslOffsetEntryTemplateCollection collection = ioffset.getBgCslOffsetEntryTemplateCollection(ksql = "where number='" + number + "' and bgScheme.id = '" + this.bgSchemeInfo.getId().toString() + "' and orgTree.id = '" + this.orgTreeInfo.getId().toString() + "' and orgUnit.id = '" + this.orgUnitInfo.getId().toString() + "'");
        if (collection != null && collection.size() > 0) {
            this.exsitInfo = info = ioffset.getBgCslOffsetEntryTemplateInfo((IObjectPK)new ObjectUuidPK(collection.get(0).getId()));
        }
        return info;
    }

    @Override
    protected CoreBaseInfo transmitnew(Hashtable hsData, Context ctx) throws Exception {
        int i;
        String number = this.getData("FNumber", (Hashtable)hsData.get(0)).toString();
        BgCslOffsetEntryTemplateInfo info = new BgCslOffsetEntryTemplateInfo();
        BgCslOffsetEntryTemplateInfo existInfo = this.getExistInfo(hsData, ctx);
        BgCslOffsetEntryTemplateEntryCollection existColls = null;
        if (this.isSltImportUpdate()) {
            if (existInfo != null) {
                if (!existInfo.getEntries().isEmpty()) {
                    existColls = new BgCslOffsetEntryTemplateEntryCollection();
                    for (int i2 = 0; i2 < existInfo.getEntries().size(); ++i2) {
                        existColls.add(existInfo.getEntries().get(i2));
                    }
                }
                info = existInfo;
            }
        } else if (existInfo != null) {
            throw new TaskExternalException(BgCslOffsetEntryTemplateImportData.getResource("NUMBER_CANNOT_THESAME", ctx));
        }
        this.setNumberByCodeRule(ctx, info, number);
        HashSet<String> memberNumbers = new HashSet<String>();
        info = this.setHeadInfo(ctx, info, (Hashtable)hsData.get(0));
        this.collectionMemberNumber(info.getMemberCombinNumber(), memberNumbers);
        for (i = 0; i < hsData.size(); ++i) {
            this.collectionMemberNumber((String)this.getData("FMemberCombinNumber", (Hashtable)hsData.get(i)), memberNumbers);
            this.collectionMemberNumber((String)this.getData("FEntries_indexMemberNumber", (Hashtable)hsData.get(i)), memberNumbers);
            this.collectionMemberNumber((String)this.getData("FEntries_memberCombinNumber", (Hashtable)hsData.get(i)), memberNumbers);
        }
        this.checkMemberExist(ctx, memberNumbers);
        for (i = 0; i < hsData.size(); ++i) {
            BgCslOffsetEntryTemplateEntryInfo entryInfo = new BgCslOffsetEntryTemplateEntryInfo();
            entryInfo.setParent(info);
            this.setEntryInfo(ctx, entryInfo, (Hashtable)hsData.get(i));
            this.collectionMemberNumber(entryInfo.getIndexMemberNumber(), memberNumbers);
            this.collectionMemberNumber(entryInfo.getMemberCombinNumber(), memberNumbers);
            info.getEntries().add(entryInfo);
            this.checkDimMatch(ctx, info, entryInfo);
        }
        this.checkSpeicalDim(ctx, info);
        if (this.isSltImportUpdate() && existInfo != null && existColls != null && info.getEntries() != null && existColls.size() < info.getEntries().size()) {
            for (i = existColls.size() - 1; i >= 0; --i) {
                if (!info.getEntries().contains(existColls.get(i))) continue;
                info.getEntries().remove(existColls.get(i));
            }
        }
        return info;
    }

    private void setEntryInfo(Context ctx, BgCslOffsetEntryTemplateEntryInfo entryInfo, Hashtable hsData) throws Exception {
        String summary = (String)this.getData("FEntries_summary", hsData);
        entryInfo.setSummary(summary);
        String accNumber = (String)this.getData("FEntries_indexMemberNumber", hsData);
        String accName = (String)this.getData("FEntries_indexMemberName", hsData);
        accName = (String)this.memberCacheMap.get(accNumber);
        String accRef = "F2";
        if (null == accNumber || null == accName || null == accRef) {
            throw new TaskExternalException(BgCslOffsetEntryTemplateImportData.getResource("BgAccount_NULL", ctx));
        }
        BgDimensionMember account = new BgDimensionMember("BG_Account", accRef, accName, accNumber);
        entryInfo.setIndexMemberName(account.getName());
        entryInfo.setIndexMemberNumber(account.getNumber());
        entryInfo.setIndexMemberRef(account.getAttribute());
        String dimNumber = (String)this.getData("FEntries_memberCombinNumber", hsData);
        String dimName = (String)this.getData("FEntries_memberCombinName", hsData);
        String dimRef = this.getDimRef(dimNumber);
        if (null != dimNumber && null != dimName && null != dimRef) {
            entryInfo.setMemberCombinName(dimName);
            entryInfo.setMemberCombinNumber(dimNumber);
            entryInfo.setMemberCombinRef(dimRef);
        }
        String debitFormula = (String)this.getData("FEntries_debitFormula", hsData);
        entryInfo.setDebitFormula(debitFormula);
        String creditFormula = (String)this.getData("FEntries_creditFormula", hsData);
        entryInfo.setCreditFormula(creditFormula);
        if (!StringUtils.isEmpty((String)entryInfo.getDebitFormula()) && !StringUtils.isEmpty((String)entryInfo.getCreditFormula())) {
            throw new TaskExternalException(BgCslOffsetEntryTemplateImportData.getResource("debitAndCreditAllFull", ctx));
        }
    }

    private BgCslOffsetEntryTemplateInfo setHeadInfo(Context ctx, BgCslOffsetEntryTemplateInfo info, Hashtable hsData) throws Exception {
        Object data = null;
        data = this.getData("FElimType", hsData);
        ElimTypeEnum enumType = this.getElimiEnumByAlias(String.valueOf(data), ctx.getOriginLocale());
        info.setElimType(enumType != null ? enumType : ElimTypeEnum.ComeAndGo);
        String name = (String)this.getData("FName", hsData);
        info.setName(name);
        String description = (String)this.getData("FDescription", hsData);
        info.setDescription(description);
        info.setBgScheme(this.bgSchemeInfo);
        info.setOrgTree(this.orgTreeInfo);
        info.setOrgUnit(this.orgUnitInfo);
        this.setBgPeriodInfo(ctx, info, hsData, false);
        this.setBgVersion(ctx, info, hsData, false);
        this.setBgElement(ctx, info, hsData, false);
        this.setBgScenario(ctx, info, hsData, false);
        this.setCurrency(ctx, info, hsData, false);
        this.setHeadMember(ctx, info, hsData);
        return info;
    }

    @Override
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }
}

