/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslOrgSeqFacadeControllerBean;
import com.kingdee.eas.ma.bgcsl.utils.BgCslOrgSeqHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class BgCslOrgSeqFacadeControllerBean
extends AbstractBgCslOrgSeqFacadeControllerBean {
    private static final long serialVersionUID = 6552678246888553686L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslOrgSeqFacadeControllerBean");

    @Override
    protected HashMap _getOrgList(Context ctx, String orgTreeID, String orgGroupID, String bgSchemeID) throws BOSException, EASBizException {
        HashMap fillSeqMap = BgCslOrgSeqHelper.getOrgCollection(ctx, orgTreeID, orgGroupID, bgSchemeID);
        String bgCslOrgSeqID = (String)fillSeqMap.get("bgCslOrgSeqID");
        List orgUnitList = (List)fillSeqMap.get("orgUnitList");
        List sysOrgUnitList = BgCslOrgSeqHelper.getSysOrgUnitList(ctx, orgGroupID, orgTreeID);
        HashMap combineResult = this.combineOrgUnitList(sysOrgUnitList, orgUnitList);
        HashMap<String, String> returnValue = new HashMap<String, String>();
        returnValue.put("bgCslOrgSeqID", bgCslOrgSeqID);
        returnValue.put("orgUnitList", (String)combineResult.get("orgUnitList"));
        Boolean isModidied = (Boolean)combineResult.get("isModified");
        if (isModidied.equals(Boolean.TRUE)) {
            this._updateOrgSeq(ctx, bgCslOrgSeqID, orgUnitList);
        }
        return returnValue;
    }

    @Override
    protected void _updateOrgSeq(Context ctx, String bgCslOrgSeqID, List orgUnitList) throws BOSException, EASBizException {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String deleteSql = "delete from T_MBG_BgCslOrgSeqEntry where FParentID = '" + bgCslOrgSeqID + "';";
            DbUtil.execute((Context)ctx, (String)deleteSql);
            if (orgUnitList != null && orgUnitList.size() > 0) {
                sql.append("insert into T_MBG_BgCslOrgSeqEntry(FID, FParentID, FOrgUnitID, FSeq)");
                sql.append("values(?,?,?,?)");
                ps = cn.prepareStatement(sql.toString());
                HashMap map = null;
                String orgUnitID = null;
                String id = null;
                for (int i = 0; i < orgUnitList.size(); ++i) {
                    map = (HashMap)orgUnitList.get(i);
                    orgUnitID = (String)map.get("OrgUnitID");
                    id = Uuid.create().toString();
                    ps.setString(1, id);
                    ps.setString(2, bgCslOrgSeqID);
                    ps.setString(3, orgUnitID);
                    ps.setInt(4, i);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)cn);
        }
    }

    private HashMap combineOrgUnitList(List sysOrgUnitList, List schemeOrgUnitList) {
        HashMap row;
        int i;
        boolean isModified = false;
        if (schemeOrgUnitList.size() == 0) {
            for (i = 0; i < sysOrgUnitList.size(); ++i) {
                row = (HashMap)sysOrgUnitList.get(i);
                row.put("EntryID", Uuid.create().toString());
                schemeOrgUnitList.add(row);
            }
            isModified = true;
        } else {
            int i2;
            HashMap row2 = null;
            String orgUnitID = null;
            String preOrgUnitNumber = null;
            String nextOrgUnitNumber = null;
            ArrayList<String> scheme_OrgUnitIds = new ArrayList<String>();
            boolean isAsc = true;
            boolean hasInsert = false;
            for (int i3 = 0; i3 < schemeOrgUnitList.size(); ++i3) {
                row2 = (HashMap)schemeOrgUnitList.get(i3);
                orgUnitID = (String)row2.get("OrgUnitID");
                scheme_OrgUnitIds.add(orgUnitID);
                if (!isAsc || i3 <= 0) continue;
                nextOrgUnitNumber = (String)row2.get("OrgUnitNumber");
                row2 = (HashMap)schemeOrgUnitList.get(i3 - 1);
                preOrgUnitNumber = (String)row2.get("OrgUnitName");
                if (preOrgUnitNumber.compareTo(nextOrgUnitNumber) <= 0) continue;
                isAsc = false;
            }
            ArrayList<String> sysOrgUnit_OrgUnitIds = new ArrayList<String>();
            for (i2 = 0; i2 < sysOrgUnitList.size(); ++i2) {
                row2 = (HashMap)sysOrgUnitList.get(i2);
                orgUnitID = (String)row2.get("OrgUnitID");
                sysOrgUnit_OrgUnitIds.add(orgUnitID);
                if (scheme_OrgUnitIds.contains(orgUnitID)) continue;
                schemeOrgUnitList.add(row2);
                if (!isModified) {
                    isModified = true;
                }
                if (hasInsert) continue;
                hasInsert = true;
            }
            for (i2 = 0; i2 < schemeOrgUnitList.size(); ++i2) {
                row2 = (HashMap)schemeOrgUnitList.get(i2);
                orgUnitID = (String)row2.get("OrgUnitID");
                if (sysOrgUnit_OrgUnitIds.contains(orgUnitID)) continue;
                schemeOrgUnitList.remove(i2);
                if (isModified) continue;
                isModified = true;
            }
            if (isAsc && hasInsert) {
                Collections.sort(schemeOrgUnitList, new ListComparator());
            }
        }
        for (i = 0; i < schemeOrgUnitList.size(); ++i) {
            row = (HashMap)schemeOrgUnitList.get(i);
            row.remove("Seq");
            row.put("Seq", new Integer(i));
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>(4);
        returnValue.put("orgUnitList", schemeOrgUnitList);
        returnValue.put("isModified", new Boolean(isModified));
        return returnValue;
    }

    class ListComparator
    implements Comparator {
        ListComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            String number = (String)((HashMap)arg0).get("OrgUnitNumber");
            String tmpNumber = (String)((HashMap)arg1).get("OrgUnitNumber");
            return number.compareTo(tmpNumber);
        }
    }
}

