/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslTemplateBaseFacadeControllerBean;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.ViewListFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.ViewListMemberParserServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslTemplateBaseFacadeControllerBean
extends AbstractBgCslTemplateBaseFacadeControllerBean {
    private static final long serialVersionUID = 748181255557236562L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslTemplateBaseFacadeControllerBean");

    @Override
    protected Map _initTemplateData(Context ctx, BOSUuid bgSchemeId, TemplateStyleInfo templateStyle, MbgViewListManager viewManager, String orgId, String unitGroupId, String orgTreeId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        BgCslSchemeDimensionHelper schemeHelper = null;
        if (!StringUtils.isEmpty((String)orgTreeId)) {
            OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
            orgTreeInfo.setId(BOSUuid.read((String)orgTreeId));
            schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId.toString(), orgTreeInfo);
        } else {
            schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId.toString(), (String)null);
        }
        if (templateStyle != null) {
            resultMap.putAll(this.initBgTemplateStyle(ctx, templateStyle));
        }
        viewManager = this.loadViewManager(ctx, schemeHelper, viewManager, orgId, unitGroupId);
        resultMap.put("dimensino.member", viewManager);
        resultMap.put("dimension.property", ViewListFacadeFactory.getLocalInstance((Context)ctx).loadProperty(viewManager, bgSchemeId.toString()));
        return resultMap;
    }

    private Map<String, Map<String, String>> loadProperty(Context ctx, BgSchemeDimensionHelper schemeHelper, MbgViewListManager viewManager) throws BOSException, EASBizException {
        Object object;
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        HashMap propSortIds = new HashMap();
        HashMap<String, Set<String>> memberNumbers = new HashMap<String, Set<String>>();
        ArrayList objects = new ArrayList();
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            objects.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getRowDimension());
            objects.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getColDimension());
        }
        for (int i = 0; i < objects.size(); ++i) {
            MbgViewListAtribute attribObject;
            object = objects.get(i);
            if (!(object instanceof MbgViewListAtribute) || (attribObject = (MbgViewListAtribute)object).getPropertySort().getId() == null) continue;
            if (!propSortIds.containsKey(attribObject.getDimNumber())) {
                propSortIds.put(attribObject.getDimNumber(), new HashSet());
            }
            ((Set)propSortIds.get(attribObject.getDimNumber())).add(attribObject.getPropertySort().getId().toString());
        }
        if (propSortIds.isEmpty()) {
            return result;
        }
        objects.clear();
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            objects.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getRowCols());
        }
        for (int i = 0; i < objects.size(); ++i) {
            BgDimensionMember member;
            object = objects.get(i);
            if (!(object instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowObject = (MbgViewListRowCol)object;
            if (rowObject.isCombin()) {
                for (int m = 0; m < rowObject.getCombinMembers().size(); ++m) {
                    member = (BgDimensionMember)rowObject.getCombinMembers().get(m);
                    String[] types = member.getType().split(",");
                    String[] numbers = member.getNumber().split(",");
                    for (int mm = 0; mm < numbers.length; ++mm) {
                        this.addMember(memberNumbers, types[mm], numbers[mm]);
                    }
                }
                continue;
            }
            for (int d = 0; d < rowObject.getDimensions().size(); ++d) {
                MbgViewListDimensionInfo dimension = (MbgViewListDimensionInfo)rowObject.getDimensions().get(d);
                for (int m = 0; m < dimension.getMember().size(); ++m) {
                    member = (BgDimensionMember)dimension.getMember().get(m);
                    this.addMember(memberNumbers, member.getType(), member.getNumber());
                }
            }
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            List paramList = null;
            String dimNumber2 = null;
            Set subSet = null;
            for (String dimNumber2 : propSortIds.keySet()) {
                subSet = (Set)memberNumbers.get(dimNumber2);
                if (subSet == null || subSet.isEmpty()) continue;
                paramList = null;
                sql.setLength(0);
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber2)) continue;
                if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber2)) {
                    sql.append("Select acct.FNumber memberNumber, prop.FName_" + ctx.getLocale() + " propName, prop.FBgPropertySortID propSortId ");
                    sql.append("FROM T_MBG_PropertyRefSource propRef INNER JOIN T_MBg_BgProperty prop ON prop.FID = propRef.FPropertyId INNER JOIN T_MBG_BgAccount acct ON acct.FID = propRef.FSourceID Where acct.FBgAccountViewId = ? ");
                    sql.append("AND prop.FBgPropertySortID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)((Set)propSortIds.get(dimNumber2)).size()).append(") ");
                    sql.append("AND acct.FNumber IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                } else {
                    sql.append("Select memb.FNumber memberNumber, prop.FName_" + ctx.getLocale() + " propName, prop.FBgPropertySortID propSortId ");
                    sql.append("FROM T_MBG_PropertyRefSource propRef INNER JOIN T_MBg_BgProperty prop ON prop.FID = propRef.FPropertyId INNER JOIN T_MBG_MbgMember memb ON memb.FID = propRef.FSourceID Where memb.FViewId = ? ");
                    sql.append("AND prop.FBgPropertySortID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)((Set)propSortIds.get(dimNumber2)).size()).append(") ");
                    sql.append("AND memb.FNumber IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                }
                Object[] commParam = new Object[((Set)propSortIds.get(dimNumber2)).size() + 1];
                commParam[0] = schemeHelper.getDimension(dimNumber2).getViewId();
                System.arraycopy(((Set)propSortIds.get(dimNumber2)).toArray(), 0, commParam, 1, commParam.length - 1);
                paramList = MbgSqlHelper.getBatchParams((Object[])commParam, (Object[])subSet.toArray(), (int)50);
                if (paramList == null || paramList.isEmpty()) continue;
                pstmt = conn.prepareStatement(sql.toString());
                for (int i = 0; i < paramList.size(); ++i) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        String propSortId = rst.getString("PropSortId");
                        String memberNumber = rst.getString("MemberNumber");
                        String propName = rst.getString("propName");
                        String key = dimNumber2 + "_" + propSortId;
                        if (!result.containsKey(key)) {
                            result.put(key, new HashMap());
                        }
                        ((Map)result.get(key)).put(memberNumber, propName);
                    }
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return result;
    }

    private void addMember(Map<String, Set<String>> memberNumbers, String dimNumber, String memberNumber) {
        if (memberNumbers == null || StringUtils.isEmpty((String)dimNumber) || StringUtils.isEmpty((String)memberNumber)) {
            return;
        }
        if (!memberNumbers.containsKey(dimNumber)) {
            memberNumbers.put(dimNumber, new HashSet());
        }
        memberNumbers.get(dimNumber).add(memberNumber);
    }

    private Map<String, String> initBgTemplateStyle(Context ctx, TemplateStyleInfo templateStyle) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (templateStyle != null) {
            if (!StringUtils.isEmpty((String)templateStyle.getUnitName())) {
                result.put("edit.orgunit", templateStyle.getUnitName());
            }
            if (!StringUtils.isEmpty((String)templateStyle.getDateName())) {
                result.put("edit.period", templateStyle.getDateName());
            }
        }
        return result;
    }

    private MbgViewListManager loadViewManager(Context ctx, BgSchemeDimensionHelper schemeHelper, MbgViewListManager viewManager, String orgId, String unitGroupId) throws BOSException, EASBizException {
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeInfo("select orgUnit.id where id = '" + schemeHelper.getBgSchemeId() + "'");
        ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, schemeHelper, orgId);
        if (!viewManager.isNeedReadRelation()) {
            helper.setQueryAllRelation(false);
        }
        helper.setUnitGroupId(unitGroupId);
        helper.parseMember(viewManager);
        return viewManager;
    }

    @Override
    protected Map _checkMemberExists(Context ctx, String bgSchemeId, Map queryMember, String unionId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId, (String)null);
        ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, (BgSchemeDimensionHelper)schemeHelper);
        helper.setUnitGroupId(unionId);
        return helper.checkMemberExists(queryMember, null);
    }
}

