/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.IBgElement;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.bgcsl.BgCslSpecialItemsFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateException;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateException;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslTemplateControllerBean;
import com.kingdee.eas.ma.bgcsl.common.BgCslTemplateHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgMeasureUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslTemplateControllerBean
extends AbstractBgCslTemplateControllerBean {
    private static final long serialVersionUID = -6187346578530054432L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslTemplateControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCslTemplateInfo info = (BgCslTemplateInfo)model;
        if (info.getNumber() != null && info.getNumber().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERTOOLONG);
        }
        this.checkDupNumber(ctx, info.getNumber(), info.getId() == null ? null : info.getId().toString(), info.getBgScheme().getId().toString(), info.getOrgTree().getId().toString());
        if (info.getName() != null && info.getName().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NAMETOOLONG);
        }
        try {
            this.transAndCheckBook(ctx, info, info.getBook());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return super._save(ctx, model);
    }

    private Book transAndCheckBook(Context ctx, BgCslTemplateInfo model, Book book) throws BOSException, EASBizException {
        if (ctx == null || model == null || book == null) {
            return book;
        }
        HashSet bgItemSet = new HashSet();
        HashSet bgPeriodSet = new HashSet();
        HashSet bgElementSet = new HashSet();
        HashSet currencySet = new HashSet();
        ArrayList formulaList = new ArrayList();
        if (!BgTemFormTypeEnum.VIEWLIST.equals((Object)model.getFormType()) && book != null && (BgTemFormTypeEnum.FIXEDFORM.equals((Object)model.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)model.getFormType()))) {
            this.transAndCheckBookForNoView(ctx, model, book, formulaList, bgItemSet, bgElementSet, bgPeriodSet, currencySet);
            new MbgXMLParser(ctx);
            model.setDimensionData(MbgXMLParser.unParse((IMbgViewManager)DimensionFormulaHelper.buildViewMamager((Context)ctx, formulaList, null)));
        }
        return book;
    }

    private void transAndCheckBookForNoView(Context ctx, BgCslTemplateInfo model, Book book, List formulaList, Set bgItemSet, Set bgElementSet, Set bgPeriodSet, Set currencySet) throws EASBizException, BOSException {
        boolean isAssignTemplate = false;
        Sheet sheet = null;
        Cell cell = null;
        String formulaStr = null;
        String expression = null;
        String _tmpStr = null;
        String[] formula = null;
        String[] _tmpStrs = null;
        String[] bgItemNums = null;
        ArrayList<String[]> checkList = new ArrayList<String[]>();
        ArrayList<String> bgItemNumList = new ArrayList<String>();
        HashSet<String> bgPeriodVariable = new HashSet<String>();
        String orgUnitId = model.getCU() == null ? ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString() : model.getCU().getId().toString();
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        boolean isAnalyseSheet = false;
        if (model.getBgType() != null && "bgMAAAAKIcA7rHKd".equals(model.getBgType().getId().toString())) {
            isAnalyseSheet = true;
        }
        HashSet<String> bgPeriodNumbers = new HashSet<String>();
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRowCount = sheet.getMaxRowIndex();
            int maxColCount = sheet.getMaxColIndex();
            for (int i = 0; i <= maxRowCount; ++i) {
                for (int j = 0; j <= maxColCount; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                    formulaList.add(formulaStr);
                    if (isAnalyseSheet) {
                        throw new BgTemplateException(BgTemplateException.SELF_ANA_TEM_NOT_ALLOW_ITEMFORMUL);
                    }
                    formula = new String[]{sheet.getSheetName(), formulaStr, String.valueOf(i), String.valueOf(j)};
                    checkList.add(formula);
                    _tmpStrs = BgNFSHelper.parseFormulaPara((String)formulaStr);
                    if (_tmpStrs == null || _tmpStrs.length != 6) {
                        throw new BgException(BgException.BGITEMPARSEERROR, (Object[])new String[]{formulaStr});
                    }
                    _tmpStr = _tmpStrs[0];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"item.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                    }
                    bgItemSet.add(_tmpStr.replaceAll(",", "_"));
                    bgItemNums = _tmpStr.split(",");
                    for (int x = 0; x < bgItemNums.length; ++x) {
                        if (bgItemNumList.contains(bgItemNums[x])) continue;
                        bgItemNumList.add(bgItemNums[x]);
                    }
                    _tmpStr = _tmpStrs[2];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"element.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                    }
                    bgElementSet.add(_tmpStr);
                    _tmpStr = _tmpStrs[1];
                    if (!StringUtils.isEmpty((String)_tmpStr)) {
                        bgPeriodNumbers.add(_tmpStr);
                        if (!bgPeriodVariable.contains(_tmpStr)) {
                            boolean isRelativeBgPeriod = false;
                            int relativeValue = 0;
                            try {
                                relativeValue = Integer.parseInt(_tmpStr);
                                isRelativeBgPeriod = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (isRelativeBgPeriod) {
                                if (Math.abs(relativeValue) > 100) {
                                    String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"itemformula.to.100.to100", (Locale)ctx.getLocale());
                                    throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                                }
                            } else if (BgPeriodNVariableHelper.checkCanConvert((String)_tmpStr)) {
                                bgPeriodVariable.add(_tmpStr);
                            } else {
                                bgPeriodSet.add(_tmpStr);
                            }
                        }
                    }
                    if (!StringUtils.isEmpty((String)(_tmpStr = _tmpStrs[5]))) {
                        currencySet.add(_tmpStr);
                    }
                    if (!StringUtils.isEmpty((String)(expression = BgNFSHelper.getExpression((Cell)cell))) && !isAssignTemplate) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inDataFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                        }
                    }
                    if (!StringUtils.isEmpty((String)(expression = cell.getFormula())) && !isAssignTemplate) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inActualFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                        }
                    }
                    if (StringUtils.isEmpty((String)(expression = cell.getFormula())) || isAssignTemplate) continue;
                    try {
                        ExcelFormulaPaserHelper.parse((String)expression);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inADDFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{msg});
                    }
                }
            }
        }
        try {
            BgPeriodDispFactory.getLocalInstance((Context)ctx).checkPeriodType(bgPeriodNumbers, false);
            DimensionFormulaHelper.checkDimensionMemberExist((Context)ctx, (String)orgUnitId, bgItemNumList);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkList.clear();
        }
    }

    @Override
    protected Map _getRPCDataMap(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> rpcDataMap = new HashMap<String, Object>();
        String oprtState = (String)paramMap.get("oprtState");
        IMeasureUnit iM = MeasureUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        if (oprtState.equals(OprtState.ADDNEW)) {
            muFilter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)"0", CompareType.EQUALS));
        }
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol1 = iM.getMeasureUnitCollection(muView);
        rpcDataMap.put("enableMeasureUnit", muCol1);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        SorterItemInfo sorter = new SorterItemInfo("number");
        view.getSorter().add(sorter);
        view.setFilter(filter);
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, (String)paramMap.get("BGSCHEME_ID"), (String)null);
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)schemeHelper.getMemberSet(DimensionConstants.DEF_ELEMENT_NUMBER, true), CompareType.INCLUDE));
        IBgElement iElement = BgElementFactory.getLocalInstance((Context)ctx);
        BgElementCollection bgElementCol = iElement.getBgElementCollection(view);
        rpcDataMap.put("bgElementCol", bgElementCol);
        EntityViewInfo muView2 = new EntityViewInfo();
        FilterInfo muFilter2 = new FilterInfo();
        muFilter2.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView2.setFilter(muFilter2);
        muView2.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol2 = iM.getMeasureUnitCollection(muView2);
        rpcDataMap.put("AllmeasureUnit", muCol2);
        return rpcDataMap;
    }

    @Override
    protected void _saveSimpleInfo(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        BgCslTemplateInfo bgTemInfo = (BgCslTemplateInfo)info;
        String id = bgTemInfo.getId().toString();
        String name = bgTemInfo.getName();
        String number = bgTemInfo.getNumber();
        String description = bgTemInfo.getDescription();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String measureId = bgTemInfo.getDefaultMeasureUnit().getId().toString();
        this.checkDupNumber(ctx, number, id, bgTemInfo.getBgScheme().getId().toString(), bgTemInfo.getOrgTree().getId().toString());
        sql.append(" update t_mbg_bgCsltemplate set fname = ?, fnumber = ?, fdescription = ?, fDefaultMeasureUnitId = ?, FLastUpdateTime = ?, FBgTypeId = ? where fid = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, name);
            sm.setString(2, number);
            sm.setString(3, description);
            sm.setString(4, measureId);
            sm.setTimestamp(5, time);
            if (bgTemInfo.getBgType() == null) {
                sm.setNull(6, 12);
            } else {
                sm.setString(6, bgTemInfo.getBgType().getId().toString());
            }
            sm.setString(7, id);
            sm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        CoreBaseCollection col = new CoreBaseCollection();
        col.addObjectCollection((IObjectCollection)bgTemInfo.getBgSpecialItems());
        BgCslSpecialItemsFactory.getLocalInstance(ctx).saveBatchData(col);
        this.saveMeasure(ctx, bgTemInfo);
    }

    private void saveMeasure(Context ctx, BgCslTemplateInfo bgTem) throws BOSException, EASBizException {
        String id = bgTem.getId().toString();
        PreparedStatement ps = null;
        Connection connection = null;
        BOSObjectType type = new BgMeasureUnitInfo().getBOSType();
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(80);
            strBuffer.append("delete T_MBG_BgCslTemMeasureUnit where FBGCSLTEMPLATEID = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, id);
            ps.executeUpdate();
            if (bgTem.getBgMeasureUnit() != null && bgTem.getBgMeasureUnit().size() != 0) {
                strBuffer = new StringBuffer(80);
                strBuffer.append("insert into T_MBG_BgCslTemMeasureUnit(fid,FBGCSLTEMPLATEID,fbgelementid,fmeasureunitid) values(?,?,?,?)");
                ps = connection.prepareStatement(strBuffer.toString());
                for (int i = 0; i < bgTem.getBgMeasureUnit().size(); ++i) {
                    ps.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                    ps.setString(2, id);
                    ps.setString(3, bgTem.getBgMeasureUnit().get(i).getBgElement().getId().toString());
                    ps.setString(4, bgTem.getBgMeasureUnit().get(i).getMeasureUnit().getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private void checkDupNumber(Context ctx, String number, String id, String bgSchemeId, String treeId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(60);
        if (id == null) {
            id = "000000000000000000000000000=";
        }
        sql.append(" SELECT FID FROM T_MBG_BgCslTemplate where FBgSchemeId = ? AND FOrgTreeID = ? AND FNumber = ? AND FID <> ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId);
            pstmt.setString(2, treeId);
            pstmt.setString(3, number);
            pstmt.setString(4, id);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{number});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _checkRefByForm(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_MBg_BgCslForm where FBgCslTemplateID = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }

    @Override
    protected void _clone(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgCslTemplateInfo info = this.getBgCslTemplateInfo(ctx, pk, BgCslTemplateHelper.getCslTemplateFullSelector());
        if (info.getDefaultMeasureUnit() != null && info.getDefaultMeasureUnit().isIsDisabled()) {
            throw new BgTemplateException(BgTemplateException.IMPORTNOTFOUNDMEASUREUNIT, new Object[]{info.getDefaultMeasureUnit().getNumber()});
        }
        info = info.deepClone();
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setNumber("clone_" + info.getNumber());
        info.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"clone", (Locale)ctx.getLocale()) + "_" + info.getName());
        IObjectPK newPk = this._save(ctx, (IObjectValue)info);
        MbgViewListDesCellFactory.getLocalInstance((Context)ctx).cloneFormTemplate(pk.toString(), newPk.toString());
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        try {
            if (this._checkRefByForm(ctx, pk.toString())) {
                throw new CanNotDeleteException(new BgCslTemplateException(BgCslTemplateException.CANNOTDELETEBYFORM).getMessage());
            }
        }
        catch (CanNotDeleteException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    @Override
    protected void _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.doCancelOrNot(ctx, ids, true);
    }

    @Override
    protected void _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.doCancelOrNot(ctx, ids, false);
    }

    protected void doCancelOrNot(Context ctx, Set ids, boolean isCancel) throws BOSException, EASBizException {
        if (ctx == null || ids == null || ids.isEmpty()) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgCslTemplate Set FTemplateStatus = " + (isCancel ? 10 : 0) + " Where FID = ?"), new ArrayList(ids));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected boolean _checkNumberDup(Context ctx, String templateId, String bgSchemeId, String orgTreeId, String number) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select t1.fid from T_MBG_BgCslTemplate t1 where  t1.fnumber = ?  and t1.FBgSchemeId = ? and t1.FOrgTreeId = ? ");
            if (!StringUtils.isEmpty((String)templateId)) {
                sql.append(" and t1.fid <> ?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                sm.setString(2, bgSchemeId);
                sm.setString(3, orgTreeId);
                if (!StringUtils.isEmpty((String)templateId)) {
                    sm.setString(4, templateId);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }
}

