/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.bgcsl.BgCslFormCollection;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormStateEnum;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgCslViewListTemplateFacadeFactory;
import com.kingdee.eas.ma.bgcsl.IBgCslViewListTemplateFacade;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslViewListFormFacadeControllerBean;
import com.kingdee.eas.ma.bgcsl.app.utils.BgCslViewlistFormServerHelper;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslCommonHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.ViewListFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.ViewListMemberParserServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCslViewListFormFacadeControllerBean
extends AbstractBgCslViewListFormFacadeControllerBean {
    private static final long serialVersionUID = -5979197525078235465L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslViewListFormFacadeControllerBean");

    @Override
    protected Map _addNewViewListFormInfo(Context ctx, BgCslFormInfo bgForm, String bgOrgViewId, boolean isBatch, String addNewPermissionNumber) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected List _checkNumber(Context ctx, BgCslFormInfo bgFormInfo, boolean isBatch) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected BgCslFormInfo _checkBgForm(Context ctx, BgCslFormInfo bgFormInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectPK _updateBgFormInfo(Context ctx, BgCslFormInfo bgFormInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getInitBgViewDimensionInfo(Context ctx, MbgViewListManager viewListManager, String bgFormId, String orgTreeId, String currOrgId, boolean isOnlyCurrOrg, boolean isOnlyLeaf) throws BOSException, EASBizException {
        if (viewListManager == null || StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        if (!BgCslFormFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectStringPK(bgFormId))) {
            return null;
        }
        BgCslFormInfo bgForm = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormInfo((IObjectPK)new ObjectStringPK(bgFormId), BgCslFormHelper.getSelector());
        HashMap<String, Map> resMap = new HashMap<String, Map>();
        HashMap<MbgViewListDimensionManager, BgPeriodInfo> tempMap = new HashMap<MbgViewListDimensionManager, BgPeriodInfo>();
        for (int s = 0; s < viewListManager.getSheetManagers().size(); ++s) {
            tempMap.put(((MbgViewListSheetManager)viewListManager.getSheetManagers().get(s)).getDimensionManager(), bgForm.getBgPeriod());
        }
        Map periodMap = BgViewServerHelper.queryMbgViewListBgPeriodByPeriod((Context)ctx, tempMap, (boolean)false, (Map)viewListManager.getPeriodCache());
        resMap.put("BGPERIOD", periodMap);
        if (viewListManager.getOrgUnitMap() == null) {
            HashSet<String> orgNums = new HashSet<String>();
            DimensionCommonHelper.getOrgNumsForCurViewManager((MbgViewListManager)viewListManager, orgNums, (boolean)false);
            resMap.put("ORGUNIT", BgCslViewlistFormServerHelper.queryBgViewOrgUnit(ctx, null, bgForm, orgTreeId, false, false, currOrgId, false, orgNums));
        } else {
            resMap.put("ORGUNIT", viewListManager.getOrgUnitMap());
        }
        return resMap;
    }

    public static Map queryBgViewOrgUnit(Context ctx, String permNumber, BgCslFormInfo bgForm, String orgTreeId, boolean isOnlyCurrOrg, String currOrgId, boolean isOnlyLeaf) throws BOSException, EASBizException {
        if (bgForm == null) {
            return null;
        }
        BOSUuid orgUnitId = currOrgId != null ? BOSUuid.read((String)currOrgId) : bgForm.getOrgUnit().getId();
        OrgUnitInfo currOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        if (currOrg != null) {
            orgMap.put(currOrg.getId().toString(), currOrg.castToFullOrgUnitInfo());
            return orgMap;
        }
        return orgMap;
    }

    @Override
    protected Map _initViewListData(Context ctx, BgCslFormInfo bgFormInfo, TemplateStyleInfo templateStyle, String orgViewId, MbgViewListManager viewManager, IReportPropertyAdapter adapter) throws BOSException, EASBizException {
        if (bgFormInfo == null || bgFormInfo.getBgCslTemplate() == null) {
            return new HashMap();
        }
        ArrayList<MbgViewListSheetManager> oldSheetManagers = new ArrayList<MbgViewListSheetManager>();
        Map resultMap = null;
        IBgCslViewListTemplateFacade iViewListFacade = BgCslViewListTemplateFacadeFactory.getLocalInstance(ctx);
        if (viewManager != null) {
            for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
                oldSheetManagers.add(DimensionCommonHelper.cloneSheetManager((MbgViewListSheetManager)((MbgViewListSheetManager)viewManager.getSheetManagers().get(s))));
            }
            resultMap = iViewListFacade.initTemplateData(bgFormInfo.getBgCslTemplate(), templateStyle, viewManager, bgFormInfo.getOrgUnit().getId().toString());
        } else {
            resultMap = iViewListFacade.initTemplateData(bgFormInfo.getBgCslTemplate(), templateStyle, bgFormInfo.getOrgUnit().getId().toString());
        }
        if (resultMap != null && adapter != null && templateStyle != null) {
            resultMap.putAll(ViewListFacadeFactory.getLocalInstance((Context)ctx).initTemplateStyle(adapter, templateStyle));
        }
        if (resultMap == null || resultMap.get("dimensino.member") == null) {
            return resultMap;
        }
        viewManager = (MbgViewListManager)resultMap.get("dimensino.member");
        if (ViewlistCombinHelper.checkHasCombin((MbgViewListManager)viewManager).booleanValue() && bgFormInfo.getBgScheme().getId() != null) {
            this.reParseCanAddMembers(ctx, viewManager, bgFormInfo.getBgScheme().getId().toString(), bgFormInfo, true);
        }
        Map otherMap = this._getInitBgViewDimensionInfo(ctx, viewManager, bgFormInfo.getId().toString(), orgViewId, bgFormInfo.getOrgUnit().getId().toString(), false, false);
        BgCslViewListFormFacadeControllerBean.additionalForViewListManager(ctx, bgFormInfo, otherMap, viewManager);
        return resultMap;
    }

    public static void additionalForViewListManager(Context ctx, BgCslFormInfo curBgForm, Map cacheMap, MbgViewListManager viewManager) throws EASBizException {
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            MbgViewListDimensionManager bm = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager();
            BgViewHelper.fillViewListDimensionMember((Context)ctx, (MbgViewListDimensionManager)bm, (Map)cacheMap, (String)curBgForm.getOrgUnit().getId().toString(), (BgPeriodInfo)curBgForm.getBgPeriod(), (CurrencyInfo)curBgForm.getCurrency(), (BgVersionInfo)curBgForm.getBgVersion(), (boolean)false);
        }
    }

    protected MbgViewListManager reParseCanAddMembers(Context ctx, MbgViewListManager viewManager, String bgSchemeId, BgCslFormInfo bgFormInfo, boolean isCombin) throws BOSException, EASBizException {
        if (ctx == null || viewManager == null || bgSchemeId == null) {
            return null;
        }
        MbgViewListFormServerHelper.backupCanAddMember((MbgViewListManager)viewManager);
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId, bgFormInfo.getBgScheme().getOrgUnit().getId().toString());
        ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, (BgSchemeDimensionHelper)schemeHelper);
        helper.parseCanAddMember(viewManager, isCombin, false);
        if (bgFormInfo != null) {
            Map otherMap = this._getInitBgViewDimensionInfo(ctx, viewManager, bgFormInfo.getId().toString(), schemeHelper.getBgOrgViewId(), bgFormInfo.getOrgUnit().getId().toString(), false, false);
            BgCslViewListFormFacadeControllerBean.additionalForViewListManager(ctx, bgFormInfo, otherMap, viewManager);
        }
        return viewManager;
    }

    @Override
    protected MbgViewListManager _loadViewListManager(Context ctx, String bgFormId, String orgViewId, MbgViewListManager viewListManager, String permissionNumber, String currOrgId, boolean isOnlyCurrOrg, boolean isOnlyLeaf) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        MbgViewListManager view = null;
        BgCslFormInfo cslFormInfo = null;
        TemplateStyleInfo style = null;
        try {
            cslFormInfo = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormInfo((IObjectPK)new ObjectStringPK(bgFormId), BgCslFormHelper.getSelector());
            if (viewListManager == null) {
                viewListManager = new MbgViewListXMLParser(ctx).parse(cslFormInfo.getDimensionData());
            }
            style = MbgXMLParser.parseStyle((byte[])cslFormInfo.getBgCslTemplate().getStyleSet().getData());
            Map resultMap = this._initViewListData(ctx, cslFormInfo, style, orgViewId, viewListManager, null);
            view = (MbgViewListManager)resultMap.get("dimensino.member");
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return view;
    }

    @Override
    protected void _saveViewData(Context ctx, BgCslFormInfo bgFormInfo, Map bgDataMap, Map otherOrgDimensionDataToSave, Map editNote, IObjectCollection desColls) throws BOSException, EASBizException {
    }

    @Override
    protected MbgViewListSheetManager _reParseSheetManager(Context ctx, MbgViewListSheetManager sheetManager, String bgSchemeId, BgCslFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (ctx == null || sheetManager == null || bgSchemeId == null) {
            return null;
        }
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId, bgFormInfo.getBgScheme().getOrgUnit().getId().toString());
        ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, (BgSchemeDimensionHelper)schemeHelper);
        MbgViewListManager view = sheetManager.getView();
        int oldSheetIndex = sheetManager.getSheetIndex();
        sheetManager.setSheetIndex(view.getSheetManagers().indexOf(sheetManager));
        helper.parseMember(view);
        Map otherMap = this._getInitBgViewDimensionInfo(ctx, view, bgFormInfo.getId().toString(), null, null, false, false);
        BgCslViewListFormFacadeControllerBean.additionalForViewListManager(ctx, bgFormInfo, otherMap, view);
        sheetManager = (MbgViewListSheetManager)view.getSheetManagers().get(sheetManager.getSheetIndex());
        sheetManager.setSheetIndex(oldSheetIndex);
        return sheetManager;
    }

    @Override
    protected MbgViewListSheetManager _reParseCanAddMembers(Context ctx, MbgViewListSheetManager sheetManager, String bgSchemeId, BgCslFormInfo bgFormInfo, boolean isCombin) throws BOSException, EASBizException {
        if (ctx == null || sheetManager == null || bgSchemeId == null) {
            return null;
        }
        MbgViewListManager view = sheetManager.getView();
        view.getSheetManagers().clear();
        view.getSheetManagers().add(sheetManager);
        this.reParseCanAddMembers(ctx, view, bgSchemeId, bgFormInfo, isCombin);
        return (MbgViewListSheetManager)view.getSheetManagers().get(0);
    }

    @Override
    protected MbgViewListManager _reParseCanAddMembers(Context ctx, MbgViewListManager view, BgCslFormInfo bgFormInfo, boolean isCombin) throws BOSException, EASBizException {
        this.reParseCanAddMembers(ctx, view, bgFormInfo.getBgScheme().getId().toString(), bgFormInfo, isCombin);
        return view;
    }

    @Override
    protected Map _getViewListManagers(Context ctx, String bgFormId, String orgViewId, Set orgNums, String permissionNumber, String currOrgId, boolean isOnlyCurrOrg) throws BOSException, EASBizException {
        return this.innerGetViewListManagers(ctx, bgFormId, orgViewId, orgNums, currOrgId, null, null, null, null);
    }

    @Override
    protected Map _initMutiOrgMemberCheckHelper(Context ctx, Map mutiViewManagers, BgSchemeDimensionHelper schemeHelper, boolean isClearCtx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _saveEditNote(Context ctx, String id, Map editNotes) throws BOSException {
    }

    @Override
    protected Map _queryMbgLeafMember(Context ctx, String bgSchemeID, Set dimensionSet) throws BOSException, EASBizException {
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
        if (bgSchemeID == null || dimensionSet == null || dimensionSet.isEmpty()) {
            return result;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT  mbgDim.FSrcNumber, mbgMem.FNumber FROM T_Mbg_MbgMember mbgMem ").append(" join T_Mbg_MbgView mbgView on mbgMem.FViewID = mbgView.FID ").append(" join T_Mbg_MbgDim mbgDim on mbgMem.FDimId = mbgDim.FID ").append(" join T_Mbg_BgDimSettingsMember settMem on settMem.FMemberID = mbgView.FID ").append(" join T_Mbg_BgDimSettings sett on settMem.FBgDimSettingsID = sett.FID ").append(" join T_Mbg_BgScheme bgScheme on sett.FBgSchemeID =  bgScheme.FID ").append(" where bgScheme.FID = '" + bgSchemeID + "' ").append(" and mbgMem.FIsLeaf = 1 ").append(" and mbgDim.FSrcNumber in ( ");
        for (String src : dimensionSet) {
            sqlBuf.append("'").append(src).append("',");
        }
        sqlBuf.delete(sqlBuf.length() - 1, sqlBuf.length()).append(" )");
        try {
            IRowSet rowSet = BgDBUtils.executeQuery((Context)ctx, (String)sqlBuf.toString());
            while (rowSet.next()) {
                String src;
                src = rowSet.getString("FSrcNumber");
                String member = rowSet.getString("FNumber");
                HashSet<String> memberSet = (HashSet<String>)result.get(src);
                if (memberSet == null) {
                    memberSet = new HashSet<String>();
                    result.put(src, memberSet);
                }
                memberSet.add(src + ":" + member);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return result;
    }

    @Override
    protected String _queryFormByData(Context ctx, Map parameter) throws BOSException, EASBizException {
        String cfsEntryCubeName;
        String bgschemeId = (String)parameter.get("schemeId");
        String orgId = (String)parameter.get("orgId");
        String bgVersionId = (String)parameter.get("versionId");
        String formula = (String)parameter.get("formula");
        String bgFormId = (String)parameter.get("form");
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance((Context)ctx).getBgSchemeInfo("select refCube where id = '" + bgschemeId + "'");
        String cfsCubeName = BgCubeUtils.getCFSCubeName((String)bgSchemeInfo.getRefCube());
        String formId = this.getFormId(ctx, orgId, bgVersionId, formula, cfsCubeName, cfsEntryCubeName = BgCubeUtils.getCFSEntryCubeName((String)bgSchemeInfo.getRefCube()));
        return formId == bgFormId ? null : formId;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFormId(Context ctx, String orgId, String bgVersionId, String formula, String cfsCubeName, String cfsEntryCubeName) throws BOSException {
        Connection connection = null;
        PreparedStatement prst = null;
        ResultSet rs = null;
        String formId = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT top 1 entry.FFORMID formId FROM ");
        sql.append(cfsCubeName + " cubeData inner join ");
        sql.append(cfsEntryCubeName + " entry ");
        sql.append(" on entry.FDataId = cubeData.FID ");
        sql.append(" where cubeData.FVersion= ? ");
        sql.append(" AND cubeData.FFormula= ? ");
        sql.append(" AND  cubeData.FOrgUnitID= ? ");
        try {
            connection = BgDBUtils.getConnection((Context)ctx);
            prst = connection.prepareStatement(sql.toString());
            prst.setInt(1, Integer.valueOf(bgVersionId));
            prst.setString(2, formula);
            prst.setString(3, orgId);
            rs = prst.executeQuery();
            while (rs.next()) {
                formId = rs.getString("formId");
            }
        }
        catch (SQLDataException var1) {
            try {
                throw new BOSException((Throwable)var1);
                catch (SQLException var2) {
                    throw new BOSException((Throwable)var2);
                }
            }
            catch (Throwable throwable) {
                DBUtils.cleanup(rs, prst, (Connection)connection);
                throw throwable;
            }
        }
        DBUtils.cleanup((ResultSet)rs, (Statement)prst, (Connection)connection);
        return formId;
    }

    @Override
    protected Map _loadViewManagersForProvider(Context ctx, BgCslFormInfo bgFormInfo, TemplateStyleInfo templateStyle, String orgViewId, MbgViewListManager viewManager, IReportPropertyAdapter adapter) throws BOSException, EASBizException {
        ViewListMemberCacheHelper memberCacheHelper = new ViewListMemberCacheHelper();
        viewManager.setMemberCacheHelper(memberCacheHelper);
        Map<String, OrgUnitInfo> orgUnitMap = null;
        HashSet<String> orgNums = new HashSet<String>();
        DimensionCommonHelper.getOrgNumsForCurViewManager((MbgViewListManager)viewManager, orgNums);
        String currOrgNumber = bgFormInfo.getOrgUnit().getNumber();
        orgNums.add(currOrgNumber);
        orgUnitMap = BgCslViewlistFormServerHelper.queryBgViewOrgUnit(ctx, null, bgFormInfo, orgViewId, false, false, bgFormInfo.getOrgUnit().getId().toString(), false, null);
        viewManager.setOrgUnitMap(orgUnitMap);
        HashSet<String> existFormOrg = new HashSet<String>();
        for (String string : orgUnitMap.keySet()) {
            OrgUnitInfo temp = orgUnitMap.get(string);
            existFormOrg.add(temp.getNumber());
        }
        HashSet<String> notExistFormOrg = new HashSet<String>();
        for (String orgNumber : orgNums) {
            if (existFormOrg.contains(orgNumber)) continue;
            notExistFormOrg.add(orgNumber);
        }
        orgNums.removeAll(notExistFormOrg);
        this.dealNotExistsOrg(viewManager, currOrgNumber, notExistFormOrg);
        this.dealAddOrgDeleForm(bgFormInfo, viewManager, existFormOrg);
        HashMap<String, BgPeriodDispCollection> hashMap = new HashMap<String, BgPeriodDispCollection>();
        viewManager.setPeriodCache(hashMap);
        Map result = this._initViewListData(ctx, bgFormInfo, templateStyle, orgViewId, viewManager, adapter);
        if (orgNums.size() > 1) {
            Map multiViewMap = this.innerGetViewListManagers(ctx, bgFormInfo.getId().toString(), orgViewId, orgNums, bgFormInfo.getOrgUnit().getId().toString(), memberCacheHelper, bgFormInfo, orgUnitMap, hashMap);
            result.put("MULTI_ORG_VIEW_MANAGER", multiViewMap);
            long std = System.currentTimeMillis();
            result.put("MULTI_ORG_VIEW_MANAGER_FORMULAS", this.innerGetMultiOrgFormulas(ctx, multiViewMap, bgFormInfo));
            logger.error((Object)("innerGetMultiOrgFormulas time:" + (System.currentTimeMillis() - std)));
            HashMap<String, BgCslFormInfo> orgBgFormInfo = new HashMap<String, BgCslFormInfo>();
            BgCslFormCollection bgCslFormColl = BgCslViewlistFormServerHelper.getBgForm(ctx, bgFormInfo, orgNums, BgCslFormHelper.getSelector(), null);
            if (bgCslFormColl != null && !bgCslFormColl.isEmpty()) {
                for (int i = 0; i < bgCslFormColl.size(); ++i) {
                    orgBgFormInfo.put(bgCslFormColl.get(i).getBizOrgUnit().getId().toString(), bgCslFormColl.get(i));
                }
                result.put("MULTI_ORG_BGFORM", orgBgFormInfo);
            }
        }
        return result;
    }

    protected MbgViewListManager innerLoadViewListManager(Context ctx, String bgFormId, BgCslFormInfo bgFormInfo, String orgViewId, MbgViewListManager viewListManager, String currOrgId, boolean isOnlyCurrOrg, boolean isOnlyLeaf) throws BOSException, EASBizException {
        viewListManager = (MbgViewListManager)this._initViewListData(ctx, bgFormInfo, null, orgViewId, viewListManager, null).get("dimensino.member");
        return viewListManager;
    }

    protected Map<String, Set<String>> innerGetMultiOrgFormulas(Context ctx, Map<FullOrgUnitInfo, MbgViewListManager> multiViewMap, BgCslFormInfo bgFormInfo) throws EASBizException, BOSException {
        HashMap<String, Set<String>> formulasMap = new HashMap<String, Set<String>>();
        if (multiViewMap == null || multiViewMap.isEmpty() || bgFormInfo.getBizBgScheme() == null) {
            return formulasMap;
        }
        BgCslSchemeDimensionHelper bgSchemeHelper = new BgCslSchemeDimensionHelper(ctx, bgFormInfo.getBizBgScheme().getId().toString(), bgFormInfo.getOrgTree());
        MbgViewListManager manager = null;
        HashSet formulas = null;
        FullOrgUnitInfo org2 = null;
        for (FullOrgUnitInfo org2 : multiViewMap.keySet()) {
            manager = multiViewMap.get(org2);
            if (!MbgViewListFormServerHelper.checkHasCombin((MbgViewListManager)manager).booleanValue()) continue;
            formulas = new HashSet();
            for (int index = 0; index < manager.getSheetManagers().size(); ++index) {
                formulas.addAll(MbgViewListFormServerHelper.buildFormula((MbgViewListSheetManager)((MbgViewListSheetManager)manager.getSheetManagers().get(index)), (BgSchemeDimensionHelper)bgSchemeHelper, null));
            }
            formulasMap.put(org2.getId().toString(), formulas);
        }
        return formulasMap;
    }

    protected Map innerGetViewListManagers(Context ctx, String bgFormId, String orgViewId, Set orgNums, String currOrgId, ViewListMemberCacheHelper memberCacheHelper, BgCslFormInfo bgForm, Map<String, OrgUnitInfo> orgUnitMap, Map<String, BgPeriodDispCollection> periodCache) throws BOSException, EASBizException {
        BgCslFormInfo _bgForm;
        if (StringUtils.isEmpty((String)bgFormId) || orgNums == null || orgNums.isEmpty()) {
            return null;
        }
        HashMap<FullOrgUnitInfo, MbgViewListManager> res = new HashMap<FullOrgUnitInfo, MbgViewListManager>();
        if (memberCacheHelper == null) {
            memberCacheHelper = new ViewListMemberCacheHelper();
        }
        if ((_bgForm = bgForm) == null) {
            _bgForm = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgCslFormHelper.getSelector());
        }
        if (orgUnitMap == null) {
            orgUnitMap = BgCslViewlistFormServerHelper.queryBgViewOrgUnit(ctx, null, _bgForm, orgViewId, false, false, currOrgId, false, orgNums);
        }
        if (periodCache == null) {
            periodCache = new HashMap<String, BgPeriodDispCollection>();
        }
        String curOrgNum2 = null;
        BgCslFormInfo curBgForm = null;
        MbgViewListXMLParser parser = new MbgViewListXMLParser(ctx);
        long st = System.currentTimeMillis();
        long st1 = System.currentTimeMillis();
        HashMap<String, BgCslFormInfo> bgFormMap = new HashMap<String, BgCslFormInfo>();
        BgCslFormCollection col = BgCslViewlistFormServerHelper.getBgForm(ctx, _bgForm, orgNums, BgCslFormHelper.getSelector(), null);
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                bgFormMap.put(col.get(i).getOrgUnit().getNumber(), col.get(i));
            }
        }
        logger.error((Object)("Batch Get BgForm User Time:" + (System.currentTimeMillis() - st)));
        for (String curOrgNum2 : orgNums) {
            st = System.currentTimeMillis();
            if (col == null || col.size() <= 0) continue;
            MbgViewListManager viewListManager = null;
            curBgForm = (BgCslFormInfo)bgFormMap.get(curOrgNum2);
            if (curBgForm == null) continue;
            try {
                viewListManager = parser.parse(curBgForm.getDimensionData());
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            viewListManager.setMemberCacheHelper(memberCacheHelper);
            viewListManager.setParseProperty(false);
            viewListManager.setOrgUnitMap(orgUnitMap);
            viewListManager.setPeriodCache(periodCache);
            this.innerLoadViewListManager(ctx, curBgForm.getId().toString(), curBgForm, orgViewId, viewListManager, curBgForm.getOrgUnit().getId().toString(), false, false);
            res.put(curBgForm.getOrgUnit(), viewListManager);
        }
        logger.error((Object)("End _getViewListManagers:" + (System.currentTimeMillis() - st1)));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealAddOrgDeleForm(BgCslFormInfo bgFormInfo, MbgViewListManager viewManager, Set<String> orgNums) {
        for (int sheetIndex = 0; sheetIndex < viewManager.getSheetManagers().size(); ++sheetIndex) {
            MbgViewListDimensionManager oldDimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager();
            oldDimensionManager.setCloneCells(false);
            Map orgAndRowCols = null;
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView((IBgDimensionManagerBase)oldDimensionManager);
            if (isorgOnPageOrView) {
                return;
            }
            String curOrgNumForDimensionData = bgFormInfo.getOrgUnit().getNumber();
            ArrayList indexLst = new ArrayList();
            HashMap newViewlistObjMap = new HashMap();
            boolean isOrgOnRow = MbgViewListFormServerHelper.isOrgOnRow((MbgViewListDimensionManager)oldDimensionManager);
            try {
                boolean isRowColShowbyTemp = true;
                isRowColShowbyTemp = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).isRowColShowbyTemp();
                orgAndRowCols = isRowColShowbyTemp ? MbgViewListFormServerHelper.getViewListObjectsByTemp((MbgViewListDimensionManager)oldDimensionManager, (Boolean)isOrgOnRow, (String)curOrgNumForDimensionData) : MbgViewListFormServerHelper.getViewListObjectsByOrg((MbgViewListDimensionManager)oldDimensionManager, (Boolean)isOrgOnRow);
                if (orgAndRowCols == null || orgAndRowCols.isEmpty()) continue;
                if (isOrgOnRow) {
                    oldDimensionManager.getRows().clear();
                } else {
                    oldDimensionManager.getColumns().clear();
                }
                for (String viewOrgNum : orgAndRowCols.keySet()) {
                    if (!orgNums.contains(viewOrgNum)) continue;
                    for (int i = 0; i < ((List)orgAndRowCols.get(viewOrgNum)).size(); ++i) {
                        if (isOrgOnRow) {
                            oldDimensionManager.getRows().add(((List)orgAndRowCols.get(viewOrgNum)).get(i));
                            continue;
                        }
                        oldDimensionManager.getColumns().add(((List)orgAndRowCols.get(viewOrgNum)).get(i));
                    }
                }
                continue;
            }
            finally {
                if (oldDimensionManager != null) {
                    oldDimensionManager.setCloneCells(true);
                }
            }
        }
    }

    private void dealNotExistsOrg(MbgViewListManager viewManager, String currOrgNumber, Set<String> notExistFormOrg) {
        for (int sheetIndex = 0; sheetIndex < viewManager.getSheetManagers().size(); ++sheetIndex) {
            MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).getDimensionManager();
            boolean isRowColShowbyTemp = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex)).isRowColShowbyTemp();
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView((IBgDimensionManagerBase)dimensionManager);
            if (isorgOnPageOrView) continue;
            boolean isOnCol = MBgTemplateHelper.isOrgOnCol((IBgDimensionManagerBase)dimensionManager);
            if (isRowColShowbyTemp) {
                Map oldViewlistObjMap = MbgViewListFormServerHelper.getViewListIndexObjectsByTemp((MbgViewListDimensionManager)dimensionManager, (Boolean)(!isOnCol ? 1 : 0), (String)currOrgNumber);
                for (String orgNum : notExistFormOrg) {
                    if (!oldViewlistObjMap.containsKey(orgNum)) continue;
                    Map tMap = (Map)oldViewlistObjMap.get(orgNum);
                    for (IMbgViewListObject vObject : tMap.values()) {
                        if (!isOnCol) {
                            dimensionManager.getRows().remove(vObject);
                            continue;
                        }
                        dimensionManager.getColumns().remove(vObject);
                    }
                }
            } else {
                Map oldOrgAndRowCols = MbgViewListFormServerHelper.getViewListObjectsByOrg((MbgViewListDimensionManager)dimensionManager, (Boolean)(!isOnCol ? 1 : 0));
                for (String orgNum : notExistFormOrg) {
                    if (oldOrgAndRowCols == null || !oldOrgAndRowCols.containsKey(orgNum)) continue;
                    List list = (List)oldOrgAndRowCols.get(orgNum);
                    for (IMbgViewListObject vObject : list) {
                        if (!isOnCol) {
                            dimensionManager.getRows().remove(vObject);
                            continue;
                        }
                        dimensionManager.getColumns().remove(vObject);
                    }
                }
            }
            this.resetObjectIndex(!isOnCol ? dimensionManager.getRows() : dimensionManager.getColumns());
        }
    }

    private void resetObjectIndex(List<IMbgViewListObject> list) {
        if (list != null && !list.isEmpty()) {
            for (int index = 0; index < list.size(); ++index) {
                list.get(index).setIndex(index);
            }
        }
    }

    @Override
    protected Map _addNewViewListFormInfo(Context ctx, String bgFormId, Set newMembers, String addNewPermissionNumber, boolean isOrgOnPageOrView, int curSheetIndex, boolean isUpdateShowTemp, boolean isShowByTemp, boolean canEditOtherAddedBgForm) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId) || newMembers == null || newMembers.isEmpty()) {
            return null;
        }
        MBgTemplateHelper.startLog((String)"Start _addNewViewListFormInfo");
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("result", "addViewOrgSucess");
        SelectorItemCollection sic = BgCslFormHelper.getSelector();
        sic.add("bgCslTemplate.data");
        BgCslFormInfo bgForm = (BgCslFormInfo)BgCslFormFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        String orgTreeId = bgForm.getOrgTree().getId().toString();
        BgCslTemplateInfo bgCslTemplateInfo = BgCslTemplateFactory.getLocalInstance(ctx).getBgCslTemplateInfo((IObjectPK)new ObjectUuidPK(bgForm.getBgCslTemplate().getId()));
        MbgViewListXMLParser viewListParser = new MbgViewListXMLParser(ctx);
        String bgTemplateId = bgForm.getBgCslTemplate().getId().toString();
        String bgSchemeId = bgForm.getBgScheme().getId().toString();
        String currencyId = bgForm.getCurrency().getId().toString();
        String bgPeriodId = bgForm.getBgPeriod().getId().toString();
        String bgVersionId = bgForm.getBgVersion().getId().toString();
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        String bgOrgViewId = schemeHelper.getBgOrgViewId();
        MbgViewListManager curViewManager = null;
        try {
            curViewManager = (MbgViewListManager)bgForm.getView(ctx, bgForm.getBgScheme());
        }
        catch (Exception exception) {
            logger.error((Object)"", (Throwable)exception);
        }
        BgDimensionMember member22 = null;
        HashSet<String> orgUnitNumbers = new HashSet<String>();
        HashSet<String> bgOrgLongNums = new HashSet<String>();
        for (BgDimensionMember member22 : newMembers) {
            orgUnitNumbers.add(member22.getNumber());
            bgOrgLongNums.add(member22.getSortValue().toString());
        }
        Map<String, OrgUnitInfo> orgMap = this.getOrgMap(ctx, orgUnitNumbers, orgTreeId);
        MBgTemplateHelper.logTime((String)"End getOrgMap");
        Map<Object, Object> bgForms = new HashMap();
        HashMap<String, BgCslFormInfo> newFormMap = new HashMap<String, BgCslFormInfo>();
        HashMap<String, BgCslFormInfo> successAddBgForms = new HashMap<String, BgCslFormInfo>();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet res = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            MbgViewListManager tempManager;
            boolean isDiff;
            conn = this.getConnection(ctx);
            bgForms = this.getBgFormMap(ctx, bgForm, orgUnitNumbers);
            MBgTemplateHelper.logTime((String)"End getBgFormMap");
            String orgUnitId = null;
            for (BgCslFormInfo bgCslFormInfo : bgForms.values()) {
                orgUnitId = bgCslFormInfo.getOrgUnit().getId().toString();
                if (bgCslFormInfo.getId() != null) {
                    orgMap.remove(orgUnitId);
                    if (!orgUnitNumbers.contains(bgCslFormInfo.getOrgUnit().getNumber())) continue;
                    successAddBgForms.put(bgCslFormInfo.getOrgUnit().getNumber(), bgCslFormInfo);
                    continue;
                }
                if (!orgMap.containsKey(orgUnitId)) continue;
                this.setBgFormInfo(ctx, bgForm, currencyId, bgPeriodId, bgVersionId, null, null, bgCslFormInfo);
                if (bgCslFormInfo.getId() == null) {
                    newFormMap.put(orgUnitId, bgCslFormInfo);
                    bgCslFormInfo.setId(BOSUuid.create((BOSObjectType)bgCslFormInfo.getBOSType()));
                }
                if (orgUnitNumbers.contains(bgCslFormInfo.getOrgUnit().getNumber())) {
                    successAddBgForms.put(bgCslFormInfo.getOrgUnit().getNumber(), bgCslFormInfo);
                }
                orgMap.remove(orgUnitId);
            }
            HashMap<String, FullOrgUnitInfo> layoutDiff = new HashMap<String, FullOrgUnitInfo>();
            if (!newFormMap.isEmpty() && (isDiff = DimensionCommonHelper.isDifference((IMbgViewBase)curViewManager, (IMbgViewBase)(tempManager = viewListParser.parse(bgCslTemplateInfo.getDimensionData())), (int)curSheetIndex))) {
                for (BgCslFormInfo bgCslFormInfo : newFormMap.values()) {
                    layoutDiff.put(bgCslFormInfo.getOrgUnit().getNumber(), bgCslFormInfo.getOrgUnit());
                }
                newFormMap.clear();
            }
            MBgTemplateHelper.logTime((String)"Start checkAddNewPermission");
            this.checkAddNewPermission(ctx, addNewPermissionNumber, result, newFormMap, "addViewOrgNoPermission");
            MBgTemplateHelper.logTime((String)"End checkAddNewPermission");
            StringBuffer detail = new StringBuffer();
            ArrayList<BgCslFormInfo> newList = new ArrayList<BgCslFormInfo>(newFormMap.values());
            HashMap<String, FullOrgUnitInfo> noExists = new HashMap<String, FullOrgUnitInfo>();
            for (int i = 0; i < newList.size(); ++i) {
                BgCslFormInfo bgCslFormInfo = (BgCslFormInfo)newList.get(i);
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)bgCslFormInfo, (String)bgCslFormInfo.getOrgUnit().getId().toString(), (String)"sourceType", (String)"number", (boolean)false);
                if (bgCslFormInfo.getNumber() == null) {
                    bgCslFormInfo.setNumber(bgForm.getNumber());
                }
                if (canEditOtherAddedBgForm && !bgCslTemplateInfo.getTemplateStatus().equals((Object)BgTemplateStatusEnum.CANCEL)) continue;
                noExists.put(bgCslFormInfo.getOrgUnit().getNumber(), bgCslFormInfo.getOrgUnit());
            }
            if (!canEditOtherAddedBgForm || bgCslTemplateInfo.getTemplateStatus().equals((Object)BgTemplateStatusEnum.CANCEL)) {
                newList.clear();
                newFormMap.clear();
            }
            if (!noExists.isEmpty()) {
                result.put("noExists", noExists);
            }
            MBgTemplateHelper.logTime((String)"End applyNumber");
            List<BgCslFormInfo> addNewList = this.batchAddNewView(ctx, newList, bgForm);
            AttachmentServerManager attachmentServerManager = AttachmentManagerFactory.getServerManager((Context)ctx);
            for (BgCslFormInfo bgform : newList) {
                BgNFSHelper.copyBizAttachmentFiles((AttachmentServerManager)attachmentServerManager, (IDimDataQuery)bgform, null, null);
            }
            MBgTemplateHelper.logTime((String)"End batchAddNewView");
            if (newFormMap.size() != newList.size()) {
                HashMap<String, FullOrgUnitInfo> numberDep = new HashMap<String, FullOrgUnitInfo>();
                for (int i = 0; i < newList.size(); ++i) {
                    newFormMap.remove(((BgCslFormInfo)newList.get(i)).getOrgUnit().getId().toString());
                }
                for (BgCslFormInfo bgCslFormInfo : newFormMap.values()) {
                    numberDep.put(bgCslFormInfo.getOrgUnit().getNumber(), bgCslFormInfo.getOrgUnit());
                }
                result.put("addViewOrgNumberDep", numberDep);
            }
            if (!successAddBgForms.isEmpty()) {
                ViewListMemberCacheHelper memberCacheHelper = new ViewListMemberCacheHelper();
                HashMap<String, BgCslFormInfo> bgFormMap = new HashMap<String, BgCslFormInfo>();
                HashSet<String> bgFormIds = new HashSet<String>();
                for (BgCslFormInfo b1 : successAddBgForms.values()) {
                    bgFormIds.add(b1.getId().toString());
                }
                if (addNewList != null && !addNewList.isEmpty()) {
                    for (BgCslFormInfo b1 : addNewList) {
                        bgFormIds.add(b1.getId().toString());
                    }
                }
                String tempIds = null;
                MBgTemplateHelper.startLog((String)"Start _LoadBgFormInfos");
                try {
                    tempIds = BgDBUtils.insertKey((TempTablePool)pool, (Connection)conn, bgFormIds);
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setSelector(BgCslFormHelper.getSelector());
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("Select FID FROM " + tempIds), CompareType.INNER));
                    BgCslFormCollection col = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormCollection(evi);
                    if (col != null && !col.isEmpty()) {
                        for (int i = 0; i < col.size(); ++i) {
                            bgFormMap.put(col.get(i).getId().toString(), col.get(i));
                            if (col.get(i).getOrgUnit() == null || StringUtils.isEmpty((String)col.get(i).getOrgUnit().getNumber())) continue;
                            successAddBgForms.put(col.get(i).getOrgUnit().getNumber(), col.get(i));
                        }
                    }
                    MBgTemplateHelper.logTime((String)"End One getBgFormInfos");
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                finally {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempIds);
                }
                Map<String, OrgUnitInfo> orgUnitMap = BgCslViewlistFormServerHelper.queryBgViewOrgUnit(ctx, null, bgForm, bgOrgViewId, false, false, bgForm.getOrgUnit().getId().toString(), false, orgUnitNumbers);
                HashMap<String, MbgViewListManager> successFromViews = new HashMap<String, MbgViewListManager>();
                MbgViewListXMLParser parser = new MbgViewListXMLParser(ctx);
                HashSet addOrgNumbers = new HashSet(successAddBgForms.keySet());
                for (String orgNumber : addOrgNumbers) {
                    bgFormId = ((BgCslFormInfo)successAddBgForms.get(orgNumber)).getId().toString();
                    if (!bgFormMap.containsKey(bgFormId)) continue;
                    BgCslFormInfo _bgForm = (BgCslFormInfo)bgFormMap.get(bgFormId);
                    MbgViewListManager viewManager = (MbgViewListManager)_bgForm.getView(ctx, _bgForm.getBgScheme());
                    if (DimensionCommonHelper.isDifference((IMbgViewBase)curViewManager, (IMbgViewBase)viewManager, (int)curSheetIndex)) {
                        layoutDiff.put(orgNumber, _bgForm.getOrgUnit());
                        successAddBgForms.remove(orgNumber);
                        continue;
                    }
                    viewManager.setMemberCacheHelper(memberCacheHelper);
                    viewManager.setOrgUnitMap(orgUnitMap);
                    Map otherMap = this._getInitBgViewDimensionInfo(ctx, viewManager, _bgForm.getId().toString(), _bgForm.getOrgTree().toString(), _bgForm.getOrgUnit().getId().toString(), false, false);
                    MBgTemplateHelper.logTime((String)"End One getInitBgViewDimensionInfo");
                    BgCslViewListFormFacadeControllerBean.additionalForViewListManager(ctx, _bgForm, otherMap, viewManager);
                    MBgTemplateHelper.logTime((String)"End One additionalForViewListManager");
                    successFromViews.put(orgNumber, viewManager);
                }
                result.put(MbgViewListDescriptionHelper.successFromViews, successFromViews);
            }
            MBgTemplateHelper.logTime((String)"End _getInitBgViewDimensionInfo");
            if (!layoutDiff.isEmpty()) {
                result.put("addViewOrgLayoutDiff", layoutDiff);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(res, pstmt, (Connection)conn);
        }
        return result;
    }

    private Map<String, OrgUnitInfo> getOrgMap(Context ctx, Set orgUnitNumbers, String orgTreeId) throws BOSException {
        HashMap<String, OrgUnitInfo> orgMap = new HashMap<String, OrgUnitInfo>();
        if (orgUnitNumbers == null || orgUnitNumbers.isEmpty() || StringUtils.isEmpty((String)orgTreeId)) {
            return orgMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("cu.id");
        evi.getSelector().add("cu.name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("select FUNITID from t_org_structure where FTREEID  = '" + orgTreeId + "' "), CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)orgUnitNumbers, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isGrouping", (Object)Boolean.TRUE, CompareType.EQUALS));
        OrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            orgMap.put(col.get(i).getId().toString(), col.get(i));
        }
        return orgMap;
    }

    private void setBgFormInfo(Context ctx, BgCslFormInfo bgForm, String currencyId, String bgPeriodId, String bgVersionId, String bgFormNumber, String bgFormName, BgCslFormInfo b) {
        if (b.getId() == null) {
            b.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            b.setCreateTime(new Timestamp(System.currentTimeMillis()));
            b.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            b.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            b.setState(BgCslFormStateEnum.EDIT);
        }
    }

    protected void checkAddNewPermission(Context ctx, String addNewPermissionNumber, Map result, Map<String, BgCslFormInfo> newFormMap, String permMsgKey) throws BOSException, EASBizException {
        if (newFormMap.isEmpty()) {
            return;
        }
        ArrayList<ObjectUuidPK> orgPks = new ArrayList<ObjectUuidPK>();
        for (BgCslFormInfo b : newFormMap.values()) {
            orgPks.add(new ObjectUuidPK(b.getOrgUnit().getId()));
        }
        Set hasPermOrgIds = null;
        if (!orgPks.isEmpty()) {
            hasPermOrgIds = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPks.toArray(new IObjectPK[1]), addNewPermissionNumber);
        }
        if (hasPermOrgIds == null || hasPermOrgIds.size() != newFormMap.size()) {
            HashMap<String, FullOrgUnitInfo> noPermission = new HashMap<String, FullOrgUnitInfo>();
            Iterator<BgCslFormInfo> itForm = newFormMap.values().iterator();
            while (itForm.hasNext()) {
                BgCslFormInfo b;
                b = itForm.next();
                if (hasPermOrgIds != null && hasPermOrgIds.contains(b.getOrgUnit().getId().toString())) continue;
                itForm.remove();
                noPermission.put(b.getOrgUnit().getNumber(), b.getOrgUnit());
            }
            if (!noPermission.isEmpty()) {
                result.put(permMsgKey, noPermission);
            }
        }
    }

    public Map<String, BgCslFormInfo> getBgFormMap(Context ctx, BgCslFormInfo bgFormInfo, Set<String> orgUnitNumbers) throws BOSException {
        HashMap<String, BgCslFormInfo> bgFormsMap = new HashMap<String, BgCslFormInfo>();
        String orgTreeId = bgFormInfo.getOrgTree().getId().toString();
        HashSet<String> orgIds = new HashSet<String>();
        String orgId2 = null;
        BgCslFormInfo info = null;
        OrgUnitInfo orgInfo = null;
        Map<String, OrgUnitInfo> orgMap = this.getOrgMap(ctx, orgUnitNumbers, orgTreeId);
        if (orgMap != null && !orgMap.isEmpty()) {
            orgIds.addAll(orgMap.keySet());
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(BgCslFormHelper.getSelector());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)bgFormInfo.getOrgTree().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgFormInfo.getBgScheme().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIds, CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgCslTemplate.id", (Object)bgFormInfo.getBgCslTemplate().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgFormInfo.getBgPeriod().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgFormInfo.getBgVersion().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)bgFormInfo.getCurrency().getId().toString(), CompareType.EQUALS));
            BgCslFormCollection colls = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormCollection(evi);
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    bgFormsMap.put(colls.get(i).getOrgUnit().getId().toString(), colls.get(i));
                }
            }
            for (String orgId2 : orgMap.keySet()) {
                orgInfo = orgMap.get(orgId2);
                if (bgFormsMap.containsKey(orgId2)) continue;
                try {
                    info = bgFormInfo.deepclone();
                    info.setId(null);
                    info.setOrgUnit(orgInfo.castToFullOrgUnitInfo());
                    bgFormsMap.put(orgId2, info);
                }
                catch (BgException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        return bgFormsMap;
    }

    public List<BgCslFormInfo> batchAddNewView(Context ctx, List<BgCslFormInfo> newList, BgCslFormInfo bgFormInfo) throws EASBizException, BOSException {
        ArrayList<BgCslFormInfo> addNewList = new ArrayList<BgCslFormInfo>();
        if (newList != null && !newList.isEmpty() && bgFormInfo != null) {
            Object[] orgUnits = new Object[newList.size()];
            for (int i = 0; i < newList.size(); ++i) {
                orgUnits[i] = newList.get(i).getOrgUnit();
            }
            Object[] templates = BgCslCommonHelper.getValues(bgFormInfo.getBgCslTemplate());
            Object[] versions = BgCslCommonHelper.getValues(bgFormInfo.getBgVersion());
            Object[] periods = BgCslCommonHelper.getValues(bgFormInfo.getBgPeriod());
            Object obj = BgCslFormFactory.getLocalInstance(ctx).batchAddCslFrom(orgUnits, templates, versions, periods, bgFormInfo.getOrgTree(), newList.get(0));
            if (obj != null) {
                if (obj instanceof BgCslFormInfo) {
                    addNewList.add((BgCslFormInfo)obj);
                } else if (obj instanceof Object[] && ((Object[])obj)[2] instanceof List) {
                    addNewList.addAll((List)((Object[])obj)[2]);
                }
            }
        }
        return addNewList;
    }
}

