/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormFactory;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperFacadeFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperFactory;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgCslWorkTableFacadeControllerBean;
import com.kingdee.eas.ma.bgcsl.common.BgCslFormHelper;
import com.kingdee.eas.ma.bgcsl.utils.BgCslAdjRptReportPropertyAdapter;
import com.kingdee.eas.ma.bgcsl.utils.BgCslRptReportPropertyAdapter;
import com.kingdee.eas.ma.bgcsl.utils.BgCslWorkTableHelper;
import com.kingdee.eas.ma.bgcsl.utils.MbgWorkRptReportPropertyAdapter;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionDataUtils;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.CalculateContext;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCslWorkTableFacadeControllerBean
extends AbstractBgCslWorkTableFacadeControllerBean {
    private static final long serialVersionUID = -7122764839014722707L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgCslWorkTableFacadeControllerBean");

    private String getOrgTreeId(Map parameter) {
        return (String)parameter.get("ORGTREE_INFO");
    }

    private String getOrgUitId(Map parameter) {
        return (String)parameter.get("ORGTREEUNIT_ID");
    }

    private String[] getTemplateType(Map parameter) {
        return (String[])parameter.get("CSL_TEMPLATETYPE");
    }

    private Boolean[] getReportsStatus(Map parameter) {
        return (Boolean[])parameter.get("REPORTSSTATUS");
    }

    private String[] getBgPeriod(Map parameter) {
        return (String[])parameter.get("CSL_BGPERIOD");
    }

    private String[] getBgVersion(Map parameter) {
        return (String[])parameter.get("CSL_BGVERSION");
    }

    private String[] getTemplateName(Map parameter) {
        return (String[])parameter.get("CSL_TEMPLATENAME");
    }

    private String getCurrency(Map parameter) {
        return (String)parameter.get("CSL_CURRENCY");
    }

    private String[] getBgScheme(Map parameter) {
        return (String[])parameter.get("CSL_BGSCHEME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getReports(Context ctx, Map parameter) throws BOSException {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        ArrayList reportsList = new ArrayList();
        Boolean[] formStatus = this.getReportsStatus(parameter);
        StringBuffer sql = new StringBuffer();
        if (formStatus[1].booleanValue() || formStatus[2].booleanValue() || formStatus[3].booleanValue() || formStatus[4].booleanValue()) {
            sql.append(this.getReportsSql(ctx, parameter));
        }
        if (formStatus[0].booleanValue()) {
            if (sql.length() > 0) {
                sql.append(" union all ");
            }
            sql.append(this.getTemplatesSql(ctx, parameter));
        }
        if (sql.length() > 0) {
            sql.insert(0, "select * from (").append(") tempAndFormTable order by tempAndFormTable.isform desc,tempAndFormTable.sortType,tempAndFormTable.fnumber,tempAndFormTable.templateNumber asc ");
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                IRowSetMetaData rowSetMeta = rs.getRowSetMetaData();
                int columnCount = rowSetMeta.getColumnCount();
                String columnName = null;
                HashMap<String, Object> mapInfo = null;
                while (rs.next()) {
                    mapInfo = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        columnName = rowSetMeta.getColumnName(i);
                        mapInfo.put(columnName.toLowerCase(), rs.getObject(columnName));
                    }
                    mapInfo.put("select", false);
                    reportsList.add(mapInfo);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        logger.error((Object)("BgCslWorkTableFacadeControllerBean _getReports reportsList.size : " + reportsList.size()));
        return reportsList;
    }

    protected String getTemplatesSql(Context ctx, Map parameter) {
        String orgTree = this.getOrgTreeId(parameter);
        String orgUnit = this.getOrgUitId(parameter);
        String[] bgPeriod = this.getBgPeriod(parameter);
        String[] bgVersion = this.getBgVersion(parameter);
        Object[] templateType = this.getTemplateType(parameter);
        String[] templateName = this.getTemplateName(parameter);
        String currency = this.getCurrency(parameter);
        String[] bgSchemeId = this.getBgScheme(parameter);
        HashSet templateTypeSet = new HashSet(Arrays.asList((Object[])templateType));
        StringBuffer sql = new StringBuffer();
        if (templateTypeSet.contains("csladjtemplate")) {
            sql.append(" select BgCslAdjTemplate.fid as id,  NULL as fname, NULL as fnumber,BgCslAdjTemplate.fname as ftemplateName,to_int(0) as fstate, 'a' as sortType, BgCslAdjTemplate.fnumber as templateNumber,");
            sql.append(" LASTUPDATEUSER.FName_l2 as fLASTUPDATEUSER, BgCslAdjTemplate.FLASTUPDATETIME as flastUpdateTime, ");
            sql.append(" BgCslAdjTemplate.FCREATETIME as FCREATETIME, creator.FNAME_L2 as fcreateName, ");
            sql.append(" BgCslAdjTemplate.fformtype as fformtype, ");
            sql.append(" 'BgCslAdjtemplateTypeInfo' as fformTypeInfo, ");
            sql.append(" NULL AS fauditTime, ");
            sql.append(" NULL AS fauditor, ");
            sql.append(" NULL AS fbgVersion, NULL AS fbgPeriod, NULL as flevel,");
            sql.append(" NULL as fcurrencyId, ");
            sql.append(" NULL AS fORGUNITid, ");
            sql.append(" BGSPECIALITEMS.FDimensionName AS fdimensionMember, ");
            sql.append(" 'csladjtemplate' as ftemplatetype, ");
            sql.append(" 0 as isform ");
            sql.append(" from T_MBG_BgCslAdjTemplate as BgCslAdjTemplate ");
            sql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON BgCslAdjTemplate.FLastUpdateUserID = LASTUPDATEUSER.FID ");
            sql.append(" INNER JOIN T_PM_USER AS creator ON BgCslAdjTemplate.FCREATORID = creator.FID ");
            sql.append(" left outer JOIN T_MBG_BgCslSpecialItems AS BGSPECIALITEMS ON BGCSLADJTEMPLATE.FID = BGSPECIALITEMS.FBgAdjTemplateID ");
            sql.append(" left outer join ( SELECT form.FBgCslTemplateID FROM t_mbg_bgcsladjform as form where form.fbgperiodid in ('").append(BgCslWorkTableHelper.getArrayToString(bgPeriod)).append("')");
            sql.append(" and form.fcurrencyid='").append(currency).append("' and form.fbgversionid in ('").append(BgCslWorkTableHelper.getArrayToString(bgVersion)).append("')");
            sql.append(" and form.fbgschemeid='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId));
            sql.append("' and form.forgtreeid='").append(orgTree).append("' and form.forgunitid='").append(orgUnit).append("') ");
            sql.append(" as tempAdj on BgCslAdjTemplate.fid = tempAdj.FBgCslTemplateID where tempAdj.FBgCslTemplateID is null ");
            sql.append(" and ");
            if (templateName != null && templateName.length > 0) {
                sql.append(" BgCslAdjTemplate.fid in ('").append(BgCslWorkTableHelper.getArrayToString(templateName)).append("') and");
            }
            sql.append(" BgCslAdjTemplate.FOrgTreeID='").append(orgTree).append("'");
            sql.append(" and BgCslAdjTemplate.FOrgUnitID = '").append(orgUnit).append("'");
            sql.append(" and BgCslAdjTemplate.FBgSchemeID='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId)).append("'");
        }
        if (templateTypeSet.contains("worktemplate")) {
            if (sql.length() > 0) {
                sql.append(" union all ");
            }
            sql.append(" select bgnworktemplate.fid as id,  NULL as fname, NULL as fnumber,bgnworktemplate.fname as ftemplateName,to_int(0) as fstate, 'b' as sortType,  bgnworktemplate.fnumber as templateNumber,");
            sql.append(" LASTUPDATEUSER.FName_l2 as fLASTUPDATEUSER, bgnworktemplate.FLASTUPDATETIME as flastUpdateTime, ");
            sql.append(" bgnworktemplate.FCREATETIME as FCREATETIME, creator.FNAME_L2 as fcreateName, ");
            sql.append(" NULL AS fformtype, ");
            sql.append(" NULL AS fformtypeinfo, ");
            sql.append(" NULL AS fauditTime, ");
            sql.append(" NULL AS fauditor, ");
            sql.append(" NULL AS fbgVersion, NULL AS fbgPeriod, NULL as flevel, ");
            sql.append(" NULL as fcurrencyId, ");
            sql.append(" NULL AS fORGUNITid, ");
            sql.append(" NULL AS fdimensionMember, ");
            sql.append(" 'worktemplate' as ftemplatetype, ");
            sql.append(" 0 as isform ");
            sql.append(" from T_MBG_BgNWorkTemplate as bgnworktemplate ");
            sql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON bgnworktemplate.FLastUpdateUserID = LASTUPDATEUSER.FID ");
            sql.append(" INNER JOIN T_PM_USER AS creator ON bgnworktemplate.FCREATORID = creator.FID ");
            sql.append(" left outer join ( SELECT form.fworktemplateid   FROM t_mbg_mbgworkpaper as form where form.fbgperiodid in ('").append(BgCslWorkTableHelper.getArrayToString(bgPeriod)).append("')");
            sql.append(" and  form.fcurrencyid='").append(currency).append("' and form.fversionid in ('").append(BgCslWorkTableHelper.getArrayToString(bgVersion)).append("')");
            sql.append(" and  form.fbgschemeid='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId));
            sql.append("' and form.forgtreeid='").append(orgTree).append("' and form.forgunitid='").append(orgUnit).append("') ");
            sql.append(" as tempWork on bgnworktemplate.fid = tempWork.fworktemplateid where tempWork.fworktemplateid is null ");
            sql.append(" and ");
            if (templateName != null && templateName.length > 0) {
                sql.append(" bgnworktemplate.fid in ('").append(BgCslWorkTableHelper.getArrayToString(templateName)).append("') and ");
            }
            sql.append(" bgnworktemplate.FBgSchemeID='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId)).append("' and ");
            sql.append(" bgnworktemplate.FOrgTreeId='").append(orgTree).append("'");
        }
        if (templateTypeSet.contains("csltemplate")) {
            if (sql.length() > 0) {
                sql.append(" union all ");
            }
            sql.append(" select bgcsltemplate.fid as id, NULL as fname, NULL as fnumber,bgcsltemplate.fname as ftemplateName,to_int(0) as fstate, 'c' as sortType,  bgcsltemplate.fnumber as templateNumber,");
            sql.append(" LASTUPDATEUSER.FName_l2 as fLASTUPDATEUSER, bgcsltemplate.FLASTUPDATETIME as flastUpdateTime, ");
            sql.append(" bgcsltemplate.FCREATETIME as FCREATETIME, creator.FNAME_L2 as fcreateName, ");
            sql.append(" bgcsltemplate.FFORMtype as fformType, ");
            sql.append(" 'bgcsltemplateformtypeinfo' as fformTypeInfo, ");
            sql.append(" NULL AS fauditTime, ");
            sql.append(" NULL AS fauditor, ");
            sql.append(" NULL AS fbgVersion, NULL AS fbgPeriod, NULL as flevel, ");
            sql.append(" NULL as fcurrencyId, ");
            sql.append(" NULL AS fORGUNITid, ");
            sql.append(" BGSPECIALITEMS.FDimensionName AS fdimensionMember, ");
            sql.append(" 'csltemplate' as ftemplatetype, ");
            sql.append(" 0 as isform ");
            sql.append(" from t_mbg_bgcsltemplate as bgcsltemplate ");
            sql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON bgcsltemplate.FLastUpdateUserID = LASTUPDATEUSER.FID ");
            sql.append(" INNER JOIN T_PM_USER AS creator ON bgcsltemplate.FCREATORID = creator.FID ");
            sql.append(" left outer join T_MBG_BgCslSpecialItems AS BGSPECIALITEMS ON BGCSLTEMPLATE.FID = BGSPECIALITEMS.FBgTemplateID ");
            sql.append(" left outer join ( SELECT form.fbgcsltemplateid   FROM T_MBG_BGCSLFORM as form where form.fbgperiodid in ('").append(BgCslWorkTableHelper.getArrayToString(bgPeriod)).append("')");
            sql.append(" and form.fcurrencyid='").append(currency).append("' and form.fbgversionid in ('").append(BgCslWorkTableHelper.getArrayToString(bgVersion)).append("')");
            sql.append(" and form.fbgschemeid='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId));
            sql.append("' and form.forgtreeid='").append(orgTree).append("' and form.forgunitid='").append(orgUnit).append("') ");
            sql.append(" as tempCsl on bgcsltemplate.fid = tempCsl.fbgcsltemplateid where tempCsl.fbgcsltemplateid is null ");
            sql.append(" and ");
            if (templateName != null && templateName.length > 0) {
                sql.append(" bgcsltemplate.fid in ('").append(BgCslWorkTableHelper.getArrayToString(templateName)).append("')  and");
            }
            sql.append(" bgcsltemplate.FBgSchemeID='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId)).append("' and");
            sql.append(" bgcsltemplate.FOrgTreeID='").append(orgTree).append("'");
        }
        logger.error((Object)("BgCslWorkTableFacadeControllerBean _getReports getTemplatesSql : " + sql.toString()));
        return sql.toString();
    }

    protected String getReportsSql(Context ctx, Map parameter) {
        String orgTree = this.getOrgTreeId(parameter);
        String orgUnit = this.getOrgUitId(parameter);
        String[] bgPeriod = this.getBgPeriod(parameter);
        String[] bgVersion = this.getBgVersion(parameter);
        Object[] templateType = this.getTemplateType(parameter);
        String[] templateName = this.getTemplateName(parameter);
        Boolean[] formStatus = this.getReportsStatus(parameter);
        String currency = this.getCurrency(parameter);
        String[] bgSchemeId = this.getBgScheme(parameter);
        HashSet templateTypeSet = new HashSet(Arrays.asList((Object[])templateType));
        StringBuffer sql = new StringBuffer();
        if (templateTypeSet.contains("csladjtemplate")) {
            sql.append(" select bgcsladjform.fid as id,bgcsladjform.fname as fname,bgcsladjform.fnumber fnumber,BgCslAdjTemplate.fname as ftemplateName, bgcsladjform.fstate as fstate, 'a' as sortType,NULL AS templateNumber,");
            sql.append(" LASTUPDATEUSER.FName_l2 as fLASTUPDATEUSER,bgcsladjform.FLASTUPDATETIME as flastUpdateTime, ");
            sql.append(" bgcsladjform.FCreateTime as FCREATETIME,creator.fname_l2 as fcreatename, ");
            sql.append(" BgCslAdjTemplate.fformType as fformType, ");
            sql.append(" 'csladjformtypeinfo' as fFormTypeInfo,");
            sql.append(" bgcsladjform.FAuditedTime as fauditTime,");
            sql.append(" auditor.fname_l2 as fauditor,");
            sql.append(" BGVERSION.FName_l2 AS fbgVersion,  BGPERIOD.FName_L2||'('||substring(BGPERIOD.FNUMBER,0,4)||')' AS fbgPeriod, BGPERIOD.flevel as flevel, ");
            sql.append(" CURRENCY.fid as fcurrencyId, ");
            sql.append(" ORGUNIT.FID AS fORGUNITid, ");
            sql.append(" BGSPECIALITEMS.FMemberDisplayName as fdimensionMember, ");
            sql.append(" 'csladjtemplate' as ftemplateType, ");
            sql.append(" 1 as isform ");
            sql.append(" from t_mbg_bgcsladjform as bgcsladjform ");
            sql.append(" INNER JOIN T_MBG_BgCslAdjTemplate AS BgCslAdjTemplate ON bgcsladjform.FBgCslTemplateID = BgCslAdjTemplate.FID ");
            sql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON bgcsladjform.FLastUpdateUserID = LASTUPDATEUSER.FID ");
            sql.append(" INNER JOIN T_PM_USER AS creator ON bgcsladjform.FCREATORID=creator.fid ");
            sql.append(" left outer join t_pm_user as auditor on bgcsladjform.fauditorid=auditor.fid ");
            sql.append(" INNER JOIN T_MBG_BgVersion AS BGVERSION ON bgcsladjform.FBgVersionID = BGVERSION.fid ");
            sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ON bgcsladjform.FCurrencyID = CURRENCY.FID ");
            sql.append(" INNER JOIN T_MBG_BgPeriod AS BGPERIOD ON bgcsladjform.FBgPeriodID = BGPERIOD.FID ");
            sql.append(" INNER JOIN T_ORG_BaseUnit AS ORGUNIT ON bgcsladjform.FOrgUnitID = ORGUNIT.FID ");
            sql.append(" left outer join T_MBG_BgCslSpecialItems AS BGSPECIALITEMS ON bgcsladjform.FID = BGSPECIALITEMS.FBgAdjFormID");
            sql.append(" where bgcsladjform.FBgVersionID in ('").append(BgCslWorkTableHelper.getArrayToString(bgVersion)).append("') and bgcsladjform.FBgPeriodID in ('").append(BgCslWorkTableHelper.getArrayToString(bgPeriod)).append("')");
            sql.append(" and bgcsladjform.FCurrencyID='").append(currency.toString()).append("'");
            if (templateName != null && templateName.length > 0) {
                sql.append(" and bgcsladjform.FBgCslTemplateID in ('").append(BgCslWorkTableHelper.getArrayToString(templateName)).append("') ");
            }
            sql.append(" and bgcsladjform.forgunitid = '").append(orgUnit).append("'");
            sql.append(" and fstate in (").append(BgCslWorkTableHelper.getFormStatusFilter(formStatus)).append(")");
            sql.append(" and bgcsladjform.FBgSchemeID='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId)).append("'");
            sql.append(" and bgcsladjform.FOrgTreeID='").append(orgTree).append("'");
        }
        if (templateTypeSet.contains("worktemplate")) {
            if (sql.length() > 0) {
                sql.append(" union all ");
            }
            sql.append(" select mbgworkpaper.fid as id,mbgworkpaper.fname as fname,mbgworkpaper.fnumber as fnumber,BGNWORKTEMPLATE.fname as ftemplateName, mbgworkpaper.fstate as fstate, 'b' as sortType, NULL AS templateNumber,");
            sql.append(" LASTUPDATEUSER.FName_l2 as fLASTUPDATEUSER,MBGWORKPAPER.FLASTUPDATETIME as flastUpdateTime, ");
            sql.append(" mbgworkpaper.FCreateTime as FCREATETIME,creator.fname_l2 as fcreatename, ");
            sql.append(" NULL as fformType, ");
            sql.append(" NULL AS fFormTypeInfo,");
            sql.append(" mbgworkpaper.FAuditedTime as fauditTime,");
            sql.append(" auditor.fname_l2 as fauditor,");
            sql.append(" BGVERSION.FName_l2 AS fbgVersion,  BGPERIOD.FName_L2||'('||substring(BGPERIOD.FNUMBER,0,4)||')' AS fbgPeriod, BGPERIOD.flevel as flevel, ");
            sql.append(" CURRENCY.fid as fcurrencyId, ");
            sql.append(" ORGUNIT.FID AS fORGUNITid, ");
            sql.append(" NULL as fdimensionMember, ");
            sql.append(" 'worktemplate' as ftemplateType, ");
            sql.append(" 1 as isform ");
            sql.append(" from t_mbg_mbgworkpaper as mbgworkpaper ");
            sql.append(" INNER JOIN T_MBG_BgNWorkTemplate AS BGNWORKTEMPLATE ON MBGWORKPAPER.FWorkTemplateID = BGNWORKTEMPLATE.FID ");
            sql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON MBGWORKPAPER.FLastUpdateUserID = LASTUPDATEUSER.FID ");
            sql.append(" INNER JOIN T_PM_USER AS creator ON mbgworkpaper.FCREATORID=creator.fid ");
            sql.append(" left outer join t_pm_user as auditor on mbgworkpaper.fauditorid=auditor.fid ");
            sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ON mbgworkpaper.FCurrencyID = CURRENCY.FID ");
            sql.append(" INNER JOIN T_MBG_BgVersion AS BGVERSION ON mbgworkpaper.FVersionID = BGVERSION.fid ");
            sql.append(" INNER JOIN T_MBG_BgPeriod AS BGPERIOD ON mbgworkpaper.FBgPeriodID = BGPERIOD.FID");
            sql.append(" INNER JOIN T_ORG_BaseUnit AS ORGUNIT ON mbgworkpaper.FOrgUnitID = ORGUNIT.FID ");
            sql.append(" where mbgworkpaper.FVersionID in ('").append(BgCslWorkTableHelper.getArrayToString(bgVersion)).append("') and mbgworkpaper.FBgPeriodID in ('").append(BgCslWorkTableHelper.getArrayToString(bgPeriod)).append("')");
            sql.append(" and mbgworkpaper.FCurrencyID='").append(currency).append("'");
            if (templateName != null && templateName.length > 0) {
                sql.append(" and mbgworkpaper.FWorkTemplateID in ('").append(BgCslWorkTableHelper.getArrayToString(templateName)).append("') ");
            }
            sql.append(" and mbgworkpaper.forgunitid = '").append(orgUnit).append("'");
            sql.append(" and fstate in (").append(BgCslWorkTableHelper.getFormStatusFilter(formStatus)).append(")");
            sql.append(" and mbgworkpaper.FBgSchemeID='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId)).append("'");
            sql.append(" and mbgworkpaper.FOrgTreeID='").append(orgTree).append("'");
        }
        if (templateTypeSet.contains("csltemplate")) {
            if (sql.length() > 0) {
                sql.append(" union all ");
            }
            sql.append(" SELECT BGCSLFORM.fid as id, BGCSLFORM.FNAME, BGCSLFORM.FNUMBER as fnumber,BgCslTemplate.fname as ftemplateName, BGCSLFORM.FSTATE as fstate, 'c' as sortType, NULL AS templateNumber,");
            sql.append(" LASTUPDATEUSER.FName_l2 as fLASTUPDATEUSER, BGCSLFORM.FLASTUPDATETIME as flastUpdateTime, ");
            sql.append(" BGCSLFORM.FCREATETIME as FCREATETIME, creator.FNAME_L2 as fcreateName, ");
            sql.append(" BgCslTemplate.fformType as fformType, ");
            sql.append(" 'bgcslformTypeinfo' as fformTypeInfo,");
            sql.append(" BGCSLFORM.FAuditedTime AS fauditTime, ");
            sql.append(" AUDITOR.FName_l2 AS fauditor, ");
            sql.append(" BGVERSION.FName_l2 AS fbgVersion,  BGPERIOD.FName_L2||'('||substring(BGPERIOD.FNUMBER,0,4)||')' AS fbgPeriod, BGPERIOD.flevel as flevel, ");
            sql.append(" CURRENCY.fid as fcurrencyId, ");
            sql.append(" ORGUNIT.FID AS fORGUNITid, ");
            sql.append(" BGSPECIALITEMS.FMemberDisplayName as fdimensionMember, ");
            sql.append(" 'csltemplate' as ftemplatetype, ");
            sql.append(" 1 as isform ");
            sql.append(" FROM T_MBG_BGCSLFORM AS BGCSLFORM ");
            sql.append(" inner join T_MBG_BgCslTemplate as BgCslTemplate on BGCSLFORM.fbgcsltemplateid=BgCslTemplate.fid ");
            sql.append(" LEFT OUTER JOIN T_PM_User AS LASTUPDATEUSER ON BGCSLFORM.FLastUpdateUserID = LASTUPDATEUSER.FID ");
            sql.append(" INNER JOIN T_PM_USER AS creator ON BGCSLFORM.FCREATORID = creator.FID ");
            sql.append(" LEFT OUTER JOIN T_PM_User AS AUDITOR ON BGCSLFORM.FAuditorID = AUDITOR.FID ");
            sql.append(" INNER JOIN T_BD_Currency AS CURRENCY ON BGCSLFORM.FCurrencyID = CURRENCY.FID ");
            sql.append(" INNER JOIN T_MBG_BgVersion AS BGVERSION ON BGCSLFORM.FBgVersionID = BGVERSION.FID ");
            sql.append(" INNER JOIN T_MBG_BgPeriod AS BGPERIOD ON BGCSLFORM.FBgPeriodID = BGPERIOD.FID ");
            sql.append(" INNER JOIN T_ORG_BaseUnit AS ORGUNIT ON BGCSLFORM.FOrgUnitID = ORGUNIT.FID ");
            sql.append(" LEFT OUTER JOIN T_MBG_BgCslSpecialItems AS BGSPECIALITEMS ON BGCSLFORM.FID = BGSPECIALITEMS.FBgFormId");
            sql.append(" where BGCSLFORM.FBgVersionID in ('").append(BgCslWorkTableHelper.getArrayToString(bgVersion)).append("') and BGCSLFORM.FBgPeriodID in ('").append(BgCslWorkTableHelper.getArrayToString(bgPeriod)).append("') ");
            sql.append(" and BGCSLFORM.FCurrencyID='").append(currency).append("'");
            if (templateName != null && templateName.length > 0) {
                sql.append(" and BGCSLFORM.fbgcsltemplateid in ('").append(BgCslWorkTableHelper.getArrayToString(templateName)).append("') ");
            }
            sql.append(" and BGCSLFORM.FOrgUnitID = '").append(orgUnit).append("'");
            sql.append(" and fstate in  (").append(BgCslWorkTableHelper.getFormStatusFilter(formStatus)).append(")");
            sql.append(" and BGCSLFORM.FBgSchemeID='").append(BgCslWorkTableHelper.getArrayToString(bgSchemeId)).append("'");
            sql.append(" and BGCSLFORM.FOrgTreeID='").append(orgTree).append("'");
        }
        logger.error((Object)("BgCslWorkTableFacadeControllerBean _getReports getReportsSql : " + sql.toString()));
        return sql.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _loadColorScheme(Context ctx) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Integer _state = null;
        String _color = null;
        HashMap<Integer, String> colorScheme = new HashMap<Integer, String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FState, FColor from T_MBG_BgCslWorkColorScheme");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _state = new Integer(rst.getInt(1));
                _color = rst.getString(2);
                colorScheme.put(_state, _color);
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return colorScheme;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveColorScheme(Context ctx, Map colorScheme) throws BOSException, EASBizException {
        if (colorScheme == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Map.Entry _entry2222222 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_MBG_BgCslWorkColorScheme");
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement("insert into T_MBG_BgCslWorkColorScheme (FState, FColor) values(?, ?)");
            for (Map.Entry _entry2222222 : colorScheme.entrySet()) {
                pstmt.setInt(1, (Integer)_entry2222222.getKey());
                pstmt.setString(2, (String)_entry2222222.getValue());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getBgCslFormTemplate(Context ctx, String templateSql) throws BOSException {
        if (templateSql.length() == 0) {
            return null;
        }
        ArrayList templatesList = new ArrayList();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)templateSql.toString());
            IRowSetMetaData rowSetMeta = rs.getRowSetMetaData();
            int columnCount = rowSetMeta.getColumnCount();
            String columnName = null;
            HashMap<String, Object> mapInfo = null;
            while (rs.next()) {
                mapInfo = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    columnName = rowSetMeta.getColumnName(i);
                    mapInfo.put(columnName.toLowerCase(), rs.getObject(columnName));
                }
                mapInfo.put("select", false);
                templatesList.add(mapInfo);
            }
        }
        catch (SQLException exp) {
            try {
                logger.error((Object)exp);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return templatesList;
    }

    @Override
    protected Map _batchAudit(Context ctx, List idList, IObjectValue idea, boolean isReqMutex) throws BOSException, EASBizException {
        if (idList.size() == 0 || idList.isEmpty() || idList == null) {
            return null;
        }
        String bosType = null;
        ArrayList<String> cslAdjForm = new ArrayList<String>();
        ArrayList<String> paperForm = new ArrayList<String>();
        ArrayList<String> cslForm = new ArrayList<String>();
        for (int index = 0; index < idList.size(); ++index) {
            bosType = BOSUuid.read((String)((String)idList.get(index))).getType().toString();
            if ("AD34C4CD".equals(bosType)) {
                cslAdjForm.add((String)idList.get(index));
                continue;
            }
            if ("9E7BD5E2".equals(bosType)) {
                paperForm.add((String)idList.get(index));
                continue;
            }
            if (!"655ADD42".equals(bosType)) continue;
            cslForm.add((String)idList.get(index));
        }
        HashMap resultMap = new HashMap();
        Map adjResult = new HashMap();
        Map cslResult = new HashMap();
        Map paperResult = new HashMap();
        if (!cslAdjForm.isEmpty()) {
            adjResult = BgCslAdjFormFactory.getLocalInstance(ctx).batchAudit(idList, idea, isReqMutex);
        }
        if (!paperForm.isEmpty()) {
            paperResult = MbgWorkPaperFactory.getLocalInstance(ctx).batchAudit(idList, idea, isReqMutex);
        }
        if (!cslForm.isEmpty()) {
            cslResult = BgCslFormFactory.getLocalInstance(ctx).batchAudit(idList, idea, isReqMutex, null);
        }
        resultMap.put("adjResult", adjResult);
        resultMap.put("paperResult", paperResult);
        resultMap.put("cslResult", cslResult);
        return resultMap;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, Map formMap, IObjectValue idea, boolean isReqMutex) throws BOSException, EASBizException {
        if (formMap.size() == 0 || formMap == null) {
            return null;
        }
        HashMap resultMap = new HashMap();
        Map cslAdjResult = new HashMap();
        Map nworkFormResult = new HashMap();
        Map bgcslResult = new HashMap();
        if (formMap.get("bgcslForm") != null) {
            ArrayList cslList = (ArrayList)formMap.get("bgcslForm");
            bgcslResult = BgCslFormFactory.getLocalInstance(ctx).batchUnAudit(cslList, idea, isReqMutex);
        }
        if (formMap.get("bgcslAdjForm") != null) {
            ArrayList adjList = (ArrayList)formMap.get("bgcslAdjForm");
            cslAdjResult = BgCslAdjFormFactory.getLocalInstance(ctx).batchUnAudit(adjList, idea, isReqMutex);
        }
        if (formMap.get("bgNWorkForm") != null) {
            Object logPk = null;
            ArrayList workList = (ArrayList)formMap.get("bgNWorkForm");
            nworkFormResult = MbgWorkPaperFactory.getLocalInstance(ctx).batchUnAudit(workList, idea, isReqMutex);
        }
        resultMap.put("cslAdjResult", cslAdjResult);
        resultMap.put("nworkFormResult", nworkFormResult);
        resultMap.put("bgcslResult", bgcslResult);
        return resultMap;
    }

    @Override
    protected Map _delete(Context ctx, Map idMap) throws BOSException, EASBizException {
        if (idMap.size() == 0 || idMap.isEmpty()) {
            return null;
        }
        ObjectStringPK pk = null;
        HashMap errorMap = new HashMap();
        SelectorItemCollection _sic = new SelectorItemCollection();
        _sic.add("id");
        _sic.add("number");
        _sic.add("name");
        _sic.add("state");
        List adjIdList = new ArrayList();
        adjIdList = (List)idMap.get("bgcslAdjForm");
        if (adjIdList != null) {
            BgCslAdjFormInfo bgCslAdjFormInfo = null;
            int n = adjIdList.size();
            for (int index = 0; index < n; ++index) {
                bgCslAdjFormInfo = BgCslAdjFormFactory.getLocalInstance(ctx).getBgCslAdjFormInfo((IObjectPK)new ObjectUuidPK((String)adjIdList.get(index)), _sic);
                if (1 != bgCslAdjFormInfo.getState().getValue()) {
                    errorMap.put(adjIdList.get(index), new String[]{bgCslAdjFormInfo.getNumber(), bgCslAdjFormInfo.getName()});
                    continue;
                }
                pk = new ObjectStringPK((String)adjIdList.get(index));
                BgCslAdjFormFactory.getLocalInstance(ctx).delete((IObjectPK)pk);
            }
        }
        List nworkIdList = new ArrayList();
        nworkIdList = (List)idMap.get("bgNWorkForm");
        if (nworkIdList != null) {
            MbgWorkPaperInfo mbgWorkFormInfo = null;
            int n = nworkIdList.size();
            for (int index = 0; index < n; ++index) {
                mbgWorkFormInfo = MbgWorkPaperFactory.getLocalInstance(ctx).getMbgWorkPaperInfo((IObjectPK)new ObjectUuidPK((String)nworkIdList.get(index)), _sic);
                if (1 != mbgWorkFormInfo.getState().getValue()) {
                    errorMap.put(nworkIdList.get(index), new String[]{mbgWorkFormInfo.getNumber(), mbgWorkFormInfo.getName()});
                    continue;
                }
                pk = new ObjectStringPK((String)nworkIdList.get(index));
                MbgWorkPaperFactory.getLocalInstance(ctx).delete((IObjectPK)pk);
            }
        }
        List cslIdList = new ArrayList();
        cslIdList = (List)idMap.get("bgcslForm");
        if (cslIdList != null) {
            BgCslFormInfo bgcslFormInfo = null;
            int n = cslIdList.size();
            for (int index = 0; index < n; ++index) {
                bgcslFormInfo = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormInfo((IObjectPK)new ObjectUuidPK((String)cslIdList.get(index)), _sic);
                if (1 != bgcslFormInfo.getState().getValue()) {
                    errorMap.put(cslIdList.get(index), new String[]{bgcslFormInfo.getNumber(), bgcslFormInfo.getName()});
                    continue;
                }
                pk = new ObjectStringPK((String)cslIdList.get(index));
                BgCslFormFactory.getLocalInstance(ctx).delete((IObjectPK)pk);
            }
        }
        return errorMap;
    }

    @Override
    protected void _saveCaculateData(Context ctx, String userId, String schemeId, Map idMap) throws EASBizException, BOSException {
        BOSUuid curOrgUnitId;
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)schemeId) || idMap.isEmpty()) {
            return;
        }
        Map tmplTypeMap = new HashMap();
        int formType = 0;
        Map dataMaps = new HashMap();
        Book book = null;
        BOSUuid unionId = null;
        String adjType = "csladjtemplate";
        String workType = "worktemplate";
        String cslType = "csltemplate";
        MbgViewListManager manager = null;
        ArrayList<MbgViewListDimensionManager> dimension = new ArrayList<MbgViewListDimensionManager>();
        HashMap<String, ArrayList<MbgViewListDimensionManager>> dimensionManagers = new HashMap<String, ArrayList<MbgViewListDimensionManager>>();
        if (idMap.get(adjType) != null) {
            String adjFormId = null;
            IDimDataQuery adjFormInfo = null;
            tmplTypeMap = (Map)idMap.get(adjType);
            for (Map.Entry entry : tmplTypeMap.entrySet()) {
                adjFormId = ((String)entry.getKey()).toString();
                adjFormInfo = this.getEachFormInfo(adjFormId, ctx, adjType);
                if (1 != adjFormInfo.getBizState()) continue;
                try {
                    book = ((BgCslAdjFormInfo)adjFormInfo).getBook();
                    if (book == null) continue;
                    unionId = adjFormInfo.getBizUnionId();
                    dataMaps = BgCslAdjFormFactory.getLocalInstance(ctx).getBgDataInfo((BgCslAdjFormInfo)adjFormInfo, (IMbgViewBase)BgCslWorkTableFacadeControllerBean.getFormView(ctx, (BgCslAdjFormInfo)adjFormInfo));
                    if (dataMaps.isEmpty()) continue;
                    this.reFillValue(adjFormInfo, book, dataMaps);
                    this.calcBook(book, this.getAdjReportAdapter(adjFormId, adjFormInfo, ctx, adjType));
                    ((BgCslAdjFormInfo)adjFormInfo).setBook(book);
                    BgCslAdjFormFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectStringPK(adjFormId), (BgCslAdjFormInfo)adjFormInfo);
                }
                catch (Exception e) {
                    logger.error((Object)"caculate bgcslAdjForm error:", (Throwable)e);
                    throw new RuntimeException();
                }
            }
        }
        if (idMap.get(workType) != null) {
            IDimDataQuery workPaperInfo = null;
            String workFormId = null;
            curOrgUnitId = null;
            BOSUuid bgSchemeId = null;
            tmplTypeMap = (Map)idMap.get(workType);
            for (Map.Entry entry : tmplTypeMap.entrySet()) {
                workFormId = ((String)entry.getKey()).toString();
                workPaperInfo = this.getEachFormInfo(workFormId, ctx, workType);
                if (1 != workPaperInfo.getBizState()) continue;
                try {
                    manager = new MbgViewListXMLParser(ctx).parse(((MbgWorkPaperInfo)workPaperInfo).getDimensionData());
                }
                catch (Exception e) {
                    logger.error((Object)"caculate mbgWorkPaperForm error:", (Throwable)e);
                    throw new RuntimeException();
                }
                for (int i = 0; i < manager.getSheetManagers().size(); ++i) {
                    dimension.add(((MbgViewListSheetManager)manager.getSheetManagers().get(i)).getDimensionManager());
                }
                curOrgUnitId = workPaperInfo.getBizOrgUnit().getId();
                bgSchemeId = workPaperInfo.getBizBgScheme().getId();
                unionId = workPaperInfo.getBizUnionId();
                dimensionManagers.put(curOrgUnitId.toString(), dimension);
                dataMaps = MbgWorkPaperFacadeFactory.getLocalInstance(ctx).queryWorkData((IObjectValue)workPaperInfo, dimensionManagers, 64, false, curOrgUnitId);
                if (dataMaps.isEmpty()) continue;
                MbgWorkPaperFacadeFactory.getLocalInstance(ctx).saveMbgWorkData(BOSUuid.read((String)workFormId), bgSchemeId, unionId, BOSUuid.read((String)userId), dataMaps);
            }
        }
        if (idMap.get(cslType) != null) {
            IDimDataQuery bgCslFormInfo = null;
            String bgCslFormId = null;
            curOrgUnitId = null;
            tmplTypeMap = (Map)idMap.get(cslType);
            HashMap<String, String> org_formId = null;
            for (Map.Entry entry : tmplTypeMap.entrySet()) {
                formType = ((BgTemFormTypeEnum)entry.getValue()).getValue();
                bgCslFormId = ((String)entry.getKey()).toString();
                if (0 == formType || 8 == formType) {
                    bgCslFormInfo = this.getEachFormInfo(bgCslFormId, ctx, cslType);
                    if (1 != bgCslFormInfo.getBizState()) continue;
                    try {
                        book = ((BgCslFormInfo)bgCslFormInfo).getBook();
                        if (book == null || (dataMaps = BgCslFormFactory.getLocalInstance(ctx).getBgDataInfo((BgCslFormInfo)bgCslFormInfo, (IMbgViewBase)BgCslWorkTableFacadeControllerBean.getFormView(ctx, (BgCslFormInfo)bgCslFormInfo))).isEmpty()) continue;
                        this.reFillValue(bgCslFormInfo, book, dataMaps);
                        this.calcBook(book, this.getCslReportAdapter(bgCslFormId, bgCslFormInfo, ctx, cslType));
                        ((BgCslFormInfo)bgCslFormInfo).setBook(book);
                        BgCslFormFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectStringPK(bgCslFormId), (BgCslFormInfo)bgCslFormInfo);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"caculate bgcslForm error:", (Throwable)e);
                        throw new RuntimeException();
                    }
                }
                if (2 != formType) continue;
                bgCslFormInfo = this.getEachFormInfo(bgCslFormId, ctx, cslType);
                curOrgUnitId = bgCslFormInfo.getBizOrgUnit().getId();
                try {
                    manager = new MbgViewListXMLParser(ctx).parse(((BgCslFormInfo)bgCslFormInfo).getDimensionData());
                }
                catch (Exception e) {
                    logger.error((Object)"caculate bgcslViewListForm error:", (Throwable)e);
                    throw new RuntimeException();
                }
                for (int i = 0; i < manager.getSheetManagers().size(); ++i) {
                    dimension.add(((MbgViewListSheetManager)manager.getSheetManagers().get(i)).getDimensionManager());
                }
                dimensionManagers.put(curOrgUnitId.toString(), dimension);
                dataMaps = BgCslFormFactory.getLocalInstance(ctx).queryViewListData((BgCslFormInfo)bgCslFormInfo, dimensionManagers, 64, false);
                if (dataMaps.isEmpty()) continue;
                org_formId = new HashMap<String, String>();
                org_formId.put(bgCslFormInfo.getBizOrgUnit().getId().toString(), bgCslFormId);
                String orgId2 = null;
                BOSUuid bgSchemeId = BOSUuid.read((String)schemeId);
                BOSUuid userid = BOSUuid.read((String)userId);
                BOSUuid orgTreeId = ((BgCslFormInfo)bgCslFormInfo).getOrgTree().getId();
                HashMap<String, Map<String, IBgNData>> subMap = new HashMap<String, Map<String, IBgNData>>();
                try {
                    for (String orgId2 : dataMaps.keySet()) {
                        if (!org_formId.containsKey(orgId2)) continue;
                        subMap.clear();
                        subMap.put(orgId2, (Map<String, IBgNData>)dataMaps.get(orgId2));
                        UnionDataUtils.getIntance().saveIndvData(ctx, BOSUuid.read((String)((String)org_formId.get(orgId2))), bgSchemeId, orgTreeId, userid, subMap, null);
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    protected final IReportPropertyAdapter getAdjReportAdapter(String id, IDimDataQuery info, Context ctx, String type) throws EASBizException, BOSException {
        BgCslAdjRptReportPropertyAdapter adapter = new BgCslAdjRptReportPropertyAdapter((BgCslAdjFormInfo)this.getEachFormInfo(id, ctx, type));
        adapter.setOrgUnit(this.getOrgUnitInfo(info));
        return adapter;
    }

    protected final IReportPropertyAdapter getWorkReportAdapter(String id, IDimDataQuery info, Context ctx, String type) throws EASBizException, BOSException {
        MbgWorkRptReportPropertyAdapter adapter = new MbgWorkRptReportPropertyAdapter((MbgWorkPaperInfo)this.getEachFormInfo(id, ctx, type));
        adapter.setOrgUnit(this.getOrgUnitInfo(info));
        return adapter;
    }

    protected final IReportPropertyAdapter getCslReportAdapter(String id, IDimDataQuery info, Context ctx, String type) throws EASBizException, BOSException {
        BgCslRptReportPropertyAdapter adapter = new BgCslRptReportPropertyAdapter((BgCslFormInfo)this.getEachFormInfo(id, ctx, type));
        adapter.setOrgUnit(this.getOrgUnitInfo(info));
        return adapter;
    }

    protected FullOrgUnitInfo getOrgUnitInfo(IDimDataQuery info) {
        FullOrgUnitInfo orgInfo = info.getBizOrgUnit();
        orgInfo.setId(info.getBizOrgUnit().getId());
        orgInfo.setName(info.getName());
        orgInfo.setNumber(info.getNumber());
        return orgInfo;
    }

    public IDimDataQuery getEachFormInfo(String id, Context ctx, String type) throws EASBizException, BOSException {
        SelectorItemCollection _sic = new SelectorItemCollection();
        _sic.add("id");
        _sic.add("name");
        _sic.add("number");
        _sic.add("bgcsltemplate");
        _sic.add("state");
        _sic.add("bgPeriod.id");
        _sic.add("bgPeriod.number");
        _sic.add("bgPeriod.name");
        _sic.add("bgPeriod.periodType");
        _sic.add("bgVersion.id");
        _sic.add("bgVersion.number");
        _sic.add("bgVersion.name");
        _sic.add("bgVersion.versionId");
        _sic.add("currency.id");
        _sic.add("currency.number");
        _sic.add("currency.precision");
        _sic.add("currency.name");
        _sic.add("orgUnit.id");
        _sic.add("orgUnit.number");
        _sic.add("orgUnit.name");
        _sic.add("orgTree.id");
        _sic.add("bgScheme.id");
        _sic.add("bgScheme.number");
        _sic.add("bgScheme.name");
        _sic.add("bgScheme.dateFrom");
        _sic.add("bgScheme.dateTo");
        _sic.add("bgScheme.orgUnit.id");
        _sic.add("bgScheme.orgUnit.number");
        _sic.add("bgScheme.orgUnit.name");
        _sic.add("dimensionData");
        _sic.add("bgCslTemplate.formType");
        _sic.add("data");
        ReportBaseInfo eachFormInfo = null;
        if (type.equals("csladjtemplate")) {
            eachFormInfo = BgCslAdjFormFactory.getLocalInstance(ctx).getBgCslAdjFormInfo((IObjectPK)new ObjectUuidPK(id), _sic);
        } else if (type.equals("worktemplate")) {
            eachFormInfo = MbgWorkPaperFactory.getLocalInstance(ctx).getMbgWorkPaperInfo((IObjectPK)new ObjectUuidPK(id), _sic);
        } else if (type.equals("csltemplate")) {
            eachFormInfo = BgCslFormFactory.getLocalInstance(ctx).getBgCslFormInfo((IObjectPK)new ObjectUuidPK(id), _sic);
        }
        return eachFormInfo;
    }

    private void calcBook(Book _book, IReportPropertyAdapter _adapter) throws Exception {
        FormulaDefinition.registerFormulaToBook((Book)_book, (ICalculateContextProvider)new CalculateContext(_book, _adapter));
        boolean oldstate = _book.isAutoCalculate();
        _book.setCalculate(true);
        _book.calc();
        _book.setCalculate(oldstate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reFillValue(IDimDataQuery formInfo, Book book, Map dataMap) throws EASBizException, BOSException {
        BgNFSHelper.disableUndo((Book)book);
        BgNFSHelper.disableCal((Book)book);
        try {
            for (int s = 0; s < book.getSheetCount(); ++s) {
                Sheet sheet = book.getSheet(s);
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        Cell cell = sheet.getCell(r, c, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                        String _tmpStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                        BgNDataInfo _bgData = BgCslWorkTableFacadeControllerBean.getDimData(formInfo, dataMap, _tmpStr);
                        if (_bgData != null) {
                            BgNFSHelper.setValue((Cell)cell, (Object)_bgData.getBudgetValue());
                            continue;
                        }
                        BgNFSHelper.setValue((Cell)cell, (Object)cell);
                    }
                }
            }
        }
        finally {
            BgNFSHelper.enableCal((Book)book);
            BgNFSHelper.enableUndo((Book)book);
        }
    }

    private static BgNDataInfo getDimData(IDimDataQuery bgCslFormInfo, Map dataMap, String formulaStr) {
        String key = formulaStr + "_" + bgCslFormInfo.getBizVersion().getNumber();
        if (dataMap.containsKey(key)) {
            return (BgNDataInfo)dataMap.get(key);
        }
        return null;
    }

    private static IMbgViewManager getFormView(Context ctx, BgCslFormInfo bgCslFormInfo) throws Exception {
        if (bgCslFormInfo.getBgScheme() == null) {
            return null;
        }
        BgSchemeDimensionHelper schemeHelper = BgCslWorkTableFacadeControllerBean.getBgSchemeDimensionHelper(ctx, bgCslFormInfo);
        return BgCslFormHelper.getFormView(null, bgCslFormInfo, schemeHelper);
    }

    private static BgSchemeDimensionHelper getBgSchemeDimensionHelper(Context ctx, BgCslFormInfo bgCslFormInfo) throws EASBizException, BOSException {
        if (bgCslFormInfo.getBgScheme() == null) {
            return null;
        }
        return new BgSchemeDimensionHelper(ctx, bgCslFormInfo.getBgScheme().getId().toString());
    }

    private static IMbgViewManager getFormView(Context ctx, BgCslAdjFormInfo bgFormInfo) throws Exception {
        if (bgFormInfo.getBgScheme() == null) {
            return null;
        }
        BgSchemeDimensionHelper schemeHelper = BgCslWorkTableFacadeControllerBean.getBgSchemeDimensionHelper(ctx, bgFormInfo);
        return BgCslFormHelper.getFormView(null, bgFormInfo, schemeHelper);
    }

    private static BgSchemeDimensionHelper getBgSchemeDimensionHelper(Context ctx, BgCslAdjFormInfo bgFormInfo) throws EASBizException, BOSException {
        if (bgFormInfo.getBgScheme() == null) {
            return null;
        }
        return new BgSchemeDimensionHelper(ctx, bgFormInfo.getBgScheme().getId().toString());
    }
}

