/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslAdjTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgCslTemplateType;
import com.kingdee.eas.ma.bgcsl.BgExamineRefCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgExamineRefCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgExamineRefCslTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateFactory;
import com.kingdee.eas.ma.bgcsl.IBgExamineRefCslTemplate;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgExamineRefCslTemplateControllerBean;
import com.kingdee.eas.ma.bgcsl.utils.BgCslSchemeDimensionHelper;
import com.kingdee.eas.ma.biz.BizCalcException;
import com.kingdee.eas.ma.biz.app.utils.BizCalcServelHelper;
import com.kingdee.eas.ma.mbg.BgExamineCollection;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupInfo;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineParseException;
import com.kingdee.eas.ma.mbg.BgExamineStateEnum;
import com.kingdee.eas.ma.mbg.BgExamineSubsetFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgExamine;
import com.kingdee.eas.ma.mbg.IBgExamineGroup;
import com.kingdee.eas.ma.mbg.app.utils.BgExamineServelHelper;
import com.kingdee.eas.ma.mbg.parse.BgExamineFormulaVerifyHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExamineRefCslTemplateControllerBean
extends AbstractBgExamineRefCslTemplateControllerBean {
    private static final long serialVersionUID = 6438041667869729622L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgExamineRefCslTemplateControllerBean");

    @Override
    protected IObjectPK _saveCslExamine(Context ctx, IObjectValue bgExamineInfo) throws BOSException, EASBizException {
        IBgExamine iBgExamine = BgExamineFactory.getLocalInstance((Context)ctx);
        BgExamineInfo model = (BgExamineInfo)bgExamineInfo;
        IObjectPK pk = iBgExamine.submit((CoreBaseInfo)model);
        this.dealBgTemplate(ctx, (IObjectValue)model);
        return pk;
    }

    private void dealBgTemplate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int i;
        int n;
        BgExamineInfo currBgExamineInfo = (BgExamineInfo)model;
        BgNWorkTemplateCollection workTemplateColls = null;
        BgCslTemplateCollection cslTemplateColls = null;
        BgCslAdjTemplateCollection cslAdjTemplateColls = null;
        if (currBgExamineInfo.get("bgtemplate") instanceof BgCslTemplateCollection) {
            cslTemplateColls = (BgCslTemplateCollection)((Object)currBgExamineInfo.get("bgtemplate"));
        }
        if (currBgExamineInfo.get("bgcsladjtemplate") instanceof BgCslAdjTemplateCollection) {
            cslAdjTemplateColls = (BgCslAdjTemplateCollection)((Object)currBgExamineInfo.get("bgcsladjtemplate"));
        }
        if (currBgExamineInfo.get("WORKTEMPLATE_COLLECTION") instanceof BgNWorkTemplateCollection) {
            workTemplateColls = (BgNWorkTemplateCollection)((Object)currBgExamineInfo.get("WORKTEMPLATE_COLLECTION"));
        }
        IBgExamine IBgExamine2 = BgExamineFactory.getLocalInstance((Context)ctx);
        IBgExamineRefCslTemplate iBgExamineRef = BgExamineRefCslTemplateFactory.getLocalInstance(ctx);
        if (currBgExamineInfo.getId() != null && IBgExamine2.exists((IObjectPK)new ObjectUuidPK(currBgExamineInfo.getId()))) {
            iBgExamineRef.delete("where bgExamineID = '" + currBgExamineInfo.getId() + "'");
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        BgExamineRefCslTemplateInfo refBgTemplate = null;
        if (workTemplateColls != null && workTemplateColls.size() != 0) {
            n = workTemplateColls.size();
            for (i = 0; i < n; ++i) {
                refBgTemplate = new BgExamineRefCslTemplateInfo();
                refBgTemplate.setBgExamineID(currBgExamineInfo.getId());
                refBgTemplate.setTemplateID(workTemplateColls.get(i).getId());
                refBgTemplate.setType(BgCslTemplateType.WORKTEMPLATE);
                colls.add((CoreBaseInfo)refBgTemplate);
            }
        }
        if (cslTemplateColls != null && cslTemplateColls.size() != 0) {
            n = cslTemplateColls.size();
            for (i = 0; i < n; ++i) {
                refBgTemplate = new BgExamineRefCslTemplateInfo();
                refBgTemplate.setBgExamineID(currBgExamineInfo.getId());
                refBgTemplate.setTemplateID(cslTemplateColls.get(i).getId());
                refBgTemplate.setType(BgCslTemplateType.CSLTEMPLATE);
                colls.add((CoreBaseInfo)refBgTemplate);
            }
        }
        if (cslAdjTemplateColls != null && cslAdjTemplateColls.size() != 0) {
            n = cslAdjTemplateColls.size();
            for (i = 0; i < n; ++i) {
                refBgTemplate = new BgExamineRefCslTemplateInfo();
                refBgTemplate.setBgExamineID(currBgExamineInfo.getId());
                refBgTemplate.setTemplateID(cslAdjTemplateColls.get(i).getId());
                refBgTemplate.setType(BgCslTemplateType.CSLADJTEMPLATE);
                colls.add((CoreBaseInfo)refBgTemplate);
            }
        }
        if (!colls.isEmpty()) {
            iBgExamineRef.addnew(colls);
        }
    }

    @Override
    protected IObjectPK _copyAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._saveCslExamine(ctx, model);
    }

    @Override
    protected Map _getRefTemplateCollection(Context ctx, String bgExamineID) throws BOSException, EASBizException {
        FilterInfo filter;
        HashMap<String, AbstractObjectCollection> resultmap = new HashMap<String, AbstractObjectCollection>();
        if (ctx == null || StringUtils.isEmpty((String)bgExamineID)) {
            return resultmap;
        }
        IBgExamineRefCslTemplate iBgExamineRef = BgExamineRefCslTemplateFactory.getLocalInstance(ctx);
        BgExamineRefCslTemplateCollection colls = iBgExamineRef.getBgExamineRefCslTemplateCollection("where bgExamineID = '" + bgExamineID + "'");
        if (colls == null || colls.isEmpty()) {
            return resultmap;
        }
        BgExamineRefCslTemplateInfo info = null;
        HashSet<String> workTemplateIds = new HashSet<String>();
        HashSet<String> cslTemplateIds = new HashSet<String>();
        HashSet<String> cslAdjTemplateIds = new HashSet<String>();
        for (int index = 0; index < colls.size(); ++index) {
            info = colls.get(index);
            if (BgCslTemplateType.WORKTEMPLATE.equals((Object)info.getType())) {
                workTemplateIds.add(info.getTemplateID().toString());
                continue;
            }
            if (BgCslTemplateType.CSLTEMPLATE.equals((Object)info.getType())) {
                cslTemplateIds.add(info.getTemplateID().toString());
                continue;
            }
            if (!BgCslTemplateType.CSLADJTEMPLATE.equals((Object)info.getType())) continue;
            cslAdjTemplateIds.add(info.getTemplateID().toString());
        }
        if (!workTemplateIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(this.getSelector());
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", workTemplateIds, CompareType.INCLUDE));
            view.setFilter(filter);
            BgNWorkTemplateCollection workTemplateColls = BgNWorkTemplateFactory.getLocalInstance(ctx).getBgNWorkTemplateCollection(view);
            resultmap.put("WORKTEMPLATE_COLLECTION", workTemplateColls);
        }
        if (!cslTemplateIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(this.getSelector());
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", cslTemplateIds, CompareType.INCLUDE));
            view.setFilter(filter);
            BgCslTemplateCollection cslTemplateColls = BgCslTemplateFactory.getLocalInstance(ctx).getBgCslTemplateCollection(view);
            resultmap.put("bgtemplate", cslTemplateColls);
        }
        if (!cslAdjTemplateIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(this.getSelector());
            view.getSelector().add("orgUnit.id");
            view.getSelector().add("orgUnit.number");
            view.getSelector().add("orgUnit.name");
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", cslAdjTemplateIds, CompareType.INCLUDE));
            view.setFilter(filter);
            BgCslAdjTemplateCollection cslAdjTemplateColls = BgCslAdjTemplateFactory.getLocalInstance(ctx).getBgCslAdjTemplateCollection(view);
            resultmap.put("bgcsladjtemplate", cslAdjTemplateColls);
        }
        return resultmap;
    }

    @Override
    protected Map _getRefTemplates(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, Map> result = new HashMap<String, Map>();
        if (ctx == null || idSet == null || idSet.isEmpty()) {
            return result;
        }
        String bgExamineId2 = null;
        Map temMap = null;
        for (String bgExamineId2 : idSet) {
            temMap = this._getRefTemplateCollection(ctx, bgExamineId2);
            if (temMap.isEmpty()) continue;
            result.put(bgExamineId2, temMap);
        }
        return result;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        return selector;
    }

    @Override
    protected Map _cancelCancelColls(Context ctx, Set bgExamineIds, String bgSchemeId, String orgTreeId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (bgExamineIds == null || bgExamineIds.isEmpty() || StringUtils.isEmpty((String)bgSchemeId)) {
            return result;
        }
        BgExamineCollection examineInfoColls = this.getBgExamineCollectionByIds(ctx, bgSchemeId, bgExamineIds);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        HashSet<BgExamineInfo> examineInfoSet = new HashSet<BgExamineInfo>();
        HashMap<String, BgExamineInfo> tmpMap = new HashMap<String, BgExamineInfo>();
        BgExamineInfo tmpExamineInfo = null;
        for (int i = 0; i < examineInfoColls.size(); ++i) {
            tmpExamineInfo = examineInfoColls.get(i);
            if (tmpExamineInfo.getState().getValue() != 1) {
                tmpExamineInfo.setState(BgExamineStateEnum.SAVED);
                tmpMap.put(tmpExamineInfo.getNumber(), tmpExamineInfo);
                examineInfoSet.add(tmpExamineInfo);
                continue;
            }
            if (result.get("incorrectNumSet") == null) {
                HashSet<String> inCorrectStateSet = new HashSet<String>();
                result.put("incorrectNumSet", inCorrectStateSet);
                inCorrectStateSet.add(tmpExamineInfo.getNumber());
                continue;
            }
            ((Set)result.get("incorrectNumSet")).add(tmpExamineInfo.getNumber());
        }
        Map<String, String> verifyResultMsg = this.getVerifyResultMsgByExamineColls(ctx, examineInfoSet, bgSchemeId, orgTreeId);
        String calcNum2 = null;
        for (String calcNum2 : tmpMap.keySet()) {
            if (verifyResultMsg.containsKey(calcNum2)) continue;
            updateColls.add((CoreBaseInfo)tmpMap.get(calcNum2));
        }
        BgExamineServelHelper.addHist((Context)ctx, (CoreBaseCollection)updateColls, (boolean)false, (boolean)false);
        result.put("cancelFailCount", examineInfoColls.size() - updateColls.size());
        result.put("totalSize", examineInfoColls.size());
        result.put("verifyErrorMsg", this.combineAllKeysToStr(verifyResultMsg));
        if (!updateColls.isEmpty()) {
            BgExamineFactory.getLocalInstance((Context)ctx).updateBatchData(updateColls);
        }
        return result;
    }

    private Map<String, String> getVerifyResultMsgByExamineColls(Context ctx, Set<BgExamineInfo> examineInfoSet, String bgSchemeId, String orgTreeId) throws EASBizException, BOSException {
        Map<String, String> resultMap = new HashMap<String, String>();
        if (ctx == null || examineInfoSet == null || examineInfoSet.isEmpty() || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgTreeId)) {
            return resultMap;
        }
        OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
        orgTreeInfo.setId(BOSUuid.read((String)orgTreeId));
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId, orgTreeInfo);
        resultMap = BgExamineServelHelper.getVerifyResultMsgByExamineColls((Context)ctx, examineInfoSet, (BgSchemeDimensionHelper)schemeHelper);
        return resultMap;
    }

    private String combineAllKeysToStr(Map<String, String> verifyResultMsg) {
        if (verifyResultMsg.isEmpty()) {
            return null;
        }
        return BgExamineServelHelper.combineAllKeysToStr(verifyResultMsg);
    }

    private BgExamineCollection getBgExamineCollectionByIds(Context ctx, String bgSchemeId, Set bgExamineIds) throws BOSException {
        return BgExamineServelHelper.getBgExamineCollectionByIds((Context)ctx, (String)bgSchemeId, (Set)bgExamineIds);
    }

    @Override
    protected String _importBgExamine(Context ctx, String bgSchemeId, String orgUnitId, String orgTreeId, Map bgExamineMap, Map refBgTempMap, ErrorHandleModeEnum errorHandle) throws BOSException, EASBizException {
        if (bgExamineMap == null || bgExamineMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgTreeId)) {
            return null;
        }
        BgSchemeInfo bgScheme = new BgSchemeInfo();
        bgScheme.setId(BOSUuid.read((String)bgSchemeId));
        FullOrgUnitInfo orgUnit = null;
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            orgUnit = new FullOrgUnitInfo();
            orgUnit.setId(BOSUuid.read((String)orgUnitId));
        } else {
            orgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo();
        }
        OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
        orgTreeInfo.setId(BOSUuid.read((String)orgTreeId));
        Map _bgExamineMap = bgExamineMap;
        Map _refBgTempMap = refBgTempMap;
        Map _relyMap = bgExamineMap;
        BgExamineInfo bgExamineInfo2 = null;
        IBgExamine iBgExamine = BgExamineFactory.getLocalInstance((Context)ctx);
        HashSet<String> keys = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.setFilter(new FilterInfo());
        Iterator it = _bgExamineMap.values().iterator();
        while (it.hasNext()) {
            keys.add(((BgExamineInfo)it.next()).getNumber());
        }
        evi.getFilter().getFilterItems().clear();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", keys, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTreeId, CompareType.EQUALS));
        BgExamineCollection bgExamineCol = iBgExamine.getBgExamineCollection(evi);
        HashSet<String> hasBizNumber = new HashSet<String>();
        if (bgExamineCol != null && !bgExamineCol.isEmpty()) {
            for (int i = 0; i < bgExamineCol.size(); ++i) {
                hasBizNumber.add(bgExamineCol.get(i).getNumber());
            }
        }
        this.importRefTemplate(ctx, _bgExamineMap, bgExamineInfo2, _refBgTempMap, bgSchemeId, orgTreeId);
        BgCslSchemeDimensionHelper schemeHelper = new BgCslSchemeDimensionHelper(ctx, bgSchemeId, orgTreeInfo);
        LinkedHashMap bgExamineFormulaMap = new LinkedHashMap();
        LinkedHashMap bgScopeSrcMap = new LinkedHashMap();
        LinkedHashMap bgScopeMap = new LinkedHashMap();
        BgExamineFormulaVerifyHelper.buildParseParam(_bgExamineMap.values(), bgExamineFormulaMap, bgScopeSrcMap, bgScopeMap, (BgSchemeDimensionHelper)schemeHelper);
        BgExamineFormulaVerifyHelper formulaParser = new BgExamineFormulaVerifyHelper(bgExamineFormulaMap, bgScopeSrcMap, bgScopeMap, (BgSchemeDimensionHelper)schemeHelper, true);
        formulaParser.batchParse();
        HashSet<String> parseErrorNumber = new HashSet<String>();
        for (String number : formulaParser.getAllExceptions().keySet()) {
            Map subsetException = (Map)formulaParser.getAllExceptions().get(number);
            for (Map lineException : subsetException.values()) {
                if (lineException.isEmpty()) continue;
                parseErrorNumber.add(number);
            }
        }
        StringBuffer message = new StringBuffer();
        int success = 0;
        boolean hasFail = !hasBizNumber.isEmpty() || !parseErrorNumber.isEmpty();
        IBgExamineGroup iBgExamineGroup = BgExamineGroupFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection subSetCol = new CoreBaseCollection();
        for (BgExamineInfo bgExamineInfo2 : _bgExamineMap.values()) {
            if (hasBizNumber.contains(bgExamineInfo2.getNumber())) {
                message.append(new BizCalcException(BizCalcException.NUMBEREXISTS, new Object[]{bgExamineInfo2.getNumber()}).getMessage());
                message.append("\r\n");
                continue;
            }
            if (!bgExamineInfo2.getBgExamineGroup().getId().toString().equals("PCto8jovS9md/v3tQ45tMIdbVAE=") && !iBgExamineGroup.exists((IObjectPK)new ObjectUuidPK(bgExamineInfo2.getBgExamineGroup().getId()))) {
                if (iBgExamineGroup.exists("where number = '" + bgExamineInfo2.getBgExamineGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "'")) {
                    BgExamineGroupInfo group = iBgExamineGroup.getBgExamineGroupInfo("where number = '" + bgExamineInfo2.getBgExamineGroup().getNumber() + "' and bgScheme.id = '" + bgSchemeId + "' and isCsl = 1 ");
                    if (group != null) {
                        bgExamineInfo2.setBgExamineGroup(group);
                    }
                } else {
                    message.append(new BgExamineParseException(BgExamineParseException.BGEXAMINEGROUP_NOTEXIST, new Object[]{bgExamineInfo2.getNumber()}).getMessage());
                    message.append("\r\n");
                    continue;
                }
            }
            if (formulaParser.getAllExceptions().containsKey(bgExamineInfo2.getNumber())) {
                boolean hasException = false;
                Map subsetException = (Map)formulaParser.getAllExceptions().get(bgExamineInfo2.getNumber());
                for (String subsetName : subsetException.keySet()) {
                    Map lineException = (Map)subsetException.get(subsetName);
                    ArrayList keyList = new ArrayList(lineException.keySet());
                    Collections.sort(keyList);
                    for (Integer line : keyList) {
                        hasException = true;
                        List Exceptions = (List)lineException.get(line);
                        for (Exception exception : Exceptions) {
                            message.append(exception.getMessage()).append("\r\n");
                        }
                    }
                }
                if (hasException) continue;
            }
            if (hasFail && ErrorHandleModeEnum.ReturnRightnow.equals((Object)errorHandle)) continue;
            ++success;
            subSetCol.addObjectCollection((IObjectCollection)bgExamineInfo2.getBgExamineSubset());
            bgExamineInfo2.setBgScheme(bgScheme);
            bgExamineInfo2.setOrgUnit(orgUnit);
            bgExamineInfo2.setOrgTree(orgTreeInfo);
            bgExamineInfo2.setVersion(bgExamineInfo2.getVersion() == null ? BizCalcServelHelper.DEFAULT_VERSION : bgExamineInfo2.getVersion());
            this._saveCslExamine(ctx, (IObjectValue)bgExamineInfo2);
            BgExamineSubsetFactory.getLocalInstance((Context)ctx).saveBatchData(subSetCol);
        }
        if (message.length() != 0) {
            message.insert(0, new BizCalcException(BizCalcException.IMPORTFAIL, new Object[]{_bgExamineMap.size() - success}).getMessage() + "\r\n");
            message.insert(0, new BizCalcException(BizCalcException.IMPORTSUCCESS, new Object[]{success}).getMessage() + "\r\n");
        }
        return message.toString();
    }

    private void importRefTemplate(Context ctx, Map bgExamineMap, BgExamineInfo bgExamineInfo2, Map<String, Map<String, IObjectCollection>> refTempMap, String bgSchemeId, String orgTreeId) throws BOSException {
        if (ctx == null || bgExamineMap.isEmpty() || refTempMap.isEmpty() || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgTreeId)) {
            return;
        }
        for (BgExamineInfo bgExamineInfo2 : bgExamineMap.values()) {
            AbstractObjectCollection temColls;
            if (bgExamineInfo2 == null || bgExamineInfo2.getId() == null || !refTempMap.containsKey(bgExamineInfo2.getId().toString())) continue;
            BgNWorkTemplateCollection workTemplateColls = (BgNWorkTemplateCollection)refTempMap.get(bgExamineInfo2.getId().toString()).get("WORKTEMPLATE_COLLECTION");
            BgCslTemplateCollection cslTemplateColls = (BgCslTemplateCollection)refTempMap.get(bgExamineInfo2.getId().toString()).get("bgtemplate");
            BgCslAdjTemplateCollection cslAdjTemplateColls = (BgCslAdjTemplateCollection)refTempMap.get(bgExamineInfo2.getId().toString()).get("bgcsladjtemplate");
            HashSet<String> templateNumbers = new HashSet<String>();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("name");
            evi.getSelector().add("number");
            evi.setFilter(new FilterInfo());
            if (workTemplateColls != null && !workTemplateColls.isEmpty()) {
                templateNumbers.clear();
                for (int index = 0; index < workTemplateColls.size(); ++index) {
                    templateNumbers.add(workTemplateColls.get(index).getNumber());
                }
                evi.getFilter().getFilterItems().clear();
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTreeId, CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", templateNumbers, CompareType.INCLUDE));
                temColls = BgNWorkTemplateFactory.getLocalInstance(ctx).getBgNWorkTemplateCollection(evi);
                if (temColls != null && !temColls.isEmpty()) {
                    bgExamineInfo2.put("WORKTEMPLATE_COLLECTION", (Object)temColls);
                }
            }
            if (cslTemplateColls != null && !cslTemplateColls.isEmpty()) {
                templateNumbers.clear();
                for (int index = 0; index < cslTemplateColls.size(); ++index) {
                    templateNumbers.add(cslTemplateColls.get(index).getNumber());
                }
                evi.getFilter().getFilterItems().clear();
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTreeId, CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", templateNumbers, CompareType.INCLUDE));
                temColls = BgCslTemplateFactory.getLocalInstance(ctx).getBgCslTemplateCollection(evi);
                if (temColls != null && !temColls.isEmpty()) {
                    bgExamineInfo2.put("bgtemplate", (Object)temColls);
                }
            }
            if (cslAdjTemplateColls == null || cslAdjTemplateColls.isEmpty()) continue;
            templateNumbers.clear();
            for (int index = 0; index < cslAdjTemplateColls.size(); ++index) {
                templateNumbers.add(cslAdjTemplateColls.get(index).getNumber());
            }
            evi.getFilter().getFilterItems().clear();
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgTree.id", (Object)orgTreeId, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", templateNumbers, CompareType.INCLUDE));
            temColls = BgCslAdjTemplateFactory.getLocalInstance(ctx).getBgCslAdjTemplateCollection(evi);
            if (temColls == null || temColls.isEmpty()) continue;
            bgExamineInfo2.put("bgcsladjtemplate", (Object)temColls);
        }
    }
}

