/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateException;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkViewDimensionFactory;
import com.kingdee.eas.ma.bgcsl.BgNWorkViewDimensionInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperException;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgNWorkTemplateControllerBean;
import com.kingdee.eas.ma.bgcsl.utils.BgNWorkTemplateHelper;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.MbgViewListEditNoteInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNWorkTemplateControllerBean
extends AbstractBgNWorkTemplateControllerBean {
    private static final long serialVersionUID = 2501171352016512315L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgNWorkTemplateControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgNWorkTemplateInfo templateInfo = (BgNWorkTemplateInfo)model;
        if (templateInfo.getCU() == null) {
            templateInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        String number = templateInfo.getNumber();
        String orgTreeId = templateInfo.getOrgTree().getId().toString();
        number = templateInfo.getNumber();
        if (this._checkNumberDup(ctx, "", templateInfo.getBgScheme().getId().toString(), orgTreeId, number)) {
            logger.error((Object)("BgNWorkTemplate._addnew [orgUnitId:" + orgTreeId + " number:" + number + "]"));
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERDUP);
        }
        if (number.indexOf("(") >= 0 || number.indexOf(")") >= 0) {
            throw new BgNWorkTemplateException(BgNFormException.NUMBERERROR);
        }
        BgNWorkTemplateInfo coreInfo = templateInfo;
        Book book = null;
        if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
            try {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            }
            catch (IOException e) {
                throw new BgNWorkTemplateException(BgNWorkTemplateException.OPENBOOKFAIL, e);
            }
        }
        try {
            book = templateInfo.getBook();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            templateInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)coreInfo);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgNWorkTemplateInfo templateInfo = (BgNWorkTemplateInfo)model;
        if (templateInfo.getCU() == null) {
            templateInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        String number = templateInfo.getNumber();
        String orgTreeId = templateInfo.getOrgTree().getId().toString();
        if (this._checkNumberDup(ctx, "", templateInfo.getBgScheme().getId().toString(), orgTreeId, number)) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERDUP);
        }
        Book book = null;
        if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
            try {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            }
            catch (IOException e) {
                throw new BgNWorkTemplateException(BgNWorkTemplateException.OPENBOOKFAIL, e);
            }
        }
        try {
            book = templateInfo.getBook();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            templateInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK[] _addnewBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        for (int i = 0; i < colls.size(); ++i) {
            BgNWorkTemplateInfo bgTemplateInfo = (BgNWorkTemplateInfo)colls.getObject(i);
            this._addnew(ctx, (IObjectValue)bgTemplateInfo);
        }
        return null;
    }

    private Book createNewBook(Context ctx) {
        Book book = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        book = Book.Manager.getNewBook(null, (int)1);
        Sheet sheet = null;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
            BgNFSHelper.setSheetSign((Sheet)sheet);
        }
        return book;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgNWorkTemplateInfo templateInfo = (BgNWorkTemplateInfo)model;
        String number = templateInfo.getNumber();
        String id = pk.toString();
        String orgTreeId = templateInfo.getOrgTree().getId().toString();
        if (this._checkNumberDup(ctx, id, templateInfo.getBgScheme().getId().toString(), orgTreeId, number)) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERDUP);
        }
        Book book = null;
        try {
            if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            } else {
                book = templateInfo.getBook();
            }
        }
        catch (Exception e) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.OPENBOOKFAIL, e);
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        BgNWorkTemplateInfo _tmpInfo = new BgNWorkTemplateInfo();
        _tmpInfo.setId(templateInfo.getId());
        _tmpInfo.setName(templateInfo.getName());
        _tmpInfo.setNumber(templateInfo.getNumber());
        _tmpInfo.setDescription(templateInfo.getDescription());
        _tmpInfo.setBgScheme(templateInfo.getBgScheme());
        _tmpInfo.setOrgTree(templateInfo.getOrgTree());
        _tmpInfo.setStyleSet(templateInfo.getStyleSet());
        try {
            _tmpInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        super._update(ctx, pk, (IObjectValue)_tmpInfo);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        BgNWorkViewDimensionFactory.getLocalInstance(ctx).deleteDimension(pk.toString());
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        try {
            if (this._checkRefByForm(ctx, pk.toString())) {
                throw new CanNotDeleteException(new MbgWorkPaperException(MbgWorkPaperException.CANNOTDELETEBYFORM).getMessage());
            }
        }
        catch (CanNotDeleteException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    @Override
    protected void _clone(Context ctx, IObjectPK bgNWorkTemplatePK) throws BOSException, EASBizException {
        if (bgNWorkTemplatePK == null) {
            return;
        }
        SelectorItemCollection sic = BgNWorkTemplateHelper.getSelectors();
        BgNWorkTemplateInfo info = this.getBgNWorkTemplateInfo(ctx, bgNWorkTemplatePK, sic);
        BgNWorkTemplateInfo cloneInfo = info.deepClone();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null) {
            cloneInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            cloneInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        cloneInfo.setNumber("clone_" + cloneInfo.getNumber());
        cloneInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"clone", (Locale)ctx.getLocale()) + "_" + cloneInfo.getName());
        if (cloneInfo.getNumber().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERTOOLONG);
        }
        if (cloneInfo.getName().length() > 80) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NAMETOOLONG);
        }
        if (this._checkNumberDup(ctx, "", cloneInfo.getBgScheme().getId().toString(), cloneInfo.getOrgTree().getId().toString(), cloneInfo.getNumber())) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERDUP);
        }
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            Book book = cloneInfo.getBook();
            Sheet sheet = null;
            int n = book.getSheetCount();
            for (int i = 0; i < n; ++i) {
                sheet = book.getSheet(i);
                sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
                BgNFSHelper.setSheetSign((Sheet)sheet);
            }
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
            }
            catch (Exception e) {
                throw new BOSException(e.toString());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            cloneInfo.setData(IOHelper.packBook((Book)book));
        }
        catch (IOException e) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.OPENBOOKFAIL, e);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        BgNWorkViewDimensionInfo old = BgNWorkViewDimensionFactory.getLocalInstance(ctx).getBgNWorkViewDimensionInfo("where template.id = '" + bgNWorkTemplatePK + "'");
        old = (BgNWorkViewDimensionInfo)old.clone();
        old.setId(BOSUuid.create((BOSObjectType)old.getBOSType()));
        old.setTemplate(cloneInfo);
        IObjectPK pk = BgNWorkViewDimensionFactory.getLocalInstance(ctx).addNewView((IObjectValue)old, (IObjectValue)cloneInfo);
        if (pk != null) {
            MbgViewListDesCellFactory.getLocalInstance((Context)ctx).cloneFormTemplate(bgNWorkTemplatePK.toString(), pk.toString());
            DbUtil.execute((Context)ctx, (String)("Insert into T_MBG_MbgViewListEditNote(FID, FBgTemplateID, FSheetIndex, FValue) Select newbosid('" + new MbgViewListEditNoteInfo().getBOSType() + "'), ?, FSheetIndex, FValue FROM T_MBG_MbgViewListEditNote Where FBgTemplateID = ?"), (Object[])new Object[]{pk.toString(), bgNWorkTemplatePK.toString()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateDataInfo(Context ctx, IObjectValue templateInfo) throws BOSException, EASBizException {
        if (templateInfo == null) return;
        if (templateInfo.getString("id") == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_MBG_BgNWorkTemplate set FData = ? where FID = ?");
            byte[] bytes = templateInfo.getBytes("data");
            if (bytes != null && bytes.length > 0) {
                pstmt.setBinaryStream(1, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            } else {
                pstmt.setBytes(1, null);
            }
            pstmt.setString(2, templateInfo.getString("id"));
            pstmt.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _checkRefByForm(Context ctx, String templateID) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_MBG_MbgWorkPaper where FWorkTemplateID = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, templateID);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }

    @Override
    protected void _saveSimpleInfo(Context ctx, IObjectValue templateInfo) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        BgNWorkTemplateInfo bgTemInfo = (BgNWorkTemplateInfo)templateInfo;
        String id = bgTemInfo.getId().toString();
        String name = bgTemInfo.getName();
        String number = bgTemInfo.getNumber();
        String description = bgTemInfo.getDescription();
        String orgTreeId = bgTemInfo.getOrgTree().getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        if (this._checkNumberDup(ctx, id, bgTemInfo.getBgScheme().getId().toString(), orgTreeId, number)) {
            throw new BgNWorkTemplateException(BgNWorkTemplateException.NUMBERDUP);
        }
        sql.append(" update T_MBG_BgNWorkTemplate set fname = ? ,fnumber = ? , fdescription = ? , FLastUpdateTime= ? where fid = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, name);
            sm.setString(2, number);
            sm.setString(3, description);
            sm.setTimestamp(4, time);
            sm.setString(5, id);
            sm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
    }

    @Override
    protected boolean _checkNumberDup(Context ctx, String templateId, String bgSchemeId, String orgTreeId, String number) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select t1.fid from T_MBG_BgNWorkTemplate t1 where  t1.fnumber = ?  and t1.FBgSchemeId = ? and t1.FOrgTreeId = ? ");
            if (!StringUtils.isEmpty((String)templateId)) {
                sql.append(" and t1.fid <> ?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                sm.setString(2, bgSchemeId);
                sm.setString(3, orgTreeId);
                if (!StringUtils.isEmpty((String)templateId)) {
                    sm.setString(4, templateId);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    @Override
    protected List _getTemplateNumbers(Context ctx, String bgSchemeId, String orgTreeId) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String sql = "select FNumber from T_MBG_BgNWorkTemplate  where FBgSchemeID = ? AND FOrgTreeId = ?";
        conn = this.getConnection(ctx);
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bgSchemeId);
            pstmt.setString(2, orgTreeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                list.add(rst.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"getTemplateNumbers", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return list;
    }

    @Override
    protected void _cancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.doCancelOrNot(ctx, ids, true);
    }

    @Override
    protected void _cancelCancel(Context ctx, Set ids) throws BOSException, EASBizException {
        this.doCancelOrNot(ctx, ids, false);
    }

    protected void doCancelOrNot(Context ctx, Set ids, boolean isCancel) throws BOSException, EASBizException {
        if (ctx == null || ids == null || ids.isEmpty()) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgNWorkTemplate Set FTemplateStatus = " + (isCancel ? 10 : 0) + " Where FID = ?"), new ArrayList(ids));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

