/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bgcsl.BgNWorkTemplateInfo;
import com.kingdee.eas.ma.bgcsl.BgNWorkViewDimensionFactory;
import com.kingdee.eas.ma.bgcsl.BgNWorkViewDimensionInfo;
import com.kingdee.eas.ma.bgcsl.app.AbstractBgNWorkTemplateFacadeControllerBean;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgNWorkTemplateFacadeControllerBean
extends AbstractBgNWorkTemplateFacadeControllerBean {
    private static final long serialVersionUID = -8809465561250201473L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.bgcsl.app.BgNWorkTemplateFacadeControllerBean");

    @Override
    protected Map _initTemplateData(Context ctx, BgNWorkTemplateInfo bgTemplateInfo, TemplateStyleInfo templateStyle, String orgId, String unitGroupId) throws BOSException, EASBizException {
        IObjectValue obj = BgNWorkViewDimensionFactory.getLocalInstance(ctx).getDimensionByTemplate(bgTemplateInfo.getId().toString());
        if (obj instanceof BgNWorkViewDimensionInfo) {
            byte[] bytes = ((BgNWorkViewDimensionInfo)obj).getData();
            try {
                String orgTreeId = null;
                if (bgTemplateInfo.getOrgTree() != null) {
                    orgTreeId = bgTemplateInfo.getOrgTree().getId().toString();
                }
                return this._initTemplateData(ctx, bgTemplateInfo.getBgScheme().getId(), templateStyle, new MbgViewListXMLParser(ctx).parse(bytes), orgId, unitGroupId, orgTreeId);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return new HashMap();
    }

    @Override
    protected Map _initTemplateData(Context ctx, BgNWorkTemplateInfo bgTemplateInfo, TemplateStyleInfo templateStyle, MbgViewListManager viewManager, String orgId, String unitGroupId) throws BOSException, EASBizException {
        String orgTreeId = null;
        if (bgTemplateInfo.getOrgTree() != null) {
            orgTreeId = bgTemplateInfo.getOrgTree().getId().toString();
        }
        return this._initTemplateData(ctx, bgTemplateInfo.getBgScheme().getId(), templateStyle, viewManager, orgId, unitGroupId, orgTreeId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getUnionCollection(Context ctx, BOSUuid orgTreeID) throws BOSException, EASBizException {
        ArrayList<OrgUnitInfo> unionList = new ArrayList<OrgUnitInfo>();
        if (orgTreeID == null) {
            return unionList;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        OrgUnitInfo unitInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select s.FUnitID, u.FName_" + ctx.getLocale() + ", u.FNumber, u.FLongNumber, s.FLevel, u.FIsLeaf from T_ORG_Structure s left join T_ORG_BaseUnit u on s.FUnitId = u.FID where s.FTreeId = ? and u.fisgrouping = 1 order by s.FLongNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgTreeID.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                unitInfo = new OrgUnitInfo();
                unitInfo.setId(BOSUuid.read((String)rst.getString("FUnitID")));
                unitInfo.setName(rst.getString("FName_" + ctx.getLocale()));
                unitInfo.setNumber(rst.getString("FNumber"));
                unitInfo.setLongNumber(rst.getString("FLongNumber"));
                unitInfo.setLevel(rst.getInt("FLevel"));
                unitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                unionList.add(unitInfo);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return unionList;
    }
}

